# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from typing import Any, Optional, TYPE_CHECKING, cast
from typing_extensions import Self

from azure.core.pipeline import policies
from azure.core.settings import settings
from azure.mgmt.core import ARMPipelineClient
from azure.mgmt.core.policies import ARMAutoResourceProviderRegistrationPolicy
from azure.mgmt.core.tools import get_arm_endpoints
from azure.profiles import KnownProfiles, ProfileDefinition
from azure.profiles.multiapiclient import MultiApiClientMixin

from ._configuration import ContainerRegistryManagementClientConfiguration
from ._utils.serialization import Deserializer, Serializer

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials import TokenCredential

class _SDKClient(object):
    def __init__(self, *args, **kwargs):
        """This is a fake class to support current implementation of MultiApiClientMixin."
        Will be removed in final version of multiapi azure-core based client
        """
        pass

class ContainerRegistryManagementClient(MultiApiClientMixin, _SDKClient):
    """ContainerRegistryManagementClient.

    This ready contains multiple API versions, to help you deal with all of the Azure clouds
    (Azure Stack, Azure Government, Azure China, etc.).
    By default, it uses the latest API version available on public Azure.
    For production, you should stick to a particular api-version and/or profile.
    The profile sets a mapping between an operation group and its API version.
    The api-version parameter sets the default API version if the operation
    group is not described in the profile.

    :param credential: Credential needed for the client to connect to Azure. Required.
    :type credential: ~azure.core.credentials.TokenCredential
    :param subscription_id: The ID of the target subscription. The value must be an UUID. Required.
    :type subscription_id: str
    :param api_version: API version to use if no profile is provided, or if missing in profile.
    :type api_version: str
    :param base_url: Service URL
    :type base_url: str
    :param profile: A profile definition, from KnownProfiles to dict.
    :type profile: azure.profiles.KnownProfiles
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no Retry-After header is present.
    """

    DEFAULT_API_VERSION = '2025-04-01'
    _PROFILE_TAG = "azure.mgmt.containerregistry.ContainerRegistryManagementClient"
    LATEST_PROFILE = ProfileDefinition({
        _PROFILE_TAG: {
            None: DEFAULT_API_VERSION,
            'agent_pools': '2025-03-01-preview',
            'archive_versions': '2025-03-01-preview',
            'archives': '2025-03-01-preview',
            'export_pipelines': '2025-03-01-preview',
            'import_pipelines': '2025-03-01-preview',
            'pipeline_runs': '2025-03-01-preview',
            'runs': '2025-03-01-preview',
            'task_runs': '2025-03-01-preview',
            'tasks': '2025-03-01-preview',
        }},
        _PROFILE_TAG + " latest"
    )

    def __init__(
        self,
        credential: "TokenCredential",
        subscription_id: str,
        api_version: Optional[str]=None,
        base_url: Optional[str] = None,
        profile: KnownProfiles=KnownProfiles.default,
        **kwargs: Any
    ):
        if api_version:
            kwargs.setdefault('api_version', api_version)
        _cloud = kwargs.pop("cloud_setting", None) or settings.current.azure_cloud  # type: ignore
        _endpoints = get_arm_endpoints(_cloud)
        if not base_url:
            base_url = _endpoints["resource_manager"]
        credential_scopes = kwargs.pop("credential_scopes", _endpoints["credential_scopes"])
        self._config = ContainerRegistryManagementClientConfiguration(credential, subscription_id, credential_scopes=credential_scopes, **kwargs)
        _policies = kwargs.pop("policies", None)
        if _policies is None:
            _policies = [
                policies.RequestIdPolicy(**kwargs),
                self._config.headers_policy,
                self._config.user_agent_policy,
                self._config.proxy_policy,
                policies.ContentDecodePolicy(**kwargs),
                ARMAutoResourceProviderRegistrationPolicy(),
                self._config.redirect_policy,
                self._config.retry_policy,
                self._config.authentication_policy,
                self._config.custom_hook_policy,
                self._config.logging_policy,
                policies.DistributedTracingPolicy(**kwargs),
                policies.SensitiveHeaderCleanupPolicy(**kwargs) if self._config.redirect_policy else None,
                self._config.http_logging_policy,
            ]
        self._client: ARMPipelineClient = ARMPipelineClient(base_url=cast(str, base_url), policies=_policies, **kwargs)
        super(ContainerRegistryManagementClient, self).__init__(
            api_version=api_version,
            profile=profile
        )

    @classmethod
    def _models_dict(cls, api_version):
        return {k: v for k, v in cls.models(api_version).__dict__.items() if isinstance(v, type)}

    @classmethod
    def models(cls, api_version=DEFAULT_API_VERSION):
        """Module depends on the API version:

           * 2019-05-01: :mod:`v2019_05_01.models<azure.mgmt.containerregistry.v2019_05_01.models>`
           * 2019-05-01-preview: :mod:`v2019_05_01_preview.models<azure.mgmt.containerregistry.v2019_05_01_preview.models>`
           * 2019-06-01-preview: :mod:`v2019_06_01_preview.models<azure.mgmt.containerregistry.v2019_06_01_preview.models>`
           * 2020-11-01-preview: :mod:`v2020_11_01_preview.models<azure.mgmt.containerregistry.v2020_11_01_preview.models>`
           * 2021-08-01-preview: :mod:`v2021_08_01_preview.models<azure.mgmt.containerregistry.v2021_08_01_preview.models>`
           * 2022-02-01-preview: :mod:`v2022_02_01_preview.models<azure.mgmt.containerregistry.v2022_02_01_preview.models>`
           * 2023-01-01-preview: :mod:`v2023_01_01_preview.models<azure.mgmt.containerregistry.v2023_01_01_preview.models>`
           * 2023-11-01-preview: :mod:`v2023_11_01_preview.models<azure.mgmt.containerregistry.v2023_11_01_preview.models>`
           * 2024-11-01-preview: :mod:`v2024_11_01_preview.models<azure.mgmt.containerregistry.v2024_11_01_preview.models>`
           * 2025-03-01-preview: :mod:`v2025_03_01_preview.models<azure.mgmt.containerregistry.v2025_03_01_preview.models>`
           * 2025-04-01: :mod:`v2025_04_01.models<azure.mgmt.containerregistry.v2025_04_01.models>`
        """
        if api_version == '2019-05-01':
            from .v2019_05_01 import models
            return models
        elif api_version == '2019-05-01-preview':
            from .v2019_05_01_preview import models
            return models
        elif api_version == '2019-06-01-preview':
            from .v2019_06_01_preview import models
            return models
        elif api_version == '2020-11-01-preview':
            from .v2020_11_01_preview import models
            return models
        elif api_version == '2021-08-01-preview':
            from .v2021_08_01_preview import models
            return models
        elif api_version == '2022-02-01-preview':
            from .v2022_02_01_preview import models
            return models
        elif api_version == '2023-01-01-preview':
            from .v2023_01_01_preview import models
            return models
        elif api_version == '2023-11-01-preview':
            from .v2023_11_01_preview import models
            return models
        elif api_version == '2024-11-01-preview':
            from .v2024_11_01_preview import models
            return models
        elif api_version == '2025-03-01-preview':
            from .v2025_03_01_preview import models
            return models
        elif api_version == '2025-04-01':
            from .v2025_04_01 import models
            return models
        raise ValueError("API version {} is not available".format(api_version))

    @property
    def agent_pools(self):
        """Instance depends on the API version:

           * 2019-06-01-preview: :class:`AgentPoolsOperations<azure.mgmt.containerregistry.v2019_06_01_preview.operations.AgentPoolsOperations>`
           * 2025-03-01-preview: :class:`AgentPoolsOperations<azure.mgmt.containerregistry.v2025_03_01_preview.operations.AgentPoolsOperations>`
        """
        api_version = self._get_api_version('agent_pools')
        if api_version == '2019-06-01-preview':
            from .v2019_06_01_preview.operations import AgentPoolsOperations as OperationClass
        elif api_version == '2025-03-01-preview':
            from .v2025_03_01_preview.operations import AgentPoolsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'agent_pools'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)), api_version)

    @property
    def archive_versions(self):
        """Instance depends on the API version:

           * 2023-11-01-preview: :class:`ArchiveVersionsOperations<azure.mgmt.containerregistry.v2023_11_01_preview.operations.ArchiveVersionsOperations>`
           * 2024-11-01-preview: :class:`ArchiveVersionsOperations<azure.mgmt.containerregistry.v2024_11_01_preview.operations.ArchiveVersionsOperations>`
           * 2025-03-01-preview: :class:`ArchiveVersionsOperations<azure.mgmt.containerregistry.v2025_03_01_preview.operations.ArchiveVersionsOperations>`
        """
        api_version = self._get_api_version('archive_versions')
        if api_version == '2023-11-01-preview':
            from .v2023_11_01_preview.operations import ArchiveVersionsOperations as OperationClass
        elif api_version == '2024-11-01-preview':
            from .v2024_11_01_preview.operations import ArchiveVersionsOperations as OperationClass
        elif api_version == '2025-03-01-preview':
            from .v2025_03_01_preview.operations import ArchiveVersionsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'archive_versions'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)), api_version)

    @property
    def archives(self):
        """Instance depends on the API version:

           * 2023-11-01-preview: :class:`ArchivesOperations<azure.mgmt.containerregistry.v2023_11_01_preview.operations.ArchivesOperations>`
           * 2024-11-01-preview: :class:`ArchivesOperations<azure.mgmt.containerregistry.v2024_11_01_preview.operations.ArchivesOperations>`
           * 2025-03-01-preview: :class:`ArchivesOperations<azure.mgmt.containerregistry.v2025_03_01_preview.operations.ArchivesOperations>`
        """
        api_version = self._get_api_version('archives')
        if api_version == '2023-11-01-preview':
            from .v2023_11_01_preview.operations import ArchivesOperations as OperationClass
        elif api_version == '2024-11-01-preview':
            from .v2024_11_01_preview.operations import ArchivesOperations as OperationClass
        elif api_version == '2025-03-01-preview':
            from .v2025_03_01_preview.operations import ArchivesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'archives'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)), api_version)

    @property
    def cache_rules(self):
        """Instance depends on the API version:

           * 2023-01-01-preview: :class:`CacheRulesOperations<azure.mgmt.containerregistry.v2023_01_01_preview.operations.CacheRulesOperations>`
           * 2023-11-01-preview: :class:`CacheRulesOperations<azure.mgmt.containerregistry.v2023_11_01_preview.operations.CacheRulesOperations>`
           * 2024-11-01-preview: :class:`CacheRulesOperations<azure.mgmt.containerregistry.v2024_11_01_preview.operations.CacheRulesOperations>`
           * 2025-03-01-preview: :class:`CacheRulesOperations<azure.mgmt.containerregistry.v2025_03_01_preview.operations.CacheRulesOperations>`
           * 2025-04-01: :class:`CacheRulesOperations<azure.mgmt.containerregistry.v2025_04_01.operations.CacheRulesOperations>`
        """
        api_version = self._get_api_version('cache_rules')
        if api_version == '2023-01-01-preview':
            from .v2023_01_01_preview.operations import CacheRulesOperations as OperationClass
        elif api_version == '2023-11-01-preview':
            from .v2023_11_01_preview.operations import CacheRulesOperations as OperationClass
        elif api_version == '2024-11-01-preview':
            from .v2024_11_01_preview.operations import CacheRulesOperations as OperationClass
        elif api_version == '2025-03-01-preview':
            from .v2025_03_01_preview.operations import CacheRulesOperations as OperationClass
        elif api_version == '2025-04-01':
            from .v2025_04_01.operations import CacheRulesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'cache_rules'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)), api_version)

    @property
    def connected_registries(self):
        """Instance depends on the API version:

           * 2020-11-01-preview: :class:`ConnectedRegistriesOperations<azure.mgmt.containerregistry.v2020_11_01_preview.operations.ConnectedRegistriesOperations>`
           * 2021-08-01-preview: :class:`ConnectedRegistriesOperations<azure.mgmt.containerregistry.v2021_08_01_preview.operations.ConnectedRegistriesOperations>`
           * 2022-02-01-preview: :class:`ConnectedRegistriesOperations<azure.mgmt.containerregistry.v2022_02_01_preview.operations.ConnectedRegistriesOperations>`
           * 2023-01-01-preview: :class:`ConnectedRegistriesOperations<azure.mgmt.containerregistry.v2023_01_01_preview.operations.ConnectedRegistriesOperations>`
           * 2023-11-01-preview: :class:`ConnectedRegistriesOperations<azure.mgmt.containerregistry.v2023_11_01_preview.operations.ConnectedRegistriesOperations>`
           * 2024-11-01-preview: :class:`ConnectedRegistriesOperations<azure.mgmt.containerregistry.v2024_11_01_preview.operations.ConnectedRegistriesOperations>`
           * 2025-03-01-preview: :class:`ConnectedRegistriesOperations<azure.mgmt.containerregistry.v2025_03_01_preview.operations.ConnectedRegistriesOperations>`
           * 2025-04-01: :class:`ConnectedRegistriesOperations<azure.mgmt.containerregistry.v2025_04_01.operations.ConnectedRegistriesOperations>`
        """
        api_version = self._get_api_version('connected_registries')
        if api_version == '2020-11-01-preview':
            from .v2020_11_01_preview.operations import ConnectedRegistriesOperations as OperationClass
        elif api_version == '2021-08-01-preview':
            from .v2021_08_01_preview.operations import ConnectedRegistriesOperations as OperationClass
        elif api_version == '2022-02-01-preview':
            from .v2022_02_01_preview.operations import ConnectedRegistriesOperations as OperationClass
        elif api_version == '2023-01-01-preview':
            from .v2023_01_01_preview.operations import ConnectedRegistriesOperations as OperationClass
        elif api_version == '2023-11-01-preview':
            from .v2023_11_01_preview.operations import ConnectedRegistriesOperations as OperationClass
        elif api_version == '2024-11-01-preview':
            from .v2024_11_01_preview.operations import ConnectedRegistriesOperations as OperationClass
        elif api_version == '2025-03-01-preview':
            from .v2025_03_01_preview.operations import ConnectedRegistriesOperations as OperationClass
        elif api_version == '2025-04-01':
            from .v2025_04_01.operations import ConnectedRegistriesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'connected_registries'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)), api_version)

    @property
    def credential_sets(self):
        """Instance depends on the API version:

           * 2023-01-01-preview: :class:`CredentialSetsOperations<azure.mgmt.containerregistry.v2023_01_01_preview.operations.CredentialSetsOperations>`
           * 2023-11-01-preview: :class:`CredentialSetsOperations<azure.mgmt.containerregistry.v2023_11_01_preview.operations.CredentialSetsOperations>`
           * 2024-11-01-preview: :class:`CredentialSetsOperations<azure.mgmt.containerregistry.v2024_11_01_preview.operations.CredentialSetsOperations>`
           * 2025-03-01-preview: :class:`CredentialSetsOperations<azure.mgmt.containerregistry.v2025_03_01_preview.operations.CredentialSetsOperations>`
           * 2025-04-01: :class:`CredentialSetsOperations<azure.mgmt.containerregistry.v2025_04_01.operations.CredentialSetsOperations>`
        """
        api_version = self._get_api_version('credential_sets')
        if api_version == '2023-01-01-preview':
            from .v2023_01_01_preview.operations import CredentialSetsOperations as OperationClass
        elif api_version == '2023-11-01-preview':
            from .v2023_11_01_preview.operations import CredentialSetsOperations as OperationClass
        elif api_version == '2024-11-01-preview':
            from .v2024_11_01_preview.operations import CredentialSetsOperations as OperationClass
        elif api_version == '2025-03-01-preview':
            from .v2025_03_01_preview.operations import CredentialSetsOperations as OperationClass
        elif api_version == '2025-04-01':
            from .v2025_04_01.operations import CredentialSetsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'credential_sets'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)), api_version)

    @property
    def export_pipelines(self):
        """Instance depends on the API version:

           * 2020-11-01-preview: :class:`ExportPipelinesOperations<azure.mgmt.containerregistry.v2020_11_01_preview.operations.ExportPipelinesOperations>`
           * 2021-08-01-preview: :class:`ExportPipelinesOperations<azure.mgmt.containerregistry.v2021_08_01_preview.operations.ExportPipelinesOperations>`
           * 2022-02-01-preview: :class:`ExportPipelinesOperations<azure.mgmt.containerregistry.v2022_02_01_preview.operations.ExportPipelinesOperations>`
           * 2023-01-01-preview: :class:`ExportPipelinesOperations<azure.mgmt.containerregistry.v2023_01_01_preview.operations.ExportPipelinesOperations>`
           * 2023-11-01-preview: :class:`ExportPipelinesOperations<azure.mgmt.containerregistry.v2023_11_01_preview.operations.ExportPipelinesOperations>`
           * 2024-11-01-preview: :class:`ExportPipelinesOperations<azure.mgmt.containerregistry.v2024_11_01_preview.operations.ExportPipelinesOperations>`
           * 2025-03-01-preview: :class:`ExportPipelinesOperations<azure.mgmt.containerregistry.v2025_03_01_preview.operations.ExportPipelinesOperations>`
        """
        api_version = self._get_api_version('export_pipelines')
        if api_version == '2020-11-01-preview':
            from .v2020_11_01_preview.operations import ExportPipelinesOperations as OperationClass
        elif api_version == '2021-08-01-preview':
            from .v2021_08_01_preview.operations import ExportPipelinesOperations as OperationClass
        elif api_version == '2022-02-01-preview':
            from .v2022_02_01_preview.operations import ExportPipelinesOperations as OperationClass
        elif api_version == '2023-01-01-preview':
            from .v2023_01_01_preview.operations import ExportPipelinesOperations as OperationClass
        elif api_version == '2023-11-01-preview':
            from .v2023_11_01_preview.operations import ExportPipelinesOperations as OperationClass
        elif api_version == '2024-11-01-preview':
            from .v2024_11_01_preview.operations import ExportPipelinesOperations as OperationClass
        elif api_version == '2025-03-01-preview':
            from .v2025_03_01_preview.operations import ExportPipelinesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'export_pipelines'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)), api_version)

    @property
    def import_pipelines(self):
        """Instance depends on the API version:

           * 2020-11-01-preview: :class:`ImportPipelinesOperations<azure.mgmt.containerregistry.v2020_11_01_preview.operations.ImportPipelinesOperations>`
           * 2021-08-01-preview: :class:`ImportPipelinesOperations<azure.mgmt.containerregistry.v2021_08_01_preview.operations.ImportPipelinesOperations>`
           * 2022-02-01-preview: :class:`ImportPipelinesOperations<azure.mgmt.containerregistry.v2022_02_01_preview.operations.ImportPipelinesOperations>`
           * 2023-01-01-preview: :class:`ImportPipelinesOperations<azure.mgmt.containerregistry.v2023_01_01_preview.operations.ImportPipelinesOperations>`
           * 2023-11-01-preview: :class:`ImportPipelinesOperations<azure.mgmt.containerregistry.v2023_11_01_preview.operations.ImportPipelinesOperations>`
           * 2024-11-01-preview: :class:`ImportPipelinesOperations<azure.mgmt.containerregistry.v2024_11_01_preview.operations.ImportPipelinesOperations>`
           * 2025-03-01-preview: :class:`ImportPipelinesOperations<azure.mgmt.containerregistry.v2025_03_01_preview.operations.ImportPipelinesOperations>`
        """
        api_version = self._get_api_version('import_pipelines')
        if api_version == '2020-11-01-preview':
            from .v2020_11_01_preview.operations import ImportPipelinesOperations as OperationClass
        elif api_version == '2021-08-01-preview':
            from .v2021_08_01_preview.operations import ImportPipelinesOperations as OperationClass
        elif api_version == '2022-02-01-preview':
            from .v2022_02_01_preview.operations import ImportPipelinesOperations as OperationClass
        elif api_version == '2023-01-01-preview':
            from .v2023_01_01_preview.operations import ImportPipelinesOperations as OperationClass
        elif api_version == '2023-11-01-preview':
            from .v2023_11_01_preview.operations import ImportPipelinesOperations as OperationClass
        elif api_version == '2024-11-01-preview':
            from .v2024_11_01_preview.operations import ImportPipelinesOperations as OperationClass
        elif api_version == '2025-03-01-preview':
            from .v2025_03_01_preview.operations import ImportPipelinesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'import_pipelines'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)), api_version)

    @property
    def operations(self):
        """Instance depends on the API version:

           * 2019-05-01: :class:`Operations<azure.mgmt.containerregistry.v2019_05_01.operations.Operations>`
           * 2020-11-01-preview: :class:`Operations<azure.mgmt.containerregistry.v2020_11_01_preview.operations.Operations>`
           * 2021-08-01-preview: :class:`Operations<azure.mgmt.containerregistry.v2021_08_01_preview.operations.Operations>`
           * 2022-02-01-preview: :class:`Operations<azure.mgmt.containerregistry.v2022_02_01_preview.operations.Operations>`
           * 2023-01-01-preview: :class:`Operations<azure.mgmt.containerregistry.v2023_01_01_preview.operations.Operations>`
           * 2023-11-01-preview: :class:`Operations<azure.mgmt.containerregistry.v2023_11_01_preview.operations.Operations>`
           * 2024-11-01-preview: :class:`Operations<azure.mgmt.containerregistry.v2024_11_01_preview.operations.Operations>`
           * 2025-03-01-preview: :class:`Operations<azure.mgmt.containerregistry.v2025_03_01_preview.operations.Operations>`
           * 2025-04-01: :class:`Operations<azure.mgmt.containerregistry.v2025_04_01.operations.Operations>`
        """
        api_version = self._get_api_version('operations')
        if api_version == '2019-05-01':
            from .v2019_05_01.operations import Operations as OperationClass
        elif api_version == '2020-11-01-preview':
            from .v2020_11_01_preview.operations import Operations as OperationClass
        elif api_version == '2021-08-01-preview':
            from .v2021_08_01_preview.operations import Operations as OperationClass
        elif api_version == '2022-02-01-preview':
            from .v2022_02_01_preview.operations import Operations as OperationClass
        elif api_version == '2023-01-01-preview':
            from .v2023_01_01_preview.operations import Operations as OperationClass
        elif api_version == '2023-11-01-preview':
            from .v2023_11_01_preview.operations import Operations as OperationClass
        elif api_version == '2024-11-01-preview':
            from .v2024_11_01_preview.operations import Operations as OperationClass
        elif api_version == '2025-03-01-preview':
            from .v2025_03_01_preview.operations import Operations as OperationClass
        elif api_version == '2025-04-01':
            from .v2025_04_01.operations import Operations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'operations'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)), api_version)

    @property
    def pipeline_runs(self):
        """Instance depends on the API version:

           * 2020-11-01-preview: :class:`PipelineRunsOperations<azure.mgmt.containerregistry.v2020_11_01_preview.operations.PipelineRunsOperations>`
           * 2021-08-01-preview: :class:`PipelineRunsOperations<azure.mgmt.containerregistry.v2021_08_01_preview.operations.PipelineRunsOperations>`
           * 2022-02-01-preview: :class:`PipelineRunsOperations<azure.mgmt.containerregistry.v2022_02_01_preview.operations.PipelineRunsOperations>`
           * 2023-01-01-preview: :class:`PipelineRunsOperations<azure.mgmt.containerregistry.v2023_01_01_preview.operations.PipelineRunsOperations>`
           * 2023-11-01-preview: :class:`PipelineRunsOperations<azure.mgmt.containerregistry.v2023_11_01_preview.operations.PipelineRunsOperations>`
           * 2024-11-01-preview: :class:`PipelineRunsOperations<azure.mgmt.containerregistry.v2024_11_01_preview.operations.PipelineRunsOperations>`
           * 2025-03-01-preview: :class:`PipelineRunsOperations<azure.mgmt.containerregistry.v2025_03_01_preview.operations.PipelineRunsOperations>`
        """
        api_version = self._get_api_version('pipeline_runs')
        if api_version == '2020-11-01-preview':
            from .v2020_11_01_preview.operations import PipelineRunsOperations as OperationClass
        elif api_version == '2021-08-01-preview':
            from .v2021_08_01_preview.operations import PipelineRunsOperations as OperationClass
        elif api_version == '2022-02-01-preview':
            from .v2022_02_01_preview.operations import PipelineRunsOperations as OperationClass
        elif api_version == '2023-01-01-preview':
            from .v2023_01_01_preview.operations import PipelineRunsOperations as OperationClass
        elif api_version == '2023-11-01-preview':
            from .v2023_11_01_preview.operations import PipelineRunsOperations as OperationClass
        elif api_version == '2024-11-01-preview':
            from .v2024_11_01_preview.operations import PipelineRunsOperations as OperationClass
        elif api_version == '2025-03-01-preview':
            from .v2025_03_01_preview.operations import PipelineRunsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'pipeline_runs'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)), api_version)

    @property
    def private_endpoint_connections(self):
        """Instance depends on the API version:

           * 2020-11-01-preview: :class:`PrivateEndpointConnectionsOperations<azure.mgmt.containerregistry.v2020_11_01_preview.operations.PrivateEndpointConnectionsOperations>`
           * 2021-08-01-preview: :class:`PrivateEndpointConnectionsOperations<azure.mgmt.containerregistry.v2021_08_01_preview.operations.PrivateEndpointConnectionsOperations>`
           * 2022-02-01-preview: :class:`PrivateEndpointConnectionsOperations<azure.mgmt.containerregistry.v2022_02_01_preview.operations.PrivateEndpointConnectionsOperations>`
           * 2023-01-01-preview: :class:`PrivateEndpointConnectionsOperations<azure.mgmt.containerregistry.v2023_01_01_preview.operations.PrivateEndpointConnectionsOperations>`
           * 2023-11-01-preview: :class:`PrivateEndpointConnectionsOperations<azure.mgmt.containerregistry.v2023_11_01_preview.operations.PrivateEndpointConnectionsOperations>`
           * 2024-11-01-preview: :class:`PrivateEndpointConnectionsOperations<azure.mgmt.containerregistry.v2024_11_01_preview.operations.PrivateEndpointConnectionsOperations>`
           * 2025-03-01-preview: :class:`PrivateEndpointConnectionsOperations<azure.mgmt.containerregistry.v2025_03_01_preview.operations.PrivateEndpointConnectionsOperations>`
           * 2025-04-01: :class:`PrivateEndpointConnectionsOperations<azure.mgmt.containerregistry.v2025_04_01.operations.PrivateEndpointConnectionsOperations>`
        """
        api_version = self._get_api_version('private_endpoint_connections')
        if api_version == '2020-11-01-preview':
            from .v2020_11_01_preview.operations import PrivateEndpointConnectionsOperations as OperationClass
        elif api_version == '2021-08-01-preview':
            from .v2021_08_01_preview.operations import PrivateEndpointConnectionsOperations as OperationClass
        elif api_version == '2022-02-01-preview':
            from .v2022_02_01_preview.operations import PrivateEndpointConnectionsOperations as OperationClass
        elif api_version == '2023-01-01-preview':
            from .v2023_01_01_preview.operations import PrivateEndpointConnectionsOperations as OperationClass
        elif api_version == '2023-11-01-preview':
            from .v2023_11_01_preview.operations import PrivateEndpointConnectionsOperations as OperationClass
        elif api_version == '2024-11-01-preview':
            from .v2024_11_01_preview.operations import PrivateEndpointConnectionsOperations as OperationClass
        elif api_version == '2025-03-01-preview':
            from .v2025_03_01_preview.operations import PrivateEndpointConnectionsOperations as OperationClass
        elif api_version == '2025-04-01':
            from .v2025_04_01.operations import PrivateEndpointConnectionsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'private_endpoint_connections'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)), api_version)

    @property
    def registries(self):
        """Instance depends on the API version:

           * 2019-05-01: :class:`RegistriesOperations<azure.mgmt.containerregistry.v2019_05_01.operations.RegistriesOperations>`
           * 2019-05-01-preview: :class:`RegistriesOperations<azure.mgmt.containerregistry.v2019_05_01_preview.operations.RegistriesOperations>`
           * 2019-06-01-preview: :class:`RegistriesOperations<azure.mgmt.containerregistry.v2019_06_01_preview.operations.RegistriesOperations>`
           * 2020-11-01-preview: :class:`RegistriesOperations<azure.mgmt.containerregistry.v2020_11_01_preview.operations.RegistriesOperations>`
           * 2021-08-01-preview: :class:`RegistriesOperations<azure.mgmt.containerregistry.v2021_08_01_preview.operations.RegistriesOperations>`
           * 2022-02-01-preview: :class:`RegistriesOperations<azure.mgmt.containerregistry.v2022_02_01_preview.operations.RegistriesOperations>`
           * 2023-01-01-preview: :class:`RegistriesOperations<azure.mgmt.containerregistry.v2023_01_01_preview.operations.RegistriesOperations>`
           * 2023-11-01-preview: :class:`RegistriesOperations<azure.mgmt.containerregistry.v2023_11_01_preview.operations.RegistriesOperations>`
           * 2024-11-01-preview: :class:`RegistriesOperations<azure.mgmt.containerregistry.v2024_11_01_preview.operations.RegistriesOperations>`
           * 2025-03-01-preview: :class:`RegistriesOperations<azure.mgmt.containerregistry.v2025_03_01_preview.operations.RegistriesOperations>`
           * 2025-04-01: :class:`RegistriesOperations<azure.mgmt.containerregistry.v2025_04_01.operations.RegistriesOperations>`
        """
        api_version = self._get_api_version('registries')
        if api_version == '2019-05-01':
            from .v2019_05_01.operations import RegistriesOperations as OperationClass
        elif api_version == '2019-05-01-preview':
            from .v2019_05_01_preview.operations import RegistriesOperations as OperationClass
        elif api_version == '2019-06-01-preview':
            from .v2019_06_01_preview.operations import RegistriesOperations as OperationClass
        elif api_version == '2020-11-01-preview':
            from .v2020_11_01_preview.operations import RegistriesOperations as OperationClass
        elif api_version == '2021-08-01-preview':
            from .v2021_08_01_preview.operations import RegistriesOperations as OperationClass
        elif api_version == '2022-02-01-preview':
            from .v2022_02_01_preview.operations import RegistriesOperations as OperationClass
        elif api_version == '2023-01-01-preview':
            from .v2023_01_01_preview.operations import RegistriesOperations as OperationClass
        elif api_version == '2023-11-01-preview':
            from .v2023_11_01_preview.operations import RegistriesOperations as OperationClass
        elif api_version == '2024-11-01-preview':
            from .v2024_11_01_preview.operations import RegistriesOperations as OperationClass
        elif api_version == '2025-03-01-preview':
            from .v2025_03_01_preview.operations import RegistriesOperations as OperationClass
        elif api_version == '2025-04-01':
            from .v2025_04_01.operations import RegistriesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'registries'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)), api_version)

    @property
    def replications(self):
        """Instance depends on the API version:

           * 2019-05-01: :class:`ReplicationsOperations<azure.mgmt.containerregistry.v2019_05_01.operations.ReplicationsOperations>`
           * 2020-11-01-preview: :class:`ReplicationsOperations<azure.mgmt.containerregistry.v2020_11_01_preview.operations.ReplicationsOperations>`
           * 2021-08-01-preview: :class:`ReplicationsOperations<azure.mgmt.containerregistry.v2021_08_01_preview.operations.ReplicationsOperations>`
           * 2022-02-01-preview: :class:`ReplicationsOperations<azure.mgmt.containerregistry.v2022_02_01_preview.operations.ReplicationsOperations>`
           * 2023-01-01-preview: :class:`ReplicationsOperations<azure.mgmt.containerregistry.v2023_01_01_preview.operations.ReplicationsOperations>`
           * 2023-11-01-preview: :class:`ReplicationsOperations<azure.mgmt.containerregistry.v2023_11_01_preview.operations.ReplicationsOperations>`
           * 2024-11-01-preview: :class:`ReplicationsOperations<azure.mgmt.containerregistry.v2024_11_01_preview.operations.ReplicationsOperations>`
           * 2025-03-01-preview: :class:`ReplicationsOperations<azure.mgmt.containerregistry.v2025_03_01_preview.operations.ReplicationsOperations>`
           * 2025-04-01: :class:`ReplicationsOperations<azure.mgmt.containerregistry.v2025_04_01.operations.ReplicationsOperations>`
        """
        api_version = self._get_api_version('replications')
        if api_version == '2019-05-01':
            from .v2019_05_01.operations import ReplicationsOperations as OperationClass
        elif api_version == '2020-11-01-preview':
            from .v2020_11_01_preview.operations import ReplicationsOperations as OperationClass
        elif api_version == '2021-08-01-preview':
            from .v2021_08_01_preview.operations import ReplicationsOperations as OperationClass
        elif api_version == '2022-02-01-preview':
            from .v2022_02_01_preview.operations import ReplicationsOperations as OperationClass
        elif api_version == '2023-01-01-preview':
            from .v2023_01_01_preview.operations import ReplicationsOperations as OperationClass
        elif api_version == '2023-11-01-preview':
            from .v2023_11_01_preview.operations import ReplicationsOperations as OperationClass
        elif api_version == '2024-11-01-preview':
            from .v2024_11_01_preview.operations import ReplicationsOperations as OperationClass
        elif api_version == '2025-03-01-preview':
            from .v2025_03_01_preview.operations import ReplicationsOperations as OperationClass
        elif api_version == '2025-04-01':
            from .v2025_04_01.operations import ReplicationsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'replications'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)), api_version)

    @property
    def runs(self):
        """Instance depends on the API version:

           * 2019-06-01-preview: :class:`RunsOperations<azure.mgmt.containerregistry.v2019_06_01_preview.operations.RunsOperations>`
           * 2025-03-01-preview: :class:`RunsOperations<azure.mgmt.containerregistry.v2025_03_01_preview.operations.RunsOperations>`
        """
        api_version = self._get_api_version('runs')
        if api_version == '2019-06-01-preview':
            from .v2019_06_01_preview.operations import RunsOperations as OperationClass
        elif api_version == '2025-03-01-preview':
            from .v2025_03_01_preview.operations import RunsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'runs'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)), api_version)

    @property
    def scope_maps(self):
        """Instance depends on the API version:

           * 2019-05-01-preview: :class:`ScopeMapsOperations<azure.mgmt.containerregistry.v2019_05_01_preview.operations.ScopeMapsOperations>`
           * 2020-11-01-preview: :class:`ScopeMapsOperations<azure.mgmt.containerregistry.v2020_11_01_preview.operations.ScopeMapsOperations>`
           * 2021-08-01-preview: :class:`ScopeMapsOperations<azure.mgmt.containerregistry.v2021_08_01_preview.operations.ScopeMapsOperations>`
           * 2022-02-01-preview: :class:`ScopeMapsOperations<azure.mgmt.containerregistry.v2022_02_01_preview.operations.ScopeMapsOperations>`
           * 2023-01-01-preview: :class:`ScopeMapsOperations<azure.mgmt.containerregistry.v2023_01_01_preview.operations.ScopeMapsOperations>`
           * 2023-11-01-preview: :class:`ScopeMapsOperations<azure.mgmt.containerregistry.v2023_11_01_preview.operations.ScopeMapsOperations>`
           * 2024-11-01-preview: :class:`ScopeMapsOperations<azure.mgmt.containerregistry.v2024_11_01_preview.operations.ScopeMapsOperations>`
           * 2025-03-01-preview: :class:`ScopeMapsOperations<azure.mgmt.containerregistry.v2025_03_01_preview.operations.ScopeMapsOperations>`
           * 2025-04-01: :class:`ScopeMapsOperations<azure.mgmt.containerregistry.v2025_04_01.operations.ScopeMapsOperations>`
        """
        api_version = self._get_api_version('scope_maps')
        if api_version == '2019-05-01-preview':
            from .v2019_05_01_preview.operations import ScopeMapsOperations as OperationClass
        elif api_version == '2020-11-01-preview':
            from .v2020_11_01_preview.operations import ScopeMapsOperations as OperationClass
        elif api_version == '2021-08-01-preview':
            from .v2021_08_01_preview.operations import ScopeMapsOperations as OperationClass
        elif api_version == '2022-02-01-preview':
            from .v2022_02_01_preview.operations import ScopeMapsOperations as OperationClass
        elif api_version == '2023-01-01-preview':
            from .v2023_01_01_preview.operations import ScopeMapsOperations as OperationClass
        elif api_version == '2023-11-01-preview':
            from .v2023_11_01_preview.operations import ScopeMapsOperations as OperationClass
        elif api_version == '2024-11-01-preview':
            from .v2024_11_01_preview.operations import ScopeMapsOperations as OperationClass
        elif api_version == '2025-03-01-preview':
            from .v2025_03_01_preview.operations import ScopeMapsOperations as OperationClass
        elif api_version == '2025-04-01':
            from .v2025_04_01.operations import ScopeMapsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'scope_maps'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)), api_version)

    @property
    def task_runs(self):
        """Instance depends on the API version:

           * 2019-06-01-preview: :class:`TaskRunsOperations<azure.mgmt.containerregistry.v2019_06_01_preview.operations.TaskRunsOperations>`
           * 2025-03-01-preview: :class:`TaskRunsOperations<azure.mgmt.containerregistry.v2025_03_01_preview.operations.TaskRunsOperations>`
        """
        api_version = self._get_api_version('task_runs')
        if api_version == '2019-06-01-preview':
            from .v2019_06_01_preview.operations import TaskRunsOperations as OperationClass
        elif api_version == '2025-03-01-preview':
            from .v2025_03_01_preview.operations import TaskRunsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'task_runs'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)), api_version)

    @property
    def tasks(self):
        """Instance depends on the API version:

           * 2019-06-01-preview: :class:`TasksOperations<azure.mgmt.containerregistry.v2019_06_01_preview.operations.TasksOperations>`
           * 2025-03-01-preview: :class:`TasksOperations<azure.mgmt.containerregistry.v2025_03_01_preview.operations.TasksOperations>`
        """
        api_version = self._get_api_version('tasks')
        if api_version == '2019-06-01-preview':
            from .v2019_06_01_preview.operations import TasksOperations as OperationClass
        elif api_version == '2025-03-01-preview':
            from .v2025_03_01_preview.operations import TasksOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'tasks'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)), api_version)

    @property
    def tokens(self):
        """Instance depends on the API version:

           * 2019-05-01-preview: :class:`TokensOperations<azure.mgmt.containerregistry.v2019_05_01_preview.operations.TokensOperations>`
           * 2020-11-01-preview: :class:`TokensOperations<azure.mgmt.containerregistry.v2020_11_01_preview.operations.TokensOperations>`
           * 2021-08-01-preview: :class:`TokensOperations<azure.mgmt.containerregistry.v2021_08_01_preview.operations.TokensOperations>`
           * 2022-02-01-preview: :class:`TokensOperations<azure.mgmt.containerregistry.v2022_02_01_preview.operations.TokensOperations>`
           * 2023-01-01-preview: :class:`TokensOperations<azure.mgmt.containerregistry.v2023_01_01_preview.operations.TokensOperations>`
           * 2023-11-01-preview: :class:`TokensOperations<azure.mgmt.containerregistry.v2023_11_01_preview.operations.TokensOperations>`
           * 2024-11-01-preview: :class:`TokensOperations<azure.mgmt.containerregistry.v2024_11_01_preview.operations.TokensOperations>`
           * 2025-03-01-preview: :class:`TokensOperations<azure.mgmt.containerregistry.v2025_03_01_preview.operations.TokensOperations>`
           * 2025-04-01: :class:`TokensOperations<azure.mgmt.containerregistry.v2025_04_01.operations.TokensOperations>`
        """
        api_version = self._get_api_version('tokens')
        if api_version == '2019-05-01-preview':
            from .v2019_05_01_preview.operations import TokensOperations as OperationClass
        elif api_version == '2020-11-01-preview':
            from .v2020_11_01_preview.operations import TokensOperations as OperationClass
        elif api_version == '2021-08-01-preview':
            from .v2021_08_01_preview.operations import TokensOperations as OperationClass
        elif api_version == '2022-02-01-preview':
            from .v2022_02_01_preview.operations import TokensOperations as OperationClass
        elif api_version == '2023-01-01-preview':
            from .v2023_01_01_preview.operations import TokensOperations as OperationClass
        elif api_version == '2023-11-01-preview':
            from .v2023_11_01_preview.operations import TokensOperations as OperationClass
        elif api_version == '2024-11-01-preview':
            from .v2024_11_01_preview.operations import TokensOperations as OperationClass
        elif api_version == '2025-03-01-preview':
            from .v2025_03_01_preview.operations import TokensOperations as OperationClass
        elif api_version == '2025-04-01':
            from .v2025_04_01.operations import TokensOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'tokens'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)), api_version)

    @property
    def webhooks(self):
        """Instance depends on the API version:

           * 2019-05-01: :class:`WebhooksOperations<azure.mgmt.containerregistry.v2019_05_01.operations.WebhooksOperations>`
           * 2020-11-01-preview: :class:`WebhooksOperations<azure.mgmt.containerregistry.v2020_11_01_preview.operations.WebhooksOperations>`
           * 2021-08-01-preview: :class:`WebhooksOperations<azure.mgmt.containerregistry.v2021_08_01_preview.operations.WebhooksOperations>`
           * 2022-02-01-preview: :class:`WebhooksOperations<azure.mgmt.containerregistry.v2022_02_01_preview.operations.WebhooksOperations>`
           * 2023-01-01-preview: :class:`WebhooksOperations<azure.mgmt.containerregistry.v2023_01_01_preview.operations.WebhooksOperations>`
           * 2023-11-01-preview: :class:`WebhooksOperations<azure.mgmt.containerregistry.v2023_11_01_preview.operations.WebhooksOperations>`
           * 2024-11-01-preview: :class:`WebhooksOperations<azure.mgmt.containerregistry.v2024_11_01_preview.operations.WebhooksOperations>`
           * 2025-03-01-preview: :class:`WebhooksOperations<azure.mgmt.containerregistry.v2025_03_01_preview.operations.WebhooksOperations>`
           * 2025-04-01: :class:`WebhooksOperations<azure.mgmt.containerregistry.v2025_04_01.operations.WebhooksOperations>`
        """
        api_version = self._get_api_version('webhooks')
        if api_version == '2019-05-01':
            from .v2019_05_01.operations import WebhooksOperations as OperationClass
        elif api_version == '2020-11-01-preview':
            from .v2020_11_01_preview.operations import WebhooksOperations as OperationClass
        elif api_version == '2021-08-01-preview':
            from .v2021_08_01_preview.operations import WebhooksOperations as OperationClass
        elif api_version == '2022-02-01-preview':
            from .v2022_02_01_preview.operations import WebhooksOperations as OperationClass
        elif api_version == '2023-01-01-preview':
            from .v2023_01_01_preview.operations import WebhooksOperations as OperationClass
        elif api_version == '2023-11-01-preview':
            from .v2023_11_01_preview.operations import WebhooksOperations as OperationClass
        elif api_version == '2024-11-01-preview':
            from .v2024_11_01_preview.operations import WebhooksOperations as OperationClass
        elif api_version == '2025-03-01-preview':
            from .v2025_03_01_preview.operations import WebhooksOperations as OperationClass
        elif api_version == '2025-04-01':
            from .v2025_04_01.operations import WebhooksOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'webhooks'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)), api_version)

    def close(self):
        self._client.close()
    def __enter__(self):
        self._client.__enter__()
        return self
    def __exit__(self, *exc_details):
        self._client.__exit__(*exc_details)
