/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.descdiagram.command;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.GroupType;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.decoration.symbol.USymbols;
import net.sourceforge.plantuml.descdiagram.DescriptionDiagram;
import net.sourceforge.plantuml.klimt.color.ColorParser;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.font.FontParam;
import net.sourceforge.plantuml.plasma.Quark;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexOr;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.stereo.StereotypePattern;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandArchimatePackage
extends SingleLineCommand2<DescriptionDiagram> {
    public CommandArchimatePackage() {
        super(CommandArchimatePackage.getRegexConcat());
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandArchimatePackage.class.getName(), RegexLeaf.start(), new RegexLeaf("SYMBOL", "archimate"), RegexLeaf.spaceOneOrMore(), CommandArchimatePackage.color().getRegex(), RegexLeaf.spaceOneOrMore(), new RegexOr(new RegexLeaf("CODE1", "([%pLN_.]+|\\(\\)[%s]*[%pLN_.]+|\\(\\)[%s]*[%g][^%g]+[%g]|:[^:]+:/?|\\([^()]+\\)/?|\\[[^\\[\\]]+\\]|[%g].+?[%g])"), new RegexConcat(new RegexLeaf("DISPLAY2", "([%g].+?[%g]|:[^:]+:/?|\\([^()]+\\)/?|\\[[^\\[\\]]+\\])"), StereotypePattern.optionalArchimate("STEREOTYPE2"), new RegexLeaf("as"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("CODE2", "([%pLN_.]+|\\(\\)[%s]*[%pLN_.]+|\\(\\)[%s]*[%g][^%g]+[%g]|:[^:]+:/?|\\([^()]+\\)/?|\\[[^\\[\\]]+\\])")), new RegexConcat(new RegexLeaf("CODE3", "([%pLN_.]+|\\(\\)[%s]*[%pLN_.]+|\\(\\)[%s]*[%g][^%g]+[%g]|:[^:]+:/?|\\([^()]+\\)/?|\\[[^\\[\\]]+\\])"), StereotypePattern.optionalArchimate("STEREOTYPE3"), new RegexLeaf("as"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("DISPLAY3", "([%g].+?[%g]|:[^:]+:/?|\\([^()]+\\)/?|\\[[^\\[\\]]+\\])")), new RegexConcat(new RegexLeaf("DISPLAY4", "([%g].+?[%g]|:[^:]+:/?|\\([^()]+\\)/?|\\[[^\\[\\]]+\\]|[%pLN_.]+)"), StereotypePattern.optionalArchimate("STEREOTYPE4"), new RegexLeaf("as"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("CODE4", "([%pLN_.]+|\\(\\)[%s]*[%pLN_.]+|\\(\\)[%s]*[%g][^%g]+[%g]|:[^:]+:/?|\\([^()]+\\)/?|\\[[^\\[\\]]+\\])"))), StereotypePattern.optionalArchimate("STEREOTYPE"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("\\{"), RegexLeaf.end());
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    @Override
    protected CommandExecutionResult executeArg(DescriptionDiagram diagram, LineLocation location, RegexResult arg, ParserPass currentPass) throws NoSuchColorException {
        CommandExecutionResult status;
        String codeRaw = arg.getLazzy("CODE", 0);
        Quark<Entity> quark = diagram.quarkInContext(true, diagram.cleanId(codeRaw));
        String display = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.getLazzy("DISPLAY", 0));
        if (display == null) {
            display = quark.getName();
        }
        if (!(status = diagram.gotoGroup(location, quark, Display.getWithNewlines(diagram.getPragma(), display), GroupType.PACKAGE, USymbols.ARCHIMATE)).isOk()) {
            return status;
        }
        Entity p = diagram.getCurrentGroup();
        String icon = StereotypePattern.removeChevronBrackets(arg.getLazzy("STEREOTYPE", 0));
        p.setDisplay(Display.getWithNewlines(diagram.getPragma(), display));
        if (icon != null) {
            p.setStereotype(Stereotype.build("<<$archimate/" + icon + ">>", diagram.getSkinParam().getCircledCharacterRadius(), diagram.getSkinParam().getFont(null, false, FontParam.CIRCLED_CHARACTER), diagram.getSkinParam().getIHtmlColorSet()));
        }
        Colors colors = CommandArchimatePackage.color().getColor(arg, diagram.getSkinParam().getIHtmlColorSet());
        p.setColors(colors);
        return CommandExecutionResult.ok();
    }
}

