/* Generated by wayland-scanner 1.23.1 */

#ifndef COLOR_REPRESENTATION_V1_SERVER_PROTOCOL_H
#define COLOR_REPRESENTATION_V1_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_color_representation_v1 The color_representation_v1 protocol
 * color representation protocol extension
 *
 * @section page_desc_color_representation_v1 Description
 *
 * This protocol extension delivers the metadata required to define alpha mode,
 * the color model, sub-sampling and quantization range used when interpreting
 * buffer contents. The main use case is defining how the YCbCr family of pixel
 * formats convert to RGB.
 *
 * Note that this protocol does not define the colorimetry of the resulting RGB
 * channels / tristimulus values. Without the help of other extensions the
 * resulting colorimetry is therefore implementation defined.
 *
 * If this extension is not used, the color representation used is compositor
 * implementation defined.
 *
 * Recommendation ITU-T H.273
 * "Coding-independent code points for video signal type identification"
 * shall be referred to as simply H.273 here.
 *
 * @section page_ifaces_color_representation_v1 Interfaces
 * - @subpage page_iface_wp_color_representation_manager_v1 - color representation manager singleton
 * - @subpage page_iface_wp_color_representation_surface_v1 - color representation extension to a surface
 * @section page_copyright_color_representation_v1 Copyright
 * <pre>
 *
 * Copyright 2022 Simon Ser
 * Copyright 2022 Red Hat, Inc.
 * Copyright 2022 Collabora, Ltd.
 * Copyright 2022-2025 Red Hat, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct wl_surface;
struct wp_color_representation_manager_v1;
struct wp_color_representation_surface_v1;

#ifndef WP_COLOR_REPRESENTATION_MANAGER_V1_INTERFACE
#define WP_COLOR_REPRESENTATION_MANAGER_V1_INTERFACE
/**
 * @page page_iface_wp_color_representation_manager_v1 wp_color_representation_manager_v1
 * @section page_iface_wp_color_representation_manager_v1_desc Description
 *
 * A singleton global interface used for getting color representation
 * extensions for wl_surface. The extension interfaces allow setting the
 * color representation of surfaces.
 *
 * Compositors should never remove this global.
 * @section page_iface_wp_color_representation_manager_v1_api API
 * See @ref iface_wp_color_representation_manager_v1.
 */
/**
 * @defgroup iface_wp_color_representation_manager_v1 The wp_color_representation_manager_v1 interface
 *
 * A singleton global interface used for getting color representation
 * extensions for wl_surface. The extension interfaces allow setting the
 * color representation of surfaces.
 *
 * Compositors should never remove this global.
 */
extern const struct wl_interface wp_color_representation_manager_v1_interface;
#endif
#ifndef WP_COLOR_REPRESENTATION_SURFACE_V1_INTERFACE
#define WP_COLOR_REPRESENTATION_SURFACE_V1_INTERFACE
/**
 * @page page_iface_wp_color_representation_surface_v1 wp_color_representation_surface_v1
 * @section page_iface_wp_color_representation_surface_v1_desc Description
 *
 * A wp_color_representation_surface_v1 allows the client to set the color
 * representation metadata of a surface.
 *
 * By default, a surface does not have any color representation metadata set.
 * The reconstruction of R, G, B signals on such surfaces is compositor
 * implementation defined. The alpha mode is assumed to be
 * premultiplied_electrical when the alpha mode is unset.
 *
 * If the wl_surface associated with the wp_color_representation_surface_v1
 * is destroyed, the wp_color_representation_surface_v1 object becomes inert.
 * @section page_iface_wp_color_representation_surface_v1_api API
 * See @ref iface_wp_color_representation_surface_v1.
 */
/**
 * @defgroup iface_wp_color_representation_surface_v1 The wp_color_representation_surface_v1 interface
 *
 * A wp_color_representation_surface_v1 allows the client to set the color
 * representation metadata of a surface.
 *
 * By default, a surface does not have any color representation metadata set.
 * The reconstruction of R, G, B signals on such surfaces is compositor
 * implementation defined. The alpha mode is assumed to be
 * premultiplied_electrical when the alpha mode is unset.
 *
 * If the wl_surface associated with the wp_color_representation_surface_v1
 * is destroyed, the wp_color_representation_surface_v1 object becomes inert.
 */
extern const struct wl_interface wp_color_representation_surface_v1_interface;
#endif

#ifndef WP_COLOR_REPRESENTATION_MANAGER_V1_ERROR_ENUM
#define WP_COLOR_REPRESENTATION_MANAGER_V1_ERROR_ENUM
/**
 * @ingroup iface_wp_color_representation_manager_v1
 * protocol errors
 */
enum wp_color_representation_manager_v1_error {
	/**
	 * color representation surface exists already
	 */
	WP_COLOR_REPRESENTATION_MANAGER_V1_ERROR_SURFACE_EXISTS = 1,
};
/**
 * @ingroup iface_wp_color_representation_manager_v1
 * Validate a wp_color_representation_manager_v1 error value.
 *
 * @return true on success, false on error.
 * @ref wp_color_representation_manager_v1_error
 */
static inline bool
wp_color_representation_manager_v1_error_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case WP_COLOR_REPRESENTATION_MANAGER_V1_ERROR_SURFACE_EXISTS:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* WP_COLOR_REPRESENTATION_MANAGER_V1_ERROR_ENUM */

/**
 * @ingroup iface_wp_color_representation_manager_v1
 * @struct wp_color_representation_manager_v1_interface
 */
struct wp_color_representation_manager_v1_interface {
	/**
	 * destroy the manager
	 *
	 * Destroy the wp_color_representation_manager_v1 object. This
	 * does not affect any other objects in any way.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * create a color representation interface for a wl_surface
	 *
	 * If a wp_color_representation_surface_v1 object already exists
	 * for the given wl_surface, the protocol error surface_exists is
	 * raised.
	 *
	 * This creates a new color wp_color_representation_surface_v1
	 * object for the given wl_surface.
	 *
	 * See the wp_color_representation_surface_v1 interface for more
	 * details.
	 */
	void (*get_surface)(struct wl_client *client,
			    struct wl_resource *resource,
			    uint32_t id,
			    struct wl_resource *surface);
};

#define WP_COLOR_REPRESENTATION_MANAGER_V1_SUPPORTED_ALPHA_MODE 0
#define WP_COLOR_REPRESENTATION_MANAGER_V1_SUPPORTED_COEFFICIENTS_AND_RANGES 1
#define WP_COLOR_REPRESENTATION_MANAGER_V1_DONE 2

/**
 * @ingroup iface_wp_color_representation_manager_v1
 */
#define WP_COLOR_REPRESENTATION_MANAGER_V1_SUPPORTED_ALPHA_MODE_SINCE_VERSION 1
/**
 * @ingroup iface_wp_color_representation_manager_v1
 */
#define WP_COLOR_REPRESENTATION_MANAGER_V1_SUPPORTED_COEFFICIENTS_AND_RANGES_SINCE_VERSION 1
/**
 * @ingroup iface_wp_color_representation_manager_v1
 */
#define WP_COLOR_REPRESENTATION_MANAGER_V1_DONE_SINCE_VERSION 1

/**
 * @ingroup iface_wp_color_representation_manager_v1
 */
#define WP_COLOR_REPRESENTATION_MANAGER_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_wp_color_representation_manager_v1
 */
#define WP_COLOR_REPRESENTATION_MANAGER_V1_GET_SURFACE_SINCE_VERSION 1

/**
 * @ingroup iface_wp_color_representation_manager_v1
 * Sends an supported_alpha_mode event to the client owning the resource.
 * @param resource_ The client's resource
 * @param alpha_mode supported alpha mode
 */
static inline void
wp_color_representation_manager_v1_send_supported_alpha_mode(struct wl_resource *resource_, uint32_t alpha_mode)
{
	wl_resource_post_event(resource_, WP_COLOR_REPRESENTATION_MANAGER_V1_SUPPORTED_ALPHA_MODE, alpha_mode);
}

/**
 * @ingroup iface_wp_color_representation_manager_v1
 * Sends an supported_coefficients_and_ranges event to the client owning the resource.
 * @param resource_ The client's resource
 * @param coefficients supported matrix coefficients
 * @param range full range flag
 */
static inline void
wp_color_representation_manager_v1_send_supported_coefficients_and_ranges(struct wl_resource *resource_, uint32_t coefficients, uint32_t range)
{
	wl_resource_post_event(resource_, WP_COLOR_REPRESENTATION_MANAGER_V1_SUPPORTED_COEFFICIENTS_AND_RANGES, coefficients, range);
}

/**
 * @ingroup iface_wp_color_representation_manager_v1
 * Sends an done event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
wp_color_representation_manager_v1_send_done(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, WP_COLOR_REPRESENTATION_MANAGER_V1_DONE);
}

#ifndef WP_COLOR_REPRESENTATION_SURFACE_V1_ERROR_ENUM
#define WP_COLOR_REPRESENTATION_SURFACE_V1_ERROR_ENUM
/**
 * @ingroup iface_wp_color_representation_surface_v1
 * protocol errors
 */
enum wp_color_representation_surface_v1_error {
	/**
	 * unsupported alpha mode
	 */
	WP_COLOR_REPRESENTATION_SURFACE_V1_ERROR_ALPHA_MODE = 1,
	/**
	 * unsupported coefficients
	 */
	WP_COLOR_REPRESENTATION_SURFACE_V1_ERROR_COEFFICIENTS = 2,
	/**
	 * the pixel format and a set value are incompatible
	 */
	WP_COLOR_REPRESENTATION_SURFACE_V1_ERROR_PIXEL_FORMAT = 3,
	/**
	 * forbidden request on inert object
	 */
	WP_COLOR_REPRESENTATION_SURFACE_V1_ERROR_INERT = 4,
};
/**
 * @ingroup iface_wp_color_representation_surface_v1
 * Validate a wp_color_representation_surface_v1 error value.
 *
 * @return true on success, false on error.
 * @ref wp_color_representation_surface_v1_error
 */
static inline bool
wp_color_representation_surface_v1_error_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case WP_COLOR_REPRESENTATION_SURFACE_V1_ERROR_ALPHA_MODE:
		return version >= 1;
	case WP_COLOR_REPRESENTATION_SURFACE_V1_ERROR_COEFFICIENTS:
		return version >= 1;
	case WP_COLOR_REPRESENTATION_SURFACE_V1_ERROR_PIXEL_FORMAT:
		return version >= 1;
	case WP_COLOR_REPRESENTATION_SURFACE_V1_ERROR_INERT:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* WP_COLOR_REPRESENTATION_SURFACE_V1_ERROR_ENUM */

#ifndef WP_COLOR_REPRESENTATION_SURFACE_V1_ALPHA_MODE_ENUM
#define WP_COLOR_REPRESENTATION_SURFACE_V1_ALPHA_MODE_ENUM
/**
 * @ingroup iface_wp_color_representation_surface_v1
 * alpha mode
 *
 * Specifies how the alpha channel affects the color channels.
 */
enum wp_color_representation_surface_v1_alpha_mode {
	/**
	 * premultiplied alpha in electrical values
	 *
	 * Electrical color channel values (after transfer function
	 * encoding) are already multiplied with the alpha channel value.
	 */
	WP_COLOR_REPRESENTATION_SURFACE_V1_ALPHA_MODE_PREMULTIPLIED_ELECTRICAL = 0,
	/**
	 * premultiplied alpha in optical values
	 *
	 * Optical color channel values (before transfer function
	 * encoding) are already multiplied with the alpha channel value.
	 */
	WP_COLOR_REPRESENTATION_SURFACE_V1_ALPHA_MODE_PREMULTIPLIED_OPTICAL = 1,
	/**
	 * straight alpha
	 *
	 * Alpha channel has not been pre-multiplied into color channels.
	 */
	WP_COLOR_REPRESENTATION_SURFACE_V1_ALPHA_MODE_STRAIGHT = 2,
};
/**
 * @ingroup iface_wp_color_representation_surface_v1
 * Validate a wp_color_representation_surface_v1 alpha_mode value.
 *
 * @return true on success, false on error.
 * @ref wp_color_representation_surface_v1_alpha_mode
 */
static inline bool
wp_color_representation_surface_v1_alpha_mode_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case WP_COLOR_REPRESENTATION_SURFACE_V1_ALPHA_MODE_PREMULTIPLIED_ELECTRICAL:
		return version >= 1;
	case WP_COLOR_REPRESENTATION_SURFACE_V1_ALPHA_MODE_PREMULTIPLIED_OPTICAL:
		return version >= 1;
	case WP_COLOR_REPRESENTATION_SURFACE_V1_ALPHA_MODE_STRAIGHT:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* WP_COLOR_REPRESENTATION_SURFACE_V1_ALPHA_MODE_ENUM */

#ifndef WP_COLOR_REPRESENTATION_SURFACE_V1_COEFFICIENTS_ENUM
#define WP_COLOR_REPRESENTATION_SURFACE_V1_COEFFICIENTS_ENUM
/**
 * @ingroup iface_wp_color_representation_surface_v1
 * named coefficients
 *
 * Named matrix coefficients used to encode well-known sets of
 * coefficients. H.273 is the authority, when it comes to the exact values
 * of coefficients and authoritative specifications, where an equivalent
 * code point exists.
 *
 * A value of 0 is invalid and will never be present in the list of enums.
 *
 * Descriptions do list the specifications for convenience.
 */
enum wp_color_representation_surface_v1_coefficients {
	/**
	 * The identity matrix
	 *
	 * Coefficients as defined by - IEC 61966-2-1 sRGB - SMPTE ST
	 * 428-1 (2019)
	 *
	 * Equivalent to H.273 MatrixCoefficients code point 0. Compatible
	 * with pixel formats of the RGB family.
	 */
	WP_COLOR_REPRESENTATION_SURFACE_V1_COEFFICIENTS_IDENTITY = 1,
	/**
	 * BT.709 matrix coefficients
	 *
	 * Coefficients as defined by - Rec. ITU-R BT.709-6 - Rec. ITU-R
	 * BT.1361-0 conventional colour gamut system (historical) - Rec.
	 * ITU-R BT.1361-0 conventional colour gamut system and extended
	 * colour gamut system (historical) - IEC 61966-2-4 xvYCC709 -
	 * SMPTE RP 177 (1993) Annex B
	 *
	 * Equivalent to H.273 MatrixCoefficients code point 1. Compatible
	 * with pixel formats of the YCbCr family.
	 */
	WP_COLOR_REPRESENTATION_SURFACE_V1_COEFFICIENTS_BT709 = 2,
	/**
	 * FCC matrix coefficients
	 *
	 * Coefficients as defined by - United States Federal
	 * Communications Commission (2003) Title 47 Code of Federal
	 * Regulations 73.682 (a) (20)
	 *
	 * Equivalent to H.273 MatrixCoefficients code point 4. Compatible
	 * with pixel formats of the YCbCr family.
	 */
	WP_COLOR_REPRESENTATION_SURFACE_V1_COEFFICIENTS_FCC = 3,
	/**
	 * BT.601-7 matrix coefficients
	 *
	 * Coefficients as defined by - Rec. ITU-R BT.470-6 System B, G
	 * (historical) - Rec. ITU-R BT.601-7 625 - Rec. ITU-R BT.601-7 525
	 * - Rec. ITU-R BT.1358-0 625 (historical) - Rec. ITU-R BT.1358-1
	 * 525 or 625 (historical) - Rec. ITU-R BT.1700-0 625 PAL and 625
	 * SECAM - Rec. ITU-R BT.1700-0 NTSC - IEC 61966-2-1 sYCC - IEC
	 * 61966-2-4 xvYCC601 - SMPTE ST 170 (2004)
	 *
	 * Equivalent to H.273 MatrixCoefficients code point 5, 6.
	 * Compatible with pixel formats of the YCbCr family.
	 */
	WP_COLOR_REPRESENTATION_SURFACE_V1_COEFFICIENTS_BT601 = 4,
	/**
	 * SMPTE ST 240 matrix coefficients
	 *
	 * Coefficients as defined by - SMPTE ST 240 (1999)
	 *
	 * Equivalent to H.273 MatrixCoefficients code point 7. Compatible
	 * with pixel formats of the YCbCr family.
	 */
	WP_COLOR_REPRESENTATION_SURFACE_V1_COEFFICIENTS_SMPTE240 = 5,
	/**
	 * BT.2020 and BT.2100 YCbCr matrix coefficients
	 *
	 * Coefficients as defined by - Rec. ITU-R BT.2020-2
	 * (non-constant luminance) - Rec. ITU-R BT.2100-2 Y′CbCr
	 *
	 * Equivalent to H.273 MatrixCoefficients code point 9. Compatible
	 * with pixel formats of the YCbCr family.
	 */
	WP_COLOR_REPRESENTATION_SURFACE_V1_COEFFICIENTS_BT2020 = 6,
	/**
	 * BT.2020 matrix coefficients for constant luminance
	 *
	 * Coefficients as defined by - Rec. ITU-R BT.2020-2 (constant
	 * luminance)
	 *
	 * Equivalent to H.273 MatrixCoefficients code point 10. Compatible
	 * with pixel formats of the YCbCr family.
	 */
	WP_COLOR_REPRESENTATION_SURFACE_V1_COEFFICIENTS_BT2020_CL = 7,
	/**
	 * BT.2100 ICtCp matrix coefficients
	 *
	 * Coefficients as defined by - Rec. ITU-R BT.2100-2 ICTCP
	 *
	 * Equivalent to H.273 MatrixCoefficients code point 14. Compatible
	 * with pixel formats of the YCbCr family.
	 */
	WP_COLOR_REPRESENTATION_SURFACE_V1_COEFFICIENTS_ICTCP = 8,
};
/**
 * @ingroup iface_wp_color_representation_surface_v1
 * Validate a wp_color_representation_surface_v1 coefficients value.
 *
 * @return true on success, false on error.
 * @ref wp_color_representation_surface_v1_coefficients
 */
static inline bool
wp_color_representation_surface_v1_coefficients_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case WP_COLOR_REPRESENTATION_SURFACE_V1_COEFFICIENTS_IDENTITY:
		return version >= 1;
	case WP_COLOR_REPRESENTATION_SURFACE_V1_COEFFICIENTS_BT709:
		return version >= 1;
	case WP_COLOR_REPRESENTATION_SURFACE_V1_COEFFICIENTS_FCC:
		return version >= 1;
	case WP_COLOR_REPRESENTATION_SURFACE_V1_COEFFICIENTS_BT601:
		return version >= 1;
	case WP_COLOR_REPRESENTATION_SURFACE_V1_COEFFICIENTS_SMPTE240:
		return version >= 1;
	case WP_COLOR_REPRESENTATION_SURFACE_V1_COEFFICIENTS_BT2020:
		return version >= 1;
	case WP_COLOR_REPRESENTATION_SURFACE_V1_COEFFICIENTS_BT2020_CL:
		return version >= 1;
	case WP_COLOR_REPRESENTATION_SURFACE_V1_COEFFICIENTS_ICTCP:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* WP_COLOR_REPRESENTATION_SURFACE_V1_COEFFICIENTS_ENUM */

#ifndef WP_COLOR_REPRESENTATION_SURFACE_V1_RANGE_ENUM
#define WP_COLOR_REPRESENTATION_SURFACE_V1_RANGE_ENUM
/**
 * @ingroup iface_wp_color_representation_surface_v1
 * Color range values
 *
 * Possible color range values.
 *
 * A value of 0 is invalid and will never be present in the list of enums.
 */
enum wp_color_representation_surface_v1_range {
	/**
	 * Full color range
	 */
	WP_COLOR_REPRESENTATION_SURFACE_V1_RANGE_FULL = 1,
	/**
	 * Limited color range
	 */
	WP_COLOR_REPRESENTATION_SURFACE_V1_RANGE_LIMITED = 2,
};
/**
 * @ingroup iface_wp_color_representation_surface_v1
 * Validate a wp_color_representation_surface_v1 range value.
 *
 * @return true on success, false on error.
 * @ref wp_color_representation_surface_v1_range
 */
static inline bool
wp_color_representation_surface_v1_range_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case WP_COLOR_REPRESENTATION_SURFACE_V1_RANGE_FULL:
		return version >= 1;
	case WP_COLOR_REPRESENTATION_SURFACE_V1_RANGE_LIMITED:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* WP_COLOR_REPRESENTATION_SURFACE_V1_RANGE_ENUM */

#ifndef WP_COLOR_REPRESENTATION_SURFACE_V1_CHROMA_LOCATION_ENUM
#define WP_COLOR_REPRESENTATION_SURFACE_V1_CHROMA_LOCATION_ENUM
/**
 * @ingroup iface_wp_color_representation_surface_v1
 * Chroma sample location for 4:2:0 YCbCr
 *
 * Chroma sample location as defined by H.273 Chroma420SampleLocType.
 *
 * A value of 0 is invalid and will never be present in the list of enums.
 *
 * The descriptions list the matching Vulkan VkChromaLocation combinations
 * for convenience.
 */
enum wp_color_representation_surface_v1_chroma_location {
	/**
	 * Horizontal offset of 0, vertical offset of 0.5
	 *
	 * Corresponding to VkChromaLocations: - xChromaOffset:
	 * VK_CHROMA_LOCATION_COSITED_EVEN - yChromaOffset:
	 * VK_CHROMA_LOCATION_MIDPOINT
	 *
	 * Equivalent to H.273 Chroma420SampleLocType 0.
	 */
	WP_COLOR_REPRESENTATION_SURFACE_V1_CHROMA_LOCATION_TYPE_0 = 1,
	/**
	 * Horizontal offset of 0.5, vertical offset of 0.5
	 *
	 * Corresponding to VkChromaLocations: - xChromaOffset:
	 * VK_CHROMA_LOCATION_MIDPOINT - yChromaOffset:
	 * VK_CHROMA_LOCATION_MIDPOINT
	 *
	 * Equivalent to H.273 Chroma420SampleLocType 1.
	 */
	WP_COLOR_REPRESENTATION_SURFACE_V1_CHROMA_LOCATION_TYPE_1 = 2,
	/**
	 * Horizontal offset of 0, vertical offset of 0
	 *
	 * Corresponding to VkChromaLocations: - xChromaOffset:
	 * VK_CHROMA_LOCATION_COSITED_EVEN - yChromaOffset:
	 * VK_CHROMA_LOCATION_COSITED_EVEN
	 *
	 * Equivalent to H.273 Chroma420SampleLocType 2.
	 */
	WP_COLOR_REPRESENTATION_SURFACE_V1_CHROMA_LOCATION_TYPE_2 = 3,
	/**
	 * Horizontal offset of 0.5, vertical offset of 0
	 *
	 * Corresponding to VkChromaLocations: - xChromaOffset:
	 * VK_CHROMA_LOCATION_MIDPOINT - yChromaOffset:
	 * VK_CHROMA_LOCATION_COSITED_EVEN
	 *
	 * Equivalent to H.273 Chroma420SampleLocType 3.
	 */
	WP_COLOR_REPRESENTATION_SURFACE_V1_CHROMA_LOCATION_TYPE_3 = 4,
	/**
	 * Horizontal offset of 0, vertical offset of 1
	 *
	 * Equivalent to H.273 Chroma420SampleLocType 4.
	 */
	WP_COLOR_REPRESENTATION_SURFACE_V1_CHROMA_LOCATION_TYPE_4 = 5,
	/**
	 * Horizontal offset of 0.5, vertical offset of 1
	 *
	 * Equivalent to H.273 Chroma420SampleLocType 5.
	 */
	WP_COLOR_REPRESENTATION_SURFACE_V1_CHROMA_LOCATION_TYPE_5 = 6,
};
/**
 * @ingroup iface_wp_color_representation_surface_v1
 * Validate a wp_color_representation_surface_v1 chroma_location value.
 *
 * @return true on success, false on error.
 * @ref wp_color_representation_surface_v1_chroma_location
 */
static inline bool
wp_color_representation_surface_v1_chroma_location_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case WP_COLOR_REPRESENTATION_SURFACE_V1_CHROMA_LOCATION_TYPE_0:
		return version >= 1;
	case WP_COLOR_REPRESENTATION_SURFACE_V1_CHROMA_LOCATION_TYPE_1:
		return version >= 1;
	case WP_COLOR_REPRESENTATION_SURFACE_V1_CHROMA_LOCATION_TYPE_2:
		return version >= 1;
	case WP_COLOR_REPRESENTATION_SURFACE_V1_CHROMA_LOCATION_TYPE_3:
		return version >= 1;
	case WP_COLOR_REPRESENTATION_SURFACE_V1_CHROMA_LOCATION_TYPE_4:
		return version >= 1;
	case WP_COLOR_REPRESENTATION_SURFACE_V1_CHROMA_LOCATION_TYPE_5:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* WP_COLOR_REPRESENTATION_SURFACE_V1_CHROMA_LOCATION_ENUM */

/**
 * @ingroup iface_wp_color_representation_surface_v1
 * @struct wp_color_representation_surface_v1_interface
 */
struct wp_color_representation_surface_v1_interface {
	/**
	 * destroy the color representation
	 *
	 * Destroy the wp_color_representation_surface_v1 object.
	 *
	 * Destroying this object unsets all the color representation
	 * metadata from the surface. See the
	 * wp_color_representation_surface_v1 interface description for how
	 * a compositor handles a surface without color representation
	 * metadata. Unsetting is double-buffered state, see
	 * wl_surface.commit.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * set the surface alpha mode
	 *
	 * If this protocol object is inert, the protocol error inert is
	 * raised.
	 *
	 * Assuming an alpha channel exists, it is always linear. The alpha
	 * mode determines whether and how the color channels include
	 * pre-multiplied alpha. Using straight alpha might have
	 * performance benefits.
	 *
	 * Only alpha modes advertised by the compositor are allowed to be
	 * used as argument for this request. The "alpha_mode" protocol
	 * error is raised otherwise.
	 *
	 * Alpha mode is double buffered, see wl_surface.commit.
	 * @param alpha_mode alpha mode
	 */
	void (*set_alpha_mode)(struct wl_client *client,
			       struct wl_resource *resource,
			       uint32_t alpha_mode);
	/**
	 * set the matrix coefficients and range
	 *
	 * If this protocol object is inert, the protocol error inert is
	 * raised.
	 *
	 * Set the matrix coefficients and video range which defines the
	 * formula and the related constants used to derive red, green and
	 * blue signals. Usually coefficients correspond to
	 * MatrixCoefficients code points in H.273.
	 *
	 * Only combinations advertised by the compositor are allowed to be
	 * used as argument for this request. The "coefficients" protocol
	 * error is raised otherwise.
	 *
	 * A call to wl_surface.commit verifies that the pixel format and
	 * the coefficients-range combination in the committed surface
	 * contents are compatible, if contents exist. The "pixel_format"
	 * protocol error is raised otherwise.
	 *
	 * A pixel format is compatible with the coefficients-range
	 * combination if the related equations and conventions as defined
	 * in H.273 can produce the color channels (RGB or YCbCr) of the
	 * pixel format.
	 *
	 * For the definition of the supported combination, see the
	 * wp_color_representation_surface_v1::coefficients and
	 * wp_color_representation_surface_v1::range enums.
	 *
	 * The coefficients-range combination is double-buffered, see
	 * wl_surface.commit.
	 * @param coefficients matrix coefficients
	 * @param range range
	 */
	void (*set_coefficients_and_range)(struct wl_client *client,
					   struct wl_resource *resource,
					   uint32_t coefficients,
					   uint32_t range);
	/**
	 * set the chroma location
	 *
	 * If this protocol object is inert, the protocol error inert is
	 * raised.
	 *
	 * Set the chroma location type which defines the position of
	 * downsampled chroma samples, corresponding to
	 * Chroma420SampleLocType code points in H.273.
	 *
	 * A call to wl_surface.commit verifies that the pixel format and
	 * chroma location type in the committed surface contents are
	 * compatible, if contents exist. The "pixel_format" protocol error
	 * is raised otherwise.
	 *
	 * For the definition of the supported chroma location types, see
	 * the wp_color_representation_surface_v1::chroma_location enum.
	 *
	 * The chroma location type is double-buffered, see
	 * wl_surface.commit.
	 * @param chroma_location chroma sample location
	 */
	void (*set_chroma_location)(struct wl_client *client,
				    struct wl_resource *resource,
				    uint32_t chroma_location);
};


/**
 * @ingroup iface_wp_color_representation_surface_v1
 */
#define WP_COLOR_REPRESENTATION_SURFACE_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_wp_color_representation_surface_v1
 */
#define WP_COLOR_REPRESENTATION_SURFACE_V1_SET_ALPHA_MODE_SINCE_VERSION 1
/**
 * @ingroup iface_wp_color_representation_surface_v1
 */
#define WP_COLOR_REPRESENTATION_SURFACE_V1_SET_COEFFICIENTS_AND_RANGE_SINCE_VERSION 1
/**
 * @ingroup iface_wp_color_representation_surface_v1
 */
#define WP_COLOR_REPRESENTATION_SURFACE_V1_SET_CHROMA_LOCATION_SINCE_VERSION 1

#ifdef  __cplusplus
}
#endif

#endif
