# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_alpm_buildinfo_global_optspecs
	string join \n h/help V/version
end

function __fish_alpm_buildinfo_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_alpm_buildinfo_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_alpm_buildinfo_using_subcommand
	set -l cmd (__fish_alpm_buildinfo_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c alpm-buildinfo -n "__fish_alpm_buildinfo_needs_command" -s h -l help -d 'Print help'
complete -c alpm-buildinfo -n "__fish_alpm_buildinfo_needs_command" -s V -l version -d 'Print version'
complete -c alpm-buildinfo -n "__fish_alpm_buildinfo_needs_command" -f -a "create" -d 'Create a BUILDINFO file according to a schema'
complete -c alpm-buildinfo -n "__fish_alpm_buildinfo_needs_command" -f -a "validate" -d 'Validate a BUILDINFO file'
complete -c alpm-buildinfo -n "__fish_alpm_buildinfo_needs_command" -f -a "format" -d 'Parse a BUILDINFO file and output it in a different format'
complete -c alpm-buildinfo -n "__fish_alpm_buildinfo_needs_command" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c alpm-buildinfo -n "__fish_alpm_buildinfo_using_subcommand create; and not __fish_seen_subcommand_from v1 v2 help" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c alpm-buildinfo -n "__fish_alpm_buildinfo_using_subcommand create; and not __fish_seen_subcommand_from v1 v2 help" -f -a "v1" -d 'Create a BUILDINFO version 1 file'
complete -c alpm-buildinfo -n "__fish_alpm_buildinfo_using_subcommand create; and not __fish_seen_subcommand_from v1 v2 help" -f -a "v2" -d 'Create a BUILDINFO version 2 file'
complete -c alpm-buildinfo -n "__fish_alpm_buildinfo_using_subcommand create; and not __fish_seen_subcommand_from v1 v2 help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c alpm-buildinfo -n "__fish_alpm_buildinfo_using_subcommand create; and __fish_seen_subcommand_from v1" -l builddate -d 'Provide a builddate' -r
complete -c alpm-buildinfo -n "__fish_alpm_buildinfo_using_subcommand create; and __fish_seen_subcommand_from v1" -l builddir -d 'Provide a builddir' -r
complete -c alpm-buildinfo -n "__fish_alpm_buildinfo_using_subcommand create; and __fish_seen_subcommand_from v1" -l buildenv -d 'Provide one or more buildenv' -r
complete -c alpm-buildinfo -n "__fish_alpm_buildinfo_using_subcommand create; and __fish_seen_subcommand_from v1" -l installed -d 'Provide one or more installed' -r
complete -c alpm-buildinfo -n "__fish_alpm_buildinfo_using_subcommand create; and __fish_seen_subcommand_from v1" -l options -d 'Provide one or more options' -r
complete -c alpm-buildinfo -n "__fish_alpm_buildinfo_using_subcommand create; and __fish_seen_subcommand_from v1" -l packager -d 'Provide a packager' -r
complete -c alpm-buildinfo -n "__fish_alpm_buildinfo_using_subcommand create; and __fish_seen_subcommand_from v1" -l pkgarch -d 'Provide a pkgarch' -r
complete -c alpm-buildinfo -n "__fish_alpm_buildinfo_using_subcommand create; and __fish_seen_subcommand_from v1" -l pkgbase -d 'Provide a pkgbase' -r
complete -c alpm-buildinfo -n "__fish_alpm_buildinfo_using_subcommand create; and __fish_seen_subcommand_from v1" -l pkgbuild-sha256sum -d 'Provide a pkgbuild_sha256sum' -r
complete -c alpm-buildinfo -n "__fish_alpm_buildinfo_using_subcommand create; and __fish_seen_subcommand_from v1" -l pkgname -d 'Provide a pkgname' -r
complete -c alpm-buildinfo -n "__fish_alpm_buildinfo_using_subcommand create; and __fish_seen_subcommand_from v1" -l pkgver -d 'Provide a pkgver' -r
complete -c alpm-buildinfo -n "__fish_alpm_buildinfo_using_subcommand create; and __fish_seen_subcommand_from v1" -s h -l help -d 'Print help'
complete -c alpm-buildinfo -n "__fish_alpm_buildinfo_using_subcommand create; and __fish_seen_subcommand_from v2" -l builddate -d 'Provide a builddate' -r
complete -c alpm-buildinfo -n "__fish_alpm_buildinfo_using_subcommand create; and __fish_seen_subcommand_from v2" -l builddir -d 'Provide a builddir' -r
complete -c alpm-buildinfo -n "__fish_alpm_buildinfo_using_subcommand create; and __fish_seen_subcommand_from v2" -l buildenv -d 'Provide one or more buildenv' -r
complete -c alpm-buildinfo -n "__fish_alpm_buildinfo_using_subcommand create; and __fish_seen_subcommand_from v2" -l installed -d 'Provide one or more installed' -r
complete -c alpm-buildinfo -n "__fish_alpm_buildinfo_using_subcommand create; and __fish_seen_subcommand_from v2" -l options -d 'Provide one or more options' -r
complete -c alpm-buildinfo -n "__fish_alpm_buildinfo_using_subcommand create; and __fish_seen_subcommand_from v2" -l packager -d 'Provide a packager' -r
complete -c alpm-buildinfo -n "__fish_alpm_buildinfo_using_subcommand create; and __fish_seen_subcommand_from v2" -l pkgarch -d 'Provide a pkgarch' -r
complete -c alpm-buildinfo -n "__fish_alpm_buildinfo_using_subcommand create; and __fish_seen_subcommand_from v2" -l pkgbase -d 'Provide a pkgbase' -r
complete -c alpm-buildinfo -n "__fish_alpm_buildinfo_using_subcommand create; and __fish_seen_subcommand_from v2" -l pkgbuild-sha256sum -d 'Provide a pkgbuild_sha256sum' -r
complete -c alpm-buildinfo -n "__fish_alpm_buildinfo_using_subcommand create; and __fish_seen_subcommand_from v2" -l pkgname -d 'Provide a pkgname' -r
complete -c alpm-buildinfo -n "__fish_alpm_buildinfo_using_subcommand create; and __fish_seen_subcommand_from v2" -l pkgver -d 'Provide a pkgver' -r
complete -c alpm-buildinfo -n "__fish_alpm_buildinfo_using_subcommand create; and __fish_seen_subcommand_from v2" -l startdir -d 'Provide a startdir' -r
complete -c alpm-buildinfo -n "__fish_alpm_buildinfo_using_subcommand create; and __fish_seen_subcommand_from v2" -l buildtool -d 'Provide a buildtool' -r
complete -c alpm-buildinfo -n "__fish_alpm_buildinfo_using_subcommand create; and __fish_seen_subcommand_from v2" -l buildtoolver -d 'Provide a buildtoolver' -r
complete -c alpm-buildinfo -n "__fish_alpm_buildinfo_using_subcommand create; and __fish_seen_subcommand_from v2" -s h -l help -d 'Print help'
complete -c alpm-buildinfo -n "__fish_alpm_buildinfo_using_subcommand create; and __fish_seen_subcommand_from help" -f -a "v1" -d 'Create a BUILDINFO version 1 file'
complete -c alpm-buildinfo -n "__fish_alpm_buildinfo_using_subcommand create; and __fish_seen_subcommand_from help" -f -a "v2" -d 'Create a BUILDINFO version 2 file'
complete -c alpm-buildinfo -n "__fish_alpm_buildinfo_using_subcommand create; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c alpm-buildinfo -n "__fish_alpm_buildinfo_using_subcommand validate" -s s -l schema -d 'Provide the BUILDINFO schema version to use' -r
complete -c alpm-buildinfo -n "__fish_alpm_buildinfo_using_subcommand validate" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c alpm-buildinfo -n "__fish_alpm_buildinfo_using_subcommand format" -s s -l schema -d 'Provide the BUILDINFO schema version to use' -r
complete -c alpm-buildinfo -n "__fish_alpm_buildinfo_using_subcommand format" -s o -l output-format -d 'Provide the output format' -r -f -a "json\t''"
complete -c alpm-buildinfo -n "__fish_alpm_buildinfo_using_subcommand format" -s p -l pretty -d 'Pretty-print the output'
complete -c alpm-buildinfo -n "__fish_alpm_buildinfo_using_subcommand format" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c alpm-buildinfo -n "__fish_alpm_buildinfo_using_subcommand help; and not __fish_seen_subcommand_from create validate format help" -f -a "create" -d 'Create a BUILDINFO file according to a schema'
complete -c alpm-buildinfo -n "__fish_alpm_buildinfo_using_subcommand help; and not __fish_seen_subcommand_from create validate format help" -f -a "validate" -d 'Validate a BUILDINFO file'
complete -c alpm-buildinfo -n "__fish_alpm_buildinfo_using_subcommand help; and not __fish_seen_subcommand_from create validate format help" -f -a "format" -d 'Parse a BUILDINFO file and output it in a different format'
complete -c alpm-buildinfo -n "__fish_alpm_buildinfo_using_subcommand help; and not __fish_seen_subcommand_from create validate format help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c alpm-buildinfo -n "__fish_alpm_buildinfo_using_subcommand help; and __fish_seen_subcommand_from create" -f -a "v1" -d 'Create a BUILDINFO version 1 file'
complete -c alpm-buildinfo -n "__fish_alpm_buildinfo_using_subcommand help; and __fish_seen_subcommand_from create" -f -a "v2" -d 'Create a BUILDINFO version 2 file'
