# - Config file for the amd_smi package
# It defines the following variables
#  AMD_SMI_INCLUDE_DIRS - include directories for amd_smi
#  AMD_SMI_LIBRARIES    - libraries to link against

# Compute paths

####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was amd_smi-config.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################
get_filename_component(AMD_SMI_CMAKE_DIR "${CMAKE_CURRENT_LIST_FILE}" PATH)

set_and_check( amd_smi_INCLUDE_DIR "${PACKAGE_PREFIX_DIR}/include" )
set_and_check( AMD_SMI_INCLUDE_DIR "${PACKAGE_PREFIX_DIR}/include" )
set_and_check( AMD_SMI_INCLUDE_DIRS "${PACKAGE_PREFIX_DIR}/include" )
set_and_check( amd_smi_LIB_DIR "${PACKAGE_PREFIX_DIR}/lib" )
set_and_check( AMD_SMI_LIB_DIR "${PACKAGE_PREFIX_DIR}/lib" )
set_and_check( AMD_SMI_LIB_DIRS "${PACKAGE_PREFIX_DIR}/lib" )


# Our library dependencies (contains definitions for IMPORTED targets)
if(NOT TARGET amd_smi AND NOT amd_smi_BINARY_DIR)
    include("${AMD_SMI_CMAKE_DIR}/amd_smiTargets.cmake")
endif()

# These are IMPORTED targets created by AmdSmiTargets.cmake
# TODO: Need to check if OAM libraries are needed here!
set(AMD_SMI_LIBRARIES amd_smi)
set(AMD_SMI_LIBRARY amd_smi)

check_required_components(amd_smi)
