# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_atac_global_optspecs
	string join \n d/directory= tui dry-run no-ansi-log v/verbose q/quiet h/help V/version
end

function __fish_atac_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_atac_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_atac_using_subcommand
	set -l cmd (__fish_atac_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c atac -n "__fish_atac_needs_command" -s d -l directory -d 'Main application directory, containing JSON/YAML collections files, the atac.toml config file and the atac.log file' -r -f -a "(__fish_complete_directories)"
complete -c atac -n "__fish_atac_needs_command" -l tui -d 'Run TUI after command'
complete -c atac -n "__fish_atac_needs_command" -l dry-run -d 'Avoid saving data to the collection and environment files'
complete -c atac -n "__fish_atac_needs_command" -l no-ansi-log -d 'Avoid using ANSI format for log file/output'
complete -c atac -n "__fish_atac_needs_command" -s v -l verbose -d 'Increase logging verbosity'
complete -c atac -n "__fish_atac_needs_command" -s q -l quiet -d 'Decrease logging verbosity'
complete -c atac -n "__fish_atac_needs_command" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c atac -n "__fish_atac_needs_command" -s V -l version -d 'Print version'
complete -c atac -n "__fish_atac_needs_command" -f -a "collection" -d 'Collection commands'
complete -c atac -n "__fish_atac_needs_command" -f -a "request" -d 'Request commands'
complete -c atac -n "__fish_atac_needs_command" -f -a "try" -d 'One-shot request sender'
complete -c atac -n "__fish_atac_needs_command" -f -a "env" -d 'Environment commands'
complete -c atac -n "__fish_atac_needs_command" -f -a "import" -d 'Import a collection or a request from other file formats (Postman v2.1.0, cURL, OpenAPI)'
complete -c atac -n "__fish_atac_needs_command" -f -a "completions" -d 'Create a completion file'
complete -c atac -n "__fish_atac_needs_command" -f -a "man" -d 'Generate ATAC man page'
complete -c atac -n "__fish_atac_needs_command" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c atac -n "__fish_atac_using_subcommand collection; and not __fish_seen_subcommand_from list info new delete rename send help" -l env -d 'Name of the environment to use' -r
complete -c atac -n "__fish_atac_using_subcommand collection; and not __fish_seen_subcommand_from list info new delete rename send help" -l tui -d 'Run TUI after command'
complete -c atac -n "__fish_atac_using_subcommand collection; and not __fish_seen_subcommand_from list info new delete rename send help" -l dry-run -d 'Avoid saving data to the collection and environment files'
complete -c atac -n "__fish_atac_using_subcommand collection; and not __fish_seen_subcommand_from list info new delete rename send help" -l no-ansi-log -d 'Avoid using ANSI format for log file/output'
complete -c atac -n "__fish_atac_using_subcommand collection; and not __fish_seen_subcommand_from list info new delete rename send help" -s v -l verbose -d 'Increase logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand collection; and not __fish_seen_subcommand_from list info new delete rename send help" -s q -l quiet -d 'Decrease logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand collection; and not __fish_seen_subcommand_from list info new delete rename send help" -s h -l help -d 'Print help'
complete -c atac -n "__fish_atac_using_subcommand collection; and not __fish_seen_subcommand_from list info new delete rename send help" -f -a "list" -d 'List all collections'
complete -c atac -n "__fish_atac_using_subcommand collection; and not __fish_seen_subcommand_from list info new delete rename send help" -f -a "info" -d 'Describe a collection'
complete -c atac -n "__fish_atac_using_subcommand collection; and not __fish_seen_subcommand_from list info new delete rename send help" -f -a "new" -d 'Create a new collection'
complete -c atac -n "__fish_atac_using_subcommand collection; and not __fish_seen_subcommand_from list info new delete rename send help" -f -a "delete" -d 'Delete a collection'
complete -c atac -n "__fish_atac_using_subcommand collection; and not __fish_seen_subcommand_from list info new delete rename send help" -f -a "rename" -d 'Rename a collection'
complete -c atac -n "__fish_atac_using_subcommand collection; and not __fish_seen_subcommand_from list info new delete rename send help" -f -a "send" -d 'Send all the collection\'s requests'
complete -c atac -n "__fish_atac_using_subcommand collection; and not __fish_seen_subcommand_from list info new delete rename send help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c atac -n "__fish_atac_using_subcommand collection; and __fish_seen_subcommand_from list" -l env -d 'Name of the environment to use' -r
complete -c atac -n "__fish_atac_using_subcommand collection; and __fish_seen_subcommand_from list" -l request-names -d 'Also print request names'
complete -c atac -n "__fish_atac_using_subcommand collection; and __fish_seen_subcommand_from list" -l tui -d 'Run TUI after command'
complete -c atac -n "__fish_atac_using_subcommand collection; and __fish_seen_subcommand_from list" -l dry-run -d 'Avoid saving data to the collection and environment files'
complete -c atac -n "__fish_atac_using_subcommand collection; and __fish_seen_subcommand_from list" -l no-ansi-log -d 'Avoid using ANSI format for log file/output'
complete -c atac -n "__fish_atac_using_subcommand collection; and __fish_seen_subcommand_from list" -s v -l verbose -d 'Increase logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand collection; and __fish_seen_subcommand_from list" -s q -l quiet -d 'Decrease logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand collection; and __fish_seen_subcommand_from list" -s h -l help -d 'Print help'
complete -c atac -n "__fish_atac_using_subcommand collection; and __fish_seen_subcommand_from info" -l env -d 'Name of the environment to use' -r
complete -c atac -n "__fish_atac_using_subcommand collection; and __fish_seen_subcommand_from info" -l without-request-names -d 'Also print request names'
complete -c atac -n "__fish_atac_using_subcommand collection; and __fish_seen_subcommand_from info" -l tui -d 'Run TUI after command'
complete -c atac -n "__fish_atac_using_subcommand collection; and __fish_seen_subcommand_from info" -l dry-run -d 'Avoid saving data to the collection and environment files'
complete -c atac -n "__fish_atac_using_subcommand collection; and __fish_seen_subcommand_from info" -l no-ansi-log -d 'Avoid using ANSI format for log file/output'
complete -c atac -n "__fish_atac_using_subcommand collection; and __fish_seen_subcommand_from info" -s v -l verbose -d 'Increase logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand collection; and __fish_seen_subcommand_from info" -s q -l quiet -d 'Decrease logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand collection; and __fish_seen_subcommand_from info" -s h -l help -d 'Print help'
complete -c atac -n "__fish_atac_using_subcommand collection; and __fish_seen_subcommand_from new" -l env -d 'Name of the environment to use' -r
complete -c atac -n "__fish_atac_using_subcommand collection; and __fish_seen_subcommand_from new" -l tui -d 'Run TUI after command'
complete -c atac -n "__fish_atac_using_subcommand collection; and __fish_seen_subcommand_from new" -l dry-run -d 'Avoid saving data to the collection and environment files'
complete -c atac -n "__fish_atac_using_subcommand collection; and __fish_seen_subcommand_from new" -l no-ansi-log -d 'Avoid using ANSI format for log file/output'
complete -c atac -n "__fish_atac_using_subcommand collection; and __fish_seen_subcommand_from new" -s v -l verbose -d 'Increase logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand collection; and __fish_seen_subcommand_from new" -s q -l quiet -d 'Decrease logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand collection; and __fish_seen_subcommand_from new" -s h -l help -d 'Print help'
complete -c atac -n "__fish_atac_using_subcommand collection; and __fish_seen_subcommand_from delete" -l env -d 'Name of the environment to use' -r
complete -c atac -n "__fish_atac_using_subcommand collection; and __fish_seen_subcommand_from delete" -l tui -d 'Run TUI after command'
complete -c atac -n "__fish_atac_using_subcommand collection; and __fish_seen_subcommand_from delete" -l dry-run -d 'Avoid saving data to the collection and environment files'
complete -c atac -n "__fish_atac_using_subcommand collection; and __fish_seen_subcommand_from delete" -l no-ansi-log -d 'Avoid using ANSI format for log file/output'
complete -c atac -n "__fish_atac_using_subcommand collection; and __fish_seen_subcommand_from delete" -s v -l verbose -d 'Increase logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand collection; and __fish_seen_subcommand_from delete" -s q -l quiet -d 'Decrease logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand collection; and __fish_seen_subcommand_from delete" -s h -l help -d 'Print help'
complete -c atac -n "__fish_atac_using_subcommand collection; and __fish_seen_subcommand_from rename" -l env -d 'Name of the environment to use' -r
complete -c atac -n "__fish_atac_using_subcommand collection; and __fish_seen_subcommand_from rename" -l tui -d 'Run TUI after command'
complete -c atac -n "__fish_atac_using_subcommand collection; and __fish_seen_subcommand_from rename" -l dry-run -d 'Avoid saving data to the collection and environment files'
complete -c atac -n "__fish_atac_using_subcommand collection; and __fish_seen_subcommand_from rename" -l no-ansi-log -d 'Avoid using ANSI format for log file/output'
complete -c atac -n "__fish_atac_using_subcommand collection; and __fish_seen_subcommand_from rename" -s v -l verbose -d 'Increase logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand collection; and __fish_seen_subcommand_from rename" -s q -l quiet -d 'Decrease logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand collection; and __fish_seen_subcommand_from rename" -s h -l help -d 'Print help'
complete -c atac -n "__fish_atac_using_subcommand collection; and __fish_seen_subcommand_from send" -l env -d 'Name of the environment to use, e.g. my_env (from file .env.my_env)' -r
complete -c atac -n "__fish_atac_using_subcommand collection; and __fish_seen_subcommand_from send" -l hide-content -d 'Hide response content'
complete -c atac -n "__fish_atac_using_subcommand collection; and __fish_seen_subcommand_from send" -l status-code -d 'Show the status code'
complete -c atac -n "__fish_atac_using_subcommand collection; and __fish_seen_subcommand_from send" -l duration -d 'Show the duration'
complete -c atac -n "__fish_atac_using_subcommand collection; and __fish_seen_subcommand_from send" -l headers -d 'Show the response headers'
complete -c atac -n "__fish_atac_using_subcommand collection; and __fish_seen_subcommand_from send" -l cookies -d 'Show the response cookies'
complete -c atac -n "__fish_atac_using_subcommand collection; and __fish_seen_subcommand_from send" -l console -d 'Show the pre and post-request script console output'
complete -c atac -n "__fish_atac_using_subcommand collection; and __fish_seen_subcommand_from send" -l request-name -d 'Show the request name'
complete -c atac -n "__fish_atac_using_subcommand collection; and __fish_seen_subcommand_from send" -l tui -d 'Run TUI after command'
complete -c atac -n "__fish_atac_using_subcommand collection; and __fish_seen_subcommand_from send" -l dry-run -d 'Avoid saving data to the collection and environment files'
complete -c atac -n "__fish_atac_using_subcommand collection; and __fish_seen_subcommand_from send" -l no-ansi-log -d 'Avoid using ANSI format for log file/output'
complete -c atac -n "__fish_atac_using_subcommand collection; and __fish_seen_subcommand_from send" -s v -l verbose -d 'Increase logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand collection; and __fish_seen_subcommand_from send" -s q -l quiet -d 'Decrease logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand collection; and __fish_seen_subcommand_from send" -s h -l help -d 'Print help'
complete -c atac -n "__fish_atac_using_subcommand collection; and __fish_seen_subcommand_from help" -f -a "list" -d 'List all collections'
complete -c atac -n "__fish_atac_using_subcommand collection; and __fish_seen_subcommand_from help" -f -a "info" -d 'Describe a collection'
complete -c atac -n "__fish_atac_using_subcommand collection; and __fish_seen_subcommand_from help" -f -a "new" -d 'Create a new collection'
complete -c atac -n "__fish_atac_using_subcommand collection; and __fish_seen_subcommand_from help" -f -a "delete" -d 'Delete a collection'
complete -c atac -n "__fish_atac_using_subcommand collection; and __fish_seen_subcommand_from help" -f -a "rename" -d 'Rename a collection'
complete -c atac -n "__fish_atac_using_subcommand collection; and __fish_seen_subcommand_from help" -f -a "send" -d 'Send all the collection\'s requests'
complete -c atac -n "__fish_atac_using_subcommand collection; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c atac -n "__fish_atac_using_subcommand request; and not __fish_seen_subcommand_from info new delete rename url method params auth header body scripts send settings export help" -l tui -d 'Run TUI after command'
complete -c atac -n "__fish_atac_using_subcommand request; and not __fish_seen_subcommand_from info new delete rename url method params auth header body scripts send settings export help" -l dry-run -d 'Avoid saving data to the collection and environment files'
complete -c atac -n "__fish_atac_using_subcommand request; and not __fish_seen_subcommand_from info new delete rename url method params auth header body scripts send settings export help" -l no-ansi-log -d 'Avoid using ANSI format for log file/output'
complete -c atac -n "__fish_atac_using_subcommand request; and not __fish_seen_subcommand_from info new delete rename url method params auth header body scripts send settings export help" -s v -l verbose -d 'Increase logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand request; and not __fish_seen_subcommand_from info new delete rename url method params auth header body scripts send settings export help" -s q -l quiet -d 'Decrease logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand request; and not __fish_seen_subcommand_from info new delete rename url method params auth header body scripts send settings export help" -s h -l help -d 'Print help'
complete -c atac -n "__fish_atac_using_subcommand request; and not __fish_seen_subcommand_from info new delete rename url method params auth header body scripts send settings export help" -f -a "info" -d 'Describe a request'
complete -c atac -n "__fish_atac_using_subcommand request; and not __fish_seen_subcommand_from info new delete rename url method params auth header body scripts send settings export help" -f -a "new" -d 'Create a request'
complete -c atac -n "__fish_atac_using_subcommand request; and not __fish_seen_subcommand_from info new delete rename url method params auth header body scripts send settings export help" -f -a "delete" -d 'Delete a request'
complete -c atac -n "__fish_atac_using_subcommand request; and not __fish_seen_subcommand_from info new delete rename url method params auth header body scripts send settings export help" -f -a "rename" -d 'Rename a request'
complete -c atac -n "__fish_atac_using_subcommand request; and not __fish_seen_subcommand_from info new delete rename url method params auth header body scripts send settings export help" -f -a "url" -d 'Get or set a request URL'
complete -c atac -n "__fish_atac_using_subcommand request; and not __fish_seen_subcommand_from info new delete rename url method params auth header body scripts send settings export help" -f -a "method" -d 'Get or set a request method'
complete -c atac -n "__fish_atac_using_subcommand request; and not __fish_seen_subcommand_from info new delete rename url method params auth header body scripts send settings export help" -f -a "params" -d 'Get, set, add, delete, rename or toggle a query param'
complete -c atac -n "__fish_atac_using_subcommand request; and not __fish_seen_subcommand_from info new delete rename url method params auth header body scripts send settings export help" -f -a "auth" -d 'Get or set a request auth method'
complete -c atac -n "__fish_atac_using_subcommand request; and not __fish_seen_subcommand_from info new delete rename url method params auth header body scripts send settings export help" -f -a "header" -d 'Get, set, add, delete, rename or toggle a header'
complete -c atac -n "__fish_atac_using_subcommand request; and not __fish_seen_subcommand_from info new delete rename url method params auth header body scripts send settings export help" -f -a "body" -d 'Get or set a request body'
complete -c atac -n "__fish_atac_using_subcommand request; and not __fish_seen_subcommand_from info new delete rename url method params auth header body scripts send settings export help" -f -a "scripts" -d 'Get or set pre- and post-request scripts'
complete -c atac -n "__fish_atac_using_subcommand request; and not __fish_seen_subcommand_from info new delete rename url method params auth header body scripts send settings export help" -f -a "send" -d 'Send a request'
complete -c atac -n "__fish_atac_using_subcommand request; and not __fish_seen_subcommand_from info new delete rename url method params auth header body scripts send settings export help" -f -a "settings" -d 'Get or set a request setting'
complete -c atac -n "__fish_atac_using_subcommand request; and not __fish_seen_subcommand_from info new delete rename url method params auth header body scripts send settings export help" -f -a "export" -d 'Export a request to another programming language'
complete -c atac -n "__fish_atac_using_subcommand request; and not __fish_seen_subcommand_from info new delete rename url method params auth header body scripts send settings export help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from info" -l tui -d 'Run TUI after command'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from info" -l dry-run -d 'Avoid saving data to the collection and environment files'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from info" -l no-ansi-log -d 'Avoid using ANSI format for log file/output'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from info" -s v -l verbose -d 'Increase logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from info" -s q -l quiet -d 'Decrease logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from info" -s h -l help -d 'Print help'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from new" -s u -l url -d 'Request URL' -r -f
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from new" -s m -l method -d 'Request method' -r
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from new" -l add-param -d 'Add a query param (can be used multiple times)' -r
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from new" -l auth-basic -d 'Set a basic auth method' -r
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from new" -l auth-bearer-token -d 'Set a bearer token auth method' -r
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from new" -l add-header -d 'Add a header (can be used multiple times)' -r
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from new" -l body-file -d 'Set a file body' -r -F
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from new" -l add-body-multipart -d 'Set a multipart form body (adds a value each time used)' -r
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from new" -l add-body-form -d 'Set a form body (adds a value each time used)' -r
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from new" -l body-raw -d 'Set a raw test body' -r
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from new" -l body-json -d 'Set a JSON body' -r
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from new" -l body-xml -d 'Set an XML body' -r
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from new" -l body-html -d 'Set an HTML body' -r
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from new" -l body-javascript -d 'Set an JavaScript body' -r
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from new" -l pre-request-script -d 'Set a pre-request script' -r
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from new" -l post-request-script -d 'Set a post-request script' -r
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from new" -l no-base-headers -d 'Do not use base headers (cache-control, user-agent, accept, accept-encoding, connection)'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from new" -l no-proxy -d 'Do not use config proxy'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from new" -l no-redirects -d 'Do not allow redirects'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from new" -l no-cookies -d 'Do not store received cookies'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from new" -l no-pretty -d 'Do not pretty print response content'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from new" -l accept-invalid-certs -d 'Accept invalid certificates'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from new" -l accept-invalid-hostnames -d 'Accept invalid hostnames'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from new" -l tui -d 'Run TUI after command'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from new" -l dry-run -d 'Avoid saving data to the collection and environment files'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from new" -l no-ansi-log -d 'Avoid using ANSI format for log file/output'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from new" -s v -l verbose -d 'Increase logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from new" -s q -l quiet -d 'Decrease logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from new" -s h -l help -d 'Print help'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from delete" -l tui -d 'Run TUI after command'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from delete" -l dry-run -d 'Avoid saving data to the collection and environment files'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from delete" -l no-ansi-log -d 'Avoid using ANSI format for log file/output'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from delete" -s v -l verbose -d 'Increase logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from delete" -s q -l quiet -d 'Decrease logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from delete" -s h -l help -d 'Print help'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from rename" -l tui -d 'Run TUI after command'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from rename" -l dry-run -d 'Avoid saving data to the collection and environment files'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from rename" -l no-ansi-log -d 'Avoid using ANSI format for log file/output'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from rename" -s v -l verbose -d 'Increase logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from rename" -s q -l quiet -d 'Decrease logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from rename" -s h -l help -d 'Print help'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from url" -l tui -d 'Run TUI after command'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from url" -l dry-run -d 'Avoid saving data to the collection and environment files'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from url" -l no-ansi-log -d 'Avoid using ANSI format for log file/output'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from url" -s v -l verbose -d 'Increase logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from url" -s q -l quiet -d 'Decrease logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from url" -s h -l help -d 'Print help'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from url" -a "get" -d 'Print the current request URL'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from url" -a "set" -d 'Set the request URL'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from url" -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from method" -l tui -d 'Run TUI after command'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from method" -l dry-run -d 'Avoid saving data to the collection and environment files'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from method" -l no-ansi-log -d 'Avoid using ANSI format for log file/output'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from method" -s v -l verbose -d 'Increase logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from method" -s q -l quiet -d 'Decrease logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from method" -s h -l help -d 'Print help'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from method" -a "get" -d 'Print the current request method'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from method" -a "set" -d 'Set the request method'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from method" -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from params" -l tui -d 'Run TUI after command'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from params" -l dry-run -d 'Avoid saving data to the collection and environment files'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from params" -l no-ansi-log -d 'Avoid using ANSI format for log file/output'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from params" -s v -l verbose -d 'Increase logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from params" -s q -l quiet -d 'Decrease logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from params" -s h -l help -d 'Print help'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from params" -a "get" -d 'Get the value paired to a key'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from params" -a "set" -d 'Set the value paired to a key'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from params" -a "add" -d 'Add a key value pair'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from params" -a "delete" -d 'Delete a key'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from params" -a "rename" -d 'Rename a key'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from params" -a "toggle" -d 'Toggle a key value pair'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from params" -a "all" -d 'Print all the key value pairs'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from params" -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from auth" -l tui -d 'Run TUI after command'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from auth" -l dry-run -d 'Avoid saving data to the collection and environment files'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from auth" -l no-ansi-log -d 'Avoid using ANSI format for log file/output'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from auth" -s v -l verbose -d 'Increase logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from auth" -s q -l quiet -d 'Decrease logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from auth" -s h -l help -d 'Print help'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from auth" -a "get" -d 'Print the current request auth method'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from auth" -a "set" -d 'Set the request auth method'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from auth" -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from header" -l tui -d 'Run TUI after command'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from header" -l dry-run -d 'Avoid saving data to the collection and environment files'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from header" -l no-ansi-log -d 'Avoid using ANSI format for log file/output'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from header" -s v -l verbose -d 'Increase logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from header" -s q -l quiet -d 'Decrease logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from header" -s h -l help -d 'Print help'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from header" -a "get" -d 'Get the value paired to a key'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from header" -a "set" -d 'Set the value paired to a key'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from header" -a "add" -d 'Add a key value pair'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from header" -a "delete" -d 'Delete a key'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from header" -a "rename" -d 'Rename a key'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from header" -a "toggle" -d 'Toggle a key value pair'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from header" -a "all" -d 'Print all the key value pairs'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from header" -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from body" -l tui -d 'Run TUI after command'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from body" -l dry-run -d 'Avoid saving data to the collection and environment files'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from body" -l no-ansi-log -d 'Avoid using ANSI format for log file/output'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from body" -s v -l verbose -d 'Increase logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from body" -s q -l quiet -d 'Decrease logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from body" -s h -l help -d 'Print help'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from body" -a "get" -d 'Print the current request body'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from body" -a "set" -d 'Set the request body'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from body" -a "key" -d 'Add, get or set a key/value pair (multipart & form body only)'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from body" -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from scripts" -l tui -d 'Run TUI after command'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from scripts" -l dry-run -d 'Avoid saving data to the collection and environment files'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from scripts" -l no-ansi-log -d 'Avoid using ANSI format for log file/output'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from scripts" -s v -l verbose -d 'Increase logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from scripts" -s q -l quiet -d 'Decrease logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from scripts" -s h -l help -d 'Print help'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from scripts" -a "get" -d 'Print the current pre- or post-request script'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from scripts" -a "set" -d 'Set a pre- or post-request script'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from scripts" -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from send" -l env -d 'Name of the environment to use, e.g. my_env (from file .env.my_env)' -r
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from send" -l hide-content -d 'Hide response content'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from send" -l status-code -d 'Show the status code'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from send" -l duration -d 'Show the duration'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from send" -l headers -d 'Show the response headers'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from send" -l cookies -d 'Show the response cookies'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from send" -l console -d 'Show the pre and post-request script console output'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from send" -l request-name -d 'Show the request name'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from send" -l tui -d 'Run TUI after command'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from send" -l dry-run -d 'Avoid saving data to the collection and environment files'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from send" -l no-ansi-log -d 'Avoid using ANSI format for log file/output'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from send" -s v -l verbose -d 'Increase logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from send" -s q -l quiet -d 'Decrease logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from send" -s h -l help -d 'Print help'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from settings" -l tui -d 'Run TUI after command'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from settings" -l dry-run -d 'Avoid saving data to the collection and environment files'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from settings" -l no-ansi-log -d 'Avoid using ANSI format for log file/output'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from settings" -s v -l verbose -d 'Increase logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from settings" -s q -l quiet -d 'Decrease logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from settings" -s h -l help -d 'Print help'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from settings" -a "all" -d 'Print all the request settings'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from settings" -a "get" -d 'Print the current request setting'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from settings" -a "set" -d 'Set the request method'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from settings" -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from export" -l tui -d 'Run TUI after command'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from export" -l dry-run -d 'Avoid saving data to the collection and environment files'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from export" -l no-ansi-log -d 'Avoid using ANSI format for log file/output'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from export" -s v -l verbose -d 'Increase logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from export" -s q -l quiet -d 'Decrease logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from export" -s h -l help -d 'Print help'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from help" -f -a "info" -d 'Describe a request'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from help" -f -a "new" -d 'Create a request'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from help" -f -a "delete" -d 'Delete a request'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from help" -f -a "rename" -d 'Rename a request'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from help" -f -a "url" -d 'Get or set a request URL'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from help" -f -a "method" -d 'Get or set a request method'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from help" -f -a "params" -d 'Get, set, add, delete, rename or toggle a query param'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from help" -f -a "auth" -d 'Get or set a request auth method'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from help" -f -a "header" -d 'Get, set, add, delete, rename or toggle a header'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from help" -f -a "body" -d 'Get or set a request body'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from help" -f -a "scripts" -d 'Get or set pre- and post-request scripts'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from help" -f -a "send" -d 'Send a request'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from help" -f -a "settings" -d 'Get or set a request setting'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from help" -f -a "export" -d 'Export a request to another programming language'
complete -c atac -n "__fish_atac_using_subcommand request; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c atac -n "__fish_atac_using_subcommand try" -s u -l url -d 'Request URL' -r -f
complete -c atac -n "__fish_atac_using_subcommand try" -s m -l method -d 'Request method' -r
complete -c atac -n "__fish_atac_using_subcommand try" -l add-param -d 'Add a query param (can be used multiple times)' -r
complete -c atac -n "__fish_atac_using_subcommand try" -l auth-basic -d 'Set a basic auth method' -r
complete -c atac -n "__fish_atac_using_subcommand try" -l auth-bearer-token -d 'Set a bearer token auth method' -r
complete -c atac -n "__fish_atac_using_subcommand try" -l add-header -d 'Add a header (can be used multiple times)' -r
complete -c atac -n "__fish_atac_using_subcommand try" -l body-file -d 'Set a file body' -r -F
complete -c atac -n "__fish_atac_using_subcommand try" -l add-body-multipart -d 'Set a multipart form body (adds a value each time used)' -r
complete -c atac -n "__fish_atac_using_subcommand try" -l add-body-form -d 'Set a form body (adds a value each time used)' -r
complete -c atac -n "__fish_atac_using_subcommand try" -l body-raw -d 'Set a raw test body' -r
complete -c atac -n "__fish_atac_using_subcommand try" -l body-json -d 'Set a JSON body' -r
complete -c atac -n "__fish_atac_using_subcommand try" -l body-xml -d 'Set an XML body' -r
complete -c atac -n "__fish_atac_using_subcommand try" -l body-html -d 'Set an HTML body' -r
complete -c atac -n "__fish_atac_using_subcommand try" -l body-javascript -d 'Set an JavaScript body' -r
complete -c atac -n "__fish_atac_using_subcommand try" -l pre-request-script -d 'Set a pre-request script' -r
complete -c atac -n "__fish_atac_using_subcommand try" -l post-request-script -d 'Set a post-request script' -r
complete -c atac -n "__fish_atac_using_subcommand try" -l env -d 'Name of the environment to use, e.g. my_env (from file .env.my_env)' -r
complete -c atac -n "__fish_atac_using_subcommand try" -l no-base-headers -d 'Do not use base headers (cache-control, user-agent, accept, accept-encoding, connection)'
complete -c atac -n "__fish_atac_using_subcommand try" -l no-proxy -d 'Do not use config proxy'
complete -c atac -n "__fish_atac_using_subcommand try" -l no-redirects -d 'Do not allow redirects'
complete -c atac -n "__fish_atac_using_subcommand try" -l no-cookies -d 'Do not store received cookies'
complete -c atac -n "__fish_atac_using_subcommand try" -l no-pretty -d 'Do not pretty print response content'
complete -c atac -n "__fish_atac_using_subcommand try" -l accept-invalid-certs -d 'Accept invalid certificates'
complete -c atac -n "__fish_atac_using_subcommand try" -l accept-invalid-hostnames -d 'Accept invalid hostnames'
complete -c atac -n "__fish_atac_using_subcommand try" -l hide-content -d 'Hide response content'
complete -c atac -n "__fish_atac_using_subcommand try" -l status-code -d 'Show the status code'
complete -c atac -n "__fish_atac_using_subcommand try" -l duration -d 'Show the duration'
complete -c atac -n "__fish_atac_using_subcommand try" -l headers -d 'Show the response headers'
complete -c atac -n "__fish_atac_using_subcommand try" -l cookies -d 'Show the response cookies'
complete -c atac -n "__fish_atac_using_subcommand try" -l console -d 'Show the pre and post-request script console output'
complete -c atac -n "__fish_atac_using_subcommand try" -l request-name -d 'Show the request name'
complete -c atac -n "__fish_atac_using_subcommand try" -l tui -d 'Run TUI after command'
complete -c atac -n "__fish_atac_using_subcommand try" -l dry-run -d 'Avoid saving data to the collection and environment files'
complete -c atac -n "__fish_atac_using_subcommand try" -l no-ansi-log -d 'Avoid using ANSI format for log file/output'
complete -c atac -n "__fish_atac_using_subcommand try" -s v -l verbose -d 'Increase logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand try" -s q -l quiet -d 'Decrease logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand try" -s h -l help -d 'Print help'
complete -c atac -n "__fish_atac_using_subcommand env; and not __fish_seen_subcommand_from info key help" -l tui -d 'Run TUI after command'
complete -c atac -n "__fish_atac_using_subcommand env; and not __fish_seen_subcommand_from info key help" -l dry-run -d 'Avoid saving data to the collection and environment files'
complete -c atac -n "__fish_atac_using_subcommand env; and not __fish_seen_subcommand_from info key help" -l no-ansi-log -d 'Avoid using ANSI format for log file/output'
complete -c atac -n "__fish_atac_using_subcommand env; and not __fish_seen_subcommand_from info key help" -s v -l verbose -d 'Increase logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand env; and not __fish_seen_subcommand_from info key help" -s q -l quiet -d 'Decrease logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand env; and not __fish_seen_subcommand_from info key help" -s h -l help -d 'Print help'
complete -c atac -n "__fish_atac_using_subcommand env; and not __fish_seen_subcommand_from info key help" -f -a "info" -d 'Describe an environment'
complete -c atac -n "__fish_atac_using_subcommand env; and not __fish_seen_subcommand_from info key help" -f -a "key" -d 'Add, get or set a key/value pair'
complete -c atac -n "__fish_atac_using_subcommand env; and not __fish_seen_subcommand_from info key help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c atac -n "__fish_atac_using_subcommand env; and __fish_seen_subcommand_from info" -l tui -d 'Run TUI after command'
complete -c atac -n "__fish_atac_using_subcommand env; and __fish_seen_subcommand_from info" -l dry-run -d 'Avoid saving data to the collection and environment files'
complete -c atac -n "__fish_atac_using_subcommand env; and __fish_seen_subcommand_from info" -l no-ansi-log -d 'Avoid using ANSI format for log file/output'
complete -c atac -n "__fish_atac_using_subcommand env; and __fish_seen_subcommand_from info" -s v -l verbose -d 'Increase logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand env; and __fish_seen_subcommand_from info" -s q -l quiet -d 'Decrease logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand env; and __fish_seen_subcommand_from info" -s h -l help -d 'Print help'
complete -c atac -n "__fish_atac_using_subcommand env; and __fish_seen_subcommand_from key" -l tui -d 'Run TUI after command'
complete -c atac -n "__fish_atac_using_subcommand env; and __fish_seen_subcommand_from key" -l dry-run -d 'Avoid saving data to the collection and environment files'
complete -c atac -n "__fish_atac_using_subcommand env; and __fish_seen_subcommand_from key" -l no-ansi-log -d 'Avoid using ANSI format for log file/output'
complete -c atac -n "__fish_atac_using_subcommand env; and __fish_seen_subcommand_from key" -s v -l verbose -d 'Increase logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand env; and __fish_seen_subcommand_from key" -s q -l quiet -d 'Decrease logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand env; and __fish_seen_subcommand_from key" -s h -l help -d 'Print help'
complete -c atac -n "__fish_atac_using_subcommand env; and __fish_seen_subcommand_from key" -a "get" -d 'Get the value paired to a key'
complete -c atac -n "__fish_atac_using_subcommand env; and __fish_seen_subcommand_from key" -a "set" -d 'Set the value paired to a key'
complete -c atac -n "__fish_atac_using_subcommand env; and __fish_seen_subcommand_from key" -a "add" -d 'Add a key value pair'
complete -c atac -n "__fish_atac_using_subcommand env; and __fish_seen_subcommand_from key" -a "delete" -d 'Delete a key'
complete -c atac -n "__fish_atac_using_subcommand env; and __fish_seen_subcommand_from key" -a "rename" -d 'Rename a key'
complete -c atac -n "__fish_atac_using_subcommand env; and __fish_seen_subcommand_from key" -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c atac -n "__fish_atac_using_subcommand env; and __fish_seen_subcommand_from help" -f -a "info" -d 'Describe an environment'
complete -c atac -n "__fish_atac_using_subcommand env; and __fish_seen_subcommand_from help" -f -a "key" -d 'Add, get or set a key/value pair'
complete -c atac -n "__fish_atac_using_subcommand env; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c atac -n "__fish_atac_using_subcommand import; and not __fish_seen_subcommand_from postman curl open-api help" -l tui -d 'Run TUI after command'
complete -c atac -n "__fish_atac_using_subcommand import; and not __fish_seen_subcommand_from postman curl open-api help" -l dry-run -d 'Avoid saving data to the collection and environment files'
complete -c atac -n "__fish_atac_using_subcommand import; and not __fish_seen_subcommand_from postman curl open-api help" -l no-ansi-log -d 'Avoid using ANSI format for log file/output'
complete -c atac -n "__fish_atac_using_subcommand import; and not __fish_seen_subcommand_from postman curl open-api help" -s v -l verbose -d 'Increase logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand import; and not __fish_seen_subcommand_from postman curl open-api help" -s q -l quiet -d 'Decrease logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand import; and not __fish_seen_subcommand_from postman curl open-api help" -s h -l help -d 'Print help'
complete -c atac -n "__fish_atac_using_subcommand import; and not __fish_seen_subcommand_from postman curl open-api help" -f -a "postman" -d 'Import a Postman v2.1.0 file'
complete -c atac -n "__fish_atac_using_subcommand import; and not __fish_seen_subcommand_from postman curl open-api help" -f -a "curl" -d 'Import a curl file'
complete -c atac -n "__fish_atac_using_subcommand import; and not __fish_seen_subcommand_from postman curl open-api help" -f -a "open-api" -d 'Import an Open Api file'
complete -c atac -n "__fish_atac_using_subcommand import; and not __fish_seen_subcommand_from postman curl open-api help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c atac -n "__fish_atac_using_subcommand import; and __fish_seen_subcommand_from postman" -l max-depth -d 'Max depth at which import should stop creating nested collections and only get the deeper requests' -r
complete -c atac -n "__fish_atac_using_subcommand import; and __fish_seen_subcommand_from postman" -l tui -d 'Run TUI after command'
complete -c atac -n "__fish_atac_using_subcommand import; and __fish_seen_subcommand_from postman" -l dry-run -d 'Avoid saving data to the collection and environment files'
complete -c atac -n "__fish_atac_using_subcommand import; and __fish_seen_subcommand_from postman" -l no-ansi-log -d 'Avoid using ANSI format for log file/output'
complete -c atac -n "__fish_atac_using_subcommand import; and __fish_seen_subcommand_from postman" -s v -l verbose -d 'Increase logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand import; and __fish_seen_subcommand_from postman" -s q -l quiet -d 'Decrease logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand import; and __fish_seen_subcommand_from postman" -s h -l help -d 'Print help'
complete -c atac -n "__fish_atac_using_subcommand import; and __fish_seen_subcommand_from curl" -l max-depth -d 'Max depth at which import should stop creating nested collections and only get the deeper requests' -r
complete -c atac -n "__fish_atac_using_subcommand import; and __fish_seen_subcommand_from curl" -s r -l recursive -d 'Search for deeper files'
complete -c atac -n "__fish_atac_using_subcommand import; and __fish_seen_subcommand_from curl" -l tui -d 'Run TUI after command'
complete -c atac -n "__fish_atac_using_subcommand import; and __fish_seen_subcommand_from curl" -l dry-run -d 'Avoid saving data to the collection and environment files'
complete -c atac -n "__fish_atac_using_subcommand import; and __fish_seen_subcommand_from curl" -l no-ansi-log -d 'Avoid using ANSI format for log file/output'
complete -c atac -n "__fish_atac_using_subcommand import; and __fish_seen_subcommand_from curl" -s v -l verbose -d 'Increase logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand import; and __fish_seen_subcommand_from curl" -s q -l quiet -d 'Decrease logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand import; and __fish_seen_subcommand_from curl" -s h -l help -d 'Print help'
complete -c atac -n "__fish_atac_using_subcommand import; and __fish_seen_subcommand_from open-api" -l max-depth -d 'Max depth at which import should stop creating nested collections and only get the deeper requests' -r
complete -c atac -n "__fish_atac_using_subcommand import; and __fish_seen_subcommand_from open-api" -l tui -d 'Run TUI after command'
complete -c atac -n "__fish_atac_using_subcommand import; and __fish_seen_subcommand_from open-api" -l dry-run -d 'Avoid saving data to the collection and environment files'
complete -c atac -n "__fish_atac_using_subcommand import; and __fish_seen_subcommand_from open-api" -l no-ansi-log -d 'Avoid using ANSI format for log file/output'
complete -c atac -n "__fish_atac_using_subcommand import; and __fish_seen_subcommand_from open-api" -s v -l verbose -d 'Increase logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand import; and __fish_seen_subcommand_from open-api" -s q -l quiet -d 'Decrease logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand import; and __fish_seen_subcommand_from open-api" -s h -l help -d 'Print help'
complete -c atac -n "__fish_atac_using_subcommand import; and __fish_seen_subcommand_from help" -f -a "postman" -d 'Import a Postman v2.1.0 file'
complete -c atac -n "__fish_atac_using_subcommand import; and __fish_seen_subcommand_from help" -f -a "curl" -d 'Import a curl file'
complete -c atac -n "__fish_atac_using_subcommand import; and __fish_seen_subcommand_from help" -f -a "open-api" -d 'Import an Open Api file'
complete -c atac -n "__fish_atac_using_subcommand import; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c atac -n "__fish_atac_using_subcommand completions" -l tui -d 'Run TUI after command'
complete -c atac -n "__fish_atac_using_subcommand completions" -l dry-run -d 'Avoid saving data to the collection and environment files'
complete -c atac -n "__fish_atac_using_subcommand completions" -l no-ansi-log -d 'Avoid using ANSI format for log file/output'
complete -c atac -n "__fish_atac_using_subcommand completions" -s v -l verbose -d 'Increase logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand completions" -s q -l quiet -d 'Decrease logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand completions" -s h -l help -d 'Print help'
complete -c atac -n "__fish_atac_using_subcommand man" -l tui -d 'Run TUI after command'
complete -c atac -n "__fish_atac_using_subcommand man" -l dry-run -d 'Avoid saving data to the collection and environment files'
complete -c atac -n "__fish_atac_using_subcommand man" -l no-ansi-log -d 'Avoid using ANSI format for log file/output'
complete -c atac -n "__fish_atac_using_subcommand man" -s v -l verbose -d 'Increase logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand man" -s q -l quiet -d 'Decrease logging verbosity'
complete -c atac -n "__fish_atac_using_subcommand man" -s h -l help -d 'Print help'
complete -c atac -n "__fish_atac_using_subcommand help; and not __fish_seen_subcommand_from collection request try env import completions man help" -f -a "collection" -d 'Collection commands'
complete -c atac -n "__fish_atac_using_subcommand help; and not __fish_seen_subcommand_from collection request try env import completions man help" -f -a "request" -d 'Request commands'
complete -c atac -n "__fish_atac_using_subcommand help; and not __fish_seen_subcommand_from collection request try env import completions man help" -f -a "try" -d 'One-shot request sender'
complete -c atac -n "__fish_atac_using_subcommand help; and not __fish_seen_subcommand_from collection request try env import completions man help" -f -a "env" -d 'Environment commands'
complete -c atac -n "__fish_atac_using_subcommand help; and not __fish_seen_subcommand_from collection request try env import completions man help" -f -a "import" -d 'Import a collection or a request from other file formats (Postman v2.1.0, cURL, OpenAPI)'
complete -c atac -n "__fish_atac_using_subcommand help; and not __fish_seen_subcommand_from collection request try env import completions man help" -f -a "completions" -d 'Create a completion file'
complete -c atac -n "__fish_atac_using_subcommand help; and not __fish_seen_subcommand_from collection request try env import completions man help" -f -a "man" -d 'Generate ATAC man page'
complete -c atac -n "__fish_atac_using_subcommand help; and not __fish_seen_subcommand_from collection request try env import completions man help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c atac -n "__fish_atac_using_subcommand help; and __fish_seen_subcommand_from collection" -f -a "list" -d 'List all collections'
complete -c atac -n "__fish_atac_using_subcommand help; and __fish_seen_subcommand_from collection" -f -a "info" -d 'Describe a collection'
complete -c atac -n "__fish_atac_using_subcommand help; and __fish_seen_subcommand_from collection" -f -a "new" -d 'Create a new collection'
complete -c atac -n "__fish_atac_using_subcommand help; and __fish_seen_subcommand_from collection" -f -a "delete" -d 'Delete a collection'
complete -c atac -n "__fish_atac_using_subcommand help; and __fish_seen_subcommand_from collection" -f -a "rename" -d 'Rename a collection'
complete -c atac -n "__fish_atac_using_subcommand help; and __fish_seen_subcommand_from collection" -f -a "send" -d 'Send all the collection\'s requests'
complete -c atac -n "__fish_atac_using_subcommand help; and __fish_seen_subcommand_from request" -f -a "info" -d 'Describe a request'
complete -c atac -n "__fish_atac_using_subcommand help; and __fish_seen_subcommand_from request" -f -a "new" -d 'Create a request'
complete -c atac -n "__fish_atac_using_subcommand help; and __fish_seen_subcommand_from request" -f -a "delete" -d 'Delete a request'
complete -c atac -n "__fish_atac_using_subcommand help; and __fish_seen_subcommand_from request" -f -a "rename" -d 'Rename a request'
complete -c atac -n "__fish_atac_using_subcommand help; and __fish_seen_subcommand_from request" -f -a "url" -d 'Get or set a request URL'
complete -c atac -n "__fish_atac_using_subcommand help; and __fish_seen_subcommand_from request" -f -a "method" -d 'Get or set a request method'
complete -c atac -n "__fish_atac_using_subcommand help; and __fish_seen_subcommand_from request" -f -a "params" -d 'Get, set, add, delete, rename or toggle a query param'
complete -c atac -n "__fish_atac_using_subcommand help; and __fish_seen_subcommand_from request" -f -a "auth" -d 'Get or set a request auth method'
complete -c atac -n "__fish_atac_using_subcommand help; and __fish_seen_subcommand_from request" -f -a "header" -d 'Get, set, add, delete, rename or toggle a header'
complete -c atac -n "__fish_atac_using_subcommand help; and __fish_seen_subcommand_from request" -f -a "body" -d 'Get or set a request body'
complete -c atac -n "__fish_atac_using_subcommand help; and __fish_seen_subcommand_from request" -f -a "scripts" -d 'Get or set pre- and post-request scripts'
complete -c atac -n "__fish_atac_using_subcommand help; and __fish_seen_subcommand_from request" -f -a "send" -d 'Send a request'
complete -c atac -n "__fish_atac_using_subcommand help; and __fish_seen_subcommand_from request" -f -a "settings" -d 'Get or set a request setting'
complete -c atac -n "__fish_atac_using_subcommand help; and __fish_seen_subcommand_from request" -f -a "export" -d 'Export a request to another programming language'
complete -c atac -n "__fish_atac_using_subcommand help; and __fish_seen_subcommand_from env" -f -a "info" -d 'Describe an environment'
complete -c atac -n "__fish_atac_using_subcommand help; and __fish_seen_subcommand_from env" -f -a "key" -d 'Add, get or set a key/value pair'
complete -c atac -n "__fish_atac_using_subcommand help; and __fish_seen_subcommand_from import" -f -a "postman" -d 'Import a Postman v2.1.0 file'
complete -c atac -n "__fish_atac_using_subcommand help; and __fish_seen_subcommand_from import" -f -a "curl" -d 'Import a curl file'
complete -c atac -n "__fish_atac_using_subcommand help; and __fish_seen_subcommand_from import" -f -a "open-api" -d 'Import an Open Api file'
