/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.meta.IPropertyValueListProvider;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.properties.ObjectPropertyDescriptor;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.contentassist.ContentAssistUtils;
import org.jkiss.dbeaver.ui.contentassist.StringContentProposalProvider;
import org.jkiss.dbeaver.ui.controls.ResizeableComposite;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.BeanUtils;
import org.jkiss.utils.CommonUtils;

public class CustomFormEditor {
    private static final Log log = Log.getLog(CustomFormEditor.class);
    private static final String VALUE_KEY = "form.data.value";
    private static final String LIST_VALUE_KEY = "form.data.list.value";
    private final Map<DBPPropertyDescriptor, Control> editorMap = new HashMap<DBPPropertyDescriptor, Control>();
    @Nullable
    private final DBSObject databaseObject;
    @Nullable
    private final DBECommandContext commandContext;
    @NotNull
    private final DBPPropertySource propertySource;
    private Composite curButtonsContainer;
    private transient boolean isLoading;

    public CustomFormEditor(@NotNull DBSObject databaseObject, @Nullable DBECommandContext commandContext, @NotNull DBPPropertySource propertySource) {
        this.databaseObject = databaseObject;
        this.commandContext = commandContext;
        this.propertySource = propertySource;
    }

    public CustomFormEditor(@NotNull DBPPropertySource propertySource) {
        this.databaseObject = null;
        this.commandContext = null;
        this.propertySource = propertySource;
    }

    protected void openObjectLink(Object linkData) {
        if (linkData != null) {
            UIUtils.openWebBrowser(CommonUtils.toString((Object)linkData));
        }
    }

    public void updateOtherPropertyValues(Object excludePropId) {
        List<DBPPropertyDescriptor> allProps = this.filterProperties(this.propertySource.getProperties());
        HashMap<DBPPropertyDescriptor, Object> propValues = new HashMap<DBPPropertyDescriptor, Object>();
        for (DBPPropertyDescriptor prop : allProps) {
            if (excludePropId != null && excludePropId.equals(prop.getId())) continue;
            Object value = this.propertySource.getPropertyValue(null, prop.getId());
            propValues.put(prop, value);
        }
        this.loadEditorValues(propValues);
    }

    public boolean isEditableObject() {
        DBPPropertyDescriptor[] dBPPropertyDescriptorArray = this.propertySource.getProperties();
        int n = dBPPropertyDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBPPropertyDescriptor prop = dBPPropertyDescriptorArray[n2];
            if (prop.isEditable(this.propertySource.getEditableValue()) || prop.getId().equals("name") && this.supportsObjectRename()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean supportsObjectRename() {
        return DBWorkbench.getPlatform().getEditorsRegistry().getObjectManager(this.propertySource.getEditableValue().getClass(), DBEObjectRenamer.class) != null;
    }

    public void createPropertyEditor(Composite group, final DBPPropertyDescriptor prop) {
        this.isLoading = true;
        try {
            boolean isReadOnlyCon;
            boolean bl = isReadOnlyCon = this.databaseObject == null || DBUtils.isReadOnly((DBSObject)this.databaseObject);
            if (prop == null) {
                UIUtils.createEmptyLabel(group, 2, 1);
            } else {
                boolean editable = !isReadOnlyCon && (prop.isEditable(this.propertySource.getEditableValue()) || prop.getId().equals("name") && this.supportsObjectRename());
                Object propertyValue = this.propertySource.getPropertyValue(null, prop.getId());
                if (propertyValue == null && prop instanceof ObjectPropertyDescriptor && ((ObjectPropertyDescriptor)prop).isOptional()) {
                    return;
                }
                Control editControl = this.createEditorControl(group, this.propertySource.getEditableValue(), prop, propertyValue, !editable);
                String propDescription = prop.getDescription();
                if (!CommonUtils.isEmpty((String)propDescription)) {
                    editControl.setToolTipText(propDescription);
                }
                if (!(editControl instanceof Button)) {
                    GridData gd = (GridData)editControl.getLayoutData();
                    if (gd == null) {
                        gd = new GridData(34);
                        editControl.setLayoutData((Object)gd);
                    }
                    if (editControl instanceof Text || editControl instanceof Combo) {
                        gd.widthHint = Math.max(UIUtils.getFontHeight((Control)group) * 15, editControl.computeSize((int)-1, (int)-1).x);
                    }
                }
                this.editorMap.put(prop, editControl);
                if (editControl instanceof Combo) {
                    final Combo combo = (Combo)editControl;
                    if ((editControl.getStyle() & 8) == 8) {
                        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                CustomFormEditor.this.updatePropertyValue(prop, combo.getText());
                            }
                        });
                    } else {
                        combo.addModifyListener(e -> {
                            try {
                                this.updatePropertyValue(prop, combo.getText());
                            }
                            catch (Exception ex) {
                                log.debug((Object)("Error setting value from combo: " + ex.getMessage()));
                            }
                        });
                    }
                } else if (editControl instanceof Text) {
                    Text text = (Text)editControl;
                    text.addModifyListener(e -> this.updatePropertyValue(prop, ((Text)editControl).getText()));
                } else if (editControl instanceof Button) {
                    final Button button = (Button)editControl;
                    button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            CustomFormEditor.this.updatePropertyValue(prop, button.getSelection());
                        }
                    });
                }
            }
        }
        finally {
            this.isLoading = false;
        }
    }

    private void updatePropertyValue(DBPPropertyDescriptor prop, Object value) {
        if (!this.isLoading) {
            if (prop.getId().equals("name") && this.databaseObject != null && this.databaseObject.isPersisted()) {
                DBEObjectRenamer renamer = (DBEObjectRenamer)DBWorkbench.getPlatform().getEditorsRegistry().getObjectManager(this.propertySource.getEditableValue().getClass(), DBEObjectRenamer.class);
                if (this.commandContext != null && renamer != null) {
                    try {
                        LinkedHashMap<String, CustomFormEditor> options = new LinkedHashMap<String, CustomFormEditor>();
                        options.put("uiSource", this);
                        renamer.renameObject(this.commandContext, this.databaseObject, options, CommonUtils.toString((Object)UIUtils.normalizePropertyValue(value)));
                    }
                    catch (Throwable e) {
                        log.error((Object)"Error renaming object", e);
                    }
                }
            } else {
                Class dataType = prop.getDataType();
                if (value instanceof String) {
                    value = GeneralUtils.convertString((String)((String)UIUtils.normalizePropertyValue(value)), (Class)dataType);
                }
                this.propertySource.getPropertyValue(null, prop.getId());
                this.propertySource.setPropertyValue(null, prop.getId(), value);
            }
        }
    }

    public Control createEditorControl(Composite parent, Object object, DBPPropertyDescriptor property, Object value, boolean readOnly) {
        Class propType;
        Object propertyDisplayName = property.getDisplayName();
        if (property.isRequired()) {
            propertyDisplayName = (String)propertyDisplayName + " (*)";
        }
        if (!readOnly && property instanceof IPropertyValueListProvider) {
            ObjectPropertyDescriptor opd;
            IPropertyValueListProvider listProvider = (IPropertyValueListProvider)property;
            Object[] items = listProvider.getPossibleValues(object);
            if (items == null && property instanceof ObjectPropertyDescriptor && (opd = (ObjectPropertyDescriptor)property).hasListValueProvider()) {
                items = new Object[]{};
            }
            if (items != null) {
                String curValue;
                ArrayList<String> strings = new ArrayList<String>(items.length);
                int i = 0;
                int itemsLength = items.length;
                while (i < itemsLength) {
                    strings.add(CustomFormEditor.objectValueToString(items[i]));
                    ++i;
                }
                if (!property.isRequired()) {
                    strings.add(0, "");
                }
                if (!CommonUtils.isEmpty((String)(curValue = CustomFormEditor.objectValueToString(value))) && !strings.contains(curValue)) {
                    strings.add(curValue);
                }
                Combo combo = UIUtils.createLabelCombo(parent, (String)propertyDisplayName, 0x804 | (listProvider.allowCustomValue() ? 0 : 8) | (readOnly ? 8 : 0));
                String[] stringsArray = strings.toArray(new String[0]);
                combo.setItems(stringsArray);
                combo.setText(curValue);
                combo.setLayoutData((Object)new GridData(34));
                if ((combo.getStyle() & 8) == 0) {
                    StringContentProposalProvider proposalProvider = new StringContentProposalProvider(stringsArray);
                    ContentAssistUtils.installContentProposal((Control)combo, (IControlContentAdapter)new ComboContentAdapter(), proposalProvider);
                }
                return combo;
            }
        }
        if (DBSObject.class.isAssignableFrom(propType = property.getDataType()) || CustomFormEditor.isLinkProperty(property)) {
            UIUtils.createControlLabel(parent, (String)propertyDisplayName);
            Composite linkPH = new Composite(parent, 0);
            linkPH.setLayoutData((Object)new GridData(768));
            GridLayout layout = new GridLayout(1, false);
            layout.marginHeight = 1;
            linkPH.setLayout((Layout)layout);
            final Link link = new Link(linkPH, 0);
            link.setText(this.getLinktitle(value));
            link.setData(value);
            link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CustomFormEditor.this.openObjectLink(link.getData());
                }
            });
            link.setLayoutData((Object)new GridData(768));
            return link;
        }
        if (CustomFormEditor.isTextPropertyType(propType)) {
            if (property instanceof ObjectPropertyDescriptor && property.getLength() == PropertyLength.MULTILINE) {
                Label label = UIUtils.createControlLabel(parent, (String)propertyDisplayName);
                label.setLayoutData((Object)new GridData(2));
                ResizeableComposite editorHost = new ResizeableComposite(parent, 512);
                editorHost.setLayoutData(new GridData(4, 4, true, true));
                Text editor = new Text((Composite)editorHost, 0xA42 | (readOnly ? 8 : 0));
                editor.setText(CustomFormEditor.objectValueToString(value));
                int editorHeight = UIUtils.getTextHeight((Control)editor);
                editorHost.setMinSize(new Point(0, editorHeight));
                editorHost.setPrefSize(new Point(0, editorHeight * 4));
                editorHost.setContent((Control)editor);
                return editor;
            }
            Text text = UIUtils.createLabelText(parent, (String)propertyDisplayName, CustomFormEditor.objectValueToString(value), 0x800 | (readOnly ? 8 : 0) | (property instanceof ObjectPropertyDescriptor && ((ObjectPropertyDescriptor)property).isPassword() ? 0x400000 : 0));
            text.setLayoutData((Object)new GridData((BeanUtils.isNumericType((Class)propType) ? 32 : 768) | 2));
            return text;
        }
        if (BeanUtils.isBooleanType((Type)propType)) {
            if (this.curButtonsContainer == null) {
                UIUtils.createEmptyLabel(parent, 1, 1);
                this.curButtonsContainer = new Composite(parent, 0);
                RowLayout layout = new RowLayout(256);
                this.curButtonsContainer.setLayout((Layout)layout);
                GridData gd = new GridData(768);
                this.curButtonsContainer.setLayoutData((Object)gd);
            }
            Button editor = UIUtils.createCheckbox(this.curButtonsContainer, (String)propertyDisplayName, "", CommonUtils.toBoolean((Object)value), 1);
            if (readOnly) {
                editor.setEnabled(false);
            }
            return editor;
        }
        if (!readOnly && propType.isEnum()) {
            T[] enumConstants = propType.getEnumConstants();
            String[] strings = new String[enumConstants.length];
            int i = 0;
            int itemsLength = enumConstants.length;
            while (i < itemsLength) {
                strings[i] = ((Enum)enumConstants[i]).name();
                ++i;
            }
            Combo combo = UIUtils.createLabelCombo(parent, (String)propertyDisplayName, 0x80C | (readOnly ? 8 : 0));
            combo.setItems(strings);
            combo.setText(CustomFormEditor.objectValueToString(value));
            combo.setLayoutData((Object)new GridData(34));
            return combo;
        }
        return UIUtils.createLabelText(parent, (String)propertyDisplayName, CustomFormEditor.objectValueToString(value), 2056);
    }

    private static boolean isLinkProperty(DBPPropertyDescriptor property) {
        return property instanceof ObjectPropertyDescriptor && (((ObjectPropertyDescriptor)property).isLinkPossible() || ((ObjectPropertyDescriptor)property).isHref());
    }

    private String getLinktitle(Object value) {
        return value == null ? "N/A" : "<a>" + CustomFormEditor.objectValueToString(value) + "</a>";
    }

    public void loadEditorValues(Map<DBPPropertyDescriptor, Object> editorValues) {
        try {
            this.isLoading = true;
            if (this.propertySource != null) {
                Object object = this.propertySource.getEditableValue();
                for (Map.Entry<DBPPropertyDescriptor, Object> prop : editorValues.entrySet()) {
                    this.setEditorValue(object, prop.getKey(), prop.getValue());
                }
            }
        }
        finally {
            this.isLoading = false;
        }
    }

    public void setEditorValue(Object object, DBPPropertyDescriptor property, Object value) {
        Control editorControl = this.editorMap.get(property);
        Class propertyType = property.getDataType();
        String stringValue = CustomFormEditor.objectValueToString(value);
        if (editorControl instanceof Combo) {
            Combo combo = (Combo)editorControl;
            if (property instanceof IPropertyValueListProvider) {
                IPropertyValueListProvider listProvider = (IPropertyValueListProvider)property;
                Object[] items = listProvider.getPossibleValues(object);
                Object[] oldItems = (Object[])combo.getData(LIST_VALUE_KEY);
                combo.setData(LIST_VALUE_KEY, (Object)items);
                if (items != null) {
                    if (oldItems == null || !Arrays.equals(items, oldItems)) {
                        String[] strings = new String[items.length];
                        int i = 0;
                        int itemsLength = items.length;
                        while (i < itemsLength) {
                            strings[i] = items[i] instanceof DBPNamedObject ? ((DBPNamedObject)items[i]).getName() : CommonUtils.toString((Object)items[i]);
                            ++i;
                        }
                        combo.setItems(strings);
                    }
                    combo.setText(stringValue);
                }
            } else if (propertyType != null && propertyType.isEnum()) {
                if (combo.getItemCount() == 0) {
                    T[] enumConstants = propertyType.getEnumConstants();
                    String[] strings = new String[enumConstants.length];
                    int i = 0;
                    int itemsLength = enumConstants.length;
                    while (i < itemsLength) {
                        strings[i] = ((Enum)enumConstants[i]).name();
                        ++i;
                    }
                    combo.setItems(strings);
                }
                combo.setText(stringValue);
            }
        } else if (editorControl instanceof Text) {
            Text text = (Text)editorControl;
            if (!CommonUtils.equalObjects((Object)text.getText(), (Object)stringValue)) {
                text.setText(stringValue);
            }
        } else if (editorControl instanceof Button) {
            Button button = (Button)editorControl;
            button.setSelection(CommonUtils.toBoolean((Object)value));
        } else if (editorControl instanceof Link) {
            Link link = (Link)editorControl;
            link.setData(value);
            link.setText(this.getLinktitle(value));
        }
    }

    private static String objectValueToString(Object value) {
        if (value instanceof DBPQualifiedObject) {
            return ((DBPQualifiedObject)value).getFullyQualifiedName(DBPEvaluationContext.UI);
        }
        if (value instanceof DBPNamedObject) {
            return ((DBPNamedObject)value).getName();
        }
        if (value instanceof Enum) {
            return ((Enum)value).name();
        }
        return DBValueFormatting.getDefaultValueDisplayString((Object)value, (DBDDisplayFormat)DBDDisplayFormat.EDIT);
    }

    private static boolean isTextPropertyType(Class<?> propertyType) {
        return propertyType == null || CharSequence.class.isAssignableFrom(propertyType) || propertyType.getComponentType() != null && CharSequence.class.isAssignableFrom(propertyType.getComponentType()) || BeanUtils.isNumericType(propertyType);
    }

    public List<DBPPropertyDescriptor> filterProperties(DBPPropertyDescriptor[] props) {
        ArrayList<DBPPropertyDescriptor> result = new ArrayList<DBPPropertyDescriptor>();
        DBPPropertyDescriptor[] dBPPropertyDescriptorArray = props;
        int n = props.length;
        int n2 = 0;
        while (n2 < n) {
            DBPPropertyDescriptor prop = dBPPropertyDescriptorArray[n2];
            String category = prop.getCategory();
            if (CommonUtils.isEmpty((String)category)) {
                result.add(prop);
            }
            ++n2;
        }
        return result;
    }

    public boolean hasEditors() {
        return !this.editorMap.isEmpty();
    }

    public void clearEditors() {
        this.editorMap.clear();
        if (this.curButtonsContainer != null) {
            this.curButtonsContainer.dispose();
            this.curButtonsContainer = null;
        }
    }
}

