/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.ui.figures;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.draw2d.text.TextFlow;
import org.jkiss.dbeaver.erd.model.ERDNote;
import org.jkiss.dbeaver.erd.ui.editor.ERDThemeSettings;

public class NoteFigure
extends FlowPage {
    private final TextFlow textFlow;

    public NoteFigure(ERDNote note) {
        this.textFlow = new TextFlow((String)note.getObject());
        this.add((IFigure)this.textFlow);
        this.setBackgroundColor(ERDThemeSettings.instance.noteBackground);
        this.setForegroundColor(ERDThemeSettings.instance.noteForeground);
        this.setOpaque(true);
        this.setBorder((Border)new CompoundBorder((Border)new LineBorder(ERDThemeSettings.instance.linesForeground, 1), (Border)new MarginBorder(5)));
    }

    public TextFlow getTextFlow() {
        return this.textFlow;
    }

    public String getText() {
        return this.textFlow.getText();
    }

    public void setText(String text) {
        this.textFlow.setText(text);
    }

    public Dimension getPreferredSize(int width, int h) {
        Dimension currentSize = this.getSize();
        Dimension textPrefSize = this.textFlow.getPreferredSize(width, h);
        if (currentSize.width >= textPrefSize.width && currentSize.height >= textPrefSize.height) {
            return currentSize;
        }
        return textPrefSize;
    }

    public void setPreferredSize(Dimension size) {
        this.textFlow.setSize(size);
        this.textFlow.setPreferredSize(size);
        super.setPreferredSize(size);
    }
}

