/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.exasol.editors.ExasolSourceObject;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSource;
import org.jkiss.dbeaver.ext.exasol.model.ExasolSchema;
import org.jkiss.dbeaver.ext.exasol.model.dict.ExasolScriptLanguage;
import org.jkiss.dbeaver.ext.exasol.model.dict.ExasolScriptResultType;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.struct.AbstractProcedure;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedure;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureParameter;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;
import org.jkiss.utils.CommonUtils;

public class ExasolScript
extends AbstractProcedure<ExasolDataSource, ExasolSchema>
implements DBSProcedure,
DBPRefreshableObject,
ExasolSourceObject {
    private String remarks;
    private Timestamp createTime;
    private String owner;
    private ExasolScriptLanguage scriptLanguage;
    private String scriptSQL;
    private ExasolScriptResultType scriptReturnType;
    private String scriptType;
    private ExasolSchema exasolSchema;

    public ExasolScript(ExasolSchema schema, ResultSet dbResult) {
        super((DBSObjectContainer)schema, true);
        this.owner = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SCRIPT_OWNER");
        this.createTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"CREATED");
        this.remarks = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SCRIPT_COMMENT");
        this.scriptLanguage = (ExasolScriptLanguage)CommonUtils.valueOf(ExasolScriptLanguage.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SCRIPT_LANGUAGE"));
        this.scriptReturnType = (ExasolScriptResultType)CommonUtils.valueOf(ExasolScriptResultType.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SCRIPT_RESULT_TYPE"));
        this.scriptSQL = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SCRIPT_TEXT");
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SCRIPT_NAME");
        this.scriptType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SCRIPT_TYPE");
        this.exasolSchema = schema;
    }

    public ExasolScript(ExasolSchema schema) {
        super((DBSObjectContainer)schema, false);
        this.exasolSchema = schema;
        this.scriptSQL = "";
    }

    public ExasolScript refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.getContainer().scriptCache.clearCache();
        this.getContainer().scriptCache.getAllObjects(monitor, (DBSObject)this.getSchema());
        return (ExasolScript)this.getContainer().scriptCache.getObject(monitor, (DBSObject)this.exasolSchema, this.getName());
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, order=2)
    public ExasolSchema getSchema() {
        return this.exasolSchema;
    }

    @Property(viewable=true, order=5)
    public ExasolScriptLanguage getLanguage() {
        return this.scriptLanguage;
    }

    @Property(order=10)
    public ExasolScriptResultType getResultType() {
        return this.scriptReturnType;
    }

    @Property(viewable=true, editable=true, updatable=true, length=PropertyLength.MULTILINE, order=11)
    @Nullable
    public String getDescription() {
        return this.remarks;
    }

    @Property(order=12)
    @Nullable
    public String getType() {
        return this.scriptType;
    }

    @Property(hidden=true, editable=true, updatable=true)
    @NotNull
    public String getSql() {
        return this.scriptSQL;
    }

    @Property(viewable=true, order=6)
    @NotNull
    public Timestamp getCreationTime() {
        return this.createTime;
    }

    @Property(category="Owner")
    public String getOwner() {
        return this.owner;
    }

    public ExasolSchema getContainer() {
        return this.exasolSchema;
    }

    public DBSProcedureType getProcedureType() {
        if (CommonUtils.equalObjects((Object)this.scriptType, (Object)"SCRIPTING") || CommonUtils.equalObjects((Object)this.scriptType, (Object)"ADAPTER")) {
            return DBSProcedureType.PROCEDURE;
        }
        return DBSProcedureType.FUNCTION;
    }

    @Nullable
    public Collection<? extends DBSProcedureParameter> getParameters(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.getContainer(), this});
    }

    @Property(hidden=true, editable=true, updatable=true, order=-1)
    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        return this.scriptSQL;
    }

    @Override
    public void setObjectDefinitionText(String sourceText) throws DBException {
        this.scriptSQL = sourceText;
    }

    public void setDescription(String description) {
        this.remarks = description;
    }
}

