/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql;

import java.util.Objects;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.schema.Column;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeBindingMeta;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraint;
import org.jkiss.dbeaver.model.impl.sql.StandardSQLDialectQueryGenerator;
import org.jkiss.dbeaver.model.sql.parser.SQLSemanticProcessor;

public abstract class SQLGroupingAttribute {
    private static final Log log = Log.getLog(SQLGroupingAttribute.class);

    @NotNull
    public abstract String getDisplayName();

    @NotNull
    public abstract DBPDataSource getDataSource();

    @NotNull
    public abstract String prepareSqlString(@Nullable String var1);

    @NotNull
    public abstract Expression prepareExpression();

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public static SQLGroupingAttribute makeCustom(@NotNull DBPDataSource dataSource, @NotNull String expressionString) {
        return new CustomAttribute(dataSource, expressionString);
    }

    public static SQLGroupingAttribute makeBound(@NotNull DBDAttributeBinding attributeBinding) {
        return new BoundAttribute(attributeBinding);
    }

    public static class BoundAttribute
    extends SQLGroupingAttribute {
        @NotNull
        private final String displayName;
        @NotNull
        private final DBDAttributeBinding binding;

        public BoundAttribute(@NotNull DBDAttributeBinding binding) {
            this.displayName = BoundAttribute.getAttributeBindingName(binding);
            this.binding = binding;
        }

        private static String getAttributeBindingName(@NotNull DBDAttributeBinding binding) {
            if (binding instanceof DBDAttributeBindingMeta && binding.getMetaAttribute() != null) {
                return DBUtils.getQuotedIdentifier((DBPDataSource)binding.getDataSource(), (String)binding.getMetaAttribute().getLabel());
            }
            return binding.getFullyQualifiedName(DBPEvaluationContext.DML);
        }

        @Override
        @NotNull
        public String getDisplayName() {
            return this.displayName;
        }

        @Override
        @NotNull
        public DBPDataSource getDataSource() {
            return this.binding.getDataSource();
        }

        @NotNull
        public DBDAttributeBinding getBinding() {
            return this.binding;
        }

        @Override
        @NotNull
        public String prepareSqlString(@Nullable String subqueryAlias) {
            return StandardSQLDialectQueryGenerator.getConstraintAttributeName((DBPDataSource)this.getDataSource(), (String)subqueryAlias, (DBDAttributeConstraint)new DBDAttributeConstraint(this.binding), (subqueryAlias != null ? 1 : 0) != 0, (subqueryAlias != null ? 1 : 0) != 0);
        }

        @Override
        @NotNull
        public Expression prepareExpression() {
            return new Column(this.prepareSqlString(null));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(Object o) {
            void that;
            if (!(o instanceof BoundAttribute)) {
                return false;
            }
            BoundAttribute boundAttribute = (BoundAttribute)o;
            return Objects.equals(this.binding, that.binding);
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.displayName);
        }
    }

    public static class CustomAttribute
    extends SQLGroupingAttribute {
        @NotNull
        private final DBPDataSource dataSource;
        @NotNull
        private final String expressionString;

        public CustomAttribute(@NotNull DBPDataSource dataSource, @NotNull String expressionString) {
            this.dataSource = dataSource;
            this.expressionString = expressionString;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            return this.expressionString;
        }

        @Override
        @NotNull
        public DBPDataSource getDataSource() {
            return this.dataSource;
        }

        @NotNull
        public String getExpressionString() {
            return this.expressionString;
        }

        @Override
        @NotNull
        public String prepareSqlString(@Nullable String subqueryAlias) {
            try {
                Expression expression = SQLSemanticProcessor.parseExpression((String)this.expressionString);
                if (!(expression instanceof Column)) {
                    return this.expressionString;
                }
            }
            catch (DBException e) {
                log.debug((Object)("Can't parse expression " + this.expressionString), (Throwable)e);
            }
            return DBUtils.getQuotedIdentifier((DBPDataSource)this.dataSource, (String)this.expressionString);
        }

        @Override
        @NotNull
        public Expression prepareExpression() {
            try {
                return SQLSemanticProcessor.parseExpression((String)this.expressionString);
            }
            catch (DBException e) {
                log.debug((Object)("Can't parse expression " + this.expressionString), (Throwable)e);
                return new Column(DBUtils.getQuotedIdentifier((DBPDataSource)this.dataSource, (String)this.expressionString));
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(Object o) {
            void that;
            if (!(o instanceof CustomAttribute)) {
                return false;
            }
            CustomAttribute customAttribute = (CustomAttribute)o;
            return Objects.equals(this.expressionString, that.expressionString);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.expressionString);
        }
    }
}

