/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model.dml;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.antlr.v4.runtime.misc.Interval;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.impl.struct.RelationalObjectType;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryLexicalScope;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryModelRecognizer;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryQualifiedName;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolOrigin;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryModelContent;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.sql.semantics.model.ddl.SQLQueryObjectDataModel;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueExpression;
import org.jkiss.dbeaver.model.stm.STMKnownRuleNames;
import org.jkiss.dbeaver.model.stm.STMTreeNode;
import org.jkiss.dbeaver.model.struct.DBSObjectType;

public class SQLQueryCallModel
extends SQLQueryModelContent {
    @Nullable
    private final SQLQueryObjectDataModel object;
    @NotNull
    private final List<SQLQueryValueExpression> expressions;
    @Nullable
    private final SQLQueryLexicalScope nameScope;
    @Nullable
    private final SQLQueryLexicalScope tailScope;
    @Nullable
    private SQLQueryDataContext dataContext = null;

    private SQLQueryCallModel(@NotNull STMTreeNode syntaxNode, @Nullable SQLQueryObjectDataModel object, @NotNull List<SQLQueryValueExpression> expressions, @Nullable SQLQueryLexicalScope nameScope, @Nullable SQLQueryLexicalScope tailScope) {
        super(syntaxNode.getRealInterval(), syntaxNode, (SQLQueryNodeModel[])expressions.toArray(SQLQueryNodeModel[]::new));
        this.object = object;
        this.expressions = expressions;
        this.nameScope = nameScope;
        this.tailScope = tailScope;
        if (object != null) {
            this.registerSubnode(object);
        }
        if (nameScope != null) {
            this.registerLexicalScope(nameScope);
        }
    }

    @Nullable
    public SQLQueryObjectDataModel getObject() {
        return this.object;
    }

    @Override
    @Nullable
    public SQLQueryDataContext getResultDataContext() {
        return this.dataContext;
    }

    @Override
    @Nullable
    public SQLQueryDataContext getGivenDataContext() {
        return this.dataContext;
    }

    @NotNull
    public List<SQLQueryValueExpression> getExpressions() {
        return this.expressions;
    }

    @Override
    protected void applyContext(@NotNull SQLQueryDataContext dataContext, @NotNull SQLQueryRecognitionContext recognitionContext) {
        this.dataContext = dataContext;
        if (this.object != null) {
            this.object.propagateContext(dataContext, recognitionContext);
        }
        if (this.nameScope != null) {
            this.nameScope.setSymbolsOrigin(new SQLQuerySymbolOrigin.DbObjectFromContext(dataContext, Set.of(RelationalObjectType.TYPE_PROCEDURE, RelationalObjectType.TYPE_PACKAGE), false));
        }
        if (this.tailScope != null) {
            this.setTailOrigin(this.tailScope.getSymbolsOrigin());
        }
    }

    @Override
    @Nullable
    protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, @NotNull T arg) {
        return visitor.visitCallStatement(this, arg);
    }

    @NotNull
    public static SQLQueryModelContent recognize(@NotNull SQLQueryModelRecognizer recognizer, @NotNull STMTreeNode node, @NotNull DBSObjectType objectType) {
        List<SQLQueryValueExpression> exprs;
        SQLQueryLexicalScope tailScope;
        SQLQueryObjectDataModel procedure;
        SQLQueryLexicalScope nameScope;
        Throwable throwable = null;
        Object var6_5 = null;
        try (SQLQueryModelRecognizer.LexicalScopeHolder h = recognizer.openScope();){
            nameScope = h.lexicalScope;
            STMTreeNode nameNode = node.findFirstChildOfName(STMKnownRuleNames.qualifiedName);
            SQLQueryQualifiedName name = nameNode == null ? null : recognizer.collectQualifiedName(nameNode);
            procedure = name == null ? null : new SQLQueryObjectDataModel(nameNode, name, RelationalObjectType.TYPE_PROCEDURE, Set.of(RelationalObjectType.TYPE_PACKAGE));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        STMTreeNode paramsNode = node.findLastChildOfName(STMKnownRuleNames.callStatementParams);
        if (paramsNode == null) {
            tailScope = procedure == null ? nameScope : null;
            exprs = Collections.emptyList();
        } else {
            tailScope = null;
            exprs = paramsNode.findChildrenOfName(STMKnownRuleNames.anyValue).stream().map(recognizer::collectValueExpression).toList();
        }
        STMTreeNode firstKeyword = node.findLastNonErrorChild();
        if (firstKeyword != null) {
            nameScope.setInterval(Interval.of((int)(firstKeyword.getRealInterval().b + 2), (int)(paramsNode == null ? Integer.MAX_VALUE : paramsNode.getRealInterval().a - 1)));
        }
        return new SQLQueryCallModel(node, procedure, exprs, nameScope, tailScope);
    }
}

