/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.cubrid.model.meta;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.cubrid.model.CubridDataSource;
import org.jkiss.dbeaver.ext.cubrid.model.CubridProcedure;
import org.jkiss.dbeaver.ext.cubrid.model.CubridSequence;
import org.jkiss.dbeaver.ext.cubrid.model.CubridSynonym;
import org.jkiss.dbeaver.ext.cubrid.model.CubridTable;
import org.jkiss.dbeaver.ext.cubrid.model.CubridTrigger;
import org.jkiss.dbeaver.ext.cubrid.model.CubridUser;
import org.jkiss.dbeaver.ext.cubrid.model.CubridView;
import org.jkiss.dbeaver.ext.cubrid.model.QueryTransformerLimitCubrid;
import org.jkiss.dbeaver.ext.cubrid.model.plan.CubridQueryPlanner;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericObjectContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericProcedure;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericSequence;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericSynonym;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericTableConstraintColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericUniqueKey;
import org.jkiss.dbeaver.ext.generic.model.GenericView;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaObject;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformProvider;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformType;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformer;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlanner;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTableConstraint;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.format.SQLFormatUtils;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;

public class CubridMetaModel
extends GenericMetaModel
implements DBCQueryTransformProvider {
    private static final Log log = Log.getLog(CubridMetaModel.class);

    @Nullable
    public String getTableOrViewName(@Nullable GenericTableBase base) {
        if (base != null) {
            if (base.isView()) {
                return ((CubridView)base).getUniqueName();
            }
            return ((CubridTable)base).getUniqueName();
        }
        return null;
    }

    @Nullable
    public List<GenericSchema> loadSchemas(@NotNull JDBCSession session, @NotNull GenericDataSource dataSource, @Nullable GenericCatalog catalog) throws DBException {
        ArrayList<GenericSchema> users = new ArrayList<GenericSchema>();
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (JDBCPreparedStatement dbStat = session.prepareStatement("select * from db_user");){
                dbStat.executeStatement();
                Throwable throwable2 = null;
                Object var9_13 = null;
                try (JDBCResultSet dbResult = dbStat.getResultSet();){
                    while (dbResult.next()) {
                        String name = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"name");
                        String description = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"comment");
                        CubridUser user = new CubridUser(dataSource, name, description);
                        users.add(user);
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            log.error((Object)"Cannot load user", (Throwable)e);
        }
        return users;
    }

    @NotNull
    public JDBCStatement prepareTableLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @Nullable GenericTableBase object, @Nullable String objectName) throws SQLException {
        String sql = "select a.*,a.class_name as TABLE_NAME, case when class_type = 'CLASS' then 'TABLE'\r\n when class_type = 'VCLASS' then 'VIEW' end as TABLE_TYPE,\r\n a.comment as REMARKS, b.current_val from db_class a LEFT JOIN\r\n db_serial b on a.class_name = b.class_name\r\n left join db_partition p on a.class_name = p.partition_class_name\r\n where a.owner_name = ? and p.partition_class_name is null";
        JDBCPreparedStatement dbStat = session.prepareStatement(sql);
        dbStat.setString(1, owner.getName());
        return dbStat;
    }

    @NotNull
    public JDBCStatement prepareTableColumnLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @Nullable GenericTableBase forTable) throws SQLException {
        boolean multiSchema = forTable != null && ((CubridDataSource)forTable.getDataSource()).getSupportMultiSchema();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT a.*, a.def_order + 1 AS ref_order, i.is_foreign_key FROM db_attribute a LEFT JOIN (SELECT k.key_attr_name AS attr_name, i.class_name, i.is_foreign_key " + (multiSchema ? ", i.owner_name " : "") + "FROM db_index i JOIN db_index_key k ON i.index_name = k.index_name WHERE i.is_foreign_key = 'YES') i ON a.class_name = i.class_name AND a.attr_name = i.attr_name " + (multiSchema ? "AND a.owner_name = i.owner_name " : ""));
        if (forTable != null) {
            sql.append("WHERE a.class_name = ? ");
            if (multiSchema) {
                sql.append("AND a.owner_name = ? ");
            }
        }
        sql.append("ORDER BY def_order");
        JDBCPreparedStatement dbStat = session.prepareStatement(sql.toString());
        if (forTable != null) {
            dbStat.setString(1, forTable.getName());
            if (multiSchema) {
                dbStat.setString(2, owner.getName());
            }
        }
        return dbStat;
    }

    @NotNull
    public boolean supportsUniqueKeys() {
        return true;
    }

    @NotNull
    public JDBCStatement prepareUniqueConstraintsLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @Nullable GenericTableBase forTable) throws SQLException, DBException {
        CubridTable table = (CubridTable)forTable;
        String sql = "select *, t1.index_name as PK_NAME from db_index t1 join db_index_key t2 \non t1.index_name = t2.index_name where is_unique = 'YES' and t1.class_name = ? \n" + (table.getDataSource().getSupportMultiSchema() ? "and t1.owner_name = ?" : "");
        JDBCPreparedStatement dbStat = session.prepareStatement(sql);
        dbStat.setString(1, table.getName());
        if (table.getDataSource().getSupportMultiSchema()) {
            dbStat.setString(2, table.getSchema().getName());
        }
        return dbStat;
    }

    @Nullable
    public GenericTableConstraintColumn[] createConstraintColumnsImpl(@NotNull JDBCSession session, @NotNull GenericTableBase parent, @Nullable GenericUniqueKey object, @Nullable GenericMetaObject pkObject, @NotNull JDBCResultSet dbResult) throws DBException {
        String name = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"key_attr_name");
        Integer keyOrder = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"key_order") + 1;
        GenericTableColumn tableColumn = parent.getAttribute(session.getProgressMonitor(), name);
        return new GenericTableConstraintColumn[]{new GenericTableConstraintColumn((JDBCTableConstraint)object, tableColumn, keyOrder.intValue())};
    }

    @NotNull
    public DBSEntityConstraintType getUniqueConstraintType(@NotNull JDBCResultSet dbResult) throws DBException {
        String isPrimary = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"is_primary_key");
        if (isPrimary.equals("YES")) {
            return DBSEntityConstraintType.PRIMARY_KEY;
        }
        return DBSEntityConstraintType.UNIQUE_KEY;
    }

    @NotNull
    public JDBCStatement prepareForeignKeysLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @Nullable GenericTableBase forTable) throws SQLException {
        return session.getMetaData().getImportedKeys(null, null, this.getTableOrViewName(forTable)).getSourceStatement();
    }

    @Nullable
    public GenericTableBase createTableImpl(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @NotNull GenericMetaObject tableObject, @NotNull JDBCResultSet dbResult) {
        String tableName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABLE_NAME");
        String tableType = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"TABLE_TYPE");
        GenericTableBase table = this.createTableOrViewImpl(owner, tableName, tableType, dbResult);
        return table;
    }

    @Nullable
    public GenericTableBase createTableOrViewImpl(@NotNull GenericStructContainer container, @Nullable String tableName, @Nullable String tableType, @Nullable JDBCResultSet dbResult) {
        if (tableType != null && this.isView(tableType)) {
            return new CubridView(container, tableName, tableType, dbResult);
        }
        return new CubridTable(container, tableName, tableType, dbResult);
    }

    @NotNull
    public boolean isTableCommentEditable() {
        return true;
    }

    @NotNull
    public boolean isTableColumnCommentEditable() {
        return true;
    }

    @NotNull
    public JDBCStatement prepareSequencesLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer container) throws SQLException {
        String sql = "select *, owner.name from db_serial where owner.name = ?";
        JDBCPreparedStatement dbStat = session.prepareStatement(sql);
        dbStat.setString(1, container.getName());
        return dbStat;
    }

    @Nullable
    public GenericSequence createSequenceImpl(@NotNull JDBCSession session, @NotNull GenericStructContainer container, @NotNull JDBCResultSet dbResult) throws DBException {
        String name = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"name");
        return new CubridSequence(container, name, dbResult);
    }

    @NotNull
    public JDBCStatement prepareSynonymsLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer container) throws SQLException {
        String sql = "select * from db_synonym where synonym_owner_name = ?";
        JDBCPreparedStatement dbStat = session.prepareStatement(sql);
        dbStat.setString(1, container.getName());
        return dbStat;
    }

    @Nullable
    public GenericSynonym createSynonymImpl(@NotNull JDBCSession session, @NotNull GenericStructContainer container, @NotNull JDBCResultSet dbResult) throws DBException {
        String name = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"synonym_name");
        String description = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"comment");
        return new CubridSynonym(container, name, description, dbResult);
    }

    @NotNull
    public boolean supportsDatabaseTriggers(@NotNull GenericDataSource dataSource) {
        return true;
    }

    @NotNull
    public boolean supportsTriggers(@NotNull GenericDataSource dataSource) {
        return true;
    }

    @NotNull
    public JDBCStatement prepareTableTriggersLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer container, @Nullable GenericTableBase table) throws SQLException {
        boolean supportMultiSchema = ((CubridDataSource)table.getDataSource()).getSupportMultiSchema();
        String sql = "select t1.*, t2.*, t1.owner.name from db_trigger as t1, db_trig as t2 \nwhere t1.name = t2.trigger_name and t1.owner.name = ? and t2.target_class_name = ? \n" + (supportMultiSchema ? "and t1.owner.name = t2.owner_name" : "");
        JDBCPreparedStatement dbStat = session.prepareStatement(sql);
        dbStat.setString(1, container.getName());
        dbStat.setString(2, table.getName());
        return dbStat;
    }

    @Nullable
    public CubridTrigger createTableTriggerImpl(@NotNull JDBCSession session, @NotNull GenericStructContainer container, @Nullable GenericTableBase table, @Nullable String triggerName, @NotNull JDBCResultSet dbResult) throws DBException {
        String name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"name");
        String description = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"comment");
        return new CubridTrigger(table, name, description, dbResult);
    }

    @NotNull
    public JDBCStatement prepareContainerTriggersLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer container) throws SQLException {
        boolean supportMultiSchema = ((CubridDataSource)container.getDataSource()).getSupportMultiSchema();
        String sql = "select t1.*, t2.*, t1.owner.name from db_trigger as t1, db_trig as t2 \nwhere t1.name = t2.trigger_name and t1.owner.name = ?\n" + (supportMultiSchema ? "and t1.owner.name = t2.owner_name" : "");
        JDBCPreparedStatement dbStat = session.prepareStatement(sql);
        dbStat.setString(1, container.getName());
        return dbStat;
    }

    @Nullable
    public CubridTrigger createContainerTriggerImpl(@NotNull GenericStructContainer container, @NotNull JDBCResultSet dbResult) throws DBException {
        String name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"name");
        String description = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"comment");
        String tableName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"target_class_name");
        String owner = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"target_owner_name");
        DBRProgressMonitor monitor = dbResult.getSession().getProgressMonitor();
        CubridTable cubridTable = (CubridTable)container.getDataSource().findTable(monitor, null, owner, tableName);
        return new CubridTrigger((GenericTableBase)cubridTable, name, description, dbResult);
    }

    public void loadProcedures(@NotNull DBRProgressMonitor monitor, @NotNull GenericObjectContainer container) throws DBException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)container, (String)"Load procedures");){
                String sql = "select * from db_stored_procedure where owner = ?";
                Throwable throwable2 = null;
                Object var8_12 = null;
                try (JDBCPreparedStatement dbStat = session.prepareStatement(sql);){
                    dbStat.setString(1, container.getName());
                    Throwable throwable3 = null;
                    Object var11_17 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        while (dbResult.next()) {
                            String procedureName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"sp_name");
                            String description = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"comment");
                            String type = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"sp_type");
                            String returnType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"return_type");
                            DBSProcedureType procedureType = type.equalsIgnoreCase("PROCEDURE") ? DBSProcedureType.PROCEDURE : (type.equalsIgnoreCase("FUNCTION") ? DBSProcedureType.FUNCTION : DBSProcedureType.UNKNOWN);
                            container.addProcedure((GenericProcedure)new CubridProcedure((GenericStructContainer)container, procedureName, description, procedureType, returnType));
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException("Load procedures failed", (Throwable)e);
        }
    }

    @Nullable
    public String getViewDDL(@NotNull DBRProgressMonitor monitor, @NotNull GenericView object, @NotNull Map<String, Object> options) throws DBException {
        Object ddl = "-- View definition not available";
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)object, (String)"Load view ddl");){
                String sql = String.format("show create view %s", ((CubridView)object).getUniqueName());
                Throwable throwable2 = null;
                Object var10_14 = null;
                try (JDBCPreparedStatement dbStat = session.prepareStatement(sql);){
                    Throwable throwable3 = null;
                    Object var13_19 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        if (dbResult.next()) {
                            ddl = "create or replace view " + dbResult.getString("View") + " as " + dbResult.getString("Create View");
                            ddl = SQLFormatUtils.formatSQL((DBPDataSource)object.getDataSource(), (String)ddl);
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            log.error((Object)"Cannot load view ddl", (Throwable)e);
        }
        return ddl;
    }

    public DBCQueryPlanner getQueryPlanner(@NotNull GenericDataSource dataSource) {
        return new CubridQueryPlanner((CubridDataSource)dataSource);
    }

    @Nullable
    public DBCQueryTransformer createQueryTransformer(@NotNull DBCQueryTransformType type) {
        if (type == DBCQueryTransformType.RESULT_SET_LIMIT) {
            return new QueryTransformerLimitCubrid();
        }
        return null;
    }
}

