/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.api.DriverReference;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBConfigurationController;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceOriginProvider;
import org.jkiss.dbeaver.model.DBPDataSourcePermission;
import org.jkiss.dbeaver.model.WorkspaceConfigEventManager;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPRegistryListener;
import org.jkiss.dbeaver.model.connection.DBPAuthModelDescriptor;
import org.jkiss.dbeaver.model.connection.DBPConnectionType;
import org.jkiss.dbeaver.model.connection.DBPDataSourceProviderDescriptor;
import org.jkiss.dbeaver.model.connection.DBPDataSourceProviderRegistry;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPDriverLoader;
import org.jkiss.dbeaver.model.connection.DBPDriverSubstitutionDescriptor;
import org.jkiss.dbeaver.model.connection.DBPEditorContribution;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.model.impl.preferences.SimplePreferenceStore;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceListener;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.registry.DataSourceAuthModelDescriptor;
import org.jkiss.dbeaver.registry.DataSourceConfigurationStorageDescriptor;
import org.jkiss.dbeaver.registry.DataSourceHandlerDescriptor;
import org.jkiss.dbeaver.registry.DataSourceOriginProviderDescriptor;
import org.jkiss.dbeaver.registry.DataSourceProviderDescriptor;
import org.jkiss.dbeaver.registry.DataSourceRegistry;
import org.jkiss.dbeaver.registry.DriverSubstitutionDescriptor;
import org.jkiss.dbeaver.registry.EditorContributionDescriptor;
import org.jkiss.dbeaver.registry.ExternalResourceDescriptor;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.registry.driver.DriverDescriptorSerializerLegacy;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.xml.SAXListener;
import org.jkiss.utils.xml.SAXReader;
import org.jkiss.utils.xml.XMLBuilder;
import org.jkiss.utils.xml.XMLException;
import org.xml.sax.Attributes;

public class DataSourceProviderRegistry
implements DBPDataSourceProviderRegistry {
    private static final Log log = Log.getLog(DataSourceProviderRegistry.class);
    private static DataSourceProviderRegistry instance = null;
    private final List<DataSourceProviderDescriptor> dataSourceProviders = new ArrayList<DataSourceProviderDescriptor>();
    private final Map<String, DataSourceProviderDescriptor> dataSourceProvidersMap = new HashMap<String, DataSourceProviderDescriptor>();
    private final List<DBPRegistryListener> registryListeners = new ArrayList<DBPRegistryListener>();
    private final List<DataSourceHandlerDescriptor> dataSourceHandlers = new ArrayList<DataSourceHandlerDescriptor>();
    private final Map<String, DBPConnectionType> connectionTypes = new LinkedHashMap<String, DBPConnectionType>();
    private final Map<String, ExternalResourceDescriptor> resourceContributions = new LinkedHashMap<String, ExternalResourceDescriptor>();
    private final List<EditorContributionDescriptor> editorContributors = new ArrayList<EditorContributionDescriptor>();
    private final Map<String, List<EditorContributionDescriptor>> contributionCategoryMap = new HashMap<String, List<EditorContributionDescriptor>>();
    private final Map<String, DataSourceAuthModelDescriptor> authModels = new LinkedHashMap<String, DataSourceAuthModelDescriptor>();
    private final List<DataSourceConfigurationStorageDescriptor> dataSourceConfigurationStorageDescriptors = new ArrayList<DataSourceConfigurationStorageDescriptor>();
    private final DBPPreferenceStore globalDataSourcePreferenceStore;
    private final Map<String, DataSourceOriginProviderDescriptor> dataSourceOrigins = new LinkedHashMap<String, DataSourceOriginProviderDescriptor>();
    private final Map<String, DBPDriverSubstitutionDescriptor> driverSubstitutions = new HashMap<String, DBPDriverSubstitutionDescriptor>();

    public static synchronized DataSourceProviderRegistry getInstance() {
        if (instance == null) {
            instance = new DataSourceProviderRegistry();
            instance.loadExtensions(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private DataSourceProviderRegistry() {
        this.globalDataSourcePreferenceStore = new SimplePreferenceStore(){

            public void addPropertyChangeListener(DBPPreferenceListener listener) {
                super.addPropertyChangeListener(listener);
            }

            public void removePropertyChangeListener(DBPPreferenceListener listener) {
                super.removePropertyChangeListener(listener);
            }

            public void save() throws IOException {
            }
        };
        WorkspaceConfigEventManager.addConfigChangedListener((String)"drivers.xml", o -> {
            for (DataSourceProviderDescriptor dataSourceProvider : this.dataSourceProviders) {
                dataSourceProvider.removeCustomAndDisabledDrivers();
            }
            this.readDriversConfig();
        });
    }

    private void loadExtensions(IExtensionRegistry registry) {
        Object descriptor;
        AbstractDescriptor provider;
        IConfigurationElement ext;
        IConfigurationElement[] extElements = registry.getConfigurationElementsFor("org.jkiss.dbeaver.dataSourceProvider");
        Arrays.sort(extElements, (o1, o2) -> {
            String p2;
            String p1 = o1.getAttribute("parent");
            if (CommonUtils.equalObjects((Object)p1, (Object)(p2 = o2.getAttribute("parent")))) {
                return 0;
            }
            if (p1 == null) {
                return -1;
            }
            if (p2 == null) {
                return 1;
            }
            return 0;
        });
        IConfigurationElement[] iConfigurationElementArray = extElements;
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            ext = iConfigurationElementArray[n2];
            switch (ext.getName()) {
                case "datasource": {
                    provider = new DataSourceProviderDescriptor(this, ext);
                    this.dataSourceProviders.add((DataSourceProviderDescriptor)provider);
                    this.dataSourceProvidersMap.put(provider.getId(), (DataSourceProviderDescriptor)provider);
                    break;
                }
                case "datasourceOrigin": {
                    provider = new DataSourceOriginProviderDescriptor(ext);
                    this.dataSourceOrigins.put(provider.getId(), (DataSourceOriginProviderDescriptor)provider);
                }
            }
            ++n2;
        }
        iConfigurationElementArray = extElements;
        n = extElements.length;
        n2 = 0;
        while (n2 < n) {
            ext = iConfigurationElementArray[n2];
            switch (ext.getName()) {
                case "datasource": {
                    provider = this.getDataSourceProvider(ext.getAttribute("id"));
                    if (provider == null) break;
                    provider.linkParentProvider(ext);
                    break;
                }
                case "datasourcePatch": {
                    String dsId = ext.getAttribute("id");
                    DataSourceProviderDescriptor dataSourceProvider = this.getDataSourceProvider(dsId);
                    if (dataSourceProvider != null) {
                        dataSourceProvider.patchConfigurationFrom(ext);
                        break;
                    }
                    log.warn((Object)("Datasource '" + dsId + "' not found for patch"));
                    break;
                }
                case "datasourceReplace": {
                    String providerId = ext.getAttribute("provider");
                    String providerClass = ext.getAttribute("class");
                    if (providerId == null || providerClass == null) break;
                    DataSourceProviderDescriptor provider2 = this.getDataSourceProvider(providerId);
                    if (provider2 == null) {
                        log.error((Object)("Cannot replace provider '" + providerId + "' - bad provider ID"));
                        break;
                    }
                    provider2.replaceImplClass(ext.getContributor(), providerClass);
                    break;
                }
                case "editorContribution": {
                    Object descriptor2 = new EditorContributionDescriptor(ext);
                    this.editorContributors.add((EditorContributionDescriptor)((Object)descriptor2));
                    List list = this.contributionCategoryMap.computeIfAbsent(((EditorContributionDescriptor)((Object)descriptor2)).getCategory(), k -> new ArrayList());
                    list.add(descriptor2);
                    break;
                }
                case "driverSubstitution": {
                    Object descriptor2 = new DriverSubstitutionDescriptor(ext);
                    this.driverSubstitutions.put(descriptor2.getId(), (DBPDriverSubstitutionDescriptor)descriptor2);
                }
            }
            ++n2;
        }
        iConfigurationElementArray = extElements;
        n = extElements.length;
        n2 = 0;
        while (n2 < n) {
            DataSourceProviderDescriptor provider3;
            ext = iConfigurationElementArray[n2];
            if ("datasource".equals(ext.getName()) && (provider3 = this.getDataSourceProvider(ext.getAttribute("id"))) != null) {
                provider3.loadExtraConfig(ext);
            }
            ++n2;
        }
        this.dataSourceProviders.sort((o1, o2) -> {
            if (o1.isDriversManagable() && !o2.isDriversManagable()) {
                return 1;
            }
            if (o2.isDriversManagable() && !o1.isDriversManagable()) {
                return -1;
            }
            return o1.getName().compareToIgnoreCase(o2.getName());
        });
        this.readDriversConfig();
        DBPConnectionType[] dBPConnectionTypeArray = DBPConnectionType.SYSTEM_TYPES;
        n2 = DBPConnectionType.SYSTEM_TYPES.length;
        int ext2 = 0;
        while (ext2 < n2) {
            DBPConnectionType ct = dBPConnectionTypeArray[ext2];
            this.connectionTypes.put(ct.getId(), ct);
            ++ext2;
        }
        this.loadConnectionTypes();
        iConfigurationElementArray = extElements = registry.getConfigurationElementsFor("org.jkiss.dbeaver.resources");
        int n3 = extElements.length;
        n2 = 0;
        while (n2 < n3) {
            IConfigurationElement ext3 = iConfigurationElementArray[n2];
            ExternalResourceDescriptor resource = new ExternalResourceDescriptor(ext3);
            this.resourceContributions.put(resource.getName(), resource);
            if (!CommonUtils.isEmpty((String)resource.getAlias())) {
                String[] stringArray = resource.getAlias().split(",");
                int n4 = stringArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    String alias = stringArray[n5];
                    this.resourceContributions.put(alias, resource);
                    ++n5;
                }
            }
            ++n2;
        }
        iConfigurationElementArray = extElements = registry.getConfigurationElementsFor("org.jkiss.dbeaver.dataSourceHandler");
        n3 = extElements.length;
        n2 = 0;
        while (n2 < n3) {
            IConfigurationElement ext4 = iConfigurationElementArray[n2];
            descriptor = new DataSourceHandlerDescriptor(ext4);
            this.dataSourceHandlers.add((DataSourceHandlerDescriptor)((Object)descriptor));
            ++n2;
        }
        iConfigurationElementArray = extElements = registry.getConfigurationElementsFor("org.jkiss.dbeaver.dataSourceAuth");
        n3 = extElements.length;
        n2 = 0;
        while (n2 < n3) {
            IConfigurationElement ext5 = iConfigurationElementArray[n2];
            descriptor = new DataSourceAuthModelDescriptor(ext5);
            this.authModels.put(descriptor.getId(), (DataSourceAuthModelDescriptor)((Object)descriptor));
            ++n2;
        }
        iConfigurationElementArray = extElements = registry.getConfigurationElementsFor("org.jkiss.dbeaver.dataSourceStorage");
        n3 = extElements.length;
        n2 = 0;
        while (n2 < n3) {
            IConfigurationElement ext6 = iConfigurationElementArray[n2];
            descriptor = new DataSourceConfigurationStorageDescriptor(ext6);
            this.dataSourceConfigurationStorageDescriptors.add((DataSourceConfigurationStorageDescriptor)((Object)descriptor));
            ++n2;
        }
    }

    public void readDriversConfig() {
        String providedDriversConfig = System.getProperty("dbeaver.drivers.configuration-file");
        if (!CommonUtils.isEmpty((String)providedDriversConfig)) {
            Path configFile = Path.of(providedDriversConfig, new String[0]);
            if (Files.exists(configFile, new LinkOption[0])) {
                log.debug((Object)("Loading provided drivers configuration from '" + String.valueOf(configFile.toAbsolutePath()) + "'"));
                this.loadDrivers(providedDriversConfig, true);
            } else {
                log.debug((Object)("Provided drivers configuration file '" + String.valueOf(configFile.toAbsolutePath()) + "' doesn't exist"));
            }
        }
        this.loadDrivers("drivers.xml", false);
        ArrayList<DriverDescriptor> allDrivers = new ArrayList<DriverDescriptor>();
        for (DataSourceProviderDescriptor provider : this.dataSourceProviders) {
            allDrivers.addAll(provider.getDrivers());
        }
        for (DriverDescriptor driver1 : allDrivers) {
            for (DriverDescriptor driver2 : allDrivers) {
                if (driver1 == driver2 || !driver1.replaces(driver2)) continue;
                driver2.setReplacedBy(driver1);
            }
        }
        this.dataSourceProviders.forEach(DataSourceProviderDescriptor::setDriverProviderProperties);
        int driverCount = 0;
        int customDriverCount = 0;
        for (DataSourceProviderDescriptor pd : this.dataSourceProviders) {
            for (DBPDriver dBPDriver : pd.getDrivers()) {
                if (dBPDriver.isDisabled() || dBPDriver.getReplacedBy() != null) continue;
                ++driverCount;
                if (!dBPDriver.isCustom()) continue;
                ++customDriverCount;
            }
        }
        log.debug((Object)("Total database drivers: " + driverCount + " (" + (driverCount - customDriverCount) + ")"));
    }

    public static void dispose() {
        if (instance != null) {
            instance.dispose0();
            instance = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispose0() {
        List<DBPRegistryListener> list = this.registryListeners;
        synchronized (list) {
            if (!this.registryListeners.isEmpty()) {
                log.warn((Object)("Some datasource registry listeners are still registered: " + String.valueOf(this.registryListeners)));
            }
            this.registryListeners.clear();
        }
        for (DataSourceProviderDescriptor providerDescriptor : this.dataSourceProviders) {
            providerDescriptor.dispose();
        }
        this.dataSourceProviders.clear();
        this.resourceContributions.clear();
        this.dataSourceConfigurationStorageDescriptors.clear();
    }

    @Nullable
    public DataSourceProviderDescriptor getDataSourceProvider(String id) {
        return this.dataSourceProvidersMap.get(id);
    }

    public DBPDataSourceProviderDescriptor makeFakeProvider(String providerID) {
        DataSourceProviderDescriptor provider = new DataSourceProviderDescriptor(this, providerID);
        this.dataSourceProviders.add(provider);
        this.dataSourceProvidersMap.put(providerID, provider);
        return provider;
    }

    public List<DataSourceProviderDescriptor> getDataSourceProviders() {
        return this.dataSourceProviders;
    }

    public List<DBPDataSourceProviderDescriptor> getEnabledDataSourceProviders() {
        ArrayList<DBPDataSourceProviderDescriptor> enabled = new ArrayList<DBPDataSourceProviderDescriptor>(this.dataSourceProviders);
        return enabled;
    }

    @Nullable
    public DBPDriver findDriver(@NotNull DriverReference ref) {
        return this.findDriver(ref.shortId());
    }

    @Nullable
    public DBPDriver findDriver(@NotNull String driverIdOrName) {
        DataSourceProviderDescriptor dsProvider;
        String[] driverPath;
        DBPDriver driver = null;
        if (driverIdOrName.contains(":") && (driverPath = driverIdOrName.split(":")).length == 2 && (dsProvider = this.getDataSourceProvider(driverPath[0])) != null) {
            driver = dsProvider.getDriver(driverPath[1]);
        }
        if (driver == null) {
            for (DataSourceProviderDescriptor pd : this.dataSourceProviders) {
                driver = pd.getDriver(driverIdOrName);
                if (driver != null) break;
            }
        }
        if (driver == null) {
            for (DataSourceProviderDescriptor pd : this.dataSourceProviders) {
                for (DBPDriver dBPDriver : pd.getDrivers()) {
                    if (!dBPDriver.getName().equalsIgnoreCase(driverIdOrName)) continue;
                    driver = dBPDriver;
                }
            }
        }
        if (driver != null) {
            while (driver.getReplacedBy() != null) {
                driver = driver.getReplacedBy();
            }
        }
        return driver;
    }

    @Nullable
    public DBPDriverSubstitutionDescriptor getDriverSubstitution(@NotNull String id) {
        return this.driverSubstitutions.get(id);
    }

    @NotNull
    public DBPDriverSubstitutionDescriptor[] getAllDriverSubstitutions() {
        return (DBPDriverSubstitutionDescriptor[])this.driverSubstitutions.values().toArray(DBPDriverSubstitutionDescriptor[]::new);
    }

    public DBPEditorContribution[] getContributedEditors(String category, DBPDataSourceContainer dataSource) {
        List<EditorContributionDescriptor> ec = this.contributionCategoryMap.get(category);
        if (ec == null) {
            return new DBPEditorContribution[0];
        }
        ArrayList<EditorContributionDescriptor> ecCopy = new ArrayList<EditorContributionDescriptor>();
        for (EditorContributionDescriptor editor : ec) {
            if (!editor.supportsDataSource(dataSource)) continue;
            ecCopy.add(editor);
        }
        return ecCopy.toArray(new DBPEditorContribution[0]);
    }

    public DBPPreferenceStore getGlobalDataSourcePreferenceStore() {
        return this.globalDataSourcePreferenceStore;
    }

    private void loadDrivers(String configFileName, boolean provided) {
        try {
            String driversConfig = provided ? Files.readString(Path.of(configFileName, new String[0]), StandardCharsets.UTF_8) : DBWorkbench.getPlatform().getConfigurationController().loadConfigurationFile(configFileName);
            if (CommonUtils.isEmpty((String)driversConfig)) {
                return;
            }
            try {
                Throwable throwable = null;
                Object var5_8 = null;
                try (StringReader is = new StringReader(driversConfig);){
                    new SAXReader((Reader)is).parse((SAXListener)new DriverDescriptorSerializerLegacy.DriversParser(provided));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (XMLException ex) {
                log.warn((Object)"Drivers config parse error", (Throwable)ex);
            }
        }
        catch (Exception ex) {
            log.warn((Object)("Error loading drivers from " + configFileName), (Throwable)ex);
        }
    }

    public void saveDrivers() {
        this.saveDrivers(DBWorkbench.getPlatform().getConfigurationController());
    }

    public void saveDrivers(DBConfigurationController configurationController) {
        try {
            this.saveDriversConfigFile(configurationController);
        }
        catch (Exception ex) {
            log.error((Object)"Error saving drivers", (Throwable)ex);
        }
    }

    public void saveDriversConfigFile(DBConfigurationController configurationController) throws DBException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            new DriverDescriptorSerializerLegacy().serializeDrivers(baos, this.dataSourceProviders);
            configurationController.saveConfigurationFile("drivers.xml", baos.toString(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new DBException("Error serializing drivers configuration file", (Throwable)e);
        }
    }

    public void linkDriverFiles(Path targetFileLocation) {
        boolean didResolve = false;
        for (DataSourceProviderDescriptor dspd : this.dataSourceProviders) {
            for (DriverDescriptor driver : dspd.getDrivers()) {
                if (driver.isDisabled() || driver.getReplacedBy() != null) continue;
                for (DBPDriverLoader driverLoader : driver.getAllDriverLoaders()) {
                    if (!driverLoader.resolveDriverFiles(targetFileLocation)) continue;
                    didResolve = true;
                }
            }
        }
        if (didResolve) {
            this.saveDrivers();
        }
    }

    private void loadConnectionTypes() {
        block13: {
            try {
                String ctConfig = DBWorkbench.getPlatform().getConfigurationController().loadConfigurationFile("connection-types.xml");
                if (CommonUtils.isEmpty((String)ctConfig)) break block13;
                try {
                    Throwable throwable = null;
                    Object var3_6 = null;
                    try (StringReader is = new StringReader(ctConfig);){
                        new SAXReader((Reader)is).parse((SAXListener)new ConnectionTypeParser());
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (XMLException ex) {
                    log.warn((Object)"Can't load connection types config from connection-types.xml", (Throwable)ex);
                }
            }
            catch (Exception ex) {
                log.warn((Object)"Error parsing connection types", (Throwable)ex);
            }
        }
    }

    public Collection<DBPConnectionType> getConnectionTypes() {
        return this.connectionTypes.values();
    }

    public DBPConnectionType getConnectionType(String id, DBPConnectionType defaultType) {
        DBPConnectionType connectionType = this.connectionTypes.get(id);
        return connectionType == null ? defaultType : connectionType;
    }

    public void addConnectionType(DBPConnectionType connectionType) {
        if (this.connectionTypes.containsKey(connectionType.getId())) {
            log.warn((Object)("Duplicate connection type id: " + connectionType.getId()));
            return;
        }
        this.connectionTypes.put(connectionType.getId(), connectionType);
    }

    public void removeConnectionType(DBPConnectionType connectionType) {
        if (!this.connectionTypes.containsKey(connectionType.getId())) {
            log.warn((Object)("Connection type doesn't exist: " + connectionType.getId()));
            return;
        }
        this.connectionTypes.remove(connectionType.getId());
    }

    public void saveConnectionTypes() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XMLBuilder xml = new XMLBuilder((OutputStream)baos, GeneralUtils.UTF8_ENCODING);
            xml.setButify(true);
            xml.startElement("types");
            for (DBPConnectionType connectionType : this.connectionTypes.values()) {
                xml.startElement("type");
                xml.addAttribute("id", connectionType.getId());
                xml.addAttribute("name", CommonUtils.toString((Object)connectionType.getName()));
                xml.addAttribute("color", connectionType.getColor());
                xml.addAttribute("description", CommonUtils.toString((Object)connectionType.getDescription()));
                xml.addAttribute("autocommit", connectionType.isAutocommit());
                xml.addAttribute("confirmExecute", connectionType.isConfirmExecute());
                xml.addAttribute("confirmDataChange", connectionType.isConfirmDataChange());
                xml.addAttribute("smartCommit", connectionType.isSmartCommit());
                xml.addAttribute("smartCommitRecover", connectionType.isSmartCommitRecover());
                xml.addAttribute("autoCloseTransactions", connectionType.isAutoCloseTransactions());
                xml.addAttribute("closeTransactionsPeriod", connectionType.getCloseIdleTransactionPeriod());
                xml.addAttribute("autoCloseConnections", connectionType.isAutoCloseConnections());
                xml.addAttribute("closeConnectionsPeriod", connectionType.getCloseIdleConnectionPeriod());
                List modifyPermission = connectionType.getModifyPermission();
                if (modifyPermission != null) {
                    xml.addAttribute("modifyPermission", modifyPermission.stream().map(Enum::name).collect(Collectors.joining(",")));
                }
                xml.endElement();
            }
            xml.endElement();
            xml.flush();
            DBWorkbench.getPlatform().getConfigurationController().saveConfigurationFile("connection-types.xml", baos.toString(StandardCharsets.UTF_8));
        }
        catch (Exception ex) {
            log.warn((Object)"Error saving drivers", (Throwable)ex);
        }
    }

    public List<DataSourceConfigurationStorageDescriptor> getDataSourceConfigurationStorages() {
        return this.dataSourceConfigurationStorageDescriptors;
    }

    public DBPDataSourceOriginProvider getDataSourceOriginProvider(String id) {
        DataSourceOriginProviderDescriptor descriptor = this.dataSourceOrigins.get(id);
        if (descriptor == null) {
            return null;
        }
        try {
            return descriptor.getProvider();
        }
        catch (Exception e) {
            log.error((Object)e);
            return null;
        }
    }

    public List<DataSourceHandlerDescriptor> getDataSourceHandlers() {
        return this.dataSourceHandlers;
    }

    public DataSourceAuthModelDescriptor getAuthModel(String id) {
        return this.authModels.get(id);
    }

    public List<DataSourceAuthModelDescriptor> getAllAuthModels() {
        return new ArrayList<DataSourceAuthModelDescriptor>(this.authModels.values());
    }

    public List<? extends DBPAuthModelDescriptor> getApplicableAuthModels(DBPDriver driver) {
        ArrayList<DataSourceAuthModelDescriptor> models = new ArrayList<DataSourceAuthModelDescriptor>();
        ArrayList<String> replaced = new ArrayList<String>();
        boolean desktopMode = !DBWorkbench.getPlatform().getApplication().isHeadlessMode();
        for (DataSourceAuthModelDescriptor amd : this.authModels.values()) {
            if (desktopMode && amd.isCloudModel() || !amd.appliesTo(driver)) continue;
            models.add(amd);
            replaced.addAll(amd.getReplaces(driver));
        }
        if (!replaced.isEmpty()) {
            models.removeIf(dataSourceAuthModelDescriptor -> replaced.contains(dataSourceAuthModelDescriptor.getId()));
        }
        return models;
    }

    @Nullable
    public URL findResourceURL(String resourcePath) {
        ExternalResourceDescriptor descriptor = this.resourceContributions.get(resourcePath);
        return descriptor == null ? null : descriptor.getURL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataSourceRegistryListener(DBPRegistryListener listener) {
        List<DBPRegistryListener> list = this.registryListeners;
        synchronized (list) {
            this.registryListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDataSourceRegistryListener(DBPRegistryListener listener) {
        List<DBPRegistryListener> list = this.registryListeners;
        synchronized (list) {
            this.registryListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireRegistryChange(DataSourceRegistry registry, boolean load) {
        ArrayList<DBPRegistryListener> lCopy;
        List<DBPRegistryListener> list = this.registryListeners;
        synchronized (list) {
            lCopy = new ArrayList<DBPRegistryListener>(this.registryListeners);
        }
        for (DBPRegistryListener listener : lCopy) {
            if (load) {
                listener.handleRegistryLoad((DBPDataSourceRegistry)registry);
                continue;
            }
            listener.handleRegistryUnload((DBPDataSourceRegistry)registry);
        }
    }

    class ConnectionTypeParser
    implements SAXListener {
        ConnectionTypeParser() {
        }

        public void saxStartElement(SAXReader reader, String namespaceURI, String localName, Attributes atts) throws XMLException {
            if (localName.equals("type")) {
                String typeId = atts.getValue("id");
                DBPConnectionType origType = null;
                DBPConnectionType[] dBPConnectionTypeArray = DBPConnectionType.SYSTEM_TYPES;
                int n = DBPConnectionType.SYSTEM_TYPES.length;
                int n2 = 0;
                while (n2 < n) {
                    DBPConnectionType ct = dBPConnectionTypeArray[n2];
                    if (ct.getId().equals(typeId)) {
                        origType = ct;
                        break;
                    }
                    ++n2;
                }
                DBPConnectionType connectionType = new DBPConnectionType(typeId, atts.getValue("name"), atts.getValue("color"), atts.getValue("description"), CommonUtils.getBoolean((String)atts.getValue("autocommit"), (origType != null && origType.isAutocommit() ? 1 : 0) != 0), CommonUtils.getBoolean((String)atts.getValue("confirmExecute"), (origType != null && origType.isConfirmExecute() ? 1 : 0) != 0), CommonUtils.getBoolean((String)atts.getValue("confirmDataChange"), (origType != null && origType.isConfirmDataChange() ? 1 : 0) != 0), CommonUtils.getBoolean((String)atts.getValue("smartCommit"), (origType != null && origType.isSmartCommit() ? 1 : 0) != 0), CommonUtils.getBoolean((String)atts.getValue("smartCommitRecover"), (origType != null && origType.isSmartCommitRecover() ? 1 : 0) != 0), CommonUtils.getBoolean((String)atts.getValue("autoCloseTransactions"), (origType != null && origType.isAutoCloseTransactions() ? 1 : 0) != 0), CommonUtils.toInt((Object)atts.getValue("closeTransactionsPeriod"), (int)(origType != null ? origType.getCloseIdleTransactionPeriod() : DBPConnectionType.DEFAULT_TYPE.getCloseIdleTransactionPeriod())), CommonUtils.getBoolean((String)atts.getValue("autoCloseConnections"), (origType != null && origType.isAutoCloseConnections() ? 1 : 0) != 0), CommonUtils.toInt((Object)atts.getValue("closeConnectionsPeriod"), (int)(origType != null ? origType.getCloseIdleConnectionPeriod() : DBPConnectionType.DEFAULT_TYPE.getCloseIdleConnectionPeriod())));
                String modifyPermissionList = atts.getValue("modifyPermission");
                if (!CommonUtils.isEmpty((String)modifyPermissionList)) {
                    ArrayList<DBPDataSourcePermission> permList = new ArrayList<DBPDataSourcePermission>();
                    String[] stringArray = modifyPermissionList.split(",");
                    int n3 = stringArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String permItem = stringArray[n4];
                        permList.add((DBPDataSourcePermission)CommonUtils.valueOf(DBPDataSourcePermission.class, (String)permItem, (Enum)DBPDataSourcePermission.PERMISSION_EDIT_DATA));
                        ++n4;
                    }
                    connectionType.setModifyPermissions(permList);
                }
                DataSourceProviderRegistry.this.connectionTypes.put(connectionType.getId(), connectionType);
            }
        }

        public void saxText(SAXReader reader, String data) {
        }

        public void saxEndElement(SAXReader reader, String namespaceURI, String localName) {
        }
    }
}

