/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.PostgreValueParser;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataType;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDependency;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreLanguage;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreObject;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilege;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilegeOwner;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedureKind;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedureParameter;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRole;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreScriptObject;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBPOverloadedObject;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPScriptObjectExt2;
import org.jkiss.dbeaver.model.DBPUniqueObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.struct.AbstractProcedure;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureParameterKind;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class PostgreProcedure
extends AbstractProcedure<PostgreDataSource, PostgreSchema>
implements PostgreObject,
PostgreScriptObject,
PostgrePrivilegeOwner,
DBPUniqueObject,
DBPOverloadedObject,
DBPNamedObject2,
DBPRefreshableObject,
DBPScriptObjectExt2 {
    private static final Log log = Log.getLog(PostgreProcedure.class);
    protected static final String CAT_FLAGS = "Flags";
    protected static final String CAT_PROPS = "Properties";
    public static final float DEFAULT_EST_ROWS = 1000.0f;
    public static final float DEFAULT_COST = 100.0f;
    protected long oid;
    protected PostgreProcedureKind kind;
    protected String procSrc;
    protected String body;
    protected long ownerId;
    protected long languageId;
    protected float execCost;
    protected float estRows;
    protected PostgreDataType varArrayType;
    protected String procTransform;
    protected boolean isAggregate;
    protected boolean isWindow;
    protected boolean isSecurityDefiner;
    protected boolean leakproof;
    protected boolean isStrict;
    protected boolean returnsSet;
    protected ProcedureVolatile procVolatile;
    protected PostgreDataType returnType;
    protected int[] transformTypes;
    protected String[] config;
    protected Object acl;
    protected String overloadedName;
    protected List<PostgreProcedureParameter> params = new ArrayList<PostgreProcedureParameter>();

    public PostgreProcedure(PostgreSchema schema) {
        super((DBSObjectContainer)schema, false);
    }

    public PostgreProcedure(DBRProgressMonitor monitor, PostgreSchema schema, ResultSet dbResult) {
        super((DBSObjectContainer)schema, true);
        this.loadInfo(monitor, dbResult);
    }

    private void loadInfo(DBRProgressMonitor monitor, ResultSet dbResult) {
        long varTypeId;
        PostgreDataSource dataSource;
        block41: {
            dataSource = (PostgreDataSource)this.getDataSource();
            this.oid = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"poid");
            this.setName(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"proname"));
            this.ownerId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"proowner");
            this.languageId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"prolang");
            if (dataSource.isServerVersionAtLeast(8, 3)) {
                this.execCost = JDBCUtils.safeGetFloat((ResultSet)dbResult, (String)"procost");
                this.estRows = JDBCUtils.safeGetFloat((ResultSet)dbResult, (String)"prorows");
            }
            Object[] allArgTypes = PostgreUtils.safeGetNumberArray(dbResult, "proallargtypes");
            String[] argNames = PostgreUtils.safeGetStringArray(dbResult, "proargnames");
            if (!ArrayUtils.isEmpty((Object[])allArgTypes)) {
                String[] argModes = PostgreUtils.safeGetStringArray(dbResult, "proargmodes");
                i = 0;
                while (i < allArgTypes.length) {
                    long paramType = ((Number)allArgTypes[i]).longValue();
                    PostgreDataType dataType = ((PostgreSchema)this.container).getDatabase().getDataType(monitor, paramType);
                    if (dataType == null) {
                        log.warn((Object)("Parameter data type [" + paramType + "] not found"));
                    } else {
                        String paramName = argNames == null || argNames.length < allArgTypes.length ? "$" + (i + 1) : argNames[i];
                        ArgumentMode mode = ArgumentMode.i;
                        if (argModes != null && argModes.length == allArgTypes.length) {
                            try {
                                mode = ArgumentMode.valueOf(argModes[i]);
                            }
                            catch (IllegalArgumentException e) {
                                log.debug((Object)e);
                            }
                        }
                        this.params.add(new PostgreProcedureParameter(this, paramName, dataType, mode, i + 1));
                    }
                    ++i;
                }
            } else {
                long[] inArgTypes = PostgreUtils.getIdVector(JDBCUtils.safeGetObject((ResultSet)dbResult, (String)"proargtypes"));
                if (!ArrayUtils.isEmpty((long[])inArgTypes)) {
                    i = 0;
                    while (i < inArgTypes.length) {
                        Long paramType = inArgTypes[i];
                        PostgreDataType dataType = ((PostgreSchema)this.container).getDatabase().getDataType(monitor, paramType.intValue());
                        if (dataType == null) {
                            log.warn((Object)("Parameter data type [" + String.valueOf(paramType) + "] not found"));
                        } else {
                            String paramName = argNames == null || argNames.length < inArgTypes.length ? "$" + (i + 1) : argNames[i];
                            PostgreProcedureParameter param = new PostgreProcedureParameter(this, paramName, dataType, ArgumentMode.i, i + 1);
                            this.params.add(param);
                        }
                        ++i;
                    }
                }
            }
            try {
                String argDefaultsString = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"arg_defaults");
                String[] argDefaults = null;
                if (!CommonUtils.isEmpty((String)argDefaultsString)) {
                    try {
                        argDefaults = PostgreValueParser.parseSingleObject(argDefaultsString);
                    }
                    catch (DBCException e) {
                        log.debug((Object)"Error parsing function parameters defaults", (Throwable)e);
                    }
                }
                if (argDefaults == null || argDefaults.length <= 0) break block41;
                int paramsAssigned = 0;
                int i = this.params.size() - 1;
                while (i >= 0) {
                    DBSProcedureParameterKind parameterKind = this.params.get(i).getParameterKind();
                    if (parameterKind != DBSProcedureParameterKind.OUT && parameterKind != DBSProcedureParameterKind.TABLE && parameterKind != DBSProcedureParameterKind.RETURN) {
                        String defaultValue = argDefaults[argDefaults.length - 1 - paramsAssigned];
                        if (defaultValue != null) {
                            defaultValue = defaultValue.trim();
                        }
                        this.params.get(i).setDefaultValue(defaultValue);
                        if (++paramsAssigned >= argDefaults.length) break;
                    }
                    --i;
                }
            }
            catch (Exception e) {
                log.error((Object)"Error parsing parameters defaults", (Throwable)e);
            }
        }
        this.overloadedName = PostgreProcedure.makeOverloadedName(this.getSchema(), this.getName(), this.params, false, false, false);
        if (dataSource.isServerVersionAtLeast(8, 4) && (varTypeId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"provariadic")) != 0L) {
            this.varArrayType = ((PostgreSchema)this.container).getDatabase().getDataType(monitor, varTypeId);
        }
        if (dataSource.isServerVersionAtLeast(9, 2) && !dataSource.isServerVersionAtLeast(12, 0)) {
            this.procTransform = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"protransform");
        }
        if (!dataSource.isServerVersionAtLeast(11, 0)) {
            this.isAggregate = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"proisagg");
        }
        if (dataSource.isServerVersionAtLeast(8, 4) && !dataSource.isServerVersionAtLeast(11, 0)) {
            this.isWindow = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"proiswindow");
        }
        this.isSecurityDefiner = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"prosecdef");
        if (dataSource.isServerVersionAtLeast(9, 2)) {
            this.leakproof = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"proleakproof");
        }
        this.isStrict = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"proisstrict");
        this.returnsSet = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"proretset");
        try {
            String provolatile = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"provolatile");
            this.procVolatile = provolatile == null ? null : ProcedureVolatile.valueOf(provolatile);
        }
        catch (IllegalArgumentException e) {
            log.debug((Object)e);
        }
        long retTypeId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"prorettype");
        if (retTypeId != 0L) {
            this.returnType = ((PostgreSchema)this.container).getDatabase().getDataType(monitor, retTypeId);
        }
        this.procSrc = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"prosrc");
        this.description = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"description");
        this.acl = JDBCUtils.safeGetObject((ResultSet)dbResult, (String)"proacl");
        if (dataSource.isServerVersionAtLeast(8, 3)) {
            this.config = PostgreUtils.safeGetStringArray(dbResult, "proconfig");
        }
        if (dataSource.getServerType().supportsStoredProcedures()) {
            String proKind = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"prokind");
            this.kind = (PostgreProcedureKind)CommonUtils.valueOf(PostgreProcedureKind.class, (String)proKind, (Enum)PostgreProcedureKind.f);
            if (this.kind == PostgreProcedureKind.a) {
                this.isAggregate = true;
            }
        } else if (this.isAggregate) {
            this.kind = PostgreProcedureKind.a;
        } else if (this.isWindow) {
            this.kind = PostgreProcedureKind.w;
        } else {
            boolean isProcedure = false;
            try {
                isProcedure = dbResult.getBoolean("prosp");
            }
            catch (SQLException sQLException) {}
            this.kind = isProcedure ? PostgreProcedureKind.p : PostgreProcedureKind.f;
        }
    }

    @Override
    @NotNull
    public PostgreDatabase getDatabase() {
        return ((PostgreSchema)this.container).getDatabase();
    }

    @Property(viewable=false, order=3)
    public PostgreProcedureKind getKind() {
        return this.kind;
    }

    public void setKind(PostgreProcedureKind kind) {
        this.kind = kind;
    }

    @Property(order=5)
    public long getObjectId() {
        return this.oid;
    }

    public DBSProcedureType getProcedureType() {
        switch (this.kind) {
            case f: 
            case a: 
            case w: {
                return DBSProcedureType.FUNCTION;
            }
        }
        return DBSProcedureType.PROCEDURE;
    }

    @Property(hidden=true, editable=true, updatable=true, order=-1)
    public String getBody() {
        return this.body;
    }

    @Nullable
    public List<PostgreProcedureParameter> getParameters(@NotNull DBRProgressMonitor monitor) {
        return this.params;
    }

    public List<PostgreProcedureParameter> getInputParameters() {
        ArrayList<PostgreProcedureParameter> result = new ArrayList<PostgreProcedureParameter>();
        for (PostgreProcedureParameter param : this.params) {
            if (!param.getParameterKind().isInput()) continue;
            result.add(param);
        }
        return result;
    }

    public List<PostgreProcedureParameter> getParameters(DBSProcedureParameterKind kind) {
        ArrayList<PostgreProcedureParameter> result = new ArrayList<PostgreProcedureParameter>();
        for (PostgreProcedureParameter param : this.params) {
            if (param.getParameterKind() != kind) continue;
            result.add(param);
        }
        return result;
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.getContainer(), this});
    }

    @NotNull
    public String getOverloadedName() {
        return this.overloadedName;
    }

    @NotNull
    public String getUniqueName() {
        return this.overloadedName;
    }

    public String getSpecificName() {
        return this.name + "_" + this.getObjectId();
    }

    public void setName(String name) {
        super.setName(name);
        this.overloadedName = PostgreProcedure.makeOverloadedName(this.getSchema(), this.getName(), this.params, false, false, false);
    }

    @Property(hidden=true, editable=true, updatable=true, order=-1)
    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        Object procDDL;
        boolean omitHeader = CommonUtils.getOption(options, (String)"debugger.source");
        Object object = procDDL = omitHeader ? "" : "-- DROP " + this.getProcedureTypeName() + " " + this.getFullQualifiedSignature() + ";\n\n";
        if (this.isPersisted() && (!((PostgreDataSource)this.getDataSource()).getServerType().supportsFunctionDefRead() || omitHeader) && !this.isAggregate) {
            if (this.procSrc == null) {
                try {
                    Throwable throwable = null;
                    Object var6_10 = null;
                    try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Read procedure body");){
                        this.procSrc = JDBCUtils.queryString((Connection)session, (String)"SELECT prosrc FROM pg_proc where oid = ?", (Object[])new Object[]{this.getObjectId()});
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (SQLException e) {
                    throw new DBException("Error reading procedure body", (Throwable)e);
                }
            }
            String returnTypeName = (returnType = this.getReturnType()) == null ? null : ((PostgreDataType)returnType).getFullTypeName();
            procDDL = (String)procDDL + (omitHeader ? this.procSrc : this.generateFunctionDeclaration(this.getLanguage(monitor), returnTypeName, this.procSrc));
        } else {
            if (this.body == null) {
                if (!this.isPersisted()) {
                    returnType = this.getReturnType();
                    String returnTypeName = returnType == null ? null : ((PostgreDataType)returnType).getFullTypeName();
                    this.body = this.generateFunctionDeclaration(this.getLanguage(monitor), returnTypeName, "\n\t-- Enter function body here\n");
                } else if (this.oid == 0L) {
                    this.body = this.procSrc;
                } else if (this.isAggregate) {
                    this.configureAggregateQuery(monitor);
                } else {
                    try {
                        returnType = null;
                        Object var6_13 = null;
                        try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Read procedure body");){
                            this.body = JDBCUtils.queryString((Connection)session, (String)("SELECT pg_get_functiondef(" + this.getObjectId() + ")"), (Object[])new Object[0]);
                        }
                        catch (Throwable throwable) {
                            if (returnType == null) {
                                returnType = throwable;
                            } else if (returnType != throwable) {
                                ((Throwable)returnType).addSuppressed(throwable);
                            }
                            throw returnType;
                        }
                    }
                    catch (SQLException e) {
                        throw new DBException("Error reading procedure body", (Throwable)e);
                    }
                }
            }
            procDDL = (String)procDDL + this.body;
        }
        if (this.isPersisted() && !omitHeader) {
            procDDL = (String)procDDL + ";\n";
            if (CommonUtils.getOption(options, (String)"ddl.includeComments") && !CommonUtils.isEmpty((String)this.getDescription())) {
                procDDL = (String)procDDL + "\nCOMMENT ON " + this.getProcedureTypeName() + " " + this.getFullQualifiedSignature() + " IS " + SQLUtils.quoteString((DBSObject)this, (String)this.getDescription()) + ";\n";
            }
            if (CommonUtils.getOption(options, (String)"ddl.includePermissions")) {
                ArrayList<DBEPersistAction> actions = new ArrayList<DBEPersistAction>();
                PostgreUtils.getObjectGrantPermissionActions(monitor, this, actions, options);
                procDDL = (String)procDDL + "\n" + SQLUtils.generateScript((DBPDataSource)this.getDataSource(), (DBEPersistAction[])actions.toArray(new DBEPersistAction[0]), (boolean)false);
            }
        }
        return procDDL;
    }

    private void configureAggregateQuery(DBRProgressMonitor monitor) throws DBCException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Read aggregate function body");){
                String query = "SELECT (pg_identify_object('pg_proc'::regclass, aggfnoid, 0)).identity,\naggtransfn::regproc,\nformat_type(aggtranstype, NULL) as aggtranstype,\nCASE aggfinalfn WHEN '-'::regproc THEN NULL ELSE aggfinalfn::text END,\nCASE aggsortop WHEN 0 THEN NULL ELSE oprname END,\nagginitval, " + (((PostgreDataSource)this.getDataSource()).isServerVersionAtLeast(9, 4) ? "aggmtransfn, aggminvtransfn,\naggfinalextra, aggmfinalextra, aggserialfn, aggdeserialfn, aggmfinalfn,\nformat_type(aggmtranstype, NULL) as aggmtranstype\n" : "") + (((PostgreDataSource)this.getDataSource()).isServerVersionAtLeast(11, 0) ? ",aggfinalmodify, aggmfinalmodify " : "") + "FROM pg_aggregate\nLEFT JOIN pg_operator ON pg_operator.oid = aggsortop\nWHERE aggfnoid = ?::regproc";
                Throwable throwable2 = null;
                Object var7_11 = null;
                try (JDBCPreparedStatement dbStat = session.prepareStatement(query);){
                    dbStat.setString(1, this.getFullyQualifiedName(DBPEvaluationContext.DDL));
                    Throwable throwable3 = null;
                    Object var10_16 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        if (dbResult.next()) {
                            String fullName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"identity");
                            String aggtransfn = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"aggtransfn");
                            String aggtranstype = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"aggtranstype");
                            String aggfinalfn = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"aggfinalfn");
                            String oprname = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"oprname");
                            Object initval = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"agginitval");
                            String mtransfn = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"aggmtransfn");
                            String mtranstype = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"aggmtranstype");
                            String minvtransfn = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"aggminvtransfn");
                            String serialfn = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"aggserialfn");
                            String deserialfn = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"aggdeserialfn");
                            String mfinalfn = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"aggmfinalfn");
                            TransitionModifies finalmodify = null;
                            TransitionModifies mfinalmodify = null;
                            if (((PostgreDataSource)this.getDataSource()).isServerVersionAtLeast(11, 0)) {
                                finalmodify = TransitionModifies.valueOf(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"aggfinalmodify"));
                                mfinalmodify = TransitionModifies.valueOf(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"aggmfinalmodify"));
                            }
                            boolean finalextra = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"aggfinalextra");
                            boolean mfinalextra = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"aggmfinalextra");
                            StringBuilder aggregateBody = new StringBuilder("CREATE OR REPLACE AGGREGATE ");
                            aggregateBody.append(fullName).append(" (\n").append("\tSFUNC = ").append(aggtransfn).append(",\n\t").append("STYPE = ").append(aggtranstype);
                            if (CommonUtils.isNotEmpty((String)aggfinalfn)) {
                                aggregateBody.append(",\n\t").append("FINALFUNC = ").append(aggfinalfn);
                                if (finalextra) {
                                    aggregateBody.append(",\n\t").append("FINALFUNC_EXTRA");
                                }
                                if (finalmodify != null) {
                                    aggregateBody.append(",\n\t").append("FINALFUNC_MODIFY = ").append(finalmodify.keyword);
                                }
                            }
                            if (CommonUtils.isNotEmpty((String)serialfn) && !"-".equals(serialfn)) {
                                aggregateBody.append(",\n\t").append("SERIALFUNC = ").append(serialfn);
                            }
                            if (CommonUtils.isNotEmpty((String)deserialfn) && !"-".equals(deserialfn)) {
                                aggregateBody.append(",\n\t").append("DESERIALFUNC = ").append(deserialfn);
                            }
                            if (CommonUtils.isNotEmpty((String)initval)) {
                                if (!Pattern.matches("[0-9]+", (CharSequence)initval)) {
                                    initval = "'" + (String)initval + "'";
                                }
                                aggregateBody.append(",\n\t").append("INITCOND = ").append((String)initval);
                            }
                            if (CommonUtils.isNotEmpty((String)mtransfn) && !"-".equals(mtransfn)) {
                                aggregateBody.append(",\n\t").append("MSFUNC = ").append(mtransfn);
                                if (CommonUtils.isNotEmpty((String)mtranstype) && !"-".equals(mtranstype)) {
                                    aggregateBody.append(",\n\t").append("MSTYPE = ").append(mtranstype);
                                }
                            }
                            if (CommonUtils.isNotEmpty((String)minvtransfn) && !"-".equals(minvtransfn)) {
                                aggregateBody.append(",\n\t").append("MINVFUNC = ").append(minvtransfn);
                            }
                            if (CommonUtils.isNotEmpty((String)mfinalfn) && !"-".equals(mfinalfn)) {
                                aggregateBody.append(",\n\t").append("MFINALFUNC = ").append(mfinalfn);
                                if (mfinalextra) {
                                    aggregateBody.append(",\n\t").append("MFINALFUNC_EXTRA");
                                }
                                if (mfinalmodify != null) {
                                    aggregateBody.append(",\n\t").append("MFINALFUNC_MODIFY = ").append(mfinalmodify.keyword);
                                }
                            }
                            if (CommonUtils.isNotEmpty((String)oprname)) {
                                aggregateBody.append(",\n\t").append("SORTOP = ").append(oprname);
                            }
                            aggregateBody.append("\n)");
                            this.body = aggregateBody.toString();
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            log.debug((Object)"Error reading aggregate function body", (Throwable)e);
            this.body = "-- Aggregate function " + this.getFullQualifiedSignature() + "\n-- " + e.getMessage();
        }
    }

    protected String generateFunctionDeclaration(PostgreLanguage language, String returnTypeName, String functionBody) {
        String lineSeparator = GeneralUtils.getDefaultLineSeparator();
        StringBuilder decl = new StringBuilder();
        String functionSignature = PostgreProcedure.makeOverloadedName(this.getSchema(), this.getName(), this.params, true, true, true);
        decl.append("CREATE OR REPLACE ").append(this.getProcedureTypeName()).append(" ").append(DBUtils.getQuotedIdentifier((DBSObject)this.getContainer())).append(".").append(functionSignature).append(lineSeparator);
        if (this.getProcedureType().hasReturnValue() && !CommonUtils.isEmpty((String)returnTypeName)) {
            decl.append("\tRETURNS ");
            if (this.isReturnsSet()) {
                List<PostgreProcedureParameter> tableParams = this.getParameters(DBSProcedureParameterKind.TABLE);
                if (!tableParams.isEmpty()) {
                    decl.append("TABLE (");
                    int i = 0;
                    while (i < tableParams.size()) {
                        PostgreProcedureParameter tp = tableParams.get(i);
                        if (i > 0) {
                            decl.append(", ");
                        }
                        decl.append(tp.getName()).append(" ").append(tp.getTypeName());
                        ++i;
                    }
                    decl.append(")");
                } else {
                    decl.append("SETOF ").append(returnTypeName);
                }
            } else {
                decl.append(returnTypeName);
            }
            decl.append(lineSeparator);
        }
        if (language != null) {
            decl.append("\tLANGUAGE ").append(language).append(lineSeparator);
        }
        if (this.isSecurityDefiner()) {
            decl.append("\tSECURITY DEFINER").append(lineSeparator);
        }
        if (this.isWindow()) {
            decl.append("\tWINDOW").append(lineSeparator);
        }
        if (this.getProcedureType() == DBSProcedureType.FUNCTION && this.procVolatile != null) {
            decl.append("\t").append(this.procVolatile.getCreateClause()).append(lineSeparator);
        }
        if (this.isStrict) {
            decl.append("\tSTRICT").append(lineSeparator);
        }
        if (this.execCost > 0.0f && this.execCost != 100.0f) {
            decl.append("\tCOST ").append(CommonUtils.niceFormatFloat((float)this.execCost)).append(lineSeparator);
        }
        if (this.estRows > 0.0f && this.estRows != 1000.0f) {
            decl.append("\tROWS ").append(CommonUtils.niceFormatFloat((float)this.estRows)).append(lineSeparator);
        }
        if (!ArrayUtils.isEmpty((Object[])this.config)) {
            String[] stringArray = this.config;
            int n = this.config.length;
            int n2 = 0;
            while (n2 < n) {
                String configLine = stringArray[n2];
                int divPos = configLine.indexOf(61);
                if (divPos != -1) {
                    String paramName = configLine.substring(0, divPos);
                    String paramValue = configLine.substring(divPos + 1);
                    boolean isNumeric = true;
                    try {
                        Double.parseDouble(paramValue);
                    }
                    catch (NumberFormatException numberFormatException) {
                        isNumeric = false;
                    }
                    decl.append("\tSET ").append(paramName).append(" = ").append((String)(isNumeric ? paramValue : "'" + paramValue + "'")).append(lineSeparator);
                } else {
                    log.debug((Object)("Wrong function configuration parameter [" + configLine + "]"));
                }
                ++n2;
            }
        }
        String delimiter = "$$";
        decl.append("AS ").append(delimiter).append("\n");
        if (!CommonUtils.isEmpty((String)functionBody)) {
            decl.append("\t").append(functionBody).append("\n");
        }
        decl.append(delimiter).append(lineSeparator);
        return decl.toString();
    }

    @Override
    public void setObjectDefinitionText(String sourceText) {
        this.body = sourceText;
    }

    public long getOwnerId() {
        return this.ownerId;
    }

    @Override
    @Property(category="Properties", order=10)
    public PostgreRole getOwner(DBRProgressMonitor monitor) throws DBException {
        if (!((PostgreDataSource)this.getDataSource()).getServerType().supportsRoles()) {
            return null;
        }
        return ((PostgreSchema)this.container).getDatabase().getRoleById(monitor, this.ownerId);
    }

    @Property(category="Properties", viewable=true, order=11)
    public PostgreLanguage getLanguage(DBRProgressMonitor monitor) throws DBException {
        return (PostgreLanguage)PostgreUtils.getObjectById(monitor, ((PostgreSchema)this.container).getDatabase().languageCache, ((PostgreSchema)this.container).getDatabase(), this.languageId);
    }

    public void setLanguage(PostgreLanguage language) {
        this.languageId = language.getObjectId();
    }

    @Property(category="Properties", viewable=true, order=12)
    public PostgreDataType getReturnType() {
        return this.returnType;
    }

    public void setReturnType(PostgreDataType returnType) {
        this.returnType = returnType;
    }

    @Property(category="Properties", viewable=false, order=13)
    public PostgreDataType getVarArrayType() {
        return this.varArrayType;
    }

    @Property(category="Properties", viewable=false, order=14)
    public String getProcTransform() {
        return this.procTransform;
    }

    @Property(category="Statistics", viewable=false, order=30)
    public float getExecCost() {
        return this.execCost;
    }

    @Property(category="Statistics", viewable=false, order=31)
    public float getEstRows() {
        return this.estRows;
    }

    @Property(category="Flags", viewable=true, order=100)
    public boolean isAggregate() {
        return this.isAggregate;
    }

    @Property(category="Flags", viewable=true, order=101)
    public boolean isWindow() {
        return this.isWindow;
    }

    @Property(category="Flags", viewable=true, order=102)
    public boolean isSecurityDefiner() {
        return this.isSecurityDefiner;
    }

    @Property(category="Flags", viewable=true, order=103)
    public boolean isLeakproof() {
        return this.leakproof;
    }

    @Property(category="Flags", viewable=true, order=104)
    public boolean isStrict() {
        return this.isStrict;
    }

    @Property(category="Flags", viewable=true, order=105)
    public boolean isReturnsSet() {
        return this.returnsSet;
    }

    @Property(category="Flags", viewable=true, order=106)
    public ProcedureVolatile getProcVolatile() {
        return this.procVolatile;
    }

    public static String makeOverloadedName(@NotNull PostgreSchema schema, @NotNull String name, @NotNull List<PostgreProcedureParameter> params, boolean quote, boolean showParamNames, boolean forDDL) {
        String selfName = quote ? DBUtils.getQuotedIdentifier((DBPDataSource)schema.getDataSource(), (String)name) : name;
        StringJoiner signature = new StringJoiner(", ", "(", ")");
        List keywordParams = params.stream().filter(x -> x.getArgumentMode().getKeyword() != null).collect(Collectors.toList());
        boolean allIn = keywordParams.stream().allMatch(x -> x.getArgumentMode() == ArgumentMode.i);
        for (PostgreProcedureParameter param : keywordParams) {
            PostgreDataType dataType;
            PostgreSchema typeContainer;
            StringJoiner parameter = new StringJoiner(" ");
            if (!allIn) {
                parameter.add(param.getArgumentMode().getKeyword());
            }
            if (showParamNames) {
                String paramName = param.getName();
                if (!forDDL || !paramName.startsWith("$")) {
                    parameter.add(paramName);
                }
            }
            if ((typeContainer = (PostgreSchema)(dataType = param.getParameterType()).getParentObject()).isPublicSchema() || typeContainer.isCatalogSchema()) {
                parameter.add(dataType.getName());
            } else {
                parameter.add(dataType.getFullyQualifiedName(DBPEvaluationContext.DDL));
            }
            String paramDefaultValue = param.getDefaultValue();
            if (forDDL && CommonUtils.isNotEmpty((String)paramDefaultValue)) {
                parameter.add("DEFAULT").add(paramDefaultValue);
            }
            signature.add(parameter.toString());
        }
        return selfName + String.valueOf(signature);
    }

    @Property(viewable=true, editable=true, updatable=true, length=PropertyLength.MULTILINE, order=200)
    @Nullable
    public String getDescription() {
        return super.getDescription();
    }

    public String getFullQualifiedSignature() {
        return DBUtils.getQuotedIdentifier((DBSObject)this.getContainer()) + "." + PostgreProcedure.makeOverloadedName(this.getSchema(), this.getName(), this.params, true, false, false);
    }

    public String getProcedureTypeName() {
        return this.kind.getName().toUpperCase(Locale.ENGLISH);
    }

    @Override
    public PostgreSchema getSchema() {
        return (PostgreSchema)this.container;
    }

    @Override
    public Collection<PostgrePrivilege> getPrivileges(@NotNull DBRProgressMonitor monitor, boolean includeNestedObjects) throws DBException {
        return PostgreUtils.extractPermissionsFromACL(monitor, this, this.acl, false);
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        return ((PostgreSchema)this.getContainer()).getProceduresCache().refreshObject(monitor, (PostgreSchema)this.getContainer(), this);
    }

    @Override
    public String generateChangeOwnerQuery(@NotNull String owner, @NotNull Map<String, Object> options) {
        return "ALTER " + this.getProcedureTypeName() + " " + this.getFullQualifiedSignature() + " OWNER TO " + owner;
    }

    @Association
    public List<PostgreDependency> getDependencies(DBRProgressMonitor monitor) throws DBCException {
        return PostgreDependency.readDependencies(monitor, this, true);
    }

    public boolean supportsObjectDefinitionOption(String option) {
        return "ddl.includeComments".equals(option) || "ddl.includePermissions".equals(option) || "sql.castParameter".equals(option);
    }

    public String toString() {
        return this.overloadedName == null ? this.name : this.overloadedName;
    }

    public static enum ArgumentMode {
        i(DBSProcedureParameterKind.IN, "in"),
        o(DBSProcedureParameterKind.OUT, "out"),
        b(DBSProcedureParameterKind.INOUT, "inout"),
        v(DBSProcedureParameterKind.RESULTSET, "variadic"),
        t(DBSProcedureParameterKind.TABLE, null),
        u(DBSProcedureParameterKind.UNKNOWN, null);

        private final DBSProcedureParameterKind parameterKind;
        private final String keyword;

        private ArgumentMode(DBSProcedureParameterKind parameterKind, String keyword) {
            this.parameterKind = parameterKind;
            this.keyword = keyword;
        }

        @NotNull
        public DBSProcedureParameterKind getParameterKind() {
            return this.parameterKind;
        }

        @Nullable
        public String getKeyword() {
            return this.keyword;
        }
    }

    public static enum ProcedureVolatile {
        i("IMMUTABLE"),
        s("STABLE"),
        v("VOLATILE");

        private final String createClause;

        private ProcedureVolatile(String createClause) {
            this.createClause = createClause;
        }

        public String getCreateClause() {
            return this.createClause;
        }
    }

    static enum TransitionModifies {
        r("READ_ONLY"),
        s("SHAREABLE"),
        w("READ_WRITE");

        private final String keyword;

        private TransitionModifies(String keyword) {
            this.keyword = keyword;
        }
    }
}

