/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.jsqlparser.expression.ArrayConstructor;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.parser.ASTNodeAccessImpl;
import net.sf.jsqlparser.schema.MultiPartName;
import net.sf.jsqlparser.schema.Table;

public class Column
extends ASTNodeAccessImpl
implements Expression,
MultiPartName {
    private Table table;
    private String columnName;
    private String commentText;
    private ArrayConstructor arrayConstructor;
    private String tableDelimiter = ".";

    public Column() {
    }

    public Column(Table table, String columnName) {
        this.setTable(table);
        this.setColumnName(columnName);
    }

    public Column(List<String> nameParts) {
        this(nameParts, nameParts.size() > 1 ? Collections.nCopies(nameParts.size() - 1, ".") : new ArrayList<String>());
    }

    public Column(List<String> nameParts, List<String> delimiters) {
        this(nameParts.size() > 1 ? new Table(nameParts.subList(0, nameParts.size() - 1), delimiters.subList(0, delimiters.size() - 1)) : null, nameParts.get(nameParts.size() - 1));
        this.setTableDelimiter(delimiters.isEmpty() ? "." : delimiters.get(delimiters.size() - 1));
    }

    public Column(String columnName) {
        this(null, columnName);
    }

    public ArrayConstructor getArrayConstructor() {
        return this.arrayConstructor;
    }

    public Column setArrayConstructor(ArrayConstructor arrayConstructor) {
        this.arrayConstructor = arrayConstructor;
        return this;
    }

    public Table getTable() {
        return this.table;
    }

    public String getTableName() {
        return this.table != null ? this.table.getName() : null;
    }

    public String getUnquotedTableName() {
        return this.table != null ? this.table.getUnquotedName() : null;
    }

    public String getSchemaName() {
        return this.table != null ? this.table.getSchemaName() : null;
    }

    public String getUnquotedSchemaName() {
        return this.table != null ? this.table.getUnquotedSchemaName() : null;
    }

    public String getCatalogName() {
        return this.table != null ? this.table.getCatalogName() : null;
    }

    public String getUnquotedCatalogName() {
        return this.table != null ? this.table.getUnquotedCatalogName() : null;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getUnquotedColumnName() {
        return MultiPartName.unquote(this.columnName);
    }

    public void setColumnName(String string) {
        this.columnName = string;
    }

    public String getTableDelimiter() {
        return this.tableDelimiter;
    }

    public void setTableDelimiter(String tableDelimiter) {
        this.tableDelimiter = tableDelimiter;
    }

    @Override
    public String getFullyQualifiedName() {
        return this.getFullyQualifiedName(false);
    }

    @Override
    public String getUnquotedName() {
        return MultiPartName.unquote(this.columnName);
    }

    public String getFullyQualifiedName(boolean aliases) {
        StringBuilder fqn = new StringBuilder();
        if (this.table != null) {
            if (this.table.getAlias() != null && aliases) {
                fqn.append(this.table.getAlias().getName());
            } else {
                fqn.append(this.table.getFullyQualifiedName());
            }
        }
        if (fqn.length() > 0) {
            fqn.append(this.tableDelimiter);
        }
        if (this.columnName != null) {
            fqn.append(this.columnName);
        }
        if (this.commentText != null) {
            fqn.append(" COMMENT ");
            fqn.append(this.commentText);
        }
        if (this.arrayConstructor != null) {
            fqn.append(this.arrayConstructor);
        }
        return fqn.toString();
    }

    @Deprecated
    public String getName(boolean aliases) {
        return this.columnName;
    }

    @Override
    public <T, S> T accept(ExpressionVisitor<T> expressionVisitor, S context) {
        return expressionVisitor.visit(this, context);
    }

    public String toString() {
        return this.getFullyQualifiedName(true) + (String)(this.commentText != null ? " /* " + this.commentText + "*/ " : "");
    }

    public Column withTable(Table table) {
        this.setTable(table);
        return this;
    }

    public Column withColumnName(String columnName) {
        this.setColumnName(columnName);
        return this;
    }

    public Column withCommentText(String commentText) {
        this.setCommentText(commentText);
        return this;
    }

    public Column withTableDelimiter(String delimiter) {
        this.setTableDelimiter(delimiter);
        return this;
    }

    public String getCommentText() {
        return this.commentText;
    }

    public void setCommentText(String commentText) {
        this.commentText = commentText;
    }
}

