/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.validation.validator;

import net.sf.jsqlparser.expression.AllValue;
import net.sf.jsqlparser.expression.AnalyticExpression;
import net.sf.jsqlparser.expression.AnyComparisonExpression;
import net.sf.jsqlparser.expression.ArrayConstructor;
import net.sf.jsqlparser.expression.ArrayExpression;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.BooleanValue;
import net.sf.jsqlparser.expression.CaseExpression;
import net.sf.jsqlparser.expression.CastExpression;
import net.sf.jsqlparser.expression.CollateExpression;
import net.sf.jsqlparser.expression.ConnectByPriorOperator;
import net.sf.jsqlparser.expression.ConnectByRootOperator;
import net.sf.jsqlparser.expression.DateTimeLiteralExpression;
import net.sf.jsqlparser.expression.DateValue;
import net.sf.jsqlparser.expression.DoubleValue;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.ExtractExpression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.HexValue;
import net.sf.jsqlparser.expression.HighExpression;
import net.sf.jsqlparser.expression.IntervalExpression;
import net.sf.jsqlparser.expression.Inverse;
import net.sf.jsqlparser.expression.JdbcNamedParameter;
import net.sf.jsqlparser.expression.JdbcParameter;
import net.sf.jsqlparser.expression.JsonAggregateFunction;
import net.sf.jsqlparser.expression.JsonExpression;
import net.sf.jsqlparser.expression.JsonFunction;
import net.sf.jsqlparser.expression.KeepExpression;
import net.sf.jsqlparser.expression.LambdaExpression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.LowExpression;
import net.sf.jsqlparser.expression.MySQLGroupConcat;
import net.sf.jsqlparser.expression.NextValExpression;
import net.sf.jsqlparser.expression.NotExpression;
import net.sf.jsqlparser.expression.NullValue;
import net.sf.jsqlparser.expression.NumericBind;
import net.sf.jsqlparser.expression.OracleHierarchicalExpression;
import net.sf.jsqlparser.expression.OracleHint;
import net.sf.jsqlparser.expression.OracleNamedFunctionParameter;
import net.sf.jsqlparser.expression.OverlapsCondition;
import net.sf.jsqlparser.expression.RangeExpression;
import net.sf.jsqlparser.expression.RowConstructor;
import net.sf.jsqlparser.expression.RowGetExpression;
import net.sf.jsqlparser.expression.SignedExpression;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.StructType;
import net.sf.jsqlparser.expression.TimeKeyExpression;
import net.sf.jsqlparser.expression.TimeValue;
import net.sf.jsqlparser.expression.TimestampValue;
import net.sf.jsqlparser.expression.TimezoneExpression;
import net.sf.jsqlparser.expression.TranscodingFunction;
import net.sf.jsqlparser.expression.TrimFunction;
import net.sf.jsqlparser.expression.UserVariable;
import net.sf.jsqlparser.expression.VariableAssignment;
import net.sf.jsqlparser.expression.WhenClause;
import net.sf.jsqlparser.expression.WindowElement;
import net.sf.jsqlparser.expression.WindowOffset;
import net.sf.jsqlparser.expression.WindowRange;
import net.sf.jsqlparser.expression.XMLSerializeExpr;
import net.sf.jsqlparser.expression.operators.arithmetic.Addition;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseAnd;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseLeftShift;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseOr;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseRightShift;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseXor;
import net.sf.jsqlparser.expression.operators.arithmetic.Concat;
import net.sf.jsqlparser.expression.operators.arithmetic.Division;
import net.sf.jsqlparser.expression.operators.arithmetic.IntegerDivision;
import net.sf.jsqlparser.expression.operators.arithmetic.Modulo;
import net.sf.jsqlparser.expression.operators.arithmetic.Multiplication;
import net.sf.jsqlparser.expression.operators.arithmetic.Subtraction;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.conditional.XorExpression;
import net.sf.jsqlparser.expression.operators.relational.Between;
import net.sf.jsqlparser.expression.operators.relational.ContainedBy;
import net.sf.jsqlparser.expression.operators.relational.Contains;
import net.sf.jsqlparser.expression.operators.relational.CosineSimilarity;
import net.sf.jsqlparser.expression.operators.relational.DoubleAnd;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExcludesExpression;
import net.sf.jsqlparser.expression.operators.relational.ExistsExpression;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.FullTextSearch;
import net.sf.jsqlparser.expression.operators.relational.GeometryDistance;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.IncludesExpression;
import net.sf.jsqlparser.expression.operators.relational.IsBooleanExpression;
import net.sf.jsqlparser.expression.operators.relational.IsDistinctExpression;
import net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import net.sf.jsqlparser.expression.operators.relational.JsonOperator;
import net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import net.sf.jsqlparser.expression.operators.relational.Matches;
import net.sf.jsqlparser.expression.operators.relational.MemberOfExpression;
import net.sf.jsqlparser.expression.operators.relational.MinorThan;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.sf.jsqlparser.expression.operators.relational.OldOracleJoinBinaryExpression;
import net.sf.jsqlparser.expression.operators.relational.Plus;
import net.sf.jsqlparser.expression.operators.relational.PriorTo;
import net.sf.jsqlparser.expression.operators.relational.RegExpMatchOperator;
import net.sf.jsqlparser.expression.operators.relational.SimilarToExpression;
import net.sf.jsqlparser.expression.operators.relational.TSQLLeftJoin;
import net.sf.jsqlparser.expression.operators.relational.TSQLRightJoin;
import net.sf.jsqlparser.parser.feature.Feature;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.AllTableColumns;
import net.sf.jsqlparser.statement.select.ParenthesedSelect;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.util.validation.ValidationCapability;
import net.sf.jsqlparser.util.validation.metadata.NamedObject;
import net.sf.jsqlparser.util.validation.validator.AbstractValidator;

public class ExpressionValidator
extends AbstractValidator<Expression>
implements ExpressionVisitor<Void> {
    @Override
    public <S> Void visit(Addition addition, S context) {
        this.visitBinaryExpression(addition, " + ");
        return null;
    }

    @Override
    public <S> Void visit(AndExpression andExpression, S context) {
        this.visitBinaryExpression(andExpression, andExpression.isUseOperator() ? " && " : " AND ");
        return null;
    }

    @Override
    public <S> Void visit(Between between, S context) {
        between.getLeftExpression().accept(this, context);
        between.getBetweenExpressionStart().accept(this, context);
        between.getBetweenExpressionEnd().accept(this, context);
        return null;
    }

    @Override
    public <S> Void visit(OverlapsCondition overlapsCondition, S context) {
        this.validateOptionalExpressionList(overlapsCondition.getLeft());
        this.validateOptionalExpressionList(overlapsCondition.getRight());
        return null;
    }

    @Override
    public <S> Void visit(EqualsTo equalsTo, S context) {
        this.validateOldOracleJoinBinaryExpression(equalsTo, " = ", context);
        return null;
    }

    @Override
    public <S> Void visit(Division division, S context) {
        this.visitBinaryExpression(division, " / ");
        return null;
    }

    @Override
    public <S> Void visit(IntegerDivision division, S context) {
        this.visitBinaryExpression(division, " DIV ");
        return null;
    }

    @Override
    public <S> Void visit(DoubleValue doubleValue, S context) {
        return null;
    }

    @Override
    public <S> Void visit(HexValue hexValue, S context) {
        return null;
    }

    @Override
    public <S> Void visit(NotExpression notExpr, S context) {
        notExpr.getExpression().accept(this, context);
        return null;
    }

    @Override
    public <S> Void visit(BitwiseRightShift expr, S context) {
        this.visitBinaryExpression(expr, " >> ");
        return null;
    }

    @Override
    public <S> Void visit(BitwiseLeftShift expr, S context) {
        this.visitBinaryExpression(expr, " << ");
        return null;
    }

    public <S> void validateOldOracleJoinBinaryExpression(OldOracleJoinBinaryExpression expression, String operator, S context) {
        for (ValidationCapability c : this.getCapabilities()) {
            this.validateOptionalExpression(expression.getLeftExpression(), this);
            if (expression.getOldOracleJoinSyntax() != 0) {
                this.validateFeature(c, Feature.oracleOldJoinSyntax);
            }
            this.validateOptionalExpression(expression.getRightExpression(), this);
            if (expression.getOraclePriorPosition() == 0) continue;
            this.validateFeature(c, Feature.oraclePriorPosition);
        }
    }

    @Override
    public <S> Void visit(GreaterThan greaterThan, S context) {
        this.validateOldOracleJoinBinaryExpression(greaterThan, " > ", context);
        return null;
    }

    @Override
    public <S> Void visit(GreaterThanEquals greaterThanEquals, S context) {
        this.validateOldOracleJoinBinaryExpression(greaterThanEquals, " >= ", context);
        return null;
    }

    @Override
    public <S> Void visit(InExpression inExpression, S context) {
        for (ValidationCapability c : this.getCapabilities()) {
            this.validateOptionalExpression(inExpression.getLeftExpression(), this);
            if (inExpression.getOldOracleJoinSyntax() == 0) continue;
            this.validateFeature(c, Feature.oracleOldJoinSyntax);
        }
        this.validateOptionalExpression(inExpression.getRightExpression(), this);
        return null;
    }

    @Override
    public <S> Void visit(IncludesExpression includesExpression, S context) {
        this.validateOptionalExpression(includesExpression.getLeftExpression(), this);
        this.validateOptionalExpression(includesExpression.getRightExpression(), this);
        return null;
    }

    @Override
    public <S> Void visit(ExcludesExpression excludesExpression, S context) {
        this.validateOptionalExpression(excludesExpression.getLeftExpression(), this);
        this.validateOptionalExpression(excludesExpression.getRightExpression(), this);
        return null;
    }

    @Override
    public <S> Void visit(FullTextSearch fullTextSearch, S context) {
        this.validateOptionalExpressions(fullTextSearch.getMatchColumns());
        return null;
    }

    @Override
    public <S> Void visit(SignedExpression signedExpression, S context) {
        signedExpression.getExpression().accept(this, context);
        return null;
    }

    @Override
    public <S> Void visit(IsNullExpression isNullExpression, S context) {
        isNullExpression.getLeftExpression().accept(this, context);
        return null;
    }

    @Override
    public <S> Void visit(IsBooleanExpression isBooleanExpression, S context) {
        isBooleanExpression.getLeftExpression().accept(this, context);
        return null;
    }

    @Override
    public <S> Void visit(JdbcParameter jdbcParameter, S context) {
        this.validateFeature(Feature.jdbcParameter);
        return null;
    }

    public void visit(PlainSelect plainSelect) {
        this.visit((Select)plainSelect, (Object)null);
    }

    @Override
    public void visit(Addition addition) {
        this.visit(addition, (Object)null);
    }

    @Override
    public void visit(AndExpression andExpression) {
        this.visit(andExpression, (Object)null);
    }

    @Override
    public void visit(Between between) {
        this.visit(between, (Object)null);
    }

    @Override
    public void visit(OverlapsCondition overlapsCondition) {
        this.visit(overlapsCondition, (Object)null);
    }

    @Override
    public void visit(EqualsTo equalsTo) {
        this.visit(equalsTo, (Object)null);
    }

    @Override
    public void visit(Division division) {
        this.visit(division, (Object)null);
    }

    @Override
    public void visit(IntegerDivision division) {
        this.visit(division, (Object)null);
    }

    @Override
    public void visit(DoubleValue doubleValue) {
        this.visit(doubleValue, (Object)null);
    }

    @Override
    public void visit(HexValue hexValue) {
        this.visit(hexValue, (Object)null);
    }

    @Override
    public void visit(NotExpression notExpr) {
        this.visit(notExpr, (Object)null);
    }

    @Override
    public void visit(BitwiseRightShift expr) {
        this.visit(expr, (Object)null);
    }

    @Override
    public void visit(BitwiseLeftShift expr) {
        this.visit(expr, (Object)null);
    }

    @Override
    public void visit(GreaterThan greaterThan) {
        this.visit(greaterThan, (Object)null);
    }

    @Override
    public void visit(GreaterThanEquals greaterThanEquals) {
        this.visit(greaterThanEquals, (Object)null);
    }

    @Override
    public void visit(InExpression inExpression) {
        this.visit(inExpression, (Object)null);
    }

    @Override
    public void visit(IncludesExpression includesExpression) {
        this.visit(includesExpression, (Object)null);
    }

    @Override
    public void visit(ExcludesExpression excludesExpression) {
        this.visit(excludesExpression, (Object)null);
    }

    @Override
    public void visit(FullTextSearch fullTextSearch) {
        this.visit(fullTextSearch, (Object)null);
    }

    @Override
    public void visit(SignedExpression signedExpression) {
        this.visit(signedExpression, (Object)null);
    }

    @Override
    public void visit(IsNullExpression isNullExpression) {
        this.visit(isNullExpression, (Object)null);
    }

    @Override
    public void visit(IsBooleanExpression isBooleanExpression) {
        this.visit(isBooleanExpression, (Object)null);
    }

    @Override
    public void visit(JdbcParameter jdbcParameter) {
        this.visit(jdbcParameter, (Object)null);
    }

    @Override
    public <S> Void visit(LikeExpression likeExpression, S context) {
        this.validateFeature(Feature.exprLike);
        this.visitBinaryExpression(likeExpression, (likeExpression.isNot() ? " NOT" : "") + (likeExpression.isCaseInsensitive() ? " ILIKE " : " LIKE "));
        return null;
    }

    @Override
    public <S> Void visit(ExistsExpression existsExpression, S context) {
        existsExpression.getRightExpression().accept(this, context);
        return null;
    }

    @Override
    public <S> Void visit(MemberOfExpression memberOfExpression, S context) {
        memberOfExpression.getLeftExpression().accept(this, context);
        memberOfExpression.getRightExpression().accept(this, context);
        return null;
    }

    @Override
    public <S> Void visit(LongValue longValue, S context) {
        return null;
    }

    @Override
    public <S> Void visit(MinorThan minorThan, S context) {
        this.validateOldOracleJoinBinaryExpression(minorThan, " < ", context);
        return null;
    }

    @Override
    public <S> Void visit(MinorThanEquals minorThanEquals, S context) {
        this.validateOldOracleJoinBinaryExpression(minorThanEquals, " <= ", context);
        return null;
    }

    @Override
    public <S> Void visit(Multiplication multiplication, S context) {
        this.visitBinaryExpression(multiplication, " * ");
        return null;
    }

    @Override
    public <S> Void visit(NotEqualsTo notEqualsTo, S context) {
        this.validateOldOracleJoinBinaryExpression(notEqualsTo, " " + notEqualsTo.getStringExpression() + " ", context);
        return null;
    }

    @Override
    public <S> Void visit(DoubleAnd doubleAnd, S context) {
        return null;
    }

    @Override
    public <S> Void visit(Contains contains, S context) {
        return null;
    }

    @Override
    public <S> Void visit(ContainedBy containedBy, S context) {
        return null;
    }

    @Override
    public <S> Void visit(NullValue nullValue, S context) {
        return null;
    }

    @Override
    public <S> Void visit(OrExpression orExpression, S context) {
        this.visitBinaryExpression(orExpression, " OR ");
        return null;
    }

    @Override
    public <S> Void visit(XorExpression xorExpression, S context) {
        this.visitBinaryExpression(xorExpression, " XOR ");
        return null;
    }

    @Override
    public <S> Void visit(StringValue stringValue, S context) {
        return null;
    }

    @Override
    public <S> Void visit(BooleanValue booleanValue, S context) {
        return null;
    }

    @Override
    public <S> Void visit(Subtraction subtraction, S context) {
        this.visitBinaryExpression(subtraction, " - ");
        return null;
    }

    protected void visitBinaryExpression(BinaryExpression binaryExpression, String operator) {
        binaryExpression.getLeftExpression().accept(this, null);
        binaryExpression.getRightExpression().accept(this, null);
    }

    @Override
    public <S> Void visit(ParenthesedSelect selectBody, S context) {
        this.validateOptionalFromItem(selectBody);
        return null;
    }

    @Override
    public <S> Void visit(Column tableColumn, S context) {
        this.validateName(NamedObject.column, tableColumn.getFullyQualifiedName());
        return null;
    }

    @Override
    public <S> Void visit(Function function, S context) {
        this.validateFeature(Feature.function);
        this.validateOptionalExpressionList(function.getNamedParameters());
        this.validateOptionalExpressionList(function.getParameters());
        Object attribute = function.getAttribute();
        if (attribute instanceof Expression) {
            this.validateOptionalExpression((Expression)attribute, this);
        }
        this.validateOptionalExpression(function.getKeep(), this);
        this.validateOptionalOrderByElements(function.getOrderByElements());
        return null;
    }

    @Override
    public <S> Void visit(DateValue dateValue, S context) {
        return null;
    }

    @Override
    public <S> Void visit(TimestampValue timestampValue, S context) {
        return null;
    }

    @Override
    public <S> Void visit(TimeValue timeValue, S context) {
        return null;
    }

    @Override
    public <S> Void visit(CaseExpression caseExpression, S context) {
        Expression switchExp = caseExpression.getSwitchExpression();
        if (switchExp != null) {
            switchExp.accept(this, context);
        }
        caseExpression.getWhenClauses().forEach(wc -> wc.accept(this, context));
        Expression elseExp = caseExpression.getElseExpression();
        if (elseExp != null) {
            elseExp.accept(this, context);
        }
        return null;
    }

    @Override
    public void visit(LikeExpression likeExpression) {
        this.visit(likeExpression, (Object)null);
    }

    @Override
    public void visit(ExistsExpression existsExpression) {
        this.visit(existsExpression, (Object)null);
    }

    @Override
    public void visit(MemberOfExpression memberOfExpression) {
        this.visit(memberOfExpression, (Object)null);
    }

    @Override
    public void visit(LongValue longValue) {
        this.visit(longValue, (Object)null);
    }

    @Override
    public void visit(MinorThan minorThan) {
        this.visit(minorThan, (Object)null);
    }

    @Override
    public void visit(MinorThanEquals minorThanEquals) {
        this.visit(minorThanEquals, (Object)null);
    }

    @Override
    public void visit(Multiplication multiplication) {
        this.visit(multiplication, (Object)null);
    }

    @Override
    public void visit(NotEqualsTo notEqualsTo) {
        this.visit(notEqualsTo, (Object)null);
    }

    @Override
    public void visit(DoubleAnd doubleAnd) {
        this.visit(doubleAnd, (Object)null);
    }

    @Override
    public void visit(Contains contains) {
        this.visit(contains, (Object)null);
    }

    @Override
    public void visit(ContainedBy containedBy) {
        this.visit(containedBy, (Object)null);
    }

    @Override
    public void visit(NullValue nullValue) {
        this.visit(nullValue, (Object)null);
    }

    @Override
    public void visit(OrExpression orExpression) {
        this.visit(orExpression, (Object)null);
    }

    @Override
    public void visit(XorExpression xorExpression) {
        this.visit(xorExpression, (Object)null);
    }

    @Override
    public void visit(StringValue stringValue) {
        this.visit(stringValue, (Object)null);
    }

    @Override
    public void visit(BooleanValue booleanValue) {
        this.visit(booleanValue, (Object)null);
    }

    @Override
    public void visit(Subtraction subtraction) {
        this.visit(subtraction, (Object)null);
    }

    public void visit(ParenthesedSelect selectBody) {
        this.visit(selectBody, (Object)null);
    }

    @Override
    public void visit(Column tableColumn) {
        this.visit(tableColumn, (Object)null);
    }

    @Override
    public void visit(Function function) {
        this.visit(function, (Object)null);
    }

    @Override
    public void visit(DateValue dateValue) {
        this.visit(dateValue, (Object)null);
    }

    @Override
    public void visit(TimestampValue timestampValue) {
        this.visit(timestampValue, (Object)null);
    }

    @Override
    public void visit(TimeValue timeValue) {
        this.visit(timeValue, (Object)null);
    }

    @Override
    public void visit(CaseExpression caseExpression) {
        this.visit(caseExpression, (Object)null);
    }

    @Override
    public <S> Void visit(WhenClause whenClause, S context) {
        whenClause.getWhenExpression().accept(this, context);
        whenClause.getThenExpression().accept(this, context);
        return null;
    }

    @Override
    public <S> Void visit(AnyComparisonExpression anyComparisonExpression, S context) {
        anyComparisonExpression.getSelect().accept(this, context);
        return null;
    }

    @Override
    public <S> Void visit(Concat concat, S context) {
        this.visitBinaryExpression(concat, " || ");
        return null;
    }

    @Override
    public <S> Void visit(Matches matches, S context) {
        this.validateOldOracleJoinBinaryExpression(matches, " @@ ", context);
        return null;
    }

    @Override
    public <S> Void visit(BitwiseAnd bitwiseAnd, S context) {
        this.visitBinaryExpression(bitwiseAnd, " & ");
        return null;
    }

    @Override
    public <S> Void visit(BitwiseOr bitwiseOr, S context) {
        this.visitBinaryExpression(bitwiseOr, " | ");
        return null;
    }

    @Override
    public <S> Void visit(BitwiseXor bitwiseXor, S context) {
        this.visitBinaryExpression(bitwiseXor, " ^ ");
        return null;
    }

    @Override
    public <S> Void visit(CastExpression cast, S context) {
        cast.getLeftExpression().accept(this, context);
        return null;
    }

    @Override
    public <S> Void visit(Modulo modulo, S context) {
        this.visitBinaryExpression(modulo, " % ");
        return null;
    }

    @Override
    public <S> Void visit(AnalyticExpression aexpr, S context) {
        this.validateOptionalExpression(aexpr.getExpression(), this);
        this.validateOptionalExpression(aexpr.getOffset(), this);
        this.validateOptionalExpression(aexpr.getDefaultValue(), this);
        this.validateOptionalExpression(aexpr.getKeep(), this);
        this.validateOptionalExpressionList(aexpr.getPartitionExpressionList());
        this.validateOptionalOrderByElements(aexpr.getOrderByElements());
        WindowElement windowElement = aexpr.getWindowElement();
        if (windowElement != null) {
            this.validateOptionalWindowOffset(windowElement.getOffset());
            WindowRange range = windowElement.getRange();
            if (range != null) {
                this.validateOptionalWindowOffset(range.getStart());
                this.validateOptionalWindowOffset(range.getEnd());
            }
        }
        this.validateOptionalExpression(aexpr.getFilterExpression());
        return null;
    }

    private void validateOptionalWindowOffset(WindowOffset offset) {
        if (offset != null) {
            this.validateOptionalExpression(offset.getExpression());
        }
    }

    @Override
    public <S> Void visit(ExtractExpression eexpr, S context) {
        eexpr.getExpression().accept(this, context);
        return null;
    }

    @Override
    public <S> Void visit(IntervalExpression iexpr, S context) {
        this.validateOptionalExpression(iexpr.getExpression());
        return null;
    }

    @Override
    public <S> Void visit(JdbcNamedParameter jdbcNamedParameter, S context) {
        this.validateFeature(Feature.jdbcNamedParameter);
        return null;
    }

    @Override
    public <S> Void visit(OracleHierarchicalExpression oexpr, S context) {
        this.validateFeature(Feature.oracleHierarchicalExpression);
        return null;
    }

    @Override
    public <S> Void visit(RegExpMatchOperator rexpr, S context) {
        this.visitBinaryExpression(rexpr, " " + rexpr.getStringExpression() + " ");
        return null;
    }

    @Override
    public <S> Void visit(JsonExpression jsonExpr, S context) {
        this.validateOptionalExpression(jsonExpr.getExpression());
        return null;
    }

    @Override
    public <S> Void visit(JsonOperator jsonExpr, S context) {
        this.visitBinaryExpression(jsonExpr, " " + jsonExpr.getStringExpression() + " ");
        return null;
    }

    @Override
    public <S> Void visit(UserVariable var, S context) {
        return null;
    }

    @Override
    public <S> Void visit(NumericBind bind, S context) {
        return null;
    }

    @Override
    public <S> Void visit(KeepExpression aexpr, S context) {
        this.validateOptionalOrderByElements(aexpr.getOrderByElements());
        return null;
    }

    @Override
    public <S> Void visit(MySQLGroupConcat groupConcat, S context) {
        this.validateOptionalExpressionList(groupConcat.getExpressionList());
        this.validateOptionalOrderByElements(groupConcat.getOrderByElements());
        return null;
    }

    private void validateOptionalExpressionList(ExpressionList<?> expressionList) {
        if (expressionList != null) {
            for (Expression expression : expressionList) {
                expression.accept(this, null);
            }
        }
    }

    @Override
    public void visit(WhenClause whenClause) {
        this.visit(whenClause, (Object)null);
    }

    @Override
    public void visit(AnyComparisonExpression anyComparisonExpression) {
        this.visit(anyComparisonExpression, (Object)null);
    }

    @Override
    public void visit(Concat concat) {
        this.visit(concat, (Object)null);
    }

    @Override
    public void visit(Matches matches) {
        this.visit(matches, (Object)null);
    }

    @Override
    public void visit(BitwiseAnd bitwiseAnd) {
        this.visit(bitwiseAnd, (Object)null);
    }

    @Override
    public void visit(BitwiseOr bitwiseOr) {
        this.visit(bitwiseOr, (Object)null);
    }

    @Override
    public void visit(BitwiseXor bitwiseXor) {
        this.visit(bitwiseXor, (Object)null);
    }

    @Override
    public void visit(CastExpression cast) {
        this.visit(cast, (Object)null);
    }

    @Override
    public void visit(Modulo modulo) {
        this.visit(modulo, (Object)null);
    }

    @Override
    public void visit(AnalyticExpression aexpr) {
        this.visit(aexpr, (Object)null);
    }

    @Override
    public void visit(ExtractExpression eexpr) {
        this.visit(eexpr, (Object)null);
    }

    @Override
    public void visit(IntervalExpression iexpr) {
        this.visit(iexpr, (Object)null);
    }

    @Override
    public void visit(JdbcNamedParameter jdbcNamedParameter) {
        this.visit(jdbcNamedParameter, (Object)null);
    }

    @Override
    public void visit(OracleHierarchicalExpression oexpr) {
        this.visit(oexpr, (Object)null);
    }

    @Override
    public void visit(RegExpMatchOperator rexpr) {
        this.visit(rexpr, (Object)null);
    }

    @Override
    public void visit(JsonExpression jsonExpr) {
        this.visit(jsonExpr, (Object)null);
    }

    @Override
    public void visit(JsonOperator jsonExpr) {
        this.visit(jsonExpr, (Object)null);
    }

    @Override
    public void visit(UserVariable var) {
        this.visit(var, (Object)null);
    }

    @Override
    public void visit(NumericBind bind) {
        this.visit(bind, (Object)null);
    }

    @Override
    public void visit(KeepExpression aexpr) {
        this.visit(aexpr, (Object)null);
    }

    @Override
    public void visit(MySQLGroupConcat groupConcat) {
        this.visit(groupConcat, (Object)null);
    }

    @Override
    public <S> Void visit(ExpressionList<?> expressionList, S context) {
        this.validateOptionalExpressionList(expressionList);
        return null;
    }

    @Override
    public <S> Void visit(RowConstructor<?> rowConstructor, S context) {
        this.validateOptionalExpressionList(rowConstructor);
        return null;
    }

    @Override
    public <S> Void visit(RowGetExpression rowGetExpression, S context) {
        rowGetExpression.getExpression().accept(this, context);
        return null;
    }

    @Override
    public <S> Void visit(OracleHint hint, S context) {
        return null;
    }

    @Override
    public <S> Void visit(TimeKeyExpression timeKeyExpression, S context) {
        return null;
    }

    @Override
    public <S> Void visit(DateTimeLiteralExpression literal, S context) {
        return null;
    }

    @Override
    public <S> Void visit(NextValExpression nextVal, S context) {
        this.validateName(NamedObject.sequence, nextVal.getName());
        return null;
    }

    @Override
    public <S> Void visit(CollateExpression col, S context) {
        this.validateOptionalExpression(col.getLeftExpression());
        return null;
    }

    @Override
    public <S> Void visit(SimilarToExpression expr, S context) {
        this.validateFeature(Feature.exprSimilarTo);
        this.visitBinaryExpression(expr, (expr.isNot() ? " NOT" : "") + " SIMILAR TO ");
        return null;
    }

    @Override
    public <S> Void visit(ArrayExpression array, S context) {
        array.getObjExpression().accept(this, context);
        if (array.getIndexExpression() != null) {
            array.getIndexExpression().accept(this, context);
        }
        if (array.getStartIndexExpression() != null) {
            array.getStartIndexExpression().accept(this, context);
        }
        if (array.getStopIndexExpression() != null) {
            array.getStopIndexExpression().accept(this, context);
        }
        return null;
    }

    @Override
    public <S> Void visit(ArrayConstructor aThis, S context) {
        for (Expression expression : aThis.getExpressions()) {
            expression.accept(this, context);
        }
        return null;
    }

    @Override
    public void validate(Expression expression) {
        expression.accept(this, null);
    }

    @Override
    public <S> Void visit(VariableAssignment a, S context) {
        this.validateOptionalExpression(a.getExpression());
        if (a.getVariable() != null) {
            a.getVariable().accept(this, context);
        }
        return null;
    }

    @Override
    public <S> Void visit(TimezoneExpression a, S context) {
        this.validateOptionalExpression(a.getLeftExpression());
        return null;
    }

    @Override
    public <S> Void visit(XMLSerializeExpr xml, S context) {
        return null;
    }

    @Override
    public <S> Void visit(JsonAggregateFunction expression, S context) {
        return null;
    }

    @Override
    public <S> Void visit(JsonFunction expression, S context) {
        return null;
    }

    @Override
    public <S> Void visit(ConnectByRootOperator connectByRootOperator, S context) {
        connectByRootOperator.getColumn().accept(this, context);
        return null;
    }

    @Override
    public <S> Void visit(ConnectByPriorOperator connectByPriorOperator, S context) {
        connectByPriorOperator.getColumn().accept(this, context);
        return null;
    }

    @Override
    public <S> Void visit(OracleNamedFunctionParameter oracleNamedFunctionParameter, S context) {
        oracleNamedFunctionParameter.getExpression().accept(this, context);
        return null;
    }

    @Override
    public <S> Void visit(AllColumns allColumns, S context) {
        return null;
    }

    @Override
    public <S> Void visit(AllTableColumns allTableColumns, S context) {
        return null;
    }

    @Override
    public <S> Void visit(AllValue allValue, S context) {
        return null;
    }

    @Override
    public <S> Void visit(IsDistinctExpression isDistinctExpression, S context) {
        isDistinctExpression.getLeftExpression().accept(this, context);
        isDistinctExpression.getRightExpression().accept(this, context);
        return null;
    }

    @Override
    public <S> Void visit(GeometryDistance geometryDistance, S context) {
        this.validateOldOracleJoinBinaryExpression(geometryDistance, " <-> ", context);
        return null;
    }

    @Override
    public <S> Void visit(Select select, S context) {
        return null;
    }

    @Override
    public <S> Void visit(TranscodingFunction transcodingFunction, S context) {
        transcodingFunction.getExpression().accept(this, context);
        return null;
    }

    @Override
    public <S> Void visit(TrimFunction trimFunction, S context) {
        if (trimFunction.getExpression() != null) {
            trimFunction.getExpression().accept(this, context);
        }
        if (trimFunction.getFromExpression() != null) {
            trimFunction.getFromExpression().accept(this, context);
        }
        return null;
    }

    @Override
    public <S> Void visit(RangeExpression rangeExpression, S context) {
        rangeExpression.getStartExpression().accept(this, context);
        rangeExpression.getEndExpression().accept(this, context);
        return null;
    }

    @Override
    public <S> Void visit(TSQLLeftJoin tsqlLeftJoin, S context) {
        tsqlLeftJoin.getLeftExpression().accept(this, context);
        tsqlLeftJoin.getRightExpression().accept(this, context);
        return null;
    }

    @Override
    public <S> Void visit(TSQLRightJoin tsqlRightJoin, S context) {
        tsqlRightJoin.getLeftExpression().accept(this, context);
        tsqlRightJoin.getRightExpression().accept(this, context);
        return null;
    }

    @Override
    public <S> Void visit(StructType structType, S context) {
        if (structType.getArguments() != null) {
            for (SelectItem<?> selectItem : structType.getArguments()) {
                selectItem.getExpression().accept(this, context);
            }
        }
        return null;
    }

    @Override
    public <S> Void visit(LambdaExpression lambdaExpression, S context) {
        lambdaExpression.getExpression().accept(this, context);
        return null;
    }

    @Override
    public <S> Void visit(HighExpression highExpression, S context) {
        highExpression.getExpression().accept(this, context);
        return null;
    }

    @Override
    public <S> Void visit(LowExpression lowExpression, S context) {
        lowExpression.getExpression().accept(this, context);
        return null;
    }

    @Override
    public <S> Void visit(Plus plus, S context) {
        this.visitBinaryExpression(plus, " PLUS ");
        return null;
    }

    @Override
    public <S> Void visit(PriorTo priorTo, S context) {
        this.visitBinaryExpression(priorTo, " PLUS ");
        return null;
    }

    @Override
    public <S> Void visit(Inverse inverse, S context) {
        inverse.getExpression().accept(this, context);
        return null;
    }

    @Override
    public void visit(TimeKeyExpression timeKeyExpression) {
        this.visit(timeKeyExpression, (Object)null);
    }

    @Override
    public void visit(DateTimeLiteralExpression literal) {
        this.visit(literal, (Object)null);
    }

    @Override
    public void visit(NextValExpression nextVal) {
        this.visit(nextVal, (Object)null);
    }

    @Override
    public void visit(CollateExpression col) {
        this.visit(col, (Object)null);
    }

    @Override
    public void visit(SimilarToExpression expr) {
        this.visit(expr, (Object)null);
    }

    @Override
    public void visit(ArrayExpression array) {
        this.visit(array, (Object)null);
    }

    @Override
    public void visit(ArrayConstructor aThis) {
        this.visit(aThis, (Object)null);
    }

    @Override
    public void visit(VariableAssignment a) {
        this.visit(a, (Object)null);
    }

    @Override
    public void visit(TimezoneExpression a) {
        this.visit(a, (Object)null);
    }

    @Override
    public void visit(XMLSerializeExpr xml) {
        this.visit(xml, (Object)null);
    }

    @Override
    public void visit(JsonAggregateFunction expression) {
        this.visit(expression, (Object)null);
    }

    @Override
    public void visit(JsonFunction expression) {
        this.visit(expression, (Object)null);
    }

    @Override
    public void visit(ConnectByRootOperator connectByRootOperator) {
        this.visit(connectByRootOperator, (Object)null);
    }

    @Override
    public void visit(OracleNamedFunctionParameter oracleNamedFunctionParameter) {
        this.visit(oracleNamedFunctionParameter, (Object)null);
    }

    @Override
    public void visit(AllColumns allColumns) {
        this.visit(allColumns, (Object)null);
    }

    @Override
    public void visit(AllTableColumns allTableColumns) {
        this.visit(allTableColumns, (Object)null);
    }

    @Override
    public void visit(AllValue allValue) {
        this.visit(allValue, (Object)null);
    }

    @Override
    public void visit(IsDistinctExpression isDistinctExpression) {
        this.visit(isDistinctExpression, (Object)null);
    }

    @Override
    public void visit(GeometryDistance geometryDistance) {
        this.visit(geometryDistance, (Object)null);
    }

    public void visit(Select select) {
        this.visit(select, (Object)null);
    }

    @Override
    public void visit(TranscodingFunction transcodingFunction) {
        this.visit(transcodingFunction, (Object)null);
    }

    @Override
    public void visit(TrimFunction trimFunction) {
        this.visit(trimFunction, (Object)null);
    }

    @Override
    public void visit(RangeExpression rangeExpression) {
        this.visit(rangeExpression, (Object)null);
    }

    @Override
    public void visit(TSQLLeftJoin tsqlLeftJoin) {
        this.visit(tsqlLeftJoin, (Object)null);
    }

    @Override
    public void visit(TSQLRightJoin tsqlRightJoin) {
        this.visit(tsqlRightJoin, (Object)null);
    }

    @Override
    public void visit(StructType structType) {
        this.visit(structType, (Object)null);
    }

    @Override
    public void visit(LambdaExpression lambdaExpression) {
        this.visit(lambdaExpression, (Object)null);
    }

    @Override
    public void visit(HighExpression highExpression) {
        this.visit(highExpression, (Object)null);
    }

    @Override
    public void visit(LowExpression lowExpression) {
        this.visit(lowExpression, (Object)null);
    }

    @Override
    public void visit(Plus plus) {
        this.visit(plus, (Object)null);
    }

    @Override
    public void visit(PriorTo priorTo) {
        this.visit(priorTo, (Object)null);
    }

    @Override
    public void visit(Inverse inverse) {
        this.visit(inverse, (Object)null);
    }

    @Override
    public <S> Void visit(CosineSimilarity cosineSimilarity, S context) {
        cosineSimilarity.getLeftExpression().accept(this, context);
        cosineSimilarity.getRightExpression().accept(this, context);
        return null;
    }
}

