/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.dameng.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.dameng.DamengConstants;
import org.jkiss.dbeaver.ext.dameng.model.DamengUtils;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericUniqueKey;
import org.jkiss.dbeaver.model.DBPObjectWithLongId;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableCheckConstraint;

public class DamengTableConstraint
extends GenericUniqueKey
implements DBPObjectWithLongId,
DBSTableCheckConstraint,
DBPScriptObject {
    private long id;
    private Status status;
    private String checkInfo;
    private Timestamp createTime;

    public DamengTableConstraint(GenericTableBase table, String name, DBSEntityConstraintType constraintType, JDBCResultSet dbResult, boolean persisted) {
        super(table, name, null, constraintType, persisted);
        this.id = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"ID");
        this.createTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"CRTDATE");
        this.status = "Y".equals(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"VALID")) ? Status.VALID : Status.INVALID;
        this.checkInfo = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CHECKINFO");
    }

    @Property(viewable=true, order=1)
    public long getObjectId() {
        return this.id;
    }

    @Property(viewable=true, order=5)
    public String getCheckConstraintDefinition() {
        return this.checkInfo;
    }

    @Property(viewable=true, order=6)
    public Status getStatus() {
        return this.status;
    }

    @Property(viewable=true, order=7)
    public Timestamp getCreateTime() {
        return this.createTime;
    }

    public void setCheckConstraintDefinition(String expression) {
        this.checkInfo = expression;
    }

    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        return DamengUtils.getDDL(monitor, (DBSObject)this, DamengConstants.ObjectType.CONSTRAINT, ((GenericTableBase)this.getTable()).getSchemaName());
    }

    public static enum Status {
        VALID,
        INVALID;

    }
}

