# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.3.0
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _repo
else:
    import _repo

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


import weakref

class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _repo.delete_SwigPyIterator

    def value(self):
        return _repo.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _repo.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _repo.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _repo.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _repo.SwigPyIterator_equal(self, x)

    def copy(self):
        return _repo.SwigPyIterator_copy(self)

    def next(self):
        return _repo.SwigPyIterator_next(self)

    def __next__(self):
        return _repo.SwigPyIterator___next__(self)

    def previous(self):
        return _repo.SwigPyIterator_previous(self)

    def advance(self, n):
        return _repo.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _repo.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _repo.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _repo.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _repo.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _repo.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _repo.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _repo:
_repo.SwigPyIterator_swigregister(SwigPyIterator)
from . import common
from . import exception
from . import conf
from . import logger
class ConfigRepo(conf.Config):
    r"""Holds repo configuration options. Default values of some options are inherited from ConfigMain."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    __swig_destroy__ = _repo.delete_ConfigRepo

    def __init__(self, *args):
        _repo.ConfigRepo_swiginit(self, _repo.new_ConfigRepo(*args))

    def get_main_config(self, *args):
        return _repo.ConfigRepo_get_main_config(self, *args)

    def get_id(self):
        return _repo.ConfigRepo_get_id(self)

    def get_name_option(self, *args):
        return _repo.ConfigRepo_get_name_option(self, *args)

    def get_enabled_option(self, *args):
        return _repo.ConfigRepo_get_enabled_option(self, *args)

    def get_basecachedir_option(self, *args):
        return _repo.ConfigRepo_get_basecachedir_option(self, *args)

    def get_baseurl_option(self, *args):
        return _repo.ConfigRepo_get_baseurl_option(self, *args)

    def get_mirrorlist_option(self, *args):
        return _repo.ConfigRepo_get_mirrorlist_option(self, *args)

    def get_metalink_option(self, *args):
        return _repo.ConfigRepo_get_metalink_option(self, *args)

    def get_type_option(self, *args):
        return _repo.ConfigRepo_get_type_option(self, *args)

    def get_mediaid_option(self, *args):
        return _repo.ConfigRepo_get_mediaid_option(self, *args)

    def get_gpgkey_option(self, *args):
        return _repo.ConfigRepo_get_gpgkey_option(self, *args)

    def get_excludepkgs_option(self, *args):
        return _repo.ConfigRepo_get_excludepkgs_option(self, *args)

    def get_includepkgs_option(self, *args):
        return _repo.ConfigRepo_get_includepkgs_option(self, *args)

    def get_fastestmirror_option(self, *args):
        return _repo.ConfigRepo_get_fastestmirror_option(self, *args)

    def get_proxy_option(self, *args):
        return _repo.ConfigRepo_get_proxy_option(self, *args)

    def get_proxy_username_option(self, *args):
        return _repo.ConfigRepo_get_proxy_username_option(self, *args)

    def get_proxy_password_option(self, *args):
        return _repo.ConfigRepo_get_proxy_password_option(self, *args)

    def get_proxy_auth_method_option(self, *args):
        return _repo.ConfigRepo_get_proxy_auth_method_option(self, *args)

    def get_username_option(self, *args):
        return _repo.ConfigRepo_get_username_option(self, *args)

    def get_password_option(self, *args):
        return _repo.ConfigRepo_get_password_option(self, *args)

    def get_protected_packages_option(self, *args):
        return _repo.ConfigRepo_get_protected_packages_option(self, *args)

    def get_gpgcheck_option(self, *args):
        r"""
        *Overload 1:*
        Deprecated: Use get_pkg_gpgcheck_option()

        |

        *Overload 2:*
        Deprecated: Use get_pkg_gpgcheck_option() const
        """
        return _repo.ConfigRepo_get_gpgcheck_option(self, *args)

    def get_pkg_gpgcheck_option(self, *args):
        return _repo.ConfigRepo_get_pkg_gpgcheck_option(self, *args)

    def get_repo_gpgcheck_option(self, *args):
        return _repo.ConfigRepo_get_repo_gpgcheck_option(self, *args)

    def get_enablegroups_option(self, *args):
        return _repo.ConfigRepo_get_enablegroups_option(self, *args)

    def get_retries_option(self, *args):
        r"""
        *Overload 1:*
        Deprecated: The option does nothing

        |

        *Overload 2:*
        Deprecated: The option does nothing
        """
        return _repo.ConfigRepo_get_retries_option(self, *args)

    def get_bandwidth_option(self, *args):
        return _repo.ConfigRepo_get_bandwidth_option(self, *args)

    def get_minrate_option(self, *args):
        return _repo.ConfigRepo_get_minrate_option(self, *args)

    def get_ip_resolve_option(self, *args):
        return _repo.ConfigRepo_get_ip_resolve_option(self, *args)

    def get_throttle_option(self, *args):
        return _repo.ConfigRepo_get_throttle_option(self, *args)

    def get_timeout_option(self, *args):
        return _repo.ConfigRepo_get_timeout_option(self, *args)

    def get_max_parallel_downloads_option(self, *args):
        return _repo.ConfigRepo_get_max_parallel_downloads_option(self, *args)

    def get_metadata_expire_option(self, *args):
        return _repo.ConfigRepo_get_metadata_expire_option(self, *args)

    def get_cost_option(self, *args):
        return _repo.ConfigRepo_get_cost_option(self, *args)

    def get_priority_option(self, *args):
        return _repo.ConfigRepo_get_priority_option(self, *args)

    def get_module_hotfixes_option(self, *args):
        return _repo.ConfigRepo_get_module_hotfixes_option(self, *args)

    def get_sslcacert_option(self, *args):
        return _repo.ConfigRepo_get_sslcacert_option(self, *args)

    def get_sslverify_option(self, *args):
        return _repo.ConfigRepo_get_sslverify_option(self, *args)

    def get_sslclientcert_option(self, *args):
        return _repo.ConfigRepo_get_sslclientcert_option(self, *args)

    def get_sslclientkey_option(self, *args):
        return _repo.ConfigRepo_get_sslclientkey_option(self, *args)

    def get_proxy_sslcacert_option(self, *args):
        return _repo.ConfigRepo_get_proxy_sslcacert_option(self, *args)

    def get_proxy_sslverify_option(self, *args):
        return _repo.ConfigRepo_get_proxy_sslverify_option(self, *args)

    def get_proxy_sslclientcert_option(self, *args):
        return _repo.ConfigRepo_get_proxy_sslclientcert_option(self, *args)

    def get_proxy_sslclientkey_option(self, *args):
        return _repo.ConfigRepo_get_proxy_sslclientkey_option(self, *args)

    def get_deltarpm_option(self, *args):
        r"""
        *Overload 1:*
        Deprecated: The option does nothing

        |

        *Overload 2:*
        Deprecated: The option does nothing
        """
        return _repo.ConfigRepo_get_deltarpm_option(self, *args)

    def get_deltarpm_percentage_option(self, *args):
        r"""
        *Overload 1:*
        Deprecated: The option does nothing

        |

        *Overload 2:*
        Deprecated: The option does nothing
        """
        return _repo.ConfigRepo_get_deltarpm_percentage_option(self, *args)

    def get_skip_if_unavailable_option(self, *args):
        return _repo.ConfigRepo_get_skip_if_unavailable_option(self, *args)

    def get_build_cache_option(self, *args):
        r"""If true it will create libsolv cache that will speed up the next loading process"""
        return _repo.ConfigRepo_get_build_cache_option(self, *args)

    def get_enabled_metadata_option(self, *args):
        return _repo.ConfigRepo_get_enabled_metadata_option(self, *args)

    def get_user_agent_option(self, *args):
        return _repo.ConfigRepo_get_user_agent_option(self, *args)

    def get_countme_option(self, *args):
        return _repo.ConfigRepo_get_countme_option(self, *args)

    def get_failovermethod_option(self, *args):
        return _repo.ConfigRepo_get_failovermethod_option(self, *args)

    def get_unique_id(self):
        r"""
        :rtype: string
        :return: A unique ID of the repository, consisting of its id and a hash
            computed from its source URLs (metalink, mirrorlist or baseurl, first
            one set is used in the order listed).
        """
        return _repo.ConfigRepo_get_unique_id(self)

    def get_cachedir(self):
        r"""
        :rtype: string
        :return: The path to the repository's cache directory, where its
            cached metadata are stored. The path contains unique ID generated by get_unique_id()
        """
        return _repo.ConfigRepo_get_cachedir(self)

    def get_persistdir(self):
        r"""
        :rtype: string
        :return: The path to the repository's persistent directory, where its
            persistent data are stored.
        """
        return _repo.ConfigRepo_get_persistdir(self)

    def load_from_parser(self, *args):
        return _repo.ConfigRepo_load_from_parser(self, *args)

# Register ConfigRepo in _repo:
_repo.ConfigRepo_swigregister(ConfigRepo)
class DownloadCallbacks(object):
    r"""
    Base class for download callbacks.
    To implement a callback, inherit from this class and override the virtual methods.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    FastestMirrorStage_INIT = _repo.DownloadCallbacks_FastestMirrorStage_INIT
    r"""Fastest mirror detection started. ptr is `nullptr`."""
    FastestMirrorStage_CACHELOADING = _repo.DownloadCallbacks_FastestMirrorStage_CACHELOADING
    r"""
    `ptr` is a (`char *`) pointer to a string with path to the cache file.
    Do not modify or free the string.
    """
    FastestMirrorStage_CACHELOADINGSTATUS = _repo.DownloadCallbacks_FastestMirrorStage_CACHELOADINGSTATUS
    r"""
    If cache was loaded successfully, `ptr` is `nullptr`, otherwise it
    is a (`char *`) string containing the error message. Do not modify
    or free the string.
    """
    FastestMirrorStage_DETECTION = _repo.DownloadCallbacks_FastestMirrorStage_DETECTION
    r"""
    Detection (pinging) in progress. If all data was loaded from cache,
    this stage is skipped. `ptr` is a pointer to `long`, the number of
    mirrors which will be tested.
    """
    FastestMirrorStage_FINISHING = _repo.DownloadCallbacks_FastestMirrorStage_FINISHING
    r"""
    Detection is done, sorting mirrors, updating cache, etc. `ptr` is
    `nullptr`.
    """
    FastestMirrorStage_STATUS = _repo.DownloadCallbacks_FastestMirrorStage_STATUS
    r"""
    The last invocation of the fastest mirror callback. If detection
    was successful, `ptr` is `nullptr`. Otherwise it is a (`char *`) /
    string containing the error message. Do not modify or free the
    string.
    """
    TransferStatus_SUCCESSFUL = _repo.DownloadCallbacks_TransferStatus_SUCCESSFUL
    TransferStatus_ALREADYEXISTS = _repo.DownloadCallbacks_TransferStatus_ALREADYEXISTS
    TransferStatus_ERROR = _repo.DownloadCallbacks_TransferStatus_ERROR
    OK = _repo.DownloadCallbacks_OK
    ABORT = _repo.DownloadCallbacks_ABORT
    ERROR = _repo.DownloadCallbacks_ERROR

    def __init__(self):
        if self.__class__ == DownloadCallbacks:
            _self = None
        else:
            _self = self
        _repo.DownloadCallbacks_swiginit(self, _repo.new_DownloadCallbacks(_self, ))
    __swig_destroy__ = _repo.delete_DownloadCallbacks

    def add_new_download(self, user_data, description, total_to_download):
        r"""
        Notify the client that a new download has been created.
        :type user_data: void
        :param user_data: User data entered together with url/package to download.
        :type description: string
        :param description: The message describing new download (url/packagename).
        :type total_to_download: float
        :param total_to_download: Total number of bytes to download.
        :rtype: void
        :return: Associated user data for new download.
        """
        return _repo.DownloadCallbacks_add_new_download(self, user_data, description, total_to_download)

    def progress(self, user_cb_data, total_to_download, downloaded):
        r"""
        Download progress callback.
        :type user_cb_data: void
        :param user_cb_data: Associated user data obtained from add_new_download.
        :type total_to_download: float
        :param total_to_download: Total number of bytes to download.
        :type downloaded: float
        :param downloaded: Number of bytes downloaded.
        :rtype: int
        :return: TODO(lukash) uses the LrCbReturnCode enum from librepo, we should translate that.
        """
        return _repo.DownloadCallbacks_progress(self, user_cb_data, total_to_download, downloaded)

    def end(self, user_cb_data, status, msg):
        r"""
        End of download callback.
        :type user_cb_data: void
        :param user_cb_data: Associated user data obtained from add_new_download.
        :type status: int
        :param status: The transfer status.
        :type msg: string
        :param msg: The error message in case of error.
        :rtype: int
        :return: TODO(lukash) uses the LrCbReturnCode enum from librepo, we should translate that.
        """
        return _repo.DownloadCallbacks_end(self, user_cb_data, status, msg)

    def mirror_failure(self, user_cb_data, msg, url, metadata):
        r"""
        Mirror failure callback.
        :type user_cb_data: void
        :param user_cb_data: Associated user data obtained from add_new_download.
        :type msg: string
        :param msg: Error message.
        :type url: string
        :param url: Failed mirror URL.
        :type metadata: string
        :param metadata: the type of metadata that is being downloaded TODO(lukash) should this point to LoadFlags in some way?
        :rtype: int
        :return: TODO(lukash) uses the LrCbReturnCode enum from librepo, we should translate that.
        """
        return _repo.DownloadCallbacks_mirror_failure(self, user_cb_data, msg, url, metadata)

    def fastest_mirror(self, user_cb_data, stage, ptr):
        r"""
        Callback for fastest mirror detection.
        :type user_cb_data: void
        :param user_cb_data: Associated user data obtained from new_download.
        :type stage: int
        :param stage: the stage of the fastest mirror detection, refer to `FastestMirrorStage`
        :type ptr: string
        :param ptr: pointer to additional data depending on the stage, refer to `FastestMirrorStage`
        """
        return _repo.DownloadCallbacks_fastest_mirror(self, user_cb_data, stage, ptr)
    def __disown__(self):
        self.this.disown()
        _repo.disown_DownloadCallbacks(self)
        return weakref.proxy(self)

# Register DownloadCallbacks in _repo:
_repo.DownloadCallbacks_swigregister(DownloadCallbacks)
class DownloadCallbacksUniquePtr(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _repo.DownloadCallbacksUniquePtr_swiginit(self, _repo.new_DownloadCallbacksUniquePtr(*args))

    def __deref__(self):
        return _repo.DownloadCallbacksUniquePtr___deref__(self)

    def release(self):
        return _repo.DownloadCallbacksUniquePtr_release(self)

    def reset(self, __p=None):
        return _repo.DownloadCallbacksUniquePtr_reset(self, __p)

    def swap(self, __u):
        return _repo.DownloadCallbacksUniquePtr_swap(self, __u)

    def get(self):
        return _repo.DownloadCallbacksUniquePtr_get(self)

    def __nonzero__(self):
        return _repo.DownloadCallbacksUniquePtr___nonzero__(self)
    __bool__ = __nonzero__


    __swig_destroy__ = _repo.delete_DownloadCallbacksUniquePtr

    def add_new_download(self, user_data, description, total_to_download):
        r"""
        Notify the client that a new download has been created.
        :type user_data: void
        :param user_data: User data entered together with url/package to download.
        :type description: string
        :param description: The message describing new download (url/packagename).
        :type total_to_download: float
        :param total_to_download: Total number of bytes to download.
        :rtype: void
        :return: Associated user data for new download.
        """
        return _repo.DownloadCallbacksUniquePtr_add_new_download(self, user_data, description, total_to_download)

    def progress(self, user_cb_data, total_to_download, downloaded):
        r"""
        Download progress callback.
        :type user_cb_data: void
        :param user_cb_data: Associated user data obtained from add_new_download.
        :type total_to_download: float
        :param total_to_download: Total number of bytes to download.
        :type downloaded: float
        :param downloaded: Number of bytes downloaded.
        :rtype: int
        :return: TODO(lukash) uses the LrCbReturnCode enum from librepo, we should translate that.
        """
        return _repo.DownloadCallbacksUniquePtr_progress(self, user_cb_data, total_to_download, downloaded)

    def end(self, user_cb_data, status, msg):
        r"""
        End of download callback.
        :type user_cb_data: void
        :param user_cb_data: Associated user data obtained from add_new_download.
        :type status: int
        :param status: The transfer status.
        :type msg: string
        :param msg: The error message in case of error.
        :rtype: int
        :return: TODO(lukash) uses the LrCbReturnCode enum from librepo, we should translate that.
        """
        return _repo.DownloadCallbacksUniquePtr_end(self, user_cb_data, status, msg)

    def mirror_failure(self, user_cb_data, msg, url, metadata):
        r"""
        Mirror failure callback.
        :type user_cb_data: void
        :param user_cb_data: Associated user data obtained from add_new_download.
        :type msg: string
        :param msg: Error message.
        :type url: string
        :param url: Failed mirror URL.
        :type metadata: string
        :param metadata: the type of metadata that is being downloaded TODO(lukash) should this point to LoadFlags in some way?
        :rtype: int
        :return: TODO(lukash) uses the LrCbReturnCode enum from librepo, we should translate that.
        """
        return _repo.DownloadCallbacksUniquePtr_mirror_failure(self, user_cb_data, msg, url, metadata)

    def fastest_mirror(self, user_cb_data, stage, ptr):
        r"""
        Callback for fastest mirror detection.
        :type user_cb_data: void
        :param user_cb_data: Associated user data obtained from new_download.
        :type stage: int
        :param stage: the stage of the fastest mirror detection, refer to `FastestMirrorStage`
        :type ptr: string
        :param ptr: pointer to additional data depending on the stage, refer to `FastestMirrorStage`
        """
        return _repo.DownloadCallbacksUniquePtr_fastest_mirror(self, user_cb_data, stage, ptr)

# Register DownloadCallbacksUniquePtr in _repo:
_repo.DownloadCallbacksUniquePtr_swigregister(DownloadCallbacksUniquePtr)
class FileDownloader(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _repo.FileDownloader_swiginit(self, _repo.new_FileDownloader(*args))
    __swig_destroy__ = _repo.delete_FileDownloader

    def download(self):
        r"""Download the previously added files (URLs)."""
        return _repo.FileDownloader_download(self)

    def set_fail_fast(self, value):
        r"""
        Configure whether to fail the whole download on a first error or keep downloading.
        :type value: boolean
        :param value: If true, download will fail on the first error, otherwise it continues.
            This is set to true by default.
        """
        return _repo.FileDownloader_set_fail_fast(self, value)

    def set_resume(self, value):
        r"""
        Configure whether to try resuming the download if a destination package already exists.
        :type value: boolean
        :param value: If true, download is tried to be resumed, otherwise it starts over.
            This is set to true by default.
        """
        return _repo.FileDownloader_set_resume(self, value)

    def add(self, *args):
        return _repo.FileDownloader_add(self, *args)

# Register FileDownloader in _repo:
_repo.FileDownloader_swigregister(FileDownloader)
class PackageDownloader(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _repo.PackageDownloader_swiginit(self, _repo.new_PackageDownloader(*args))
    __swig_destroy__ = _repo.delete_PackageDownloader

    def download(self):
        r"""Download the previously added packages."""
        return _repo.PackageDownloader_download(self)

    def set_fail_fast(self, value):
        r"""
        Configure whether to fail the whole download on a first error or keep downloading.
        :type value: boolean
        :param value: If true, download will fail on the first error, otherwise it continues.
            This is set to true by default.
        """
        return _repo.PackageDownloader_set_fail_fast(self, value)

    def set_resume(self, value):
        r"""
        Configure whether to try resuming the download if a destination package already exists.
        :type value: boolean
        :param value: If true, download is tried to be resumed, otherwise it starts over.
            This is set to true by default.
        """
        return _repo.PackageDownloader_set_resume(self, value)

    def force_keep_packages(self, value):
        r"""
        Explicitly setup the behavior related to packages caching.
        By default, the `keepcache` configuration option is used to determine whether to keep
        downloaded packages even after following successful transaction.

        :type value: boolean
        :param value: If true, packages will be kept on the disk after downloading
            regardless the `keepcache` option value, if false, it enforces packages removal after
            the next successful transaction.
        """
        return _repo.PackageDownloader_force_keep_packages(self, value)

    def add(self, *args):
        return _repo.PackageDownloader_add(self, *args)

# Register PackageDownloader in _repo:
_repo.PackageDownloader_swigregister(PackageDownloader)
class RepoCacheRemoveStatistics(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    __swig_destroy__ = _repo.delete_RepoCacheRemoveStatistics

    def __init__(self, *args):
        _repo.RepoCacheRemoveStatistics_swiginit(self, _repo.new_RepoCacheRemoveStatistics(*args))

    def get_files_removed(self):
        return _repo.RepoCacheRemoveStatistics_get_files_removed(self)

    def get_dirs_removed(self):
        return _repo.RepoCacheRemoveStatistics_get_dirs_removed(self)

    def get_bytes_removed(self):
        return _repo.RepoCacheRemoveStatistics_get_bytes_removed(self)

    def get_errors(self):
        return _repo.RepoCacheRemoveStatistics_get_errors(self)

    def __iadd__(self, rhs):
        return _repo.RepoCacheRemoveStatistics___iadd__(self, rhs)

# Register RepoCacheRemoveStatistics in _repo:
_repo.RepoCacheRemoveStatistics_swigregister(RepoCacheRemoveStatistics)
class RepoCache(object):
    r"""Repository cache management class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    ATTRIBUTE_EXPIRED = _repo.RepoCache_ATTRIBUTE_EXPIRED
    r"""The name of the attribute used to mark the cache as expired."""
    __swig_destroy__ = _repo.delete_RepoCache

    def __init__(self, *args):
        r"""
        *Overload 1:*
        Construct a new repository cache management instance.

        :type base: libdnf5::BaseWeakPtr
        :param base:            WeakPtr on the Base instance.
        :type repo_cache_dir: std::filesystem::path
        :param repo_cache_dir:  Path to repository cache directory.

        |

        *Overload 2:*
        Construct a new repository cache management instance.

        :type base: libdnf5::Base
        :param base:            Base instance reference.
        :type repo_cache_dir: string
        :param repo_cache_dir:  Path to repository cache directory.
        """
        _repo.RepoCache_swiginit(self, _repo.new_RepoCache(*args))

    def remove_metadata(self):
        r"""
        Removes metadata from the cache.

        :rtype: :py:class:`RemoveStatistics`
        :return: Number of deleted files and directories. Number of errors.
        """
        return _repo.RepoCache_remove_metadata(self)

    def remove_packages(self):
        r"""
        Removes packages from the cache.

        :rtype: :py:class:`RemoveStatistics`
        :return: Number of deleted files and directories. Number of errors.
        """
        return _repo.RepoCache_remove_packages(self)

    def remove_solv_files(self):
        r"""
        Removes solvable files from the cache.

        :rtype: :py:class:`RemoveStatistics`
        :return: Number of deleted files and directories. Number of errors.
        """
        return _repo.RepoCache_remove_solv_files(self)

    def remove_all(self):
        r"""
        Removes metadata, packages, solvable files, and attributes from the cache.
        If the repository cache directory becomes empty, it will also be deleted.

        :rtype: :py:class:`RemoveStatistics`
        :return: Number of deleted files and directories. Number of errors.
        """
        return _repo.RepoCache_remove_all(self)

    def write_attribute(self, *args):
        r"""
        Writes `value` to the` name` attribute.
        If the attribute does not exist, it is created. If it already existed, its value is overwritten.

        :type name: string
        :param name:   Attribute name.
        :type value: string, optional
        :param value:  Attribute value.
        :raises: std::runtime_exception  An error occurred while writing the attribute.
        """
        return _repo.RepoCache_write_attribute(self, *args)

    def read_attribute(self, name):
        r"""
        Returns the value of the `name` attribute.

        :type name: string
        :param name:  Attribute name.
        :rtype: string
        :return: The value of the `name` attribute.
        :raises: std::runtime_exception  The `name` attribute does not exist or an error occurred while reading it.
        """
        return _repo.RepoCache_read_attribute(self, name)

    def is_attribute(self, name):
        r"""
        Tests if the `name` attribute exists.

        :type name: string
        :param name:  Attribute name.
        :rtype: boolean
        :return: If the `name` attribute exists, it returns true otherwise false.
        """
        return _repo.RepoCache_is_attribute(self, name)

    def remove_attribute(self, name):
        r"""
        Removes the `name` attribute.

        :type name: string
        :param name:  Attribute name.
        :rtype: boolean
        :return: true if the attribute was deleted, false if the attribute did not exist.
        :raises: std::runtime_exception An error occurred while removing the attribute.
        """
        return _repo.RepoCache_remove_attribute(self, name)

    def get_repoid(self):
        r"""
        Gets the id of the cached repository.

        :rtype: string
        :return: id of the cached repository.
        :raises: RepoCacheException Throws an exception if the reposiitory id cannot be determined.
        """
        return _repo.RepoCache_get_repoid(self)

# Register RepoCache in _repo:
_repo.RepoCache_swigregister(RepoCache)
class Repo(object):
    r"""
    RPM repository
    Represents a repository used to download packages.
    Remote metadata is cached locally.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    Type_AVAILABLE = _repo.Repo_Type_AVAILABLE
    Type_SYSTEM = _repo.Repo_Type_SYSTEM
    Type_COMMANDLINE = _repo.Repo_Type_COMMANDLINE
    SyncStrategy_LAZY = _repo.Repo_SyncStrategy_LAZY
    SyncStrategy_ONLY_CACHE = _repo.Repo_SyncStrategy_ONLY_CACHE
    SyncStrategy_TRY_CACHE = _repo.Repo_SyncStrategy_TRY_CACHE

    @staticmethod
    def verify_id(repo_id):
        r"""
        Verify repo ID
        :type repo_id: string
        :param repo_id: repo ID to verify
        :rtype: std::string::size_type
        :return: index of the first invalid character in the repo ID (if present) or std::string::npos
        """
        return _repo.Repo_verify_id(repo_id)

    def __init__(self, *args):
        r"""
        *Overload 1:*
        Construct the Repo object
        :type base: libdnf5::BaseWeakPtr
        :param base:   weak pointer to the Base instance
        :type id: string
        :param id:     repo ID to use
        :type type: int, optional
        :param type:   type of repo

        |

        *Overload 2:*
        Construct the Repo object
        :type base: libdnf5::Base
        :param base:   a reference to the Base instance
        :type id: string
        :param id:     repo ID to use
        :type type: int, optional
        :param type:   type of repo

        |

        *Overload 3:*
        Construct the Repo object
        :type base: libdnf5::Base
        :param base:   a reference to the Base instance
        :type id: string
        :param id:     repo ID to use
        :param type:   type of repo
        """
        _repo.Repo_swiginit(self, _repo.new_Repo(*args))
    __swig_destroy__ = _repo.delete_Repo

    def get_type(self):
        r"""Returns the repository type"""
        return _repo.Repo_get_type(self)

    def set_callbacks(self, callbacks):
        r"""Registers a class that implements callback methods (fastest mirror detection, download state, key import)."""
        return _repo.Repo_set_callbacks(self, callbacks)

    def get_callbacks(self):
        r"""Returns the currently registered callbacks for the repo."""
        return _repo.Repo_get_callbacks(self)

    def verify(self):
        r"""
        Verify repo object configuration
        Will throw exception if Repo has no mirror or baseurl set or if Repo type is unsupported.
        """
        return _repo.Repo_verify(self)

    def get_config(self, *args):
        r"""
        *Overload 1:*
        Returns pointer to the repository configuration

        |

        *Overload 2:*
        Returns pointer to the repository configuration
        """
        return _repo.Repo_get_config(self, *args)

    def get_id(self):
        r"""Returns repository id"""
        return _repo.Repo_get_id(self)

    def enable(self):
        r"""Enable the repository"""
        return _repo.Repo_enable(self)

    def disable(self):
        r"""Disable the repository"""
        return _repo.Repo_disable(self)

    def is_enabled(self):
        r"""
        Return whether the repository is enabled.
        :rtype: boolean
        :return: true if enabled
        """
        return _repo.Repo_is_enabled(self)

    def is_local(self):
        r"""
        Return whether the repository is local.
        :rtype: boolean
        :return: true if local
        """
        return _repo.Repo_is_local(self)

    def read_metadata_cache(self):
        r"""Reads metadata from local cache."""
        return _repo.Repo_read_metadata_cache(self)

    def is_in_sync(self):
        r"""
        Checks whether the locally downloaded metadata are in sync with the origin.
        :rtype: boolean
        :return: `true` if metadata are in sync with the origin, `false` otherwise.
        """
        return _repo.Repo_is_in_sync(self)

    def get_use_includes(self):
        r"""
        Returns whether the using of "includes" is enabled
        If enabled, only packages listed in the "includepkgs" will be used from the repository.
        """
        return _repo.Repo_get_use_includes(self)

    def set_use_includes(self, enabled):
        r"""
        Enables/disables using of "includes"
        If enabled, only packages listed in the "includepkgs" will be used from the repository.
        """
        return _repo.Repo_set_use_includes(self, enabled)

    def get_cost(self):
        r"""
        Returns repository cost
        TODO(jrohel): Remove it? It is only shortcut for get_config()->cost()->get_value()
        """
        return _repo.Repo_get_cost(self)

    def set_cost(self, *args):
        r"""
        Set repo cost in RepoConf and in Libsolv repo if attached. Values are only updated when Option::Priority
        of stored value is equal or lower.

        Version: 1.0.0
        :type value: int
        :param value: Cost value
        :type priority: int, optional
        :param priority: Optional argument
        """
        return _repo.Repo_set_cost(self, *args)

    def get_priority(self):
        r"""
        Returns repository priority
        TODO(jrohel): Remove it? It is only shortcut for get_config()->cost()->get_value()
        """
        return _repo.Repo_get_priority(self)

    def set_priority(self, *args):
        r"""
        Set repo priority in RepoConf and in Libsolv repo if attached. Values are only updated when
        Option::Priority of stored value is equal or lower.

        Version: 1.0.0
        :type value: int
        :param value: Priority value
        :type priority: int, optional
        :param priority: Optional argument
        """
        return _repo.Repo_set_priority(self, *args)

    def get_revision(self):
        return _repo.Repo_get_revision(self)

    def get_age(self):
        r"""Gets age of the local cache"""
        return _repo.Repo_get_age(self)

    def get_metadata_path(self, metadata_type):
        r"""
        Return path to the particular downloaded repository metadata in cache
        :type metadata_type: string
        :param metadata_type: metadata type (filelists, other, productid...)
        :rtype: string
        :return: file path or empty string in case the requested metadata does not exist
        """
        return _repo.Repo_get_metadata_path(self, metadata_type)

    def expire(self):
        r"""
        Mark whatever is in the current cache expired.
        This repo instance will always try to fetch a fresh metadata after this
        method is called.
        """
        return _repo.Repo_expire(self)

    def is_expired(self):
        r"""
        Return whether the cached metadata is expired.
        :rtype: boolean
        :return: bool
        """
        return _repo.Repo_is_expired(self)

    def get_expires_in(self):
        r"""
        Get the number of seconds after which the cached metadata will expire.
        Negative number means the metadata has expired already.
        :rtype: int
        :return: Seconds to expiration
        """
        return _repo.Repo_get_expires_in(self)

    def set_max_mirror_tries(self, max_mirror_tries):
        return _repo.Repo_set_max_mirror_tries(self, max_mirror_tries)

    def get_timestamp(self):
        r"""Gets timestamp of metadata "primary" file, if the file is not present returns -1"""
        return _repo.Repo_get_timestamp(self)

    def get_max_timestamp(self):
        r"""
        Gets the highest timestamp from repomd records
        TODO(jrohel): Used in DNF repolist: displayed as "Repo-updated time" base.py: "using metadata from" in debug messages Is it correct?
        """
        return _repo.Repo_get_max_timestamp(self)

    def set_preserve_remote_time(self, preserve_remote_time):
        r"""
        Try to preserve remote side timestamps
        When set to true the underlying librepo is asked to make an attempt to set the timestamps
        of the local downloaded files (repository metadata and packages) to match those from
        the remote files.
        This feature is by default switched off.
        :type preserve_remote_time: boolean
        :param preserve_remote_time: true - use remote file timestamp, false - use the current time
        """
        return _repo.Repo_set_preserve_remote_time(self, preserve_remote_time)

    def get_preserve_remote_time(self):
        return _repo.Repo_get_preserve_remote_time(self)

    def get_content_tags(self):
        r"""TODO(jrohel): Used by DNF repolist. Do we need it?"""
        return _repo.Repo_get_content_tags(self)

    def get_distro_tags(self):
        r"""TODO(jrohel): Used by DNF repolist. Do we need it?"""
        return _repo.Repo_get_distro_tags(self)

    def get_metadata_locations(self):
        r"""
        Get list of relative locations of metadata files inside the repo
        e.g. [('primary', 'repodata/primary.xml.gz'), ('filelists', 'repodata/filelists.xml.gz')...]
        :rtype: std::vector< std::pair< std::string,std::string >,std::allocator< std::pair< std::string,std::string > > >
        :return: vector of (metadata_type, location) string pairs
        """
        return _repo.Repo_get_metadata_locations(self)

    def get_cachedir(self):
        r"""Gets path to the repository cache directory"""
        return _repo.Repo_get_cachedir(self)

    def get_persistdir(self):
        r"""Gets path to the repository persistent directory"""
        return _repo.Repo_get_persistdir(self)

    def get_name(self):
        r"""
        Gets name of repository
        Alias
        """
        return _repo.Repo_get_name(self)

    def set_repo_file_path(self, path):
        r"""Sets repository configuration file path"""
        return _repo.Repo_set_repo_file_path(self, path)

    def get_repo_file_path(self):
        r"""Gets repository configuration file path"""
        return _repo.Repo_get_repo_file_path(self)

    def set_sync_strategy(self, strategy):
        r"""Sets repository synchronisation strategy"""
        return _repo.Repo_set_sync_strategy(self, strategy)

    def get_sync_strategy(self):
        r"""Returns repository synchronisation strategy"""
        return _repo.Repo_get_sync_strategy(self)

    def set_http_headers(self, headers):
        r"""
        Downloads file from URL into given opened file descriptor.
        TODO(lukash) fd seems like an inconvenient API for this function, use target path instead?
                     It also needs defining what it means downloading an URL through a particular repo
        Set http headers.
        :type headers: std::vector< std::string,std::allocator< std::string > >
        :param headers: A vector of full headers ("header: value")
        """
        return _repo.Repo_set_http_headers(self, headers)

    def get_http_headers(self):
        r"""
        Get http headers.
        :rtype: std::vector< std::string,std::allocator< std::string > >
        :return: A vector of full headers ("header: value")
        """
        return _repo.Repo_get_http_headers(self)

    def get_mirrors(self):
        r"""
        Returns mirrorlist associated with the repository.
        Mirrors on this list are mirrors parsed from mirrorlist/metalink specified by LRO_MIRRORLIST or
        from mirrorlist specified by LRO_MIRROSLISTURL and metalink specified by LRO_METALINKURL.
        No URLs specified by LRO_URLS are included in this list.
        """
        return _repo.Repo_get_mirrors(self)

    def get_weak_ptr(self):
        return _repo.Repo_get_weak_ptr(self)

    def get_base(self):
        r"""
        :rtype: libdnf5::BaseWeakPtr
        :return: The `Base` object to which this object belongs.
        Since: 5.0
        """
        return _repo.Repo_get_base(self)

    @staticmethod
    def type_to_string(type):
        r"""Return string representation of the Type enum"""
        return _repo.Repo_type_to_string(type)

    def download_metadata(self, destdir):
        r"""Downloads repository metadata."""
        return _repo.Repo_download_metadata(self, destdir)

    def get_appstream_metadata(self):
        r"""Returns a list of pairs of the rpmmd type and filename of the Appstream data of the repo"""
        return _repo.Repo_get_appstream_metadata(self)

    def set_user_data(self, user_data):
        return _repo.Repo_set_user_data(self, user_data)

    def get_user_data(self):
        return _repo.Repo_get_user_data(self)

# Register Repo in _repo:
_repo.Repo_swigregister(Repo)
class RepoWeakPtr(object):
    r"""
    WeakPtr is a "smart" pointer. It contains a pointer to resource and to guard of resource.
    WeakPtr pointer can be owner of the resource. However, the resource itself may depend on another resource.
    WeakPtr registers/unregisters itself at the guard of resource. And the resource guard invalidates
    the registered WeakPtrs when the resource is unusable (eg. its dependecny was released).
    Note on thread safety:
    It is safe to create, access and destroy WeakPtrs in multiple threads simultaneously.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _repo.RepoWeakPtr_swiginit(self, _repo.new_RepoWeakPtr(*args))
    __swig_destroy__ = _repo.delete_RepoWeakPtr

    def __deref__(self):
        r"""Provides access to the managed object. Generates exception if object is not valid."""
        return _repo.RepoWeakPtr___deref__(self)

    def get(self):
        r"""Returns a pointer to the managed object. Generates exception if object is not valid."""
        return _repo.RepoWeakPtr_get(self)

    def is_valid(self):
        r"""Checks if managed object is valid."""
        return _repo.RepoWeakPtr_is_valid(self)

    def has_same_guard(self, other):
        r"""Checks if the other WeakPtr instance has the same WeakPtrGuard."""
        return _repo.RepoWeakPtr_has_same_guard(self, other)

    def __ref__(self):
        return _repo.RepoWeakPtr___ref__(self)

    def __eq__(self, other):
        return _repo.RepoWeakPtr___eq__(self, other)

    def __ne__(self, other):
        return _repo.RepoWeakPtr___ne__(self, other)

    def __lt__(self, other):
        return _repo.RepoWeakPtr___lt__(self, other)

    def __gt__(self, other):
        return _repo.RepoWeakPtr___gt__(self, other)

    def __le__(self, other):
        return _repo.RepoWeakPtr___le__(self, other)

    def __ge__(self, other):
        return _repo.RepoWeakPtr___ge__(self, other)

    def __hash__(self):
        return _repo.RepoWeakPtr___hash__(self)

    def verify_id(self, repo_id):
        r"""
        Verify repo ID
        :type repo_id: string
        :param repo_id: repo ID to verify
        :rtype: std::string::size_type
        :return: index of the first invalid character in the repo ID (if present) or std::string::npos
        """
        return _repo.RepoWeakPtr_verify_id(self, repo_id)

    def get_type(self):
        r"""Returns the repository type"""
        return _repo.RepoWeakPtr_get_type(self)

    def set_callbacks(self, callbacks):
        r"""Registers a class that implements callback methods (fastest mirror detection, download state, key import)."""
        return _repo.RepoWeakPtr_set_callbacks(self, callbacks)

    def get_callbacks(self):
        r"""Returns the currently registered callbacks for the repo."""
        return _repo.RepoWeakPtr_get_callbacks(self)

    def verify(self):
        r"""
        Verify repo object configuration
        Will throw exception if Repo has no mirror or baseurl set or if Repo type is unsupported.
        """
        return _repo.RepoWeakPtr_verify(self)

    def get_config(self, *args):
        r"""
        *Overload 1:*
        Returns pointer to the repository configuration

        |

        *Overload 2:*
        Returns pointer to the repository configuration
        """
        return _repo.RepoWeakPtr_get_config(self, *args)

    def get_id(self):
        r"""Returns repository id"""
        return _repo.RepoWeakPtr_get_id(self)

    def enable(self):
        r"""Enable the repository"""
        return _repo.RepoWeakPtr_enable(self)

    def disable(self):
        r"""Disable the repository"""
        return _repo.RepoWeakPtr_disable(self)

    def is_enabled(self):
        r"""
        Return whether the repository is enabled.
        :rtype: boolean
        :return: true if enabled
        """
        return _repo.RepoWeakPtr_is_enabled(self)

    def is_local(self):
        r"""
        Return whether the repository is local.
        :rtype: boolean
        :return: true if local
        """
        return _repo.RepoWeakPtr_is_local(self)

    def read_metadata_cache(self):
        r"""Reads metadata from local cache."""
        return _repo.RepoWeakPtr_read_metadata_cache(self)

    def is_in_sync(self):
        r"""
        Checks whether the locally downloaded metadata are in sync with the origin.
        :rtype: boolean
        :return: `true` if metadata are in sync with the origin, `false` otherwise.
        """
        return _repo.RepoWeakPtr_is_in_sync(self)

    def get_use_includes(self):
        r"""
        Returns whether the using of "includes" is enabled
        If enabled, only packages listed in the "includepkgs" will be used from the repository.
        """
        return _repo.RepoWeakPtr_get_use_includes(self)

    def set_use_includes(self, enabled):
        r"""
        Enables/disables using of "includes"
        If enabled, only packages listed in the "includepkgs" will be used from the repository.
        """
        return _repo.RepoWeakPtr_set_use_includes(self, enabled)

    def get_cost(self):
        r"""
        Returns repository cost
        TODO(jrohel): Remove it? It is only shortcut for get_config()->cost()->get_value()
        """
        return _repo.RepoWeakPtr_get_cost(self)

    def set_cost(self, *args):
        r"""
        Set repo cost in RepoConf and in Libsolv repo if attached. Values are only updated when Option::Priority
        of stored value is equal or lower.

        Version: 1.0.0
        :type value: int
        :param value: Cost value
        :type priority: int, optional
        :param priority: Optional argument
        """
        return _repo.RepoWeakPtr_set_cost(self, *args)

    def get_priority(self):
        r"""
        Returns repository priority
        TODO(jrohel): Remove it? It is only shortcut for get_config()->cost()->get_value()
        """
        return _repo.RepoWeakPtr_get_priority(self)

    def set_priority(self, *args):
        r"""
        Set repo priority in RepoConf and in Libsolv repo if attached. Values are only updated when
        Option::Priority of stored value is equal or lower.

        Version: 1.0.0
        :type value: int
        :param value: Priority value
        :type priority: int, optional
        :param priority: Optional argument
        """
        return _repo.RepoWeakPtr_set_priority(self, *args)

    def get_revision(self):
        return _repo.RepoWeakPtr_get_revision(self)

    def get_age(self):
        r"""Gets age of the local cache"""
        return _repo.RepoWeakPtr_get_age(self)

    def get_metadata_path(self, metadata_type):
        r"""
        Return path to the particular downloaded repository metadata in cache
        :type metadata_type: string
        :param metadata_type: metadata type (filelists, other, productid...)
        :rtype: string
        :return: file path or empty string in case the requested metadata does not exist
        """
        return _repo.RepoWeakPtr_get_metadata_path(self, metadata_type)

    def expire(self):
        r"""
        Mark whatever is in the current cache expired.
        This repo instance will always try to fetch a fresh metadata after this
        method is called.
        """
        return _repo.RepoWeakPtr_expire(self)

    def is_expired(self):
        r"""
        Return whether the cached metadata is expired.
        :rtype: boolean
        :return: bool
        """
        return _repo.RepoWeakPtr_is_expired(self)

    def get_expires_in(self):
        r"""
        Get the number of seconds after which the cached metadata will expire.
        Negative number means the metadata has expired already.
        :rtype: int
        :return: Seconds to expiration
        """
        return _repo.RepoWeakPtr_get_expires_in(self)

    def set_max_mirror_tries(self, max_mirror_tries):
        return _repo.RepoWeakPtr_set_max_mirror_tries(self, max_mirror_tries)

    def get_timestamp(self):
        r"""Gets timestamp of metadata "primary" file, if the file is not present returns -1"""
        return _repo.RepoWeakPtr_get_timestamp(self)

    def get_max_timestamp(self):
        r"""
        Gets the highest timestamp from repomd records
        TODO(jrohel): Used in DNF repolist: displayed as "Repo-updated time" base.py: "using metadata from" in debug messages Is it correct?
        """
        return _repo.RepoWeakPtr_get_max_timestamp(self)

    def set_preserve_remote_time(self, preserve_remote_time):
        r"""
        Try to preserve remote side timestamps
        When set to true the underlying librepo is asked to make an attempt to set the timestamps
        of the local downloaded files (repository metadata and packages) to match those from
        the remote files.
        This feature is by default switched off.
        :type preserve_remote_time: boolean
        :param preserve_remote_time: true - use remote file timestamp, false - use the current time
        """
        return _repo.RepoWeakPtr_set_preserve_remote_time(self, preserve_remote_time)

    def get_preserve_remote_time(self):
        return _repo.RepoWeakPtr_get_preserve_remote_time(self)

    def get_content_tags(self):
        r"""TODO(jrohel): Used by DNF repolist. Do we need it?"""
        return _repo.RepoWeakPtr_get_content_tags(self)

    def get_distro_tags(self):
        r"""TODO(jrohel): Used by DNF repolist. Do we need it?"""
        return _repo.RepoWeakPtr_get_distro_tags(self)

    def get_metadata_locations(self):
        r"""
        Get list of relative locations of metadata files inside the repo
        e.g. [('primary', 'repodata/primary.xml.gz'), ('filelists', 'repodata/filelists.xml.gz')...]
        :rtype: std::vector< std::pair< std::string,std::string >,std::allocator< std::pair< std::string,std::string > > >
        :return: vector of (metadata_type, location) string pairs
        """
        return _repo.RepoWeakPtr_get_metadata_locations(self)

    def get_cachedir(self):
        r"""Gets path to the repository cache directory"""
        return _repo.RepoWeakPtr_get_cachedir(self)

    def get_persistdir(self):
        r"""Gets path to the repository persistent directory"""
        return _repo.RepoWeakPtr_get_persistdir(self)

    def get_name(self):
        r"""
        Gets name of repository
        Alias
        """
        return _repo.RepoWeakPtr_get_name(self)

    def set_repo_file_path(self, path):
        r"""Sets repository configuration file path"""
        return _repo.RepoWeakPtr_set_repo_file_path(self, path)

    def get_repo_file_path(self):
        r"""Gets repository configuration file path"""
        return _repo.RepoWeakPtr_get_repo_file_path(self)

    def set_sync_strategy(self, strategy):
        r"""Sets repository synchronisation strategy"""
        return _repo.RepoWeakPtr_set_sync_strategy(self, strategy)

    def get_sync_strategy(self):
        r"""Returns repository synchronisation strategy"""
        return _repo.RepoWeakPtr_get_sync_strategy(self)

    def set_http_headers(self, headers):
        r"""
        Downloads file from URL into given opened file descriptor.
        TODO(lukash) fd seems like an inconvenient API for this function, use target path instead?
                     It also needs defining what it means downloading an URL through a particular repo
        Set http headers.
        :type headers: std::vector< std::string,std::allocator< std::string > >
        :param headers: A vector of full headers ("header: value")
        """
        return _repo.RepoWeakPtr_set_http_headers(self, headers)

    def get_http_headers(self):
        r"""
        Get http headers.
        :rtype: std::vector< std::string,std::allocator< std::string > >
        :return: A vector of full headers ("header: value")
        """
        return _repo.RepoWeakPtr_get_http_headers(self)

    def get_mirrors(self):
        r"""
        Returns mirrorlist associated with the repository.
        Mirrors on this list are mirrors parsed from mirrorlist/metalink specified by LRO_MIRRORLIST or
        from mirrorlist specified by LRO_MIRROSLISTURL and metalink specified by LRO_METALINKURL.
        No URLs specified by LRO_URLS are included in this list.
        """
        return _repo.RepoWeakPtr_get_mirrors(self)

    def get_weak_ptr(self):
        return _repo.RepoWeakPtr_get_weak_ptr(self)

    def get_base(self):
        r"""
        :rtype: libdnf5::BaseWeakPtr
        :return: The `Base` object to which this object belongs.
        Since: 5.0
        """
        return _repo.RepoWeakPtr_get_base(self)

    def type_to_string(self, type):
        r"""Return string representation of the Type enum"""
        return _repo.RepoWeakPtr_type_to_string(self, type)

    def download_metadata(self, destdir):
        r"""Downloads repository metadata."""
        return _repo.RepoWeakPtr_download_metadata(self, destdir)

    def get_appstream_metadata(self):
        r"""Returns a list of pairs of the rpmmd type and filename of the Appstream data of the repo"""
        return _repo.RepoWeakPtr_get_appstream_metadata(self)

    def set_user_data(self, user_data):
        return _repo.RepoWeakPtr_set_user_data(self, user_data)

    def get_user_data(self):
        return _repo.RepoWeakPtr_get_user_data(self)

# Register RepoWeakPtr in _repo:
_repo.RepoWeakPtr_swigregister(RepoWeakPtr)
class SetConstIteratorRepoWeakPtr(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def value(self):
        return _repo.SetConstIteratorRepoWeakPtr_value(self)

    def next(self):
        return _repo.SetConstIteratorRepoWeakPtr_next(self)

    def prev(self):
        return _repo.SetConstIteratorRepoWeakPtr_prev(self)

    def __eq__(self, other):
        return _repo.SetConstIteratorRepoWeakPtr___eq__(self, other)

    def __ne__(self, other):
        return _repo.SetConstIteratorRepoWeakPtr___ne__(self, other)
    __swig_destroy__ = _repo.delete_SetConstIteratorRepoWeakPtr

# Register SetConstIteratorRepoWeakPtr in _repo:
_repo.SetConstIteratorRepoWeakPtr_swigregister(SetConstIteratorRepoWeakPtr)
class SetRepoWeakPtr(object):
    r"""
    Set represents set of objects (e.g. repositories, or groups)
    and implements set operations such as unions or differences.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _repo.delete_SetRepoWeakPtr

    def empty(self):
        return _repo.SetRepoWeakPtr_empty(self)

    def size(self):
        return _repo.SetRepoWeakPtr_size(self)

    def clear(self):
        return _repo.SetRepoWeakPtr_clear(self)

    def add(self, *args):
        return _repo.SetRepoWeakPtr_add(self, *args)

    def remove(self, obj):
        return _repo.SetRepoWeakPtr_remove(self, obj)

    def find(self, obj):
        return _repo.SetRepoWeakPtr_find(self, obj)

    def contains(self, obj):
        return _repo.SetRepoWeakPtr_contains(self, obj)

    def __ior__(self, other):
        return _repo.SetRepoWeakPtr___ior__(self, other)

    def __iand__(self, other):
        return _repo.SetRepoWeakPtr___iand__(self, other)

    def __isub__(self, other):
        return _repo.SetRepoWeakPtr___isub__(self, other)

    def __ixor__(self, other):
        return _repo.SetRepoWeakPtr___ixor__(self, other)

    def update(self, other):
        return _repo.SetRepoWeakPtr_update(self, other)

    def intersection(self, other):
        return _repo.SetRepoWeakPtr_intersection(self, other)

    def difference(self, other):
        return _repo.SetRepoWeakPtr_difference(self, other)

    def symmetric_difference(self, other):
        return _repo.SetRepoWeakPtr_symmetric_difference(self, other)

    def is_subset(self, other):
        return _repo.SetRepoWeakPtr_is_subset(self, other)

    def is_superset(self, other):
        return _repo.SetRepoWeakPtr_is_superset(self, other)

    def swap(self, other):
        return _repo.SetRepoWeakPtr_swap(self, other)

    def get_data(self, *args):
        r"""Return reference to underlying std::set"""
        return _repo.SetRepoWeakPtr_get_data(self, *args)

    def begin(self):
        return _repo.SetRepoWeakPtr_begin(self)

    def end(self):
        return _repo.SetRepoWeakPtr_end(self)

    def __len__(self):
        return _repo.SetRepoWeakPtr___len__(self)

# Register SetRepoWeakPtr in _repo:
_repo.SetRepoWeakPtr_swigregister(SetRepoWeakPtr)

def __eq__(*args):
    return _repo.__eq__(*args)

class SackQueryRepoWeakPtr(SetRepoWeakPtr):
    r"""Query is a Set with filtering capabilities."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _repo.SackQueryRepoWeakPtr_swiginit(self, _repo.new_SackQueryRepoWeakPtr(*args))

    def filter(self, *args):
        return _repo.SackQueryRepoWeakPtr_filter(self, *args)

    def get(self):
        r"""Get a single object. Raise an exception if none or multiple objects match the query."""
        return _repo.SackQueryRepoWeakPtr_get(self)

    def list(self):
        r"""List all objects matching the query."""
        return _repo.SackQueryRepoWeakPtr_list(self)
    __swig_destroy__ = _repo.delete_SackQueryRepoWeakPtr

# Register SackQueryRepoWeakPtr in _repo:
_repo.SackQueryRepoWeakPtr_swigregister(SackQueryRepoWeakPtr)
class RepoCallbacks(object):
    r"""
    Base class for repository callbacks.
    To implement callbacks, inherit from this class and override virtual methods.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        if self.__class__ == RepoCallbacks:
            _self = None
        else:
            _self = self
        _repo.RepoCallbacks_swiginit(self, _repo.new_RepoCallbacks(_self, ))
    __swig_destroy__ = _repo.delete_RepoCallbacks

    def repokey_import(self, key_info):
        r"""
        OpenPGP key import callback. Allows to confirm or deny the import.
        :type key_info: libdnf5::rpm::KeyInfo
        :param key_info: The key that is about to be imported
        :rtype: boolean
        :return: `true` to import the key, `false` to not import
        """
        return _repo.RepoCallbacks_repokey_import(self, key_info)

    def repokey_imported(self, key_info):
        r"""
        Called on successful repo key import.
        :type key_info: libdnf5::rpm::KeyInfo
        :param key_info: The key that was successfully imported
        """
        return _repo.RepoCallbacks_repokey_imported(self, key_info)
    def __disown__(self):
        self.this.disown()
        _repo.disown_RepoCallbacks(self)
        return weakref.proxy(self)

# Register RepoCallbacks in _repo:
_repo.RepoCallbacks_swigregister(RepoCallbacks)
class RepoCallbacks2_1(RepoCallbacks):
    r"""Extended repository callbacks with additional methods for support of key removal."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        _repo.RepoCallbacks2_1_swiginit(self, _repo.new_RepoCallbacks2_1())
    __swig_destroy__ = _repo.delete_RepoCallbacks2_1

    def repokey_remove(self, key_info, removal_info):
        r"""
        OpenPGP key remove callback. Allows to confirm or deny the removal.
        :type key_info: libdnf5::rpm::KeyInfo
        :param key_info: The key that is about to be removed
        :type removal_info: :py:class:`Message`
        :param removal_info: Additional information about the key removal
        :rtype: boolean
        :return: `true` to remove the key, `false` to not remove
        """
        return _repo.RepoCallbacks2_1_repokey_remove(self, key_info, removal_info)

    def repokey_removed(self, key_info):
        r"""
        Called on successful repo key removal.
        :type key_info: libdnf5::rpm::KeyInfo
        :param key_info: The key that was successfully removed
        """
        return _repo.RepoCallbacks2_1_repokey_removed(self, key_info)

# Register RepoCallbacks2_1 in _repo:
_repo.RepoCallbacks2_1_swigregister(RepoCallbacks2_1)
class RepoCallbacksUniquePtr(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _repo.RepoCallbacksUniquePtr_swiginit(self, _repo.new_RepoCallbacksUniquePtr(*args))

    def __deref__(self):
        return _repo.RepoCallbacksUniquePtr___deref__(self)

    def release(self):
        return _repo.RepoCallbacksUniquePtr_release(self)

    def reset(self, __p=None):
        return _repo.RepoCallbacksUniquePtr_reset(self, __p)

    def swap(self, __u):
        return _repo.RepoCallbacksUniquePtr_swap(self, __u)

    def get(self):
        return _repo.RepoCallbacksUniquePtr_get(self)

    def __nonzero__(self):
        return _repo.RepoCallbacksUniquePtr___nonzero__(self)
    __bool__ = __nonzero__


    __swig_destroy__ = _repo.delete_RepoCallbacksUniquePtr

    def repokey_import(self, key_info):
        r"""
        OpenPGP key import callback. Allows to confirm or deny the import.
        :type key_info: libdnf5::rpm::KeyInfo
        :param key_info: The key that is about to be imported
        :rtype: boolean
        :return: `true` to import the key, `false` to not import
        """
        return _repo.RepoCallbacksUniquePtr_repokey_import(self, key_info)

    def repokey_imported(self, key_info):
        r"""
        Called on successful repo key import.
        :type key_info: libdnf5::rpm::KeyInfo
        :param key_info: The key that was successfully imported
        """
        return _repo.RepoCallbacksUniquePtr_repokey_imported(self, key_info)

# Register RepoCallbacksUniquePtr in _repo:
_repo.RepoCallbacksUniquePtr_swigregister(RepoCallbacksUniquePtr)
class RepoQuery(SackQueryRepoWeakPtr):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    __swig_destroy__ = _repo.delete_RepoQuery

    def __init__(self, *args):
        r"""
        *Overload 1:*
        Create a new RepoQuery instance.

        :type base: libdnf5::BaseWeakPtr
        :param base:     A weak pointer to Base

        |

        *Overload 2:*
        Create a new RepoQuery instance.

        :type base: libdnf5::Base
        :param base:     Reference to Base
        """
        _repo.RepoQuery_swiginit(self, _repo.new_RepoQuery(*args))

    def get_base(self):
        r"""
        :rtype: libdnf5::BaseWeakPtr
        :return: Weak pointer to the Base object.
        Since: 5.0
        """
        return _repo.RepoQuery_get_base(self)

    def filter_enabled(self, enabled):
        r"""
        Filter repos by their `enabled` state.

        :type enabled: boolean
        :param enabled:  A boolean value the filter is matched against.
        Since: 5.0
        """
        return _repo.RepoQuery_filter_enabled(self, enabled)

    def filter_expired(self, expired):
        r"""
        Filter repos by their `expired` state.

        :type expired: boolean
        :param expired:  A boolean value the filter is matched against.
        Since: 5.0
        """
        return _repo.RepoQuery_filter_expired(self, expired)

    def filter_id(self, *args):
        r"""
        *Overload 1:*
        Filter repos by their `id`.

        :type pattern: string
        :param pattern:  A string the filter is matched against.
        :type cmp: int, optional
        :param cmp:      A comparison (match) operator, defaults to `QueryCmp::EQ`.
        Since: 5.0

        |

        *Overload 2:*
        Filter repos by their `id`.

        :type patterns: std::vector< std::string,std::allocator< std::string > >
        :param patterns: A vector of strings the filter is matched against.
        :type cmp: int, optional
        :param cmp:      A comparison (match) operator, defaults to `QueryCmp::EQ`.
        Since: 5.0

        |

        *Overload 3:*
        Filter repos by their `id`.

        :type patterns: std::vector< std::string,std::allocator< std::string > >
        :param patterns: A vector of strings the filter is matched against.
        :param cmp:      A comparison (match) operator, defaults to `QueryCmp::EQ`.
        Since: 5.0
        """
        return _repo.RepoQuery_filter_id(self, *args)

    def filter_local(self, local):
        r"""
        Filter repositories by whether they are local

        :type local: boolean
        :param local:  `true` returns local repos, `false` remote repos.
        Since: 5.0
        """
        return _repo.RepoQuery_filter_local(self, local)

    def filter_name(self, *args):
        r"""
        *Overload 1:*
        Filter repos by their `name`.

        :type pattern: string
        :param pattern:  A string the filter is matched against.
        :type cmp: int, optional
        :param cmp:      A comparison (match) operator, defaults to `QueryCmp::EQ`.
        Since: 5.0

        |

        *Overload 2:*
        Filter repos by their `name`.

        :type patterns: std::vector< std::string,std::allocator< std::string > >
        :param patterns: A vector of strings the filter is matched against.
        :type cmp: int, optional
        :param cmp:      A comparison (match) operator, defaults to `QueryCmp::EQ`.
        Since: 5.0

        |

        *Overload 3:*
        Filter repos by their `name`.

        :type patterns: std::vector< std::string,std::allocator< std::string > >
        :param patterns: A vector of strings the filter is matched against.
        :param cmp:      A comparison (match) operator, defaults to `QueryCmp::EQ`.
        Since: 5.0
        """
        return _repo.RepoQuery_filter_name(self, *args)

    def filter_type(self, *args):
        r"""
        Filter repos by their `type`.

        :type type: int
        :param type:     A type the filter is matched against.
        :type cmp: int, optional
        :param cmp:      A comparison (match) operator, defaults to `QueryCmp::EQ`.
        Since: 5.0
        """
        return _repo.RepoQuery_filter_type(self, *args)

# Register RepoQuery in _repo:
_repo.RepoQuery_swigregister(RepoQuery)
class SackRepoRepoQuery(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def size(self):
        return _repo.SackRepoRepoQuery_size(self)

    def get_excludes(self):
        return _repo.SackRepoRepoQuery_get_excludes(self)

    def add_excludes(self, value):
        return _repo.SackRepoRepoQuery_add_excludes(self, value)

    def remove_excludes(self, value):
        return _repo.SackRepoRepoQuery_remove_excludes(self, value)

    def set_excludes(self, value):
        return _repo.SackRepoRepoQuery_set_excludes(self, value)

    def get_includes(self):
        return _repo.SackRepoRepoQuery_get_includes(self)

    def add_includes(self, value):
        return _repo.SackRepoRepoQuery_add_includes(self, value)

    def remove_includes(self, value):
        return _repo.SackRepoRepoQuery_remove_includes(self, value)

    def set_includes(self, value):
        return _repo.SackRepoRepoQuery_set_includes(self, value)

    def get_use_includes(self):
        return _repo.SackRepoRepoQuery_get_use_includes(self)

    def set_use_includes(self, value):
        return _repo.SackRepoRepoQuery_set_use_includes(self, value)
    __swig_destroy__ = _repo.delete_SackRepoRepoQuery

# Register SackRepoRepoQuery in _repo:
_repo.SackRepoRepoQuery_swigregister(SackRepoRepoQuery)
class RepoSack(SackRepoRepoQuery):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def create_repo(self, id):
        r"""
        Creates a new clear repository with default configuration.
        :type id: string
        :param id: The new repo id
        :rtype: :py:class:`RepoWeakPtr`
        :return: A weak pointer to the new repo
        """
        return _repo.RepoSack_create_repo(self, id)

    def create_repos_from_file(self, path):
        r"""
        Creates new repositories from the configuration file at `path`.
        :type path: string
        :param path: The path to the repository configuration file
        """
        return _repo.RepoSack_create_repos_from_file(self, path)

    def create_repos_from_config_file(self):
        r"""
        Creates new repositories from the Base's configuration file (the
        "config_file_path" configuration option).

        Repositories can be configured in dnf's main configuration file in
        sections other than "[main]".
        """
        return _repo.RepoSack_create_repos_from_config_file(self)

    def create_repos_from_dir(self, dir_path):
        r"""
        Creates new repositories from all configuration files with the ".repo"
        extension in the `dir_path` directory.

        The files in the directory are read in alphabetical order.
        :type dir_path: string
        :param dir_path: The path to the directory with configuration files
        """
        return _repo.RepoSack_create_repos_from_dir(self, dir_path)

    def create_repos_from_reposdir(self):
        r"""
        Creates new repositories from all configuration files with ".repo" extension in the directories
        defined by the "reposdir" configuration option.

        The files in the directories are read in alphabetical order.
        """
        return _repo.RepoSack_create_repos_from_reposdir(self)

    def create_repos_from_paths(self, repos_paths, priority):
        r"""
        Create new repositories from ids and paths.
        :type repos_paths: std::vector< std::pair< std::string,std::string >,std::allocator< std::pair< std::string,std::string > > >
        :param repos_paths: Vector of <ID,PATH> pairs. The "baseurl" parameter of the new repo is set to the PATH, "name" and "id" to the ID. Both values can be enriched by the repository variables which are substituted before creating the repo.
        :type priority: int
        :param priority: Priority with which the name and baseurl attributes of the new repo are set.
        """
        return _repo.RepoSack_create_repos_from_paths(self, repos_paths, priority)

    def create_repos_from_system_configuration(self):
        r"""
        Creates new repositories from the Base's configuration file (the /
        "config_file_path" configuration option) and from directories defined by
        the "reposdir" configuration option. Repository overrides are then applied.

        Calls `create_repos_from_config_file()`, `create_repos_from_reposdir()`,
        and loads repository configuration overrides.
        """
        return _repo.RepoSack_create_repos_from_system_configuration(self)

    def create_repo_from_libsolv_testcase(self, id, path):
        r"""
        Creates a new repository from a libsolv testcase file.
        :type id: string
        :param id: The new repo id
        :type path: string
        :param path: The path to the libsolv testcase file
        :rtype: :py:class:`RepoWeakPtr`
        :return: A weak pointer to the new repo
        """
        return _repo.RepoSack_create_repo_from_libsolv_testcase(self, id, path)

    def get_system_repo(self):
        r"""
        If not created yet, creates the system repository and returns it.
        :rtype: :py:class:`RepoWeakPtr`
        :return: The system repository.
        """
        return _repo.RepoSack_get_system_repo(self)

    def add_cmdline_packages(self, paths, calculate_checksum=False):
        r"""
        Add given paths to comdline repository.
        :type paths: std::vector< std::string,std::allocator< std::string > >
        :param paths: Vector of paths to rpm files to be inserted to cmdline repo. Can contain paths to local files or URLs of remote rpm files. Specifications that are neither file paths, nor URLs are ignored.
        :type calculate_checksum: boolean, optional
        :param calculate_checksum: Whether libsolv should calculate and store checksum of added packages. Setting to true significantly reduces performance.
        :rtype: std::map< std::string,libdnf5::rpm::Package,std::less< std::string >,std::allocator< std::pair< std::string const,libdnf5::rpm::Package > > >
        :return: Map path->rpm::Package which maps input path to newly created Package object in cmdline repo
        """
        return _repo.RepoSack_add_cmdline_packages(self, paths, calculate_checksum)

    def has_system_repo(self):
        r"""
        :rtype: boolean
        :return: `true` if the system repository has been initialized (via `get_system_repo()`).
        """
        return _repo.RepoSack_has_system_repo(self)

    def has_cmdline_repo(self):
        r"""
        :rtype: boolean
        :return: `true` if the command line repository has been initialized (via `get_cmdline_repo()`).
        """
        return _repo.RepoSack_has_cmdline_repo(self)

    def dump_debugdata(self, dir):
        r"""
        Dumps libsolv's rpm debugdata of all loaded repositories.
        :type dir: string
        :param dir: The directory into which to dump the debugdata.
        """
        return _repo.RepoSack_dump_debugdata(self, dir)

    def dump_comps_debugdata(self, dir):
        r"""
        Dumps libsolv's comps debugdata of all loaded repositories.
        :type dir: string
        :param dir: The directory into which to dump the debugdata.
        """
        return _repo.RepoSack_dump_comps_debugdata(self, dir)

    def update_and_load_enabled_repos(self, load_system):
        r"""
        Downloads (if necessary) all enabled repository metadata and loads them in parallel.

        This is just a thin wrapper around load_repos.

        :type load_system: boolean
        :param load_system: Whether to load the system repository
        Deprecated: Use load_repos() which allows specifying repo type.
        """
        return _repo.RepoSack_update_and_load_enabled_repos(self, load_system)

    def load_repos(self, *args):
        r"""
        *Overload 1:*
        Downloads (if necessary) repositories of selected type and loads them in parallel.
        load_repos() can be called only once per each RepoSack.
        It also sets up modular filtering.
        :type type: int
        :param type: What repositories to load (libdnf5::Repo::Type::SYSTEM or libdnf5::Repo::Type::AVAILABLE)

        |

        *Overload 2:*
        Downloads (if necessary) both available and system repositories and loads them in parallel.
        load_repos() can be called only once per each RepoSack.
        It also sets up modular filtering.
        """
        return _repo.RepoSack_load_repos(self, *args)

    def get_weak_ptr(self):
        return _repo.RepoSack_get_weak_ptr(self)

    def get_base(self):
        r"""
        :rtype: libdnf5::BaseWeakPtr
        :return: The `Base` object to which this object belongs.
        Since: 5.0
        """
        return _repo.RepoSack_get_base(self)

    def enable_source_repos(self):
        r"""
        For each enabled repository enable corresponding source repository.
        When repo ID has suffix -rpm then it enables <ID>-source-rpms
        otherwise it enables <ID>-source
        Since: 5.0
        """
        return _repo.RepoSack_enable_source_repos(self)

    def enable_debug_repos(self):
        r"""
        For each enabled repository enable corresponding debug repository.
        When repo ID has suffix -rpm then it enables <ID>-debug-rpms
        otherwise it enables <ID>-debuginfo
        Since: 5.2.4
        """
        return _repo.RepoSack_enable_debug_repos(self)
    __swig_destroy__ = _repo.delete_RepoSack

# Register RepoSack in _repo:
_repo.RepoSack_swigregister(RepoSack)
class RepoSackWeakPtr(object):
    r"""
    WeakPtr is a "smart" pointer. It contains a pointer to resource and to guard of resource.
    WeakPtr pointer can be owner of the resource. However, the resource itself may depend on another resource.
    WeakPtr registers/unregisters itself at the guard of resource. And the resource guard invalidates
    the registered WeakPtrs when the resource is unusable (eg. its dependecny was released).
    Note on thread safety:
    It is safe to create, access and destroy WeakPtrs in multiple threads simultaneously.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _repo.RepoSackWeakPtr_swiginit(self, _repo.new_RepoSackWeakPtr(*args))
    __swig_destroy__ = _repo.delete_RepoSackWeakPtr

    def __deref__(self):
        r"""Provides access to the managed object. Generates exception if object is not valid."""
        return _repo.RepoSackWeakPtr___deref__(self)

    def get(self):
        r"""Returns a pointer to the managed object. Generates exception if object is not valid."""
        return _repo.RepoSackWeakPtr_get(self)

    def is_valid(self):
        r"""Checks if managed object is valid."""
        return _repo.RepoSackWeakPtr_is_valid(self)

    def has_same_guard(self, other):
        r"""Checks if the other WeakPtr instance has the same WeakPtrGuard."""
        return _repo.RepoSackWeakPtr_has_same_guard(self, other)

    def __ref__(self):
        return _repo.RepoSackWeakPtr___ref__(self)

    def __eq__(self, other):
        return _repo.RepoSackWeakPtr___eq__(self, other)

    def __ne__(self, other):
        return _repo.RepoSackWeakPtr___ne__(self, other)

    def __lt__(self, other):
        return _repo.RepoSackWeakPtr___lt__(self, other)

    def __gt__(self, other):
        return _repo.RepoSackWeakPtr___gt__(self, other)

    def __le__(self, other):
        return _repo.RepoSackWeakPtr___le__(self, other)

    def __ge__(self, other):
        return _repo.RepoSackWeakPtr___ge__(self, other)

    def __hash__(self):
        return _repo.RepoSackWeakPtr___hash__(self)

    def create_repo(self, id):
        r"""
        Creates a new clear repository with default configuration.
        :type id: string
        :param id: The new repo id
        :rtype: :py:class:`RepoWeakPtr`
        :return: A weak pointer to the new repo
        """
        return _repo.RepoSackWeakPtr_create_repo(self, id)

    def create_repos_from_file(self, path):
        r"""
        Creates new repositories from the configuration file at `path`.
        :type path: string
        :param path: The path to the repository configuration file
        """
        return _repo.RepoSackWeakPtr_create_repos_from_file(self, path)

    def create_repos_from_config_file(self):
        r"""
        Creates new repositories from the Base's configuration file (the
        "config_file_path" configuration option).

        Repositories can be configured in dnf's main configuration file in
        sections other than "[main]".
        """
        return _repo.RepoSackWeakPtr_create_repos_from_config_file(self)

    def create_repos_from_dir(self, dir_path):
        r"""
        Creates new repositories from all configuration files with the ".repo"
        extension in the `dir_path` directory.

        The files in the directory are read in alphabetical order.
        :type dir_path: string
        :param dir_path: The path to the directory with configuration files
        """
        return _repo.RepoSackWeakPtr_create_repos_from_dir(self, dir_path)

    def create_repos_from_reposdir(self):
        r"""
        Creates new repositories from all configuration files with ".repo" extension in the directories
        defined by the "reposdir" configuration option.

        The files in the directories are read in alphabetical order.
        """
        return _repo.RepoSackWeakPtr_create_repos_from_reposdir(self)

    def create_repos_from_paths(self, repos_paths, priority):
        r"""
        Create new repositories from ids and paths.
        :type repos_paths: std::vector< std::pair< std::string,std::string >,std::allocator< std::pair< std::string,std::string > > >
        :param repos_paths: Vector of <ID,PATH> pairs. The "baseurl" parameter of the new repo is set to the PATH, "name" and "id" to the ID. Both values can be enriched by the repository variables which are substituted before creating the repo.
        :type priority: int
        :param priority: Priority with which the name and baseurl attributes of the new repo are set.
        """
        return _repo.RepoSackWeakPtr_create_repos_from_paths(self, repos_paths, priority)

    def create_repos_from_system_configuration(self):
        r"""
        Creates new repositories from the Base's configuration file (the /
        "config_file_path" configuration option) and from directories defined by
        the "reposdir" configuration option. Repository overrides are then applied.

        Calls `create_repos_from_config_file()`, `create_repos_from_reposdir()`,
        and loads repository configuration overrides.
        """
        return _repo.RepoSackWeakPtr_create_repos_from_system_configuration(self)

    def create_repo_from_libsolv_testcase(self, id, path):
        r"""
        Creates a new repository from a libsolv testcase file.
        :type id: string
        :param id: The new repo id
        :type path: string
        :param path: The path to the libsolv testcase file
        :rtype: :py:class:`RepoWeakPtr`
        :return: A weak pointer to the new repo
        """
        return _repo.RepoSackWeakPtr_create_repo_from_libsolv_testcase(self, id, path)

    def get_system_repo(self):
        r"""
        If not created yet, creates the system repository and returns it.
        :rtype: :py:class:`RepoWeakPtr`
        :return: The system repository.
        """
        return _repo.RepoSackWeakPtr_get_system_repo(self)

    def add_cmdline_packages(self, paths, calculate_checksum=False):
        r"""
        Add given paths to comdline repository.
        :type paths: std::vector< std::string,std::allocator< std::string > >
        :param paths: Vector of paths to rpm files to be inserted to cmdline repo. Can contain paths to local files or URLs of remote rpm files. Specifications that are neither file paths, nor URLs are ignored.
        :type calculate_checksum: boolean, optional
        :param calculate_checksum: Whether libsolv should calculate and store checksum of added packages. Setting to true significantly reduces performance.
        :rtype: std::map< std::string,libdnf5::rpm::Package,std::less< std::string >,std::allocator< std::pair< std::string const,libdnf5::rpm::Package > > >
        :return: Map path->rpm::Package which maps input path to newly created Package object in cmdline repo
        """
        return _repo.RepoSackWeakPtr_add_cmdline_packages(self, paths, calculate_checksum)

    def has_system_repo(self):
        r"""
        :rtype: boolean
        :return: `true` if the system repository has been initialized (via `get_system_repo()`).
        """
        return _repo.RepoSackWeakPtr_has_system_repo(self)

    def has_cmdline_repo(self):
        r"""
        :rtype: boolean
        :return: `true` if the command line repository has been initialized (via `get_cmdline_repo()`).
        """
        return _repo.RepoSackWeakPtr_has_cmdline_repo(self)

    def dump_debugdata(self, dir):
        r"""
        Dumps libsolv's rpm debugdata of all loaded repositories.
        :type dir: string
        :param dir: The directory into which to dump the debugdata.
        """
        return _repo.RepoSackWeakPtr_dump_debugdata(self, dir)

    def dump_comps_debugdata(self, dir):
        r"""
        Dumps libsolv's comps debugdata of all loaded repositories.
        :type dir: string
        :param dir: The directory into which to dump the debugdata.
        """
        return _repo.RepoSackWeakPtr_dump_comps_debugdata(self, dir)

    def update_and_load_enabled_repos(self, load_system):
        r"""
        Downloads (if necessary) all enabled repository metadata and loads them in parallel.

        This is just a thin wrapper around load_repos.

        :type load_system: boolean
        :param load_system: Whether to load the system repository
        Deprecated: Use load_repos() which allows specifying repo type.
        """
        return _repo.RepoSackWeakPtr_update_and_load_enabled_repos(self, load_system)

    def load_repos(self, *args):
        r"""
        *Overload 1:*
        Downloads (if necessary) repositories of selected type and loads them in parallel.
        load_repos() can be called only once per each RepoSack.
        It also sets up modular filtering.
        :type type: int
        :param type: What repositories to load (libdnf5::Repo::Type::SYSTEM or libdnf5::Repo::Type::AVAILABLE)

        |

        *Overload 2:*
        Downloads (if necessary) both available and system repositories and loads them in parallel.
        load_repos() can be called only once per each RepoSack.
        It also sets up modular filtering.
        """
        return _repo.RepoSackWeakPtr_load_repos(self, *args)

    def get_weak_ptr(self):
        return _repo.RepoSackWeakPtr_get_weak_ptr(self)

    def get_base(self):
        r"""
        :rtype: libdnf5::BaseWeakPtr
        :return: The `Base` object to which this object belongs.
        Since: 5.0
        """
        return _repo.RepoSackWeakPtr_get_base(self)

    def enable_source_repos(self):
        r"""
        For each enabled repository enable corresponding source repository.
        When repo ID has suffix -rpm then it enables <ID>-source-rpms
        otherwise it enables <ID>-source
        Since: 5.0
        """
        return _repo.RepoSackWeakPtr_enable_source_repos(self)

    def enable_debug_repos(self):
        r"""
        For each enabled repository enable corresponding debug repository.
        When repo ID has suffix -rpm then it enables <ID>-debug-rpms
        otherwise it enables <ID>-debuginfo
        Since: 5.2.4
        """
        return _repo.RepoSackWeakPtr_enable_debug_repos(self)

    def size(self):
        return _repo.RepoSackWeakPtr_size(self)

    def get_excludes(self):
        return _repo.RepoSackWeakPtr_get_excludes(self)

    def add_excludes(self, value):
        return _repo.RepoSackWeakPtr_add_excludes(self, value)

    def remove_excludes(self, value):
        return _repo.RepoSackWeakPtr_remove_excludes(self, value)

    def set_excludes(self, value):
        return _repo.RepoSackWeakPtr_set_excludes(self, value)

    def get_includes(self):
        return _repo.RepoSackWeakPtr_get_includes(self)

    def add_includes(self, value):
        return _repo.RepoSackWeakPtr_add_includes(self, value)

    def remove_includes(self, value):
        return _repo.RepoSackWeakPtr_remove_includes(self, value)

    def set_includes(self, value):
        return _repo.RepoSackWeakPtr_set_includes(self, value)

    def get_use_includes(self):
        return _repo.RepoSackWeakPtr_get_use_includes(self)

    def set_use_includes(self, value):
        return _repo.RepoSackWeakPtr_set_use_includes(self, value)

# Register RepoSackWeakPtr in _repo:
_repo.RepoSackWeakPtr_swigregister(RepoSackWeakPtr)

def SetRepoWeakPtr__iter__(self):
    return common.Iterator(self, self.begin(), self.end())
SetRepoWeakPtr.__iter__ = SetRepoWeakPtr__iter__
del SetRepoWeakPtr__iter__


conf.create_config_option_attributes(ConfigRepo)


common.create_attributes_from_getters_and_setters(RepoCacheRemoveStatistics)


