%% Generated by the Erlang ASN.1 BER compiler. Version: 5.4
%% Purpose: Encoding and decoding of the types in OCSP-2024-08.

-module('OCSP-2024-08').
-moduledoc false.
-compile(nowarn_unused_vars).
-dialyzer(no_improper_lists).
-dialyzer(no_match).
-include("OCSP-2024-08.hrl").
-asn1_info([{vsn,'5.4'},
            {module,'OCSP-2024-08'},
            {options,[{i,"/build/erlang/src/otp/lib/public_key/asn1/../src"},
 warnings,ber,errors,
 {cwd,"/build/erlang/src/otp/lib/public_key/asn1"},
 {outdir,"/build/erlang/src/otp/lib/public_key/asn1/../src"},
 der,noobj,asn1config,
 {i,"."},
 {i,"/build/erlang/src/otp/lib/public_key/asn1"}]}]).

-export([encoding_rule/0,maps/0,bit_string_format/0,
         legacy_erlang_types/0]).
-export(['dialyzer-suppressions'/1]).
-export([
enc_OCSPRequest/2,
enc_TBSRequest/2,
enc_Signature/2,
enc_Version/2,
enc_Nonce/2,
enc_Request/2,
enc_CertID/2,
enc_OCSPResponse/2,
enc_OCSPResponseStatus/2,
enc_ResponseBytes/2,
enc_BasicOCSPResponse/2,
enc_ResponseData/2,
enc_ResponderID/2,
enc_KeyHash/2,
enc_SingleResponse/2,
enc_CertStatus/2,
enc_RevokedInfo/2,
enc_UnknownInfo/2,
enc_ArchiveCutoff/2,
enc_AcceptableResponses/2,
enc_ServiceLocator/2,
enc_CrlID/2,
enc_PreferredSignatureAlgorithms/2,
enc_PreferredSignatureAlgorithm/2
]).

-export([
dec_OCSPRequest/2,
dec_TBSRequest/2,
dec_Signature/2,
dec_Version/2,
dec_Nonce/2,
dec_Request/2,
dec_CertID/2,
dec_OCSPResponse/2,
dec_OCSPResponseStatus/2,
dec_ResponseBytes/2,
dec_BasicOCSPResponse/2,
dec_ResponseData/2,
dec_ResponderID/2,
dec_KeyHash/2,
dec_SingleResponse/2,
dec_CertStatus/2,
dec_RevokedInfo/2,
dec_UnknownInfo/2,
dec_ArchiveCutoff/2,
dec_AcceptableResponses/2,
dec_ServiceLocator/2,
dec_CrlID/2,
dec_PreferredSignatureAlgorithms/2,
dec_PreferredSignatureAlgorithm/2
]).

-export([
enc_basicResponse/3,
'enc_ext-ocsp-nocheck'/3,
'enc_re-ocsp-nonce'/3,
'enc_re-ocsp-response'/3,
'enc_re-ocsp-service-locator'/3,
'enc_re-ocsp-preferred-signature-algorithms'/3,
'enc_re-ocsp-crl'/3,
'enc_re-ocsp-archive-cutoff'/3,
'enc_re-ocsp-extended-revoke'/3
]).

-export([
dec_basicResponse/3,
'dec_ext-ocsp-nocheck'/3,
'dec_re-ocsp-nonce'/3,
'dec_re-ocsp-response'/3,
'dec_re-ocsp-service-locator'/3,
'dec_re-ocsp-preferred-signature-algorithms'/3,
'dec_re-ocsp-crl'/3,
'dec_re-ocsp-archive-cutoff'/3,
'dec_re-ocsp-extended-revoke'/3
]).

-export([
getenc_ResponseSet/1,
getenc_internal_object_set_argument_8/1,
getenc_internal_object_set_argument_6/1,
getenc_internal_object_set_argument_5/1,
getenc_internal_object_set_argument_4/1,
getenc_internal_object_set_argument_3/1,
getenc_internal_object_set_argument_2/1,
getenc_internal_object_set_argument_19/1,
getenc_internal_object_set_argument_18/1,
getenc_internal_object_set_argument_17/1,
getenc_internal_object_set_argument_26/1,
getenc_internal_object_set_argument_24/1,
getenc_internal_object_set_argument_22/1,
getenc_internal_object_set_argument_20/1
]).

-export([
getdec_ResponseSet/1,
getdec_internal_object_set_argument_8/1,
getdec_internal_object_set_argument_6/1,
getdec_internal_object_set_argument_5/1,
getdec_internal_object_set_argument_4/1,
getdec_internal_object_set_argument_3/1,
getdec_internal_object_set_argument_2/1,
getdec_internal_object_set_argument_19/1,
getdec_internal_object_set_argument_18/1,
getdec_internal_object_set_argument_17/1,
getdec_internal_object_set_argument_26/1,
getdec_internal_object_set_argument_24/1,
getdec_internal_object_set_argument_22/1,
getdec_internal_object_set_argument_20/1
]).

-export([
'id-kp-OCSPSigning'/0,
'id-pkix-ocsp'/0,
'id-pkix-ocsp-basic'/0,
'id-pkix-ocsp-nonce'/0,
'id-pkix-ocsp-crl'/0,
'id-pkix-ocsp-response'/0,
'id-pkix-ocsp-nocheck'/0,
'id-pkix-ocsp-archive-cutoff'/0,
'id-pkix-ocsp-service-locator'/0,
'id-pkix-ocsp-pref-sig-algs'/0,
'id-pkix-ocsp-extended-revoke'/0
]).

-export([info/0]).

-export([encode/2,decode/2]).

encoding_rule() -> ber.

maps() -> false.

bit_string_format() -> bitstring.

legacy_erlang_types() -> false.

encode(Type, Data) ->
try iolist_to_binary(element(1, encode_disp(Type, Data))) of
  Bytes ->
    {ok,Bytes}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end.


decode(Type, Data) ->
try
   Result = decode_disp(Type, element(1, ber_decode_nif(Data))),
   {ok,Result}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end.

encode_disp('OCSPRequest', Data) -> enc_OCSPRequest(Data);
encode_disp('TBSRequest', Data) -> enc_TBSRequest(Data);
encode_disp('Signature', Data) -> enc_Signature(Data);
encode_disp('Version', Data) -> enc_Version(Data);
encode_disp('Nonce', Data) -> enc_Nonce(Data);
encode_disp('Request', Data) -> enc_Request(Data);
encode_disp('CertID', Data) -> enc_CertID(Data);
encode_disp('OCSPResponse', Data) -> enc_OCSPResponse(Data);
encode_disp('OCSPResponseStatus', Data) -> enc_OCSPResponseStatus(Data);
encode_disp('ResponseBytes', Data) -> enc_ResponseBytes(Data);
encode_disp('BasicOCSPResponse', Data) -> enc_BasicOCSPResponse(Data);
encode_disp('ResponseData', Data) -> enc_ResponseData(Data);
encode_disp('ResponderID', Data) -> enc_ResponderID(Data);
encode_disp('KeyHash', Data) -> enc_KeyHash(Data);
encode_disp('SingleResponse', Data) -> enc_SingleResponse(Data);
encode_disp('CertStatus', Data) -> enc_CertStatus(Data);
encode_disp('RevokedInfo', Data) -> enc_RevokedInfo(Data);
encode_disp('UnknownInfo', Data) -> enc_UnknownInfo(Data);
encode_disp('ArchiveCutoff', Data) -> enc_ArchiveCutoff(Data);
encode_disp('AcceptableResponses', Data) -> enc_AcceptableResponses(Data);
encode_disp('ServiceLocator', Data) -> enc_ServiceLocator(Data);
encode_disp('CrlID', Data) -> enc_CrlID(Data);
encode_disp('PreferredSignatureAlgorithms', Data) -> enc_PreferredSignatureAlgorithms(Data);
encode_disp('PreferredSignatureAlgorithm', Data) -> enc_PreferredSignatureAlgorithm(Data);
encode_disp(Type, _Data) -> exit({error,{asn1,{undefined_type,Type}}}).

decode_disp('OCSPRequest', Data) -> dec_OCSPRequest(Data);
decode_disp('TBSRequest', Data) -> dec_TBSRequest(Data);
decode_disp('Signature', Data) -> dec_Signature(Data);
decode_disp('Version', Data) -> dec_Version(Data);
decode_disp('Nonce', Data) -> dec_Nonce(Data);
decode_disp('Request', Data) -> dec_Request(Data);
decode_disp('CertID', Data) -> dec_CertID(Data);
decode_disp('OCSPResponse', Data) -> dec_OCSPResponse(Data);
decode_disp('OCSPResponseStatus', Data) -> dec_OCSPResponseStatus(Data);
decode_disp('ResponseBytes', Data) -> dec_ResponseBytes(Data);
decode_disp('BasicOCSPResponse', Data) -> dec_BasicOCSPResponse(Data);
decode_disp('ResponseData', Data) -> dec_ResponseData(Data);
decode_disp('ResponderID', Data) -> dec_ResponderID(Data);
decode_disp('KeyHash', Data) -> dec_KeyHash(Data);
decode_disp('SingleResponse', Data) -> dec_SingleResponse(Data);
decode_disp('CertStatus', Data) -> dec_CertStatus(Data);
decode_disp('RevokedInfo', Data) -> dec_RevokedInfo(Data);
decode_disp('UnknownInfo', Data) -> dec_UnknownInfo(Data);
decode_disp('ArchiveCutoff', Data) -> dec_ArchiveCutoff(Data);
decode_disp('AcceptableResponses', Data) -> dec_AcceptableResponses(Data);
decode_disp('ServiceLocator', Data) -> dec_ServiceLocator(Data);
decode_disp('CrlID', Data) -> dec_CrlID(Data);
decode_disp('PreferredSignatureAlgorithms', Data) -> dec_PreferredSignatureAlgorithms(Data);
decode_disp('PreferredSignatureAlgorithm', Data) -> dec_PreferredSignatureAlgorithm(Data);
decode_disp(Type, _Data) -> exit({error,{asn1,{undefined_type,Type}}}).

info() ->
   case ?MODULE:module_info(attributes) of
     Attributes when is_list(Attributes) ->
       case lists:keyfind(asn1_info, 1, Attributes) of
         {_,Info} when is_list(Info) ->
           Info;
         _ ->
           []
       end;
     _ ->
       []
   end.


%%================================
%%  OCSPRequest
%%================================
enc_OCSPRequest(Val) ->
    enc_OCSPRequest(Val, [<<48>>]).

enc_OCSPRequest(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute tbsRequest(1)   External OCSP-2024-08:TBSRequest
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_TBSRequest'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute optionalSignature(2)   External OCSP-2024-08:Signature OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_Signature'(Cindex2, [<<48>>,<<160>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_OCSPRequest(Tlv) ->
   dec_OCSPRequest(Tlv, [16]).

dec_OCSPRequest(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute tbsRequest(1)   External OCSP-2024-08:TBSRequest
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_TBSRequest'(V1, [16]),

%%-------------------------------------------------
%% attribute optionalSignature(2)   External OCSP-2024-08:Signature OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131072,V2}|TempTlv3] ->
    {'dec_Signature'(V2, [16]), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'OCSPRequest',Term1,Term2},
Res1.


%%================================
%%  TBSRequest
%%================================
enc_TBSRequest(Val) ->
    enc_TBSRequest(Val, [<<48>>]).

enc_TBSRequest(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4} = Val,

%%-------------------------------------------------
%% attribute version(1) with type INTEGER DEFAULT = 0
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case is_default_1(Cindex1) of
true -> {[],0};
false ->
encode_integer(Cindex1, [{v1,0}], [<<2>>,<<160>>])
       end,

%%-------------------------------------------------
%% attribute requestorName(2)   External PKIX1Implicit-2009:GeneralName OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'PKIX1Implicit-2009':'enc_GeneralName'(Cindex2, [<<161>>])
       end,

%%-------------------------------------------------
%% attribute requestList(3) with type SEQUENCE OF
%%-------------------------------------------------
   {EncBytes3,EncLen3} = 'enc_TBSRequest_requestList'(Cindex3, [<<48>>]),

%%-------------------------------------------------
%% attribute requestExtensions(4) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case Cindex4 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_TBSRequest_requestExtensions'(Cindex4, [<<48>>,<<162>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  TBSRequest_requestList
%%================================
enc_TBSRequest_requestList(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_TBSRequest_requestList_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_TBSRequest_requestList_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_TBSRequest_requestList_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_Request'(H, [<<48>>]),
   'enc_TBSRequest_requestList_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  TBSRequest_requestExtensions
%%================================
enc_TBSRequest_requestExtensions(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_TBSRequest_requestExtensions_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_TBSRequest_requestExtensions_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_TBSRequest_requestExtensions_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_TBSRequest_requestExtensions_Extension'(H, [<<48>>]),
   'enc_TBSRequest_requestExtensions_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  TBSRequest_requestExtensions_Extension
%%================================
enc_TBSRequest_requestExtensions_Extension(Val, TagIn) ->
   {_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute extnID(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute critical(2) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case is_default_2(Cindex2) of
true -> {[],0};
false ->
encode_boolean(Cindex2, [<<1>>])
       end,

%%-------------------------------------------------
%% attribute extnValue(3) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_restricted_string(Cindex3, [<<4>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_TBSRequest(Tlv) ->
   dec_TBSRequest(Tlv, [16]).

dec_TBSRequest(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute version(1) with type INTEGER DEFAULT = 0
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {begin
Val1 = decode_integer(V1, [2]),
number2name(Val1, [{v1,0}])
end
, TempTlv2};
    _ ->
        {0,Tlv1}
end,

%%-------------------------------------------------
%% attribute requestorName(2)   External PKIX1Implicit-2009:GeneralName OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {'PKIX1Implicit-2009':'dec_GeneralName'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute requestList(3) with type SEQUENCE OF
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = 'dec_TBSRequest_requestList'(V3, [16]),

%%-------------------------------------------------
%% attribute requestExtensions(4) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
{Term4,Tlv5} = case Tlv4 of
[{131074,V4}|TempTlv5] ->
    {'dec_TBSRequest_requestExtensions'(V4, [16]), TempTlv5};
    _ ->
        { asn1_NOVALUE, Tlv4}
end,

case Tlv5 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv5}}}) % extra fields not allowed
end,
Res1 = {'TBSRequest',Term1,Term2,Term3,Term4},
Res1.
'dec_TBSRequest_requestList'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_Request'(V1, [16]) || V1 <- Tlv1].


'dec_TBSRequest_requestExtensions'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_TBSRequest_requestExtensions_Extension'(V1, [16]) || V1 <- Tlv1].


'dec_TBSRequest_requestExtensions_Extension'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute extnID(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute critical(2) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{1,V2}|TempTlv3] ->
    {decode_boolean(V2, []), TempTlv3};
    _ ->
        {false,Tlv2}
end,

%%-------------------------------------------------
%% attribute extnValue(3) with type OCTET STRING
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = decode_octet_string(V3, [4]),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'Extension',Term1,Term2,Term3},
Res1.


%%================================
%%  Signature
%%================================
enc_Signature(Val) ->
    enc_Signature(Val, [<<48>>]).

enc_Signature(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute signatureAlgorithm(1) with type SEQUENCE
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_Signature_signatureAlgorithm'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute signature(2) with type BIT STRING
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_unnamed_bit_string(Cindex2, [<<3>>]),

%%-------------------------------------------------
%% attribute certs(3) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_Signature_certs'(Cindex3, [<<48>>,<<160>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  Signature_signatureAlgorithm
%%================================
enc_Signature_signatureAlgorithm(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'OCSP-2024-08':'getenc_internal_object_set_argument_8'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  Signature_certs
%%================================
enc_Signature_certs(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_Signature_certs_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_Signature_certs_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_Signature_certs_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'PKIX1Explicit-2009':'enc_Certificate'(H, [<<48>>]),
   'enc_Signature_certs_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_Signature(Tlv) ->
   dec_Signature(Tlv, [16]).

dec_Signature(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute signatureAlgorithm(1) with type SEQUENCE
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_Signature_signatureAlgorithm'(V1, [16]),

%%-------------------------------------------------
%% attribute signature(2) with type BIT STRING
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_native_bit_string(V2, [3]),

%%-------------------------------------------------
%% attribute certs(3) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131072,V3}|TempTlv4] ->
    {'dec_Signature_certs'(V3, [16]), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'Signature',Term1,Term2,Term3},
Res1.
'dec_Signature_signatureAlgorithm'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'OCSP-2024-08':'getdec_internal_object_set_argument_8'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'Signature_signatureAlgorithm',Term1,Term2},
Res1.
'dec_Signature_certs'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['PKIX1Explicit-2009':'dec_Certificate'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  Version
%%================================
enc_Version(Val) ->
    enc_Version(Val, [<<2>>]).

enc_Version(Val, TagIn) ->
encode_integer(Val, [{v1,0}], TagIn).


dec_Version(Tlv) ->
   dec_Version(Tlv, [2]).

dec_Version(Tlv, TagIn) ->
begin
Val1 = decode_integer(Tlv, TagIn),
number2name(Val1, [{v1,0}])
end
.



%%================================
%%  Nonce
%%================================
enc_Nonce(Val) ->
    enc_Nonce(Val, [<<4>>]).

enc_Nonce(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_Nonce(Tlv) ->
   dec_Nonce(Tlv, [4]).

dec_Nonce(Tlv, TagIn) ->
begin
Val1 = decode_octet_string(Tlv, TagIn),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 128 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end.



%%================================
%%  Request
%%================================
enc_Request(Val) ->
    enc_Request(Val, [<<48>>]).

enc_Request(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute reqCert(1)   External OCSP-2024-08:CertID
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_CertID'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute singleRequestExtensions(2) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_Request_singleRequestExtensions'(Cindex2, [<<48>>,<<160>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  Request_singleRequestExtensions
%%================================
enc_Request_singleRequestExtensions(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_Request_singleRequestExtensions_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_Request_singleRequestExtensions_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_Request_singleRequestExtensions_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_Request_singleRequestExtensions_Extension'(H, [<<48>>]),
   'enc_Request_singleRequestExtensions_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  Request_singleRequestExtensions_Extension
%%================================
enc_Request_singleRequestExtensions_Extension(Val, TagIn) ->
   {_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute extnID(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute critical(2) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case is_default_2(Cindex2) of
true -> {[],0};
false ->
encode_boolean(Cindex2, [<<1>>])
       end,

%%-------------------------------------------------
%% attribute extnValue(3) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_restricted_string(Cindex3, [<<4>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_Request(Tlv) ->
   dec_Request(Tlv, [16]).

dec_Request(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute reqCert(1)   External OCSP-2024-08:CertID
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_CertID'(V1, [16]),

%%-------------------------------------------------
%% attribute singleRequestExtensions(2) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131072,V2}|TempTlv3] ->
    {'dec_Request_singleRequestExtensions'(V2, [16]), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'Request',Term1,Term2},
Res1.
'dec_Request_singleRequestExtensions'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_Request_singleRequestExtensions_Extension'(V1, [16]) || V1 <- Tlv1].


'dec_Request_singleRequestExtensions_Extension'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute extnID(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute critical(2) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{1,V2}|TempTlv3] ->
    {decode_boolean(V2, []), TempTlv3};
    _ ->
        {false,Tlv2}
end,

%%-------------------------------------------------
%% attribute extnValue(3) with type OCTET STRING
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = decode_octet_string(V3, [4]),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'Extension',Term1,Term2,Term3},
Res1.


%%================================
%%  CertID
%%================================
enc_CertID(Val) ->
    enc_CertID(Val, [<<48>>]).

enc_CertID(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4} = Val,

%%-------------------------------------------------
%% attribute hashAlgorithm(1) with type SEQUENCE
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_CertID_hashAlgorithm'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute issuerNameHash(2) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_restricted_string(Cindex2, [<<4>>]),

%%-------------------------------------------------
%% attribute issuerKeyHash(3) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_restricted_string(Cindex3, [<<4>>]),

%%-------------------------------------------------
%% attribute serialNumber(4) with type INTEGER
%%-------------------------------------------------
   {EncBytes4,EncLen4} = encode_integer(Cindex4, [<<2>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  CertID_hashAlgorithm
%%================================
enc_CertID_hashAlgorithm(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'OCSP-2024-08':'getenc_internal_object_set_argument_2'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_CertID(Tlv) ->
   dec_CertID(Tlv, [16]).

dec_CertID(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute hashAlgorithm(1) with type SEQUENCE
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_CertID_hashAlgorithm'(V1, [16]),

%%-------------------------------------------------
%% attribute issuerNameHash(2) with type OCTET STRING
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_octet_string(V2, [4]),

%%-------------------------------------------------
%% attribute issuerKeyHash(3) with type OCTET STRING
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = decode_octet_string(V3, [4]),

%%-------------------------------------------------
%% attribute serialNumber(4) with type INTEGER
%%-------------------------------------------------
[V4|Tlv5] = Tlv4, 
Term4 = decode_integer(V4, [2]),

case Tlv5 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv5}}}) % extra fields not allowed
end,
Res1 = {'CertID',Term1,Term2,Term3,Term4},
Res1.
'dec_CertID_hashAlgorithm'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'OCSP-2024-08':'getdec_internal_object_set_argument_2'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'CertID_hashAlgorithm',Term1,Term2},
Res1.


%%================================
%%  OCSPResponse
%%================================
enc_OCSPResponse(Val) ->
    enc_OCSPResponse(Val, [<<48>>]).

enc_OCSPResponse(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute responseStatus(1) with type ENUMERATED
%%-------------------------------------------------
   {EncBytes1,EncLen1} = case Cindex1 of
successful -> encode_tags([<<10>>], [0], 1);
malformedRequest -> encode_tags([<<10>>], [1], 1);
internalError -> encode_tags([<<10>>], [2], 1);
tryLater -> encode_tags([<<10>>], [3], 1);
sigRequired -> encode_tags([<<10>>], [5], 1);
unauthorized -> encode_tags([<<10>>], [6], 1);
Enumval1 -> exit({error,{asn1, {enumerated_not_in_range,Enumval1}}})
end,

%%-------------------------------------------------
%% attribute responseBytes(2)   External OCSP-2024-08:ResponseBytes OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_ResponseBytes'(Cindex2, [<<48>>,<<160>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_OCSPResponse(Tlv) ->
   dec_OCSPResponse(Tlv, [16]).

dec_OCSPResponse(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute responseStatus(1) with type ENUMERATED
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = case decode_integer(V1, [10]) of
0 -> successful;
1 -> malformedRequest;
2 -> internalError;
3 -> tryLater;
5 -> sigRequired;
6 -> unauthorized;
Default1 -> exit({error,{asn1,{illegal_enumerated,Default1}}})
end,

%%-------------------------------------------------
%% attribute responseBytes(2)   External OCSP-2024-08:ResponseBytes OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131072,V2}|TempTlv3] ->
    {'dec_ResponseBytes'(V2, [16]), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'OCSPResponse',Term1,Term2},
Res1.


%%================================
%%  OCSPResponseStatus
%%================================
enc_OCSPResponseStatus(Val) ->
    enc_OCSPResponseStatus(Val, [<<10>>]).

enc_OCSPResponseStatus(Val, TagIn) ->
case Val of
successful -> encode_tags(TagIn, [0], 1);
malformedRequest -> encode_tags(TagIn, [1], 1);
internalError -> encode_tags(TagIn, [2], 1);
tryLater -> encode_tags(TagIn, [3], 1);
sigRequired -> encode_tags(TagIn, [5], 1);
unauthorized -> encode_tags(TagIn, [6], 1);
Enumval1 -> exit({error,{asn1, {enumerated_not_in_range,Enumval1}}})
end.


dec_OCSPResponseStatus(Tlv) ->
   dec_OCSPResponseStatus(Tlv, [10]).

dec_OCSPResponseStatus(Tlv, TagIn) ->
case decode_integer(Tlv, TagIn) of
0 -> successful;
1 -> malformedRequest;
2 -> internalError;
3 -> tryLater;
5 -> sigRequired;
6 -> unauthorized;
Default1 -> exit({error,{asn1,{illegal_enumerated,Default1}}})
end.



%%================================
%%  ResponseBytes
%%================================
enc_ResponseBytes(Val) ->
    enc_ResponseBytes(Val, [<<48>>]).

enc_ResponseBytes(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute responseType(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute response(2) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_restricted_string(Cindex2, [<<4>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_ResponseBytes(Tlv) ->
   dec_ResponseBytes(Tlv, [16]).

dec_ResponseBytes(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute responseType(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute response(2) with type OCTET STRING
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_octet_string(V2, [4]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'ResponseBytes',Term1,Term2},
Res1.


%%================================
%%  BasicOCSPResponse
%%================================
enc_BasicOCSPResponse(Val) ->
    enc_BasicOCSPResponse(Val, [<<48>>]).

enc_BasicOCSPResponse(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4} = Val,

%%-------------------------------------------------
%% attribute tbsResponseData(1)   External OCSP-2024-08:ResponseData
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_ResponseData'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute signatureAlgorithm(2) with type SEQUENCE
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_BasicOCSPResponse_signatureAlgorithm'(Cindex2, [<<48>>]),

%%-------------------------------------------------
%% attribute signature(3) with type BIT STRING
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_unnamed_bit_string(Cindex3, [<<3>>]),

%%-------------------------------------------------
%% attribute certs(4) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case Cindex4 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_BasicOCSPResponse_certs'(Cindex4, [<<48>>,<<160>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  BasicOCSPResponse_signatureAlgorithm
%%================================
enc_BasicOCSPResponse_signatureAlgorithm(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'OCSP-2024-08':'getenc_internal_object_set_argument_22'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  BasicOCSPResponse_certs
%%================================
enc_BasicOCSPResponse_certs(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_BasicOCSPResponse_certs_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_BasicOCSPResponse_certs_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_BasicOCSPResponse_certs_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'PKIX1Explicit-2009':'enc_Certificate'(H, [<<48>>]),
   'enc_BasicOCSPResponse_certs_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_BasicOCSPResponse(Tlv) ->
   dec_BasicOCSPResponse(Tlv, [16]).

dec_BasicOCSPResponse(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute tbsResponseData(1)   External OCSP-2024-08:ResponseData
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_ResponseData'(V1, [16]),

%%-------------------------------------------------
%% attribute signatureAlgorithm(2) with type SEQUENCE
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_BasicOCSPResponse_signatureAlgorithm'(V2, [16]),

%%-------------------------------------------------
%% attribute signature(3) with type BIT STRING
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = decode_native_bit_string(V3, [3]),

%%-------------------------------------------------
%% attribute certs(4) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
{Term4,Tlv5} = case Tlv4 of
[{131072,V4}|TempTlv5] ->
    {'dec_BasicOCSPResponse_certs'(V4, [16]), TempTlv5};
    _ ->
        { asn1_NOVALUE, Tlv4}
end,

case Tlv5 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv5}}}) % extra fields not allowed
end,
Res1 = {'BasicOCSPResponse',Term1,Term2,Term3,Term4},
Res1.
'dec_BasicOCSPResponse_signatureAlgorithm'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'OCSP-2024-08':'getdec_internal_object_set_argument_22'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'BasicOCSPResponse_signatureAlgorithm',Term1,Term2},
Res1.
'dec_BasicOCSPResponse_certs'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['PKIX1Explicit-2009':'dec_Certificate'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  ResponseData
%%================================
enc_ResponseData(Val) ->
    enc_ResponseData(Val, [<<48>>]).

enc_ResponseData(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4,Cindex5} = Val,

%%-------------------------------------------------
%% attribute version(1) with type INTEGER DEFAULT = 0
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case is_default_1(Cindex1) of
true -> {[],0};
false ->
encode_integer(Cindex1, [{v1,0}], [<<2>>,<<160>>])
       end,

%%-------------------------------------------------
%% attribute responderID(2)   External OCSP-2024-08:ResponderID
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_ResponderID'(Cindex2, []),

%%-------------------------------------------------
%% attribute producedAt(3) with type GeneralizedTime
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_restricted_string(Cindex3, [<<24>>]),

%%-------------------------------------------------
%% attribute responses(4) with type SEQUENCE OF
%%-------------------------------------------------
   {EncBytes4,EncLen4} = 'enc_ResponseData_responses'(Cindex4, [<<48>>]),

%%-------------------------------------------------
%% attribute responseExtensions(5) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
   {EncBytes5,EncLen5} =  case Cindex5 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_ResponseData_responseExtensions'(Cindex5, [<<48>>,<<161>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4, EncBytes5],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4 + EncLen5,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  ResponseData_responses
%%================================
enc_ResponseData_responses(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_ResponseData_responses_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_ResponseData_responses_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_ResponseData_responses_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_SingleResponse'(H, [<<48>>]),
   'enc_ResponseData_responses_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  ResponseData_responseExtensions
%%================================
enc_ResponseData_responseExtensions(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_ResponseData_responseExtensions_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_ResponseData_responseExtensions_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_ResponseData_responseExtensions_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_ResponseData_responseExtensions_Extension'(H, [<<48>>]),
   'enc_ResponseData_responseExtensions_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  ResponseData_responseExtensions_Extension
%%================================
enc_ResponseData_responseExtensions_Extension(Val, TagIn) ->
   {_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute extnID(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute critical(2) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case is_default_2(Cindex2) of
true -> {[],0};
false ->
encode_boolean(Cindex2, [<<1>>])
       end,

%%-------------------------------------------------
%% attribute extnValue(3) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_restricted_string(Cindex3, [<<4>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_ResponseData(Tlv) ->
   dec_ResponseData(Tlv, [16]).

dec_ResponseData(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute version(1) with type INTEGER DEFAULT = 0
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {begin
Val1 = decode_integer(V1, [2]),
number2name(Val1, [{v1,0}])
end
, TempTlv2};
    _ ->
        {0,Tlv1}
end,

%%-------------------------------------------------
%% attribute responderID(2)   External OCSP-2024-08:ResponderID
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_ResponderID'(V2, []),

%%-------------------------------------------------
%% attribute producedAt(3) with type GeneralizedTime
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = begin
binary_to_list(decode_restricted_string(V3, [24]))
end
,

%%-------------------------------------------------
%% attribute responses(4) with type SEQUENCE OF
%%-------------------------------------------------
[V4|Tlv5] = Tlv4, 
Term4 = 'dec_ResponseData_responses'(V4, [16]),

%%-------------------------------------------------
%% attribute responseExtensions(5) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
{Term5,Tlv6} = case Tlv5 of
[{131073,V5}|TempTlv6] ->
    {'dec_ResponseData_responseExtensions'(V5, [16]), TempTlv6};
    _ ->
        { asn1_NOVALUE, Tlv5}
end,

case Tlv6 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv6}}}) % extra fields not allowed
end,
Res1 = {'ResponseData',Term1,Term2,Term3,Term4,Term5},
Res1.
'dec_ResponseData_responses'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_SingleResponse'(V1, [16]) || V1 <- Tlv1].


'dec_ResponseData_responseExtensions'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_ResponseData_responseExtensions_Extension'(V1, [16]) || V1 <- Tlv1].


'dec_ResponseData_responseExtensions_Extension'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute extnID(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute critical(2) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{1,V2}|TempTlv3] ->
    {decode_boolean(V2, []), TempTlv3};
    _ ->
        {false,Tlv2}
end,

%%-------------------------------------------------
%% attribute extnValue(3) with type OCTET STRING
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = decode_octet_string(V3, [4]),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'Extension',Term1,Term2,Term3},
Res1.


%%================================
%%  ResponderID
%%================================
enc_ResponderID(Val) ->
    enc_ResponderID(Val, []).

enc_ResponderID(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      byName ->
         'PKIX1Explicit-2009':'enc_Name'(element(2,Val), [<<161>>]);
      byKey ->
         encode_restricted_string(element(2,Val), [<<4>>,<<162>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_ResponderID(Tlv) ->
   dec_ResponderID(Tlv, []).

dec_ResponderID(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'byName'
    {131073, V1} -> 
        {byName, 'PKIX1Explicit-2009':'dec_Name'(V1, [])};


%% 'byKey'
    {131074, V1} -> 
        {byKey, decode_octet_string(V1, [4])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  KeyHash
%%================================
enc_KeyHash(Val) ->
    enc_KeyHash(Val, [<<4>>]).

enc_KeyHash(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_KeyHash(Tlv) ->
   dec_KeyHash(Tlv, [4]).

dec_KeyHash(Tlv, TagIn) ->
decode_octet_string(Tlv, TagIn).



%%================================
%%  SingleResponse
%%================================
enc_SingleResponse(Val) ->
    enc_SingleResponse(Val, [<<48>>]).

enc_SingleResponse(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4,Cindex5} = Val,

%%-------------------------------------------------
%% attribute certID(1)   External OCSP-2024-08:CertID
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_CertID'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute certStatus(2)   External OCSP-2024-08:CertStatus
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_CertStatus'(Cindex2, []),

%%-------------------------------------------------
%% attribute thisUpdate(3) with type GeneralizedTime
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_restricted_string(Cindex3, [<<24>>]),

%%-------------------------------------------------
%% attribute nextUpdate(4) with type GeneralizedTime OPTIONAL
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case Cindex4 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex4, [<<24>>,<<160>>])
       end,

%%-------------------------------------------------
%% attribute singleExtensions(5) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
   {EncBytes5,EncLen5} =  case Cindex5 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_SingleResponse_singleExtensions'(Cindex5, [<<48>>,<<161>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4, EncBytes5],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4 + EncLen5,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  SingleResponse_singleExtensions
%%================================
enc_SingleResponse_singleExtensions(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_SingleResponse_singleExtensions_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_SingleResponse_singleExtensions_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_SingleResponse_singleExtensions_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_SingleResponse_singleExtensions_Extension'(H, [<<48>>]),
   'enc_SingleResponse_singleExtensions_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  SingleResponse_singleExtensions_Extension
%%================================
enc_SingleResponse_singleExtensions_Extension(Val, TagIn) ->
   {_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute extnID(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute critical(2) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case is_default_2(Cindex2) of
true -> {[],0};
false ->
encode_boolean(Cindex2, [<<1>>])
       end,

%%-------------------------------------------------
%% attribute extnValue(3) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_restricted_string(Cindex3, [<<4>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_SingleResponse(Tlv) ->
   dec_SingleResponse(Tlv, [16]).

dec_SingleResponse(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute certID(1)   External OCSP-2024-08:CertID
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_CertID'(V1, [16]),

%%-------------------------------------------------
%% attribute certStatus(2)   External OCSP-2024-08:CertStatus
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_CertStatus'(V2, []),

%%-------------------------------------------------
%% attribute thisUpdate(3) with type GeneralizedTime
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = begin
binary_to_list(decode_restricted_string(V3, [24]))
end
,

%%-------------------------------------------------
%% attribute nextUpdate(4) with type GeneralizedTime OPTIONAL
%%-------------------------------------------------
{Term4,Tlv5} = case Tlv4 of
[{131072,V4}|TempTlv5] ->
    {begin
binary_to_list(decode_restricted_string(V4, [24]))
end
, TempTlv5};
    _ ->
        { asn1_NOVALUE, Tlv4}
end,

%%-------------------------------------------------
%% attribute singleExtensions(5) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
{Term5,Tlv6} = case Tlv5 of
[{131073,V5}|TempTlv6] ->
    {'dec_SingleResponse_singleExtensions'(V5, [16]), TempTlv6};
    _ ->
        { asn1_NOVALUE, Tlv5}
end,

case Tlv6 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv6}}}) % extra fields not allowed
end,
Res1 = {'SingleResponse',Term1,Term2,Term3,Term4,Term5},
Res1.
'dec_SingleResponse_singleExtensions'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_SingleResponse_singleExtensions_Extension'(V1, [16]) || V1 <- Tlv1].


'dec_SingleResponse_singleExtensions_Extension'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute extnID(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute critical(2) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{1,V2}|TempTlv3] ->
    {decode_boolean(V2, []), TempTlv3};
    _ ->
        {false,Tlv2}
end,

%%-------------------------------------------------
%% attribute extnValue(3) with type OCTET STRING
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = decode_octet_string(V3, [4]),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'Extension',Term1,Term2,Term3},
Res1.


%%================================
%%  CertStatus
%%================================
enc_CertStatus(Val) ->
    enc_CertStatus(Val, []).

enc_CertStatus(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      good ->
         encode_null(element(2,Val), [<<128>>]);
      revoked ->
         'enc_RevokedInfo'(element(2,Val), [<<161>>]);
      unknown ->
         encode_null(element(2,Val), [<<130>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_CertStatus(Tlv) ->
   dec_CertStatus(Tlv, []).

dec_CertStatus(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'good'
    {131072, V1} -> 
        {good, decode_null(V1, [])};


%% 'revoked'
    {131073, V1} -> 
        {revoked, 'dec_RevokedInfo'(V1, [])};


%% 'unknown'
    {131074, V1} -> 
        {unknown, decode_null(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  RevokedInfo
%%================================
enc_RevokedInfo(Val) ->
    enc_RevokedInfo(Val, [<<48>>]).

enc_RevokedInfo(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute revocationTime(1) with type GeneralizedTime
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_restricted_string(Cindex1, [<<24>>]),

%%-------------------------------------------------
%% attribute revocationReason(2) with type ENUMERATED OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            case Cindex2 of
unspecified -> encode_tags([<<10>>,<<160>>], [0], 1);
keyCompromise -> encode_tags([<<10>>,<<160>>], [1], 1);
cACompromise -> encode_tags([<<10>>,<<160>>], [2], 1);
affiliationChanged -> encode_tags([<<10>>,<<160>>], [3], 1);
superseded -> encode_tags([<<10>>,<<160>>], [4], 1);
cessationOfOperation -> encode_tags([<<10>>,<<160>>], [5], 1);
certificateHold -> encode_tags([<<10>>,<<160>>], [6], 1);
removeFromCRL -> encode_tags([<<10>>,<<160>>], [8], 1);
privilegeWithdrawn -> encode_tags([<<10>>,<<160>>], [9], 1);
aACompromise -> encode_tags([<<10>>,<<160>>], [10], 1);
Enumval2 -> exit({error,{asn1, {enumerated_not_in_range,Enumval2}}})
end
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_RevokedInfo(Tlv) ->
   dec_RevokedInfo(Tlv, [16]).

dec_RevokedInfo(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute revocationTime(1) with type GeneralizedTime
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
binary_to_list(decode_restricted_string(V1, [24]))
end
,

%%-------------------------------------------------
%% attribute revocationReason(2) with type ENUMERATED OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131072,V2}|TempTlv3] ->
    {case decode_integer(V2, [10]) of
0 -> unspecified;
1 -> keyCompromise;
2 -> cACompromise;
3 -> affiliationChanged;
4 -> superseded;
5 -> cessationOfOperation;
6 -> certificateHold;
8 -> removeFromCRL;
9 -> privilegeWithdrawn;
10 -> aACompromise;
Default1 -> exit({error,{asn1,{illegal_enumerated,Default1}}})
end, TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'RevokedInfo',Term1,Term2},
Res1.


%%================================
%%  UnknownInfo
%%================================
enc_UnknownInfo(Val) ->
    enc_UnknownInfo(Val, [<<5>>]).

enc_UnknownInfo(Val, TagIn) ->
encode_null(Val, TagIn).


dec_UnknownInfo(Tlv) ->
   dec_UnknownInfo(Tlv, [5]).

dec_UnknownInfo(Tlv, TagIn) ->
decode_null(Tlv, TagIn).



%%================================
%%  ArchiveCutoff
%%================================
enc_ArchiveCutoff(Val) ->
    enc_ArchiveCutoff(Val, [<<24>>]).

enc_ArchiveCutoff(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_ArchiveCutoff(Tlv) ->
   dec_ArchiveCutoff(Tlv, [24]).

dec_ArchiveCutoff(Tlv, TagIn) ->
begin
binary_to_list(decode_restricted_string(Tlv, TagIn))
end
.



%%================================
%%  AcceptableResponses
%%================================
enc_AcceptableResponses(Val) ->
    enc_AcceptableResponses(Val, [<<48>>]).

enc_AcceptableResponses(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_AcceptableResponses_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_AcceptableResponses_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_AcceptableResponses_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = encode_object_identifier(H, [<<6>>]),
   'enc_AcceptableResponses_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_AcceptableResponses(Tlv) ->
   dec_AcceptableResponses(Tlv, [16]).

dec_AcceptableResponses(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
[decode_object_identifier(V1, [6]) || V1 <- Tlv1].




%%================================
%%  ServiceLocator
%%================================
enc_ServiceLocator(Val) ->
    enc_ServiceLocator(Val, [<<48>>]).

enc_ServiceLocator(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute issuer(1)   External PKIX1Explicit-2009:Name
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'PKIX1Explicit-2009':'enc_Name'(Cindex1, []),

%%-------------------------------------------------
%% attribute locator(2)   External PKIX1Implicit-2009:AuthorityInfoAccessSyntax
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'PKIX1Implicit-2009':'enc_AuthorityInfoAccessSyntax'(Cindex2, [<<48>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_ServiceLocator(Tlv) ->
   dec_ServiceLocator(Tlv, [16]).

dec_ServiceLocator(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute issuer(1)   External PKIX1Explicit-2009:Name
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'PKIX1Explicit-2009':'dec_Name'(V1, []),

%%-------------------------------------------------
%% attribute locator(2)   External PKIX1Implicit-2009:AuthorityInfoAccessSyntax
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'PKIX1Implicit-2009':'dec_AuthorityInfoAccessSyntax'(V2, [16]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'ServiceLocator',Term1,Term2},
Res1.


%%================================
%%  CrlID
%%================================
enc_CrlID(Val) ->
    enc_CrlID(Val, [<<48>>]).

enc_CrlID(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute crlUrl(1) with type IA5String OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex1, [<<22>>,<<160>>])
       end,

%%-------------------------------------------------
%% attribute crlNum(2) with type INTEGER OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_integer(Cindex2, [<<2>>,<<161>>])
       end,

%%-------------------------------------------------
%% attribute crlTime(3) with type GeneralizedTime OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex3, [<<24>>,<<162>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_CrlID(Tlv) ->
   dec_CrlID(Tlv, [16]).

dec_CrlID(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute crlUrl(1) with type IA5String OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {begin
binary_to_list(decode_restricted_string(V1, [22]))
end
, TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute crlNum(2) with type INTEGER OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {decode_integer(V2, [2]), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute crlTime(3) with type GeneralizedTime OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131074,V3}|TempTlv4] ->
    {begin
binary_to_list(decode_restricted_string(V3, [24]))
end
, TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'CrlID',Term1,Term2,Term3},
Res1.


%%================================
%%  PreferredSignatureAlgorithms
%%================================
enc_PreferredSignatureAlgorithms(Val) ->
    enc_PreferredSignatureAlgorithms(Val, [<<48>>]).

enc_PreferredSignatureAlgorithms(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_PreferredSignatureAlgorithms_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_PreferredSignatureAlgorithms_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_PreferredSignatureAlgorithms_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_PreferredSignatureAlgorithm'(H, [<<48>>]),
   'enc_PreferredSignatureAlgorithms_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_PreferredSignatureAlgorithms(Tlv) ->
   dec_PreferredSignatureAlgorithms(Tlv, [16]).

dec_PreferredSignatureAlgorithms(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_PreferredSignatureAlgorithm'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  PreferredSignatureAlgorithm
%%================================
enc_PreferredSignatureAlgorithm(Val) ->
    enc_PreferredSignatureAlgorithm(Val, [<<48>>]).

enc_PreferredSignatureAlgorithm(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute sigIdentifier(1) with type SEQUENCE
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_PreferredSignatureAlgorithm_sigIdentifier'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute certIdentifier(2) with type SEQUENCE OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_PreferredSignatureAlgorithm_certIdentifier'(Cindex2, [<<48>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  PreferredSignatureAlgorithm_sigIdentifier
%%================================
enc_PreferredSignatureAlgorithm_sigIdentifier(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'OCSP-2024-08':'getenc_internal_object_set_argument_24'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  PreferredSignatureAlgorithm_certIdentifier
%%================================
enc_PreferredSignatureAlgorithm_certIdentifier(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'OCSP-2024-08':'getenc_internal_object_set_argument_26'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_PreferredSignatureAlgorithm(Tlv) ->
   dec_PreferredSignatureAlgorithm(Tlv, [16]).

dec_PreferredSignatureAlgorithm(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute sigIdentifier(1) with type SEQUENCE
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_PreferredSignatureAlgorithm_sigIdentifier'(V1, [16]),

%%-------------------------------------------------
%% attribute certIdentifier(2) with type SEQUENCE OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{16,V2}|TempTlv3] ->
    {'dec_PreferredSignatureAlgorithm_certIdentifier'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'PreferredSignatureAlgorithm',Term1,Term2},
Res1.
'dec_PreferredSignatureAlgorithm_sigIdentifier'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'OCSP-2024-08':'getdec_internal_object_set_argument_24'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'PreferredSignatureAlgorithm_sigIdentifier',Term1,Term2},
Res1.
'dec_PreferredSignatureAlgorithm_certIdentifier'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'OCSP-2024-08':'getdec_internal_object_set_argument_26'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'PreferredSignatureAlgorithm_certIdentifier',Term1,Term2},
Res1.
'id-kp-OCSPSigning'() ->
{1,3,6,1,5,5,7,3,9}.

'id-pkix-ocsp'() ->
{1,3,6,1,5,5,7,48,1}.

'id-pkix-ocsp-basic'() ->
{1,3,6,1,5,5,7,48,1,1}.

'id-pkix-ocsp-nonce'() ->
{1,3,6,1,5,5,7,48,1,2}.

'id-pkix-ocsp-crl'() ->
{1,3,6,1,5,5,7,48,1,3}.

'id-pkix-ocsp-response'() ->
{1,3,6,1,5,5,7,48,1,4}.

'id-pkix-ocsp-nocheck'() ->
{1,3,6,1,5,5,7,48,1,5}.

'id-pkix-ocsp-archive-cutoff'() ->
{1,3,6,1,5,5,7,48,1,6}.

'id-pkix-ocsp-service-locator'() ->
{1,3,6,1,5,5,7,48,1,7}.

'id-pkix-ocsp-pref-sig-algs'() ->
{1,3,6,1,5,5,7,48,1,8}.

'id-pkix-ocsp-extended-revoke'() ->
{1,3,6,1,5,5,7,48,1,9}.




%%================================
%%  basicResponse
%%================================
enc_basicResponse('Type', Val, _RestPrimFieldName) ->
   enc_BasicOCSPResponse(Val, [<<48>>]).


dec_basicResponse('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_BasicOCSPResponse(Tlv, [16]).

tlv_format(Bytes) when is_binary(Bytes) ->
  {Tlv,_} = ber_decode_nif(Bytes),
  Tlv;
tlv_format(Bytes) ->
  Bytes.



%%================================
%%  ext-ocsp-nocheck
%%================================
'enc_ext-ocsp-nocheck'('ExtnType', Val, _RestPrimFieldName) ->
encode_null(Val, [<<5>>]).


'dec_ext-ocsp-nocheck'('ExtnType', Bytes,_) ->
  Tlv = tlv_format(Bytes),
decode_null(Tlv, [5]).




%%================================
%%  re-ocsp-nonce
%%================================
'enc_re-ocsp-nonce'('ExtnType', Val, _RestPrimFieldName) ->
   enc_Nonce(Val, [<<4>>]).


'dec_re-ocsp-nonce'('ExtnType', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_Nonce(Tlv, [4]).




%%================================
%%  re-ocsp-response
%%================================
'enc_re-ocsp-response'('ExtnType', Val, _RestPrimFieldName) ->
   enc_AcceptableResponses(Val, [<<48>>]).


'dec_re-ocsp-response'('ExtnType', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_AcceptableResponses(Tlv, [16]).




%%================================
%%  re-ocsp-service-locator
%%================================
'enc_re-ocsp-service-locator'('ExtnType', Val, _RestPrimFieldName) ->
   enc_ServiceLocator(Val, [<<48>>]).


'dec_re-ocsp-service-locator'('ExtnType', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_ServiceLocator(Tlv, [16]).




%%================================
%%  re-ocsp-preferred-signature-algorithms
%%================================
'enc_re-ocsp-preferred-signature-algorithms'('ExtnType', Val, _RestPrimFieldName) ->
   enc_PreferredSignatureAlgorithms(Val, [<<48>>]).


'dec_re-ocsp-preferred-signature-algorithms'('ExtnType', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_PreferredSignatureAlgorithms(Tlv, [16]).




%%================================
%%  re-ocsp-crl
%%================================
'enc_re-ocsp-crl'('ExtnType', Val, _RestPrimFieldName) ->
   enc_CrlID(Val, [<<48>>]).


'dec_re-ocsp-crl'('ExtnType', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_CrlID(Tlv, [16]).




%%================================
%%  re-ocsp-archive-cutoff
%%================================
'enc_re-ocsp-archive-cutoff'('ExtnType', Val, _RestPrimFieldName) ->
   enc_ArchiveCutoff(Val, [<<24>>]).


'dec_re-ocsp-archive-cutoff'('ExtnType', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_ArchiveCutoff(Tlv, [24]).




%%================================
%%  re-ocsp-extended-revoke
%%================================
'enc_re-ocsp-extended-revoke'('ExtnType', Val, _RestPrimFieldName) ->
encode_null(Val, [<<5>>]).


'dec_re-ocsp-extended-revoke'('ExtnType', Bytes,_) ->
  Tlv = tlv_format(Bytes),
decode_null(Tlv, [5]).




%%================================
%%  ResponseSet
%%================================
getenc_ResponseSet(Id) when Id =:= {1,3,6,1,5,5,7,48,1,1} ->
    fun enc_basicResponse/3;
getenc_ResponseSet(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_ResponseSet(Id) when Id =:= {1,3,6,1,5,5,7,48,1,1} ->
    fun 'dec_basicResponse'/3;
getdec_ResponseSet(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_8
%%================================
getenc_internal_object_set_argument_8(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_8(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_6
%%================================
getenc_internal_object_set_argument_6(Id) when Id =:= {1,3,6,1,5,5,7,48,1,2} ->
    fun 'enc_re-ocsp-nonce'/3;
getenc_internal_object_set_argument_6(Id) when Id =:= {1,3,6,1,5,5,7,48,1,4} ->
    fun 'enc_re-ocsp-response'/3;
getenc_internal_object_set_argument_6(Id) when Id =:= {1,3,6,1,5,5,7,48,1,8} ->
    fun 'enc_re-ocsp-preferred-signature-algorithms'/3;
getenc_internal_object_set_argument_6(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_6(Id) when Id =:= {1,3,6,1,5,5,7,48,1,2} ->
    fun 'dec_re-ocsp-nonce'/3;
getdec_internal_object_set_argument_6(Id) when Id =:= {1,3,6,1,5,5,7,48,1,4} ->
    fun 'dec_re-ocsp-response'/3;
getdec_internal_object_set_argument_6(Id) when Id =:= {1,3,6,1,5,5,7,48,1,8} ->
    fun 'dec_re-ocsp-preferred-signature-algorithms'/3;
getdec_internal_object_set_argument_6(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_5
%%================================
getenc_internal_object_set_argument_5(Id) when Id =:= {1,3,6,1,5,5,7,48,1,2} ->
    fun 'enc_re-ocsp-nonce'/3;
getenc_internal_object_set_argument_5(Id) when Id =:= {1,3,6,1,5,5,7,48,1,4} ->
    fun 'enc_re-ocsp-response'/3;
getenc_internal_object_set_argument_5(Id) when Id =:= {1,3,6,1,5,5,7,48,1,8} ->
    fun 'enc_re-ocsp-preferred-signature-algorithms'/3;
getenc_internal_object_set_argument_5(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_5(Id) when Id =:= {1,3,6,1,5,5,7,48,1,2} ->
    fun 'dec_re-ocsp-nonce'/3;
getdec_internal_object_set_argument_5(Id) when Id =:= {1,3,6,1,5,5,7,48,1,4} ->
    fun 'dec_re-ocsp-response'/3;
getdec_internal_object_set_argument_5(Id) when Id =:= {1,3,6,1,5,5,7,48,1,8} ->
    fun 'dec_re-ocsp-preferred-signature-algorithms'/3;
getdec_internal_object_set_argument_5(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_4
%%================================
getenc_internal_object_set_argument_4(Id) when Id =:= {1,3,6,1,5,5,7,48,1,7} ->
    fun 'enc_re-ocsp-service-locator'/3;
getenc_internal_object_set_argument_4(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_4(Id) when Id =:= {1,3,6,1,5,5,7,48,1,7} ->
    fun 'dec_re-ocsp-service-locator'/3;
getdec_internal_object_set_argument_4(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_3
%%================================
getenc_internal_object_set_argument_3(Id) when Id =:= {1,3,6,1,5,5,7,48,1,7} ->
    fun 'enc_re-ocsp-service-locator'/3;
getenc_internal_object_set_argument_3(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_3(Id) when Id =:= {1,3,6,1,5,5,7,48,1,7} ->
    fun 'dec_re-ocsp-service-locator'/3;
getdec_internal_object_set_argument_3(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_2
%%================================
getenc_internal_object_set_argument_2(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_2(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_19
%%================================
getenc_internal_object_set_argument_19(Id) when Id =:= {1,3,6,1,5,5,7,48,1,2} ->
    fun 'enc_re-ocsp-nonce'/3;
getenc_internal_object_set_argument_19(Id) when Id =:= {1,3,6,1,5,5,7,48,1,9} ->
    fun 'enc_re-ocsp-extended-revoke'/3;
getenc_internal_object_set_argument_19(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_19(Id) when Id =:= {1,3,6,1,5,5,7,48,1,2} ->
    fun 'dec_re-ocsp-nonce'/3;
getdec_internal_object_set_argument_19(Id) when Id =:= {1,3,6,1,5,5,7,48,1,9} ->
    fun 'dec_re-ocsp-extended-revoke'/3;
getdec_internal_object_set_argument_19(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_18
%%================================
getenc_internal_object_set_argument_18(Id) when Id =:= {2,5,29,21} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-CRLReason'(T,V,O) end;
getenc_internal_object_set_argument_18(Id) when Id =:= {2,5,29,23} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-HoldInstructionCode'(T,V,O) end;
getenc_internal_object_set_argument_18(Id) when Id =:= {2,5,29,24} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-InvalidityDate'(T,V,O) end;
getenc_internal_object_set_argument_18(Id) when Id =:= {2,5,29,29} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-CertificateIssuer'(T,V,O) end;
getenc_internal_object_set_argument_18(Id) when Id =:= {1,3,6,1,5,5,7,48,1,3} ->
    fun 'enc_re-ocsp-crl'/3;
getenc_internal_object_set_argument_18(Id) when Id =:= {1,3,6,1,5,5,7,48,1,6} ->
    fun 'enc_re-ocsp-archive-cutoff'/3;
getenc_internal_object_set_argument_18(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_18(Id) when Id =:= {2,5,29,21} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-CRLReason'(T,V,O) end;
getdec_internal_object_set_argument_18(Id) when Id =:= {2,5,29,23} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-HoldInstructionCode'(T,V,O) end;
getdec_internal_object_set_argument_18(Id) when Id =:= {2,5,29,24} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-InvalidityDate'(T,V,O) end;
getdec_internal_object_set_argument_18(Id) when Id =:= {2,5,29,29} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-CertificateIssuer'(T,V,O) end;
getdec_internal_object_set_argument_18(Id) when Id =:= {1,3,6,1,5,5,7,48,1,3} ->
    fun 'dec_re-ocsp-crl'/3;
getdec_internal_object_set_argument_18(Id) when Id =:= {1,3,6,1,5,5,7,48,1,6} ->
    fun 'dec_re-ocsp-archive-cutoff'/3;
getdec_internal_object_set_argument_18(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_17
%%================================
getenc_internal_object_set_argument_17(Id) when Id =:= {2,5,29,21} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-CRLReason'(T,V,O) end;
getenc_internal_object_set_argument_17(Id) when Id =:= {2,5,29,23} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-HoldInstructionCode'(T,V,O) end;
getenc_internal_object_set_argument_17(Id) when Id =:= {2,5,29,24} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-InvalidityDate'(T,V,O) end;
getenc_internal_object_set_argument_17(Id) when Id =:= {2,5,29,29} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-CertificateIssuer'(T,V,O) end;
getenc_internal_object_set_argument_17(Id) when Id =:= {1,3,6,1,5,5,7,48,1,3} ->
    fun 'enc_re-ocsp-crl'/3;
getenc_internal_object_set_argument_17(Id) when Id =:= {1,3,6,1,5,5,7,48,1,6} ->
    fun 'enc_re-ocsp-archive-cutoff'/3;
getenc_internal_object_set_argument_17(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_17(Id) when Id =:= {2,5,29,21} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-CRLReason'(T,V,O) end;
getdec_internal_object_set_argument_17(Id) when Id =:= {2,5,29,23} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-HoldInstructionCode'(T,V,O) end;
getdec_internal_object_set_argument_17(Id) when Id =:= {2,5,29,24} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-InvalidityDate'(T,V,O) end;
getdec_internal_object_set_argument_17(Id) when Id =:= {2,5,29,29} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-CertificateIssuer'(T,V,O) end;
getdec_internal_object_set_argument_17(Id) when Id =:= {1,3,6,1,5,5,7,48,1,3} ->
    fun 'dec_re-ocsp-crl'/3;
getdec_internal_object_set_argument_17(Id) when Id =:= {1,3,6,1,5,5,7,48,1,6} ->
    fun 'dec_re-ocsp-archive-cutoff'/3;
getdec_internal_object_set_argument_17(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_26
%%================================
getenc_internal_object_set_argument_26(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_26(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_24
%%================================
getenc_internal_object_set_argument_24(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_24(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_22
%%================================
getenc_internal_object_set_argument_22(Id) when Id =:= {1,2,840,10040,4,3} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-dsaWithSHA1'(T,V,O) end;
getenc_internal_object_set_argument_22(Id) when Id =:= {1,2,840,113549,1,1,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-rsaWithMD2'(T,V,O) end;
getenc_internal_object_set_argument_22(Id) when Id =:= {1,2,840,113549,1,1,4} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-rsaWithMD5'(T,V,O) end;
getenc_internal_object_set_argument_22(Id) when Id =:= {1,2,840,113549,1,1,5} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-rsaWithSHA1'(T,V,O) end;
getenc_internal_object_set_argument_22(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_22(Id) when Id =:= {1,2,840,10040,4,3} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-dsaWithSHA1'(T,V,O) end;
getdec_internal_object_set_argument_22(Id) when Id =:= {1,2,840,113549,1,1,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-rsaWithMD2'(T,V,O) end;
getdec_internal_object_set_argument_22(Id) when Id =:= {1,2,840,113549,1,1,4} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-rsaWithMD5'(T,V,O) end;
getdec_internal_object_set_argument_22(Id) when Id =:= {1,2,840,113549,1,1,5} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-rsaWithSHA1'(T,V,O) end;
getdec_internal_object_set_argument_22(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_20
%%================================
getenc_internal_object_set_argument_20(Id) when Id =:= {1,3,6,1,5,5,7,48,1,2} ->
    fun 'enc_re-ocsp-nonce'/3;
getenc_internal_object_set_argument_20(Id) when Id =:= {1,3,6,1,5,5,7,48,1,9} ->
    fun 'enc_re-ocsp-extended-revoke'/3;
getenc_internal_object_set_argument_20(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_20(Id) when Id =:= {1,3,6,1,5,5,7,48,1,2} ->
    fun 'dec_re-ocsp-nonce'/3;
getdec_internal_object_set_argument_20(Id) when Id =:= {1,3,6,1,5,5,7,48,1,9} ->
    fun 'dec_re-ocsp-extended-revoke'/3;
getdec_internal_object_set_argument_20(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.



%%%
%%% Run-time functions.
%%%

'dialyzer-suppressions'(Arg) ->
    ok.

is_default_1(asn1_DEFAULT) ->
true;
is_default_1(Value) ->
try check_int(Value, 0, [{v1,0}]) of
_ -> true
catch throw:false -> false
end.


is_default_2(asn1_DEFAULT) ->
true;
is_default_2(Def) when Def =:= false ->
true;
is_default_2(_) ->
false.


ber_decode_nif(B) ->
    asn1rt_nif:decode_ber_tlv(B).

ber_encode([Tlv]) ->
    ber_encode(Tlv);
ber_encode(Tlv) when is_binary(Tlv) ->
    Tlv;
ber_encode(Tlv) ->
    asn1rt_nif:encode_ber_tlv(Tlv).

check_int(Value, Value, _) when is_integer(Value) ->
    true;
check_int(Value, DefValue, NNL) when is_atom(Value) ->
    case lists:keyfind(Value, 1, NNL) of
        {_, DefValue} ->
            true;
        _ ->
            throw(false)
    end;
check_int(_, _, _) ->
    throw(false).

collect_parts(TlvList) ->
    collect_parts(TlvList, []).

collect_parts([{_, L} | Rest], Acc) when is_list(L) ->
    collect_parts(Rest, [collect_parts(L) | Acc]);
collect_parts([{3, <<Unused,Bits/binary>>} | Rest], _Acc) ->
    collect_parts_bit(Rest, [Bits], Unused);
collect_parts([{_T, V} | Rest], Acc) ->
    collect_parts(Rest, [V | Acc]);
collect_parts([], Acc) ->
    list_to_binary(lists:reverse(Acc)).

collect_parts_bit([{3, <<Unused,Bits/binary>>} | Rest], Acc, Uacc) ->
    collect_parts_bit(Rest, [Bits | Acc], Unused + Uacc);
collect_parts_bit([], Acc, Uacc) ->
    list_to_binary([Uacc | lists:reverse(Acc)]).

dec_subidentifiers(<<>>, _Av, Al) ->
    lists:reverse(Al);
dec_subidentifiers(<<1:1,H:7,T/binary>>, Av, Al) ->
    dec_subidentifiers(T, Av bsl 7 + H, Al);
dec_subidentifiers(<<H,T/binary>>, Av, Al) ->
    dec_subidentifiers(T, 0, [Av bsl 7 + H | Al]).

decode_boolean(Tlv, TagIn) ->
    Val = match_tags(Tlv, TagIn),
    case Val of
        <<0:8>> ->
            false;
        <<_:8>> ->
            true;
        _ ->
            exit({error, {asn1, {decode_boolean, Val}}})
    end.

decode_integer(Tlv, TagIn) ->
    Bin = match_tags(Tlv, TagIn),
    Len = byte_size(Bin),
    <<Int:Len/signed-unit:8>> = Bin,
    Int.

decode_native_bit_string(Buffer, Tags) ->
    case match_and_collect(Buffer, Tags) of
        <<0>> ->
            <<>>;
        <<Unused,Bits/binary>> ->
            Size = bit_size(Bits) - Unused,
            <<Val:Size/bitstring,_:Unused/bitstring>> = Bits,
            Val
    end.

decode_null(Tlv, Tags) ->
    Val = match_tags(Tlv, Tags),
    case Val of
        <<>> ->
            'NULL';
        _ ->
            exit({error, {asn1, {decode_null, Val}}})
    end.

decode_object_identifier(Tlv, Tags) ->
    Val = match_tags(Tlv, Tags),
    [AddedObjVal | ObjVals] = dec_subidentifiers(Val, 0, []),
    {Val1, Val2} =
        if
            AddedObjVal < 40 ->
                {0, AddedObjVal};
            AddedObjVal < 80 ->
                {1, AddedObjVal - 40};
            true ->
                {2, AddedObjVal - 80}
        end,
    list_to_tuple([Val1, Val2 | ObjVals]).

decode_octet_string(Tlv, TagsIn) ->
    Bin = match_and_collect(Tlv, TagsIn),
    binary:copy(Bin).

decode_open_type(Tlv, TagIn) ->
    case match_tags(Tlv, TagIn) of
        Bin when is_binary(Bin) ->
            {InnerTlv, _} = ber_decode_nif(Bin),
            InnerTlv;
        TlvBytes ->
            TlvBytes
    end.

decode_restricted_string(Tlv, TagsIn) ->
    match_and_collect(Tlv, TagsIn).

e_object_identifier({'OBJECT IDENTIFIER', V}) ->
    e_object_identifier(V);
e_object_identifier(V) when is_tuple(V) ->
    e_object_identifier(tuple_to_list(V));
e_object_identifier([E1, E2 | Tail]) ->
    Head = 40 * E1 + E2,
    {H, Lh} = mk_object_val(Head),
    {R, Lr} = lists:mapfoldl(fun enc_obj_id_tail/2, 0, Tail),
    {[H | R], Lh + Lr}.

enc_obj_id_tail(H, Len) ->
    {B, L} = mk_object_val(H),
    {B, Len + L}.

encode_boolean(true, TagIn) ->
    encode_tags(TagIn, [255], 1);
encode_boolean(false, TagIn) ->
    encode_tags(TagIn, [0], 1);
encode_boolean(X, _) ->
    exit({error, {asn1, {encode_boolean, X}}}).

encode_integer(Val) ->
    Bytes =
        if
            Val >= 0 ->
                encode_integer_pos(Val, []);
            true ->
                encode_integer_neg(Val, [])
        end,
    {Bytes, length(Bytes)}.

encode_integer(Val, NamedNumberList, Tag) when is_atom(Val) ->
    case lists:keyfind(Val, 1, NamedNumberList) of
        {_, NewVal} ->
            encode_tags(Tag, encode_integer(NewVal));
        _ ->
            exit({error, {asn1, {encode_integer_namednumber, Val}}})
    end;
encode_integer(Val, _NamedNumberList, Tag) ->
    encode_tags(Tag, encode_integer(Val)).

encode_integer(Val, Tag) when is_integer(Val) ->
    encode_tags(Tag, encode_integer(Val));
encode_integer(Val, _Tag) ->
    exit({error, {asn1, {encode_integer, Val}}}).

encode_integer_neg(-1, [B1 | _T] = L) when B1 > 127 ->
    L;
encode_integer_neg(N, Acc) ->
    encode_integer_neg(N bsr 8, [N band 255 | Acc]).

encode_integer_pos(0, [B | _Acc] = L) when B < 128 ->
    L;
encode_integer_pos(N, Acc) ->
    encode_integer_pos(N bsr 8, [N band 255 | Acc]).

encode_length(L) when L =< 127 ->
    {[L], 1};
encode_length(L) ->
    Oct = minimum_octets(L),
    Len = length(Oct),
    if
        Len =< 126 ->
            {[128 bor Len | Oct], Len + 1};
        true ->
            exit({error, {asn1, too_long_length_oct, Len}})
    end.

encode_null(_Val, TagIn) ->
    encode_tags(TagIn, [], 0).

encode_object_identifier(Val, TagIn) ->
    encode_tags(TagIn, e_object_identifier(Val)).

encode_open_type(Val, T) when is_list(Val) ->
    encode_open_type(list_to_binary(Val), T);
encode_open_type(Val, Tag) ->
    encode_tags(Tag, Val, byte_size(Val)).

encode_restricted_string(OctetList, TagIn) when is_binary(OctetList) ->
    encode_tags(TagIn, OctetList, byte_size(OctetList));
encode_restricted_string(OctetList, TagIn) when is_list(OctetList) ->
    encode_tags(TagIn, OctetList, length(OctetList)).

encode_tags(TagIn, {BytesSoFar, LenSoFar}) ->
    encode_tags(TagIn, BytesSoFar, LenSoFar).

encode_tags([Tag | Trest], BytesSoFar, LenSoFar) ->
    {Bytes2, L2} = encode_length(LenSoFar),
    encode_tags(Trest,
                [Tag, Bytes2 | BytesSoFar],
                LenSoFar + byte_size(Tag) + L2);
encode_tags([], BytesSoFar, LenSoFar) ->
    {BytesSoFar, LenSoFar}.

encode_unnamed_bit_string(Bits, TagIn) ->
    Unused = (8 - bit_size(Bits) band 7) band 7,
    Bin = <<Unused,Bits/bitstring,0:Unused>>,
    encode_tags(TagIn, Bin, byte_size(Bin)).

match_and_collect(Tlv, TagsIn) ->
    Val = match_tags(Tlv, TagsIn),
    case Val of
        [_ | _] = PartList ->
            collect_parts(PartList);
        Bin when is_binary(Bin) ->
            Bin
    end.

match_tags({T, V}, [T]) ->
    V;
match_tags({T, V}, [T | Tt]) ->
    match_tags(V, Tt);
match_tags([{T, V}], [T | Tt]) ->
    match_tags(V, Tt);
match_tags([{T, _V} | _] = Vlist, [T]) ->
    Vlist;
match_tags(Tlv, []) ->
    Tlv;
match_tags({Tag, _V} = Tlv, [T | _Tt]) ->
    exit({error, {asn1, {wrong_tag, {{expected, T}, {got, Tag, Tlv}}}}}).

minimum_octets(0, Acc) ->
    Acc;
minimum_octets(Val, Acc) ->
    minimum_octets(Val bsr 8, [Val band 255 | Acc]).

minimum_octets(Val) ->
    minimum_octets(Val, []).

mk_object_val(0, Ack, Len) ->
    {Ack, Len};
mk_object_val(Val, Ack, Len) ->
    mk_object_val(Val bsr 7, [Val band 127 bor 128 | Ack], Len + 1).

mk_object_val(Val) when Val =< 127 ->
    {[255 band Val], 1};
mk_object_val(Val) ->
    mk_object_val(Val bsr 7, [Val band 127], 1).

number2name(Int, NamedNumberList) ->
    case lists:keyfind(Int, 2, NamedNumberList) of
        {NamedVal, _} ->
            NamedVal;
        _ ->
            Int
    end.
