%% Generated by the Erlang ASN.1 BER compiler. Version: 5.4
%% Purpose: Encoding and decoding of the types in PKIX1Implicit-2009.

-module('PKIX1Implicit-2009').
-moduledoc false.
-compile(nowarn_unused_vars).
-dialyzer(no_improper_lists).
-dialyzer(no_match).
-include("PKIX1Implicit-2009.hrl").
-asn1_info([{vsn,'5.4'},
            {module,'PKIX1Implicit-2009'},
            {options,[{i,"/build/erlang/src/otp/lib/public_key/asn1/../src"},
 warnings,ber,errors,
 {cwd,"/build/erlang/src/otp/lib/public_key/asn1"},
 {outdir,"/build/erlang/src/otp/lib/public_key/asn1/../src"},
 der,noobj,asn1config,
 {i,"."},
 {i,"/build/erlang/src/otp/lib/public_key/asn1"}]}]).

-export([encoding_rule/0,maps/0,bit_string_format/0,
         legacy_erlang_types/0]).
-export(['dialyzer-suppressions'/1]).
-export([
enc_AuthorityKeyIdentifier/2,
enc_KeyIdentifier/2,
enc_KeyUsage/2,
enc_PrivateKeyUsagePeriod/2,
enc_CertificatePolicies/2,
enc_PolicyInformation/2,
enc_CertPolicyId/2,
enc_PolicyQualifierInfo/2,
enc_CPSuri/2,
enc_UserNotice/2,
enc_NoticeReference/2,
enc_DisplayText/2,
enc_PolicyMappings/2,
enc_GeneralNames/2,
enc_GeneralName/2,
enc_EDIPartyName/2,
enc_SubjectDirectoryAttributes/2,
enc_BasicConstraints/2,
enc_NameConstraints/2,
enc_GeneralSubtrees/2,
enc_GeneralSubtree/2,
enc_BaseDistance/2,
enc_PolicyConstraints/2,
enc_SkipCerts/2,
enc_CRLDistributionPoints/2,
enc_DistributionPoint/2,
enc_DistributionPointName/2,
enc_ReasonFlags/2,
enc_ExtKeyUsageSyntax/2,
enc_KeyPurposeId/2,
enc_AuthorityInfoAccessSyntax/2,
enc_AccessDescription/2,
enc_SubjectInfoAccessSyntax/2,
enc_CRLNumber/2,
enc_IssuingDistributionPoint/2,
enc_CRLReason/2,
'enc_INSTANCE OF'/2
]).

-export([
dec_AuthorityKeyIdentifier/2,
dec_KeyIdentifier/2,
dec_KeyUsage/2,
dec_PrivateKeyUsagePeriod/2,
dec_CertificatePolicies/2,
dec_PolicyInformation/2,
dec_CertPolicyId/2,
dec_PolicyQualifierInfo/2,
dec_CPSuri/2,
dec_UserNotice/2,
dec_NoticeReference/2,
dec_DisplayText/2,
dec_PolicyMappings/2,
dec_GeneralNames/2,
dec_GeneralName/2,
dec_EDIPartyName/2,
dec_SubjectDirectoryAttributes/2,
dec_BasicConstraints/2,
dec_NameConstraints/2,
dec_GeneralSubtrees/2,
dec_GeneralSubtree/2,
dec_BaseDistance/2,
dec_PolicyConstraints/2,
dec_SkipCerts/2,
dec_CRLDistributionPoints/2,
dec_DistributionPoint/2,
dec_DistributionPointName/2,
dec_ReasonFlags/2,
dec_ExtKeyUsageSyntax/2,
dec_KeyPurposeId/2,
dec_AuthorityInfoAccessSyntax/2,
dec_AccessDescription/2,
dec_SubjectInfoAccessSyntax/2,
dec_CRLNumber/2,
dec_IssuingDistributionPoint/2,
dec_CRLReason/2,
'dec_INSTANCE OF'/2
]).

-export([
'enc_ext-AuthorityKeyIdentifier'/3,
'enc_ext-SubjectKeyIdentifier'/3,
'enc_ext-KeyUsage'/3,
'enc_ext-PrivateKeyUsagePeriod'/3,
'enc_ext-CertificatePolicies'/3,
'enc_pqid-cps'/3,
'enc_pqid-unotice'/3,
'enc_ext-PolicyMappings'/3,
'enc_ext-SubjectAltName'/3,
'enc_ext-IssuerAltName'/3,
'enc_ext-SubjectDirectoryAttributes'/3,
'enc_ext-BasicConstraints'/3,
'enc_ext-NameConstraints'/3,
'enc_ext-PolicyConstraints'/3,
'enc_ext-CRLDistributionPoints'/3,
'enc_ext-ExtKeyUsage'/3,
'enc_ext-InhibitAnyPolicy'/3,
'enc_ext-FreshestCRL'/3,
'enc_ext-AuthorityInfoAccess'/3,
'enc_ext-SubjectInfoAccessSyntax'/3,
'enc_ext-CRLNumber'/3,
'enc_ext-IssuingDistributionPoint'/3,
'enc_ext-DeltaCRLIndicator'/3,
'enc_ext-CRLReason'/3,
'enc_ext-CertificateIssuer'/3,
'enc_ext-HoldInstructionCode'/3,
'enc_ext-InvalidityDate'/3
]).

-export([
'dec_ext-AuthorityKeyIdentifier'/3,
'dec_ext-SubjectKeyIdentifier'/3,
'dec_ext-KeyUsage'/3,
'dec_ext-PrivateKeyUsagePeriod'/3,
'dec_ext-CertificatePolicies'/3,
'dec_pqid-cps'/3,
'dec_pqid-unotice'/3,
'dec_ext-PolicyMappings'/3,
'dec_ext-SubjectAltName'/3,
'dec_ext-IssuerAltName'/3,
'dec_ext-SubjectDirectoryAttributes'/3,
'dec_ext-BasicConstraints'/3,
'dec_ext-NameConstraints'/3,
'dec_ext-PolicyConstraints'/3,
'dec_ext-CRLDistributionPoints'/3,
'dec_ext-ExtKeyUsage'/3,
'dec_ext-InhibitAnyPolicy'/3,
'dec_ext-FreshestCRL'/3,
'dec_ext-AuthorityInfoAccess'/3,
'dec_ext-SubjectInfoAccessSyntax'/3,
'dec_ext-CRLNumber'/3,
'dec_ext-IssuingDistributionPoint'/3,
'dec_ext-DeltaCRLIndicator'/3,
'dec_ext-CRLReason'/3,
'dec_ext-CertificateIssuer'/3,
'dec_ext-HoldInstructionCode'/3,
'dec_ext-InvalidityDate'/3
]).

-export([
getenc_CertExtensions/1,
getenc_CrlExtensions/1,
getenc_CrlEntryExtensions/1,
getenc_PolicyQualifierId/1,
getenc_internal_object_set_argument_2/1
]).

-export([
getdec_CertExtensions/1,
getdec_CrlExtensions/1,
getdec_CrlEntryExtensions/1,
getdec_PolicyQualifierId/1,
getdec_internal_object_set_argument_2/1
]).

-export([
'id-ce'/0,
'id-ce-authorityKeyIdentifier'/0,
'id-ce-subjectKeyIdentifier'/0,
'id-ce-keyUsage'/0,
'id-ce-privateKeyUsagePeriod'/0,
'id-ce-certificatePolicies'/0,
'id-ce-policyMappings'/0,
'id-ce-subjectAltName'/0,
'id-ce-issuerAltName'/0,
'id-ce-subjectDirectoryAttributes'/0,
'id-ce-basicConstraints'/0,
'id-ce-nameConstraints'/0,
'id-ce-policyConstraints'/0,
'id-ce-cRLDistributionPoints'/0,
'id-ce-extKeyUsage'/0,
anyExtendedKeyUsage/0,
'id-kp-serverAuth'/0,
'id-kp-clientAuth'/0,
'id-kp-codeSigning'/0,
'id-kp-emailProtection'/0,
'id-kp-timeStamping'/0,
'id-kp-OCSPSigning'/0,
'id-ce-inhibitAnyPolicy'/0,
'id-ce-freshestCRL'/0,
'id-pe-authorityInfoAccess'/0,
'id-pe-subjectInfoAccess'/0,
'id-ce-cRLNumber'/0,
'id-ce-issuingDistributionPoint'/0,
'id-ce-deltaCRLIndicator'/0,
'id-ce-cRLReasons'/0,
'id-ce-certificateIssuer'/0,
'id-ce-holdInstructionCode'/0,
holdInstruction/0,
'id-holdinstruction-none'/0,
'id-holdinstruction-callissuer'/0,
'id-holdinstruction-reject'/0,
'id-ce-invalidityDate'/0,
ubMax/0
]).

-export([info/0]).

-export([encode/2,decode/2]).

encoding_rule() -> ber.

maps() -> false.

bit_string_format() -> bitstring.

legacy_erlang_types() -> false.

encode(Type, Data) ->
try iolist_to_binary(element(1, encode_disp(Type, Data))) of
  Bytes ->
    {ok,Bytes}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end.


decode(Type, Data) ->
try
   Result = decode_disp(Type, element(1, ber_decode_nif(Data))),
   {ok,Result}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end.

encode_disp('AuthorityKeyIdentifier', Data) -> enc_AuthorityKeyIdentifier(Data);
encode_disp('KeyIdentifier', Data) -> enc_KeyIdentifier(Data);
encode_disp('KeyUsage', Data) -> enc_KeyUsage(Data);
encode_disp('PrivateKeyUsagePeriod', Data) -> enc_PrivateKeyUsagePeriod(Data);
encode_disp('CertificatePolicies', Data) -> enc_CertificatePolicies(Data);
encode_disp('PolicyInformation', Data) -> enc_PolicyInformation(Data);
encode_disp('CertPolicyId', Data) -> enc_CertPolicyId(Data);
encode_disp('PolicyQualifierInfo', Data) -> enc_PolicyQualifierInfo(Data);
encode_disp('CPSuri', Data) -> enc_CPSuri(Data);
encode_disp('UserNotice', Data) -> enc_UserNotice(Data);
encode_disp('NoticeReference', Data) -> enc_NoticeReference(Data);
encode_disp('DisplayText', Data) -> enc_DisplayText(Data);
encode_disp('PolicyMappings', Data) -> enc_PolicyMappings(Data);
encode_disp('GeneralNames', Data) -> enc_GeneralNames(Data);
encode_disp('GeneralName', Data) -> enc_GeneralName(Data);
encode_disp('EDIPartyName', Data) -> enc_EDIPartyName(Data);
encode_disp('SubjectDirectoryAttributes', Data) -> enc_SubjectDirectoryAttributes(Data);
encode_disp('BasicConstraints', Data) -> enc_BasicConstraints(Data);
encode_disp('NameConstraints', Data) -> enc_NameConstraints(Data);
encode_disp('GeneralSubtrees', Data) -> enc_GeneralSubtrees(Data);
encode_disp('GeneralSubtree', Data) -> enc_GeneralSubtree(Data);
encode_disp('BaseDistance', Data) -> enc_BaseDistance(Data);
encode_disp('PolicyConstraints', Data) -> enc_PolicyConstraints(Data);
encode_disp('SkipCerts', Data) -> enc_SkipCerts(Data);
encode_disp('CRLDistributionPoints', Data) -> enc_CRLDistributionPoints(Data);
encode_disp('DistributionPoint', Data) -> enc_DistributionPoint(Data);
encode_disp('DistributionPointName', Data) -> enc_DistributionPointName(Data);
encode_disp('ReasonFlags', Data) -> enc_ReasonFlags(Data);
encode_disp('ExtKeyUsageSyntax', Data) -> enc_ExtKeyUsageSyntax(Data);
encode_disp('KeyPurposeId', Data) -> enc_KeyPurposeId(Data);
encode_disp('AuthorityInfoAccessSyntax', Data) -> enc_AuthorityInfoAccessSyntax(Data);
encode_disp('AccessDescription', Data) -> enc_AccessDescription(Data);
encode_disp('SubjectInfoAccessSyntax', Data) -> enc_SubjectInfoAccessSyntax(Data);
encode_disp('CRLNumber', Data) -> enc_CRLNumber(Data);
encode_disp('IssuingDistributionPoint', Data) -> enc_IssuingDistributionPoint(Data);
encode_disp('CRLReason', Data) -> enc_CRLReason(Data);
encode_disp('INSTANCE OF', Data) -> 'enc_INSTANCE OF'(Data);
encode_disp(Type, _Data) -> exit({error,{asn1,{undefined_type,Type}}}).

decode_disp('AuthorityKeyIdentifier', Data) -> dec_AuthorityKeyIdentifier(Data);
decode_disp('KeyIdentifier', Data) -> dec_KeyIdentifier(Data);
decode_disp('KeyUsage', Data) -> dec_KeyUsage(Data);
decode_disp('PrivateKeyUsagePeriod', Data) -> dec_PrivateKeyUsagePeriod(Data);
decode_disp('CertificatePolicies', Data) -> dec_CertificatePolicies(Data);
decode_disp('PolicyInformation', Data) -> dec_PolicyInformation(Data);
decode_disp('CertPolicyId', Data) -> dec_CertPolicyId(Data);
decode_disp('PolicyQualifierInfo', Data) -> dec_PolicyQualifierInfo(Data);
decode_disp('CPSuri', Data) -> dec_CPSuri(Data);
decode_disp('UserNotice', Data) -> dec_UserNotice(Data);
decode_disp('NoticeReference', Data) -> dec_NoticeReference(Data);
decode_disp('DisplayText', Data) -> dec_DisplayText(Data);
decode_disp('PolicyMappings', Data) -> dec_PolicyMappings(Data);
decode_disp('GeneralNames', Data) -> dec_GeneralNames(Data);
decode_disp('GeneralName', Data) -> dec_GeneralName(Data);
decode_disp('EDIPartyName', Data) -> dec_EDIPartyName(Data);
decode_disp('SubjectDirectoryAttributes', Data) -> dec_SubjectDirectoryAttributes(Data);
decode_disp('BasicConstraints', Data) -> dec_BasicConstraints(Data);
decode_disp('NameConstraints', Data) -> dec_NameConstraints(Data);
decode_disp('GeneralSubtrees', Data) -> dec_GeneralSubtrees(Data);
decode_disp('GeneralSubtree', Data) -> dec_GeneralSubtree(Data);
decode_disp('BaseDistance', Data) -> dec_BaseDistance(Data);
decode_disp('PolicyConstraints', Data) -> dec_PolicyConstraints(Data);
decode_disp('SkipCerts', Data) -> dec_SkipCerts(Data);
decode_disp('CRLDistributionPoints', Data) -> dec_CRLDistributionPoints(Data);
decode_disp('DistributionPoint', Data) -> dec_DistributionPoint(Data);
decode_disp('DistributionPointName', Data) -> dec_DistributionPointName(Data);
decode_disp('ReasonFlags', Data) -> dec_ReasonFlags(Data);
decode_disp('ExtKeyUsageSyntax', Data) -> dec_ExtKeyUsageSyntax(Data);
decode_disp('KeyPurposeId', Data) -> dec_KeyPurposeId(Data);
decode_disp('AuthorityInfoAccessSyntax', Data) -> dec_AuthorityInfoAccessSyntax(Data);
decode_disp('AccessDescription', Data) -> dec_AccessDescription(Data);
decode_disp('SubjectInfoAccessSyntax', Data) -> dec_SubjectInfoAccessSyntax(Data);
decode_disp('CRLNumber', Data) -> dec_CRLNumber(Data);
decode_disp('IssuingDistributionPoint', Data) -> dec_IssuingDistributionPoint(Data);
decode_disp('CRLReason', Data) -> dec_CRLReason(Data);
decode_disp('INSTANCE OF', Data) -> 'dec_INSTANCE OF'(Data);
decode_disp(Type, _Data) -> exit({error,{asn1,{undefined_type,Type}}}).

info() ->
   case ?MODULE:module_info(attributes) of
     Attributes when is_list(Attributes) ->
       case lists:keyfind(asn1_info, 1, Attributes) of
         {_,Info} when is_list(Info) ->
           Info;
         _ ->
           []
       end;
     _ ->
       []
   end.


%%================================
%%  AuthorityKeyIdentifier
%%================================
enc_AuthorityKeyIdentifier(Val) ->
    enc_AuthorityKeyIdentifier(Val, [<<48>>]).

enc_AuthorityKeyIdentifier(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute keyIdentifier(1) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex1, [<<128>>])
       end,

%%-------------------------------------------------
%% attribute authorityCertIssuer(2)   External PKIX1Implicit-2009:GeneralNames OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_GeneralNames'(Cindex2, [<<161>>])
       end,

%%-------------------------------------------------
%% attribute authorityCertSerialNumber(3) with type INTEGER OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_integer(Cindex3, [<<130>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_AuthorityKeyIdentifier(Tlv) ->
   dec_AuthorityKeyIdentifier(Tlv, [16]).

dec_AuthorityKeyIdentifier(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute keyIdentifier(1) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {decode_octet_string(V1, []), TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute authorityCertIssuer(2)   External PKIX1Implicit-2009:GeneralNames OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {'dec_GeneralNames'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute authorityCertSerialNumber(3) with type INTEGER OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131074,V3}|TempTlv4] ->
    {decode_integer(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'AuthorityKeyIdentifier',Term1,Term2,Term3},
Res1.


%%================================
%%  KeyIdentifier
%%================================
enc_KeyIdentifier(Val) ->
    enc_KeyIdentifier(Val, [<<4>>]).

enc_KeyIdentifier(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_KeyIdentifier(Tlv) ->
   dec_KeyIdentifier(Tlv, [4]).

dec_KeyIdentifier(Tlv, TagIn) ->
decode_octet_string(Tlv, TagIn).



%%================================
%%  KeyUsage
%%================================
enc_KeyUsage(Val) ->
    enc_KeyUsage(Val, [<<3>>]).

enc_KeyUsage(Val, TagIn) ->
encode_named_bit_string(Val, [{digitalSignature,0},{nonRepudiation,1},{keyEncipherment,2},{dataEncipherment,3},{keyAgreement,4},{keyCertSign,5},{cRLSign,6},{encipherOnly,7},{decipherOnly,8}], TagIn).


dec_KeyUsage(Tlv) ->
   dec_KeyUsage(Tlv, [3]).

dec_KeyUsage(Tlv, TagIn) ->
decode_named_bit_string(Tlv, [{digitalSignature,0},{nonRepudiation,1},{keyEncipherment,2},{dataEncipherment,3},{keyAgreement,4},{keyCertSign,5},{cRLSign,6},{encipherOnly,7},{decipherOnly,8}], TagIn).



%%================================
%%  PrivateKeyUsagePeriod
%%================================
enc_PrivateKeyUsagePeriod(Val) ->
    enc_PrivateKeyUsagePeriod(Val, [<<48>>]).

enc_PrivateKeyUsagePeriod(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute notBefore(1) with type GeneralizedTime OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex1, [<<128>>])
       end,

%%-------------------------------------------------
%% attribute notAfter(2) with type GeneralizedTime OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex2, [<<129>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_PrivateKeyUsagePeriod(Tlv) ->
   dec_PrivateKeyUsagePeriod(Tlv, [16]).

dec_PrivateKeyUsagePeriod(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute notBefore(1) with type GeneralizedTime OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {begin
binary_to_list(decode_restricted_string(V1, []))
end
, TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute notAfter(2) with type GeneralizedTime OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {begin
binary_to_list(decode_restricted_string(V2, []))
end
, TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'PrivateKeyUsagePeriod',Term1,Term2},
Res1.


%%================================
%%  CertificatePolicies
%%================================
enc_CertificatePolicies(Val) ->
    enc_CertificatePolicies(Val, [<<48>>]).

enc_CertificatePolicies(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_CertificatePolicies_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_CertificatePolicies_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_CertificatePolicies_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_PolicyInformation'(H, [<<48>>]),
   'enc_CertificatePolicies_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_CertificatePolicies(Tlv) ->
   dec_CertificatePolicies(Tlv, [16]).

dec_CertificatePolicies(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_PolicyInformation'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  PolicyInformation
%%================================
enc_PolicyInformation(Val) ->
    enc_PolicyInformation(Val, [<<48>>]).

enc_PolicyInformation(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute policyIdentifier(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute policyQualifiers(2) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_PolicyInformation_policyQualifiers'(Cindex2, [<<48>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  PolicyInformation_policyQualifiers
%%================================
enc_PolicyInformation_policyQualifiers(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_PolicyInformation_policyQualifiers_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_PolicyInformation_policyQualifiers_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_PolicyInformation_policyQualifiers_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_PolicyQualifierInfo'(H, [<<48>>]),
   'enc_PolicyInformation_policyQualifiers_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_PolicyInformation(Tlv) ->
   dec_PolicyInformation(Tlv, [16]).

dec_PolicyInformation(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute policyIdentifier(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute policyQualifiers(2) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{16,V2}|TempTlv3] ->
    {'dec_PolicyInformation_policyQualifiers'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'PolicyInformation',Term1,Term2},
Res1.
'dec_PolicyInformation_policyQualifiers'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_PolicyQualifierInfo'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  CertPolicyId
%%================================
enc_CertPolicyId(Val) ->
    enc_CertPolicyId(Val, [<<6>>]).

enc_CertPolicyId(Val, TagIn) ->
encode_object_identifier(Val, TagIn).


dec_CertPolicyId(Tlv) ->
   dec_CertPolicyId(Tlv, [6]).

dec_CertPolicyId(Tlv, TagIn) ->
decode_object_identifier(Tlv, TagIn).



%%================================
%%  PolicyQualifierInfo
%%================================
enc_PolicyQualifierInfo(Val) ->
    enc_PolicyQualifierInfo(Val, [<<48>>]).

enc_PolicyQualifierInfo(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,
ObjpolicyQualifierId = 
   'PKIX1Implicit-2009':'getenc_PolicyQualifierId'(                                   Cindex1),

%%-------------------------------------------------
%% attribute policyQualifierId(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute qualifier(2) with type typefieldType
%%-------------------------------------------------
   {TmpBytes2,_} = ObjpolicyQualifierId('Type', Cindex2, []),
   {EncBytes2,EncLen2} = encode_open_type(TmpBytes2, [])
,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_PolicyQualifierInfo(Tlv) ->
   dec_PolicyQualifierInfo(Tlv, [16]).

dec_PolicyQualifierInfo(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute policyQualifierId(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute qualifier(2) with type typefieldType
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 

  Tmpterm1 = decode_open_type(V2, []),

DecObjpolicyQualifierIdTerm1 =
   'PKIX1Implicit-2009':'getdec_PolicyQualifierId'(Term1),
Term2 = 
   case (catch DecObjpolicyQualifierIdTerm1('Type', Tmpterm1, [])) of
      {'EXIT', Reason1} ->
         exit({'Type not compatible with table constraint',Reason1});
      Tmpterm2 ->
         Tmpterm2
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'PolicyQualifierInfo',Term1,Term2},
Res1.


%%================================
%%  CPSuri
%%================================
enc_CPSuri(Val) ->
    enc_CPSuri(Val, [<<22>>]).

enc_CPSuri(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_CPSuri(Tlv) ->
   dec_CPSuri(Tlv, [22]).

dec_CPSuri(Tlv, TagIn) ->
begin
binary_to_list(decode_restricted_string(Tlv, TagIn))
end
.



%%================================
%%  UserNotice
%%================================
enc_UserNotice(Val) ->
    enc_UserNotice(Val, [<<48>>]).

enc_UserNotice(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute noticeRef(1)   External PKIX1Implicit-2009:NoticeReference OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_NoticeReference'(Cindex1, [<<48>>])
       end,

%%-------------------------------------------------
%% attribute explicitText(2)   External PKIX1Implicit-2009:DisplayText OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_DisplayText'(Cindex2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_UserNotice(Tlv) ->
   dec_UserNotice(Tlv, [16]).

dec_UserNotice(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute noticeRef(1)   External PKIX1Implicit-2009:NoticeReference OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{16,V1}|TempTlv2] ->
    {'dec_NoticeReference'(V1, []), TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute explicitText(2)   External PKIX1Implicit-2009:DisplayText OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[V2 = {22,_}|TempTlv3] ->
    {'dec_DisplayText'(V2, []), TempTlv3};
[V2 = {26,_}|TempTlv3] ->
    {'dec_DisplayText'(V2, []), TempTlv3};
[V2 = {30,_}|TempTlv3] ->
    {'dec_DisplayText'(V2, []), TempTlv3};
[V2 = {12,_}|TempTlv3] ->
    {'dec_DisplayText'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'UserNotice',Term1,Term2},
Res1.


%%================================
%%  NoticeReference
%%================================
enc_NoticeReference(Val) ->
    enc_NoticeReference(Val, [<<48>>]).

enc_NoticeReference(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute organization(1)   External PKIX1Implicit-2009:DisplayText
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_DisplayText'(Cindex1, []),

%%-------------------------------------------------
%% attribute noticeNumbers(2) with type SEQUENCE OF
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_NoticeReference_noticeNumbers'(Cindex2, [<<48>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  NoticeReference_noticeNumbers
%%================================
enc_NoticeReference_noticeNumbers(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_NoticeReference_noticeNumbers_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_NoticeReference_noticeNumbers_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_NoticeReference_noticeNumbers_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = encode_integer(H, [<<2>>]),
   'enc_NoticeReference_noticeNumbers_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_NoticeReference(Tlv) ->
   dec_NoticeReference(Tlv, [16]).

dec_NoticeReference(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute organization(1)   External PKIX1Implicit-2009:DisplayText
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_DisplayText'(V1, []),

%%-------------------------------------------------
%% attribute noticeNumbers(2) with type SEQUENCE OF
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_NoticeReference_noticeNumbers'(V2, [16]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'NoticeReference',Term1,Term2},
Res1.
'dec_NoticeReference_noticeNumbers'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
[decode_integer(V1, [2]) || V1 <- Tlv1].




%%================================
%%  DisplayText
%%================================
enc_DisplayText(Val) ->
    enc_DisplayText(Val, []).

enc_DisplayText(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      ia5String ->
         encode_restricted_string(element(2,Val), [<<22>>]);
      visibleString ->
         encode_restricted_string(element(2,Val), [<<26>>]);
      bmpString ->
         encode_BMP_string(element(2,Val), [<<30>>]);
      utf8String ->
         encode_UTF8_string(element(2,Val), [<<12>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_DisplayText(Tlv) ->
   dec_DisplayText(Tlv, []).

dec_DisplayText(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'ia5String'
    {22, V1} -> 
        {ia5String, begin
Val1 = decode_restricted_string(V1, []),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 200 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'visibleString'
    {26, V1} -> 
        {visibleString, begin
Val2 = decode_restricted_string(V1, []),
C2 = byte_size(Val2),
if 1 =< C2, C2 =< 200 ->
binary_to_list(Val2);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'bmpString'
    {30, V1} -> 
        {bmpString, begin
Val3 = decode_BMP_string(V1, []),
C3 = length(Val3),
if 1 =< C3, C3 =< 200 ->
Val3;
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'utf8String'
    {12, V1} -> 
        {utf8String, decode_UTF8_string(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  PolicyMappings
%%================================
enc_PolicyMappings(Val) ->
    enc_PolicyMappings(Val, [<<48>>]).

enc_PolicyMappings(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_PolicyMappings_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_PolicyMappings_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_PolicyMappings_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_PolicyMappings_SEQOF'(H, [<<48>>]),
   'enc_PolicyMappings_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  PolicyMappings_SEQOF
%%================================
enc_PolicyMappings_SEQOF(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute issuerDomainPolicy(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute subjectDomainPolicy(2) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_object_identifier(Cindex2, [<<6>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_PolicyMappings(Tlv) ->
   dec_PolicyMappings(Tlv, [16]).

dec_PolicyMappings(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_PolicyMappings_SEQOF'(V1, [16]) || V1 <- Tlv1].


'dec_PolicyMappings_SEQOF'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute issuerDomainPolicy(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute subjectDomainPolicy(2) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_object_identifier(V2, [6]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'PolicyMappings_SEQOF',Term1,Term2},
Res1.


%%================================
%%  GeneralNames
%%================================
enc_GeneralNames(Val) ->
    enc_GeneralNames(Val, [<<48>>]).

enc_GeneralNames(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_GeneralNames_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_GeneralNames_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_GeneralNames_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_GeneralName'(H, []),
   'enc_GeneralNames_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_GeneralNames(Tlv) ->
   dec_GeneralNames(Tlv, [16]).

dec_GeneralNames(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_GeneralName'(V1, []) || V1 <- Tlv1].




%%================================
%%  GeneralName
%%================================
enc_GeneralName(Val) ->
    enc_GeneralName(Val, []).

enc_GeneralName(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      otherName ->
         'enc_INSTANCE OF'(element(2,Val), [<<160>>]);
      rfc822Name ->
         encode_restricted_string(element(2,Val), [<<129>>]);
      dNSName ->
         encode_restricted_string(element(2,Val), [<<130>>]);
      x400Address ->
         'PKIX-X400Address-2009':'enc_ORAddress'(element(2,Val), [<<163>>]);
      directoryName ->
         'PKIX1Explicit-2009':'enc_Name'(element(2,Val), [<<164>>]);
      ediPartyName ->
         'enc_EDIPartyName'(element(2,Val), [<<165>>]);
      uniformResourceIdentifier ->
         encode_restricted_string(element(2,Val), [<<134>>]);
      iPAddress ->
         encode_restricted_string(element(2,Val), [<<135>>]);
      registeredID ->
         encode_object_identifier(element(2,Val), [<<136>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_GeneralName(Tlv) ->
   dec_GeneralName(Tlv, []).

dec_GeneralName(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'otherName'
    {131072, V1} -> 
        {otherName, 'dec_INSTANCE OF'(V1, [])};


%% 'rfc822Name'
    {131073, V1} -> 
        {rfc822Name, begin
binary_to_list(decode_restricted_string(V1, []))
end
};


%% 'dNSName'
    {131074, V1} -> 
        {dNSName, begin
binary_to_list(decode_restricted_string(V1, []))
end
};


%% 'x400Address'
    {131075, V1} -> 
        {x400Address, 'PKIX-X400Address-2009':'dec_ORAddress'(V1, [])};


%% 'directoryName'
    {131076, V1} -> 
        {directoryName, 'PKIX1Explicit-2009':'dec_Name'(V1, [])};


%% 'ediPartyName'
    {131077, V1} -> 
        {ediPartyName, 'dec_EDIPartyName'(V1, [])};


%% 'uniformResourceIdentifier'
    {131078, V1} -> 
        {uniformResourceIdentifier, begin
binary_to_list(decode_restricted_string(V1, []))
end
};


%% 'iPAddress'
    {131079, V1} -> 
        {iPAddress, decode_octet_string(V1, [])};


%% 'registeredID'
    {131080, V1} -> 
        {registeredID, decode_object_identifier(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  EDIPartyName
%%================================
enc_EDIPartyName(Val) ->
    enc_EDIPartyName(Val, [<<48>>]).

enc_EDIPartyName(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute nameAssigner(1) with type CHOICE OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_EDIPartyName_nameAssigner'(Cindex1, [<<160>>])
       end,

%%-------------------------------------------------
%% attribute partyName(2) with type CHOICE
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_EDIPartyName_partyName'(Cindex2, [<<161>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  EDIPartyName_nameAssigner
%%================================
enc_EDIPartyName_nameAssigner(Val, TagIn) ->
      {EncBytes,EncLen} = case element(1,Val) of
      teletexString ->
         encode_restricted_string(element(2,Val), [<<20>>]);
      printableString ->
         encode_restricted_string(element(2,Val), [<<19>>]);
      bmpString ->
         encode_BMP_string(element(2,Val), [<<30>>]);
      universalString ->
         encode_universal_string(element(2,Val), [<<28>>]);
      utf8String ->
         encode_UTF8_string(element(2,Val), [<<12>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).





%%================================
%%  EDIPartyName_partyName
%%================================
enc_EDIPartyName_partyName(Val, TagIn) ->
      {EncBytes,EncLen} = case element(1,Val) of
      teletexString ->
         encode_restricted_string(element(2,Val), [<<20>>]);
      printableString ->
         encode_restricted_string(element(2,Val), [<<19>>]);
      bmpString ->
         encode_BMP_string(element(2,Val), [<<30>>]);
      universalString ->
         encode_universal_string(element(2,Val), [<<28>>]);
      utf8String ->
         encode_UTF8_string(element(2,Val), [<<12>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_EDIPartyName(Tlv) ->
   dec_EDIPartyName(Tlv, [16]).

dec_EDIPartyName(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute nameAssigner(1) with type CHOICE OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {'dec_EDIPartyName_nameAssigner'(V1, []), TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute partyName(2) with type CHOICE
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_EDIPartyName_partyName'(V2, [131073]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'EDIPartyName',Term1,Term2},
Res1.
'dec_EDIPartyName_nameAssigner'(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'teletexString'
    {20, V1} -> 
        {teletexString, begin
Val1 = decode_restricted_string(V1, []),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 32768 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'printableString'
    {19, V1} -> 
        {printableString, begin
Val2 = decode_restricted_string(V1, []),
C2 = byte_size(Val2),
if 1 =< C2, C2 =< 32768 ->
binary_to_list(Val2);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'bmpString'
    {30, V1} -> 
        {bmpString, begin
Val3 = decode_BMP_string(V1, []),
C3 = length(Val3),
if 1 =< C3, C3 =< 32768 ->
Val3;
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'universalString'
    {28, V1} -> 
        {universalString, begin
Val4 = decode_universal_string(V1, []),
C4 = length(Val4),
if 1 =< C4, C4 =< 32768 ->
Val4;
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'utf8String'
    {12, V1} -> 
        {utf8String, decode_UTF8_string(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.
'dec_EDIPartyName_partyName'(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'teletexString'
    {20, V1} -> 
        {teletexString, begin
Val1 = decode_restricted_string(V1, []),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 32768 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'printableString'
    {19, V1} -> 
        {printableString, begin
Val2 = decode_restricted_string(V1, []),
C2 = byte_size(Val2),
if 1 =< C2, C2 =< 32768 ->
binary_to_list(Val2);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'bmpString'
    {30, V1} -> 
        {bmpString, begin
Val3 = decode_BMP_string(V1, []),
C3 = length(Val3),
if 1 =< C3, C3 =< 32768 ->
Val3;
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'universalString'
    {28, V1} -> 
        {universalString, begin
Val4 = decode_universal_string(V1, []),
C4 = length(Val4),
if 1 =< C4, C4 =< 32768 ->
Val4;
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'utf8String'
    {12, V1} -> 
        {utf8String, decode_UTF8_string(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  SubjectDirectoryAttributes
%%================================
enc_SubjectDirectoryAttributes(Val) ->
    enc_SubjectDirectoryAttributes(Val, [<<48>>]).

enc_SubjectDirectoryAttributes(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_SubjectDirectoryAttributes_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_SubjectDirectoryAttributes_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_SubjectDirectoryAttributes_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_SubjectDirectoryAttributes_AttributeSet'(H, [<<48>>]),
   'enc_SubjectDirectoryAttributes_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  SubjectDirectoryAttributes_AttributeSet
%%================================
enc_SubjectDirectoryAttributes_AttributeSet(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objtype = 
   'PKIX1Implicit-2009':'getenc_internal_object_set_argument_2'(                                   Cindex1),

%%-------------------------------------------------
%% attribute type(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute values(2) with type SET OF
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_SubjectDirectoryAttributes_AttributeSet_values'(Cindex2, [<<49>>], Objtype),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  SubjectDirectoryAttributes_AttributeSet_values
%%================================
enc_SubjectDirectoryAttributes_AttributeSet_values(Val, TagIn, ObjFun) ->
      {EncBytes,EncLen} = 'enc_SubjectDirectoryAttributes_AttributeSet_values_components'(Val, ObjFun,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_SubjectDirectoryAttributes_AttributeSet_values_components'([], _, AccBytes, AccLen) -> 
   {dynamicsort_SETOF(AccBytes),AccLen};

'enc_SubjectDirectoryAttributes_AttributeSet_values_components'([H|T], ObjFun,AccBytes, AccLen) ->
   {TmpBytes,_} = ObjFun('Type', H, []),
   {EncBytes,EncLen} = encode_open_type(TmpBytes, [])
,
   'enc_SubjectDirectoryAttributes_AttributeSet_values_components'(T, ObjFun,[EncBytes|AccBytes], AccLen + EncLen).



dec_SubjectDirectoryAttributes(Tlv) ->
   dec_SubjectDirectoryAttributes(Tlv, [16]).

dec_SubjectDirectoryAttributes(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_SubjectDirectoryAttributes_AttributeSet'(V1, [16]) || V1 <- Tlv1].


'dec_SubjectDirectoryAttributes_AttributeSet'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute type(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),
ObjFun = 'PKIX1Implicit-2009':'getdec_internal_object_set_argument_2'(Term1),

%%-------------------------------------------------
%% attribute values(2) with type SET OF
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_SubjectDirectoryAttributes_AttributeSet_values'(V2, [17], ObjFun),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'AttributeSet',Term1,Term2},
Res1.
'dec_SubjectDirectoryAttributes_AttributeSet_values'(Tlv, TagIn, ObjFun) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
[
      begin
         Tmptlv1 = decode_open_type(V1, []),
         case (catch ObjFun('Type', Tmptlv1, [])) of
            {'EXIT',Reason1} ->
               exit({'Type not compatible with table constraint', Reason1});
            Tmpterm1 ->
               Tmpterm1
         end
      end
 || V1 <- Tlv1].




%%================================
%%  BasicConstraints
%%================================
enc_BasicConstraints(Val) ->
    enc_BasicConstraints(Val, [<<48>>]).

enc_BasicConstraints(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute cA(1) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case is_default_1(Cindex1) of
true -> {[],0};
false ->
encode_boolean(Cindex1, [<<1>>])
       end,

%%-------------------------------------------------
%% attribute pathLenConstraint(2) with type INTEGER OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_integer(Cindex2, [<<2>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_BasicConstraints(Tlv) ->
   dec_BasicConstraints(Tlv, [16]).

dec_BasicConstraints(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute cA(1) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{1,V1}|TempTlv2] ->
    {decode_boolean(V1, []), TempTlv2};
    _ ->
        {false,Tlv1}
end,

%%-------------------------------------------------
%% attribute pathLenConstraint(2) with type INTEGER OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{2,V2}|TempTlv3] ->
    {begin
Val1 = decode_integer(V2, []),
if 0 =< Val1, Val1 =< 'MAX' ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'BasicConstraints',Term1,Term2},
Res1.


%%================================
%%  NameConstraints
%%================================
enc_NameConstraints(Val) ->
    enc_NameConstraints(Val, [<<48>>]).

enc_NameConstraints(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute permittedSubtrees(1)   External PKIX1Implicit-2009:GeneralSubtrees OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_GeneralSubtrees'(Cindex1, [<<160>>])
       end,

%%-------------------------------------------------
%% attribute excludedSubtrees(2)   External PKIX1Implicit-2009:GeneralSubtrees OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_GeneralSubtrees'(Cindex2, [<<161>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_NameConstraints(Tlv) ->
   dec_NameConstraints(Tlv, [16]).

dec_NameConstraints(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute permittedSubtrees(1)   External PKIX1Implicit-2009:GeneralSubtrees OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {'dec_GeneralSubtrees'(V1, []), TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute excludedSubtrees(2)   External PKIX1Implicit-2009:GeneralSubtrees OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {'dec_GeneralSubtrees'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'NameConstraints',Term1,Term2},
Res1.


%%================================
%%  GeneralSubtrees
%%================================
enc_GeneralSubtrees(Val) ->
    enc_GeneralSubtrees(Val, [<<48>>]).

enc_GeneralSubtrees(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_GeneralSubtrees_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_GeneralSubtrees_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_GeneralSubtrees_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_GeneralSubtree'(H, [<<48>>]),
   'enc_GeneralSubtrees_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_GeneralSubtrees(Tlv) ->
   dec_GeneralSubtrees(Tlv, [16]).

dec_GeneralSubtrees(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_GeneralSubtree'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  GeneralSubtree
%%================================
enc_GeneralSubtree(Val) ->
    enc_GeneralSubtree(Val, [<<48>>]).

enc_GeneralSubtree(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute base(1)   External PKIX1Implicit-2009:GeneralName
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_GeneralName'(Cindex1, []),

%%-------------------------------------------------
%% attribute minimum(2) with type INTEGER DEFAULT = 0
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case is_default_2(Cindex2) of
true -> {[],0};
false ->
encode_integer(Cindex2, [<<128>>])
       end,

%%-------------------------------------------------
%% attribute maximum(3) with type INTEGER OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_integer(Cindex3, [<<129>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_GeneralSubtree(Tlv) ->
   dec_GeneralSubtree(Tlv, [16]).

dec_GeneralSubtree(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute base(1)   External PKIX1Implicit-2009:GeneralName
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_GeneralName'(V1, []),

%%-------------------------------------------------
%% attribute minimum(2) with type INTEGER DEFAULT = 0
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131072,V2}|TempTlv3] ->
    {begin
Val1 = decode_integer(V2, []),
if 0 =< Val1, Val1 =< 'MAX' ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv3};
    _ ->
        {0,Tlv2}
end,

%%-------------------------------------------------
%% attribute maximum(3) with type INTEGER OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131073,V3}|TempTlv4] ->
    {begin
Val2 = decode_integer(V3, []),
if 0 =< Val2, Val2 =< 'MAX' ->
Val2;
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'GeneralSubtree',Term1,Term2,Term3},
Res1.


%%================================
%%  BaseDistance
%%================================
enc_BaseDistance(Val) ->
    enc_BaseDistance(Val, [<<2>>]).

enc_BaseDistance(Val, TagIn) ->
encode_integer(Val, TagIn).


dec_BaseDistance(Tlv) ->
   dec_BaseDistance(Tlv, [2]).

dec_BaseDistance(Tlv, TagIn) ->
begin
Val1 = decode_integer(Tlv, TagIn),
if 0 =< Val1, Val1 =< 'MAX' ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end.



%%================================
%%  PolicyConstraints
%%================================
enc_PolicyConstraints(Val) ->
    enc_PolicyConstraints(Val, [<<48>>]).

enc_PolicyConstraints(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute requireExplicitPolicy(1) with type INTEGER OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_integer(Cindex1, [<<128>>])
       end,

%%-------------------------------------------------
%% attribute inhibitPolicyMapping(2) with type INTEGER OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_integer(Cindex2, [<<129>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_PolicyConstraints(Tlv) ->
   dec_PolicyConstraints(Tlv, [16]).

dec_PolicyConstraints(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute requireExplicitPolicy(1) with type INTEGER OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {begin
Val1 = decode_integer(V1, []),
if 0 =< Val1, Val1 =< 'MAX' ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute inhibitPolicyMapping(2) with type INTEGER OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {begin
Val2 = decode_integer(V2, []),
if 0 =< Val2, Val2 =< 'MAX' ->
Val2;
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'PolicyConstraints',Term1,Term2},
Res1.


%%================================
%%  SkipCerts
%%================================
enc_SkipCerts(Val) ->
    enc_SkipCerts(Val, [<<2>>]).

enc_SkipCerts(Val, TagIn) ->
encode_integer(Val, TagIn).


dec_SkipCerts(Tlv) ->
   dec_SkipCerts(Tlv, [2]).

dec_SkipCerts(Tlv, TagIn) ->
begin
Val1 = decode_integer(Tlv, TagIn),
if 0 =< Val1, Val1 =< 'MAX' ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end.



%%================================
%%  CRLDistributionPoints
%%================================
enc_CRLDistributionPoints(Val) ->
    enc_CRLDistributionPoints(Val, [<<48>>]).

enc_CRLDistributionPoints(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_CRLDistributionPoints_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_CRLDistributionPoints_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_CRLDistributionPoints_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_DistributionPoint'(H, [<<48>>]),
   'enc_CRLDistributionPoints_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_CRLDistributionPoints(Tlv) ->
   dec_CRLDistributionPoints(Tlv, [16]).

dec_CRLDistributionPoints(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_DistributionPoint'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  DistributionPoint
%%================================
enc_DistributionPoint(Val) ->
    enc_DistributionPoint(Val, [<<48>>]).

enc_DistributionPoint(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute distributionPoint(1)   External PKIX1Implicit-2009:DistributionPointName OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_DistributionPointName'(Cindex1, [<<160>>])
       end,

%%-------------------------------------------------
%% attribute reasons(2) with type BIT STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_named_bit_string(Cindex2, [{unused,0},{keyCompromise,1},{cACompromise,2},{affiliationChanged,3},{superseded,4},{cessationOfOperation,5},{certificateHold,6},{privilegeWithdrawn,7},{aACompromise,8}], [<<129>>])
       end,

%%-------------------------------------------------
%% attribute cRLIssuer(3)   External PKIX1Implicit-2009:GeneralNames OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_GeneralNames'(Cindex3, [<<162>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_DistributionPoint(Tlv) ->
   dec_DistributionPoint(Tlv, [16]).

dec_DistributionPoint(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute distributionPoint(1)   External PKIX1Implicit-2009:DistributionPointName OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {'dec_DistributionPointName'(V1, []), TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute reasons(2) with type BIT STRING OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {decode_named_bit_string(V2, [{unused,0},{keyCompromise,1},{cACompromise,2},{affiliationChanged,3},{superseded,4},{cessationOfOperation,5},{certificateHold,6},{privilegeWithdrawn,7},{aACompromise,8}], []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute cRLIssuer(3)   External PKIX1Implicit-2009:GeneralNames OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131074,V3}|TempTlv4] ->
    {'dec_GeneralNames'(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'DistributionPoint',Term1,Term2,Term3},
Res1.


%%================================
%%  DistributionPointName
%%================================
enc_DistributionPointName(Val) ->
    enc_DistributionPointName(Val, []).

enc_DistributionPointName(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      fullName ->
         'enc_GeneralNames'(element(2,Val), [<<160>>]);
      nameRelativeToCRLIssuer ->
         'PKIX1Explicit-2009':'enc_RelativeDistinguishedName'(element(2,Val), [<<161>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_DistributionPointName(Tlv) ->
   dec_DistributionPointName(Tlv, []).

dec_DistributionPointName(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'fullName'
    {131072, V1} -> 
        {fullName, 'dec_GeneralNames'(V1, [])};


%% 'nameRelativeToCRLIssuer'
    {131073, V1} -> 
        {nameRelativeToCRLIssuer, 'PKIX1Explicit-2009':'dec_RelativeDistinguishedName'(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  ReasonFlags
%%================================
enc_ReasonFlags(Val) ->
    enc_ReasonFlags(Val, [<<3>>]).

enc_ReasonFlags(Val, TagIn) ->
encode_named_bit_string(Val, [{unused,0},{keyCompromise,1},{cACompromise,2},{affiliationChanged,3},{superseded,4},{cessationOfOperation,5},{certificateHold,6},{privilegeWithdrawn,7},{aACompromise,8}], TagIn).


dec_ReasonFlags(Tlv) ->
   dec_ReasonFlags(Tlv, [3]).

dec_ReasonFlags(Tlv, TagIn) ->
decode_named_bit_string(Tlv, [{unused,0},{keyCompromise,1},{cACompromise,2},{affiliationChanged,3},{superseded,4},{cessationOfOperation,5},{certificateHold,6},{privilegeWithdrawn,7},{aACompromise,8}], TagIn).



%%================================
%%  ExtKeyUsageSyntax
%%================================
enc_ExtKeyUsageSyntax(Val) ->
    enc_ExtKeyUsageSyntax(Val, [<<48>>]).

enc_ExtKeyUsageSyntax(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_ExtKeyUsageSyntax_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_ExtKeyUsageSyntax_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_ExtKeyUsageSyntax_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = encode_object_identifier(H, [<<6>>]),
   'enc_ExtKeyUsageSyntax_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_ExtKeyUsageSyntax(Tlv) ->
   dec_ExtKeyUsageSyntax(Tlv, [16]).

dec_ExtKeyUsageSyntax(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
[decode_object_identifier(V1, [6]) || V1 <- Tlv1].




%%================================
%%  KeyPurposeId
%%================================
enc_KeyPurposeId(Val) ->
    enc_KeyPurposeId(Val, [<<6>>]).

enc_KeyPurposeId(Val, TagIn) ->
encode_object_identifier(Val, TagIn).


dec_KeyPurposeId(Tlv) ->
   dec_KeyPurposeId(Tlv, [6]).

dec_KeyPurposeId(Tlv, TagIn) ->
decode_object_identifier(Tlv, TagIn).



%%================================
%%  AuthorityInfoAccessSyntax
%%================================
enc_AuthorityInfoAccessSyntax(Val) ->
    enc_AuthorityInfoAccessSyntax(Val, [<<48>>]).

enc_AuthorityInfoAccessSyntax(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_AuthorityInfoAccessSyntax_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_AuthorityInfoAccessSyntax_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_AuthorityInfoAccessSyntax_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_AccessDescription'(H, [<<48>>]),
   'enc_AuthorityInfoAccessSyntax_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_AuthorityInfoAccessSyntax(Tlv) ->
   dec_AuthorityInfoAccessSyntax(Tlv, [16]).

dec_AuthorityInfoAccessSyntax(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_AccessDescription'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  AccessDescription
%%================================
enc_AccessDescription(Val) ->
    enc_AccessDescription(Val, [<<48>>]).

enc_AccessDescription(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute accessMethod(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute accessLocation(2)   External PKIX1Implicit-2009:GeneralName
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_GeneralName'(Cindex2, []),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_AccessDescription(Tlv) ->
   dec_AccessDescription(Tlv, [16]).

dec_AccessDescription(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute accessMethod(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute accessLocation(2)   External PKIX1Implicit-2009:GeneralName
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_GeneralName'(V2, []),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'AccessDescription',Term1,Term2},
Res1.


%%================================
%%  SubjectInfoAccessSyntax
%%================================
enc_SubjectInfoAccessSyntax(Val) ->
    enc_SubjectInfoAccessSyntax(Val, [<<48>>]).

enc_SubjectInfoAccessSyntax(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_SubjectInfoAccessSyntax_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_SubjectInfoAccessSyntax_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_SubjectInfoAccessSyntax_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_AccessDescription'(H, [<<48>>]),
   'enc_SubjectInfoAccessSyntax_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_SubjectInfoAccessSyntax(Tlv) ->
   dec_SubjectInfoAccessSyntax(Tlv, [16]).

dec_SubjectInfoAccessSyntax(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_AccessDescription'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  CRLNumber
%%================================
enc_CRLNumber(Val) ->
    enc_CRLNumber(Val, [<<2>>]).

enc_CRLNumber(Val, TagIn) ->
encode_integer(Val, TagIn).


dec_CRLNumber(Tlv) ->
   dec_CRLNumber(Tlv, [2]).

dec_CRLNumber(Tlv, TagIn) ->
begin
Val1 = decode_integer(Tlv, TagIn),
if 0 =< Val1, Val1 =< 'MAX' ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end.



%%================================
%%  IssuingDistributionPoint
%%================================
enc_IssuingDistributionPoint(Val) ->
    enc_IssuingDistributionPoint(Val, [<<48>>]).

enc_IssuingDistributionPoint(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4,Cindex5,Cindex6} = Val,

%%-------------------------------------------------
%% attribute distributionPoint(1)   External PKIX1Implicit-2009:DistributionPointName OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_DistributionPointName'(Cindex1, [<<160>>])
       end,

%%-------------------------------------------------
%% attribute onlyContainsUserCerts(2) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case is_default_3(Cindex2) of
true -> {[],0};
false ->
encode_boolean(Cindex2, [<<129>>])
       end,

%%-------------------------------------------------
%% attribute onlyContainsCACerts(3) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case is_default_4(Cindex3) of
true -> {[],0};
false ->
encode_boolean(Cindex3, [<<130>>])
       end,

%%-------------------------------------------------
%% attribute onlySomeReasons(4) with type BIT STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case Cindex4 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_named_bit_string(Cindex4, [{unused,0},{keyCompromise,1},{cACompromise,2},{affiliationChanged,3},{superseded,4},{cessationOfOperation,5},{certificateHold,6},{privilegeWithdrawn,7},{aACompromise,8}], [<<131>>])
       end,

%%-------------------------------------------------
%% attribute indirectCRL(5) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
   {EncBytes5,EncLen5} =  case is_default_5(Cindex5) of
true -> {[],0};
false ->
encode_boolean(Cindex5, [<<132>>])
       end,

%%-------------------------------------------------
%% attribute onlyContainsAttributeCerts(6) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
   {EncBytes6,EncLen6} =  case is_default_6(Cindex6) of
true -> {[],0};
false ->
encode_boolean(Cindex6, [<<133>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4, EncBytes5, EncBytes6],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4 + EncLen5 + EncLen6,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_IssuingDistributionPoint(Tlv) ->
   dec_IssuingDistributionPoint(Tlv, [16]).

dec_IssuingDistributionPoint(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute distributionPoint(1)   External PKIX1Implicit-2009:DistributionPointName OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {'dec_DistributionPointName'(V1, []), TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute onlyContainsUserCerts(2) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {decode_boolean(V2, []), TempTlv3};
    _ ->
        {false,Tlv2}
end,

%%-------------------------------------------------
%% attribute onlyContainsCACerts(3) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131074,V3}|TempTlv4] ->
    {decode_boolean(V3, []), TempTlv4};
    _ ->
        {false,Tlv3}
end,

%%-------------------------------------------------
%% attribute onlySomeReasons(4) with type BIT STRING OPTIONAL
%%-------------------------------------------------
{Term4,Tlv5} = case Tlv4 of
[{131075,V4}|TempTlv5] ->
    {decode_named_bit_string(V4, [{unused,0},{keyCompromise,1},{cACompromise,2},{affiliationChanged,3},{superseded,4},{cessationOfOperation,5},{certificateHold,6},{privilegeWithdrawn,7},{aACompromise,8}], []), TempTlv5};
    _ ->
        { asn1_NOVALUE, Tlv4}
end,

%%-------------------------------------------------
%% attribute indirectCRL(5) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
{Term5,Tlv6} = case Tlv5 of
[{131076,V5}|TempTlv6] ->
    {decode_boolean(V5, []), TempTlv6};
    _ ->
        {false,Tlv5}
end,

%%-------------------------------------------------
%% attribute onlyContainsAttributeCerts(6) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
{Term6,Tlv7} = case Tlv6 of
[{131077,V6}|TempTlv7] ->
    {decode_boolean(V6, []), TempTlv7};
    _ ->
        {false,Tlv6}
end,

case Tlv7 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv7}}}) % extra fields not allowed
end,
Res1 = {'IssuingDistributionPoint',Term1,Term2,Term3,Term4,Term5,Term6},
Res1.


%%================================
%%  CRLReason
%%================================
enc_CRLReason(Val) ->
    enc_CRLReason(Val, [<<10>>]).

enc_CRLReason(Val, TagIn) ->
case Val of
unspecified -> encode_tags(TagIn, [0], 1);
keyCompromise -> encode_tags(TagIn, [1], 1);
cACompromise -> encode_tags(TagIn, [2], 1);
affiliationChanged -> encode_tags(TagIn, [3], 1);
superseded -> encode_tags(TagIn, [4], 1);
cessationOfOperation -> encode_tags(TagIn, [5], 1);
certificateHold -> encode_tags(TagIn, [6], 1);
removeFromCRL -> encode_tags(TagIn, [8], 1);
privilegeWithdrawn -> encode_tags(TagIn, [9], 1);
aACompromise -> encode_tags(TagIn, [10], 1);
Enumval1 -> exit({error,{asn1, {enumerated_not_in_range,Enumval1}}})
end.


dec_CRLReason(Tlv) ->
   dec_CRLReason(Tlv, [10]).

dec_CRLReason(Tlv, TagIn) ->
case decode_integer(Tlv, TagIn) of
0 -> unspecified;
1 -> keyCompromise;
2 -> cACompromise;
3 -> affiliationChanged;
4 -> superseded;
5 -> cessationOfOperation;
6 -> certificateHold;
8 -> removeFromCRL;
9 -> privilegeWithdrawn;
10 -> aACompromise;
Default1 -> exit({error,{asn1,{illegal_enumerated,Default1}}})
end.



%%================================
%%  INSTANCE OF
%%================================
'enc_INSTANCE OF'(Val) ->
    'enc_INSTANCE OF'(Val, [<<40>>]).

'enc_INSTANCE OF'(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute type-id(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute value(2) with type ASN1_OPEN_TYPE
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_open_type(Cindex2, [<<160>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_INSTANCE OF'(Tlv) ->
   'dec_INSTANCE OF'(Tlv, [8]).

'dec_INSTANCE OF'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute type-id(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute value(2) with type ASN1_OPEN_TYPE
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_open_type_as_binary(V2, [131072]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'INSTANCE OF',Term1,Term2},
Res1.
'id-ce'() ->
{2,5,29}.

'id-ce-authorityKeyIdentifier'() ->
{2,5,29,35}.

'id-ce-subjectKeyIdentifier'() ->
{2,5,29,14}.

'id-ce-keyUsage'() ->
{2,5,29,15}.

'id-ce-privateKeyUsagePeriod'() ->
{2,5,29,16}.

'id-ce-certificatePolicies'() ->
{2,5,29,32}.

'id-ce-policyMappings'() ->
{2,5,29,33}.

'id-ce-subjectAltName'() ->
{2,5,29,17}.

'id-ce-issuerAltName'() ->
{2,5,29,18}.

'id-ce-subjectDirectoryAttributes'() ->
{2,5,29,9}.

'id-ce-basicConstraints'() ->
{2,5,29,19}.

'id-ce-nameConstraints'() ->
{2,5,29,30}.

'id-ce-policyConstraints'() ->
{2,5,29,36}.

'id-ce-cRLDistributionPoints'() ->
{2,5,29,31}.

'id-ce-extKeyUsage'() ->
{2,5,29,37}.

anyExtendedKeyUsage() ->
{2,5,29,37,0}.

'id-kp-serverAuth'() ->
{1,3,6,1,5,5,7,3,1}.

'id-kp-clientAuth'() ->
{1,3,6,1,5,5,7,3,2}.

'id-kp-codeSigning'() ->
{1,3,6,1,5,5,7,3,3}.

'id-kp-emailProtection'() ->
{1,3,6,1,5,5,7,3,4}.

'id-kp-timeStamping'() ->
{1,3,6,1,5,5,7,3,8}.

'id-kp-OCSPSigning'() ->
{1,3,6,1,5,5,7,3,9}.

'id-ce-inhibitAnyPolicy'() ->
{2,5,29,54}.

'id-ce-freshestCRL'() ->
{2,5,29,46}.

'id-pe-authorityInfoAccess'() ->
{1,3,6,1,5,5,7,1,1}.

'id-pe-subjectInfoAccess'() ->
{1,3,6,1,5,5,7,1,11}.

'id-ce-cRLNumber'() ->
{2,5,29,20}.

'id-ce-issuingDistributionPoint'() ->
{2,5,29,28}.

'id-ce-deltaCRLIndicator'() ->
{2,5,29,27}.

'id-ce-cRLReasons'() ->
{2,5,29,21}.

'id-ce-certificateIssuer'() ->
{2,5,29,29}.

'id-ce-holdInstructionCode'() ->
{2,5,29,23}.

holdInstruction() ->
{2,2,840,10040,2}.

'id-holdinstruction-none'() ->
{2,2,840,10040,2,1}.

'id-holdinstruction-callissuer'() ->
{2,2,840,10040,2,2}.

'id-holdinstruction-reject'() ->
{2,2,840,10040,2,3}.

'id-ce-invalidityDate'() ->
{2,5,29,24}.

ubMax() ->
32768.




%%================================
%%  ext-AuthorityKeyIdentifier
%%================================
'enc_ext-AuthorityKeyIdentifier'('ExtnType', Val, _RestPrimFieldName) ->
   enc_AuthorityKeyIdentifier(Val, [<<48>>]).


'dec_ext-AuthorityKeyIdentifier'('ExtnType', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_AuthorityKeyIdentifier(Tlv, [16]).

tlv_format(Bytes) when is_binary(Bytes) ->
  {Tlv,_} = ber_decode_nif(Bytes),
  Tlv;
tlv_format(Bytes) ->
  Bytes.



%%================================
%%  ext-SubjectKeyIdentifier
%%================================
'enc_ext-SubjectKeyIdentifier'('ExtnType', Val, _RestPrimFieldName) ->
   enc_KeyIdentifier(Val, [<<4>>]).


'dec_ext-SubjectKeyIdentifier'('ExtnType', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_KeyIdentifier(Tlv, [4]).




%%================================
%%  ext-KeyUsage
%%================================
'enc_ext-KeyUsage'('ExtnType', Val, _RestPrimFieldName) ->
   enc_KeyUsage(Val, [<<3>>]).


'dec_ext-KeyUsage'('ExtnType', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_KeyUsage(Tlv, [3]).




%%================================
%%  ext-PrivateKeyUsagePeriod
%%================================
'enc_ext-PrivateKeyUsagePeriod'('ExtnType', Val, _RestPrimFieldName) ->
   enc_PrivateKeyUsagePeriod(Val, [<<48>>]).


'dec_ext-PrivateKeyUsagePeriod'('ExtnType', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_PrivateKeyUsagePeriod(Tlv, [16]).




%%================================
%%  ext-CertificatePolicies
%%================================
'enc_ext-CertificatePolicies'('ExtnType', Val, _RestPrimFieldName) ->
   enc_CertificatePolicies(Val, [<<48>>]).


'dec_ext-CertificatePolicies'('ExtnType', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_CertificatePolicies(Tlv, [16]).




%%================================
%%  pqid-cps
%%================================
'enc_pqid-cps'('Type', Val, _RestPrimFieldName) ->
   enc_CPSuri(Val, [<<22>>]).


'dec_pqid-cps'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_CPSuri(Tlv, [22]).




%%================================
%%  pqid-unotice
%%================================
'enc_pqid-unotice'('Type', Val, _RestPrimFieldName) ->
   enc_UserNotice(Val, [<<48>>]).


'dec_pqid-unotice'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_UserNotice(Tlv, [16]).




%%================================
%%  ext-PolicyMappings
%%================================
'enc_ext-PolicyMappings'('ExtnType', Val, _RestPrimFieldName) ->
   enc_PolicyMappings(Val, [<<48>>]).


'dec_ext-PolicyMappings'('ExtnType', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_PolicyMappings(Tlv, [16]).




%%================================
%%  ext-SubjectAltName
%%================================
'enc_ext-SubjectAltName'('ExtnType', Val, _RestPrimFieldName) ->
   enc_GeneralNames(Val, [<<48>>]).


'dec_ext-SubjectAltName'('ExtnType', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_GeneralNames(Tlv, [16]).




%%================================
%%  ext-IssuerAltName
%%================================
'enc_ext-IssuerAltName'('ExtnType', Val, _RestPrimFieldName) ->
   enc_GeneralNames(Val, [<<48>>]).


'dec_ext-IssuerAltName'('ExtnType', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_GeneralNames(Tlv, [16]).




%%================================
%%  ext-SubjectDirectoryAttributes
%%================================
'enc_ext-SubjectDirectoryAttributes'('ExtnType', Val, _RestPrimFieldName) ->
   enc_SubjectDirectoryAttributes(Val, [<<48>>]).


'dec_ext-SubjectDirectoryAttributes'('ExtnType', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_SubjectDirectoryAttributes(Tlv, [16]).




%%================================
%%  ext-BasicConstraints
%%================================
'enc_ext-BasicConstraints'('ExtnType', Val, _RestPrimFieldName) ->
   enc_BasicConstraints(Val, [<<48>>]).


'dec_ext-BasicConstraints'('ExtnType', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_BasicConstraints(Tlv, [16]).




%%================================
%%  ext-NameConstraints
%%================================
'enc_ext-NameConstraints'('ExtnType', Val, _RestPrimFieldName) ->
   enc_NameConstraints(Val, [<<48>>]).


'dec_ext-NameConstraints'('ExtnType', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_NameConstraints(Tlv, [16]).




%%================================
%%  ext-PolicyConstraints
%%================================
'enc_ext-PolicyConstraints'('ExtnType', Val, _RestPrimFieldName) ->
   enc_PolicyConstraints(Val, [<<48>>]).


'dec_ext-PolicyConstraints'('ExtnType', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_PolicyConstraints(Tlv, [16]).




%%================================
%%  ext-CRLDistributionPoints
%%================================
'enc_ext-CRLDistributionPoints'('ExtnType', Val, _RestPrimFieldName) ->
   enc_CRLDistributionPoints(Val, [<<48>>]).


'dec_ext-CRLDistributionPoints'('ExtnType', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_CRLDistributionPoints(Tlv, [16]).




%%================================
%%  ext-ExtKeyUsage
%%================================
'enc_ext-ExtKeyUsage'('ExtnType', Val, _RestPrimFieldName) ->
   enc_ExtKeyUsageSyntax(Val, [<<48>>]).


'dec_ext-ExtKeyUsage'('ExtnType', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_ExtKeyUsageSyntax(Tlv, [16]).




%%================================
%%  ext-InhibitAnyPolicy
%%================================
'enc_ext-InhibitAnyPolicy'('ExtnType', Val, _RestPrimFieldName) ->
   enc_SkipCerts(Val, [<<2>>]).


'dec_ext-InhibitAnyPolicy'('ExtnType', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_SkipCerts(Tlv, [2]).




%%================================
%%  ext-FreshestCRL
%%================================
'enc_ext-FreshestCRL'('ExtnType', Val, _RestPrimFieldName) ->
   enc_CRLDistributionPoints(Val, [<<48>>]).


'dec_ext-FreshestCRL'('ExtnType', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_CRLDistributionPoints(Tlv, [16]).




%%================================
%%  ext-AuthorityInfoAccess
%%================================
'enc_ext-AuthorityInfoAccess'('ExtnType', Val, _RestPrimFieldName) ->
   enc_AuthorityInfoAccessSyntax(Val, [<<48>>]).


'dec_ext-AuthorityInfoAccess'('ExtnType', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_AuthorityInfoAccessSyntax(Tlv, [16]).




%%================================
%%  ext-SubjectInfoAccessSyntax
%%================================
'enc_ext-SubjectInfoAccessSyntax'('ExtnType', Val, _RestPrimFieldName) ->
   enc_SubjectInfoAccessSyntax(Val, [<<48>>]).


'dec_ext-SubjectInfoAccessSyntax'('ExtnType', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_SubjectInfoAccessSyntax(Tlv, [16]).




%%================================
%%  ext-CRLNumber
%%================================
'enc_ext-CRLNumber'('ExtnType', Val, _RestPrimFieldName) ->
encode_integer(Val, [<<2>>]).


'dec_ext-CRLNumber'('ExtnType', Bytes,_) ->
  Tlv = tlv_format(Bytes),
begin
Val1 = decode_integer(Tlv, [2]),
if 0 =< Val1, Val1 =< 'MAX' ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end.




%%================================
%%  ext-IssuingDistributionPoint
%%================================
'enc_ext-IssuingDistributionPoint'('ExtnType', Val, _RestPrimFieldName) ->
   enc_IssuingDistributionPoint(Val, [<<48>>]).


'dec_ext-IssuingDistributionPoint'('ExtnType', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_IssuingDistributionPoint(Tlv, [16]).




%%================================
%%  ext-DeltaCRLIndicator
%%================================
'enc_ext-DeltaCRLIndicator'('ExtnType', Val, _RestPrimFieldName) ->
   enc_CRLNumber(Val, [<<2>>]).


'dec_ext-DeltaCRLIndicator'('ExtnType', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_CRLNumber(Tlv, [2]).




%%================================
%%  ext-CRLReason
%%================================
'enc_ext-CRLReason'('ExtnType', Val, _RestPrimFieldName) ->
   enc_CRLReason(Val, [<<10>>]).


'dec_ext-CRLReason'('ExtnType', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_CRLReason(Tlv, [10]).




%%================================
%%  ext-CertificateIssuer
%%================================
'enc_ext-CertificateIssuer'('ExtnType', Val, _RestPrimFieldName) ->
   enc_GeneralNames(Val, [<<48>>]).


'dec_ext-CertificateIssuer'('ExtnType', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_GeneralNames(Tlv, [16]).




%%================================
%%  ext-HoldInstructionCode
%%================================
'enc_ext-HoldInstructionCode'('ExtnType', Val, _RestPrimFieldName) ->
encode_object_identifier(Val, [<<6>>]).


'dec_ext-HoldInstructionCode'('ExtnType', Bytes,_) ->
  Tlv = tlv_format(Bytes),
decode_object_identifier(Tlv, [6]).




%%================================
%%  ext-InvalidityDate
%%================================
'enc_ext-InvalidityDate'('ExtnType', Val, _RestPrimFieldName) ->
encode_restricted_string(Val, [<<24>>]).


'dec_ext-InvalidityDate'('ExtnType', Bytes,_) ->
  Tlv = tlv_format(Bytes),
begin
binary_to_list(decode_restricted_string(Tlv, [24]))
end
.




%%================================
%%  CertExtensions
%%================================
getenc_CertExtensions(Id) when Id =:= {2,5,29,9} ->
    fun 'enc_ext-SubjectDirectoryAttributes'/3;
getenc_CertExtensions(Id) when Id =:= {2,5,29,14} ->
    fun 'enc_ext-SubjectKeyIdentifier'/3;
getenc_CertExtensions(Id) when Id =:= {2,5,29,15} ->
    fun 'enc_ext-KeyUsage'/3;
getenc_CertExtensions(Id) when Id =:= {2,5,29,16} ->
    fun 'enc_ext-PrivateKeyUsagePeriod'/3;
getenc_CertExtensions(Id) when Id =:= {2,5,29,17} ->
    fun 'enc_ext-SubjectAltName'/3;
getenc_CertExtensions(Id) when Id =:= {2,5,29,18} ->
    fun 'enc_ext-IssuerAltName'/3;
getenc_CertExtensions(Id) when Id =:= {2,5,29,19} ->
    fun 'enc_ext-BasicConstraints'/3;
getenc_CertExtensions(Id) when Id =:= {2,5,29,30} ->
    fun 'enc_ext-NameConstraints'/3;
getenc_CertExtensions(Id) when Id =:= {2,5,29,31} ->
    fun 'enc_ext-CRLDistributionPoints'/3;
getenc_CertExtensions(Id) when Id =:= {2,5,29,32} ->
    fun 'enc_ext-CertificatePolicies'/3;
getenc_CertExtensions(Id) when Id =:= {2,5,29,33} ->
    fun 'enc_ext-PolicyMappings'/3;
getenc_CertExtensions(Id) when Id =:= {2,5,29,35} ->
    fun 'enc_ext-AuthorityKeyIdentifier'/3;
getenc_CertExtensions(Id) when Id =:= {2,5,29,36} ->
    fun 'enc_ext-PolicyConstraints'/3;
getenc_CertExtensions(Id) when Id =:= {2,5,29,37} ->
    fun 'enc_ext-ExtKeyUsage'/3;
getenc_CertExtensions(Id) when Id =:= {2,5,29,46} ->
    fun 'enc_ext-FreshestCRL'/3;
getenc_CertExtensions(Id) when Id =:= {2,5,29,54} ->
    fun 'enc_ext-InhibitAnyPolicy'/3;
getenc_CertExtensions(Id) when Id =:= {1,3,6,1,5,5,7,1,1} ->
    fun 'enc_ext-AuthorityInfoAccess'/3;
getenc_CertExtensions(Id) when Id =:= {1,3,6,1,5,5,7,1,11} ->
    fun 'enc_ext-SubjectInfoAccessSyntax'/3;
getenc_CertExtensions(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_CertExtensions(Id) when Id =:= {2,5,29,9} ->
    fun 'dec_ext-SubjectDirectoryAttributes'/3;
getdec_CertExtensions(Id) when Id =:= {2,5,29,14} ->
    fun 'dec_ext-SubjectKeyIdentifier'/3;
getdec_CertExtensions(Id) when Id =:= {2,5,29,15} ->
    fun 'dec_ext-KeyUsage'/3;
getdec_CertExtensions(Id) when Id =:= {2,5,29,16} ->
    fun 'dec_ext-PrivateKeyUsagePeriod'/3;
getdec_CertExtensions(Id) when Id =:= {2,5,29,17} ->
    fun 'dec_ext-SubjectAltName'/3;
getdec_CertExtensions(Id) when Id =:= {2,5,29,18} ->
    fun 'dec_ext-IssuerAltName'/3;
getdec_CertExtensions(Id) when Id =:= {2,5,29,19} ->
    fun 'dec_ext-BasicConstraints'/3;
getdec_CertExtensions(Id) when Id =:= {2,5,29,30} ->
    fun 'dec_ext-NameConstraints'/3;
getdec_CertExtensions(Id) when Id =:= {2,5,29,31} ->
    fun 'dec_ext-CRLDistributionPoints'/3;
getdec_CertExtensions(Id) when Id =:= {2,5,29,32} ->
    fun 'dec_ext-CertificatePolicies'/3;
getdec_CertExtensions(Id) when Id =:= {2,5,29,33} ->
    fun 'dec_ext-PolicyMappings'/3;
getdec_CertExtensions(Id) when Id =:= {2,5,29,35} ->
    fun 'dec_ext-AuthorityKeyIdentifier'/3;
getdec_CertExtensions(Id) when Id =:= {2,5,29,36} ->
    fun 'dec_ext-PolicyConstraints'/3;
getdec_CertExtensions(Id) when Id =:= {2,5,29,37} ->
    fun 'dec_ext-ExtKeyUsage'/3;
getdec_CertExtensions(Id) when Id =:= {2,5,29,46} ->
    fun 'dec_ext-FreshestCRL'/3;
getdec_CertExtensions(Id) when Id =:= {2,5,29,54} ->
    fun 'dec_ext-InhibitAnyPolicy'/3;
getdec_CertExtensions(Id) when Id =:= {1,3,6,1,5,5,7,1,1} ->
    fun 'dec_ext-AuthorityInfoAccess'/3;
getdec_CertExtensions(Id) when Id =:= {1,3,6,1,5,5,7,1,11} ->
    fun 'dec_ext-SubjectInfoAccessSyntax'/3;
getdec_CertExtensions(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  CrlExtensions
%%================================
getenc_CrlExtensions(Id) when Id =:= {2,5,29,18} ->
    fun 'enc_ext-IssuerAltName'/3;
getenc_CrlExtensions(Id) when Id =:= {2,5,29,20} ->
    fun 'enc_ext-CRLNumber'/3;
getenc_CrlExtensions(Id) when Id =:= {2,5,29,27} ->
    fun 'enc_ext-DeltaCRLIndicator'/3;
getenc_CrlExtensions(Id) when Id =:= {2,5,29,28} ->
    fun 'enc_ext-IssuingDistributionPoint'/3;
getenc_CrlExtensions(Id) when Id =:= {2,5,29,35} ->
    fun 'enc_ext-AuthorityKeyIdentifier'/3;
getenc_CrlExtensions(Id) when Id =:= {2,5,29,46} ->
    fun 'enc_ext-FreshestCRL'/3;
getenc_CrlExtensions(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_CrlExtensions(Id) when Id =:= {2,5,29,18} ->
    fun 'dec_ext-IssuerAltName'/3;
getdec_CrlExtensions(Id) when Id =:= {2,5,29,20} ->
    fun 'dec_ext-CRLNumber'/3;
getdec_CrlExtensions(Id) when Id =:= {2,5,29,27} ->
    fun 'dec_ext-DeltaCRLIndicator'/3;
getdec_CrlExtensions(Id) when Id =:= {2,5,29,28} ->
    fun 'dec_ext-IssuingDistributionPoint'/3;
getdec_CrlExtensions(Id) when Id =:= {2,5,29,35} ->
    fun 'dec_ext-AuthorityKeyIdentifier'/3;
getdec_CrlExtensions(Id) when Id =:= {2,5,29,46} ->
    fun 'dec_ext-FreshestCRL'/3;
getdec_CrlExtensions(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  CrlEntryExtensions
%%================================
getenc_CrlEntryExtensions(Id) when Id =:= {2,5,29,21} ->
    fun 'enc_ext-CRLReason'/3;
getenc_CrlEntryExtensions(Id) when Id =:= {2,5,29,23} ->
    fun 'enc_ext-HoldInstructionCode'/3;
getenc_CrlEntryExtensions(Id) when Id =:= {2,5,29,24} ->
    fun 'enc_ext-InvalidityDate'/3;
getenc_CrlEntryExtensions(Id) when Id =:= {2,5,29,29} ->
    fun 'enc_ext-CertificateIssuer'/3;
getenc_CrlEntryExtensions(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_CrlEntryExtensions(Id) when Id =:= {2,5,29,21} ->
    fun 'dec_ext-CRLReason'/3;
getdec_CrlEntryExtensions(Id) when Id =:= {2,5,29,23} ->
    fun 'dec_ext-HoldInstructionCode'/3;
getdec_CrlEntryExtensions(Id) when Id =:= {2,5,29,24} ->
    fun 'dec_ext-InvalidityDate'/3;
getdec_CrlEntryExtensions(Id) when Id =:= {2,5,29,29} ->
    fun 'dec_ext-CertificateIssuer'/3;
getdec_CrlEntryExtensions(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  PolicyQualifierId
%%================================
getenc_PolicyQualifierId(Id) when Id =:= {1,3,6,1,5,5,7,2,1} ->
    fun 'enc_pqid-cps'/3;
getenc_PolicyQualifierId(Id) when Id =:= {1,3,6,1,5,5,7,2,2} ->
    fun 'enc_pqid-unotice'/3;
getenc_PolicyQualifierId(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_PolicyQualifierId(Id) when Id =:= {1,3,6,1,5,5,7,2,1} ->
    fun 'dec_pqid-cps'/3;
getdec_PolicyQualifierId(Id) when Id =:= {1,3,6,1,5,5,7,2,2} ->
    fun 'dec_pqid-unotice'/3;
getdec_PolicyQualifierId(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_2
%%================================
getenc_internal_object_set_argument_2(Id) when Id =:= {2,5,4,3} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'enc_at-x520CommonName'(T,V,O) end;
getenc_internal_object_set_argument_2(Id) when Id =:= {2,5,4,4} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'enc_at-surname'(T,V,O) end;
getenc_internal_object_set_argument_2(Id) when Id =:= {2,5,4,5} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'enc_at-x520SerialNumber'(T,V,O) end;
getenc_internal_object_set_argument_2(Id) when Id =:= {2,5,4,6} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'enc_at-x520countryName'(T,V,O) end;
getenc_internal_object_set_argument_2(Id) when Id =:= {2,5,4,7} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'enc_at-x520LocalityName'(T,V,O) end;
getenc_internal_object_set_argument_2(Id) when Id =:= {2,5,4,8} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'enc_at-x520StateOrProvinceName'(T,V,O) end;
getenc_internal_object_set_argument_2(Id) when Id =:= {2,5,4,10} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'enc_at-x520OrganizationName'(T,V,O) end;
getenc_internal_object_set_argument_2(Id) when Id =:= {2,5,4,11} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'enc_at-x520OrganizationalUnitName'(T,V,O) end;
getenc_internal_object_set_argument_2(Id) when Id =:= {2,5,4,12} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'enc_at-x520Title'(T,V,O) end;
getenc_internal_object_set_argument_2(Id) when Id =:= {2,5,4,41} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'enc_at-name'(T,V,O) end;
getenc_internal_object_set_argument_2(Id) when Id =:= {2,5,4,42} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'enc_at-givenName'(T,V,O) end;
getenc_internal_object_set_argument_2(Id) when Id =:= {2,5,4,43} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'enc_at-initials'(T,V,O) end;
getenc_internal_object_set_argument_2(Id) when Id =:= {2,5,4,44} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'enc_at-generationQualifier'(T,V,O) end;
getenc_internal_object_set_argument_2(Id) when Id =:= {2,5,4,46} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'enc_at-x520dnQualifier'(T,V,O) end;
getenc_internal_object_set_argument_2(Id) when Id =:= {2,5,4,65} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'enc_at-x520Pseudonym'(T,V,O) end;
getenc_internal_object_set_argument_2(Id) when Id =:= {0,9,2342,19200300,100,1,25} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'enc_at-domainComponent'(T,V,O) end;
getenc_internal_object_set_argument_2(Id) when Id =:= {1,2,840,113549,1,9,1} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'enc_at-emailAddress'(T,V,O) end;
getenc_internal_object_set_argument_2(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_2(Id) when Id =:= {2,5,4,3} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'dec_at-x520CommonName'(T,V,O) end;
getdec_internal_object_set_argument_2(Id) when Id =:= {2,5,4,4} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'dec_at-surname'(T,V,O) end;
getdec_internal_object_set_argument_2(Id) when Id =:= {2,5,4,5} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'dec_at-x520SerialNumber'(T,V,O) end;
getdec_internal_object_set_argument_2(Id) when Id =:= {2,5,4,6} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'dec_at-x520countryName'(T,V,O) end;
getdec_internal_object_set_argument_2(Id) when Id =:= {2,5,4,7} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'dec_at-x520LocalityName'(T,V,O) end;
getdec_internal_object_set_argument_2(Id) when Id =:= {2,5,4,8} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'dec_at-x520StateOrProvinceName'(T,V,O) end;
getdec_internal_object_set_argument_2(Id) when Id =:= {2,5,4,10} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'dec_at-x520OrganizationName'(T,V,O) end;
getdec_internal_object_set_argument_2(Id) when Id =:= {2,5,4,11} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'dec_at-x520OrganizationalUnitName'(T,V,O) end;
getdec_internal_object_set_argument_2(Id) when Id =:= {2,5,4,12} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'dec_at-x520Title'(T,V,O) end;
getdec_internal_object_set_argument_2(Id) when Id =:= {2,5,4,41} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'dec_at-name'(T,V,O) end;
getdec_internal_object_set_argument_2(Id) when Id =:= {2,5,4,42} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'dec_at-givenName'(T,V,O) end;
getdec_internal_object_set_argument_2(Id) when Id =:= {2,5,4,43} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'dec_at-initials'(T,V,O) end;
getdec_internal_object_set_argument_2(Id) when Id =:= {2,5,4,44} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'dec_at-generationQualifier'(T,V,O) end;
getdec_internal_object_set_argument_2(Id) when Id =:= {2,5,4,46} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'dec_at-x520dnQualifier'(T,V,O) end;
getdec_internal_object_set_argument_2(Id) when Id =:= {2,5,4,65} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'dec_at-x520Pseudonym'(T,V,O) end;
getdec_internal_object_set_argument_2(Id) when Id =:= {0,9,2342,19200300,100,1,25} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'dec_at-domainComponent'(T,V,O) end;
getdec_internal_object_set_argument_2(Id) when Id =:= {1,2,840,113549,1,9,1} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'dec_at-emailAddress'(T,V,O) end;
getdec_internal_object_set_argument_2(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.



%%%
%%% Run-time functions.
%%%

'dialyzer-suppressions'(Arg) ->
    ok.

is_default_1(asn1_DEFAULT) ->
true;
is_default_1(Def) when Def =:= false ->
true;
is_default_1(_) ->
false.


is_default_2(asn1_DEFAULT) ->
true;
is_default_2(Def) when Def =:= 0 ->
true;
is_default_2(_) ->
false.


is_default_3(asn1_DEFAULT) ->
true;
is_default_3(Def) when Def =:= false ->
true;
is_default_3(_) ->
false.


is_default_4(asn1_DEFAULT) ->
true;
is_default_4(Def) when Def =:= false ->
true;
is_default_4(_) ->
false.


is_default_5(asn1_DEFAULT) ->
true;
is_default_5(Def) when Def =:= false ->
true;
is_default_5(_) ->
false.


is_default_6(asn1_DEFAULT) ->
true;
is_default_6(Def) when Def =:= false ->
true;
is_default_6(_) ->
false.


ber_decode_nif(B) ->
    asn1rt_nif:decode_ber_tlv(B).

ber_encode([Tlv]) ->
    ber_encode(Tlv);
ber_encode(Tlv) when is_binary(Tlv) ->
    Tlv;
ber_encode(Tlv) ->
    asn1rt_nif:encode_ber_tlv(Tlv).

collect_parts(TlvList) ->
    collect_parts(TlvList, []).

collect_parts([{_, L} | Rest], Acc) when is_list(L) ->
    collect_parts(Rest, [collect_parts(L) | Acc]);
collect_parts([{3, <<Unused,Bits/binary>>} | Rest], _Acc) ->
    collect_parts_bit(Rest, [Bits], Unused);
collect_parts([{_T, V} | Rest], Acc) ->
    collect_parts(Rest, [V | Acc]);
collect_parts([], Acc) ->
    list_to_binary(lists:reverse(Acc)).

collect_parts_bit([{3, <<Unused,Bits/binary>>} | Rest], Acc, Uacc) ->
    collect_parts_bit(Rest, [Bits | Acc], Unused + Uacc);
collect_parts_bit([], Acc, Uacc) ->
    list_to_binary([Uacc | lists:reverse(Acc)]).

dec_subidentifiers(<<>>, _Av, Al) ->
    lists:reverse(Al);
dec_subidentifiers(<<1:1,H:7,T/binary>>, Av, Al) ->
    dec_subidentifiers(T, Av bsl 7 + H, Al);
dec_subidentifiers(<<H,T/binary>>, Av, Al) ->
    dec_subidentifiers(T, 0, [Av bsl 7 + H | Al]).

decode_BMP_string(Buffer, Tags) ->
    Bin = match_and_collect(Buffer, Tags),
    mk_BMP_string(binary_to_list(Bin)).

decode_UTF8_string(Tlv, TagsIn) ->
    Val = match_tags(Tlv, TagsIn),
    case Val of
        [_ | _] = PartList ->
            collect_parts(PartList);
        Bin ->
            Bin
    end.

decode_bitstring2(1, Unused,
                  <<B7:1,B6:1,B5:1,B4:1,B3:1,B2:1,B1:1,B0:1,_/binary>>) ->
    lists:sublist([B7, B6, B5, B4, B3, B2, B1, B0], 8 - Unused);
decode_bitstring2(Len, Unused,
                  <<B7:1,
                    B6:1,
                    B5:1,
                    B4:1,
                    B3:1,
                    B2:1,
                    B1:1,
                    B0:1,
                    Buffer/binary>>) ->
    [B7, B6, B5, B4, B3, B2, B1, B0 |
     decode_bitstring2(Len - 1, Unused, Buffer)].

decode_bitstring_NNL(BitList, NamedNumberList) ->
    decode_bitstring_NNL(BitList, NamedNumberList, 0, []).

decode_bitstring_NNL([], _, _No, Result) ->
    lists:reverse(Result);
decode_bitstring_NNL([B | BitList],
                     [{Name, No} | NamedNumberList],
                     No, Result) ->
    if
        B =:= 0 ->
            decode_bitstring_NNL(BitList, NamedNumberList,
                                 No + 1,
                                 Result);
        true ->
            decode_bitstring_NNL(BitList, NamedNumberList,
                                 No + 1,
                                 [Name | Result])
    end;
decode_bitstring_NNL([1 | BitList], NamedNumberList, No, Result) ->
    decode_bitstring_NNL(BitList, NamedNumberList,
                         No + 1,
                         [{bit, No} | Result]);
decode_bitstring_NNL([0 | BitList], NamedNumberList, No, Result) ->
    decode_bitstring_NNL(BitList, NamedNumberList, No + 1, Result).

decode_boolean(Tlv, TagIn) ->
    Val = match_tags(Tlv, TagIn),
    case Val of
        <<0:8>> ->
            false;
        <<_:8>> ->
            true;
        _ ->
            exit({error, {asn1, {decode_boolean, Val}}})
    end.

decode_integer(Tlv, TagIn) ->
    Bin = match_tags(Tlv, TagIn),
    Len = byte_size(Bin),
    <<Int:Len/signed-unit:8>> = Bin,
    Int.

decode_named_bit_string(Buffer, NamedNumberList, Tags) ->
    case match_and_collect(Buffer, Tags) of
        <<0>> ->
            [];
        <<Unused,Bits/binary>> ->
            BitString = decode_bitstring2(byte_size(Bits), Unused, Bits),
            decode_bitstring_NNL(BitString, NamedNumberList)
    end.

decode_object_identifier(Tlv, Tags) ->
    Val = match_tags(Tlv, Tags),
    [AddedObjVal | ObjVals] = dec_subidentifiers(Val, 0, []),
    {Val1, Val2} =
        if
            AddedObjVal < 40 ->
                {0, AddedObjVal};
            AddedObjVal < 80 ->
                {1, AddedObjVal - 40};
            true ->
                {2, AddedObjVal - 80}
        end,
    list_to_tuple([Val1, Val2 | ObjVals]).

decode_octet_string(Tlv, TagsIn) ->
    Bin = match_and_collect(Tlv, TagsIn),
    binary:copy(Bin).

decode_open_type(Tlv, TagIn) ->
    case match_tags(Tlv, TagIn) of
        Bin when is_binary(Bin) ->
            {InnerTlv, _} = ber_decode_nif(Bin),
            InnerTlv;
        TlvBytes ->
            TlvBytes
    end.

decode_open_type_as_binary(Tlv, TagIn) ->
    ber_encode(match_tags(Tlv, TagIn)).

decode_restricted_string(Tlv, TagsIn) ->
    match_and_collect(Tlv, TagsIn).

decode_universal_string(Buffer, Tags) ->
    Bin = match_and_collect(Buffer, Tags),
    mk_universal_string(binary_to_list(Bin)).

do_encode_named_bit_string([FirstVal | RestVal], NamedBitList, TagIn) ->
    ToSetPos = get_all_bitposes([FirstVal | RestVal], NamedBitList, []),
    Size = lists:max(ToSetPos) + 1,
    BitList = make_and_set_list(Size, ToSetPos, 0),
    {Len, Unused, OctetList} = encode_bitstring(BitList),
    encode_tags(TagIn, [Unused | OctetList], Len + 1).

dynamicsort_SETOF(ListOfEncVal) ->
    BinL =
        lists:map(fun(L) when is_list(L) ->
                         list_to_binary(L);
                     (B) ->
                         B
                  end,
                  ListOfEncVal),
    lists:sort(BinL).

e_object_identifier({'OBJECT IDENTIFIER', V}) ->
    e_object_identifier(V);
e_object_identifier(V) when is_tuple(V) ->
    e_object_identifier(tuple_to_list(V));
e_object_identifier([E1, E2 | Tail]) ->
    Head = 40 * E1 + E2,
    {H, Lh} = mk_object_val(Head),
    {R, Lr} = lists:mapfoldl(fun enc_obj_id_tail/2, 0, Tail),
    {[H | R], Lh + Lr}.

enc_obj_id_tail(H, Len) ->
    {B, L} = mk_object_val(H),
    {B, Len + L}.

encode_BMP_string(BMPString, TagIn) ->
    OctetList = mk_BMP_list(BMPString),
    encode_tags(TagIn, OctetList, length(OctetList)).

encode_UTF8_string(UTF8String, TagIn) when is_binary(UTF8String) ->
    encode_tags(TagIn, UTF8String, byte_size(UTF8String));
encode_UTF8_string(UTF8String, TagIn) ->
    encode_tags(TagIn, UTF8String, length(UTF8String)).

encode_bitstring([B8, B7, B6, B5, B4, B3, B2, B1 | Rest]) ->
    Val =
        B8 bsl 7 bor (B7 bsl 6) bor (B6 bsl 5) bor (B5 bsl 4)
        bor
        (B4 bsl 3)
        bor
        (B3 bsl 2)
        bor
        (B2 bsl 1)
        bor
        B1,
    encode_bitstring(Rest, [Val], 1);
encode_bitstring(Val) ->
    {Unused, Octet} = unused_bitlist(Val, 7, 0),
    {1, Unused, [Octet]}.

encode_bitstring([B8, B7, B6, B5, B4, B3, B2, B1 | Rest], Ack, Len) ->
    Val =
        B8 bsl 7 bor (B7 bsl 6) bor (B6 bsl 5) bor (B5 bsl 4)
        bor
        (B4 bsl 3)
        bor
        (B3 bsl 2)
        bor
        (B2 bsl 1)
        bor
        B1,
    encode_bitstring(Rest, [Ack, Val], Len + 1);
encode_bitstring([], Ack, Len) ->
    {Len, 0, Ack};
encode_bitstring(Rest, Ack, Len) ->
    {Unused, Val} = unused_bitlist(Rest, 7, 0),
    {Len + 1, Unused, [Ack, Val]}.

encode_boolean(true, TagIn) ->
    encode_tags(TagIn, [255], 1);
encode_boolean(false, TagIn) ->
    encode_tags(TagIn, [0], 1);
encode_boolean(X, _) ->
    exit({error, {asn1, {encode_boolean, X}}}).

encode_integer(Val) ->
    Bytes =
        if
            Val >= 0 ->
                encode_integer_pos(Val, []);
            true ->
                encode_integer_neg(Val, [])
        end,
    {Bytes, length(Bytes)}.

encode_integer(Val, Tag) when is_integer(Val) ->
    encode_tags(Tag, encode_integer(Val));
encode_integer(Val, _Tag) ->
    exit({error, {asn1, {encode_integer, Val}}}).

encode_integer_neg(-1, [B1 | _T] = L) when B1 > 127 ->
    L;
encode_integer_neg(N, Acc) ->
    encode_integer_neg(N bsr 8, [N band 255 | Acc]).

encode_integer_pos(0, [B | _Acc] = L) when B < 128 ->
    L;
encode_integer_pos(N, Acc) ->
    encode_integer_pos(N bsr 8, [N band 255 | Acc]).

encode_length(L) when L =< 127 ->
    {[L], 1};
encode_length(L) ->
    Oct = minimum_octets(L),
    Len = length(Oct),
    if
        Len =< 126 ->
            {[128 bor Len | Oct], Len + 1};
        true ->
            exit({error, {asn1, too_long_length_oct, Len}})
    end.

encode_named_bit_string([H | _] = Bits, NamedBitList, TagIn)
    when is_atom(H) ->
    do_encode_named_bit_string(Bits, NamedBitList, TagIn);
encode_named_bit_string([{bit, _} | _] = Bits, NamedBitList, TagIn) ->
    do_encode_named_bit_string(Bits, NamedBitList, TagIn);
encode_named_bit_string([], _NamedBitList, TagIn) ->
    encode_unnamed_bit_string(<<>>, TagIn);
encode_named_bit_string(Bits, _NamedBitList, TagIn)
    when is_bitstring(Bits) ->
    encode_unnamed_bit_string(Bits, TagIn).

encode_object_identifier(Val, TagIn) ->
    encode_tags(TagIn, e_object_identifier(Val)).

encode_open_type(Val, T) when is_list(Val) ->
    encode_open_type(list_to_binary(Val), T);
encode_open_type(Val, Tag) ->
    encode_tags(Tag, Val, byte_size(Val)).

encode_restricted_string(OctetList, TagIn) when is_binary(OctetList) ->
    encode_tags(TagIn, OctetList, byte_size(OctetList));
encode_restricted_string(OctetList, TagIn) when is_list(OctetList) ->
    encode_tags(TagIn, OctetList, length(OctetList)).

encode_tags(TagIn, {BytesSoFar, LenSoFar}) ->
    encode_tags(TagIn, BytesSoFar, LenSoFar).

encode_tags([Tag | Trest], BytesSoFar, LenSoFar) ->
    {Bytes2, L2} = encode_length(LenSoFar),
    encode_tags(Trest,
                [Tag, Bytes2 | BytesSoFar],
                LenSoFar + byte_size(Tag) + L2);
encode_tags([], BytesSoFar, LenSoFar) ->
    {BytesSoFar, LenSoFar}.

encode_universal_string(Universal, TagIn) ->
    OctetList = mk_uni_list(Universal),
    encode_tags(TagIn, OctetList, length(OctetList)).

encode_unnamed_bit_string(Bits, TagIn) ->
    Unused = (8 - bit_size(Bits) band 7) band 7,
    Bin = <<Unused,Bits/bitstring,0:Unused>>,
    encode_tags(TagIn, Bin, byte_size(Bin)).

get_all_bitposes([{bit, ValPos} | Rest], NamedBitList, Ack) ->
    get_all_bitposes(Rest, NamedBitList, [ValPos | Ack]);
get_all_bitposes([Val | Rest], NamedBitList, Ack) when is_atom(Val) ->
    case lists:keyfind(Val, 1, NamedBitList) of
        {_ValName, ValPos} ->
            get_all_bitposes(Rest, NamedBitList, [ValPos | Ack]);
        _ ->
            exit({error, {asn1, {bitstring_namedbit, Val}}})
    end;
get_all_bitposes([], _NamedBitList, Ack) ->
    lists:sort(Ack).

make_and_set_list(0, [], _) ->
    [];
make_and_set_list(0, _, _) ->
    exit({error, {asn1, bitstring_sizeconstraint}});
make_and_set_list(Len, [XPos | SetPos], XPos) ->
    [1 | make_and_set_list(Len - 1, SetPos, XPos + 1)];
make_and_set_list(Len, [Pos | SetPos], XPos) ->
    [0 | make_and_set_list(Len - 1, [Pos | SetPos], XPos + 1)];
make_and_set_list(Len, [], XPos) ->
    [0 | make_and_set_list(Len - 1, [], XPos + 1)].

match_and_collect(Tlv, TagsIn) ->
    Val = match_tags(Tlv, TagsIn),
    case Val of
        [_ | _] = PartList ->
            collect_parts(PartList);
        Bin when is_binary(Bin) ->
            Bin
    end.

match_tags({T, V}, [T]) ->
    V;
match_tags({T, V}, [T | Tt]) ->
    match_tags(V, Tt);
match_tags([{T, V}], [T | Tt]) ->
    match_tags(V, Tt);
match_tags([{T, _V} | _] = Vlist, [T]) ->
    Vlist;
match_tags(Tlv, []) ->
    Tlv;
match_tags({Tag, _V} = Tlv, [T | _Tt]) ->
    exit({error, {asn1, {wrong_tag, {{expected, T}, {got, Tag, Tlv}}}}}).

minimum_octets(0, Acc) ->
    Acc;
minimum_octets(Val, Acc) ->
    minimum_octets(Val bsr 8, [Val band 255 | Acc]).

minimum_octets(Val) ->
    minimum_octets(Val, []).

mk_BMP_list(In) ->
    mk_BMP_list(In, []).

mk_BMP_list([], List) ->
    lists:reverse(List);
mk_BMP_list([{0, 0, C, D} | T], List) ->
    mk_BMP_list(T, [D, C | List]);
mk_BMP_list([H | T], List) ->
    mk_BMP_list(T, [H, 0 | List]).

mk_BMP_string(In) ->
    mk_BMP_string(In, []).

mk_BMP_string([], US) ->
    lists:reverse(US);
mk_BMP_string([0, B | T], US) ->
    mk_BMP_string(T, [B | US]);
mk_BMP_string([C, D | T], US) ->
    mk_BMP_string(T, [{0, 0, C, D} | US]).

mk_object_val(0, Ack, Len) ->
    {Ack, Len};
mk_object_val(Val, Ack, Len) ->
    mk_object_val(Val bsr 7, [Val band 127 bor 128 | Ack], Len + 1).

mk_object_val(Val) when Val =< 127 ->
    {[255 band Val], 1};
mk_object_val(Val) ->
    mk_object_val(Val bsr 7, [Val band 127], 1).

mk_uni_list(In) ->
    mk_uni_list(In, []).

mk_uni_list([], List) ->
    lists:reverse(List);
mk_uni_list([{A, B, C, D} | T], List) ->
    mk_uni_list(T, [D, C, B, A | List]);
mk_uni_list([H | T], List) ->
    mk_uni_list(T, [H, 0, 0, 0 | List]).

mk_universal_string(In) ->
    mk_universal_string(In, []).

mk_universal_string([], Acc) ->
    lists:reverse(Acc);
mk_universal_string([0, 0, 0, D | T], Acc) ->
    mk_universal_string(T, [D | Acc]);
mk_universal_string([A, B, C, D | T], Acc) ->
    mk_universal_string(T, [{A, B, C, D} | Acc]).

unused_bitlist([], Trail, Ack) ->
    {Trail + 1, Ack};
unused_bitlist([Bit | Rest], Trail, Ack) ->
    unused_bitlist(Rest, Trail - 1, Bit bsl Trail bor Ack).
