/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.ui;

import java.awt.AWTEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import org.freeplane.core.util.Compat;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.text.DetailModel;
import org.freeplane.features.text.TextController;
import org.freeplane.features.text.mindmapmode.MTextController;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.ZoomableLabel;
import org.freeplane.view.swing.ui.LinkNavigatorMouseListener;
import org.freeplane.view.swing.ui.NodePopupMenuDisplayer;
import org.freeplane.view.swing.ui.NodeSelector;

public class DetailsViewMouseListener
extends LinkNavigatorMouseListener {
    protected final NodeSelector nodeSelector = new NodeSelector();

    @Override
    public void mouseClicked(MouseEvent e) {
        JPopupMenu popupmenu;
        NodeView nodeView = this.nodeSelector.getRelatedNodeView(e);
        if (nodeView == null || !nodeView.getMap().isSelected()) {
            return;
        }
        ModeController mc = nodeView.getMap().getModeController();
        if (Compat.isMacOsX() && (popupmenu = mc.getUserInputListenerFactory().getNodePopupMenu()).isShowing()) {
            return;
        }
        NodeModel model = nodeView.getNode();
        TextController controller = mc.getExtension(TextController.class);
        if (this.eventFromHideDisplayArea(e)) {
            IMapSelection selection = Controller.getCurrentController().getSelection();
            selection.preserveRootNodeLocationOnScreen();
            controller.setDetailsHidden(model, !DetailModel.getDetail(model).isHidden());
        } else {
            this.nodeSelector.extendSelection(e, false);
            if (mc.canEdit(model.getMap()) && this.canEdit(controller) && this.isEditingStartEvent(e)) {
                boolean editLong = e.isAltDown();
                if (!editLong) {
                    ((MTextController)controller).getEventQueue().activate((AWTEvent)e);
                }
                ((MTextController)controller).editDetails(model, (InputEvent)e, editLong);
            } else {
                super.mouseClicked(e);
            }
        }
    }

    protected boolean eventFromHideDisplayArea(MouseEvent e) {
        ZoomableLabel component = (ZoomableLabel)e.getComponent();
        return e.getX() < component.getZoomedIconWidth();
    }

    private boolean canEdit(TextController controller) {
        return controller.canEdit();
    }

    private boolean isEditingStartEvent(MouseEvent e) {
        return e.getClickCount() == 2;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        new NodePopupMenuDisplayer().showNodePopupMenu(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        new NodePopupMenuDisplayer().showNodePopupMenu(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        super.mouseMoved(e);
        if (!this.eventFromHideDisplayArea(e) && this.nodeSelector.isRelevant(e)) {
            this.nodeSelector.createTimer(e, false);
        } else {
            this.nodeSelector.stopTimerForDelayedSelection();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.nodeSelector.stopTimerForDelayedSelection();
        this.nodeSelector.selectSingleNode(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (!this.eventFromHideDisplayArea(e) && this.nodeSelector.isRelevant(e)) {
            this.mouseMoved(e);
        } else {
            this.nodeSelector.stopTimerForDelayedSelection();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.nodeSelector.stopTimerForDelayedSelection();
        this.nodeSelector.trackWindowForComponent(e.getComponent());
    }
}

