**Note:** This file is automatically generated. Please see the [developer
documentation](doc/development/changelog.md) for instructions on adding your own
entry.

## 18.0.1 (2025-05-21)

### Fixed (1 change)

- [Apply Rails 7-1-stable patches to fix type map init issues](https://gitlab.com/gitlab-org/security/gitlab/-/commit/883fb9273c7cd961249d5dbe6bee4df76d704aaf)

### Changed (1 change)

- [Add outbound allowlist to allowed endpoints for SSRF filter](https://gitlab.com/gitlab-org/security/gitlab/-/commit/f64186f3e141c6ca8485b451cb1e264364beaa7a) **GitLab Enterprise Edition**

### Security (10 changes)

- [Use CI::VariableValue in BasicEntity to prevent exposing hidden values in collapsible UI element](https://gitlab.com/gitlab-org/security/gitlab/-/commit/75c84787120ca99c5e385d566207a1b1e5aa3bd1) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5021))
- [Show full path of project in create MR dropdown](https://gitlab.com/gitlab-org/security/gitlab/-/commit/2a2faab0bbb53af58aaf76725f9afb1a732c4349) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5002))
- [Remove trace field as it is already added in the interface](https://gitlab.com/gitlab-org/security/gitlab/-/commit/95cf66aa590556b28884371332175a28c8a934fd) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5004))
- [Security 479168 discord zip vulnerability](https://gitlab.com/gitlab-org/security/gitlab/-/commit/766fab2ac7e498efda2561ee15a68e59af83e633) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5018))
- [Limit length of certificate cluster text fields](https://gitlab.com/gitlab-org/security/gitlab/-/commit/5f61b3d9430ff69c0a69032485c1e8065c7ef1b6) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4999))
- [Check rate limit for over-sized blobs](https://gitlab.com/gitlab-org/security/gitlab/-/commit/b920b5eb587da918a3925cfcc2c16217ee12b79c) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5008))
- [Added size constraint validation to notes position fields](https://gitlab.com/gitlab-org/security/gitlab/-/commit/08ea9082a91765c13c2b63b3161dcd4185a24af2) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5005))
- [Obfuscate emails in note.bodyFirstLineHtml](https://gitlab.com/gitlab-org/security/gitlab/-/commit/eaf7702da8bab8041f84d5a24742576342ba2ecc) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5003))
- [Need to update 2fa requirement after accepting request](https://gitlab.com/gitlab-org/security/gitlab/-/commit/dd5abda5785fd824b7056513695a3a17d7555697) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4997))
- [Ensure SAML authn context comes from signed portion of SAML response](https://gitlab.com/gitlab-org/security/gitlab/-/commit/c641624daf734ee6f61adac4a0cc898b894590af) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/5010))

## 18.0.0 (2025-05-14)

### Added (177 changes)

- [Backfill vulnerabilities ES index](https://gitlab.com/gitlab-org/gitlab/-/commit/0acf9feff050cb66162ae531c01e8effcbf3ed4e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184819)) **GitLab Enterprise Edition**
- [Add markdown rendering to code quality issue name](https://gitlab.com/gitlab-org/gitlab/-/commit/3eb9b9b62112c2584224988fd2b79cd623266564) by @django1194 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185717))
- [Adding api for listing project requirement statuses](https://gitlab.com/gitlab-org/gitlab/-/commit/48f54c07e47af5087ee958cd61b680e019aa7803) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186260)) **GitLab Enterprise Edition**
- [Add archive column and event handler for project analyzer status](https://gitlab.com/gitlab-org/gitlab/-/commit/c9b7bc92779e08d3316db97d0309552816431e35) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189665)) **GitLab Enterprise Edition**
- [Prepare async FK for p_ci_pipelines.trigger_id](https://gitlab.com/gitlab-org/gitlab/-/commit/242e119fc1bd0130e68ff16085531106820e10e8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189738))
- [Update table_size database dictionary entries](https://gitlab.com/gitlab-org/gitlab/-/commit/99ece00ff019d2eb2ec30bba53c01d84315214e5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190938))
- [Update model validation to new value constraint](https://gitlab.com/gitlab-org/gitlab/-/commit/d086741e5e8e07c6382b7f2d54ff4ce9133a67af) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190830)) **GitLab Enterprise Edition**
- [Add wiki endpoints to notes REST API](https://gitlab.com/gitlab-org/gitlab/-/commit/aa66ccc1bc339fc7fe3d385f99bab204de8647c5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182483))
- [Remove `duo_code_review_system_note` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/bdbbcfeb59db74ff31df1a9fa64c87d0dd03908c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190704))
- [Add last updated information to Compliance Frameworks table](https://gitlab.com/gitlab-org/gitlab/-/commit/3fcf92a0a628cc0ca864d181e78ba021dd6c1b11) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190668)) **GitLab Enterprise Edition**
- [Add configurable cookie salts](https://gitlab.com/gitlab-org/gitlab/-/commit/c99bb3013db0bbcf469ca2f3c99579dba60df1b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190350))
- [Backfill instance integrations organization_id](https://gitlab.com/gitlab-org/gitlab/-/commit/2d81a9f6cb1416ce8620794b748f5edb74990f2a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189808))
- [Enable duo_code_review_full_file feature flag by default](https://gitlab.com/gitlab-org/gitlab/-/commit/73f5266f9011fa7aeb5ec1e85659afc9765ad9b5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190579)) **GitLab Enterprise Edition**
- [Enable duo_code_review_multi_file feature flag by default](https://gitlab.com/gitlab-org/gitlab/-/commit/f808fc54b373d19ef538e0860f4c28afa689ee26) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190577)) **GitLab Enterprise Edition**
- [Hide Duo availability for Duo Core only scenarios](https://gitlab.com/gitlab-org/gitlab/-/commit/62fdb407dabf2167124cf97afb4f4e473d0d6aa7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190411)) **GitLab Enterprise Edition**
- [Delete old routing docs from Vulnerability Index on Project transfer](https://gitlab.com/gitlab-org/gitlab/-/commit/d1ae078cfe56ca7b1163fdda0bd7d8135b5593f1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190083)) **GitLab Enterprise Edition**
- [Add updated_at to ComplianceFrameworkType](https://gitlab.com/gitlab-org/gitlab/-/commit/e5922e1209b06b3c0533e30e8743c99db206c0bc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190655)) **GitLab Enterprise Edition**
- [Add reusable TokenValidityBadge component](https://gitlab.com/gitlab-org/gitlab/-/commit/0d11b7c8428f916e0a15641fd39c54a1a23d5185) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190538)) **GitLab Enterprise Edition**
- [Sticky headers: Add translucent glass style](https://gitlab.com/gitlab-org/gitlab/-/commit/65d82b3d8edf66893d2b767ed9c17c2d7a36132e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190203))
- [Add project delete event worker for vulnerability namespace statistics](https://gitlab.com/gitlab-org/gitlab/-/commit/4b8482764e24d915526ac8e76ece16e27f2cd694) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188778)) **GitLab Enterprise Edition**
- [Add messaging to redirect users to Branch rules section](https://gitlab.com/gitlab-org/gitlab/-/commit/e34bb1c658f83628c03c5b96ce9a15b99aa3e05f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189974))
- [Enable enhanced bulk actions and related vulnerabilities by default](https://gitlab.com/gitlab-org/gitlab/-/commit/a2e30ed58a4c19eb11c141a232ddd7713d0c420f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190213)) **GitLab Enterprise Edition**
- [Add column for project web_based_commit_signing_enabled setting](https://gitlab.com/gitlab-org/gitlab/-/commit/0a58797c9cd1d44190b17fd4fd7e779182845356) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189184))
- [Remove job source feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/3e2b41894a9b6200681ead3bf2515f668c1245f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190563))
- [Allow session to expire after specific time](https://gitlab.com/gitlab-org/gitlab/-/commit/99ff290074b47316070dec7b43284c73d04d4b46) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190483))
- [Add is_team_member property to workflow API](https://gitlab.com/gitlab-org/gitlab/-/commit/2f3cbf9b972e0ba9abc12896ea5ee87cdec3d394) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190246)) **GitLab Enterprise Edition**
- [Vulnerability webhook events for Groups](https://gitlab.com/gitlab-org/gitlab/-/commit/4e3a92ff0fdb112d722a518d91b8b83179108781) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185569)) **GitLab Enterprise Edition**
- [Add group import histories controller](https://gitlab.com/gitlab-org/gitlab/-/commit/29ae0209420d04922708f1cb7860217257d7f4fe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187033))
- [Add Pages/Docusaurus project template](https://gitlab.com/gitlab-org/gitlab/-/commit/812cf972419790e4ddf02e588c1f25d5ab9b606e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189610))
- [Add event forwarder for Snowplow events](https://gitlab.com/gitlab-org/gitlab/-/commit/21c7083a57ff346e3cdb2bf40e0620c257ed142c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190332))
- [Add control for one approval on MRs](https://gitlab.com/gitlab-org/gitlab/-/commit/e6c6ac69de1db981f9bd54c04d5ba05417258ecd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188831)) **GitLab Enterprise Edition**
- [Enable CI-based analyzer event tracking](https://gitlab.com/gitlab-org/gitlab/-/commit/2370e80fb09d401ff684c950d20e48daac75788f) ([merge request](190101!)) **GitLab Enterprise Edition**
- [Adds the analyzer_project_statuses query](https://gitlab.com/gitlab-org/gitlab/-/commit/af3d57992ba4649ee54032a1a5241b867ce6777c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186529)) **GitLab Enterprise Edition**
- [Add columns for web_based_commit_signing_enabled setting](https://gitlab.com/gitlab-org/gitlab/-/commit/dfceabe1c951eb55a0f3d95fb5ec7e755b9ab397) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189144))
- [Add product usage data log](https://gitlab.com/gitlab-org/gitlab/-/commit/b53926cab7e8f3c436f1af0514f973dd627e56d6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187132))
- [Add `organization_id` validations to fork_networks](https://gitlab.com/gitlab-org/gitlab/-/commit/4a4a17bc4753a55bae537e712b9c151bf7944e36) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184826))
- [Add Duo Workflow action component](https://gitlab.com/gitlab-org/gitlab/-/commit/aa6e5fbcf9a2d170653a7509c634a1143968df8c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189522)) **GitLab Enterprise Edition**
- [Add table for Organizations::OrganizationUserAlias](https://gitlab.com/gitlab-org/gitlab/-/commit/d19c6508471985966168856180bcc3205537478d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189052))
- [The base implementation of the PDF Vulnerability Report](https://gitlab.com/gitlab-org/gitlab/-/commit/eba92b1f5ce53243a48d71220356de8208428c57) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185058)) **GitLab Enterprise Edition**
- [Release the routable tokens feature](https://gitlab.com/gitlab-org/gitlab/-/commit/087ffc24a56191e36e19fc3c491661ab01332e59) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190340))
- [Add migration to create hosted runner records](https://gitlab.com/gitlab-org/gitlab/-/commit/f84170a3303af5d6e0151e90abca8ab8e0a47c57) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183329)) **GitLab Enterprise Edition**
- [Allow ai_workflows token to create Merge Requests](https://gitlab.com/gitlab-org/gitlab/-/commit/3e8652269377f6386bf0da67c62acd3668284752) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189938))
- [Add arguments to filter board lists by status](https://gitlab.com/gitlab-org/gitlab/-/commit/2ebff2779135ddb73daba3363512eec465482094) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189406)) **GitLab Enterprise Edition**
- [Add `Reload` option to GLQL blocks](https://gitlab.com/gitlab-org/gitlab/-/commit/6ad3ff65fb074c4436aea92c3c990c3fb89dfc40) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190264))
- [Add more accurate cluster health states](https://gitlab.com/gitlab-org/gitlab/-/commit/0be05e0570d5258f30ab73ca09c52163594d706d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190216))
- [ActiveContext: use stored search embedding version during search](https://gitlab.com/gitlab-org/gitlab/-/commit/6a10fa4b4a1a8867d0b1c09867244d40b0f99df4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188549))
- [Add status to board list GraphQL API](https://gitlab.com/gitlab-org/gitlab/-/commit/cf3b79f6a59fc590d33eaece5b24895d02b73b6c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189400)) **GitLab Enterprise Edition**
- [Add auto_duo_code_review_enabled setting to REST API](https://gitlab.com/gitlab-org/gitlab/-/commit/247e0c1c64172c5fb4a24b8facc0fed975df4022) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188962)) **GitLab Enterprise Edition**
- [Add sync status, timestamps & error columns to ldap_admin_role_links](https://gitlab.com/gitlab-org/gitlab/-/commit/cce2109b538b9e76dcbdd42c2361a21035c00785) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189576))
- [Update table_size database dictionary entries](https://gitlab.com/gitlab-org/gitlab/-/commit/fb7b4e580e99edd82cf459c086ece4a26a8a2a3e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190159))
- [Add default variable configuration to new policy](https://gitlab.com/gitlab-org/gitlab/-/commit/f618be89bc034fb28691b223d0b38635f31d09df) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189767)) **GitLab Enterprise Edition**
- [Add update logic for Duo Core enablement for Self-Managed](https://gitlab.com/gitlab-org/gitlab/-/commit/0eb37d7afb554818772afd1f97fad3c12a8d805f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189774)) **GitLab Enterprise Edition**
- [Display missing Duo configs in info card](https://gitlab.com/gitlab-org/gitlab/-/commit/3bbaf34b65b90f97349a3b45c82cf0e2a5e0ebe8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189889)) **GitLab Enterprise Edition**
- [Add variables overwrite configuration](https://gitlab.com/gitlab-org/gitlab/-/commit/754c1b7060107a28790343c6e33f7d723a54576a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188591)) **GitLab Enterprise Edition**
- [Add author_email column to gpg_signatures table](https://gitlab.com/gitlab-org/gitlab/-/commit/28f2b7018dcfac3a9396819d0b378de675f72491) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189770))
- [Add LDAP badge & filter to the users page in admin area](https://gitlab.com/gitlab-org/gitlab/-/commit/b60a5f785632591ce9a2d2048ea0826629e6b02e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187105))
- [Add batched background migration to dpop column](https://gitlab.com/gitlab-org/gitlab/-/commit/4402c592a71517f4dbf0883e841bb39f3172fc19) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188396))
- [Introduce policy for creating immutable tag rules](https://gitlab.com/gitlab-org/gitlab/-/commit/d07f9ae0b7507500c5f3eb8e36e41d68f8248844) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188667))
- [Add ScheduleWithinWorker to schedule jobs with jitter](https://gitlab.com/gitlab-org/gitlab/-/commit/ab24516e7e8090b9c7f2d11422f21b3665c6a131) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189021))
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/bd9667799d2800b027f03604ee32b7180fd10ce4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189884))
- [Add syncing LDAP with admin roles to cron jobs](https://gitlab.com/gitlab-org/gitlab/-/commit/c794e91be1a551c2a49dc7e5f9c676cb18c6edd6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189809))
- [Set branch and pass in workflow_definition](https://gitlab.com/gitlab-org/gitlab/-/commit/205da58ae60cbd65e0d5f0440d5249fcd21b41d6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188198)) **GitLab Enterprise Edition**
- [Allow Organization agents when creating workspaces](https://gitlab.com/gitlab-org/gitlab/-/commit/2e6be56213f8a81e2514e2aa853ca8b20cf2d9cd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188260))
- [Remove limit_unique_project_downloads_per_namespace_user](https://gitlab.com/gitlab-org/gitlab/-/commit/44ae1deae9961efdae73772bfa9e5ddad051f781) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183101)) **GitLab Enterprise Edition**
- [Add default state and validation](https://gitlab.com/gitlab-org/gitlab/-/commit/b208d2d120f448bf27f6989998d5a93eb83a5ff9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189607)) **GitLab Enterprise Edition**
- [Add protected and immutable tag patterns to tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/4d914f4868c3d79eff538188844a76f00f3b5aba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188812))
- [Add copy permalink to repository overflow menu](https://gitlab.com/gitlab-org/gitlab/-/commit/e7cd462f9e8fdab98423978291857147df79e10f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189208))
- [Show work item status badge in child and linked items](https://gitlab.com/gitlab-org/gitlab/-/commit/156bbb1ce8acfa4da4bf00376ec510548512dfe2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187639)) **GitLab Enterprise Edition**
- [Adding order by attribute to project compliance statuses](https://gitlab.com/gitlab-org/gitlab/-/commit/b582b48da6cf63760aa420a3745af88798084d9f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188555)) **GitLab Enterprise Edition**
- [Add group transfer event handler for vulnerability_namespace_statistics](https://gitlab.com/gitlab-org/gitlab/-/commit/b919bf1e1b4b53abda82bd60b8111ce9efd91a89) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187742)) **GitLab Enterprise Edition**
- [Add classes for syncing ldap with custom admin roles](https://gitlab.com/gitlab-org/gitlab/-/commit/a2b9976abc34212c3b2c24f13a37356eb447a6d0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187526))
- [Add status argument to boardListCreate mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/069820472fdf6f391cc8a795d54139aa607ba70d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189575)) **GitLab Enterprise Edition**
- [Add internal event for dependency list version filtering](https://gitlab.com/gitlab-org/gitlab/-/commit/7b78f4b0f74d45b1587785d987e99a3659fc09dd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189356)) **GitLab Enterprise Edition**
- [Show detailed pod status](https://gitlab.com/gitlab-org/gitlab/-/commit/410c19127d85112749024d069fb74d66ecda8737) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189471))
- [Add get package files with revision](https://gitlab.com/gitlab-org/gitlab/-/commit/3f0594d47d476985332e17bf9fd42c16b5c0f049) by @mbo5be ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187850))
- [Auto enable Duo Core features setting when activating a new subscription](https://gitlab.com/gitlab-org/gitlab/-/commit/453874a4e8263f4f0df9327ed4a9d056eddc0147) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189302)) **GitLab Enterprise Edition**
- [Add support for showing Duo Workflow component](https://gitlab.com/gitlab-org/gitlab/-/commit/e8197c3411a81feb5be83da15199bea6f161f1ac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189412)) **GitLab Enterprise Edition**
- [Protected packages: NuGet package push protection](https://gitlab.com/gitlab-org/gitlab/-/commit/7a0f09c21f086b35a18b1650ebc2c2d8afa02194) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184059))
- [Add variable override option](https://gitlab.com/gitlab-org/gitlab/-/commit/0f2479c6c7b3dc0ab8c35f51972e155aaab7403b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188451)) **GitLab Enterprise Edition**
- [Add the admin setting to cache the zoekt result](https://gitlab.com/gitlab-org/gitlab/-/commit/a67bb4f0418bdcef5f8da8463698efdf810364fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189266)) **GitLab Enterprise Edition**
- [Add Vulnerability Reads Es finder](https://gitlab.com/gitlab-org/gitlab/-/commit/4f8b2aa9e3fac488013c26e0ff448114e259612a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188112)) **GitLab Enterprise Edition**
- [Allow links from work items to incidents](https://gitlab.com/gitlab-org/gitlab/-/commit/4c2beb6a13fc8b07815e2db387386d1cedb7db5b) by @vedant-jain03 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179152))
- [Update Semver_dialects to 3.7.0](https://gitlab.com/gitlab-org/gitlab/-/commit/8644fd1604f7fa7b801f1366b25e29e75f00f1c9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188903))
- [Removes the group_remove_dormant_members FF](https://gitlab.com/gitlab-org/gitlab/-/commit/5f26590a73b43b97bd6421568f77e0bac750cc60) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182577)) **GitLab Enterprise Edition**
- [Add silent-mode subscription activation error](https://gitlab.com/gitlab-org/gitlab/-/commit/789e46aa06de32087d86fdfe117ab8bc7bd3e0dd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189182)) **GitLab Enterprise Edition**
- [Remove duo_additional_context feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/9f7855164a1e128e3c507a7b88042dcc3b6e9eda) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189728)) **GitLab Enterprise Edition**
- [Add application settings to manage CI/CD partitions](https://gitlab.com/gitlab-org/gitlab/-/commit/90cc0aca2de721dd1267d53ab204d91c12beb619) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189131))
- [Add the ability fetch group level sbom component versions](https://gitlab.com/gitlab-org/gitlab/-/commit/84548c661e9c676b5dcb4dc94512329171b1da99) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184270)) **GitLab Enterprise Edition**
- [Add upgrade Duo Core card](https://gitlab.com/gitlab-org/gitlab/-/commit/616e892efba73f9418849c5f1c5c804ffaa2123c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189161)) **GitLab Enterprise Edition**
- [ActiveContext: use indexing_embedding_versions to generate embeddings](https://gitlab.com/gitlab-org/gitlab/-/commit/2917e41117d46f489ea81741687fb58780198a5f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188535))
- [Allow admin to update duo_nano_features_enabled Duo setting](https://gitlab.com/gitlab-org/gitlab/-/commit/1b50980b818d52599de87dfe18a4fe638a4e1120) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187565)) **GitLab Enterprise Edition**
- [Add Contributor count to project-level VSD lifecycle metrics table](https://gitlab.com/gitlab-org/gitlab/-/commit/2cf69dd44988783377629f73978b91662aac7815) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188905)) **GitLab Enterprise Edition**
- [Finalize BackfillArchivedAndTraversalIdsToVulnerabilityStatistics BBM](https://gitlab.com/gitlab-org/gitlab/-/commit/f434b124f9f2659869b730db3c4d17245921870c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186127))
- [Adapt Duo configuration info card for Duo Nano](https://gitlab.com/gitlab-org/gitlab/-/commit/63e0af81f3eec6b38817dc436b18db70510c6659) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188625)) **GitLab Enterprise Edition**
- [Remove duo_additional_context feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/22ea25f799e3145a674ea1823ff3c0bfa05689be) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188608)) **GitLab Enterprise Edition**
- [Deleting all compliance statuses for a project when moved](https://gitlab.com/gitlab-org/gitlab/-/commit/cbb7e02ea41833ee449fe382af05ec318d5737e5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188401)) **GitLab Enterprise Edition**
- [ActiveContext: add operation type upsert_only](https://gitlab.com/gitlab-org/gitlab/-/commit/b943e9370bac46bf149cdf34c24543abc7502fe0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188877))
- [ActiveContext: add migration for updating metadata on collection](https://gitlab.com/gitlab-org/gitlab/-/commit/1296205ef443e6fa0f35dba231e333093c4fbaa5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187724))
- [Add variable override option](https://gitlab.com/gitlab-org/gitlab/-/commit/8bd54e3c657b6ad76c3e94df55e58cb96a7f0999) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188190)) **GitLab Enterprise Edition**
- [Add `up` key shortcut behaviour on Work Items](https://gitlab.com/gitlab-org/gitlab/-/commit/d23299c1e9c87e10d44f27d48cb7f969e1c6960c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189067))
- [Release SAML Groups Duo Add On Assignment](https://gitlab.com/gitlab-org/gitlab/-/commit/0bdc298d3393b2ea6d45d7313781d47801af05f4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189231)) **GitLab Enterprise Edition**
- [Introduce GitLab Geo feedback banner](https://gitlab.com/gitlab-org/gitlab/-/commit/eeded6f6d97c20f2e941494d72faeb86b2281cbe) by @karras ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188378)) **GitLab Enterprise Edition**
- [Raise headers chars for audit event destinations](https://gitlab.com/gitlab-org/gitlab/-/commit/760a0f55d94504811bbb716263fd5cc0df90a398) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188797)) **GitLab Enterprise Edition**
- [Add the ability to filter by version for project](https://gitlab.com/gitlab-org/gitlab/-/commit/65f57b7811f5862f2650e312177b243fe4724f9c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188782)) **GitLab Enterprise Edition**
- [Relocate Duo self-hosted pages to Duo settings menu](https://gitlab.com/gitlab-org/gitlab/-/commit/04dec13cf226a3f0fd21fc47b9ef1539dbaa8c9b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188522)) **GitLab Enterprise Edition**
- [Enable dormant member limited capacity worker](https://gitlab.com/gitlab-org/gitlab/-/commit/ba0329f1fce5ae80cd47f74f3be1eb9ef9e98e8a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189128)) **GitLab Enterprise Edition**
- [Allows runner URLs to be fetched via a project connection](https://gitlab.com/gitlab-org/gitlab/-/commit/193085b5dd3264057266b9b49832c6a8b9d6c880) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189115))
- [Add `active` parameter to Groups REST API](https://gitlab.com/gitlab-org/gitlab/-/commit/0a0eff64bbbec56fd6d4e53b1b447b33658bc387) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186393))
- [Add optional parent_namespace_id to group delete event](https://gitlab.com/gitlab-org/gitlab/-/commit/8ea54bc9f5f4c6a8a2f4fe7ba2d2a8217ca64e10) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189089))
- [Expose "active" parameter to the Projects REST API](https://gitlab.com/gitlab-org/gitlab/-/commit/0c402a3ac3ad933d737e402b195f5d83ed2408c1) by @dagaranupam ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187416))
- [Display Last GitLab Duo Activity on Duo Seat Utilization Page](https://gitlab.com/gitlab-org/gitlab/-/commit/cd0aff42bbecffad914f3efd7ec90f288474aefd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188609)) **GitLab Enterprise Edition**
- [Add new code suggestions field to GraphQL aiMetrics](https://gitlab.com/gitlab-org/gitlab/-/commit/658ded9e285d641a51cec6b0b716c0bddae2ee88) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185844)) **GitLab Enterprise Edition**
- [Filter Non-Applicable Features from Premium Users in Duo Enterprise](https://gitlab.com/gitlab-org/gitlab/-/commit/e205653324bb611eae03d00fcda78c3d52b2af58) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189006)) **GitLab Enterprise Edition**
- [Remove vulnerability redetected note feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/14a90789b11da3edbe153e504f2059a89baeba89) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188998)) **GitLab Enterprise Edition**
- [Add status to legacy issues GraphQL API](https://gitlab.com/gitlab-org/gitlab/-/commit/0020fe5afe88e5ac2216d1b6ca51831c8c6cc7b4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188950)) **GitLab Enterprise Edition**
- [Add search to pipeline stage dropdown](https://gitlab.com/gitlab-org/gitlab/-/commit/bb5c441ac560cf883af9352454a01b9207b97f84) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187529))
- [Add group_setting jsonb column to app_settings](https://gitlab.com/gitlab-org/gitlab/-/commit/d4e675cbfd681914624e11664a62341b258079a6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187738)) **GitLab Enterprise Edition**
- [Add popover to parent widget link](https://gitlab.com/gitlab-org/gitlab/-/commit/ee77a86279ea4e2787111863499fe77c87fde2d9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187763))
- [Add auto_duo_code_review project setting](https://gitlab.com/gitlab-org/gitlab/-/commit/e10315dadbb09b4d838820bb5a044998a0f70002) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188069)) **GitLab Enterprise Edition**
- [Show `Create new emoji` within work items emoji picker](https://gitlab.com/gitlab-org/gitlab/-/commit/49375fc0858518e064bc624d8d83ef8725564818) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187200))
- [Add authenticate v2 endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/d551c0e1972a03a6d76c3509fa49302d4b7209e1) by @mbo5be ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187977))
- [Add latest package revision endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/b1642ce0b585d0fad6304c978f473da8e262967d) by @oceane_scania ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187678))
- [Create merge_request_commits_metadata table](https://gitlab.com/gitlab-org/gitlab/-/commit/779d322c3d6c5027365b1877a8287b777ad537e3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186556))
- [feat: Add admin API to revoke user support PIN](https://gitlab.com/gitlab-org/gitlab/-/commit/fab89872bc0fb1a1152f5ef8c48cf218b6807dbd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187657))
- [Add possibility to hide Duo Base from Duo frontend](https://gitlab.com/gitlab-org/gitlab/-/commit/3f93f09400da7178718aaf36cd06f4cde849ec57) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188414)) **GitLab Enterprise Edition**
- [Add support for deleting agent managed resources on environment stop](https://gitlab.com/gitlab-org/gitlab/-/commit/1b89c6f673e0df88e9dda09f019e2e60674ae5ad) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188024))
- [Add column build_id to analzyer_project_statuses table](https://gitlab.com/gitlab-org/gitlab/-/commit/f1ed69c67ee34fe02878e957535ef6bb4a61ebfc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187480))
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/3466d88833d521418d88a7bc796fc384746d9d47) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188762))
- [Update table_size database dictionary entries](https://gitlab.com/gitlab-org/gitlab/-/commit/bc279117cda8faab7df7204526e9bc378ddb734a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188748))
- [Release scheduled PEP feature as experiment](https://gitlab.com/gitlab-org/gitlab/-/commit/5a81dc1e1953bf16eee914339ba9d5394fc99a6e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187779)) **GitLab Enterprise Edition**
- [Initial commit to create vulnerabilities ES Index](https://gitlab.com/gitlab-org/gitlab/-/commit/cc6420d9e20a593d20faba1f9f3cd8023bd7f38e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185327)) **GitLab Enterprise Edition**
- [Create instance level compute visualization](https://gitlab.com/gitlab-org/gitlab/-/commit/3e4f91883aad570dc84e4171c370564760712f03) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180612))
- [Add Pages/Next.js project template](https://gitlab.com/gitlab-org/gitlab/-/commit/ba6023436ed6fde2796a13641c491e27ed65a680) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188669))
- [Add multiline paste support for custom fields](https://gitlab.com/gitlab-org/gitlab/-/commit/d4d399b8e530ceb73b6571ea497c30363ae3e975) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187970))
- [Add the ability to filter dependecines by version](https://gitlab.com/gitlab-org/gitlab/-/commit/18d9705187ee4166459dbb8a8bea08384e20c410) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188337)) **GitLab Enterprise Edition**
- [Add system note when a vulnerability is redetected](https://gitlab.com/gitlab-org/gitlab/-/commit/6ab0c48c904a1d03c2946833414350561f8e40d1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188156)) **GitLab Enterprise Edition**
- [Add support for Duo to GitLab Duo pages](https://gitlab.com/gitlab-org/gitlab/-/commit/e3f45279db9bc1e93cae8787bd418b781a07bbe1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188191)) **GitLab Enterprise Edition**
- [Add endpoint for deletion of all done todos](https://gitlab.com/gitlab-org/gitlab/-/commit/f29a31bda387e8f8758d787a43b018943bdc3a3f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184767))
- [Add REST API support for managing pipeline schedule inputs](https://gitlab.com/gitlab-org/gitlab/-/commit/a7c4df60395d079d54c064a58ae7ef1ee2edfba9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185389))
- [Allow LDAP users to authenticate by using their GitLab username](https://gitlab.com/gitlab-org/gitlab/-/commit/55bd866d2440aa6eb6f6d4af5c1ce02e88257638) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186848))
- [Follow-on Root Cause Analysis Hotspot experiment](https://gitlab.com/gitlab-org/gitlab/-/commit/b37ab87a64e2b4265ac96f8f218b1a24058a06d5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186914)) **GitLab Enterprise Edition**
- [Use duo_base_features_enabled as attribute instead](https://gitlab.com/gitlab-org/gitlab/-/commit/166c8c4417b62d53aba9396aec0fe79aee3a2874) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188290)) **GitLab Enterprise Edition**
- [Update TroubleshootJob executor to include ai tracking](https://gitlab.com/gitlab-org/gitlab/-/commit/43592eb686dd2395959eaf8a4e1e80f2fd36b2ac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187848)) **GitLab Enterprise Edition**
- [Allow to display Rapid Diffs on merge request creation page](https://gitlab.com/gitlab-org/gitlab/-/commit/6785d12068e83c777d6bf639cd0e870eab27cd35) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187955))
- [Add MR pipeline support to AST CI/CD templates](https://gitlab.com/gitlab-org/gitlab/-/commit/3b1f2e5dd999bb51684c0ebb01d565f7049f44e5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179652))
- [Remove importer_user_mapping_reassignment_csv feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/04af091b73d12ab94939bc2ea18c2543c6b0a5ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187170))
- [Allow batched background migrations to be listed by job name](https://gitlab.com/gitlab-org/gitlab/-/commit/31e0bb577662c7a7f4d565b2f2db8d8f0b833cd5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187413))
- [Support Premium licenses to use self-hosted AI models](https://gitlab.com/gitlab-org/gitlab/-/commit/bcb9b5aeda80f8ae01d32a64e67daf5bb4751870) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188263)) **GitLab Enterprise Edition**
- [Create Rake Task to Bulk Assign Duo Seats](https://gitlab.com/gitlab-org/gitlab/-/commit/43b62ac5f590e7fcaecded495b0c45a93ab8a0c7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187230)) **GitLab Enterprise Edition**
- [Add ability to trigger Duo Code Review automatically](https://gitlab.com/gitlab-org/gitlab/-/commit/896cdc462f9a756c0c7d1dd5f8c87eb34cf47c6c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187807)) **GitLab Enterprise Edition**
- [Add metrics for mrap package exceptions](https://gitlab.com/gitlab-org/gitlab/-/commit/c13453f8d1a76131dab6563ab2dc40f857cc0658) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187782)) **GitLab Enterprise Edition**
- [Enable Coverband UI](https://gitlab.com/gitlab-org/gitlab/-/commit/7ef4e0200655cf665645ac01fc64bb0ad50d3d12) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188364))
- [Add SaaS detection and Duo Workflow paths to admin settings](https://gitlab.com/gitlab-org/gitlab/-/commit/d67f0f207a664147bbaf8d40318af2a851a2d5ce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188265)) **GitLab Enterprise Edition**
- [Adds GraphQL queries for vulnerabilities](https://gitlab.com/gitlab-org/gitlab/-/commit/da54880f9721635a91264708e815070b16876de4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184633)) **GitLab Enterprise Edition**
- [Add sorting projects by full path](https://gitlab.com/gitlab-org/gitlab/-/commit/2a7f7122de57875e70be6d76ae270bb75ed0f48d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187174))
- [Add email prefix feature for gitlab emails](https://gitlab.com/gitlab-org/gitlab/-/commit/dc07d4577d35ed09b954a1225298c9c82d544ffd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184568))
- [Add support for aliases in GLQL](https://gitlab.com/gitlab-org/gitlab/-/commit/88ad392850ffb6962bfc87554c0ea7719d1e91c7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188073))
- [Add status widget to the sidebar of tasks](https://gitlab.com/gitlab-org/gitlab/-/commit/952f888a68cdaffd1a9d5cd304b4ac44f9d135d0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187818))
- [Sync Cloud Connector tokens hourly](https://gitlab.com/gitlab-org/gitlab/-/commit/a850c8edaa3cdef48a75afd353c62114515fecdf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188065)) **GitLab Enterprise Edition**
- [Add advanced vulnerability filters to es](https://gitlab.com/gitlab-org/gitlab/-/commit/cd9e68d8ae21a39e18ac0c7a45f2b0153c7d1ebf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187330)) **GitLab Enterprise Edition**
- [Allow titles to contain markdown](https://gitlab.com/gitlab-org/gitlab/-/commit/c6c600b3d523880fcadf5f3f7f784605da28eb90) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184070))
- [Add copy button to work item MR modal](https://gitlab.com/gitlab-org/gitlab/-/commit/32c03ee013a8b6d50501771560397dad4f26ebf7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187614))
- [Enable periodical_namespace_descendants... FF](https://gitlab.com/gitlab-org/gitlab/-/commit/73dedc746cc2f968f9d63461d0379a8289c766c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188042))
- [Use whitespace setting on Rapid Diffs page reload](https://gitlab.com/gitlab-org/gitlab/-/commit/9e31eca2f22cf9dbe29f95d71a0929852a3f9e67) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186430))
- [Update table_size database dictionary entries](https://gitlab.com/gitlab-org/gitlab/-/commit/4cdda7c4bb2ce757087e7c04b2f43978f8d5528d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188020))
- [Update table_size database dictionary entries](https://gitlab.com/gitlab-org/gitlab/-/commit/1b3aee797f8fc261ddfd5c407a6d73aa93458afa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188019))
- [Add IdP-scoped SAML group links](https://gitlab.com/gitlab-org/gitlab/-/commit/020ee341c185a4fca9d7d10d8b0757e5533c698d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184213)) **GitLab Enterprise Edition**
- [Add UI setting for AI agents to run pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/f95dd1dea4e6a83d5413cda8bae57938f305b32d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187945)) **GitLab Enterprise Edition**
- [Create organization_push_rules table](https://gitlab.com/gitlab-org/gitlab/-/commit/863894063f80e26b3e62418f57896bcc3360f205) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186908)) **GitLab Enterprise Edition**
- [Enable custom fields by default](https://gitlab.com/gitlab-org/gitlab/-/commit/98ef1bc32d15e1953fe44a59dea94da553e2f705) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187721)) **GitLab Enterprise Edition**
- [Allow owner to update duo_nano_features_enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/ba933c4163a9eb9e19d0263aeaca9f9abb76f0b1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187692)) **GitLab Enterprise Edition**
- [Add merge requests data source](https://gitlab.com/gitlab-org/gitlab/-/commit/53e5511d2fdb06b2bd177974eac55e4e22ae49ce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186762)) **GitLab Enterprise Edition**
- [Connect current statuses and custom statuses](https://gitlab.com/gitlab-org/gitlab/-/commit/3d7469f264b44df36d2e98c118b7d6ccfe945de4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186943))
- [Added validation for control name and expression](https://gitlab.com/gitlab-org/gitlab/-/commit/d3e52e32c9cfdf38cdbe2b600d585a20ca63939a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187350)) **GitLab Enterprise Edition**
- [Add `permalinkPath` field to TreeType via TreePresenter](https://gitlab.com/gitlab-org/gitlab/-/commit/a078f040d9a31bdea013d1bbce960c03a1684fec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186829))
- [Release conan protected packages feature](https://gitlab.com/gitlab-org/gitlab/-/commit/7e36dd7c2ea7c5d7b142ec4941c8a103a474acb4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187123))
- [Add AST_ENABLE_MR_PIPELINES var to scan execution policies](https://gitlab.com/gitlab-org/gitlab/-/commit/91b59abe2714a73a0ac19a56321a3d44985d907f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186739))

### Fixed (169 changes)

- [Loosen settings.write stub and expectations in GithubService spec](https://gitlab.com/gitlab-org/gitlab/-/commit/aab89e5ff5a8c26e533eb7443ca561039161ecad) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190977)) **GitLab Enterprise Edition**
- [Hide delete button for All branches](https://gitlab.com/gitlab-org/gitlab/-/commit/6f230775a12c8b45725a3a15315b55e493d0287f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190942))
- [Handle invalid import URLs](https://gitlab.com/gitlab-org/gitlab/-/commit/d706f1db3ecc915e4d6908d8fa57ce6ac5db24ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190873))
- [Add query params for prefilling new work item](https://gitlab.com/gitlab-org/gitlab/-/commit/74a09ae2ab44693b1a9d20bd2d3c1b536c3247c3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190389))
- [Update feature specs to pass when pipeline inputs flag enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/660840e6d53418a3363cadf9ddeca28b2ed8dcf5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189091))
- [Prevent duplicate submissions in work item form](https://gitlab.com/gitlab-org/gitlab/-/commit/2e443c1991ead83be012cb1aeb3afb0ccae86a7a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190772))
- [Move class to component](https://gitlab.com/gitlab-org/gitlab/-/commit/b65a7fa5292503a3a5dea0ce50edc252ae6f182e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189687)) **GitLab Enterprise Edition**
- [Use `no_longer_detected_ids` when auto-resolving vulnerabilities](https://gitlab.com/gitlab-org/gitlab/-/commit/5a9e23ff356dc1ed8be07320e30529d24a294dc0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190738)) **GitLab Enterprise Edition**
- [Fix sequence ownership for builds_metadata](https://gitlab.com/gitlab-org/gitlab/-/commit/d06c1ad92dddd69330a9d2e45e497c6b0028435c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190701))
- [Use tanuki icon for pages/html import](https://gitlab.com/gitlab-org/gitlab/-/commit/c32634b8b9b8b4b270c9fd3ccc034e010ffe625b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190532))
- [Fix scheduled PEP project schedule (re)creation](https://gitlab.com/gitlab-org/gitlab/-/commit/e8ee4a08d9eb145fc05eb94191adac3dc5bad565) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190088)) **GitLab Enterprise Edition**
- [Fix members list in group protected environments](https://gitlab.com/gitlab-org/gitlab/-/commit/ef7c08ca086f3fa6eee24af15f72a60f17a7a260) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190576)) **GitLab Enterprise Edition**
- [Fix bugs on dependency paths](https://gitlab.com/gitlab-org/gitlab/-/commit/731125ce239fc80107350ded864acd14cbfe2083) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188972)) **GitLab Enterprise Edition**
- [Change workspace scripts volume permission to 555](https://gitlab.com/gitlab-org/gitlab/-/commit/e381248a64826e693a7eb23988f628ffb70da7cd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190568))
- [Search Settings checkboxes only visible when instance is licensed](https://gitlab.com/gitlab-org/gitlab/-/commit/69b677c418241e67e8bcb2a3e3149aeeeddfe623) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190522)) **GitLab Enterprise Edition**
- [Fix TypeError for GraphqlController#query parameter](https://gitlab.com/gitlab-org/gitlab/-/commit/ec61ce23658a8d22026463e4781ac356b771683c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190186))
- [Fix creating system notes for mentions in wiki pages](https://gitlab.com/gitlab-org/gitlab/-/commit/9bdb563219e1e1066a4c6988ae23fd300b1623bb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189278))
- [Add Imported badge for Comments and System notes](https://gitlab.com/gitlab-org/gitlab/-/commit/3d987cb1c4afea3c5dbaac008336c7d6db887345) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190515))
- [Fix manual job is not clickable (mini graph)](https://gitlab.com/gitlab-org/gitlab/-/commit/cc958fd114b0e6826b8984fbb0f66edaa2f03d68) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190504))
- [Markdown preview header: Fix overlap on left](https://gitlab.com/gitlab-org/gitlab/-/commit/f8d904aa8239a8aa33489f0dbf8ead0764ef6264) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190503))
- [Fix NoMethodError for markdown documents with a single space](https://gitlab.com/gitlab-org/gitlab/-/commit/75b9842dd772bdc50b073ea475cc9c39553d196b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190482))
- [Disable Self-hosted models configurations on GitLab dedicated](https://gitlab.com/gitlab-org/gitlab/-/commit/ec11c67eef4844ba6dad5a022e88e764540736b8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190181)) **GitLab Enterprise Edition**
- [Allows clearing Docker Hub Authentication details in the UI](https://gitlab.com/gitlab-org/gitlab/-/commit/28bae318beb333a3c348c08d61ad2e9ca4e2dee8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189998))
- [Support trusted proxies in Workhorse config](https://gitlab.com/gitlab-org/gitlab/-/commit/74f8b1251291641b7d024406085c9807d5411fd7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189530))
- [Add a ping? check before hitting Elasticsearch in admin](https://gitlab.com/gitlab-org/gitlab/-/commit/b4d78e8a84844c2358bd7042a79653d982078e4c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189968)) **GitLab Enterprise Edition**
- [Skip orphan Sbom::Occurrence records when executing CVS](https://gitlab.com/gitlab-org/gitlab/-/commit/fe343c2d9ea7e4f219c793ca44e615642a95af82) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190413))
- [Adapt request for Duo settings update for sub-groups](https://gitlab.com/gitlab-org/gitlab/-/commit/2780802ab3bb5f34c293e003de835816a0b3490b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190386)) **GitLab Enterprise Edition**
- [Link security policy to framework from multiple top-level groups](https://gitlab.com/gitlab-org/gitlab/-/commit/fa777e11694b31d0789dd93232543dec53a81258) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190154)) **GitLab Enterprise Edition**
- [Update comment box warning text](https://gitlab.com/gitlab-org/gitlab/-/commit/c26ac06b4fb7d5433c89b4ffbf3ccb9b42132aed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189037))
- [Hide disable PAT group setting on self-managed](https://gitlab.com/gitlab-org/gitlab/-/commit/86e9c09fbb9504bf710f1cc0d03fa82a564317f7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189333)) **GitLab Enterprise Edition**
- [Make Geo Registry Names translatable and no longer auto generated](https://gitlab.com/gitlab-org/gitlab/-/commit/356860c514dfbd5958917e65d6699ec43e11c30a) by @karras ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187676)) **GitLab Enterprise Edition**
- [Fix no method error in SyncPolicyEventWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/c8f26445e538b3f0b7018b6984810492b20c1e8b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189920)) **GitLab Enterprise Edition**
- [Save custom_software_license if license is not on SPDX list](https://gitlab.com/gitlab-org/gitlab/-/commit/0539387ad76f3a142a2ff10d76fbb8e95d62ca59) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190124)) **GitLab Enterprise Edition**
- [Fix Web IDE iframe-based OAuth token refresh](https://gitlab.com/gitlab-org/gitlab/-/commit/8658b263f01a8182af274ec5d4ea597c81b4a158) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190307))
- [Fix missing PAT last_used_ips in GitLab CE](https://gitlab.com/gitlab-org/gitlab/-/commit/72e3ad5ce5bdcdc435895ca95b44ce5c4b148378) by @thomasgl-orange ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187714))
- [Fixed command palette edge case](https://gitlab.com/gitlab-org/gitlab/-/commit/6aca0c214ad5d597aef2a40f7da9db90db3361f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187691))
- [Fix overflow issue of issue title in user profile activity](https://gitlab.com/gitlab-org/gitlab/-/commit/0ecffdda3335a6b9200cae61a32cd86ca510a0a7) by @mosampatel78 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190151))
- [Fix work item URLs in activity RSS feeds](https://gitlab.com/gitlab-org/gitlab/-/commit/952d7c27701d6038129ca5b22f6d0f2145d538a7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190037))
- [Reschedule deduplicated `SyncScanPoliciesWorker`](https://gitlab.com/gitlab-org/gitlab/-/commit/01f4c967439fec9e0bc3fda80ea7f233699ad70f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189784)) **GitLab Enterprise Edition**
- [Handle race condition in approval rule creation from approval policy](https://gitlab.com/gitlab-org/gitlab/-/commit/36819f0d7a535360705add25cb4b05c993eb194d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190155)) **GitLab Enterprise Edition**
- [Pull branch ref from Gitaly if not present in Redis](https://gitlab.com/gitlab-org/gitlab/-/commit/dc4ca4c4b057256bd426fdcaf24669c428f159fe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188492))
- [Skip resolved_by validation on importing records](https://gitlab.com/gitlab-org/gitlab/-/commit/3d3a957982e3ca86fe54da2964f950f3165e8247) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190081))
- [Work items notes: Fix use of shortcut 'r'](https://gitlab.com/gitlab-org/gitlab/-/commit/8ffdf10977c2c1b58eeb1f4a5857c796019f5822) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190052))
- [Update runners/all access](https://gitlab.com/gitlab-org/gitlab/-/commit/669184e393ef3b27b562cabf108aa3eacc263570) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189287)) **GitLab Enterprise Edition**
- [Fix the new DS analyzer CI job image url](https://gitlab.com/gitlab-org/gitlab/-/commit/9865e404f4ee11a8a18f9db0e4478958b9a7647d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189987))
- [Fix subgroup filtering in framework project selection](https://gitlab.com/gitlab-org/gitlab/-/commit/e169b215e090351e3f797807395827aed9d7205e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189869)) **GitLab Enterprise Edition**
- [Fix the deletion callback bug for ES bookkeeping](https://gitlab.com/gitlab-org/gitlab/-/commit/b992a80fe39c6b1f17d794acfa772b222c1e82ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189840)) **GitLab Enterprise Edition**
- [Check for router nav possibility](https://gitlab.com/gitlab-org/gitlab/-/commit/565a04401217352848ed78fb38d278c8efa7c766) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189916))
- [Allow using comment templates in MR reviews](https://gitlab.com/gitlab-org/gitlab/-/commit/e23232fbd07392d56248f270ac7e2181d3bf1700) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189896))
- [Fix title disappearing in CreateWorkItemModal](https://gitlab.com/gitlab-org/gitlab/-/commit/8775f18d2852fb2fd0d95c42071455d18e7abff0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189145))
- [Check for setting before showing ImportHistoryMenu](https://gitlab.com/gitlab-org/gitlab/-/commit/f743d42d55f6562fe8face48899b9af8cea8e3a4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189844))
- [Prevent unauthorized users from adding, selecting or archiving designs](https://gitlab.com/gitlab-org/gitlab/-/commit/6fde5be3c02d745f7186a3e5ead6221b37b89d35) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189352))
- [Fix read AI Setting error when not logged in](https://gitlab.com/gitlab-org/gitlab/-/commit/7fa7346880d7758ace283e9bfea5f0451a5df7b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189805)) **GitLab Enterprise Edition**
- [Optimize searching projects with component version](https://gitlab.com/gitlab-org/gitlab/-/commit/46a71cc5efc0923b6c73dd1a01c054c0891764bf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189728)) **GitLab Enterprise Edition**
- [Alternative Vue breadcrumb injection method](https://gitlab.com/gitlab-org/gitlab/-/commit/99e41df6f4bcc85fb1846e969c3eef0112941cad) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186906))
- [Use SECURE_ANALYZERS_PREFIX in new dependency-scanning jobs](https://gitlab.com/gitlab-org/gitlab/-/commit/9aa79fe06d35db7f4ba6b19ca3d897693a434c7f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189072))
- [Make `after_script` and `before_script` mutually exclusive with `run` keyword](https://gitlab.com/gitlab-org/gitlab/-/commit/2aea534f75a897c2b8dc6c65e0683b25a707643e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189437))
- [Link security policy to framework from multiple top-level groups](https://gitlab.com/gitlab-org/gitlab/-/commit/7a65bd2bdae0644b46bbf8dbe94d513d90457504) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189075)) **GitLab Enterprise Edition**
- [Package Assets table: Add check for upload slot](https://gitlab.com/gitlab-org/gitlab/-/commit/41f54ffd32e8cd5286e142056648ac4dd74b7bcd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189739))
- [Use issuable name in issuable by email popup](https://gitlab.com/gitlab-org/gitlab/-/commit/4d44bfbb6a71665d010ca68f110edbe5a395470b) by @curs3_w4ll ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188796))
- [Fix manual job is not clickable](https://gitlab.com/gitlab-org/gitlab/-/commit/1f8780c6da5c688df5144e82f3b956b869a64136) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188806))
- [Fix ci variable drawer state](https://gitlab.com/gitlab-org/gitlab/-/commit/c31d0c8d306eb1348ef05c74c988e06061f7a6b0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189616))
- [Added detectAndConfirmSensitiveTokens to work_item_comment_form](https://gitlab.com/gitlab-org/gitlab/-/commit/6881c8e05f5910ec3dd2f831106f1f8953cd5863) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189258))
- [Fix CI depended triggers not locks resources](https://gitlab.com/gitlab-org/gitlab/-/commit/c3b4ac42072b79ef6e40de1ecc0e715a33eb0f06) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189585))
- [Rescue invalid URI in TransformReferencesWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/e6411642df2cacac53f26cb01a8e59edb6e21217) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189599))
- [Fix typo in FIPS docs page](https://gitlab.com/gitlab-org/gitlab/-/commit/bacb72da48b1f104e6cf1e1d32bd0fb1805e03f3) by @zillemarco ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189597))
- [Add the Parallelism flag in the indexing request](https://gitlab.com/gitlab-org/gitlab/-/commit/bcb7321bf274a42fd165b9105f0640c68ea0b6c9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189457)) **GitLab Enterprise Edition**
- [Bump devfile gem to v0.4.3](https://gitlab.com/gitlab-org/gitlab/-/commit/10c0949652f7668d1ac6e67d1e5d991cdfde8ec3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189533))
- [Show unknown status when nil Finding token status](https://gitlab.com/gitlab-org/gitlab/-/commit/2a0a65e3ad5ca575cc56b9719547231a74085ea7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188942)) **GitLab Enterprise Edition**
- [Fix bug where jobs don't show up in stage](https://gitlab.com/gitlab-org/gitlab/-/commit/61ebe2a4dce4723856d7fa3370ebb6b8ead67262) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189506))
- [Refactor NamespaceStatistics schedule worker namespace ids extraction](https://gitlab.com/gitlab-org/gitlab/-/commit/fc70cafe8f7c2f037f75b84c43c2682b83510db0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189239)) **GitLab Enterprise Edition**
- [Hide SSH signature from the tag's message](https://gitlab.com/gitlab-org/gitlab/-/commit/56448381fca598932d06768e3bf93a45c8f39fbc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189422))
- [Fix NoMethodError for Projects::RefsController#logs_tree](https://gitlab.com/gitlab-org/gitlab/-/commit/d17d6f1bc92a709ff83430732d48045c178b31f6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189414))
- [Update fast_gettext gem to v4.1.0](https://gitlab.com/gitlab-org/gitlab/-/commit/70106af51da30b40ab033ddff129be50b02b4686) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189383))
- [Fix nullable timelog.user in GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/f57ec6c0594b501c85a665e56ddc5b0bee44cc90) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189360))
- [Migrate timelogs for deleted users to ghost user](https://gitlab.com/gitlab-org/gitlab/-/commit/88c549b6344cb3ac32badaaa769838349785f1c9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189377))
- [Fix logic to hide work item notifications widget for logged out users](https://gitlab.com/gitlab-org/gitlab/-/commit/57c44c0c84aef96968b4c078bafad68675f8e153) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189370))
- [Consolidate style for "Please register or sign in to reply"](https://gitlab.com/gitlab-org/gitlab/-/commit/2012a03451ec245130b3a30c0fe2df505c651827) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189368))
- [Fix SEP validation for target_default and target_protected branch types](https://gitlab.com/gitlab-org/gitlab/-/commit/4d4975996ab56cab07f7d85180ce684758de9aeb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188710)) **GitLab Enterprise Edition**
- [Ensure primary button on board form remains disabled before modal closes](https://gitlab.com/gitlab-org/gitlab/-/commit/e8065f15b00b2c2b233cad8973fead7961a50060) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189359))
- [Ignore up arrow shortcut trigger if current comment is not empty](https://gitlab.com/gitlab-org/gitlab/-/commit/d1c2ea426129c429eadfc3c232c7b0c3a23ce45d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189339))
- [Prioritize service response when showing issue type fetch error](https://gitlab.com/gitlab-org/gitlab/-/commit/950ed2ac690b94b84d64ff03d47097d720adce50) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189330))
- [Remove force_scrollbar feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/98587272f0c49219a990a2804a3a097a4560c0d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189309))
- [Show partial data when there is an error in development widget](https://gitlab.com/gitlab-org/gitlab/-/commit/72cc551278c08d2755877409bd33d2494b3e7e18) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189180)) **GitLab Enterprise Edition**
- [Replace error with message when no comments found in /summarize_comments](https://gitlab.com/gitlab-org/gitlab/-/commit/9a863b063de34ca0cc743f2473095feca49efaa7) by @dagaranupam ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188010)) **GitLab Enterprise Edition**
- [Ensure security policy bot user before executing auto resolve policy](https://gitlab.com/gitlab-org/gitlab/-/commit/392cf48b0a02e5817ac7f20634e109dc86299ea2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189223)) **GitLab Enterprise Edition**
- [Fix issue popover's createdAt for non-relative-time users](https://gitlab.com/gitlab-org/gitlab/-/commit/b394e4a3addc1faeb3fc6edc08c409ac039356c8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189221))
- [Only check records with encrypted data in gitlab:doctor:encryption_keys](https://gitlab.com/gitlab-org/gitlab/-/commit/bf17b924fd73b1ec5b759562242ae02a3ce45695) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189030))
- [Improve namespace statistics scheduleWorker performance](https://gitlab.com/gitlab-org/gitlab/-/commit/04458c1f764c9ad2722d87888bc84814b02ddd53) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188503)) **GitLab Enterprise Edition**
- [Ensure token status has the correct value](https://gitlab.com/gitlab-org/gitlab/-/commit/4a20c322ade1a5efa6299d5bad696c08ad95ea65) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188839)) **GitLab Enterprise Edition**
- [Account for sign in bar for work item drawer](https://gitlab.com/gitlab-org/gitlab/-/commit/de06234fba9c216b9535b74befaa987fd6d7aade) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189119))
- [Fix policy editor button position](https://gitlab.com/gitlab-org/gitlab/-/commit/7a3fa98bd77a3d8ceb935d62a5f2c40c7df3dfd0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189099)) **GitLab Enterprise Edition**
- [Auto-expand work item description on link navigation](https://gitlab.com/gitlab-org/gitlab/-/commit/72cba1e16964e180d15e2d18739e69556bc89671) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188940))
- [Add key to router-view to ensure re-renders](https://gitlab.com/gitlab-org/gitlab/-/commit/aca1ffd3e7bb2bb5d54e90b7025f7a3b25bc9dd8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188984))
- [Fixed single relation endpoint bugs](https://gitlab.com/gitlab-org/gitlab/-/commit/4e956c29e850337c8c7cc0e582356326b339f2aa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187940))
- [Fix CRM validation bug when updating group settings](https://gitlab.com/gitlab-org/gitlab/-/commit/302538bdc502a5356a42dbea847e27f629804065) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188990))
- [Show webhook settings link if user has permissions](https://gitlab.com/gitlab-org/gitlab/-/commit/6bc9536ad3e7a1dc48489fe530288c4024cb848c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/153808)) **GitLab Enterprise Edition**
- [Handle nils for prometheus integrations](https://gitlab.com/gitlab-org/gitlab/-/commit/f95ae76cbd29f6fa9ac25d8289f6a7d1c4e7a2ae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187672))
- [Add BBMs to fix string config hashes in streaming destinations](https://gitlab.com/gitlab-org/gitlab/-/commit/14e7cc75fc606078ddace5a0a4a51c5903f466e2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187558)) **GitLab Enterprise Edition**
- [Fix streaming destinations BBMs](https://gitlab.com/gitlab-org/gitlab/-/commit/9f535b6a718c714fd5817f985b26d9967b087608) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186866)) **GitLab Enterprise Edition**
- [Update assignees search to include participants](https://gitlab.com/gitlab-org/gitlab/-/commit/c6966160e261d9fa48526bcec06e5c295881e7d3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188914))
- [Provide set_pipeline_variables policy from backend](https://gitlab.com/gitlab-org/gitlab/-/commit/a3a16813205cf3542a2b2c624063339aa690bcf7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188325))
- [Fix skeleton loader for work item mention popover](https://gitlab.com/gitlab-org/gitlab/-/commit/a9a2f41152a3297025bbab2c91ac1b35a2199ac0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188768))
- [Use CSS-based loaders for work item loading state](https://gitlab.com/gitlab-org/gitlab/-/commit/bc50be7c03ab1e4f0722427a5396a13feff8e351) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188808))
- [Fix quoting of user name in ReplaceTable helper class](https://gitlab.com/gitlab-org/gitlab/-/commit/a4a225317fd45a79d534d2389aedede6233fc80c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188867))
- [Remove unnecessary expectation to fix flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/2ef43c2d4e2110feaee70a6def9c43900ea64131) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188888))
- [Fix broken Dockerfile highlighting](https://gitlab.com/gitlab-org/gitlab/-/commit/d31016d433f2c17aed4f3d31508583b8ea268ac3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188866))
- [Prevent :remove_group perm. when projects cannot be removed by owners](https://gitlab.com/gitlab-org/gitlab/-/commit/a002479429b519cbc2eccd820da83f24a7fcf510) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188530)) **GitLab Enterprise Edition**
- [Hide group settings for dependency proxy if config is disabled](https://gitlab.com/gitlab-org/gitlab/-/commit/becd0d6739a2ead1230050d06016cb5dc475e026) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187046))
- [Fix fluid width invite members banner](https://gitlab.com/gitlab-org/gitlab/-/commit/32342ed3424539090679dd553fab3b4a7103c525) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187431))
- [Clear form on milestone create or cancel](https://gitlab.com/gitlab-org/gitlab/-/commit/e8bf93de415f053079339136d8698f932c0e4038) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188787))
- [Fix token prefix change when PAT prefix is nil](https://gitlab.com/gitlab-org/gitlab/-/commit/11672934e2e6904cb52d1e69eddba50e6ba62e23) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188779))
- [Update fog-xml to v0.1.5](https://gitlab.com/gitlab-org/gitlab/-/commit/eda35d1cf9a4df8ff0b9bb2839f04313aeecdf72) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188739))
- [Fix MR diffs endpoint to respond with pagination headers](https://gitlab.com/gitlab-org/gitlab/-/commit/93f2c9acb5124e913f2248ed57725ee103bee2f1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188752))
- [Fix bug with pipeline_schedule.last_pipeline loading all pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/ea0415926bbca5dbb75224c7ab4b89595517f933) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188719))
- [Fix project transfer not prioritizing exact matches](https://gitlab.com/gitlab-org/gitlab/-/commit/13bfd41ea173c664b7dc56a396ad697059ee3674) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188711))
- [Fix GraphQL /assign non-project member quick action (confidential issue)](https://gitlab.com/gitlab-org/gitlab/-/commit/b2f50a44a9d658d25063220e6f63a127a02ade12) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188706))
- [Fix design routing issue](https://gitlab.com/gitlab-org/gitlab/-/commit/3b319b2739bc2b26858c22a1d1b4d3716df9f1f3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188680))
- [Fix no method error construct pep with invalid policies](https://gitlab.com/gitlab-org/gitlab/-/commit/2eccae599b873d5a09968de951bbf42c9b222c75) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187878)) **GitLab Enterprise Edition**
- [Fix suffix alignment for mobile screen](https://gitlab.com/gitlab-org/gitlab/-/commit/f5554527221e36e7550a63fab77b6e3b59d11ad3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188638)) **GitLab Enterprise Edition**
- [Remove unnecessary preload from pipeline schedules API endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/898eed15402d4abfa912c2fb1613099fceadc906) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188606))
- [Fixed calling only one proper method to populate count](https://gitlab.com/gitlab-org/gitlab/-/commit/655893669a1a4701691755bc95e3454de7b6d505) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188142))
- [Fix the rendering of token Last Used IPs](https://gitlab.com/gitlab-org/gitlab/-/commit/21b2c7185aaefff1c80a36b1bd77041a587fcf4d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187403))
- [Do not try to update not existing record](https://gitlab.com/gitlab-org/gitlab/-/commit/e52a8caf1e0316bccba00e9ac088d8d7adbd7cf0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188557)) **GitLab Enterprise Edition**
- [Create security_policy_bot on project transfer](https://gitlab.com/gitlab-org/gitlab/-/commit/905be738e6dd46c67259f68cea8c2cdeae24a5c7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188551)) **GitLab Enterprise Edition**
- [Use commit email for cherry pick via UI](https://gitlab.com/gitlab-org/gitlab/-/commit/029d75b5e7a683d1c5af3d532aae74d19ee4c9f4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188546))
- [Respect fork filter for global zoekt search](https://gitlab.com/gitlab-org/gitlab/-/commit/3956f15e5d445af436b87601b5bffb7794cb3176) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187181)) **GitLab Enterprise Edition**
- [Fix issue where attached JS files couldn't be downloaded](https://gitlab.com/gitlab-org/gitlab/-/commit/c9c4347c6307e6891db7a4f91e17debeb07fb467) by @nikitasakau ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188465))
- [Allow update_runner policy for project runners shared indirectly](https://gitlab.com/gitlab-org/gitlab/-/commit/fde35b37427dd8eaac56f04493da38e4d98f49e0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188147))
- [Fix pipeline execution policies limit for group-level policies](https://gitlab.com/gitlab-org/gitlab/-/commit/e058fc1ae26f014a0b41436a1aae12f1c8bdf774) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188293)) **GitLab Enterprise Edition**
- [Move router view out of collapsible section](https://gitlab.com/gitlab-org/gitlab/-/commit/2db21e65606854ad520d2cdf5b34f5ad52bc232e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188450))
- [Adjust package history loading skeleton](https://gitlab.com/gitlab-org/gitlab/-/commit/7a6d8ee856aea84d617eca996824c69e4c1d2102) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188324))
- [Localize work item types in "Change type" modal](https://gitlab.com/gitlab-org/gitlab/-/commit/046f23421274dc4bd6d787ab6a69a60edfb83155) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186859))
- [Fix search SAML redirect for subgroup search](https://gitlab.com/gitlab-org/gitlab/-/commit/d16ad9c2be246e559d27049a8e4f7a51e8d6c092) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187559)) **GitLab Enterprise Edition**
- [Fix toggle text on dropdowns when initially selection is reset](https://gitlab.com/gitlab-org/gitlab/-/commit/3fcf2bab156c24318881896635d4e96e0717e5cd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188384))
- [Use fullpath for MR tooltip](https://gitlab.com/gitlab-org/gitlab/-/commit/d3d6a5f1767b845cd39fa25bc89ed5c0bc2431d5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188280))
- [Provide set_pipeline_variables policy from backend](https://gitlab.com/gitlab-org/gitlab/-/commit/84a3ea3ae20529bf1ac6fa18462dd4ac915611e5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188321))
- [Make sure long inline code in GLFM doesn't overflow its parent](https://gitlab.com/gitlab-org/gitlab/-/commit/7c16784530580706c15dc14bd8f7935c7d6cd85d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188317))
- [Runners list: Delete action fix loading icon](https://gitlab.com/gitlab-org/gitlab/-/commit/e4e6f52e15f5e067fa45730ed643f664e0c06061) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188267))
- [Improve custom field select options validation](https://gitlab.com/gitlab-org/gitlab/-/commit/edbf1d123160fdf29c403b1fa3cbb81cda4ca1f8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188278)) **GitLab Enterprise Edition**
- [Update approval_policy_rule_id to loose foreign key](https://gitlab.com/gitlab-org/gitlab/-/commit/2bbca02afb4226109f2cea6819dbf59543b207f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187881)) **GitLab Enterprise Edition**
- [Fix Epic note events in contribution calendar](https://gitlab.com/gitlab-org/gitlab/-/commit/dd3ea5b47163116afecf4a267a3e12d131ea7786) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188139)) **GitLab Enterprise Edition**
- [Fix time discrepancy in open MRs for blob](https://gitlab.com/gitlab-org/gitlab/-/commit/0b5154aa0e1e79b5453fc66ea1e5251a2d4f38d0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188241))
- [Fix MWPS notification label and improve event handling](https://gitlab.com/gitlab-org/gitlab/-/commit/28b6bb377edad2d2527c5755d5c7e574ef6fb917) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187572))
- [Protected container repositories Crud migrations](https://gitlab.com/gitlab-org/gitlab/-/commit/41f53690630fc412ff79fbaf40ed86d3809e9810) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188235))
- [Fix alignment of items in vulnerability report on mobile devices](https://gitlab.com/gitlab-org/gitlab/-/commit/81abd8f2435d0c466f1f8088da71050ed22073f8) by @karras ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188013)) **GitLab Enterprise Edition**
- [Show only scoped Vulnerability Management Policies in policies list](https://gitlab.com/gitlab-org/gitlab/-/commit/b4f600e864ecad59718c8e11947cd59fc46267c0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188391)) **GitLab Enterprise Edition**
- [Fix policy index handling for deleted security policies](https://gitlab.com/gitlab-org/gitlab/-/commit/eb4a3c830844775f04a9bba04b77c8aece5b5c85) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187861)) **GitLab Enterprise Edition**
- [Prevent title overflow](https://gitlab.com/gitlab-org/gitlab/-/commit/4d8d7ecec2f557cb6fb2bb4f8364c045543e7043) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188172))
- [Remove potential duplicate settings](https://gitlab.com/gitlab-org/gitlab/-/commit/60e820b9cee0be95b9fb569236626dabf80a019e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187086))
- [Show PMD results in inline code quality diff](https://gitlab.com/gitlab-org/gitlab/-/commit/04056a2003a89d50aa174f2868b4557113f7976b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187759))
- [Fix new issue template work item logic](https://gitlab.com/gitlab-org/gitlab/-/commit/a0d95efcb57724d5e7dfcc20a82cd27c6bb29165) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188165))
- [Display loading icon on the correct button](https://gitlab.com/gitlab-org/gitlab/-/commit/31164126de0941bbd848388f473afdc6d5c50492) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187813)) **GitLab Enterprise Edition**
- [Fix alignment of pending note footers](https://gitlab.com/gitlab-org/gitlab/-/commit/bbe7efe0407fc65d3563e4ee67887886c5c71991) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188149))
- [Fix string conversion for CI Inputs](https://gitlab.com/gitlab-org/gitlab/-/commit/53a620b2b2b0e3f6355f5ef3383fd9db79c15f68) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188093))
- [Pipeline graph: Failed grouped jobs spacing fix](https://gitlab.com/gitlab-org/gitlab/-/commit/ca396408d2bc6aef4b09b68e4c9b38584700b7d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188141))
- [Always log CloudFlare leaked cred reports on signin](https://gitlab.com/gitlab-org/gitlab/-/commit/e2f97eeab0f663ecab06444a0df5608b48f3b1ac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187644)) **GitLab Enterprise Edition**
- [Top bar search: Fix alignment on right](https://gitlab.com/gitlab-org/gitlab/-/commit/ccb12a0721bb1ce7f8d66e37ac7d720432202c3e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188126))
- [Use fuzzy search on work item labels dropdown](https://gitlab.com/gitlab-org/gitlab/-/commit/835e8f7ff29acceb99b457ba7da843aa231741ad) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187958))
- [Ensure board card "Card options" menu toggle button has accessible text](https://gitlab.com/gitlab-org/gitlab/-/commit/f2a3190ad9a64a277cc25b23de7dc1a474a9e22e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187770))
- [Allow long downstream pipeline names to break](https://gitlab.com/gitlab-org/gitlab/-/commit/322198275daeb92aca65635f12ba756b890941a8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187924))
- [Fix execute_count method on elasticsearch](https://gitlab.com/gitlab-org/gitlab/-/commit/b09ea5ba310416bc219ab7ec2918a55750187ac1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187674)) **GitLab Enterprise Edition**
- [Fix spacing of note header timestamp for notes with system content](https://gitlab.com/gitlab-org/gitlab/-/commit/9d52f0a4cb52b3dbd329d78a59fbddac29a5c358) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187608))
- [Truncate long test suite names](https://gitlab.com/gitlab-org/gitlab/-/commit/9540323800846bfa59d2de6209c96c41399e63fc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187734))
- [Fix positioning of GLQL actions dropdown](https://gitlab.com/gitlab-org/gitlab/-/commit/5fbe89bf99d5cc2640cfe7ba5acb3fe1d7c36a8b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187864))
- [Schedule pipeline: Validate cron timezone](https://gitlab.com/gitlab-org/gitlab/-/commit/c7bac13bb4de5d63e9f2f5872835f15c2b83b965) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187542))
- [Input copy toggle: Add border to input](https://gitlab.com/gitlab-org/gitlab/-/commit/7b2f1f4e1f3e15081a558794773db22e3b9b89f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187736))
- [Ensure end of notification email signature has unique content](https://gitlab.com/gitlab-org/gitlab/-/commit/1402cf2924f1a00d2231e9e38bbc853b27cf8649) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177913))
- [Fix service account email confirmation with domain verification](https://gitlab.com/gitlab-org/gitlab/-/commit/359862a7d153f6e781c0ee18aff16ee8cfead5ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186716)) **GitLab Enterprise Edition**

### Changed (231 changes)

- [Remove custom_software_license feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/757cd23b26f7fcf36c21007059632619a7957439) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188923)) **GitLab Enterprise Edition**
- [Add right sidebar for new learn gitlab](https://gitlab.com/gitlab-org/gitlab/-/commit/73704c32b436dc427a9498786c14998e9d46bd8f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190257)) **GitLab Enterprise Edition**
- [Handle nil vulnerability_read for VulnerabilityType](https://gitlab.com/gitlab-org/gitlab/-/commit/654cfdc3c023d7136273c25d122728ec2acde122) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190851))
- [Add base policy attributes](https://gitlab.com/gitlab-org/gitlab/-/commit/f7bbc3770697505539627703812321a477dc23ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190758)) **GitLab Enterprise Edition**
- [User admin detail: Migrate page header to pageHeading](https://gitlab.com/gitlab-org/gitlab/-/commit/49ef6ea0800924b64ac81e3fc72d27904d70aa77) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190821))
- [Remove feature flag zoekt_multimatch_frontend](https://gitlab.com/gitlab-org/gitlab/-/commit/9026c9687cb0ffe208a8b3aff9975c13d3d59f97) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190519)) **GitLab Enterprise Edition**
- [Add human/bot filtering options to admin interface](https://gitlab.com/gitlab-org/gitlab/-/commit/cba95694d0e63c2280bf945022e2e0247f65de80) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189848))
- [Help menu: Fix contribute link](https://gitlab.com/gitlab-org/gitlab/-/commit/56930931bfeddb00ed804b5e33a2e3f436941e87) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190849))
- [Adjust capitalization for service accounts UI](https://gitlab.com/gitlab-org/gitlab/-/commit/988fd3bed9ab48b022996669b4949e46000653f7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190983))
- [Update PostgreSQL docs for version 16](https://gitlab.com/gitlab-org/gitlab/-/commit/5f705ff47abe85b4e277457d38fb1d4ea8906171) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190883))
- [Public avatar settings section migration](https://gitlab.com/gitlab-org/gitlab/-/commit/6c7a2781976ad6905d93d3830dc11c6e29312b75) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190825))
- [Bump minimum required PostgreSQL version to 16](https://gitlab.com/gitlab-org/gitlab/-/commit/303c4f53a9193735fa63cd9e2a49864e0f4c6497) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190814))
- [Decrease bottom padding in content wrapper](https://gitlab.com/gitlab-org/gitlab/-/commit/15a087a0ed5e599d44fada12d21aea38c2a282ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190863))
- [Update container registry page and shared list item](https://gitlab.com/gitlab-org/gitlab/-/commit/ef3ec868871b25e8a7da040cdaaeb5e8eff1afa6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189541))
- [Improve access tokens options in admin settings](https://gitlab.com/gitlab-org/gitlab/-/commit/ee602d0659969b9047b684b95e915366c9f0f278) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190481))
- [Add style to new_gpg_key_email notification](https://gitlab.com/gitlab-org/gitlab/-/commit/3a9ca923e1d7ca9c72dfff020d5faf79d4f02f86) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190115))
- [Set FF allow_duo_base_access to true](https://gitlab.com/gitlab-org/gitlab/-/commit/ba8462670f0355dfe8398d44fc99127693c22484) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190267)) **GitLab Enterprise Edition**
- [Settings section: Make only heading sticky](https://gitlab.com/gitlab-org/gitlab/-/commit/e6a8c7b5a2be22a46d90868b8763ba1d3603e7b8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190372))
- [Roles and permissions detail page: Remove tabs](https://gitlab.com/gitlab-org/gitlab/-/commit/78798e1c9d582677c7fcaf0fa0aa4100e91b4ebf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190205)) **GitLab Enterprise Edition**
- [Permanently enables dependency_proxy_read_write_scopes](https://gitlab.com/gitlab-org/gitlab/-/commit/764bec8d55b80132cd77ad895baf4803085344aa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189014))
- [Inclusive due_date for %Started scope](https://gitlab.com/gitlab-org/gitlab/-/commit/84df2b3ddb39d7b04cb6fedbe3c645cc145c5a9e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190770))
- [make control name reflect what is ensured](https://gitlab.com/gitlab-org/gitlab/-/commit/f4a94a4b9c3492b8fe4e798ccc321c0031b4247b) by @erik.petzold1 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190348)) **GitLab Enterprise Edition**
- [Add registry upstream list item and form components](https://gitlab.com/gitlab-org/gitlab/-/commit/f6a30cc8425713ebb25210a15eec886bbbba646b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189692))
- [Add source filter to `newest_first` method in the Pipeline model](https://gitlab.com/gitlab-org/gitlab/-/commit/71b66d60ae9b98d7203be71aa26e40270c6602fa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189704))
- [Update tooltip and docs description for Cycle time analytics](https://gitlab.com/gitlab-org/gitlab/-/commit/b1f04bc29ff985368dfa5664f9c6a83cc32a717f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190253))
- [Populate email field if email is present](https://gitlab.com/gitlab-org/gitlab/-/commit/65c973c6f241ecef975ccff47e4bf9997c46082d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190574)) **GitLab Enterprise Edition**
- [Only send modified inputs in pipeline new form](https://gitlab.com/gitlab-org/gitlab/-/commit/0019e91dfc86c1322c9ee7e270f3bba714094d9c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189952))
- [Use user organization as fallback for missing organization](https://gitlab.com/gitlab-org/gitlab/-/commit/30989ac9c8e5c8cc4a1811c928709229a72b7065) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190360))
- [Consider namespace bans for Duo root_group_ids](https://gitlab.com/gitlab-org/gitlab/-/commit/2e27f97a05d25ab9a4801fcad827910662faa516) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190702)) **GitLab Enterprise Edition**
- [Bypass permission check to close MRs for archived projects](https://gitlab.com/gitlab-org/gitlab/-/commit/5da37700fc347662c07f9317785a6c8e4d7c0cfe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189438))
- [Add ES bookkeeping when calling update_all or delete_all on vulnerabilities](https://gitlab.com/gitlab-org/gitlab/-/commit/bdb2b52745becf675afca7691e9ed753655a3bba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188856)) **GitLab Enterprise Edition**
- [Allow auto enable Duo Core feature setting via seat link sync](https://gitlab.com/gitlab-org/gitlab/-/commit/c96ced572dbe01eefc4814f72bd520b361cebece) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190496)) **GitLab Enterprise Edition**
- [Delete placeholder users when a top level group is deleted](https://gitlab.com/gitlab-org/gitlab/-/commit/c4de5583a26111a02947999c7d2f7f7b2c4122fb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188764))
- [ActiveContext: Add consitent error handling for preprocessors](https://gitlab.com/gitlab-org/gitlab/-/commit/48af8dfadf535add828289436aaad4e7e1a288d9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190224))
- [Improve UX on CTAs after creation of compliance framework](https://gitlab.com/gitlab-org/gitlab/-/commit/32132a8d25c782dd18743b9b90d50c15d66925ae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189275)) **GitLab Enterprise Edition**
- [Refactor AI Setting mutation to return the object](https://gitlab.com/gitlab-org/gitlab/-/commit/7c5528fd86c140b003606e973cf9948bd8ac3790) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189810)) **GitLab Enterprise Edition**
- [Allow only active and non-bot user](https://gitlab.com/gitlab-org/gitlab/-/commit/f7662a649f5c79f7b14533c92466b2423e40db45) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190665)) **GitLab Enterprise Edition**
- [Modernize Crud component](https://gitlab.com/gitlab-org/gitlab/-/commit/9d47ce8cc7cd676d0f3a420d6a82205b00798b43) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188572))
- [Disables editing blob for lfs](https://gitlab.com/gitlab-org/gitlab/-/commit/173841652bdd35acda378f22c5c3fb2df28f3923) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190276))
- [Revert user-facing docs for enabling admin bypass placeholder confirmation](https://gitlab.com/gitlab-org/gitlab/-/commit/bc353a34f20ebd5dc41aa22c7604934c557a1f28) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190584))
- [Include push_ruleable concern in group_push_rule](https://gitlab.com/gitlab-org/gitlab/-/commit/1b219f4098f0e1b1be145907c67566095b687f8f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190414)) **GitLab Enterprise Edition**
- [Extract shared logic from push_rules to a concern](https://gitlab.com/gitlab-org/gitlab/-/commit/289ebf33e730ea5e2bb64bf20f6a5f3cb50bf71b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188997)) **GitLab Enterprise Edition**
- [Update header app and blob overflow menu feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/ac5d5108a24de0c65c847ed3cb1def4880b15673) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190540))
- [Updates project runner details page](https://gitlab.com/gitlab-org/gitlab/-/commit/78e4cd90b2882b04ac47ae5e4857c20d3a4dc6fa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189650))
- [Scope Duo Workflow action feature flag to user](https://gitlab.com/gitlab-org/gitlab/-/commit/a7cbd025c9ba366bed0f8795f2d01db53e35db1e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190527)) **GitLab Enterprise Edition**
- [Enable better CI/CD analytics for project pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/0c3c3c521ae927bdef78f159a4fa9dfcddf45a0b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190316))
- [Track collapsed diffs from Gitaly to show safe limit warnings](https://gitlab.com/gitlab-org/gitlab/-/commit/c00fd442cf563a1502240b7873570815f9239359) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190442))
- [Enable `commits_from_gitaly` feature flag by default](https://gitlab.com/gitlab-org/gitlab/-/commit/11fb609de5265b6e819007bd283d31cacdc8285f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190477))
- [Update major version of GLAS image](https://gitlab.com/gitlab-org/gitlab/-/commit/2ed3a5740c4c2b2c46a3fe6f834cd74c1336abc5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189787))
- [Remove the extra space on no results](https://gitlab.com/gitlab-org/gitlab/-/commit/eeab5defdeca3709da06d2f4bada64c771a34f73) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188793))
- [Update on call schedule to import only data design token color constants](https://gitlab.com/gitlab-org/gitlab/-/commit/72d6d1cb7752657ea475777b708dacbecffbacbf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190163))
- [Add explore GitLab Duo Core banner to MR](https://gitlab.com/gitlab-org/gitlab/-/commit/57eb9edb01476b58c35e610c82c98b41a99a348e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189684)) **GitLab Enterprise Edition**
- [Finalize backfill_secret_push_protection_enabled migration](https://gitlab.com/gitlab-org/gitlab/-/commit/f4b619cd4fc8b5dc2f1b4e7456e54ba46fc2673f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190349))
- [Remove the git_push_create_all_pipelines feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/2f1427ff97782395e7ec642adc1d300aa8471ac5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190248))
- [Make external status checks support group-level protected branches](https://gitlab.com/gitlab-org/gitlab/-/commit/379af69db2345d21217275d3c90e719b11ba361e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189498)) **GitLab Enterprise Edition**
- [Update project template list](https://gitlab.com/gitlab-org/gitlab/-/commit/73460985e8aa3f4560f286c320f7c6c2825207cb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189964)) **GitLab Enterprise Edition**
- [Revalidate_gpg_fingerprins ff default_enabled set to true](https://gitlab.com/gitlab-org/gitlab/-/commit/16fb0aade6280a24664bf61422a766442033c6ea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190370))
- [Updates enable duo banner to use api](https://gitlab.com/gitlab-org/gitlab/-/commit/dcffae178f02ca21488cd00f826af048bc166c48) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190280)) **GitLab Enterprise Edition**
- [Add admin UI control for `scan_execution_policies_schedule_limit`](https://gitlab.com/gitlab-org/gitlab/-/commit/ec6e48db3febcf1e0b6b3fec99329f4c0ae804e6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190352)) **GitLab Enterprise Edition**
- [Permanently enables packages_dependency_proxy_containers_scope_check](https://gitlab.com/gitlab-org/gitlab/-/commit/8d6e903236f4c786086b6661a8fa4ec2a7be95c6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190324))
- [Role detail view: Migrate components](https://gitlab.com/gitlab-org/gitlab/-/commit/7bcd97f69645f8ec1fd4e8ffde3bb0d00a562af2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190040))
- [Increse max_tokens for review_merge_request](https://gitlab.com/gitlab-org/gitlab/-/commit/b25764e6fe969d4fd810c9e4996feeaa6f5a8736) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190308)) **GitLab Enterprise Edition**
- [Fixes tracking for modal primary event](https://gitlab.com/gitlab-org/gitlab/-/commit/fe6ccb97fe60789474d9072e6405fb5062ec43f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190259)) **GitLab Enterprise Edition**
- [Show message when Duo code review is unavailable](https://gitlab.com/gitlab-org/gitlab/-/commit/e5982fcb0a4728cbbf95f86f531247c32b11a8f2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189905)) **GitLab Enterprise Edition**
- [ActiveContext: allow disabling ref fields](https://gitlab.com/gitlab-org/gitlab/-/commit/3a646a03c6dfed049cf6a092608289513e7bbd3a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190222))
- [Container registry forms: Set autofocus to add forms](https://gitlab.com/gitlab-org/gitlab/-/commit/82e3469f61c51295d0b9cde03714af7caa1de5f8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190199))
- [Create member role: Migrate components used to shared components](https://gitlab.com/gitlab-org/gitlab/-/commit/ae43617f2c8fd73340142492efabd056d49c85ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190036))
- [Drop exact_matches_first_project_transfer feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/192e287227e929ea5da9f9975fcebb48be62cda8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190305))
- [Disable batch update button for disabled features](https://gitlab.com/gitlab-org/gitlab/-/commit/7694814bf89da35e4f7da77458a8a102bcdc6e0a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188949)) **GitLab Enterprise Edition**
- [Feature flag default_enabled set to true](https://gitlab.com/gitlab-org/gitlab/-/commit/d90c937034add4de3c27f5020766f5e0dd93d94f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190283))
- [Update example response for Geo site status API](https://gitlab.com/gitlab-org/gitlab/-/commit/e09674c1538dfe1e9419130ab8f6cd7d25888a4e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190256))
- [Package registry: Improve loader to reflect more real world data](https://gitlab.com/gitlab-org/gitlab/-/commit/405a51a4450427024076739f4756652e3286b0d4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189796))
- [Document SaaS-only GraphQL schema](https://gitlab.com/gitlab-org/gitlab/-/commit/0195cb3d13fd79f0f0937608d04fbe34a15a67e9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189556))
- [Remove company size from company form](https://gitlab.com/gitlab-org/gitlab/-/commit/40ed2704fe92e55589a3c3a36b54bd69441e6b64) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189680)) **GitLab Enterprise Edition**
- [Add boolean type custom cell to inputs table](https://gitlab.com/gitlab-org/gitlab/-/commit/dbcb2215ec1ad11ac349be2c183664a4a9126253) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189972))
- [Shorten import options list on group registration page](https://gitlab.com/gitlab-org/gitlab/-/commit/7864c83e60d40a3a56ecf52bfbee313812962425) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189526)) **GitLab Enterprise Edition**
- [Hide Duo availability for Duo Core](https://gitlab.com/gitlab-org/gitlab/-/commit/a6ebd04084397b64ec966717354f6f3f6a713cf7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189778)) **GitLab Enterprise Edition**
- [Update dependency auto-build-image to v4.11.1](https://gitlab.com/gitlab-org/gitlab/-/commit/904b60eeb7c6035aa66546f38e3ce4febc94a3a2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190073))
- [Enable open MRs for a file feature by default](https://gitlab.com/gitlab-org/gitlab/-/commit/03df2e20d46a710257c714e40f0dfc770f4c0948) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190051))
- [Package project settings: Use section instead of block component](https://gitlab.com/gitlab-org/gitlab/-/commit/c8e540f1a9f6c22653edb7ff1b481b5c0eb968a7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188225))
- [Add ExclusiveLeaseGuard to bulk update](https://gitlab.com/gitlab-org/gitlab/-/commit/76fc7bcd06ad2fe550ff315fc3816f5e24a2b5d9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188271)) **GitLab Enterprise Edition**
- [Stop persisting pipeline config](https://gitlab.com/gitlab-org/gitlab/-/commit/bdc421dc22a1a4d46f099ff834ab0a9fd748c6fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189479))
- [Update registration company form](https://gitlab.com/gitlab-org/gitlab/-/commit/201af6dbbc13e201f11652f7091a3109579750a8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188164)) **GitLab Enterprise Edition**
- [Make delayed deletion available to all pricing tiers](https://gitlab.com/gitlab-org/gitlab/-/commit/f553dc8a042d1d170b9fbe6e60cb69f3dff4ff71) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189976))
- [Reset variables modal to initial state](https://gitlab.com/gitlab-org/gitlab/-/commit/3a3c1697a85552b690a5001990ffc13c67260ee6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189372)) **GitLab Enterprise Edition**
- [Add 'external_control_name' to compliance requirements controls](https://gitlab.com/gitlab-org/gitlab/-/commit/a6858434651e1ddd46762316cd27929a7ac09127) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189851)) **GitLab Enterprise Edition**
- [Add enable duo banner component](https://gitlab.com/gitlab-org/gitlab/-/commit/d96b60158d4f7f49d9864e921c0b45fa8e5e3fdb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188312)) **GitLab Enterprise Edition**
- [Move work item confidentiality loading spinner to actions dropdown](https://gitlab.com/gitlab-org/gitlab/-/commit/d90b6011e9b7ecd4dfe93af8d1b49b0eabd8f558) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188920))
- [Separate project and group dependency types in GraphQL API](https://gitlab.com/gitlab-org/gitlab/-/commit/2ba24d078a44e343b3cf87383eefdc806b5172af) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188295)) **GitLab Enterprise Edition**
- [Enable using glab for CI release](https://gitlab.com/gitlab-org/gitlab/-/commit/440f6c6a41c509671648890128d60712d55507b0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189138))
- [Add API endpoint to update Maven virtual registry upstream position](https://gitlab.com/gitlab-org/gitlab/-/commit/389595ab5456cfd71de1f82c7e8411e07c49b546) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186890))
- [Add ApplicationSetting for the `git_push_create_all_pipelines` ff](https://gitlab.com/gitlab-org/gitlab/-/commit/eb783b1891d46a1ecb9235ab2f26f0bdac733137) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186134))
- [Update milestone scopes](https://gitlab.com/gitlab-org/gitlab/-/commit/7286879b0833f18f5f66909fb743a95b159ea8ad) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187632))
- [Remove next button from identity verification](https://gitlab.com/gitlab-org/gitlab/-/commit/1b9f301cd065cfaf61c82ef12ef32872e0405e0d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189753)) **GitLab Enterprise Edition**
- [Add archived project to compliance framework filter](https://gitlab.com/gitlab-org/gitlab/-/commit/836c7ca1819e553a2bbf671da19428781efbe302) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178665)) **GitLab Enterprise Edition**
- [Move a variable list to a parent component](https://gitlab.com/gitlab-org/gitlab/-/commit/4b7924ee8b4ecd65073e4740b2fbe767c6168209) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189366)) **GitLab Enterprise Edition**
- [Increased default bcrypt stretches, enabled transparent upgrade](https://gitlab.com/gitlab-org/gitlab/-/commit/905ff18bd2a1e6028dfeadec7ebfbf63687cf7a5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177154))
- [Updated Validity Check Badge text to reflect possible design titles](https://gitlab.com/gitlab-org/gitlab/-/commit/e93a58fa579dbd8c2edd29d24b15a550e2a79dd5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189586))
- [Change column default from true to false](https://gitlab.com/gitlab-org/gitlab/-/commit/07fe5b17ed5674495e7a4514f7713477196d976c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188203)) **GitLab Enterprise Edition**
- [Revert MR 189075](https://gitlab.com/gitlab-org/gitlab/-/commit/0bfbf99025e749eb1c6cb202a74cee5262a4f540) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189821)) **GitLab Enterprise Edition**
- [Update package page headings and install instructions](https://gitlab.com/gitlab-org/gitlab/-/commit/54f91a85854c5b649b18bd9567110dbb7245f807) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188338))
- [Pipeline minigraph: Improve search input styles](https://gitlab.com/gitlab-org/gitlab/-/commit/b00bac2af3b6f4fda18c8d8883d8a343e5817880) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189782))
- [Work item: Reduce spacing between title and meta information](https://gitlab.com/gitlab-org/gitlab/-/commit/e80cff3702f6d6b8d13dd1a7710f1e8d54577571) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189632))
- [Re-prepare async index on merge_request_commits_metadata_id](https://gitlab.com/gitlab-org/gitlab/-/commit/5bec662aff0cc1fdaa794d5ecb58eacebe1b26bc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189775))
- [Project sidebar badges alignment improvement](https://gitlab.com/gitlab-org/gitlab/-/commit/5eac71f4f96ff2c3ecc2cf68ee2cfac1c751c818) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189769))
- [Rename Security Orchestration Policy to Scheduled Scan Execution Policy](https://gitlab.com/gitlab-org/gitlab/-/commit/ee27f8d36fa8453671b3fcadbcf9f0ed970f64ed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189761)) **GitLab Enterprise Edition**
- [Updated move and clone operations to work on work item framework](https://gitlab.com/gitlab-org/gitlab/-/commit/09f1ef29904500a43de00cc6cb55c140375d14b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187589))
- [Model registry: Performance tab changes](https://gitlab.com/gitlab-org/gitlab/-/commit/13a23898a49f54232afef0dafb93a5ad3bc29ca7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189752))
- [Model registry version: Refactor header](https://gitlab.com/gitlab-org/gitlab/-/commit/a0ba8ca17bf4d5683c3a7d2ff943d7858bfba306) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189745))
- [Update variable args in workspaceCreate mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/3954f07818d7c47ac4c2a9fc0fa5f488036bce6d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188937)) **GitLab Enterprise Edition**
- [Document tuning of lower Geo concurrency default settings](https://gitlab.com/gitlab-org/gitlab/-/commit/f5180ea6796369b6875ae85f8329c43a42ad60de) by @karras ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184510))
- [Add Auditor as a filter option to the Admin users page](https://gitlab.com/gitlab-org/gitlab/-/commit/50126ffc6b0e7c108e3ae8e15d25a69b907bf0d4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187612)) **GitLab Enterprise Edition**
- [Separate project and group dependency types in GraphQL API](https://gitlab.com/gitlab-org/gitlab/-/commit/b4e191a88744b61d4334ba41e1437c12004eb46c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188295)) **GitLab Enterprise Edition**
- [Disable `confetti_post_signup` cookie](https://gitlab.com/gitlab-org/gitlab/-/commit/cf28bd11d333ae86cc1ef10d6963b391d7e43c0b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189340)) **GitLab Enterprise Edition**
- [Flexible work item sidebar](https://gitlab.com/gitlab-org/gitlab/-/commit/fe2cf3461eaa4ff7549f9d24e4901ac0e7ef4905) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186598))
- [Turn auto_devops_banner_disabled on by default to hide the banner](https://gitlab.com/gitlab-org/gitlab/-/commit/3cacbc6449d5fa08022881bfebe83e9c707c19f7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189630))
- [Improve interpolation error messaging](https://gitlab.com/gitlab-org/gitlab/-/commit/13d0edf3e3ab1affe113fc6b516f15c165fde371) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189460))
- [Make PDM no-op since it was incorrect](https://gitlab.com/gitlab-org/gitlab/-/commit/8ab2c412638b49dfe80f5c31e968a7e73e4befc1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189591))
- [Runner detail page: Show runners in Crud](https://gitlab.com/gitlab-org/gitlab/-/commit/655a5dbc57bec8ba6170256041a371acea38c88c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188089))
- [Change to async_delete for ci_running_builds.runner_id](https://gitlab.com/gitlab-org/gitlab/-/commit/fc84bfdf30df056f4c1606ddb0eb61961361d38e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189572))
- [Lower Geo replication concurrency default settings](https://gitlab.com/gitlab-org/gitlab/-/commit/aea17157fc02f63ab0be58930285d569217a570a) by @karras ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184473))
- [Add integration tests for exclude licenses](https://gitlab.com/gitlab-org/gitlab/-/commit/fbd4edb391f4343a561969ecaaf29d222aee3a61) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189477)) **GitLab Enterprise Edition**
- [Add "Open in Workspace" in MR page](https://gitlab.com/gitlab-org/gitlab/-/commit/e140374d9b18355d569de5f5e8cdeeaf10626c58) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187320)) **GitLab Enterprise Edition**
- [Update group and project label in search modal](https://gitlab.com/gitlab-org/gitlab/-/commit/5bf8040fbf230a5d2d8255a266829df55737e631) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187626))
- [Fix the styling of import buttons](https://gitlab.com/gitlab-org/gitlab/-/commit/8c32b48e5ab0028f1426b8613f41614709dbd3f5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188822)) **GitLab Enterprise Edition**
- [Use package id in package registry breadcrumbs](https://gitlab.com/gitlab-org/gitlab/-/commit/ed5f2d6666d910926000a9b3d39cf080a8842f57) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188628))
- [Update dependency auto-deploy-image to v2.128.0](https://gitlab.com/gitlab-org/gitlab/-/commit/05056cac6cbc7c5985a8ca0d7fda934ed379f979) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189473))
- [Update dependency auto-build-image to v4.11.0](https://gitlab.com/gitlab-org/gitlab/-/commit/a99a02b17977c01fd3485e167c51bcf90ca9aa13) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189472))
- [Model registry detail page improvements](https://gitlab.com/gitlab-org/gitlab/-/commit/c105f1b0c58c6dfb46cd503dbb753e7120b967fa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188422))
- [Update error messages for pipeline inputs](https://gitlab.com/gitlab-org/gitlab/-/commit/733094c64f5d24266cab5bf0e28f4852ece3a676) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188784))
- [Add confirmation step before a broadcast messages gets saved](https://gitlab.com/gitlab-org/gitlab/-/commit/6b4ed39a9cba49ac0a50c8e2882c5316ada30232) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189446))
- [Move `workItemStatus` fragment to main query](https://gitlab.com/gitlab-org/gitlab/-/commit/6477e8b23b178f0bb7e071ac127bfa321f36e263) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188212)) **GitLab Enterprise Edition**
- [Set cache: [] in Secret Detection latest template](https://gitlab.com/gitlab-org/gitlab/-/commit/776e726aaec3f7f16c7f612399624e29fd415ad0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186637))
- [Hide child items and linked items widgets when empty and can't edit](https://gitlab.com/gitlab-org/gitlab/-/commit/b900a6ceb9f759ea8cbbf75a96d203496825fa4a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189347))
- [Add a warning modal when disconnecting SAML groups](https://gitlab.com/gitlab-org/gitlab/-/commit/443b211f36dc8ff6cd5c8e4a6dc304066acf1efc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188996))
- [Enable `disable_widget_responses` by default](https://gitlab.com/gitlab-org/gitlab/-/commit/32ce61a8c9be61211451eddc9797ce9149ae486c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189189))
- [Fix PAT last_used_ips for /self API](https://gitlab.com/gitlab-org/gitlab/-/commit/8be64522586e4d5bf453bfaff4783369056c5ce2) by @thomasgl-orange ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187671))
- [Update ffi and mixlib-log gems](https://gitlab.com/gitlab-org/gitlab/-/commit/b0e2cfc8ea1e47495af059d180f99bcc5f6ee4a7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189229))
- [Add milestone_title keyword field to work_items index](https://gitlab.com/gitlab-org/gitlab/-/commit/0b5cc20d6a2967b36684dc0843a29cb4633f991d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187717))
- [Expose vulnerabilities fields to Jira integration API](https://gitlab.com/gitlab-org/gitlab/-/commit/54e41f6ef00369d4cb27fd592c056c0ea55beb64) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189200)) **GitLab Enterprise Edition**
- [Nullify embedding0 field](https://gitlab.com/gitlab-org/gitlab/-/commit/0cdb926077271296c277ee164b65d747594b2af4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188044)) **GitLab Enterprise Edition**
- [Cleanup plan_limits_repository_size Feature Flag](https://gitlab.com/gitlab-org/gitlab/-/commit/06d735f820763ee5076449a0561ecbb71f0575d2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188251))
- [Switch workitem index to use new embedding field and model](https://gitlab.com/gitlab-org/gitlab/-/commit/bc242330a0480da3abfa0ec79c9bd7900b1da7ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187518)) **GitLab Enterprise Edition**
- [Update Duo Nano to Duo Core](https://gitlab.com/gitlab-org/gitlab/-/commit/fb95c24e353724d375fdac67566cadf388dd0551) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189033)) **GitLab Enterprise Edition**
- [Always enable sorting for storage usage quotas](https://gitlab.com/gitlab-org/gitlab/-/commit/c400c43bf076145ab54c26d0ab4ff2af82a016b0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189158))
- [Add namespace and project metadata to application context for GLQL](https://gitlab.com/gitlab-org/gitlab/-/commit/810d3120df62314748e73ed2e5cdcaa70b212421) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186951))
- [Add merge_request_commits_metadata_id column to MRDC](https://gitlab.com/gitlab-org/gitlab/-/commit/653cb433e35d81584cc8a992e1aa49e3169f6db7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188985))
- [Log error message when managed resources fail to delete](https://gitlab.com/gitlab-org/gitlab/-/commit/fc600cfd8efdd4a6f8b67b6fd219772f5d12f61b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189103))
- [Add a new ResourceGroup process_mode: "newest_ready_first"](https://gitlab.com/gitlab-org/gitlab/-/commit/8829415364b69d20ab6178bb9b1f368e150cc2f2) by @BageDevimo ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188049))
- [Add infinite scroll to GitHub organizations box](https://gitlab.com/gitlab-org/gitlab/-/commit/aa5a167007e10d6427b3b563e70300a02a769447) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188177))
- [Add actor for static_licenses feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/b931f8c3663d6a3da6b0fe53751623e528188be9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187755)) **GitLab Enterprise Edition**
- [Add embedding1 field to workitems index](https://gitlab.com/gitlab-org/gitlab/-/commit/9035c425776b4397e6ccb4bf0242fc77f4554e99) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187493)) **GitLab Enterprise Edition**
- [Update environments to use token for websocket](https://gitlab.com/gitlab-org/gitlab/-/commit/0d89e83249730034c8eff554a34a9e179eea8868) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187325))
- [Updated EnforceDatabaseHealthSignalDeferral ignored list](https://gitlab.com/gitlab-org/gitlab/-/commit/2d6f4439cf25e4f03b69b88f3e530c3aea1a9044) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189019))
- [Improve help text for auto user deactivation](https://gitlab.com/gitlab-org/gitlab/-/commit/0823c4b56497423c2530d0991fb1fa579613fb42) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189017))
- [Bump CS and DS analyzer major version](https://gitlab.com/gitlab-org/gitlab/-/commit/e2bccff3b908a16c9c92735d46277956fc935a8c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188890))
- [Bump secrets analyzer major version](https://gitlab.com/gitlab-org/gitlab/-/commit/5f19592fbc44d5f06c4705399caea3484018e37f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188938))
- [Bump SD analyzer version to 7](https://gitlab.com/gitlab-org/gitlab/-/commit/88da03792ff3e862be065063c7fafb8574fe7fad) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188849))
- [Drop sequences for some ID columns in MRCM table](https://gitlab.com/gitlab-org/gitlab/-/commit/e14e7a8ee505b877af835e44ec26a405b0ca16cf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188978))
- [Track all workers concurrency jobs](https://gitlab.com/gitlab-org/gitlab/-/commit/3df4f6a885bf25a1716e8880b2f29c15ef7604df) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188415))
- [Runner detail: Delete action](https://gitlab.com/gitlab-org/gitlab/-/commit/193e2e19e8b47f850c3427110350eb529d150f87) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187838))
- [Add versioning support to routable token](https://gitlab.com/gitlab-org/gitlab/-/commit/8343330faa9b1d2143da7e402dd189ad69305917) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188441))
- [Package detail page: Move delete button into ellipsis menu](https://gitlab.com/gitlab-org/gitlab/-/commit/65b5b48d8b3cca6f8c50afed3cf513a1c4802e0b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188383))
- [Adds Rubocop rule to enforce worker deferral based on DB health](https://gitlab.com/gitlab-org/gitlab/-/commit/eb4188e3391f4ca6779fbdef55b7c663dcd427c6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187967))
- [Hide test button - GitLab for Jira app integration](https://gitlab.com/gitlab-org/gitlab/-/commit/92a53169844982eebd9d71f3dd261b10fbcb24af) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188934))
- [Move social accounts into their own section](https://gitlab.com/gitlab-org/gitlab/-/commit/8108b14b006fcc89df21b139198918371d5bc02f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188918))
- [Rename Duo Nano to Duo Core](https://gitlab.com/gitlab-org/gitlab/-/commit/c421cfd65fba2a6f61a646142fdeaa6a86881967) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188898)) **GitLab Enterprise Edition**
- [Skips processing dormant members when deactivated](https://gitlab.com/gitlab-org/gitlab/-/commit/77ab6ec4e2367f043d818e3982e0b22ca04fac58) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188906)) **GitLab Enterprise Edition**
- [Update openapi docs](https://gitlab.com/gitlab-org/gitlab/-/commit/93288653ea518900b0b9d61752881cdf74078ce2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188901))
- [Validate seat assignable add-on](https://gitlab.com/gitlab-org/gitlab/-/commit/b699bbc847c1e8ca03bf2caabaed69059321ba48) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188457)) **GitLab Enterprise Edition**
- [Limit the number of concurrent exports in progress](https://gitlab.com/gitlab-org/gitlab/-/commit/b029619550b320b3e36ebe5760c2982e9e7c8777) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187017)) **GitLab Enterprise Edition**
- [Add security_policy_id to compliance_framework_security_policies](https://gitlab.com/gitlab-org/gitlab/-/commit/092df0302039f127eac77063fbf3492803bf92e7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186097)) **GitLab Enterprise Edition**
- [Dry'd check for increase in billable count](https://gitlab.com/gitlab-org/gitlab/-/commit/2cf55d6bf92354972e52245ffae5b5bb1c564383) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188406)) **GitLab Enterprise Edition**
- [Change DuoNano to DuoCore](https://gitlab.com/gitlab-org/gitlab/-/commit/7c735db83ad663fde162825eaccfba33c95d8cab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188854)) **GitLab Enterprise Edition**
- [Align API Discovery CI templates with other AST features](https://gitlab.com/gitlab-org/gitlab/-/commit/6b4d207423357a91684767b87c4d24b4f88eaad8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188334))
- [Upgrade Hugo project template](https://gitlab.com/gitlab-org/gitlab/-/commit/e64f7f5cd3e4fc6ebc98a9014a1b8bf054b9293f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188878))
- [Adjust code to work with static licenses catalogue](https://gitlab.com/gitlab-org/gitlab/-/commit/06e1114b7ff140b5331d67b617eddff5d387bd21) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180013)) **GitLab Enterprise Edition**
- [Update `r` key shortcut behaviour on Work Items](https://gitlab.com/gitlab-org/gitlab/-/commit/dc66fa7302f975d1cce494180c6467dac103ec69) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188620))
- [Remove fix_gmail_footer_truncation feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/f79c61f1b70f1d354bd4faba216bdaab078fb832) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188819))
- [Remove confidentiality relocation sidebar stub](https://gitlab.com/gitlab-org/gitlab/-/commit/20342f5e6e0d0ce9c7556436f6ecaec87e8dc916) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188292))
- [Rename search admin UI checkboxes and update relevant documentation](https://gitlab.com/gitlab-org/gitlab/-/commit/51d6e13eac86fe62ed58708fa0476265a17f32fb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188763))
- [Cleanup FF enable_secrets_provider_check](https://gitlab.com/gitlab-org/gitlab/-/commit/fc51977b4cbe0f0fa0067b9513eaba9be892cc6d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188767)) **GitLab Enterprise Edition**
- [Remove beta status from block seat overages for .com](https://gitlab.com/gitlab-org/gitlab/-/commit/3b3d9de12bc9c3255d63291ba6b635fa28c8867f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185946)) **GitLab Enterprise Edition**
- [Remove beta status for BSO self-managed](https://gitlab.com/gitlab-org/gitlab/-/commit/df6340a0e60b76b0f8570f23c752b9130cad82e5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185949)) **GitLab Enterprise Edition**
- [Introduce subscriptions refactor](https://gitlab.com/gitlab-org/gitlab/-/commit/2747252b8d17d1377b7a4d92d264b76e8a85f3fc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/142336))
- [Change user authorization to use terms query for projects](https://gitlab.com/gitlab-org/gitlab/-/commit/c6ae8d6e34d5457ba372ec5c2f89b875f2e11f6c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187862)) **GitLab Enterprise Edition**
- [Default `scan_execution_policies_action_limit` setting to 0](https://gitlab.com/gitlab-org/gitlab/-/commit/eda9d36fbe015ee14f9898b05d995324dc968747) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187866)) **GitLab Enterprise Edition**
- [Crud: Change loading state to use skeleton loader](https://gitlab.com/gitlab-org/gitlab/-/commit/620f2bd65c66a7531c055e912b726b3358e68d20) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188246))
- [Use read replica for GLQL queries if available](https://gitlab.com/gitlab-org/gitlab/-/commit/4f334e0dc5021c55749f6be7bf0c9085bb6a60c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188245))
- [Make license version optional](https://gitlab.com/gitlab-org/gitlab/-/commit/5ad0b79f9320240190977eafe08067b87588699f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188194)) **GitLab Enterprise Edition**
- [Move branch rules alert into settings block](https://gitlab.com/gitlab-org/gitlab/-/commit/220b066367ab4374bc7dbbb3aeb5e0a440df5104) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188446))
- [Default backdated timelogs to midday (12:00)](https://gitlab.com/gitlab-org/gitlab/-/commit/28e6f1e5d439b1b38a9b0efe7cd388b083ed6df8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188269))
- [Update alignment of package registry page](https://gitlab.com/gitlab-org/gitlab/-/commit/cd05e6d7b0cde619d26395b9b719f8b882598aec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188159))
- [Allow specifying the organization for an Internal User](https://gitlab.com/gitlab-org/gitlab/-/commit/7fb8a73a32ab58113b33b0d24f60ed48e6f8ba89) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186690)) **GitLab Enterprise Edition**
- [Update reachability to only be present for](https://gitlab.com/gitlab-org/gitlab/-/commit/aafb7d0ce03ef4c86c842c374d44c446053f9868) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188437)) **GitLab Enterprise Edition**
- [Model registry: Improve upload artifacts of assets](https://gitlab.com/gitlab-org/gitlab/-/commit/017836b75e7d9dd132b4fbd9ab73566a7e26fca2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188417))
- [Add MR pipelines support to Container Scanning CI template](https://gitlab.com/gitlab-org/gitlab/-/commit/b1111dd9571def61d409268eb71aeb36812860b2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188416))
- [Added registry setup instruction for group level endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/18658d1039457b2485f706fc3aab4f8bb0219805) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187556))
- [Add UpdateTroubleshootJobEventsPrimaryKey migration](https://gitlab.com/gitlab-org/gitlab/-/commit/f98358dc9548a5f79adcdb11c171e9a7a8527a88) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188341))
- [Finalize semver_patch conversion to bigint in terraform module metadata](https://gitlab.com/gitlab-org/gitlab/-/commit/dd80a0fc4421a2881049e173b3bcd50620c14a47) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188297))
- [Only refresh seat assignable add-on](https://gitlab.com/gitlab-org/gitlab/-/commit/465c1a8e21cf5902daa72c3d528a19a43a5dd045) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188114)) **GitLab Enterprise Edition**
- [Package group settings: Cleanup settings](https://gitlab.com/gitlab-org/gitlab/-/commit/4e2bd3462d9f06e03bc6a94b0ca36fe02d8a46ae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188221))
- [Package detail page migrations](https://gitlab.com/gitlab-org/gitlab/-/commit/0d1e25e9e1a560e4d60f23f25240f297bd0d82cd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188277))
- [Set some columns in MRDC to be nullable](https://gitlab.com/gitlab-org/gitlab/-/commit/475a5cc031de9ee7f045748dd3fcec6f1a4acf5b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188358))
- [Update the permalinkPath description](https://gitlab.com/gitlab-org/gitlab/-/commit/32ab3da21ade848361171d4f31f5b968c864fd2b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188111))
- [Improve styling of user calendar activities](https://gitlab.com/gitlab-org/gitlab/-/commit/c9a92c0e38fb673f048a7acb9eba43cd4028e3ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188342))
- [Add MR pipelines support to Container Scanning CI template](https://gitlab.com/gitlab-org/gitlab/-/commit/5e12b5d97d5764a8dd96446f17e01c100e0f3914) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188283))
- [Return a success status when stopping an already stopped environment](https://gitlab.com/gitlab-org/gitlab/-/commit/020d342bdf1924fa928fbf6990963897fa168741) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187790))
- [Update DrawIO media bubble edit button copy](https://gitlab.com/gitlab-org/gitlab/-/commit/5e989241a53109ef1e9a969ae0e4c68636a2a08a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188311))
- [Migrate `.setting-message` to Pajamas alert component](https://gitlab.com/gitlab-org/gitlab/-/commit/9f225a36ac4a7d5d266341b5c6fd3dc8ae28cc33) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187870))
- [Updated supported CWE list for Vulnerability Resolution](https://gitlab.com/gitlab-org/gitlab/-/commit/7fa2546309ea021231bf629f99c48a26031137f8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188270)) **GitLab Enterprise Edition**
- [Reorder routable token's base-64-payload](https://gitlab.com/gitlab-org/gitlab/-/commit/07ee3242ea2ab7ab07f03794a5cb48e24027d570) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188255))
- [Container registry cleanup policies: Migrate to Crud](https://gitlab.com/gitlab-org/gitlab/-/commit/0ef220b2ca95cc40199a6a24b8a44a1a89c3627e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188239))
- [Allow vertex embeddings model to be passed in](https://gitlab.com/gitlab-org/gitlab/-/commit/848ba8ada9a23513d40bbf27b6fda89d239c80ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187481)) **GitLab Enterprise Edition**
- [Update project runners update page](https://gitlab.com/gitlab-org/gitlab/-/commit/d30957e6606f0a17485711b7f31d21b856b8088f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187360))
- [Improve policy bot message for pipeline failures](https://gitlab.com/gitlab-org/gitlab/-/commit/de8ecdc863d400f40f142fed65fe72701ff7ea93) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187841)) **GitLab Enterprise Edition**
- [Support dynamic predefined question prompts on Duo Chat](https://gitlab.com/gitlab-org/gitlab/-/commit/a6bcc6f672e3710057170e48c16f18c8b9c57e4b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187605)) **GitLab Enterprise Edition**
- [Allow shift key in sidebar shortcut](https://gitlab.com/gitlab-org/gitlab/-/commit/fd20c9c7458eec2ccc0ccebb910f9f38655cfb75) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187613))
- [Remove resolve_vulnerability_with_ai flag](https://gitlab.com/gitlab-org/gitlab/-/commit/7ad2ca0f7fa936dc886811820bb4bc0fefa08847) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185452)) **GitLab Enterprise Edition**
- [Remove incorrect docs link shown for push rule file size limit](https://gitlab.com/gitlab-org/gitlab/-/commit/528d1fb39fb3202851612107fa0cb0533414b6eb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187085)) **GitLab Enterprise Edition**
- [Remove SafelyChangeColumnDefault concern from topics](https://gitlab.com/gitlab-org/gitlab/-/commit/ec8b48ce292cb412a8675fbc189413af6026a5e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188109))
- [Organization switcher: Decrease spacing](https://gitlab.com/gitlab-org/gitlab/-/commit/d4f0b4c6bed8a938d4e7daacd481e567d6e58bd4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188097))
- [Only show convert_to_ticket quick action when Service Desk enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/947c63bda11d33f964b22094fc274ce3217b8cc6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187684))
- [Update Q settings link to Amazon Q console to create profile](https://gitlab.com/gitlab-org/gitlab/-/commit/d4b45501d5c7e8f3d8bf0f8e223abcc15270845d) by @katwal ([merge request](https://gitlab.com/foo/bar/-/merge_requests/187968)) **GitLab Enterprise Edition**
- [Fix alert icon size](https://gitlab.com/gitlab-org/gitlab/-/commit/e611464504f926c65ddb5540c0c4cb49733a3a63) by @yonghyun.jin13 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185525))
- [Wrap multiline selection to collapsible section](https://gitlab.com/gitlab-org/gitlab/-/commit/6dd7fbe6884183e495987021dbf6697ed6541b17) by @Bubbis ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187756))
- [Enabled exclude_license_packages feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/68134330c634be993f56c1e2b3ce4481c4b7bd58) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187896)) **GitLab Enterprise Edition**
- [Remove docker hub alert](https://gitlab.com/gitlab-org/gitlab/-/commit/8b1cf20bceee5175e4b1ca7e8b8283da4f606a6c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187160))
- [Add Prometheus histogram for scheduled pipeline execution scheduling](https://gitlab.com/gitlab-org/gitlab/-/commit/d17c87d18802f9dd7b54ac09058cb39783f1a8f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187843)) **GitLab Enterprise Edition**
- [ActiveContext: add query to get all results](https://gitlab.com/gitlab-org/gitlab/-/commit/024a3a907f082f0340b2726d98e2bde0ec414bed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187687))
- [Convert hover overlay text to focus interaction](https://gitlab.com/gitlab-org/gitlab/-/commit/7436e021e3487c05556a1c7abec2ea1b39af1abe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187410))

### Deprecated (1 change)

- [Ignore project_fingerprint and removed usages](https://gitlab.com/gitlab-org/gitlab/-/commit/271e059b63124fa61e3320219ccdd0e579245d49) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185329)) **GitLab Enterprise Edition**

### Removed (35 changes)

- [Delete the `zoekt_index_circuit_breaker` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/6e5d3f3ba98abe9d99100fef9dd28d8a2649662b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190328))
- [Remove Twitter identities](https://gitlab.com/gitlab-org/gitlab/-/commit/ff03bf95e376d1ba0b559d80779af209eff03ca9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188411))
- [Disable Limit CI_JOB_TOKEN access scope feature](https://gitlab.com/gitlab-org/gitlab/-/commit/7e80ac2cebd2bbd6f0a2a7d81bfa5b81190812c1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189748))
- [Drop support for scan_result_policy in backend](https://gitlab.com/gitlab-org/gitlab/-/commit/ac07348b861c97fb3389665e86b8b6646a214a12) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189581)) **GitLab Enterprise Edition**
- [Remove feature flag custom_ability_admin_protected_environments](https://gitlab.com/gitlab-org/gitlab/-/commit/d88ab3e0071481907e0072ab9659ffed764a15dc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190209))
- [Removes FF mr_show_reports_immediately](https://gitlab.com/gitlab-org/gitlab/-/commit/ecd85c4cc3bbd62857a874f351890ec0634d0c8a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190287))
- [Remove work item type old ID fallback](https://gitlab.com/gitlab-org/gitlab/-/commit/7c2bcdb4d7933572e2acc6afdaed1e6131f3c5ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190215))
- [Remove IssuesBulkUpdate mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/f6cc9fa0ec0235bf92835ba722c5d59b0bc50e17) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187694))
- [Remove prompt migration feature flags post completion](https://gitlab.com/gitlab-org/gitlab/-/commit/61c538cae1e4bcd0f3dda1a8ea49e176641c4e2d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183439)) **GitLab Enterprise Edition**
- [Remove Pages Project templates](https://gitlab.com/gitlab-org/gitlab/-/commit/a6795a45ecf8e9335557ab851c97756696077da4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188791))
- [Delete the `zoekt_optimized_performance_indexing` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/887fdc29de6503a26c4fdf753fab20c86af926fe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188860))
- [Remove project limit from the dependency list](https://gitlab.com/gitlab-org/gitlab/-/commit/c25dc285783854b6434844ce656edbbbe62738e9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189797)) **GitLab Enterprise Edition**
- [Remove deprecated Terraform CI/CD templates](https://gitlab.com/gitlab-org/gitlab/-/commit/e9ba0927821d0764e0d232dc0a8f1c1b35e694ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190011))
- [Disable Limit CI_JOB_TOKEN access scope feature](https://gitlab.com/gitlab-org/gitlab/-/commit/2392d6cc1e704862fc397692214fd21915afdc5b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189028))
- [Cleans up code_suggestions_include_context_imports ff](https://gitlab.com/gitlab-org/gitlab/-/commit/c194646447f8c02a5706329920976240ecbff6fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189008))
- [Remove Usage model references from create service](https://gitlab.com/gitlab-org/gitlab/-/commit/2120f002b677cb37b9168a905d08288b611186fe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189583))
- [Remove the references of trigger_request](https://gitlab.com/gitlab-org/gitlab/-/commit/b5de9978de0b357aa91319efe5e76d0ec1ccb983) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188425))
- [Delete the `elastic_migration_worker` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/be68eedcca56dd54eae850bc855a1abfd088ae61) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187543))
- [Remove deprecated Geo VerificationWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/88acf56f22eb07d7382522e84f2507849fd362f9) by @karras ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188390)) **GitLab Enterprise Edition**
- [Remove GraphQL Namespace addOnPurchase Field](https://gitlab.com/gitlab-org/gitlab/-/commit/bc50056906ea630c741ba69ec5e0f5820a63d012) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189066)) **GitLab Enterprise Edition**
- [Remove the tmp index for p_ci_builds.trigger_request_id](https://gitlab.com/gitlab-org/gitlab/-/commit/c818a17cd4bfcfa26b4774c1533fd7c1a0afc7e6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189122))
- [Remove GraphQL addOnPurchase Query](https://gitlab.com/gitlab-org/gitlab/-/commit/a1165d156f2cb3bf1d5cc852cb720bfbf2fc74f5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189053)) **GitLab Enterprise Edition**
- [Merge `more_commits_from_gitaly` FF into `commits_from_gitaly`](https://gitlab.com/gitlab-org/gitlab/-/commit/76894daa835a9771e6ce4ecf987ca8c34d0578b8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189188))
- [Remove feature flag cloud_connector_new_token_impl](https://gitlab.com/gitlab-org/gitlab/-/commit/a09148ab8d66905c936934d4c2e294706e9accfd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189177)) **GitLab Enterprise Edition**
- [Remove feature flag ci_only_one_persistent_ref_creation](https://gitlab.com/gitlab-org/gitlab/-/commit/b2a902e297ae43359e2405ba007e139a983c2d09) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187651))
- [Remove custom scan action from policy schema](https://gitlab.com/gitlab-org/gitlab/-/commit/08de8107f348e29e38eb60c58f5b27bac31cdb43) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188580)) **GitLab Enterprise Edition**
- [Remove ff ci_read_trigger_from_ci_pipeline](https://gitlab.com/gitlab-org/gitlab/-/commit/9d914765d21194ec6b1dfd858d27f585a5271d75) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182226))
- [Mark the migration as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/adecf9a8dce8db9126a48cab2602b515d9f84bea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188747)) **GitLab Enterprise Edition**
- [Clean up ai_duo_chat_switch feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/0127042ba071e8342be496a36b48979e5600333c) by @aryandutt ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188728))
- [Remove unused #wiki_page_version_author_avatar](https://gitlab.com/gitlab-org/gitlab/-/commit/8341c8ae334691b1efd64209fb97bf39a6254665) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188184))
- [Remove GraphQL `name` field in CiMinutesProjectMonthlyUsage](https://gitlab.com/gitlab-org/gitlab/-/commit/f4d60ddb5e379e7b03323115689d40dccac921b2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188402)) **GitLab Enterprise Edition**
- [Remove GraphQL `STORAGE` enum in NamespaceProjectSortEnum](https://gitlab.com/gitlab-org/gitlab/-/commit/ae9fed7232b64f544fe8506edab88d14d214bfec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188395)) **GitLab Enterprise Edition**
- [Remove secret_checks_for_web_requests FF](https://gitlab.com/gitlab-org/gitlab/-/commit/df805dc42363ea683d7ba4db706c9f9845f1e5d0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187433))
- [Remove project from the group settings sidebar menu](https://gitlab.com/gitlab-org/gitlab/-/commit/53a72684c02d4f335ca633579f459f7a15ddba05) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188204))
- [Remove duo redirct banners from general settings](https://gitlab.com/gitlab-org/gitlab/-/commit/0c537d2afba4c68abe9c00dcfcd40645cc275a30) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186616))

### Security (7 changes)

- [Improve Octokit::ResponseValidation middleware and add rate limits](https://gitlab.com/gitlab-org/gitlab/-/commit/803ab95a2f20364ecdfdf4a74461bcb9db5edc61)
- [Remove id attribute from OAuth form](https://gitlab.com/gitlab-org/gitlab/-/commit/74620473c5a7d686aafd7792eb0574d9a80d75db)
- [Use IssuePolicy for #issues_readable_by_user](https://gitlab.com/gitlab-org/gitlab/-/commit/542b1da9d89d43450d87752ff09658140d4a3b71)
- [Security unauthorized access to reading branch names](https://gitlab.com/gitlab-org/gitlab/-/commit/65394fc44e4dfb185258c628916488d77dee9781) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189728))
- [Add SecureHeaders middleware with the Nel header](https://gitlab.com/gitlab-org/gitlab/-/commit/fec5ba732d37c690a188a46e7d490bd308995b1e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189728))
- [Restrict forwarded headers in Maven dependency proxy](https://gitlab.com/gitlab-org/gitlab/-/commit/424e4908341e3d1cf757b3d305d757a49854765b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189728))
- [Simplify detecting paragraphs for quick actions](https://gitlab.com/gitlab-org/gitlab/-/commit/35a1349e156cdd95d6bbbdf3fd1a4e5c319f77b2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189728))

### Performance (11 changes)

- [Delete environments in batches to fix project.destroy! timeout](https://gitlab.com/gitlab-org/gitlab/-/commit/0df2c5a997d0594195a5d58464358ba3d59d0084) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190497))
- [Use bulk_perform to trigger security policy sync](https://gitlab.com/gitlab-org/gitlab/-/commit/698bdad2fbab6598d41538a52564882ebde90822) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190046)) **GitLab Enterprise Edition**
- [Optimize issues banned users query](https://gitlab.com/gitlab-org/gitlab/-/commit/edbe1d7944f696480c0cc05d3e482773da951437) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190314))
- [Delete commit status in batches](https://gitlab.com/gitlab-org/gitlab/-/commit/333534540a325d030963ebb48bf738f9d988ac84) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190311))
- [Drop web_hook_logs table](https://gitlab.com/gitlab-org/gitlab/-/commit/8f0302498e76dcc130876eeaeb7c787fa76fdb83) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189420))
- [Prevent timeout in cancel pipeline query during project deletion](https://gitlab.com/gitlab-org/gitlab/-/commit/f168f87c2911b25473eeb8a342fab6ae510185a3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189295))
- [Clean up group_microsoft_applications_table FF](https://gitlab.com/gitlab-org/gitlab/-/commit/c704831c9d02f2f567062e04c63762ef164b9ad2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182829)) **GitLab Enterprise Edition**
- [Enable reindexing FF by default](https://gitlab.com/gitlab-org/gitlab/-/commit/6fe07e5bdf5b1d38c0c917a6533d167d365f16b2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188548))
- [Use web_hook_logs_daily](https://gitlab.com/gitlab-org/gitlab/-/commit/db6b93b4d12f8a378cb7ff6539c6d1b7140376a1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188880))
- [Apply InOperatorOptimization to relative_position](https://gitlab.com/gitlab-org/gitlab/-/commit/e7d33dab700d2b579d732f3870fd0cd25ece639c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187894))
- [Reduce merge request diff batch size for keep-around rake task](https://gitlab.com/gitlab-org/gitlab/-/commit/0b086fc92a383048e169f5bdfebe6b13f336a133) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187451))

### Other (174 changes)

- [Remove duo_code_review_chat feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/c14aada20e4fca2d8d94adc403451cc6f6d83814) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190640)) **GitLab Enterprise Edition**
- [refactor: Consolidate tests for CheckRuleExistenceService](https://gitlab.com/gitlab-org/gitlab/-/commit/9995b824a2975ecb3a687f08a2cc4e0147afa207) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188135))
- [Document how to troubleshoot missing files on the Geo primary site](https://gitlab.com/gitlab-org/gitlab/-/commit/4e53c102e6e0c719f5c09334c815a21eb6ffc692) by @karras ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188195))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/b94e4afc436fbdbe939db0c1f338f88fc161243f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190201))
- [Return ServiceResponse for Generic::CreatePackageFileService](https://gitlab.com/gitlab-org/gitlab/-/commit/e07a06484083350e6b72255e0261e58d0294a9e2) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189754))
- [Synchronously remove unused index_merge_request_diffs_on_project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/040a6b8e1fefbb46f0f4ece4ee27e9105e84640e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190763))
- [Remove ai_review_merge_request feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/e07eee6f089b138a66d654635afd2c6d7f12a1dc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190639)) **GitLab Enterprise Edition**
- [Drop index (expire_at, job_id) from p_ci_job_artifacts](https://gitlab.com/gitlab-org/gitlab/-/commit/26fc74d4d1bfbd613a47355c4123b05824f8079b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189532))
- [Remove feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/9b8623c0be69bfb4bdc491c85e59a81d45d0a9ad) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189923))
- [Clean up feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/7e41dbb49aa133ca5eae0406d4f2f5b569b9a37b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190732)) **GitLab Enterprise Edition**
- [Feature flag cleanup](https://gitlab.com/gitlab-org/gitlab/-/commit/e3fa954bd7584e457fb7eb1e271d3d7d5cc23265) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190727)) **GitLab Enterprise Edition**
- [Workhorse: set metrics labels for external URLs](https://gitlab.com/gitlab-org/gitlab/-/commit/e8122ac903c187ee282926a4358c38330d28c07e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187163))
- [Clean up sum vulnerability count feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/81a477c4f7642776697277e5e08bd618652d463b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190718)) **GitLab Enterprise Edition**
- [Revert MR 187612 until DB query is resolved](https://gitlab.com/gitlab-org/gitlab/-/commit/f4eb8c965e5b786081a817f42ba65d10d30c8b50) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190708))
- [Finalize BBM MarkDuplicateMavenPackagesForDestruction](https://gitlab.com/gitlab-org/gitlab/-/commit/be944c01ce5fde3079e2d2dcb84a6f22c2ac718b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190695))
- [Add sent_notifications.namespace_id column](https://gitlab.com/gitlab-org/gitlab/-/commit/eb5a1a060d16c6ee8957d024072c23d1a687953b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190671))
- [Disable product usage data for offline license](https://gitlab.com/gitlab-org/gitlab/-/commit/c266afd050e25722349375590af22d6c2e853c73) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190005))
- [Change schema for pipeline_variables](https://gitlab.com/gitlab-org/gitlab/-/commit/65512474f0e7c8e9add9a3cb2c034c9ecc36be64) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187555))
- [Sync translations from crowdin (2025-05-08)](https://gitlab.com/gitlab-org/gitlab/-/commit/72f460898a7664942e27bde268bc3f614ab0124c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189436))
- [Remove duo_code_review_claude_3_7_sonnet Feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/6a143afc9eb6d9ef9df71b4ad1b21360a07fc47e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190644)) **GitLab Enterprise Edition**
- [Remove generate_commit_message_claude_3_7 Feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/c3a8e7d0ef1ef5629690188a0a3a3c09b82445b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190643)) **GitLab Enterprise Edition**
- [Remove fallback for Current.organization&.id in groups controller](https://gitlab.com/gitlab-org/gitlab/-/commit/5b7558c0d8d47db49992552b7376c0cf7cdbb9b6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190091))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/1f28c5bb966e053ed3770e25f9fc80478dad060f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190622))
- [Finalize BBM BackfillProtectedBranchMergeAccessLevelsProtectedBranchProj](https://gitlab.com/gitlab-org/gitlab/-/commit/e47d3e7d0d5783a6036d0f986f1226b4b9c60a11) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190603))
- [Remove usage of default organization in Certificate](https://gitlab.com/gitlab-org/gitlab/-/commit/c3d6a97e1eb047c4f4bd10c085667dc436501af0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189720))
- [Remove new_milestone_filtering_logic flag and use new behaviour globally](https://gitlab.com/gitlab-org/gitlab/-/commit/28a43d0bde21b2f5d54dd10336c8a7af13e0f41a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189988))
- [Remove group_vulnerability_scanners_using_statistics FF](https://gitlab.com/gitlab-org/gitlab/-/commit/d7b878e87d7101ae64c2f09b8323b4812dd70574) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190559)) **GitLab Enterprise Edition**
- [Update CI partitioning threshold to 1TB](https://gitlab.com/gitlab-org/gitlab/-/commit/9bb3e3509aedfa77477643a75398c4855d81e7e1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190547))
- [Copy global push rule to organization push rules](https://gitlab.com/gitlab-org/gitlab/-/commit/feacf6441fc75780c07d071f61fce0750e4dcd52) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190258))
- [Remove `commit_message_logger` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/b1a6b1634fa5efa7125db5bf983b5edf2fb54651) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190474))
- [Add sent_notifications.created_at column](https://gitlab.com/gitlab-org/gitlab/-/commit/4d8f994f6baf6b5f7ba81ead0b085547b17de776) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186703))
- [Drop taggings table](https://gitlab.com/gitlab-org/gitlab/-/commit/5c0147c02cae9e716a32b94b317fe5b32c08f560) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179404))
- [Ignore resource_label_event columns](https://gitlab.com/gitlab-org/gitlab/-/commit/73dadd9740897317d8b16b3e9343bd8db57957be) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190451))
- [Add migration to set rate limits to zero for self-managed instances](https://gitlab.com/gitlab-org/gitlab/-/commit/85c1b58a32f08d8e756765a7f074e85a2fe66a2f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189906))
- [Replace ff with admin setting](https://gitlab.com/gitlab-org/gitlab/-/commit/c30a5443517fb904d4aaf3e0d26d02fa470226c9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190090))
- [Drop siphon_issues.correct_work_item_type_id from CH](https://gitlab.com/gitlab-org/gitlab/-/commit/121c061b14e1fc2350b0858d11e0100b22726507) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190384))
- [Remove correct_work_item_type_id from work item index](https://gitlab.com/gitlab-org/gitlab/-/commit/b8a98c407e4622578d2ae694913e7ae19a8a274c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190211)) **GitLab Enterprise Edition**
- [Improve Geo post-failover clean up documentation](https://gitlab.com/gitlab-org/gitlab/-/commit/e95eb824b9f4887ee93935df56c705d28945357e) by @karras ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190302))
- [Add NOT NULL for sharding key on issue_email_participants](https://gitlab.com/gitlab-org/gitlab/-/commit/58ceeb4876c4dc88f889f402e6fef9502cc6ebb2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189213))
- [Finalize DeleteOrphanedGroups batched background migration](https://gitlab.com/gitlab-org/gitlab/-/commit/c38090702f974e7292a01d0ecdf5346c4fd9aa94) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190315))
- [Add a new cop to prevent explicit calls for enable_lock_retries!](https://gitlab.com/gitlab-org/gitlab/-/commit/02ae50d009ead802a1bac9d7029b2192d3913d75) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189306))
- [Reindex Elasticsearch note index to update integer with long type](https://gitlab.com/gitlab-org/gitlab/-/commit/bd3f3d7bd3ade9ff51536779c6e9c2fc185edc48) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189649)) **GitLab Enterprise Edition**
- [Remove populate_and_use_build_source_table feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/c6108347f7e861de29b919264fdd821d1d9fcb05) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190164))
- [Remove ci_enable_live_trace flag](https://gitlab.com/gitlab-org/gitlab/-/commit/fde6743cbeb8ea81efafc0d67781c70204a2d491) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189232))
- [Finalize BBM BackfillIssueLinkIdOnRelatedEpicLinks](https://gitlab.com/gitlab-org/gitlab/-/commit/9f54feb3cdd12e7051153f742e320dcff5eabfeb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189979))
- [Create the temp index for notes project null sync](https://gitlab.com/gitlab-org/gitlab/-/commit/1735007671a453f4063aefe0c5c6753abd5fec3b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189423))
- [Backfill DuoCore AddOnPurchase for existing subscription](https://gitlab.com/gitlab-org/gitlab/-/commit/318fbf44554896f5eb5ff40325016f962f90dd8b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188884)) **GitLab Enterprise Edition**
- [Run ConcurrencyLimitSampler once per interval](https://gitlab.com/gitlab-org/gitlab/-/commit/0e17b5831b2d3f9576c4274c35e9a2cde990b1bb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189327))
- [Add and fill resource_iteration_events group](https://gitlab.com/gitlab-org/gitlab/-/commit/bcc9e05e0bc3781e2ad554436077f04da898f5a6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187487))
- [Remove model-level validation for sharding key in issue_assignment_event](https://gitlab.com/gitlab-org/gitlab/-/commit/36bdcdfb95dda260903f7da275373c25acaec414) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189989))
- [Finalize BBM BackfillIssueUserMentionsNamespaceId](https://gitlab.com/gitlab-org/gitlab/-/commit/e51e07d4695bd1aa646810684ba55c88c6bc8fa8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189982))
- [Adds todo notification for self-managed enabling duo core features](https://gitlab.com/gitlab-org/gitlab/-/commit/836771dfc7eebd991134e3c7d62e9c691469c261) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189524)) **GitLab Enterprise Edition**
- [Finalize migration BackfillGroupWikiRepositoryStatesGroupId](https://gitlab.com/gitlab-org/gitlab/-/commit/dad6751839382633da4cd9c0b47b78fd293e595a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186910))
- [Drop unused indexes from issues table](https://gitlab.com/gitlab-org/gitlab/-/commit/42d4042f979586cb46a948289b03605376957cfd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189484))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/551d68d6840fe1b852a36e1bf997bb5ca17d452a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188947))
- [Remove safe navigation operator from Current.organization.id references](https://gitlab.com/gitlab-org/gitlab/-/commit/1b5bdb97f804f57d3054984eedbff9adb9b0dfb1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189118))
- [Add not NULL constraint to fork_networks](https://gitlab.com/gitlab-org/gitlab/-/commit/065d98ac34614613aa1a4aa3093cff2f03a0ac2a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188272))
- [Upgrade Jekyll project template](https://gitlab.com/gitlab-org/gitlab/-/commit/98aa3c3418b5c65613dd688c760ce0bedda5e632) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189764))
- [Add NOT NULL constraint on design_management_versions.namespace_id](https://gitlab.com/gitlab-org/gitlab/-/commit/0f206af6308ecd820a8c7871130f187579493e2e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177369))
- [Adds todo notification for self-managed enabling duo core features](https://gitlab.com/gitlab-org/gitlab/-/commit/bdb745981bbd2c047234f241d9ac97c4c1ac21d6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189490)) **GitLab Enterprise Edition**
- [Truncate p_ci_build_trace_metadata partition 102 on .com](https://gitlab.com/gitlab-org/gitlab/-/commit/288aeaa795481dcbcc748d9a1c0f3a421e69c80b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189719))
- [Change plan card styling for trial billing page](https://gitlab.com/gitlab-org/gitlab/-/commit/5d4bda16173052d927e7f5a5d0368f0d3f1bf3df) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189379)) **GitLab Enterprise Edition**
- [Make pipeline cleanup limits configurable](https://gitlab.com/gitlab-org/gitlab/-/commit/ff0b38df1d72489b441f400c5d1f538076f4e9d8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189191))
- [Finalize migration BackfillPipelineExecutionPoliciesConfigLinks](https://gitlab.com/gitlab-org/gitlab/-/commit/0b75e02bbd4a6dd227948054f2fcf2b97e43afe5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189601))
- [Finalize BBM BackfillIssueEmailsNamespaceId](https://gitlab.com/gitlab-org/gitlab/-/commit/06de2463129cb6ccdcea8271ec6002d5dac7f968) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189242))
- [Step-up auth: Use NamespacedSessionStore for accessing session data](https://gitlab.com/gitlab-org/gitlab/-/commit/d5b9612a3e7e50abd248e6f608691cc8ea2171b2) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186803))
- [Drop ci_runner_machines_archived table](https://gitlab.com/gitlab-org/gitlab/-/commit/4eca3b07655ac32d5ea2ef592ff5ed3ae265aaa5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189308))
- [Add FF switch to fetch contributions data from new CH tables](https://gitlab.com/gitlab-org/gitlab/-/commit/01635c1f003e68e232ab9c0d022da5f7468a3253) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187192)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/aa67e01fd76ad8d23b8c3f0f910da14f3f0b3f6c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189567))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/14510d99c367089e3b4c0daa1de43a9902520143) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189565))
- [Include ability checks for advanced vulnerability management using ES](https://gitlab.com/gitlab-org/gitlab/-/commit/8da9b6023903673e25017062de19acb795f75f26) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189291)) **GitLab Enterprise Edition**
- [Validate NOT NULL constraint on ci_build_needs.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/8b766650353ed8b64463a06f6c552407aa26b650) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187236))
- [Add a new POST heartbeat endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/83d7680f0beeed096dbb547499174199b616012c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188994)) **GitLab Enterprise Edition**
- [Streamline Project#archived? to hide deletion-related logic](https://gitlab.com/gitlab-org/gitlab/-/commit/64e1c420231ef4d4472c99149643ba323d4d7a42) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188545))
- [Set search_uses_match_queries as default true](https://gitlab.com/gitlab-org/gitlab/-/commit/a5e837e6d0a896a783aed44408e19b861ec08813) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189405)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/903cc6fcd98a007427d827981a685ae1c60e488e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189401))
- [Finalize the finish onboarding for group saml backfill](https://gitlab.com/gitlab-org/gitlab/-/commit/7f0ad9063b18793f59ae616f0b2b8471afd744ac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187716))
- [Remove FF hide_merge_requests_from_banned_users](https://gitlab.com/gitlab-org/gitlab/-/commit/3d8542ada0be39bdd29ddd65fd85b1884efc1a38) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188770)) **GitLab Enterprise Edition**
- [Improve custom template logging](https://gitlab.com/gitlab-org/gitlab/-/commit/ad8601a67901d36852fb60f62e2524a1cff71634) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189135)) **GitLab Enterprise Edition**
- [Change ai_troubleshoot_job_events foreign key](https://gitlab.com/gitlab-org/gitlab/-/commit/a401a51b6a660be9b9172679a8dba7a261352367) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189004))
- [Ignore blank values in policy field comparison](https://gitlab.com/gitlab-org/gitlab/-/commit/d8511fe6642165e87494cde86ebc61e17c68b6a4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189319)) **GitLab Enterprise Edition**
- [Drop ci_runners_archived table](https://gitlab.com/gitlab-org/gitlab/-/commit/c7117f1d98ec28be7bc91107546db311e9b6fd9d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188902))
- [Add not-null constraint check for non-extensions settings](https://gitlab.com/gitlab-org/gitlab/-/commit/6552feea580a83b89fd41d46218e0e5b6128e1e1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186795))
- [Sync translations from crowdin (2025-04-25)](https://gitlab.com/gitlab-org/gitlab/-/commit/2e4043849b4da86a3ebaae1c217530d810c44e78) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189282))
- [Reindex Elasticsearch work items to update integer with long type](https://gitlab.com/gitlab-org/gitlab/-/commit/6077d421f24fd38afb2ea1e2bac48a2fccc8cf91) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189044)) **GitLab Enterprise Edition**
- [Remove p_ci_builds_metadata.runtime_runner_features column](https://gitlab.com/gitlab-org/gitlab/-/commit/1ea802ca1d00a02d5a1c14e77f59c187649ef4ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189271))
- [Add the retry rollout logic for failed namespaces](https://gitlab.com/gitlab-org/gitlab/-/commit/e4dab8d06cb4c0ee320efddb0733e94cb1cb2f94) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188249)) **GitLab Enterprise Edition**
- [Sync translations from crowdin (2025-04-24)](https://gitlab.com/gitlab-org/gitlab/-/commit/66feaee0c47079ade929bd946bc1f3672de39390) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188668))
- [Mark 20250113152652 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/9c796a43b47af7d6016263e2b42dbc2411fa5a6d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188694)) **GitLab Enterprise Edition**
- [Sync rules from read model on default branch change](https://gitlab.com/gitlab-org/gitlab/-/commit/a2a52e91087f4498eadcf4c3a910a52fcbde7a9f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188991)) **GitLab Enterprise Edition**
- [Reindex Elasticsearch merge request to update integer with long type](https://gitlab.com/gitlab-org/gitlab/-/commit/85028a7911e78ae19b76572d4a3fb3ee73f87b52) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188909)) **GitLab Enterprise Edition**
- [refactor: Avoid escaping characters in error message in package overview](https://gitlab.com/gitlab-org/gitlab/-/commit/f62690534e950c37d0c0b9810b5176a0c86b04b5) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189173))
- [Add NOT NULL for sharding key on issue_assignment_events](https://gitlab.com/gitlab-org/gitlab/-/commit/047a740e2602143ca9748b32baeeaeeb1190eef2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188803))
- [Set zoekt_critical_watermark_stop_indexing as default_enabled true](https://gitlab.com/gitlab-org/gitlab/-/commit/aad1e71e917cef1c5f1c27211db27681c6bb771f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188746)) **GitLab Enterprise Edition**
- [Mark 20241204115350 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/27a02a7a47a8faf416639cd663a90addacfe905a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188693)) **GitLab Enterprise Edition**
- [Remove mentions to enable_lock_retries! from docs](https://gitlab.com/gitlab-org/gitlab/-/commit/e9eda7a223e4e10d62f55edd78ce86734ed0500e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189063))
- [Conditionally show first name and last name fields on in-app trials](https://gitlab.com/gitlab-org/gitlab/-/commit/ca5980f2ef2927eca65750debf683fef2da5e5a2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188816)) **GitLab Enterprise Edition**
- [Lower retries for audit events worker to 3](https://gitlab.com/gitlab-org/gitlab/-/commit/2c55e84fb42cabc22d483c48afbd593a4da42cef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188491)) **GitLab Enterprise Edition**
- [Drop redundant indexes on the issues table](https://gitlab.com/gitlab-org/gitlab/-/commit/a7e1ec70a803300baf1ccb6ad858513f53db668c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189036))
- [Mark 20250203130827 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/c780a44ec688deade4d74fc671b78f9370d31aed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188695)) **GitLab Enterprise Edition**
- [Remove hide_snippets_of_banned_users feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/e271662b00cd659739c85267171dd5cdcd088c3b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188980))
- [Finalize BBM BackfillPCiPipelineVariablesFromCiTriggerRequests](https://gitlab.com/gitlab-org/gitlab/-/commit/32a599789c1446fde2de335666f8d8de72dc8d03) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188507))
- [Add `canLeave` user permission field for the Groups GQL query](https://gitlab.com/gitlab-org/gitlab/-/commit/e944f6e6e3787657acf4e4a225f9bd934975bd55) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188078))
- [Remove vscode_web_ide feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/9965327a0f254486e985104d412ce7f597c67ab2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188427))
- [Finalize settings context hash backfill](https://gitlab.com/gitlab-org/gitlab/-/commit/089df04905ea9db8e5862f1a8187975386b0fca9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184414))
- [Add NOT NULL for sharding key on dast_site_profiles_builds](https://gitlab.com/gitlab-org/gitlab/-/commit/e3c6d32c449a50b68267704187c7ce23ebab853b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186922))
- [Add & backfill sharding keys for protected_branch_push_access_levels](https://gitlab.com/gitlab-org/gitlab/-/commit/c0141a06f90c3da82fd32cdc06e6a103bd716573) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175714))
- [Mark 20250203213829 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/becc557a5ce9f92d0510cfd44138da771c349e56) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188696)) **GitLab Enterprise Edition**
- [Remove safe navigators](https://gitlab.com/gitlab-org/gitlab/-/commit/ff7b5197297353d70a14618b7041cdb5e0ef2811) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187461))
- [Mark 20241107131942 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/bda2872748e68d568a127a0dadc3d02a9fed09b1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188657)) **GitLab Enterprise Edition**
- [Refactor and breakdown SyncProjectApprovalPolicyRulesService](https://gitlab.com/gitlab-org/gitlab/-/commit/a7601774353c7b35283bb78c7137b58d404c3b54) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184623)) **GitLab Enterprise Edition**
- [Mark 20250204111501 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/d35e4da7d456179d934a304015011f80d187505d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188697)) **GitLab Enterprise Edition**
- [Finalize BackfillPartitionedWebHookLogsDaily](https://gitlab.com/gitlab-org/gitlab/-/commit/af915e9ed57c7868a5afb848c2fdb4f699dfba2e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188055))
- [Finalize BBM BackfillPCiPipelinesTriggerId](https://gitlab.com/gitlab-org/gitlab/-/commit/f3a3053918053b10f9b54c2c78454987cfa5b9d2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188508))
- [Add migration to remove the jobs of a deprecated worker](https://gitlab.com/gitlab-org/gitlab/-/commit/6d396a1c9eec3a33d7ee52309aea6065ab7065d4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188469)) **GitLab Enterprise Edition**
- [Remove custom_fields_feature feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/97fe03247148a7096a342761cb85e138702d9338) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188844))
- [Remove redundant index from job artifacts](https://gitlab.com/gitlab-org/gitlab/-/commit/29cb8c91ec3752ad5f50b20f5748b9b6c5a6962e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187564))
- [Remove deprecated ElasticCommitIndexerWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/a7795c80d7377f2973e229a2ada0406fc6a667ed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188853)) **GitLab Enterprise Edition**
- [Include EncryptedAttribute in non-owned files](https://gitlab.com/gitlab-org/gitlab/-/commit/1961c03cab6941c083a2a0a8e7a1d8c1d719ea89) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188124))
- [Protected containers: Repository push protection for deploy token](https://gitlab.com/gitlab-org/gitlab/-/commit/58b0f375bb3be08b96287ce13db056763fb50f6a) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185823))
- [Allow null values for namespace_id column in compliance adherence table](https://gitlab.com/gitlab-org/gitlab/-/commit/8558af98f44a94305d2b8c44df031f0d0334791d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188400))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/943a21c720bb2783827e2d094294850467a0e76d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188518))
- [Finalize BBM BackfillIssueEmailParticipantsNamespaceId](https://gitlab.com/gitlab-org/gitlab/-/commit/f07f81dbd87f45c1c75e6aac0d90aa87fffefe0a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188655))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/0ead2bef2019860f44bc0aa0e9bf06573488440f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188765))
- [Mark 20241107144941 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/b17bfd504b9fa84122072f515164f2ee75ca4027) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188692)) **GitLab Enterprise Edition**
- [Remove hidden_notes feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/17ad57b94d4922f3749bff261f49d820866dd657) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188760))
- [Add documentation for approving an MR directly after creation/push](https://gitlab.com/gitlab-org/gitlab/-/commit/e0b98bafcc2ac55f88e30c7896b8d41c09d1966d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187255))
- [Optimize and requeue redirect_routes namespace_id backfill](https://gitlab.com/gitlab-org/gitlab/-/commit/c5faf7f4c04ca055c2b8286a38c3581da0d735f8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186774))
- [Move custom emoji path logic to widget model](https://gitlab.com/gitlab-org/gitlab/-/commit/392d3baf86abcf6fa77b39f1d998039c41b8283b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188449))
- [Remove unused default_organization initialization from spec](https://gitlab.com/gitlab-org/gitlab/-/commit/7d91e4f8db1feb60dc5a23fa724d0286fd24a426) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188592))
- [Fix timestamp inconsistency for AI events in CH](https://gitlab.com/gitlab-org/gitlab/-/commit/45868adf0777c672eca94802a9eb2463cfbe9cd6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186988)) **GitLab Enterprise Edition**
- [Sync translations from crowdin (2025-04-17)](https://gitlab.com/gitlab-org/gitlab/-/commit/6fed5207ee42e1595f6c8e01d0fcff58d955736c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188556))
- [Finalize migration BulkImportTrackers](https://gitlab.com/gitlab-org/gitlab/-/commit/0044d3a9853acffaa182c1d98801881046dd566e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184776))
- [Delete orphaned ci_runner_machines records on self-managed](https://gitlab.com/gitlab-org/gitlab/-/commit/cfa320d79ce681db52f64c719267721936f312ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188083))
- [Finalize BBM BackfillIssueAssignmentEventsNamespaceId](https://gitlab.com/gitlab-org/gitlab/-/commit/93fb69627b7ffb4281ac194a5f0d40270101f05c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188346))
- [Add migration to remove the jobs of a deprecated worker](https://gitlab.com/gitlab-org/gitlab/-/commit/846d3d0bb9802127df84f4756e935ccb398453bb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188474)) **GitLab Enterprise Edition**
- [Sync translations from crowdin (2025-04-16)](https://gitlab.com/gitlab-org/gitlab/-/commit/aa6b4a3f992aaf57cb723482793281e9d23d6999) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188460))
- [Swap stage with stage_id column in ci_finished_builds ClickHouse table](https://gitlab.com/gitlab-org/gitlab/-/commit/ba3c033a9c8e747c012e603322636004c401f582) by @karras ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188096)) **GitLab Enterprise Edition**
- [Add NOT NULL for sharding key on container_repository_states](https://gitlab.com/gitlab-org/gitlab/-/commit/4be266a349dbd2f79bdccd424b6606d6dd87818b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188456))
- [Recreate new code_suggestion_events storage in CH](https://gitlab.com/gitlab-org/gitlab/-/commit/5eed9c45332a63cb63e00da204b795bee5082f7f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186860))
- [Remove feature flag group_deletion_notification_email](https://gitlab.com/gitlab-org/gitlab/-/commit/f1e59cd84a5562e4dc08e1e51704f1b0aaaa7bb2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188062))
- [Remove the check_path_traversal_middleware_reject_requests feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/59d60be4affbff27a3593a6707b8fce05794cae7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187709))
- [Finalize fork_networks organization_id backfill](https://gitlab.com/gitlab-org/gitlab/-/commit/cb61d41c55bacb8300f611466d4d6efe6136553e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188382))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/0f63905a4b6e44312b3ec5331f184d1f81854d02) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187248))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/cb4915bfcfa71be767d915e3d4e3770e0bd59202) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187810))
- [Async remove unused index from ci_job_artifacts](https://gitlab.com/gitlab-org/gitlab/-/commit/3ced8018d2a4070b795a4ebe47fc389b7a66533c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188347))
- [Drop unused notes.attachment column](https://gitlab.com/gitlab-org/gitlab/-/commit/6f78ae5c1f20af71a8b2d71091ceeb6ee4478385) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188133))
- [Removed member_promotion_management feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/81c9d125420bbccccb63a9c0b5bc1af271a82d7c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187888))
- [Add and fill resource_iteration_events group](https://gitlab.com/gitlab-org/gitlab/-/commit/e3a5591479dd4e2aca0d42a48a88b8979d414f1f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185139))
- [test: Improve readability of test by applying table syntax](https://gitlab.com/gitlab-org/gitlab/-/commit/4ad16e4539a00b0c5f01ca996c50c397968c62c2) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180229))
- [Document replicator and GitLab component names in Geo glossary](https://gitlab.com/gitlab-org/gitlab/-/commit/f38d5e7548a99ae0563cd90a84fd412c7efa51d4) by @karras ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187006))
- [Validate NOT NULL constraint on packages_npm_metadata.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/cbe5d1d576f5516290d2b6d915a3b78309efeae2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188202))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/b420faba3d04624c27d78ac89540767c7fdf4951) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188087))
- [Drop credentials columns from virtual registries maven upstreams](https://gitlab.com/gitlab-org/gitlab/-/commit/9e0f3a8f09db0faebd53c24e7d9aee785e0e4bf2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188180))
- [Finalize FixBadShardingKeyIdOnProjectCiRunners migration](https://gitlab.com/gitlab-org/gitlab/-/commit/9cbc6a93d2516650c9f9987e7f9c87546e1b1354) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188163))
- [Add NOT NULL on ci_resources.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/1ad053e3314b89026fba9bbb9d96f92f35521faa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182693))
- [Optimize re-enqueue the RolloutWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/9a7796d48cdf94bc019cc338252fabd2c93ca85c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188138)) **GitLab Enterprise Edition**
- [Clean up branch_rule_squash_settings feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/334db07c3f93cb6738e4dd35aa2839596ba8e9f5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186618))
- [Drop package registry application settings individual columns](https://gitlab.com/gitlab-org/gitlab/-/commit/81decd2a7a6783cd325f5fbb2ecb9d4ef741d380) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188113))
- [Remove approval_policies_pipelines_limit feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/0e0ef1bfafa21131bebbce733809713dcd6473b9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188094)) **GitLab Enterprise Edition**
- [Step-up auth: Add feature tests for step-up auth scenarios](https://gitlab.com/gitlab-org/gitlab/-/commit/2f1c140da23e672fca056e02ba666de8caf279e8) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176095))
- [Add approval_policy_rule association to ScanResultPolicyRead](https://gitlab.com/gitlab-org/gitlab/-/commit/e06d32838cb1fbfd879eb2a8f4b4e0859dfd7056) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188076)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/1332579edb4a24b2fe1e6ce7df08e001a2e99eda) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187979))
- [Rename notification for being added as approver](https://gitlab.com/gitlab-org/gitlab/-/commit/a860bb54496806d7dfac50b0002e075bb016a6fe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187571))
- [Remove redundant partition index from job artifacts](https://gitlab.com/gitlab-org/gitlab/-/commit/26f95ca4308d9898926f205e066aeb78a22ebdcd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187858))
- [Add step to disable automated PostgreSQL upgrades in Geo setup docs](https://gitlab.com/gitlab-org/gitlab/-/commit/363f5c6653559882d6c96d69fd8109eb2f3d2f4f) by @karras ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187832))
- [Remove service_accounts_crud feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/0ddd2f3d0a0175418c3355885c5791aeccc19836) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187689))
- [Add NOT NULL for sharding key on packages_nuget_metadata](https://gitlab.com/gitlab-org/gitlab/-/commit/b404d5ebbc48b13a927167d91ab5dbceced305ad) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187794))
- [Fix RSpec/RedundantAround offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/5527d953e35ceed48dcb792c7c0a0c13aa2e626d) by @JonstonChan ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187640))
- [Finalize migration BackfillIssuableSeveritiesNamespaceId](https://gitlab.com/gitlab-org/gitlab/-/commit/3084d6db66af4e5d571df3703c8191b92e728ffa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187621))
- [Sync translations from crowdin (2025-04-09)](https://gitlab.com/gitlab-org/gitlab/-/commit/dce1b2a2ff09d94e9cb1b8b948d62327463dc729) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186814))
- [Increase severity for logging blob downloads in Geo to warning](https://gitlab.com/gitlab-org/gitlab/-/commit/18bdbd39f6ef881b9a668631d6201081ce876ef8) by @karras ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186398)) **GitLab Enterprise Edition**
- [Finalize migration BackfillContainerRepositoryStatesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/78f333c76a39d0a85938318b3be49905c19074e6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185869))
- [Finalize migration BackfillPackagesRpmMetadataProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/d066d88be1fff7cfcf64017124af797e085a4b4f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184553))

## 17.11.2 (2025-05-07)

### Fixed (3 changes)

- [Bump devfile gem to v0.4.3](https://gitlab.com/gitlab-org/security/gitlab/-/commit/fb04def13b13a05ea39ba4bdd8e821427d0e8ed0)
- [Only check records with encrypted data in gitlab:doctor:encryption_keys](https://gitlab.com/gitlab-org/security/gitlab/-/commit/ea74aee315396d7418c5641eb280993a4b19b8bd)
- [Fix MR diffs endpoint to respond with pagination headers](https://gitlab.com/gitlab-org/security/gitlab/-/commit/5da8b87140aec0c7c593d229d37338396ccacd38)

### Changed (1 change)

- [Change to async_delete for ci_running_builds.runner_id](https://gitlab.com/gitlab-org/security/gitlab/-/commit/8869d30b56801b2e8bfd92f876d00637481ead0d)

### Security (3 changes)

- [Improve Octokit::ResponseValidation middleware and add rate limits](https://gitlab.com/gitlab-org/security/gitlab/-/commit/0a091f92508210fb4c251389fa6054fd65becf76) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4935))
- [Remove id attribute from OAuth form](https://gitlab.com/gitlab-org/security/gitlab/-/commit/57f19d6fde464506dc756621c83e6eaf0bfdfc33) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4948))
- [Use IssuePolicy for #issues_readable_by_user](https://gitlab.com/gitlab-org/security/gitlab/-/commit/19c44aecc4fd834c9fbde85003e9e20946e82979) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4955))

## 17.11.1 (2025-04-22)

### Fixed (1 change)

- [Fix string conversion for CI Inputs](https://gitlab.com/gitlab-org/security/gitlab/-/commit/aceb71126fb8ea5be6259a2156c6255bbaa1f3de)

### Changed (1 change)

- [Put allow_composite_identities_to_run_pipelines behind ff](https://gitlab.com/gitlab-org/security/gitlab/-/commit/2287e37df7c9ed82aa54643759e00bbf30a788c8)

### Security (4 changes)

- [Add SecureHeaders middleware with the Nel header](https://gitlab.com/gitlab-org/security/gitlab/-/commit/5a586de4d56429eabe0fb6ebc524894925759d2e) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4934))
- [Restrict forwarded headers in Maven dependency proxy](https://gitlab.com/gitlab-org/security/gitlab/-/commit/80244b98dd92312510f4a9276b5adfcbaba8e68a) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4929))
- [Security unauthorized access to reading branch names](https://gitlab.com/gitlab-org/security/gitlab/-/commit/9f9724584d109181e764f79a3b61667520d2212f) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4933))
- [Simplify detecting paragraphs for quick actions](https://gitlab.com/gitlab-org/security/gitlab/-/commit/78466ef2cd3ddee5fbf0db67056a5bccf7c59907) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4925))

## 17.11.0 (2025-04-16)

### Added (211 changes)

- [Requeue batched background migration](https://gitlab.com/gitlab-org/gitlab/-/commit/607d5f56abf2c1f8ab0a2a03b821b45737a06cf4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186925))
- [Add workflow settings](https://gitlab.com/gitlab-org/gitlab/-/commit/b10eda32d7311f9ee036c122d9bbcbe7cc0176af) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187300)) **GitLab Enterprise Edition**
- [Changes to record the users who cannot be deleted](https://gitlab.com/gitlab-org/gitlab/-/commit/b8ec63aa5be3ff0dc53565138d6db33816e79513) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183401))
- [Release Pipeline Inputs and add more details in docs](https://gitlab.com/gitlab-org/gitlab/-/commit/cca85fba528c912901e50499be46734c6cc134a4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185642))
- [Add metric to determine how many instances configured ClickHouse](https://gitlab.com/gitlab-org/gitlab/-/commit/f3a568c0d9bfcd55dd83c628206f2a367418397b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187682))
- [Add support for variable for pages.expire_in](https://gitlab.com/gitlab-org/gitlab/-/commit/179bde6865465fecaf630bd90b4dda2c4e6b9c35) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186536))
- [Implement Root Cause Analysis Hotspot experiment](https://gitlab.com/gitlab-org/gitlab/-/commit/ea225352ec3ea6791c2e71f187416db445239239) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183606)) **GitLab Enterprise Edition**
- [Add Frontend support for finding_token_status](https://gitlab.com/gitlab-org/gitlab/-/commit/76efbbfade61bf728c246f1fbaa30518d08f5d9c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187101)) **GitLab Enterprise Edition**
- [Introduce custom status and lifecycle](https://gitlab.com/gitlab-org/gitlab/-/commit/4c7fbdb3c83b7ea8e7425852f7edb568f603ec0a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186050))
- [Release duo_chat_multi_thread to self-managed](https://gitlab.com/gitlab-org/gitlab/-/commit/57e98bcb7220f683dd68a35648420b6fd780602b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187443)) **GitLab Enterprise Edition**
- [Destroying control statuses on project framework disassociation](https://gitlab.com/gitlab-org/gitlab/-/commit/2c6d4c15b33731522d6cc12d0e7e0664250cbc23) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187277)) **GitLab Enterprise Edition**
- [Add new column to `project_settings` table](https://gitlab.com/gitlab-org/gitlab/-/commit/1e1266023d6908a17e0e8ef5e28f5e74961c64dc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187342))
- [Project runner settings: Add new FF for new Vue variant (Part 2)](https://gitlab.com/gitlab-org/gitlab/-/commit/cf4fc67c5ee038ca479ecc64acea6c1411dbfbad) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186285))
- [Enabling enable_stale_compliance_status_removal by default](https://gitlab.com/gitlab-org/gitlab/-/commit/6582da1793993dba7695a3e51c6ff79d049b69aa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187519)) **GitLab Enterprise Edition**
- [Enabling enable_standards_adherence_dashboard_v2 by default](https://gitlab.com/gitlab-org/gitlab/-/commit/9a6f5ca96661a1062eebc848994c99e16b9e2542) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187517)) **GitLab Enterprise Edition**
- [Trigger AI events backfill on instance setting change](https://gitlab.com/gitlab-org/gitlab/-/commit/a41a86928cee41cf0d30e6023e1330640b80cea5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187345)) **GitLab Enterprise Edition**
- [Add show only selected projects toggle](https://gitlab.com/gitlab-org/gitlab/-/commit/86764264c66ad140b3ac9f72a80ba8ca11a31807) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187396)) **GitLab Enterprise Edition**
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/0ce94fdafaee62042fa9dc00b34f76fbdf25bfa7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187136))
- [Enabling evaluate_compliance_controls by default](https://gitlab.com/gitlab-org/gitlab/-/commit/eabd2dc213fdde9297d95fbdf99824489576257b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187520)) **GitLab Enterprise Edition**
- [Add status widget to the sidebar of tasks](https://gitlab.com/gitlab-org/gitlab/-/commit/241e915ca89e1c488e2191d3b4c535c67387ae62) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185554))
- [Enable FF code_suggestions_include_context_imports by default](https://gitlab.com/gitlab-org/gitlab/-/commit/80a94bec095715e4c05f7f6aab1dd7cbe6bf0525) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187456)) **GitLab Enterprise Edition**
- [Enable Fireworks/Codestral by default for code completion](https://gitlab.com/gitlab-org/gitlab/-/commit/b7c5e213084b7beea6d3448e439f98d22e55c47a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187417)) **GitLab Enterprise Edition**
- [Evaluating external controls for a project](https://gitlab.com/gitlab-org/gitlab/-/commit/5e21af941c8f217217ce0c1e252fcf6d6e4e6e4a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187492)) **GitLab Enterprise Edition**
- [Add Internal Inventory checks](https://gitlab.com/gitlab-org/gitlab/-/commit/214da55ac3178b6e5b56ca7e74e5ff361b033013) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185695)) **GitLab Enterprise Edition**
- [Add additional pipelines usage information](https://gitlab.com/gitlab-org/gitlab/-/commit/bab86d203c2596a5490276bd1998c4ca88a6f6b2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187435)) **GitLab Enterprise Edition**
- [Fix editing requirements with external controls](https://gitlab.com/gitlab-org/gitlab/-/commit/14582149211f40d60b2a0dae0d3ad3d9d32ae6ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187469)) **GitLab Enterprise Edition**
- [Fix reference style links after quick actions in RTE](https://gitlab.com/gitlab-org/gitlab/-/commit/c2dc0985e72fa9b56a5a7e7750ff80c9144d32b0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187001))
- [Update table_size database dictionary entries](https://gitlab.com/gitlab-org/gitlab/-/commit/94cf0fa9d7eede153084add938b4b3533658280d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186364))
- [Add Duo nano support to new namespace provision API endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/5d23a7bf8216aac3edcf19816f4b9dac91cd7ed7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187364)) **GitLab Enterprise Edition**
- [Add instance AI setting to enable or disable Duo Nano features](https://gitlab.com/gitlab-org/gitlab/-/commit/b0f294f12d08b9cc4f5b4287d8ff3728c76064d5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187538)) **GitLab Enterprise Edition**
- [Add a settings dropdown to GLQL views](https://gitlab.com/gitlab-org/gitlab/-/commit/f70cb22a2692bc5ed24d4e6fe4b3d0e067abfa73) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184788))
- [Expose `newCustomEmojiPath` on WorkItemWidgetAwardEmoji](https://gitlab.com/gitlab-org/gitlab/-/commit/39d2b8af84ab1e446acb411b76cd611279b2ea9f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187367))
- [Add policy for deleting registry tag rules](https://gitlab.com/gitlab-org/gitlab/-/commit/688cb61f5c7b7d7bd901e8ed4f88a4001a796917) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186667))
- [Adding MemberApprovalEvent data builder](https://gitlab.com/gitlab-org/gitlab/-/commit/84acd5374ccb807019d3497606671839ee9ac4d9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186252)) **GitLab Enterprise Edition**
- [Add catalog column to CloudConnectorAccess](https://gitlab.com/gitlab-org/gitlab/-/commit/09414746fbeedb6974faee910cf7cfca0934972e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185609))
- [Add warning icon and alert for scheduled rules](https://gitlab.com/gitlab-org/gitlab/-/commit/611d4c6ef623571ceacbacf11cfe2c28636088ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185132)) **GitLab Enterprise Edition**
- [Migration to add duo_nano_features_enabled column](https://gitlab.com/gitlab-org/gitlab/-/commit/c2c758af98a43e5a285245adf851c73f7a806a37) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186948)) **GitLab Enterprise Edition**
- [Protected containers: Minimum access level delete in project setting UI](https://gitlab.com/gitlab-org/gitlab/-/commit/b800391621f04180991f7781b90f5217b4b90c1a) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184810))
- [Add before_validation :update_project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/139784fb23c0f998c27cbf2abd7cdd9cb32e5b38) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184215))
- [Step-up auth: Add omniauth step-up auth for admin mode](https://gitlab.com/gitlab-org/gitlab/-/commit/6c828bfb2ea4537f1ea9ad066971007a8c17b459) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171643))
- [Add SOC2 compliance requirement controls](https://gitlab.com/gitlab-org/gitlab/-/commit/1a55260c954bf3830f78c191f3289a5622017a0e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185177)) **GitLab Enterprise Edition**
- [Add copy control ID button to framework info drawer](https://gitlab.com/gitlab-org/gitlab/-/commit/d323abde66a87c16188d381b8f7b513a1e34ff5d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187227)) **GitLab Enterprise Edition**
- [Add filter for placeholder to users module](https://gitlab.com/gitlab-org/gitlab/-/commit/7050ea0f942e6d3ace3c840eed8f08d5d26f3ace) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185481))
- [Add user_profile_visibility_updated audit event](https://gitlab.com/gitlab-org/gitlab/-/commit/c56d0472e84c2c313e9159bb1cfcbae9fcdea314) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187207)) **GitLab Enterprise Edition**
- [Pipline Graph: Group failed jobs on top of stage](https://gitlab.com/gitlab-org/gitlab/-/commit/065a019153de56c596897c4a1e27f5b8ae8d9ca9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186793))
- [Introduce application settings for pipeline execution policy limits](https://gitlab.com/gitlab-org/gitlab/-/commit/9d52a271aff55c80a05fcc6eecaa7d143e9bb667) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185209)) **GitLab Enterprise Edition**
- [Extend Duo Health check with Amazon Q probes](https://gitlab.com/gitlab-org/gitlab/-/commit/99d5ccdf8c98abc3c825e1da821037289dd8849e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187286)) **GitLab Enterprise Edition**
- [Create organization_push_rules table](https://gitlab.com/gitlab-org/gitlab/-/commit/dd1dbec787b2b0325690de6ac436439f7b6a7394) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186740)) **GitLab Enterprise Edition**
- [Fix bug edit framework without projects modified](https://gitlab.com/gitlab-org/gitlab/-/commit/4e0d85ed80507d5399c5b2b509455309feea4fa8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187246)) **GitLab Enterprise Edition**
- [Initial commit to create vulnerabilities ES Index](https://gitlab.com/gitlab-org/gitlab/-/commit/4dcaea98cd2af893135c4c2f9475061225419fff) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186827)) **GitLab Enterprise Edition**
- [Default-enable prevent token-prefixed fallback for sessionless](https://gitlab.com/gitlab-org/gitlab/-/commit/96aac77ad527b59cb4d1988eb40110d8293bc553) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187366))
- [ActiveContext: redact unauthorized results](https://gitlab.com/gitlab-org/gitlab/-/commit/33b779e47a284a8034e70be254654fe114e956ec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186399))
- [Add Duo Nano support to provision API and service for GitLab.com](https://gitlab.com/gitlab-org/gitlab/-/commit/c97d4d67c7cf1373acb6661ceaf0ddee1c42993b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186605)) **GitLab Enterprise Edition**
- [GraphQL: Expose CiRunner.creationState](https://gitlab.com/gitlab-org/gitlab/-/commit/90073d58d819547b056fbebbb49123817f201213) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187306))
- [Create runner form: Add new FF for new form](https://gitlab.com/gitlab-org/gitlab/-/commit/bff6ec63c9f2884effeeebfdd814fe8a8414e33a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186711))
- [Add project pagination to the update framework page](https://gitlab.com/gitlab-org/gitlab/-/commit/ca6535a65bd414cbdc1b2b3dae30afdbe98958cf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186601)) **GitLab Enterprise Edition**
- [Make reindexing settings configurable](https://gitlab.com/gitlab-org/gitlab/-/commit/86d5bec94b3a3b6478d3418fa96d32f5cd25dd10) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186065))
- [Increased the limit on description](https://gitlab.com/gitlab-org/gitlab/-/commit/dc0fd9aae1828ef4fc2b4e282113df76ad4feba0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187039)) **GitLab Enterprise Edition**
- [Destroying requirement statuses on project framework disassociation](https://gitlab.com/gitlab-org/gitlab/-/commit/a8889864a39ab10d7576228e60b87b58808833f3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186779)) **GitLab Enterprise Edition**
- [Change behaviour of control update service](https://gitlab.com/gitlab-org/gitlab/-/commit/7cb8578ccfda2bc77d052af9702e277a11756992) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187034)) **GitLab Enterprise Edition**
- [Refresh requirement statuses on control deletion](https://gitlab.com/gitlab-org/gitlab/-/commit/23a4c300afd93c4eb0173526830c33b128e2d787) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186655)) **GitLab Enterprise Edition**
- [Check policy when evaluating control](https://gitlab.com/gitlab-org/gitlab/-/commit/fd474f87ff7a8a20e89e111f8657247e99db26a3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186404)) **GitLab Enterprise Edition**
- [Add counts.user_with_nil_external_attribute metric](https://gitlab.com/gitlab-org/gitlab/-/commit/865e4c3aca488de468acbe6db7ad82d7ca5a2c79) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184848))
- [Add instance setting to enable or disable Duo Nano features](https://gitlab.com/gitlab-org/gitlab/-/commit/715ff7d2ad861fed4a55e78a6e79368f8ae2091a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187113)) **GitLab Enterprise Edition**
- [Add fluidWidth prop to entity_select and group_select](https://gitlab.com/gitlab-org/gitlab/-/commit/524483532551d61efbaf6de823c4f4045b190c67) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187129))
- [Add filter for placeholder to users module](https://gitlab.com/gitlab-org/gitlab/-/commit/0458b9a9249bdf9a70ba0c04c3647daee3290ff2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185683))
- [Enable policy_mergability_check by default](https://gitlab.com/gitlab-org/gitlab/-/commit/d0432951497cdd00c92f1a6cbc75fbf4166836a2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187117)) **GitLab Enterprise Edition**
- [Update duo pro seat assignment email](https://gitlab.com/gitlab-org/gitlab/-/commit/32b9a2ee4cd099d286b7c20920fa8d72a2c4f3fe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186006)) **GitLab Enterprise Edition**
- [UI for JSON Import Service](https://gitlab.com/gitlab-org/gitlab/-/commit/a1caf221576bcc3fb3665097d9f061646872a63c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185696)) **GitLab Enterprise Edition**
- [Add Backend Support for finding_token_status](https://gitlab.com/gitlab-org/gitlab/-/commit/ce3dbffa298213b2ebd33496c92d8a52eb2085ea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186220)) **GitLab Enterprise Edition**
- [Add projects to the ComplianceFrameworkFilterInputType graphql type](https://gitlab.com/gitlab-org/gitlab/-/commit/9e090816645cb475522d3880a77859a58012eef5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184682)) **GitLab Enterprise Edition**
- [Geo: Enable observability ui feature flags](https://gitlab.com/gitlab-org/gitlab/-/commit/7a1577a7e0531af477a5a686f39404db8f56e19e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187023)) **GitLab Enterprise Edition**
- [Groups sort by name, id, path](https://gitlab.com/gitlab-org/gitlab/-/commit/a604e0d1c5d5fdf5da7b2f3bb23a9ccffab3a010) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186482))
- [Create group_push_rule table](https://gitlab.com/gitlab-org/gitlab/-/commit/02ca336b7b46fb587d562490d2449cf09ad9dd58) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185982)) **GitLab Enterprise Edition**
- [Remove `cyclonedx_dependency_list_export` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/a76e66eadf623ec6388398dfcf5dc4497bd896b1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187004)) **GitLab Enterprise Edition**
- [Add analytics for CycloneDX exports](https://gitlab.com/gitlab-org/gitlab/-/commit/b05106f2335e7e5243989ab06f55e49cccfe15c0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187002)) **GitLab Enterprise Edition**
- [Implement new adherence report drawer](https://gitlab.com/gitlab-org/gitlab/-/commit/7ed305cc1df4985c4e15c18f3ae76d64dce394f2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186869)) **GitLab Enterprise Edition**
- [Token prefixes: Add support for deploy tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/c29f837c20be1077e12a9c713b91d2844eba5cfd) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186538))
- [Release the routable tokens feature](https://gitlab.com/gitlab-org/gitlab/-/commit/e07aea5d164d97fc5083df7f13409555e740c0e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186679))
- [ActiveContext: embeddings for documents](https://gitlab.com/gitlab-org/gitlab/-/commit/ad94b28f5fcddf7f2f4f74f12886a8cbda29b011) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186261))
- [Apply Framework to Projects Services](https://gitlab.com/gitlab-org/gitlab/-/commit/f9293b8fca934ffe04efa863c7b1f586190e3b19) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186483)) **GitLab Enterprise Edition**
- [Added analyzer_namespace_statuses table](https://gitlab.com/gitlab-org/gitlab/-/commit/c3488d4752fdde8123a180c357c9aa51519b1b3c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185595))
- [Create index on merge_request_diff_files.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/86dd82601511ff10bb32fedbb9aa5cd5e6baea53) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186903))
- [Add reverse_issuer_* formats for LDAP Smart Card Authentication](https://gitlab.com/gitlab-org/gitlab/-/commit/603d9ccad6ed6deee67a32301d2181c68f0de294) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186333)) **GitLab Enterprise Edition**
- [Implement filtering in new adherence report](https://gitlab.com/gitlab-org/gitlab/-/commit/c683c129c33ef602041b40b6f9136b6e2243dcda) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186566)) **GitLab Enterprise Edition**
- [Adds seat_type enum to seat_assignments](https://gitlab.com/gitlab-org/gitlab/-/commit/a18e13706a936422d6682b8860fbbb4b4a5707b1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185602)) **GitLab Enterprise Edition**
- [Create system notes when custom field is changed or removed](https://gitlab.com/gitlab-org/gitlab/-/commit/a39b77951675bb4b42452d9e8fa6c56d64e23b1b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184961)) **GitLab Enterprise Edition**
- [Added new error page for zoekt multi-match](https://gitlab.com/gitlab-org/gitlab/-/commit/f65a1bd1307a6c54dfaae7d3ebc5640a17149b2d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186397))
- [Log CloudFlare-reported leaked creds on sign-ins](https://gitlab.com/gitlab-org/gitlab/-/commit/a73844e66762cd198326eaee346555e72a1a8aae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186820)) **GitLab Enterprise Edition**
- [ActiveContext concern to track on ActiveRecord callbacks](https://gitlab.com/gitlab-org/gitlab/-/commit/c0d65d141dc699d0b99448eee48d5f2c20b175cf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186530))
- [Add Duo Nano support to provision API and service for GitLab.com](https://gitlab.com/gitlab-org/gitlab/-/commit/845e5403104db1541d6cdf896f73cbdc35dfcd76) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186569)) **GitLab Enterprise Edition**
- [Release Duo seat assignment TODO notificiation](https://gitlab.com/gitlab-org/gitlab/-/commit/17be7454434f634074d71410894a2899f342e0c9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186742)) **GitLab Enterprise Edition**
- [Add date based expiration to Issue WIT feedback badge](https://gitlab.com/gitlab-org/gitlab/-/commit/a60679dae90e6c18a8b30516fed77a4598e82475) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186731))
- [Add limit to creating requirements in UI](https://gitlab.com/gitlab-org/gitlab/-/commit/557d05e86ab8186821540853316d011c07d77007) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186330)) **GitLab Enterprise Edition**
- [Add system note when a vulnerability is redetected](https://gitlab.com/gitlab-org/gitlab/-/commit/0b6a68d306e0ebf1535304940e7c62094cad7160) by @onasser ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184712)) **GitLab Enterprise Edition**
- [Implement pagination in new adherence report](https://gitlab.com/gitlab-org/gitlab/-/commit/5d60807856ef89145b8287fec3faad2f99f3716e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186548)) **GitLab Enterprise Edition**
- [Added requirement status column to control status](https://gitlab.com/gitlab-org/gitlab/-/commit/409eaae8a3edb3b546cda5ba7d2e39ff8d164b54) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186510)) **GitLab Enterprise Edition**
- [Add Duo Nano support to provision API and service for GitLab.com](https://gitlab.com/gitlab-org/gitlab/-/commit/1ade0d8190f17fc327521c1c5c19aa1413bc71b5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186455)) **GitLab Enterprise Edition**
- [Enable Snowplow batching](https://gitlab.com/gitlab-org/gitlab/-/commit/bcc0af6b12f3a4dbc0c117e2a4455b21a8f063f7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185811))
- [Add read model support for package filtering](https://gitlab.com/gitlab-org/gitlab/-/commit/f990a78a04a97f6d17c8f8f169d4fe0a659e475c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185785)) **GitLab Enterprise Edition**
- [Add pages/Nuxt project template](https://gitlab.com/gitlab-org/gitlab/-/commit/d6ef986c47155a608f8081d62a05384da3030c55) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186657))
- [Updating and creating requirement status](https://gitlab.com/gitlab-org/gitlab/-/commit/001ea637c47c53f20b04287076478e51f27fafaa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183502)) **GitLab Enterprise Edition**
- [Release protected maven packages feature](https://gitlab.com/gitlab-org/gitlab/-/commit/a9deb0b20b9384a2385ff33ce57ea802c896d5b7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185940))
- [Remove vsd visualizations feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/b72c40b0c2e3c3f9a68bc4be41eed99211a8a082) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186222)) **GitLab Enterprise Edition**
- [Implement `PATCH /Groups/:id` SCIM endpoint for self-managed](https://gitlab.com/gitlab-org/gitlab/-/commit/d0b38b76845ce66ec17674e2679bddff46662563) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184997)) **GitLab Enterprise Edition**
- [Show only linked items in unlink quick action suggestions](https://gitlab.com/gitlab-org/gitlab/-/commit/16f2b6d96a47ed215afcb901efefc52826ed3781) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183102))
- [Implement basic version of new adherence report](https://gitlab.com/gitlab-org/gitlab/-/commit/64788590869dbc20a44f0f0d23e777d1e0c4694c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186525)) **GitLab Enterprise Edition**
- [Add GET /personal_access_tokens to service_accounts API](https://gitlab.com/gitlab-org/gitlab/-/commit/190fc1eb933d16bcc003b027b5ec65f9a2e7667f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186105)) **GitLab Enterprise Edition**
- [Feat: Add checkbox for group level setting AmazonQ](https://gitlab.com/gitlab-org/gitlab/-/commit/75886ff6d3e3e68305ea4673ed5851cfccb493de) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185504)) **GitLab Enterprise Edition**
- [Release group custom service account email](https://gitlab.com/gitlab-org/gitlab/-/commit/5443ba96bdc8ff2aceec9c64ec11bc840bb3b1f6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186476)) **GitLab Enterprise Edition**
- [Added validations on associations for control status](https://gitlab.com/gitlab-org/gitlab/-/commit/4fa1bcce1a2be97428d8fb8e21e4da084849b2b0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185412)) **GitLab Enterprise Edition**
- [Add top-align to the trash icon in the requirement modal](https://gitlab.com/gitlab-org/gitlab/-/commit/f6e31fe172deb329d5def92bdcc602fedad2b778) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185809)) **GitLab Enterprise Edition**
- [Improve compliance control development flow](https://gitlab.com/gitlab-org/gitlab/-/commit/7741ce67a6d86ad195f815801842051213c39343) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184981)) **GitLab Enterprise Edition**
- [Update table_size database dictionary entries](https://gitlab.com/gitlab-org/gitlab/-/commit/243634e6a8a6a44fde835cf2916ccc8c9ef69866) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186363))
- [Expose `aboutToBeArchived` information for vulnerabilities on GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/df21c0cf26804c74f5619dec7919387d8cb347cf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185311)) **GitLab Enterprise Edition**
- [Support getting predominant worker from pg_stat](https://gitlab.com/gitlab-org/gitlab/-/commit/a0fc096e5c6d6906772231635149c07764018997) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174951))
- [DB change to add member_approvals_event column](https://gitlab.com/gitlab-org/gitlab/-/commit/0da4533a8175c9c658b35a8d390713834c672f84) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186253))
- [Allow owners to revoke service account tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/ce46298d1582c3a378567d99a716fbd6c2f21c40) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185682)) **GitLab Enterprise Edition**
- [ActiveContext PostgreSQL processor for queries](https://gitlab.com/gitlab-org/gitlab/-/commit/43466653cc5fb481df3d533b144093e9f04f2ea7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184708))
- [Add missing prompt versions for tools](https://gitlab.com/gitlab-org/gitlab/-/commit/753086879608b7eeff6681ce530282037c32b77b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186508)) **GitLab Enterprise Edition**
- [Added analyzer_project_statuses table](https://gitlab.com/gitlab-org/gitlab/-/commit/a9f5c5f8e95ea5b19702e029e203831ac45a8a74) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184448)) **GitLab Enterprise Edition**
- [Protected packages: Add minimumAccessLevelForDelete in proj. settings UI](https://gitlab.com/gitlab-org/gitlab/-/commit/c185f79888d91823d5652ded0494a338d0158b62) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180416))
- [Add create MR to work item branch](https://gitlab.com/gitlab-org/gitlab/-/commit/25beeaabcf61eeb08ba4ad2b6d343d3eebaf92b5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181479))
- [Add immutable field to access level interface](https://gitlab.com/gitlab-org/gitlab/-/commit/a8b62fb3b13ade00c7ef6c0b3815396f101f7589) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185537))
- [Add summarize_new_merge_request tool](https://gitlab.com/gitlab-org/gitlab/-/commit/fe446fd1343dad3c72cd8984018724a929c182de) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186225))
- [Project runner settings: Add new FF for new Vue variant](https://gitlab.com/gitlab-org/gitlab/-/commit/bcd15ec199549fde806cb3d09fd137c16cdff12b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185957))
- [Add tables and models to store SBoM dependency graphs](https://gitlab.com/gitlab-org/gitlab/-/commit/b16610fb476ec633a6a82ef70833c8312ca755a2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184240)) **GitLab Enterprise Edition**
- [Release the track_repository_xray_in_ci FF](https://gitlab.com/gitlab-org/gitlab/-/commit/8739ed3c3410c2e0d048c7aa816c1c174dbf630d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186372)) **GitLab Enterprise Edition**
- [Add sort by path to group projects](https://gitlab.com/gitlab-org/gitlab/-/commit/e2f0b581abba7003cf77b6597812eebb2bc5fe0d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186319))
- [Add cylonedx export parameter](https://gitlab.com/gitlab-org/gitlab/-/commit/970dcf8b62bba418669cd9e1ac66f7a457a62311) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185517)) **GitLab Enterprise Edition**
- [Add lastComment presenter for GLQL](https://gitlab.com/gitlab-org/gitlab/-/commit/bf5539c5ea72830a3d39009542b2ef20ca9653da) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185864))
- [Save namespace_path to CH when provided for AI usage events](https://gitlab.com/gitlab-org/gitlab/-/commit/cb0fbe6ba0fe44e66cdd25d089eb65c36e8a54a3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186082)) **GitLab Enterprise Edition**
- [Add duo workflow checkpoint endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/a0a347b1d95db04976353c694876898c0b5cfeff) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185068)) **GitLab Enterprise Edition**
- [Add DB metric for external audit streams](https://gitlab.com/gitlab-org/gitlab/-/commit/eb30a59f8d79655331e17bbe8b1d9a1930e29937) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184339)) **GitLab Enterprise Edition**
- [UI and docuemtation changes for the virtual registry scopes](https://gitlab.com/gitlab-org/gitlab/-/commit/5d170819dd6954c7a51c011a16be774fa766b357) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185059))
- [Add `group_wikis_routes_view` database view](https://gitlab.com/gitlab-org/gitlab/-/commit/4a21a59d0b66e8f3be22a077c13ecefa4a21e5a0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179454))
- [Add ClickHouse configuration settings to CE](https://gitlab.com/gitlab-org/gitlab/-/commit/d0bd3059e73399411c54f177115b4c218c34bc03) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184314))
- [Add page size selector to packages list page](https://gitlab.com/gitlab-org/gitlab/-/commit/d8d3ee6f44f3fd5134ffceff8892ffca6c09d551) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185639))
- [Add merge_request_title_regex to project setting](https://gitlab.com/gitlab-org/gitlab/-/commit/3199f464891a04f9e51a2e2adcb360d65686ed76) ([merge request](gitlab.com/gitlab-org/gitlab/-/merge_requests/184935))
- [Add tracking for dependency exports](https://gitlab.com/gitlab-org/gitlab/-/commit/f9772cd3db9e060daadf0fbebfeaeab819457a3b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184666)) **GitLab Enterprise Edition**
- [Added a new vulnerability_namespace_statistics table](https://gitlab.com/gitlab-org/gitlab/-/commit/1518390583e40ac6c5e499292956d2132474e58d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182917))
- [Adds organization_id to seat_assignments table](https://gitlab.com/gitlab-org/gitlab/-/commit/67e0f579d3f0feb3cddb22316999c9df490ca87f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185243))
- [Add sort actions to all columns in Storage view in Usage quotas](https://gitlab.com/gitlab-org/gitlab/-/commit/cd221a519efbf260e25acf1df707605582224f2f) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185975))
- [Readds tooltips to icons in dev widget](https://gitlab.com/gitlab-org/gitlab/-/commit/92da858fc56af34310f69659a822e3501baaa076) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185491))
- [Add sort actions to all columns in Storage view in Usage quotas](https://gitlab.com/gitlab-org/gitlab/-/commit/99bac9897781b714cc559968f72f98b92d0cdd15) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184030))
- [Create basic Ai::TroubleshootJobEvent model](https://gitlab.com/gitlab-org/gitlab/-/commit/059e2e5f44940d132d7610e21576cd9f38217391) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184357)) **GitLab Enterprise Edition**
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/2a4a92ffee0de2338feddac824a954b55e1fc252) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185924))
- [Admin Token API: Revoke GitLab Session](https://gitlab.com/gitlab-org/gitlab/-/commit/33ca8a6ce9d216432777a9c1911c4134c47dbbf0) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184047))
- [Notify users if famework export was truncated](https://gitlab.com/gitlab-org/gitlab/-/commit/55410063ed43c20decc62f25245473bda846611d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185089)) **GitLab Enterprise Edition**
- [Add shared_namespace column to workspaces_agent_configs](https://gitlab.com/gitlab-org/gitlab/-/commit/49a26c3b6c46cfa22f049248eda96742f6921145) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185895)) **GitLab Enterprise Edition**
- [Adding framework namespace validation in requirement model](https://gitlab.com/gitlab-org/gitlab/-/commit/c61971b69ef1f08abe909215b11847666c588975) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185403)) **GitLab Enterprise Edition**
- [Add editPath to GraphQL for Compliance Frameworks](https://gitlab.com/gitlab-org/gitlab/-/commit/825ba6859422803e281bf80299960549f157bff3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184122)) **GitLab Enterprise Edition**
- [Add subscribed, due, and updated filters to work items list](https://gitlab.com/gitlab-org/gitlab/-/commit/f73ac993a1fa162aa168047b559d0f14764a9be0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185126))
- [Connect audit event streams from new tables](https://gitlab.com/gitlab-org/gitlab/-/commit/4216b7b7fc844acff542e2840bd4277baa548ef6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181861)) **GitLab Enterprise Edition**
- [Add fix button for Amazon Q quick actions](https://gitlab.com/gitlab-org/gitlab/-/commit/c21ed8abbd8cc93be130505ae2a4edd53c45e92a) by @jlosito ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184055)) **GitLab Enterprise Edition**
- [Added a new vulnerability_namespace_statistics table](https://gitlab.com/gitlab-org/gitlab/-/commit/c6439188ada8e37fc8f651b93000bc1e1b7244b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183131))
- [Add help icon for array types](https://gitlab.com/gitlab-org/gitlab/-/commit/c8ab44586301586c6204c59c143187ed37df7f71) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185686))
- [Add endpoint to batch delete todos records](https://gitlab.com/gitlab-org/gitlab/-/commit/e727df8450910e6d53a7806a1df469f9f2ffc4c3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184362))
- [Feat: Amazon Q code review button](https://gitlab.com/gitlab-org/gitlab/-/commit/f584b0e6460d2c5ddaf660cba2f9c676459583eb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185019)) **GitLab Enterprise Edition**
- [Protected packages: Add minimum_access_level_for_delete to REST API](https://gitlab.com/gitlab-org/gitlab/-/commit/1ae51456277dc246bb22f37c840baf934a0f6704) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180063))
- [Expose contacts_available field for work item CRM contacts widget](https://gitlab.com/gitlab-org/gitlab/-/commit/77c11a4e74fde415c7fcf309310e1016efa8990a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185764))
- [Audit environment_scope changes](https://gitlab.com/gitlab-org/gitlab/-/commit/259f4526e7bcd0a5c2e0212859b549d467dde2fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185253)) **GitLab Enterprise Edition**
- [RequestAccess for non-billable users](https://gitlab.com/gitlab-org/gitlab/-/commit/32a306ce242d5ad73733771a6fda66b3dc009895) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185592)) **GitLab Enterprise Edition**
- [Redirect `/-/u/:id` to user page](https://gitlab.com/gitlab-org/gitlab/-/commit/84c0cfc66919f5bdc0c028f3262798a6eb3475cb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185387))
- [Add `project_snippets_view` database view](https://gitlab.com/gitlab-org/gitlab/-/commit/707a1035ebd3bbc871733a4aa7e236a4182cab8a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179452))
- [Support new access token sorting options in the UI](https://gitlab.com/gitlab-org/gitlab/-/commit/f297564d746a31417652d8539e310f0ba6892ed7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184303))
- [Add `personal_snippets_view` database view](https://gitlab.com/gitlab-org/gitlab/-/commit/580a673bb72fbf384e3f669c0aa8e97dbdfe57d9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179451))
- [List project control statuses for a requirement](https://gitlab.com/gitlab-org/gitlab/-/commit/fbb55608f9fc822b767708e2f343a139d718d9a3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184881)) **GitLab Enterprise Edition**
- [Add a new licenses violation checker for package exclusions](https://gitlab.com/gitlab-org/gitlab/-/commit/9909a20e1807fe4d06286fb32f3df0ab5832c82c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177156)) **GitLab Enterprise Edition**
- [Adds additional context for self-hosted generation](https://gitlab.com/gitlab-org/gitlab/-/commit/2b6c1a2ada36f31f985e2fc3ca25c4bdf9840d32) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185263))
- [Implement cronjob to archive vulnerabilities periodically](https://gitlab.com/gitlab-org/gitlab/-/commit/446719210fb0e5c0cd6fa13bb9a4b4aa388971ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185131)) **GitLab Enterprise Edition**
- [Remove the `add_policies_to_ci_job_token` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/da2a9590fef70f8d3d943354152accacc1301f57) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185124))
- [Json Import Service for Compliance Frameworks](https://gitlab.com/gitlab-org/gitlab/-/commit/61b6f5013b836bcccd04db7ee8846c1ced125030) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181890)) **GitLab Enterprise Edition**
- [Add Geo rake task for checking tracking DB after promotion](https://gitlab.com/gitlab-org/gitlab/-/commit/e2ac0d6756706e53b9ece6f5bd631ea550b430ab) by @karras ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184882)) **GitLab Enterprise Edition**
- [Implement `GET /Groups` SCIM endpoint for self-managed](https://gitlab.com/gitlab-org/gitlab/-/commit/8e5d3ccf5204ddb5ec34c13bbe3ab974240f1b67) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182371)) **GitLab Enterprise Edition**
- [Add component field to GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/48afb2e05c5557b0ebb3b50e57bdfcc20369b8c1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181568)) **GitLab Enterprise Edition**
- [Add ancestor type to GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/4987b990178f755ef2018a892f161f9c34c447af) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180747)) **GitLab Enterprise Edition**
- [Add API endpoint to revoke PATs for service accounts](https://gitlab.com/gitlab-org/gitlab/-/commit/f2f46d8c891d6977502aa3c002e7ced7f9038cf5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184287))
- [Add sidebar shortcut, event tracking](https://gitlab.com/gitlab-org/gitlab/-/commit/e50516355eceb44da683e055e3f9f62e887fa3be) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184858))
- [Export adherence project statuses report](https://gitlab.com/gitlab-org/gitlab/-/commit/5372718bb8814f2516be194591fe5b45387575de) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184762)) **GitLab Enterprise Edition**
- [Show job source in job details](https://gitlab.com/gitlab-org/gitlab/-/commit/8f0e949f30ef4dbe604c7bf8b477b44c971dbea3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184975))
- [Add jobs filter by source](https://gitlab.com/gitlab-org/gitlab/-/commit/57f11b9d0bc898f51696b11ade3b84baac613f15) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185028)) **GitLab Enterprise Edition**
- [Added filtering for project requirement compliance statuses](https://gitlab.com/gitlab-org/gitlab/-/commit/ca40912bb1a18d8eecb2e3e1465b6929d75adc7d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185135)) **GitLab Enterprise Edition**
- [Add negated filter for component versions](https://gitlab.com/gitlab-org/gitlab/-/commit/f1b959d5225d10e16057e2df9fb0e3d80a8317d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185285)) **GitLab Enterprise Edition**
- [Make field connection type so that we can use pagination](https://gitlab.com/gitlab-org/gitlab/-/commit/9bd97e7678613c31a14acfdf512ffb9772ae5aaa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185178)) **GitLab Enterprise Edition**
- [Add migration issue form](https://gitlab.com/gitlab-org/gitlab/-/commit/986a5333fd91827c7e487405067929dc3a0a9547) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184238))
- [Adds duo workflow to ai_settings](https://gitlab.com/gitlab-org/gitlab/-/commit/e4cfec2c57d6374136d615022714650a335fef01) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182894)) **GitLab Enterprise Edition**
- [Update controls in requirement update mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/5bc1c36b0cc2085668ae82f4030abc601613fefa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183476)) **GitLab Enterprise Edition**
- [Add count.admins metric](https://gitlab.com/gitlab-org/gitlab/-/commit/5c70b8bac9102e44b2b44f43c5935b703dd3eeae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184797))
- [Enable extension marketplace by default](https://gitlab.com/gitlab-org/gitlab/-/commit/728255eb752f7eda737a5fb9627946a11f6b1c92) by @pslaughter ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184662))
- [Introduce retention policy alert](https://gitlab.com/gitlab-org/gitlab/-/commit/9a6dacc172e8637eab50dba14f635531203ef197) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184461)) **GitLab Enterprise Edition**
- [Create partitioned table for uploads](https://gitlab.com/gitlab-org/gitlab/-/commit/001e2334b6e1012d6993f703c02a4ef00cf532d2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175203))
- [Add inputs banner to pipeline editor](https://gitlab.com/gitlab-org/gitlab/-/commit/092ebe992971dbbbe2ce78c605f377d41e535c46) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185171))
- [Resolve vulnerability using Claude 3.7 Sonnet prompt version](https://gitlab.com/gitlab-org/gitlab/-/commit/a4b46a30a0761a574d93189ecf9e6cb33e676d33) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183607)) **GitLab Enterprise Edition**
- [Add version filtering in project level controller](https://gitlab.com/gitlab-org/gitlab/-/commit/3053dcd4f6b76749aad19f6f340189813e89dce3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184967)) **GitLab Enterprise Edition**
- [ActiveContext migration worker](https://gitlab.com/gitlab-org/gitlab/-/commit/f71823774b908020d978830b589fdb03c7d0c2d4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184309))
- [Add inputs to PipelineScheduleUpdate mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/05b695960aaf37fda97c8b35dd6fd2454aadae75) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184620))
- [Add CI/CD job token policies switch](https://gitlab.com/gitlab-org/gitlab/-/commit/9a685e0f39eed1fd9fd4fb63f3f7b1fb0cfc8bdc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184516))
- [Remove preload_member_roles from projects resolvers](https://gitlab.com/gitlab-org/gitlab/-/commit/e1a83213ad5e7cd3adc935152e7c2bee037d81a6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185045)) **GitLab Enterprise Edition**
- [Add support for organization-wide agent CI authorization](https://gitlab.com/gitlab-org/gitlab/-/commit/fb40299b2c8dde589985a279612c98f3854d0e97) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184259))
- [Add pipeline inputs to pipeline schedule](https://gitlab.com/gitlab-org/gitlab/-/commit/2c9ff3fc4442186b7b70723ad680e7736d5f6b06) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184698))
- [Update ci schema to support inputs](https://gitlab.com/gitlab-org/gitlab/-/commit/a96cf07705e8b568f12754bd0866cf186ceb2e75) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182198))
- [Add `organization_id` code logic to `fork_networks`](https://gitlab.com/gitlab-org/gitlab/-/commit/70ebd734c319b8095ad2419be777bba0eccfa4d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184033))
- [Support sorting params in List package files endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/c78d247c84f7b4fa169760e3d4cd65c309af8f21) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184839))
- [Allow users to input docker hub credentials](https://gitlab.com/gitlab-org/gitlab/-/commit/ccbf4faa4fda1c0327511804b3ec3b9908f88424) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183699))
- [Add notes field to notes work item widget type](https://gitlab.com/gitlab-org/gitlab/-/commit/4c32d7bf9c0dee5045460e9a5a81c2bd33dfdf84) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184763))
- [Optimize offsets on Group/Project audit events API](https://gitlab.com/gitlab-org/gitlab/-/commit/031541b13ebf640a867fc787008d1f0f65a2a2fb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182031)) **GitLab Enterprise Edition**
- [Add Import usage tab to group usage quotas](https://gitlab.com/gitlab-org/gitlab/-/commit/a53e4aa997b409ed7a0b68162979801934139cea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184500))
- [Add rotate and admin_token_api events with namespace metrics](https://gitlab.com/gitlab-org/gitlab/-/commit/8f47b11957f674c9f8ce27256861c1c745e14100) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184008))
- [Add GraphQL mutation to delete custom admin roles](https://gitlab.com/gitlab-org/gitlab/-/commit/080133fff86c086efe9aa453506355e635e93fab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182217)) **GitLab Enterprise Edition**
- [Add the ability filter by versions](https://gitlab.com/gitlab-org/gitlab/-/commit/719aefc0e3c4a7bc9fb4405c6ffb0cf094b99ef2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184738)) **GitLab Enterprise Edition**

### Fixed (132 changes)

- [Update signatures also for gpg key fingerprints](https://gitlab.com/gitlab-org/gitlab/-/commit/698545e0f359d47d62fa7b3a3e309b26a6c06ae2) by @filipmoc ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182738))
- [Clear session cookie when browser is closed](https://gitlab.com/gitlab-org/gitlab/-/commit/f09c3096e347e7d01a454255a77f814b23109ec9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187882))
- [Fix CI inputs conversion](https://gitlab.com/gitlab-org/gitlab/-/commit/3ebeeb9d293d96ff7cc804baede20bcf4de80aeb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187711))
- [Zoekt: Fix last_rollout_failed_at usage](https://gitlab.com/gitlab-org/gitlab/-/commit/b8f04cafd5f321c866b37e8b3d8cc8d078a598b7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187853)) **GitLab Enterprise Edition**
- [Set the MR to unchecked when updating target branch](https://gitlab.com/gitlab-org/gitlab/-/commit/769f38d8500fd685faeb166d427340338d502e66) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187249))
- [Fix 500 in Todo API when wiki page todo exists](https://gitlab.com/gitlab-org/gitlab/-/commit/ade00a12203e8d84bf5349aa69ac52724a4db4c7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186933))
- [Create progress note for DCR and handle errors better](https://gitlab.com/gitlab-org/gitlab/-/commit/0936eaf0383e732141089f106f3503097cf4ee3b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186920)) **GitLab Enterprise Edition**
- [Fix filtering pipelines by merge request branch name](https://gitlab.com/gitlab-org/gitlab/-/commit/1b70e6715e817c185a881f54696324ae6783dffb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187548))
- [Enforce scrollbar on body](https://gitlab.com/gitlab-org/gitlab/-/commit/64f197a0caa2bda54d05c468642242f83557e1be) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186498))
- [Fix how title changed system notes rendered](https://gitlab.com/gitlab-org/gitlab/-/commit/7e0459b2a85b509ba5be97b1f1d65447c5ecc6c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187028))
- [Fixed access level statement inviting members to a project or group](https://gitlab.com/gitlab-org/gitlab/-/commit/8cbd72f12c3d5ba4f6614311b3d271ba9c016d82) by @zillemarco ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186837))
- [Safari-specific container query fixes for work items](https://gitlab.com/gitlab-org/gitlab/-/commit/be0a4d0979d034d09fa80afe186e580dca29cbcd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187607))
- [Hide unsupported WI relationship types on free tier](https://gitlab.com/gitlab-org/gitlab/-/commit/19fa0b0f87f056684fae158e7baba0605f56e459) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181481))
- [Check block seat overages during group access request approval](https://gitlab.com/gitlab-org/gitlab/-/commit/c9f4712967f2711bd7e5f84c6d3f2a4c44a31e5b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187266)) **GitLab Enterprise Edition**
- [Fix bug when secrets provider URL given in dotenv](https://gitlab.com/gitlab-org/gitlab/-/commit/e0301d2011d97a5239a6c1934dd650807a23e321) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186617)) **GitLab Enterprise Edition**
- [Include reserved refs in pipeline branch searches](https://gitlab.com/gitlab-org/gitlab/-/commit/f24efc9793f5312fd5ab842c19a0c165f89a4ce3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186590))
- [Preserve ReAct steps in Duo Chat history](https://gitlab.com/gitlab-org/gitlab/-/commit/879066eaafb9a989ad8ca26e97602db7f40e47ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178730)) **GitLab Enterprise Edition**
- [Add project to work item MRs](https://gitlab.com/gitlab-org/gitlab/-/commit/00cb26df89cb07a55eea32ddc8961c5c38a92917) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187044))
- [Show current namespace name in create work item form](https://gitlab.com/gitlab-org/gitlab/-/commit/d27084fc9439215a088824841dbca7900342bf96) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187406))
- [Fix license widget classification](https://gitlab.com/gitlab-org/gitlab/-/commit/7520137ba854217cf9276939de183d146b5a575b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186750)) **GitLab Enterprise Edition**
- [Ensure scan execution policy respects skip_ci for scheduled scans](https://gitlab.com/gitlab-org/gitlab/-/commit/4ec63defd7a44d124556b6ac878a55ea390ed4a7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187172)) **GitLab Enterprise Edition**
- [Return the empty result of project is not available for zoekt search](https://gitlab.com/gitlab-org/gitlab/-/commit/6f4e03bf29c987eddeff4e8c7fd78db5d1efaac6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185228)) **GitLab Enterprise Edition**
- [Use case-insensitive comparison for commit SHAs](https://gitlab.com/gitlab-org/gitlab/-/commit/6b18d335ff9872e0c2499c066768fd6ce6c7b86e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187301))
- [Handle errors when smartcard user not found on LDAP server](https://gitlab.com/gitlab-org/gitlab/-/commit/8599551d7a5c8fbfc1f889ecf443f7bbb98f927c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186337)) **GitLab Enterprise Edition**
- [Disable filter shortcut on file browser](https://gitlab.com/gitlab-org/gitlab/-/commit/57b2ab7647423a6084d2fc85c115d0a4a08485e0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187284))
- [Stop throwing exceptions when the discussion diff is broken](https://gitlab.com/gitlab-org/gitlab/-/commit/959849ade970c627ac1d4f93be422f383cdba7bf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187239))
- [Support `type` param on new incidents page for Work Items](https://gitlab.com/gitlab-org/gitlab/-/commit/0540b46e21097829d7821b965ca941d9c4822ced) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187241))
- [Show current work item assignees for `/unassign`](https://gitlab.com/gitlab-org/gitlab/-/commit/107c3701b35d0e3977ae49bd8b16cb347e2772df) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187225))
- [Move notification trigger to list item](https://gitlab.com/gitlab-org/gitlab/-/commit/a98b05916aa501c232ea8417f315bba881dc834c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187215))
- [Fix removal of policies which have reached limits](https://gitlab.com/gitlab-org/gitlab/-/commit/8548b54245c5ff231134aa1af19c02b97e8a1220) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186801)) **GitLab Enterprise Edition**
- [Prevent invalid tokens from falling back to Git password auth](https://gitlab.com/gitlab-org/gitlab/-/commit/d6e67842e926a962e806345a04c8c2bff3ac5229) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185987))
- [Use cached values of Ci::Runner#creation_state](https://gitlab.com/gitlab-org/gitlab/-/commit/87ef321333d685cdfb44673c1495082842351a42) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187153))
- [Fix ActiveRecord::QueryCanceled in RelatedPipelinesFinder](https://gitlab.com/gitlab-org/gitlab/-/commit/54fc2a36d40012e5aab678bc76c00cbcb5a8d1d8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183553)) **GitLab Enterprise Edition**
- [Fix broken regex in flaky tests for funnels](https://gitlab.com/gitlab-org/gitlab/-/commit/f74aff2d062014f8d60ced97bd9e194312ed2022) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187148)) **GitLab Enterprise Edition**
- [Allow empty code suggestion in RTE](https://gitlab.com/gitlab-org/gitlab/-/commit/3838f56b1a57b39001e1ba5611bc947d13c464be) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187142))
- [Fix setCurrentDiffFileIdFromNote not returning Promise](https://gitlab.com/gitlab-org/gitlab/-/commit/aed7eda6342fca7d5cf28f60b555436ff74a04ea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187138))
- [Take a more declarative/dependency injection path for trial alert](https://gitlab.com/gitlab-org/gitlab/-/commit/846164dc0218fcd53e85e50e6441303b862e2dda) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186889)) **GitLab Enterprise Edition**
- [Use a more universal selector for initQuickSubmit](https://gitlab.com/gitlab-org/gitlab/-/commit/a545da637312a1a01f017a5cd487d9417c262560) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183365))
- [Override restrict_user_defined_variables](https://gitlab.com/gitlab-org/gitlab/-/commit/38b98d37827aa7c952afa2291e54df275fdc932c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185458))
- [Fix SCIM group sync when externalId is missing](https://gitlab.com/gitlab-org/gitlab/-/commit/21641747ce6fcf824377ba069b306a7ea5de5d19) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186715)) **GitLab Enterprise Edition**
- [Fix loading reference error in YAML editor](https://gitlab.com/gitlab-org/gitlab/-/commit/d534ff91d8ac65bc53eb211b6f981b4f91a02836) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187108)) **GitLab Enterprise Edition**
- [Fix ProjectsRelationBuilder to preload member roles for projects API](https://gitlab.com/gitlab-org/gitlab/-/commit/b6847c901028d43b03e64902fd58954fac6b6e99) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183477))
- [Fix the GitLab import button on the user registration process](https://gitlab.com/gitlab-org/gitlab/-/commit/e228f5dd6ee275210bcb4394fd1d6519c852f2e9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186901)) **GitLab Enterprise Edition**
- [Ensure files are deleted from storage alongside dependency list exports](https://gitlab.com/gitlab-org/gitlab/-/commit/33e9a2c0c11c5c77484d5bb43ad5d79636d29e90) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186998)) **GitLab Enterprise Edition**
- [Update approval_project_rule name validation to include approval policy](https://gitlab.com/gitlab-org/gitlab/-/commit/138a68cedb4c9516766cab4976628065738f9f71) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186114)) **GitLab Enterprise Edition**
- [Fix string interpolation in MR discussion filter](https://gitlab.com/gitlab-org/gitlab/-/commit/fb5b19e62448ba524e52bfe95f1d3f43ce8a0497) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186942))
- [Fix bug in remember_me_available? helper](https://gitlab.com/gitlab-org/gitlab/-/commit/aa9d366b84dd48a81cbc43d7f97f97218875ebf8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186882))
- [Bulk indexing cron workers should respect pause setting](https://gitlab.com/gitlab-org/gitlab/-/commit/e35165b543e22c48c4e8941ec502bf13f95a4356) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186885)) **GitLab Enterprise Edition**
- [Do not try to access root ancestor if project is not under a group](https://gitlab.com/gitlab-org/gitlab/-/commit/8532473ef8ea3c7350b794b680a4981440d41eb9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186877)) **GitLab Enterprise Edition**
- [Pluralize bulk_import_csv mailer text](https://gitlab.com/gitlab-org/gitlab/-/commit/51d704cb9fe0a47430e7846ed05d6b0e79744712) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184976))
- [Fix behavior of merged MR widget](https://gitlab.com/gitlab-org/gitlab/-/commit/75f741e675ed6e48d12c151a999749add6bd95d9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186844))
- [Fix Duo Code Review failures when SAML SSO is enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/e90c41e6c81431af61b9a00b03457c7a2638b670) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186071)) **GitLab Enterprise Edition**
- [Fix N+1 queries in Linked Items widget](https://gitlab.com/gitlab-org/gitlab/-/commit/12b312e9809e5a00e6d1293caf485521143f1b13) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186076)) **GitLab Enterprise Edition**
- [Fix NoMethodError in IdentityVerifable](https://gitlab.com/gitlab-org/gitlab/-/commit/98fa85a6eaf3acabe9edec153fdb2da7be542a61) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186467)) **GitLab Enterprise Edition**
- [Update mr widget to consider cyclonedx artifacts](https://gitlab.com/gitlab-org/gitlab/-/commit/eeb294e06b6cff3faada41365fd0b9dc6ddcae50) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186603)) **GitLab Enterprise Edition**
- [Properly fetch assigned Duo users for self-managed instances](https://gitlab.com/gitlab-org/gitlab/-/commit/c05331954bf9b1ea43798f63166885fa2dde65ea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186712)) **GitLab Enterprise Edition**
- [Add line type to Duo Code Review input and handle chunk headers](https://gitlab.com/gitlab-org/gitlab/-/commit/4f3ed69d2f264d631924ad4b15946f1cb37049e3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186517)) **GitLab Enterprise Edition**
- [Fix ANSI color parsing and add specs](https://gitlab.com/gitlab-org/gitlab/-/commit/285bd10383c65ea3ec2ccf4d44d0d695e4754bad) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186625))
- [Fix 2 flaky tests](https://gitlab.com/gitlab-org/gitlab/-/commit/88f35c3c6b0b36369618442827b04895aba5f6ff) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186609))
- [Prevent negative number entry in CI/CD admin limit inputs](https://gitlab.com/gitlab-org/gitlab/-/commit/97dd57ecf17030d5019cc6636716c644d2ecd63e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186594))
- [Support AWS assume roles in Advanced search](https://gitlab.com/gitlab-org/gitlab/-/commit/5dcc8e2a5bab32956488435c4bbda71454fa0898) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185877)) **GitLab Enterprise Edition**
- [Fix accessibility of pipeline labels](https://gitlab.com/gitlab-org/gitlab/-/commit/797b04242409449e31a852916af0b26e81decb49) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186486))
- [Fix troubleshoot_job policy](https://gitlab.com/gitlab-org/gitlab/-/commit/797610d3dfe1e3262910a0e18d29b29438d0c5a1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186059)) **GitLab Enterprise Edition**
- [Fix 'Connect a cluster' button at group level](https://gitlab.com/gitlab-org/gitlab/-/commit/62192f2c3e214d54b2e21559f9f493d85ff682f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186168))
- [Pre-authorize work items children field](https://gitlab.com/gitlab-org/gitlab/-/commit/9170449b6d2560e806a4e430154ae9c3944ccd89) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182556))
- [Increase max packages limit for bulk destroy mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/37a76cc68c6bd136561a9551d32fc600ac748a73) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186494))
- [Fix: Omit null fields in CycloneDX export](https://gitlab.com/gitlab-org/gitlab/-/commit/20e900b824824a6da90877bb5d021174c1e7ae8e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182147))
- [Optimize SAML SSO session filtering in GroupsFinder](https://gitlab.com/gitlab-org/gitlab/-/commit/5e89fa606e290e1f100b476ee2d0dc4143165ffd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185382)) **GitLab Enterprise Edition**
- [Fix encoding for patch and diff responses](https://gitlab.com/gitlab-org/gitlab/-/commit/23c4ebac9acf007d19bc38c050d5ed682d01a9c3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186437))
- [Remove wrongly displayed line for Free Namespaces](https://gitlab.com/gitlab-org/gitlab/-/commit/fe069d924f10ccd229282eab1ccc5465bfe9ac42) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186425)) **GitLab Enterprise Edition**
- [Delete duplicate CI taggings in gitlab:db:deduplicate_tags](https://gitlab.com/gitlab-org/gitlab/-/commit/6dc2877c43aa0f42bc84813d2f2158334c5bc9d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186131))
- [Move group.cluster_agents field to CE](https://gitlab.com/gitlab-org/gitlab/-/commit/02401a4d60084abea5143a08554388aca42c2be6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186395)) **GitLab Enterprise Edition**
- [Fix auditing when same status is updated](https://gitlab.com/gitlab-org/gitlab/-/commit/9ca05f244185f382108299a3b3584669a960311c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186389)) **GitLab Enterprise Edition**
- [Fix pipelines mini graph separator](https://gitlab.com/gitlab-org/gitlab/-/commit/3400906915d963ab19e4b6b0bd26d1439a1d979f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186367))
- [Work item due dates ce and ee version](https://gitlab.com/gitlab-org/gitlab/-/commit/2c092b63c3a4c47291892c050d38abc2c20c02bf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185719)) **GitLab Enterprise Edition**
- [Avoid possible project authorization race condtions on project create](https://gitlab.com/gitlab-org/gitlab/-/commit/b264b307b26ce712bed6c168681215263b269a02) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185330))
- [Add job source options](https://gitlab.com/gitlab-org/gitlab/-/commit/a607e65dd4862e8385e37d14cc415db8220eba23) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186173)) **GitLab Enterprise Edition**
- [Update style of top bar search and fix a11y concern](https://gitlab.com/gitlab-org/gitlab/-/commit/3d4a3f40dc6878b9cfc9d04d04cbdc9fe7faba56) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186144))
- [Allow user to use keyboard to access pipeline job status tags](https://gitlab.com/gitlab-org/gitlab/-/commit/dc3f9eb6560bdd97375e7742594ee209fbfb8194) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185977))
- [Normalize pm_affected_packages package_name](https://gitlab.com/gitlab-org/gitlab/-/commit/41957a4a01238186c75758bcc8d6b447522a6090) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183732))
- [Return merge request count for non hidden users only](https://gitlab.com/gitlab-org/gitlab/-/commit/df4f76326d45708dab959565b879a887a6d17392) by @dagaranupam ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186177))
- [Ensure runner taggings are copied from taggings](https://gitlab.com/gitlab-org/gitlab/-/commit/c3282be1cb39693edd161659dd98ca45e047146e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186236))
- [Drop unwanted sequence on foreign key project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/550b92e65897756295b29f454dcc5324960c2a9a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186242))
- [Adjust work item create loading top margin](https://gitlab.com/gitlab-org/gitlab/-/commit/f01244527c7877f2227f6f9d583a501f6d3807ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186181))
- [Fix free push limit on non-saas](https://gitlab.com/gitlab-org/gitlab/-/commit/81a966fdae23daeb661bcc8bafe37b2e8f86c814) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186122))
- [Fix invalid pipelines for scan execution policies](https://gitlab.com/gitlab-org/gitlab/-/commit/811fad03fff1d00fe8c8d02f9e1761827c5fbb53) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185861)) **GitLab Enterprise Edition**
- [Send lowercase Cloud Connector HTTP headers](https://gitlab.com/gitlab-org/gitlab/-/commit/21a9d9690b8494c80e53fa7f3303323487914a8a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185072)) **GitLab Enterprise Edition**
- [Mark License Usage Banner as Dismissable After API Export](https://gitlab.com/gitlab-org/gitlab/-/commit/11be46bb3331f34e61ae6896511b209e37de3662) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185792)) **GitLab Enterprise Edition**
- [Ensure new epic route has a title](https://gitlab.com/gitlab-org/gitlab/-/commit/3b623c03894bb051b54a74576b6c5e63ce9a125c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185701)) **GitLab Enterprise Edition**
- [Fix analytics dashboard editor confirm prompt](https://gitlab.com/gitlab-org/gitlab/-/commit/e053ca3d28537b298f7ab06c2f1f65a27a7af7b1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185833)) **GitLab Enterprise Edition**
- [Configure first day of week according to user preferences](https://gitlab.com/gitlab-org/gitlab/-/commit/3fa16d77233e511583e03e15ef0087d9e542c91c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186104))
- [Apply group/project access token rotation logic to project_bot only](https://gitlab.com/gitlab-org/gitlab/-/commit/c90f8bde21946fef126891e2dd4404151f1935c6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185462))
- [Apply labels from quick actions and widget sidebar](https://gitlab.com/gitlab-org/gitlab/-/commit/c3fbd903697bf76389a5352921d222933205e98f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186074))
- [Remove the rebase_sha != newrev check](https://gitlab.com/gitlab-org/gitlab/-/commit/cfbe13d5b347858beb05d2e3d2fa8627e40ca5b9) ([merge request](gitlab.com/gitlab-org/gitlab/-/merge_requests/184558)) **GitLab Enterprise Edition**
- [Ensure current user is first to appear in assignee list if assigned](https://gitlab.com/gitlab-org/gitlab/-/commit/debf918b2bf7205ac4d72909bae390191fe91d28) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186015))
- [Fix missing autocompletes for work item comments](https://gitlab.com/gitlab-org/gitlab/-/commit/f144f10554b329c16138fbf1dcf927cea9b20910) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185685))
- [Reset pagination when changing todos filters](https://gitlab.com/gitlab-org/gitlab/-/commit/bbed22002b8fd5448ffacb8eca7746c99be61c92) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185817))
- [Remove unknown license insertion](https://gitlab.com/gitlab-org/gitlab/-/commit/103e4e780d131a7aff8dc5369526657f8a325379) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185163)) **GitLab Enterprise Edition**
- [Init conversion of terraform modules metadata semver to bigint](https://gitlab.com/gitlab-org/gitlab/-/commit/20d12cea8ffc69f25d720bb7a2a7dcdc2a341ed9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185252))
- [Correctly set archive for the archived records](https://gitlab.com/gitlab-org/gitlab/-/commit/226ad569cebe826888defeaa6aacf647e941f3b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185774)) **GitLab Enterprise Edition**
- [Fix handling of HTTP 500 errors in Geo GraphQL API](https://gitlab.com/gitlab-org/gitlab/-/commit/a9f12cf445f7434a07b7751031fada9750d8bd55) by @karras ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185506)) **GitLab Enterprise Edition**
- [Fix handling for current controls](https://gitlab.com/gitlab-org/gitlab/-/commit/a54bbce0fe64b113bacc1beb7100fc5e92bfd6ff) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185546)) **GitLab Enterprise Edition**
- [Retain existing page params while using design version dropdown](https://gitlab.com/gitlab-org/gitlab/-/commit/09edeeaad36cc872f434f4da72be7d5d30cc927a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185700))
- [Use semantic h3 for subscription table row title](https://gitlab.com/gitlab-org/gitlab/-/commit/ef72287637935d65b1f0eb515128a67c47baca2f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185339)) **GitLab Enterprise Edition**
- [Fix drag handles on work items loaded outside issue view](https://gitlab.com/gitlab-org/gitlab/-/commit/88fe04d5e722be64e286a8890625a7b0604da356) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185688))
- [Send only required fields to protected environment](https://gitlab.com/gitlab-org/gitlab/-/commit/c0b99b2b6513280f71429f725335c65878a03327) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185613))
- [Fix partitioned uploads table FK on projects](https://gitlab.com/gitlab-org/gitlab/-/commit/9a9fb6740cb228357018e11f91fbe6ea570bfe53) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185596))
- [Return success when pending promotions fails if user is billable](https://gitlab.com/gitlab-org/gitlab/-/commit/6ab29a04de252cd0ebfc0ac36d3b80a341d1befb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184894)) **GitLab Enterprise Edition**
- [Fix notification settings for Epic notifications](https://gitlab.com/gitlab-org/gitlab/-/commit/066c0acee523f2936fb3f1ca4a6ce48176c15f7d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185572)) **GitLab Enterprise Edition**
- [Fix issue when empty plans sorting to of terraform reports widget in MRs](https://gitlab.com/gitlab-org/gitlab/-/commit/5cb7b1f371be184f1a05674d8a7bacf7b893a2e8) by @BageDevimo ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185044))
- [Account for design note paths](https://gitlab.com/gitlab-org/gitlab/-/commit/1e3c4b04c2d600511fee131983a4ff6c777dae08) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185119))
- [Replace HTML entities with normal characters](https://gitlab.com/gitlab-org/gitlab/-/commit/b16bee6fc88f570e9f275c22ae6ae0bca3e4a39e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185446))
- [Add pipeline syntax check when publish and pages.publish both specified](https://gitlab.com/gitlab-org/gitlab/-/commit/5661b37e5227bc95812e2162bc74a317dcf99f2e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184878))
- [Enables full screen in create work item](https://gitlab.com/gitlab-org/gitlab/-/commit/6209c7076cbe62e374303d693f26b58d85c7e497) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185352))
- [Retain drawer params while switching design versions](https://gitlab.com/gitlab-org/gitlab/-/commit/0e54fdef6597fa4358ef3979f863b95fd58c5cfb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185321))
- [Truncate name in `namespace_metadata` panel](https://gitlab.com/gitlab-org/gitlab/-/commit/c24011b4479a2a23b92d9aea21fdde1ab28c5ef6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184831)) **GitLab Enterprise Edition**
- [Fix lookup of find_diff_start_pipeline_with_security_reports](https://gitlab.com/gitlab-org/gitlab/-/commit/7575f70a715c707753f0cf9692c5344c3c34a625) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185162)) **GitLab Enterprise Edition**
- [Add a11y labels to star, fork, MR and issue links on vue project list](https://gitlab.com/gitlab-org/gitlab/-/commit/dd0221bf14f6509db41577a9543dd54ee3beef2b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184503))
- [Don't add duplicate emojis to emoji cache](https://gitlab.com/gitlab-org/gitlab/-/commit/fa319c125f4240e45486f35d9202b02670a43516) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184999))
- [Adjust prompt_version for summarize_new_merge_request](https://gitlab.com/gitlab-org/gitlab/-/commit/90e7bcf64a4091a7967931ea6ce086e4c742b8e6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184818)) **GitLab Enterprise Edition**
- [Fix award emoji policy for group-level work items](https://gitlab.com/gitlab-org/gitlab/-/commit/f8af9621f79e6390f33b5acd5614533ae05b3a39) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185098)) **GitLab Enterprise Edition**
- [Fix gitattributes parser to apply patterns to subdirectories](https://gitlab.com/gitlab-org/gitlab/-/commit/c51af4068f732677989e071d47298d8ba0cb9785) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178281))
- [Fix bug in Mutation.ciJobTokenScopeRemoveProject](https://gitlab.com/gitlab-org/gitlab/-/commit/f9019e30584bbe69d873260286ed453738275cb6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185080))
- [Fix end date filter in global time tracking report](https://gitlab.com/gitlab-org/gitlab/-/commit/d9f3c08324b3628e9aa8861d28952253a89dd4d3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185057))
- [Ignore pending member in Direct Transfer member pipeline](https://gitlab.com/gitlab-org/gitlab/-/commit/45a28f3e3b6e3016ce58a750273a1e0aa73bbc8a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184360))
- [Avoid unrelated items from affecting finishing onboarding](https://gitlab.com/gitlab-org/gitlab/-/commit/926d3444800ac96725f92f07d73b121731144b6d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184949)) **GitLab Enterprise Edition**
- [Removes ordering requirement for funnel sync test](https://gitlab.com/gitlab-org/gitlab/-/commit/dda230ffb3171954739c071bcdb6e221852db17e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184956))
- [Detect organization_id change to be synced in project callback](https://gitlab.com/gitlab-org/gitlab/-/commit/20d7eeee84a1c2bafe77d96104091d5b513be0bc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184892))
- [Update docs to shoe private incident comments could be public](https://gitlab.com/gitlab-org/gitlab/-/commit/d4fd821c30682a46fd10208bfa528ed78885f6d5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184902))
- [Use source repository storage for forking process](https://gitlab.com/gitlab-org/gitlab/-/commit/0a1c67c212ca2e9558d5d09675011798ea2dce4f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183992))
- [Tags::CreateService: add a handler for NoRepository exception](https://gitlab.com/gitlab-org/gitlab/-/commit/0c5c735956eb2d057bcf218d8d63ad7752b8e71b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184759))
- [Show "Copy to clipboard" button in snippet descriptions](https://gitlab.com/gitlab-org/gitlab/-/commit/fefd83246978f5fd851521430aef3ae6198ef761) by @puxlit ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184752))

### Changed (195 changes)

- [Display /new command in suggested slash commands](https://gitlab.com/gitlab-org/gitlab/-/commit/790045dd3de20ea82afebef6d7b8c62fcf4e5d07) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178832)) **GitLab Enterprise Edition**
- [Show correct http error when accessing security policies](https://gitlab.com/gitlab-org/gitlab/-/commit/e4d66ab8f18d9d8919f7b23f3947c603a676d395) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186683)) **GitLab Enterprise Edition**
- [Update astro project template and move to pages/astro](https://gitlab.com/gitlab-org/gitlab/-/commit/47db86f29f718b3340db3ea1c4bdfe154dc519c7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187661))
- [Always show new thread when opening Duo Chat](https://gitlab.com/gitlab-org/gitlab/-/commit/2f4b128f09b29070f0d6d7a10f89afd3413452d4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186984)) **GitLab Enterprise Edition**
- [Stores instance ai logging config to database](https://gitlab.com/gitlab-org/gitlab/-/commit/305feb6657d58bea2f6ca389a1e56b6dbea91965) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186678))
- [Remove project_authorizations_update_in_background feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/ff0c7161ac3ecfbc93072ae88bfe8c7d54734461) by @Taucher2003 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187762))
- [Clarify access to PEP configuration when using $CI_JOB_TOKEN](https://gitlab.com/gitlab-org/gitlab/-/commit/1f0c8dc20f127c816acf07792a48d8bfc3b38eae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187712))
- [Remove seat assignment not null constraint](https://gitlab.com/gitlab-org/gitlab/-/commit/ed0737d0b1ba8ee8a7753e793e3bb73d6782af21) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185599))
- [Cleanup feature flags for vulnerability export](https://gitlab.com/gitlab-org/gitlab/-/commit/310f92c08fa801a188f48c79e29fc8cb34bf51c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187285))
- [ActiveContext: allow ref to define unique identifier](https://gitlab.com/gitlab-org/gitlab/-/commit/0261da0ddf338deaaa281adf5447a5b763d4799c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186986))
- [Project runner settings: Simplify group runner crud](https://gitlab.com/gitlab-org/gitlab/-/commit/f61a3914183c9f011f412a2b66a0ad046507a5d0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187288))
- [Swap ordering of Self-hosted Duo tabs](https://gitlab.com/gitlab-org/gitlab/-/commit/7e9e3a185cb238fe6b7383a2685b6cb7bc20ed71) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187660)) **GitLab Enterprise Edition**
- [Remove default value from topics sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/a587d594eebaf00e5e4bb0260d0215e169027d5b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186103))
- [Replace FK with LFK on lfs_object_states](https://gitlab.com/gitlab-org/gitlab/-/commit/9530f041a08c495e38596ac69fdb74191bae71c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186760))
- [Set product_usage_data FF enabled by default](https://gitlab.com/gitlab-org/gitlab/-/commit/a0cdd23e493a681c9169c18e22d3cd8e44998885) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187634))
- [Add modal when importing to personal namespace](https://gitlab.com/gitlab-org/gitlab/-/commit/77a5687b2ec5d8d991171dfaad0638c1c28f22ff) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186830))
- [Update search bar width and button text](https://gitlab.com/gitlab-org/gitlab/-/commit/7185a4f1b809818149821470a9bf4a84808083a1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186593))
- [Keep selected labels in the list in the labels selector](https://gitlab.com/gitlab-org/gitlab/-/commit/77787e06587afdf493c32f769a9edbf3f37f4584) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186850))
- [Add created and update design events to contribution calendar](https://gitlab.com/gitlab-org/gitlab/-/commit/4373738d449042724b371ce76d0883eb23cac9d4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186011))
- [Update PAT logic for tokens with expiry beyond 1 year](https://gitlab.com/gitlab-org/gitlab/-/commit/513bea2e8f5a3a8a3b1e236371e0d6a3641d6fda) by @guptapratibha26 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186314))
- [Add reachability into vulnerability list](https://gitlab.com/gitlab-org/gitlab/-/commit/181438c8e68ff1f8c399cb35834ab818db6ca21e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186879)) **GitLab Enterprise Edition**
- [Convert commands to filter in search modal](https://gitlab.com/gitlab-org/gitlab/-/commit/7b37714228af40808abb2d3f589f020fc48e234e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186580))
- [Update issue popover to include start–due date range](https://gitlab.com/gitlab-org/gitlab/-/commit/28f6772fa568a6e4fb2fbee2fd4367019e22521c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187010))
- [CI/CD Variables: Migrate masked value to dots](https://gitlab.com/gitlab-org/gitlab/-/commit/2f9ae7a444b6d6be2c0b77756a87031588a2f639) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187504))
- [Set security_policy_id to compliance_framework_security_policies](https://gitlab.com/gitlab-org/gitlab/-/commit/0e14966b6b13979ee6fe224c7c6ca5997d7c6c2b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186019)) **GitLab Enterprise Edition**
- [Compliance status report style tweaks](https://gitlab.com/gitlab-org/gitlab/-/commit/180055ad6d6629e5f9b6f6e92199bac69a48af23) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187490)) **GitLab Enterprise Edition**
- [Remove small or medium entries from Migration/UpdateLargeTable list](https://gitlab.com/gitlab-org/gitlab/-/commit/8123975b52a4916dc48b5645ec25e651034f14b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187428))
- [Create new Geo verification state table for Terraform::StateVersion](https://gitlab.com/gitlab-org/gitlab/-/commit/3a2605ea24dccd4a1e1539f8d03909fb4a6fbcc6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182457)) **GitLab Enterprise Edition**
- [Fix the placement of rca troubleshoot button](https://gitlab.com/gitlab-org/gitlab/-/commit/78f81b2ea0946bc12248fb57d504ef9d7bc0bd76) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185364))
- [Change sidekiq queueing related duration logic](https://gitlab.com/gitlab-org/gitlab/-/commit/5a17a56105842065a139f77bf7383146b4b28ea1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186982))
- [Project runner page: Migrate to Vue](https://gitlab.com/gitlab-org/gitlab/-/commit/93a610b2de09a3bec37691b60f67f16988da0c90) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186963))
- [fix: Updated Amazon Q error message note](https://gitlab.com/gitlab-org/gitlab/-/commit/cd080fc8c16df008d6452c142dc338491add44cd) by @protsivd ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186992)) **GitLab Enterprise Edition**
- [Update Code Generation to Claude 3.7 Sonnet](https://gitlab.com/gitlab-org/gitlab/-/commit/bf7caddbb7d419f02f0b1174ad5a32bb5dbb6010) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184335)) **GitLab Enterprise Edition**
- [Update compliance status report content](https://gitlab.com/gitlab-org/gitlab/-/commit/2fbf31072b291aa224cfd06dbc4dc1f59da03167) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187254)) **GitLab Enterprise Edition**
- [Set vulnerability_report_type_scanner_filter to default enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/81347c2e0f967e4a80497c8118ebe3e37a07e4ac) ([merge request](!187121)) **GitLab Enterprise Edition**
- [Removes organization_id default value](https://gitlab.com/gitlab-org/gitlab/-/commit/f26b98f7e1aa0a9207032bc852e4064c2f94fce2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186274))
- [Implement better rendering of compliance dashboard side drawer](https://gitlab.com/gitlab-org/gitlab/-/commit/ec8da87c2616edad501c10443a6c86e6df813c13) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187282)) **GitLab Enterprise Edition**
- [Pipeline header: Migrate to use shared PageHeading component](https://gitlab.com/gitlab-org/gitlab/-/commit/f3e5846b877df9a467184619c6a5fa1fe873abb2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187283))
- [Default enable generate_commit_message_claude_3_7](https://gitlab.com/gitlab-org/gitlab/-/commit/ac83517c337ee78f5df5dde13f73e057f5177ee1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187240)) **GitLab Enterprise Edition**
- [Default enable duo_code_review_claude_3_7_sonnet](https://gitlab.com/gitlab-org/gitlab/-/commit/c9fcfd735133cc05651dc5a42b39278eb148fb5d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187237)) **GitLab Enterprise Edition**
- [Add last_used_at attribute to SSHKey API entity](https://gitlab.com/gitlab-org/gitlab/-/commit/ef5bdaad7cb08a5a19fa3d0d66dabca45b03100b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187229))
- [Add skip ci configuration to default policy](https://gitlab.com/gitlab-org/gitlab/-/commit/f73ada4ba8ef35e18de2bbe4204eb6ac953d392e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186088)) **GitLab Enterprise Edition**
- [Remove security_policy_bot_worker feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/667fc2a68a1faab954fc06da8aa756e9f1783242) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186137)) **GitLab Enterprise Edition**
- [Limit scan execution policy schedule `actions`](https://gitlab.com/gitlab-org/gitlab/-/commit/bde3e26038edb2dd2e4b199f37eca9b8f9ea0b44) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186864)) **GitLab Enterprise Edition**
- [Map source ghost users to destination ghost users in importers](https://gitlab.com/gitlab-org/gitlab/-/commit/bf76e9d2178fe9e894ec0026303f6ea7ad34b8c8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186788))
- [Runner page: Update assigned projects](https://gitlab.com/gitlab-org/gitlab/-/commit/7d1d6c653ac3c64c088d29dfd4086dd3e35d5ed5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186842))
- [Improve the text so that the message is clearer](https://gitlab.com/gitlab-org/gitlab/-/commit/8c2b1d03bc8e7b37feb648b30ac4ec568c583caf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185641)) **GitLab Enterprise Edition**
- [Add ES filters for vulnerabilities](https://gitlab.com/gitlab-org/gitlab/-/commit/a9afa02e5e8a4c48d6452f4ba04ddd813fc23680) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184888)) **GitLab Enterprise Edition**
- [Compliance style tweaks](https://gitlab.com/gitlab-org/gitlab/-/commit/f59956335d8f1bdba04f0e3390d98578b378cea3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186767)) **GitLab Enterprise Edition**
- [Rename main plan to base product in namespace provision API endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/f0b07dea7ce729424323a4731a7dd04858cb235a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186978)) **GitLab Enterprise Edition**
- [Refactor SPP scan prechecks into PreconditionValidator class](https://gitlab.com/gitlab-org/gitlab/-/commit/ff486e999afd0564a1a3a4ab5ebbc0a67a5e74a9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183432))
- [Add Live Trace Application Setting](https://gitlab.com/gitlab-org/gitlab/-/commit/c1c3868fb552d4cbd1c8b8c9ade9ef85e94cfa9e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186182))
- [Updates to subscription cards](https://gitlab.com/gitlab-org/gitlab/-/commit/722360a66752b6c0f88ea1c286f63d0179266d0a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186033)) **GitLab Enterprise Edition**
- [Update location tooltip in the dependency page](https://gitlab.com/gitlab-org/gitlab/-/commit/c7db66d4677c208267b21fcd764a46fb82855c72) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186311)) **GitLab Enterprise Edition**
- [Limit scan execution policy pipeline `actions`](https://gitlab.com/gitlab-org/gitlab/-/commit/541e47271b36676b2dd96f157286a4e9d7266fcc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186854)) **GitLab Enterprise Edition**
- [Render Markdown in Pipeline Variable descriptions](https://gitlab.com/gitlab-org/gitlab/-/commit/2be99a1250ef09ac4e86054f7a5a5f0b34837787) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183823))
- [Add polling to last commit](https://gitlab.com/gitlab-org/gitlab/-/commit/156b03050e9284db828ba5ba01ecfcba5addbaa6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186888))
- [Expose expected archival date of vulnerability on GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/79dd3a18c1da3dc3c6353f93a55c298ec49c0750) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186974)) **GitLab Enterprise Edition**
- [Refactor error tracking widget to use GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/4eb5b403652e642e5f8304092ecf5812947b9f2c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185826))
- [MR elipsis menu: Add icons](https://gitlab.com/gitlab-org/gitlab/-/commit/85c9b35730442e21f50182e6cfbb9a6b9164b6b9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186953))
- [Add pipelines fine-grained permission for job tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/28bc3f6f84f8e6b4a9c0b69afea4e68e6896f880) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186965))
- [Remove feature flag on protected tags](https://gitlab.com/gitlab-org/gitlab/-/commit/407d5552b4e929e23a39b5ed231e61e1c876144d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186353))
- [Evaluate only for projects assigned to the framework](https://gitlab.com/gitlab-org/gitlab/-/commit/6a4c3d8808401712fad3778d8855da1d334b23f4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186940)) **GitLab Enterprise Edition**
- [Log token OAuth application ID when available](https://gitlab.com/gitlab-org/gitlab/-/commit/b45fcea1020bcc9c52506940a0458cd98ad59946) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186915))
- [Convert array types back to array on emit](https://gitlab.com/gitlab-org/gitlab/-/commit/94ea873fe2d4c985ebaf03a0708a91bb6d1e38fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186170))
- [Sync removal pages_deployments_deleted_at_index](https://gitlab.com/gitlab-org/gitlab/-/commit/be5ac9021f42fbb98fc7497464974f68ed6bbfda) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186432))
- [Update downstream name for multi-project child pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/19a9edf28914856217226cfc46695c2805ea3d4c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186191))
- [Migrate `.settings-message` elements to the Alert component](https://gitlab.com/gitlab-org/gitlab/-/commit/5b0a4819f94a4993dd30c8bceee0cbedbdd76b57) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186849))
- [Update availability of analytics dashboard designer to experiment](https://gitlab.com/gitlab-org/gitlab/-/commit/08bc0be88b4c731583daea90c1a9fdf79509128d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185377)) **GitLab Enterprise Edition**
- [Add max actions to scan execution policy](https://gitlab.com/gitlab-org/gitlab/-/commit/ef044efa160eb5eda9deb0842f82293c678b00c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186622)) **GitLab Enterprise Edition**
- [Update to proper tailwind classes](https://gitlab.com/gitlab-org/gitlab/-/commit/9e12ec7c92372855728bc30185a2635b43704a42) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186619)) **GitLab Enterprise Edition**
- [Reset accesslevel to Guest when promotion on a billable role](https://gitlab.com/gitlab-org/gitlab/-/commit/81d99e3a31add02958b55f6093b556dbf3eaee57) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186096)) **GitLab Enterprise Edition**
- [ActiveContext: add chunk preprocessors](https://gitlab.com/gitlab-org/gitlab/-/commit/3bc923ea370d7353ab72517d86a27086502c2aed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185913))
- [Add `scan_execution_policies_schedule_limit` application setting](https://gitlab.com/gitlab-org/gitlab/-/commit/0891c018ef6152b5945e103f2fab02cd0280ac54) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186095)) **GitLab Enterprise Edition**
- [Update company controller urgency](https://gitlab.com/gitlab-org/gitlab/-/commit/5a2a0443340448f9c0482ed1b94302b67f1659a0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186713))
- [Add security_policy_id to compliance_framework_security_policies](https://gitlab.com/gitlab-org/gitlab/-/commit/3d188b6c9f01bfb51999908a4be9dab307228c00) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185962)) **GitLab Enterprise Edition**
- [Move Your Workspaces from Edit Menu to Code Menu](https://gitlab.com/gitlab-org/gitlab/-/commit/8aeb89b4efe04a9e26274ac0f8402cf139e63252) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178492))
- [Runner edit: Improve view of project restrictions](https://gitlab.com/gitlab-org/gitlab/-/commit/11516c3bc142b50c715eafba440d611ef40175cd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185118))
- [Make instance_type runners routable](https://gitlab.com/gitlab-org/gitlab/-/commit/b3bf24fecb32b755f2244fa28a8a8339b52ca11d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186706))
- [Expose expires_at field for exports](https://gitlab.com/gitlab-org/gitlab/-/commit/92f5fc78f1c1cee112b26dfb775ac9e0939a78e6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186460)) **GitLab Enterprise Edition**
- [ActiveContext: support multiple jsons](https://gitlab.com/gitlab-org/gitlab/-/commit/6f6f1f9ad13203e82b2573933befa67457448341) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185781))
- [New work item kebab menu: Add icons to items](https://gitlab.com/gitlab-org/gitlab/-/commit/a9be666f296b03008347eafa7be722b3c7c5ecf0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186295))
- [Adjust alignment of project artifacts table](https://gitlab.com/gitlab-org/gitlab/-/commit/d6d8d90558edbefb70e5911cb6bf142b33567df6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186613))
- [Fix Duo Chat buttons that do not work on multithreaded](https://gitlab.com/gitlab-org/gitlab/-/commit/64685355f7f0685c419041f569556ea1c1c81a08) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186606)) **GitLab Enterprise Edition**
- [Remove second CTA on group members page](https://gitlab.com/gitlab-org/gitlab/-/commit/671c76341149981925babd85a8f2d5b74f45fa7f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186584)) **GitLab Enterprise Edition**
- [Add more details to estimate_cluster_size, udpate docs](https://gitlab.com/gitlab-org/gitlab/-/commit/9b24f0acdf5b444ee30021aa8b8b128351924588) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186118)) **GitLab Enterprise Edition**
- [Change file result title to two-lines](https://gitlab.com/gitlab-org/gitlab/-/commit/6e6c37cdcf9f6c8ec57101958da8fab3dff796b6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186235))
- [Add ability to distinguish Duo Chat commands from buttons](https://gitlab.com/gitlab-org/gitlab/-/commit/4173685335eaf80c592991c14989cf0cef0fa8db) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186338)) **GitLab Enterprise Edition**
- [Sync new index and drop old one for p_ci_pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/6c28b69078e9a5739bd154945049335eca143e7d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185025))
- [Allow users to customize Pages publish directory in setup wizard](https://gitlab.com/gitlab-org/gitlab/-/commit/7f2aeca2f94342766e481a790095374d86d3964b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185658))
- [Consolidate package registry application settings into one JSONB column](https://gitlab.com/gitlab-org/gitlab/-/commit/d3bc3cd744e2326d28cd3bc29bbe19dd6533ffec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186130))
- [Return the namespace cluster agent mapping after it is deleted](https://gitlab.com/gitlab-org/gitlab/-/commit/495bc4a22825045fc21eb9cfc7bc94b84a7a294d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184950)) **GitLab Enterprise Edition**
- [Refactor by_traversal_ids filter](https://gitlab.com/gitlab-org/gitlab/-/commit/b0582a80c26c77d89f99a40b3cee57bb51c49df0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186515)) **GitLab Enterprise Edition**
- [Runners project settings: Overhaul display of runners](https://gitlab.com/gitlab-org/gitlab/-/commit/c26a4798608d5283f32cf305423c2e5e53bfc871) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185232))
- [Remove vulnerabilities_as_webhook_events FF](https://gitlab.com/gitlab-org/gitlab/-/commit/5451d946b1d78fd9930027bc3eec2dd438511040) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186218)) **GitLab Enterprise Edition**
- [Token prefixes: Make feed tokens backwards compatible](https://gitlab.com/gitlab-org/gitlab/-/commit/c8f5d5757aa0d2242ffc474d358a685b900448af) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185538))
- [Respect global time tracking hours-only setting in work item issues view](https://gitlab.com/gitlab-org/gitlab/-/commit/b280fdfc997402b110083c9d414023b13ae4a29d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186480))
- [Allow internal users read external status checks response](https://gitlab.com/gitlab-org/gitlab/-/commit/9c109e566efd1f385e17fc3a71ae7b873db40e76) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185740)) **GitLab Enterprise Edition**
- [Hide Instance tab from Create from template page](https://gitlab.com/gitlab-org/gitlab/-/commit/6a78f3d1e0c49fc36485592a92dede34a1e47a49) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185832)) **GitLab Enterprise Edition**
- [Changed show more and less button inconsistent wording](https://gitlab.com/gitlab-org/gitlab/-/commit/a36496ebceb61a7eb6840100d78b0d4b13210d99) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186110))
- [Added scoped items to user search in command palette](https://gitlab.com/gitlab-org/gitlab/-/commit/0388f125a48e6cce08eacba6d5c18f8d2c4e777f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185974))
- [Add index that covers project_id, path_prefix, id in pages_deployments](https://gitlab.com/gitlab-org/gitlab/-/commit/ec80d3b2bf1df0498c1141de84a3e8f0b9e7e3ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185610))
- [Store the Kubernetes objects created when using managed resources](https://gitlab.com/gitlab-org/gitlab/-/commit/3c36e1f15e69a4bf16d181d9004d2716c294803e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186369))
- [Return unique Sbom::Component by name](https://gitlab.com/gitlab-org/gitlab/-/commit/65ae9788a37f92a03cbdcf370860408b70aa66bc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185816)) **GitLab Enterprise Edition**
- [Add immutability to tag rule model](https://gitlab.com/gitlab-org/gitlab/-/commit/617300f4018c525b53f48ce97db913bf7a757352) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183135))
- [Add documentation for `monospace` property in pipeline wizard](https://gitlab.com/gitlab-org/gitlab/-/commit/d41dab16f6f9e5cf659c0635f8361952077fa894) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186308))
- [Add tooltip to task list actions menu](https://gitlab.com/gitlab-org/gitlab/-/commit/b7fb55fe7e31b318a0c71fb33fc0bbb5fa1d454f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185691))
- [Drop cache_validity_hours from maven vreg registries table](https://gitlab.com/gitlab-org/gitlab/-/commit/7ba3feb3b77bcd53148d876c1f2b997f6104a2f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186239)) **GitLab Enterprise Edition**
- [More comfortable styles for custom wiki sidebar content](https://gitlab.com/gitlab-org/gitlab/-/commit/96e238f8a988564c5e33cbfe8ab963b2cdabe0d6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185678))
- [Add label to color picker GlFormInputGroup](https://gitlab.com/gitlab-org/gitlab/-/commit/b30a86f863be953e4aa8343f8ad074456a3c1fb0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179129))
- [Show requirements info in Frameworks report and Drawer](https://gitlab.com/gitlab-org/gitlab/-/commit/9f5ec6a524dd06ccc350662fa45046b21da39739) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177042)) **GitLab Enterprise Edition**
- [Move service ping worker to sticky data_consistency](https://gitlab.com/gitlab-org/gitlab/-/commit/5889eff92a1c14a7a21adc47eafa28c5baa6d95c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185983))
- [Improve CodeOwner section parsing logic](https://gitlab.com/gitlab-org/gitlab/-/commit/e24928c25da271e0022860b00e5fc2dee9d916b4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185180)) **GitLab Enterprise Edition**
- [CI Pipeline graph: Indicate groups as failed if job has failed](https://gitlab.com/gitlab-org/gitlab/-/commit/3eb1500607eed11abb0f3df20f9e1b0db621182f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185583))
- [Re-establish agent association for environments lacking agent links](https://gitlab.com/gitlab-org/gitlab/-/commit/9e0e9eb824d58d93fa61172e535fe9aacd5c3720) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185048))
- [Make entire collapsible state container widget header clickable](https://gitlab.com/gitlab-org/gitlab/-/commit/72aae849388e349eeba145f6063443c57b9d06f6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185852))
- [Remove search_migration_cleanup feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/4fe7a8b762104562a40f72f2b9c606332057303f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186162)) **GitLab Enterprise Edition**
- [Add docker hub rate limits alert](https://gitlab.com/gitlab-org/gitlab/-/commit/4ae9434c82c13e8c36dbc722fc61bcd779f5ba31) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186149))
- [Move partition_id to token payload](https://gitlab.com/gitlab-org/gitlab/-/commit/1862822c55cdc49491ff5840656df76dab453def) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183554))
- [Add not null constraint to started_at](https://gitlab.com/gitlab-org/gitlab/-/commit/7351751c164adb70859201a4f129f7340588d446) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175317))
- [Add conditional rounded corner styling](https://gitlab.com/gitlab-org/gitlab/-/commit/319824c07bb834eadc4bb030e9d477cd37572107) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186115))
- [Remove skip ci feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/65020b7a8cf05753218a7f1ae6051fce01948c3c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184518)) **GitLab Enterprise Edition**
- [Cleanup of feature flag 'filter_unknown_licenses_by_spdx_identifier'](https://gitlab.com/gitlab-org/gitlab/-/commit/23cfec0b763245f3b1b64b0f5f5a928d6e7cdf9e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184652))
- [Remove commit details async feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/303e8f543303f3c5ebe78921700bb170d7b18699) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186063))
- [Include "directly addressed" when filtering for "mentioned"](https://gitlab.com/gitlab-org/gitlab/-/commit/c9c7f068da72712cc57c54f669a55af4afe1a60f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185447))
- [Container queries for work item note content](https://gitlab.com/gitlab-org/gitlab/-/commit/67185c8b6c524372371a630a006eddd7553ce2ff) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184654))
- [Sort destination namespace results by similarity](https://gitlab.com/gitlab-org/gitlab/-/commit/66acef6bcece309ab72f2dad815d2fddbbb09667) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186001))
- [SPP refactor audit logger](https://gitlab.com/gitlab-org/gitlab/-/commit/2192df7d85689f386b330b926d051b36509767f6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183479))
- [Mini pipeline graph: Add max height to downstream dropdowns](https://gitlab.com/gitlab-org/gitlab/-/commit/615e4f74954f2dcf1743a7d809ffd4150aec89c7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185984))
- [Deactivate dormant users from enterprise groups](https://gitlab.com/gitlab-org/gitlab/-/commit/b299a615390e0c7be3cdcaddf314fa7c63af15ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184161)) **GitLab Enterprise Edition**
- [Remove FF use_related_pipelines_for_policy_evaluation](https://gitlab.com/gitlab-org/gitlab/-/commit/d55258e11c8bb70d70c868c4e76ef16d766be831) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185942)) **GitLab Enterprise Edition**
- [Project runner: Update destructive actions to secondary buttons](https://gitlab.com/gitlab-org/gitlab/-/commit/d4a61d3b683937c52205cf443232bdaea2ee37c9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185603))
- [Remove auto resolve banner](https://gitlab.com/gitlab-org/gitlab/-/commit/561889420b1f82297309fd518689d40741cae651) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185061)) **GitLab Enterprise Edition**
- [Cleanup Duo Chat Claude 3.7 feature flags](https://gitlab.com/gitlab-org/gitlab/-/commit/9d24b8b50f7edc71b5a2f20563e58f28f737a844) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185744))
- [Improve performance in edit framework screen](https://gitlab.com/gitlab-org/gitlab/-/commit/1d6f8ced1bf8356bb5449eb1c309f89275cb3509) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182029)) **GitLab Enterprise Edition**
- [Make entire header of collapsible crud component clickable to toggle](https://gitlab.com/gitlab-org/gitlab/-/commit/e8a9a51819dddb186ca722785e6d72db9ce2773f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183882))
- [Update layout of pipeline schedules variables form](https://gitlab.com/gitlab-org/gitlab/-/commit/05539c687ab8dcf55c43bd4d0823ea32967a7c00) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185821))
- [Update existing external status check secret](https://gitlab.com/gitlab-org/gitlab/-/commit/3694a8831e880406372910b9950aa5b13362d9d5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184072)) **GitLab Enterprise Edition**
- [Add arguments to Geo bulk update mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/7f2efb7f1db702634c3c9a37ff0576b946669850) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184960)) **GitLab Enterprise Edition**
- [Swap FK project_repositories.project_id for LFK](https://gitlab.com/gitlab-org/gitlab/-/commit/7da1ae6107c95456d33436f0f41bb6759072d2be) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185307))
- [Document IMDS V2 hop limit and other troubleshooting information](https://gitlab.com/gitlab-org/gitlab/-/commit/be4344a6b1c0f96a1ebc9c712585fe4a4f1b3cdd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185698))
- [Deprecate `restrict_user_defined_variables` in REST docs](https://gitlab.com/gitlab-org/gitlab/-/commit/feeb78693a3323fc7e4ad03b97620205af2abe5b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185594))
- [Update array validation](https://gitlab.com/gitlab-org/gitlab/-/commit/f2213f93d5c69134c3d11997f2340e3adabe5d74) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185293))
- [Remove user autocomplete feature flags](https://gitlab.com/gitlab-org/gitlab/-/commit/83eacb7a9cf52061007ed7cb7009e2406ca15d02) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185577))
- [Preserve text selection after removing or adding emphasis](https://gitlab.com/gitlab-org/gitlab/-/commit/2f5a8855ac0f7bee63bdebb77c58b66a96136ae4) by @Bubbis ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183087))
- [Add LFK triggers to pool_repositories](https://gitlab.com/gitlab-org/gitlab/-/commit/7304fc55df0d121569744f6e70d2a81bba0f1922) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182933))
- [Add userCalloutsDismisser to pipeline inputs adoption banner](https://gitlab.com/gitlab-org/gitlab/-/commit/697df2b8fb0bf04fab8797ce333a00ff3a1ee314) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185652))
- [Silence ActiveContext worker logs](https://gitlab.com/gitlab-org/gitlab/-/commit/75f8e0e84fba3f7575351d46f9ed1abf94b7d315) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185628)) **GitLab Enterprise Edition**
- [Token prefixes: Clarify level of support of automatic secret detection](https://gitlab.com/gitlab-org/gitlab/-/commit/951db3dba2910f4511e302c7155ad7cfaad94e40) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185590))
- [Swap FK group_wiki_repository_states.group_id for LFK](https://gitlab.com/gitlab-org/gitlab/-/commit/c2b0f8c80ff13dd7dec06dfed701d406d70084de) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185323))
- [Revisit snoozed todos timestamp display](https://gitlab.com/gitlab-org/gitlab/-/commit/2241a7f035d12f4f1b71d5a57afa7b651d0ae510) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184843))
- [Use UserCounts for Your Work > Issues pill](https://gitlab.com/gitlab-org/gitlab/-/commit/e0f41badddcfa04a9e02699df254e4ae5e77c16a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185066))
- [Use UserCounts for Your Work > Merge requests pill](https://gitlab.com/gitlab-org/gitlab/-/commit/82dd97aef6d425d30fb14d9b89369bef3735e741) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185066))
- [Use UserCounts for Your Work > To-Do List pill](https://gitlab.com/gitlab-org/gitlab/-/commit/f553a56b4b1f8a8795e8ead171277fc7ca55f80d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185066))
- [Swap FK group_wiki_repositories.group_id for LFK](https://gitlab.com/gitlab-org/gitlab/-/commit/251b96b0e1242d8e286de56c188cf06056674531) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185301)) **GitLab Enterprise Edition**
- [Allow to add inherited members to the group level protected environments](https://gitlab.com/gitlab-org/gitlab/-/commit/2ff85ea996a75177e24883e90db0ade9caf80cac) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185409)) **GitLab Enterprise Edition**
- [GraphQL: Rename CiPipelineCiSources to CiPipelineSources](https://gitlab.com/gitlab-org/gitlab/-/commit/a2e776b2d5cea0983e25d47257ca69a292a753b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184971))
- [Update protected packages feature to allow rule editing](https://gitlab.com/gitlab-org/gitlab/-/commit/4f30abb2dc09807ca302cda4f97aacbbcc4f4d13) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184868))
- [Allow for clicking anywhere on failed jobs widget to expand it](https://gitlab.com/gitlab-org/gitlab/-/commit/615745887d18b01c7a48244abf3a0f4fce2f3a54) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185347))
- [Use grid and container queries for layout of work item design widget](https://gitlab.com/gitlab-org/gitlab/-/commit/cccd8c41ce9ed7f7eeb1e3b08cd875b7253299e7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185172))
- [Swap FK geo_node_namespace_links.namespace_id for LFK](https://gitlab.com/gitlab-org/gitlab/-/commit/a86b9b4c4cdc1902d29a01f5c71db36644e5282f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185319))
- [Swap FK pool_repositories.source_project_id for LFK](https://gitlab.com/gitlab-org/gitlab/-/commit/8f3c73d0de50a461af26cf77fa1385db7345e4a1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185316))
- [Swap FK project_states.project_id for LFK](https://gitlab.com/gitlab-org/gitlab/-/commit/e2f27c59a1360c06eb835404cc9567de5e3ca495) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185313))
- [Remove pending members on switch from user caps to block seat overages](https://gitlab.com/gitlab-org/gitlab/-/commit/ec6048411622a5084fe41b7985c85f742d09a339) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184254)) **GitLab Enterprise Edition**
- [Rename `Created` sort option to `Recommended` in the todos app](https://gitlab.com/gitlab-org/gitlab/-/commit/0d5b057afabd13ba28a792bdc182c78d6a117378) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184982))
- [CI Pipeline graph: Indicate failed job on group better](https://gitlab.com/gitlab-org/gitlab/-/commit/a38d6ecf7724f413787082cd104f1b0c4259de7c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185269))
- [Validate saml and scim for sso requirements](https://gitlab.com/gitlab-org/gitlab/-/commit/10265371ad0f5797258cbd6169ecb852c2697d66) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183465)) **GitLab Enterprise Edition**
- [Check marketplace_home_url with user opt in](https://gitlab.com/gitlab-org/gitlab/-/commit/f939f624d92d97dce326ef4f82d4c441cfe6cf2c) by @pslaughter ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184569))
- [Update Google Cloud setup instructions](https://gitlab.com/gitlab-org/gitlab/-/commit/794ad935c88f5b73185bc2f01a7ae315ead6fad2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185145))
- [Update the status timeout message for Geo metrics](https://gitlab.com/gitlab-org/gitlab/-/commit/0ae98c12a2aa6b3c07cc68d7a61348de2caaeb48) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183082)) **GitLab Enterprise Edition**
- [ActiveContext build partition from name and number](https://gitlab.com/gitlab-org/gitlab/-/commit/70ab3b2fd5b6964389ab53112c36f9be406a9b18) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184775))
- [To-do dashboard: Optimistic updates to global count](https://gitlab.com/gitlab-org/gitlab/-/commit/65eb16ee11b77736cc2df95977ca80cbb3e06bd7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185112))
- [To-do dashboard: Tie pending counts to global UserCounts](https://gitlab.com/gitlab-org/gitlab/-/commit/5339e2c30ce88c36af936d1522998b3d3b321664) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185112))
- [Update form UX by marking optional fields](https://gitlab.com/gitlab-org/gitlab/-/commit/9764a0a306e8cb34d3520b1182dd7169b864c3e6) by @ahmad-kashkoush ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184678))
- [Prepare async index creation for p_ci_pipelines trigger_id and id desc](https://gitlab.com/gitlab-org/gitlab/-/commit/a5130c00d00a42994f77a823a03165bb633d47de) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185017))
- [Update secureflag text](https://gitlab.com/gitlab-org/gitlab/-/commit/10603f96988caf5b35989c31d4c4a6c57995cc95) by @mega6382 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168274))
- [Sentence case container registry](https://gitlab.com/gitlab-org/gitlab/-/commit/6b7717ad0cb3ce954fbfe1b92b68a6f886c663ae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183770))
- [Improve visibility for Database review in MR description](https://gitlab.com/gitlab-org/gitlab/-/commit/be92362ae798a30c85145d6fa16933d2e8fe4481) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184945))
- [Update projects finder to filter topics from user's organization](https://gitlab.com/gitlab-org/gitlab/-/commit/bdd8b550aa5a3ac41ad7c4e6137ea6f4e980820f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182816))
- [Rename Jobs column to Jobs Artifacts for consistency](https://gitlab.com/gitlab-org/gitlab/-/commit/8598e6cbb4eade39883caf3dd99f8e41e1ae42e2) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184932))
- [Adjust FeatureSettings Mutation to allow batch updates](https://gitlab.com/gitlab-org/gitlab/-/commit/33e5583db0cf97e8202996085af6ffd5665930b5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183319)) **GitLab Enterprise Edition**
- [Retry SyncServiceTokenWorker for up to 12 times](https://gitlab.com/gitlab-org/gitlab/-/commit/a97df4612ab6fcece1dd84a922fb61ca35e1666c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184924)) **GitLab Enterprise Edition**
- [Add Placeholder badge to admin users](https://gitlab.com/gitlab-org/gitlab/-/commit/ce3d39e9c3c6ae5e0723d23174873f3f064bcf65) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184927))
- [Update copy for User Cap disclaimer](https://gitlab.com/gitlab-org/gitlab/-/commit/7a6c4d645dc2272c82a744abf92e1a11c9475231) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184585)) **GitLab Enterprise Edition**
- [Raise error when deleting images with rules](https://gitlab.com/gitlab-org/gitlab/-/commit/3e4461ac6da80f8142e8064a34a2f8836dba95fb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183128))
- [Admin roles and permissions: Migrate components used](https://gitlab.com/gitlab-org/gitlab/-/commit/626440238a992e9601ea0bc2bf5fcde376eddcc3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184895))
- [Refine SAST template patterns](https://gitlab.com/gitlab-org/gitlab/-/commit/9b877a6a24bc9790a959977164d8ec40aceb6a2b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184795))
- [Filter Pipelines API by created_at date](https://gitlab.com/gitlab-org/gitlab/-/commit/897c56e0fbaec5b040967fbdcbb13d37834b88de) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182576))
- [Update amazon q notes](https://gitlab.com/gitlab-org/gitlab/-/commit/f35084ca566c2b6284110d447f4f135285426480) by @jlosito ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183858)) **GitLab Enterprise Edition**
- [Geo Replication List: Make name more readable](https://gitlab.com/gitlab-org/gitlab/-/commit/cacd26fea72ea6efdabfbc2de07d53b2671ea041) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184490)) **GitLab Enterprise Edition**
- [Consolidate unknown license feature flags](https://gitlab.com/gitlab-org/gitlab/-/commit/7c239b1784a4c487428671a7bc0a334e20c39ce4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184661)) **GitLab Enterprise Edition**
- [Update dependency auto-deploy-image to v2.126.0](https://gitlab.com/gitlab-org/gitlab/-/commit/154198926473e5a8658a4b2723d42a14156a8e71) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184589))
- [Remove Current.organization_id method](https://gitlab.com/gitlab-org/gitlab/-/commit/aa649ae71de4aa73e3a90b43805b2d16f0060ffa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184304)) **GitLab Enterprise Edition**
- [Prefix export subject line with exportable name](https://gitlab.com/gitlab-org/gitlab/-/commit/eaf73911c27e5add8a50a5d36943072b8e6ee937) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184101)) **GitLab Enterprise Edition**
- [Remove onboarding_step_full_uri feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/7f2d598492efe079b57ab29e13f429c1b23fd0cc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183362)) **GitLab Enterprise Edition**

### Removed (31 changes)

- [Marked SetComplianceFramework deprecated](https://gitlab.com/gitlab-org/gitlab/-/commit/700059f5c986c52cc6f1d2fef4ddbc6f5b2b02f2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187703)) **GitLab Enterprise Edition**
- [Remove Fireworks/Qwen support for SaaS](https://gitlab.com/gitlab-org/gitlab/-/commit/a9f0f05dcdece186f342d6a00314be0c9adfd001) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187397)) **GitLab Enterprise Edition**
- [Delete the `search_sidekiq_default_concurrency_limit` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/b598cab0a8542ec4ad148edfe1ecf1fd30648085) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187544))
- [Delete the `zoekt_index_pending_delete_repos` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/6235a0cd39c4210b9e00246970f0f70277f43bf1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187349))
- [Dropping control_expression and requirement_type columns](https://gitlab.com/gitlab-org/gitlab/-/commit/92e8354bc9dbb799a0acd2a3075a54117e5b6a49) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187281)) **GitLab Enterprise Edition**
- [Attempt 3 to remove the broken fk_fb57e6cc56_p](https://gitlab.com/gitlab-org/gitlab/-/commit/256e1bda904215d8223d677348e822380315ecb8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187090))
- [Remove spp_scan_diffs ff](https://gitlab.com/gitlab-org/gitlab/-/commit/6a04424e1b32628b42100b5acad15738cee94185) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185882))
- [Remove the merge_when_pipeline_succeeds code](https://gitlab.com/gitlab-org/gitlab/-/commit/dfb0c1d6ba11007200405684191ad88e904a5296) ([merge request](gitlab.com/gitlab-org/gitlab/-/merge_requests/185557))
- [Attempt 2 to remove the broken fk_fb57e6cc56_p](https://gitlab.com/gitlab-org/gitlab/-/commit/938c2bda54ea3a6eceb1b1832b4b97b6724a0b25) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186507))
- [Drop p_ci_pipelines_trigger_id_idx](https://gitlab.com/gitlab-org/gitlab/-/commit/a9b4bac80eabb19a05a54a43ae00dc8de5f1c7ae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186771))
- [Remove parse_conan_metadata_on_upload flag code](https://gitlab.com/gitlab-org/gitlab/-/commit/6ef6ddfde7b2c9b3ce575d1e179b39361e8c211f) by @mbo5be ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186292))
- [Remove hide_projects_of_banned_users feature](https://gitlab.com/gitlab-org/gitlab/-/commit/935ab67237cf8ddeabd3ce67f2242ae4cd04cad7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185004))
- [Remove amazon_q_chat_and_code_suggestions feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/b6afbcb12ccc383bd107d8117d39a1b6085d56d5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186296))
- [Remove all code of `/remind_me` proof-of-concept](https://gitlab.com/gitlab-org/gitlab/-/commit/222d20391416971d072a3ed9166ee84e9bd9a15f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185413))
- [Remove unused code for UsersFinder](https://gitlab.com/gitlab-org/gitlab/-/commit/0494fc1654dc0c125cd9f57123c305fe264af44f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186254))
- [Remove "Work item" option from category filter](https://gitlab.com/gitlab-org/gitlab/-/commit/e2a2eacf82fedf30dfff20fba2b15b9c9ca04847) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186077))
- [Remove broken fk fk_fb57e6cc56_p](https://gitlab.com/gitlab-org/gitlab/-/commit/bdef81677156fb2b810a6aa8e1928c5f4b7bd08c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185024))
- [Removed ignore rule for dropped column](https://gitlab.com/gitlab-org/gitlab/-/commit/a0f8c3ce465ce9a4efbb7615cb4793bdb38171a6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185854)) **GitLab Enterprise Edition**
- [Do not report search_zoekt_task_processing_queue_size in sidekiq](https://gitlab.com/gitlab-org/gitlab/-/commit/3567128b2ff312542bc1216710dc30ea240cf001) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185690)) **GitLab Enterprise Edition**
- [Remove `dora_projects_comparison_subgroups` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/dd5c9c41baf40a2c2942832b13bc3280b5a57592) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185815)) **GitLab Enterprise Edition**
- [Remove auto-deletion of banned user projects](https://gitlab.com/gitlab-org/gitlab/-/commit/1adc9de4b09f54cd975c9d1d6160603d16927097) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185456))
- [Remove broken foreign key fk_f29c5f4380_p](https://gitlab.com/gitlab-org/gitlab/-/commit/b14f6daa11f85114cc5e076d189fa65a55bd8ca8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183987))
- [Delete the `zoekt_reduced_pull_frequency` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/79b450511d02e9e35f1d0568169317ec43d0a9f7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185581))
- [Remove sep max_concurrency application setting](https://gitlab.com/gitlab-org/gitlab/-/commit/0030eebb4dc99348ad6b6fa261fecef7b8edd2dd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178892))
- [Attempt 2 to remove fk fk_a2141b1522_p](https://gitlab.com/gitlab-org/gitlab/-/commit/4b90a137a2a761f94c5b3e508556043aac8f8a9e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184285))
- [Remove old implementation of the Environment folder page](https://gitlab.com/gitlab-org/gitlab/-/commit/61e57062a646fddaf5acb34d5451f21e673c6792) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183212)) **GitLab Enterprise Edition**
- [Remove broken foreign key fk_rails_e214655a86_p](https://gitlab.com/gitlab-org/gitlab/-/commit/61ac96cca1592fc541a41f96f8bbb16f16e20afd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184022))
- [Delete the `zoekt_node_assignment` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/a47351923e759c445216fc40b11287021a1bf004) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184821))
- [Remove ci_auth_job_finder_in_runner_api and Ci::Build#valid_token?](https://gitlab.com/gitlab-org/gitlab/-/commit/a95dda6083aaccc4abb44f63de45f9a82278c5ec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184565))
- [Remove unused method #project_merge_requests_list_more_actions_data](https://gitlab.com/gitlab-org/gitlab/-/commit/34dae138f5238465e1d59536f716a08c0063238f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184835))
- [Remove filtering by packager](https://gitlab.com/gitlab-org/gitlab/-/commit/a622a18052b941d6765edf17408002e0061d9434) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184613)) **GitLab Enterprise Edition**

### Security (14 changes)

- [Add delay to when pointer events are enabled for 0Auth authorize page](https://gitlab.com/gitlab-org/gitlab/-/commit/e02da7cb01b2bda6eaedbf5e9d50133d39587e48)
- [Set the IP address state for Action Cable requests](https://gitlab.com/gitlab-org/gitlab/-/commit/4dfcaa61c92e172341175df32a2f5c844d8f0d81)
- [Do not enable pprof by default in Workhorse](https://gitlab.com/gitlab-org/gitlab/-/commit/753ddb6865f23dc2403bb03bb902772c9c381218)
- [Global search count leak for confidential issues](https://gitlab.com/gitlab-org/gitlab/-/commit/4be506cb69b703f41dc6edff34687a3a60b7a3ac)
- [Adding validation for Ci::Pipeline](https://gitlab.com/gitlab-org/gitlab/-/commit/8606ad7c7593b54fab2a1844d611db358e2f3187)
- [Bump workhorse golang-jwt/jwt to 5.2.2](https://gitlab.com/gitlab-org/gitlab/-/commit/1f741e3aa42d69891bdb5eb127531f951e5cfd24)
- [Filter LFS objects to prevent unauthorized access in merge requests](https://gitlab.com/gitlab-org/gitlab/-/commit/e71f6b01064d79f4933354d58cbac94f77fe0660) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186959))
- [Add CI/CD project setting `allow_composite_identities_to_run_pipelines`](https://gitlab.com/gitlab-org/gitlab/-/commit/d996802255df23ea7857868ce1375efb6883c525)
- [Inherit current_user external status while rotating project/group token](https://gitlab.com/gitlab-org/gitlab/-/commit/138f3c4b1549314e4286155c92def410b4c4e118)
- [Prevent XSS via merge error on the merge request page](https://gitlab.com/gitlab-org/gitlab/-/commit/5e1e1affa536552d9d7f1d50a081a6e98682d8be)
- [Sync organization user access when admin status changes](https://gitlab.com/gitlab-org/gitlab/-/commit/3837a1ad2486f34a2d3376bbea1382b9ff9fa980)
- [Add validations for the project_name of Harbor integration](https://gitlab.com/gitlab-org/gitlab/-/commit/d71bb82df57e812e557165c4650349b81eb2d807)
- [Sanitize returned input on asciidoc Timeout](https://gitlab.com/gitlab-org/gitlab/-/commit/e6fbb87bfa3ee2bc00d0a62b685bc540488a86dd)
- [Add limit to resource counts in tfplan merge request report](https://gitlab.com/gitlab-org/gitlab/-/commit/ef8fda85fb9386476224169a22dd12c962dbf802)

### Performance (2 changes)

- [Enable bitbucket_server_notes_separate_worker by default](https://gitlab.com/gitlab-org/gitlab/-/commit/d4e8f69aac54c48eb666bfe450aa755a5c040c5a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187133))
- [Reduce queries when building pipeline webhook data](https://gitlab.com/gitlab-org/gitlab/-/commit/277360202bfd0521aa5899c0e38b5ac97a8ac55f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184704)) **GitLab Enterprise Edition**

### Other (157 changes)

- [Create new contributions materialized view](https://gitlab.com/gitlab-org/gitlab/-/commit/d27fccd1927a0135e6d1e427d5cd65c5ae7e9940) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186895))
- [GraphQL: Remove deprecation of ciMinutesUsed](https://gitlab.com/gitlab-org/gitlab/-/commit/06dc9f1e6594dd1df402883b97ea75d973f288d4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187830))
- [GraphQL: Remove deprecation of runner active field](https://gitlab.com/gitlab-org/gitlab/-/commit/bc3663090aace201020204101a12cb8882ac4d12) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187829))
- [Remove feature flag project_deletion_notification_email](https://gitlab.com/gitlab-org/gitlab/-/commit/9f9c3d3f00cba757bd0f262fbc0eb24a02e713fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187157))
- [Remove bulk_update_work_items_mutation feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/d02591ffae276c43cb7f0d8f84033056fc64e05f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187720))
- [Add and backfill lists sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/324243f85509102dba4a6bf938bf9a35d4652cc9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186991))
- [Finalize the finish onboarding for enterprise user backfill](https://gitlab.com/gitlab-org/gitlab/-/commit/7b31575b8b25b006293fa801833b56eef3501cef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187713))
- [Fix Duo with Amazon policy](https://gitlab.com/gitlab-org/gitlab/-/commit/f0d250e5d4fa090b3fbc7119fb1e99f46bf9b5da) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187675))
- [Add NOT NULL for sharding key on \](https://gitlab.com/gitlab-org/gitlab/-/commit/5a86e3b3fbe4053fae141d93855427a40fab8eb1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187636))
- [Remove feature flag for PK lookup using functions](https://gitlab.com/gitlab-org/gitlab/-/commit/5e7a4fce88345fb27cc60608d686d4595cd15005) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180892))
- [Add created rule ID to security policy diff](https://gitlab.com/gitlab-org/gitlab/-/commit/d79b850aefad9c2601bc2236ba6c7d7e30d9b634) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187175)) **GitLab Enterprise Edition**
- [Remove application code from onboarding status role backfill](https://gitlab.com/gitlab-org/gitlab/-/commit/b6bab5b60d44f5bb61a0a6de8c6eb348e3623ed1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187401))
- [Finalize migration IncidentManagementIssuableEscalation](https://gitlab.com/gitlab-org/gitlab/-/commit/7a13eabfd47740f828af60e2cb1693aaad4767cf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187219))
- [Add and backfill organization_id for bulk_import_configurations](https://gitlab.com/gitlab-org/gitlab/-/commit/53111765c9d49e929828f846aa8d9999a1743f68) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187337))
- [Remove worker data consistency feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/4a2bedaa0999bda69a612e712187f5269fa1ac49) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187287))
- [Force update reserved_storage_bytes for overprovisioned indices](https://gitlab.com/gitlab-org/gitlab/-/commit/5001ad3093f3dfab603050928328fe928c970f36) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186410)) **GitLab Enterprise Edition**
- [Remove filtering_optimization_for_work_items references](https://gitlab.com/gitlab-org/gitlab/-/commit/3bd09dedffb3ff429ebf092dadfb5e5527200c80) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187444))
- [Clarify when "due soon" email is sent](https://gitlab.com/gitlab-org/gitlab/-/commit/2979308ed713acba949c167d04f8909eaee51042) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187185))
- [Protected packages: Extend docs for minimum access level for delete](https://gitlab.com/gitlab-org/gitlab/-/commit/80d5cbf1329f2ff171f5bce4ed5418374bd23961) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186585))
- [Add NOT NULL for sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/035d1a5f065fd86f3c36b40abd0ebfa06105a9cc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186784))
- [Extract Work Item userPermissions to its own fragment for CE & EE](https://gitlab.com/gitlab-org/gitlab/-/commit/d855ebf9a62d419103aa3ec88749f60e43b8560a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187007)) **GitLab Enterprise Edition**
- [No-op FinalizeBackfillCiRunnerMachinesPartitionedTable migration](https://gitlab.com/gitlab-org/gitlab/-/commit/70e3051e3508e4fb48a06a2d613770efca1b3d1e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187339))
- [Add NOT NULL on vulnerability_external_issue_links.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/b217c3e0924442b6d5ffc7fdd7b58d1532d98eab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182697))
- [Make "Approved by" MR fliter use sentence case](https://gitlab.com/gitlab-org/gitlab/-/commit/01223f527b179794072c1bb1916e47870218cfe4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187159))
- [Add NOT NULL for sharding key on packages_npm_metadata](https://gitlab.com/gitlab-org/gitlab/-/commit/6a7ffcefa7130810da169e44585b50d2a631c427) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186623))
- [Reindex Elasticsearch project index to update integer with long type](https://gitlab.com/gitlab-org/gitlab/-/commit/81b308dda26bc8b13eb9aa8e75ecdf5593405162) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187003)) **GitLab Enterprise Edition**
- [Finalize migration BackfillIssuableMetricImagesNamespaceId](https://gitlab.com/gitlab-org/gitlab/-/commit/6d101f05e0780d4c749e8ddf0e13723bd64e88f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187220))
- [Clarify that "Watch" doesn't include all notifications](https://gitlab.com/gitlab-org/gitlab/-/commit/e3f01f15bd93a4dd436e8b9843451b518b2dd04a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187193))
- [Delete ci build trace metadata record after archive](https://gitlab.com/gitlab-org/gitlab/-/commit/bfdc5fd7a61f6a1cb155077ed07b4e02278d6f7e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186748))
- [Update values for ci_runner_machines_archived in LFKs](https://gitlab.com/gitlab-org/gitlab/-/commit/9288aff65a4de1b5b276325a85198267b8850997) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187110))
- [Cleanup Redis BufferedCounter post migration](https://gitlab.com/gitlab-org/gitlab/-/commit/374854440b3c717fbc25bd908f63b7c7bcb9b18e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187130))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/e33145e961fe6e352595e0dc76be9883192d62dc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187125))
- [Remove feature flag autocomplete_projects_use_search_service](https://gitlab.com/gitlab-org/gitlab/-/commit/8cbd1b5263bd298ee181864b2a324400ecdb4e73) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186513))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/b6e4015fae95cfd9db3aa76f2ef868d4127765a9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187087))
- [Document how to troubleshoot object storage migration inconsistencies](https://gitlab.com/gitlab-org/gitlab/-/commit/4ee9c4307eb09f5867746e4bdd0296e90e1f99c1) by @karras ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185399))
- [Add migration to delete orphaned routes](https://gitlab.com/gitlab-org/gitlab/-/commit/a225ffdc3203253a9d4e6f4b9dd0277f16555e76) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186659))
- [Update Storybook to v7](https://gitlab.com/gitlab-org/gitlab/-/commit/ffdd260314665407ecf16c5e28de85bd7147d81e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174526))
- [Fetch component name from sbom_components](https://gitlab.com/gitlab-org/gitlab/-/commit/11b873f1ad39eacb388724c256cf1cc539bd74ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186813)) **GitLab Enterprise Edition**
- [Finalize migration BackfillFreeSharedRunnersMinutesLimit](https://gitlab.com/gitlab-org/gitlab/-/commit/bb892643553ac1466e97936f72f131a9b66ddc94) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186909))
- [Remove GitLab Duo features from Duo with Amazon Q docs](https://gitlab.com/gitlab-org/gitlab/-/commit/481c4fe4cc3c8875907bd6edbecb52678b0124ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186884)) **GitLab Enterprise Edition**
- [Remove force_cancel_build FF](https://gitlab.com/gitlab-org/gitlab/-/commit/12fb08061b4a4c413e8f04844b800dea41cafa59) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186132))
- [Ignore runtime_runner_features on builds metadata](https://gitlab.com/gitlab-org/gitlab/-/commit/e9061dea14c673928236db4254826a7fe6ad37ff) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186826))
- [Clean up feature flag cleanup_stale_policy_violations](https://gitlab.com/gitlab-org/gitlab/-/commit/8a2c2aecdafaf719a2b0054b4662fcd3cbae869c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186785)) **GitLab Enterprise Edition**
- [Clean up feature flag pat_expiry_inherited_members_notification](https://gitlab.com/gitlab-org/gitlab/-/commit/35c0b7fb4143d84e2ab98f58b82ba40981b42455) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184677))
- [Add API endpoint rate limit for virtual registries](https://gitlab.com/gitlab-org/gitlab/-/commit/7db3f49ffae17fee7d15075555e99dd8a9f473da) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185280))
- [Sync translations from crowdin (2025-04-02)](https://gitlab.com/gitlab-org/gitlab/-/commit/ddda898e27625b9185582657225377aa22eb1b12) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186677))
- [Drop issues.correct_work_item_type_id column](https://gitlab.com/gitlab-org/gitlab/-/commit/cf28d67cbed6f9853e0aa3d243002f2f56974992) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185979))
- [Clean up blame_ignore_revs feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/99ed55ecf0640228cafff594c5bcd50f283b50ad) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186479))
- [Sync translations from crowdin (2025-03-31)](https://gitlab.com/gitlab-org/gitlab/-/commit/bb6a4f8b3669210ad509f490e1606598a60fceb6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185933))
- [Update workers data_consistency](https://gitlab.com/gitlab-org/gitlab/-/commit/f9d3c90f714b821ae4c06ba4a9b47068281dc240) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186079))
- [Limit dependency paths returned for a vuln](https://gitlab.com/gitlab-org/gitlab/-/commit/f2b99c01cd3114cad42d082ba6f4be1b3ca2f43e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186543)) **GitLab Enterprise Edition**
- [Document Container Repositories as part of the Geo data types](https://gitlab.com/gitlab-org/gitlab/-/commit/c20840b17ab0ff8865a68a37df975c841a6d6517) by @karras ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186343))
- [Finalize migration BackfillPersonalAccessTokenSevenDaysNotificationSent](https://gitlab.com/gitlab-org/gitlab/-/commit/9910ff959837c7d44efe7293bf15ce855c8fec3a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185359))
- [Add NOT NULL for sharding key on incident_management_escalation_rules](https://gitlab.com/gitlab-org/gitlab/-/commit/e89c5865d42321b0d79e0c25c20a47a29e664bf1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186611))
- [Ensure user is authorized to push NuGet packages](https://gitlab.com/gitlab-org/gitlab/-/commit/4fa32f666589542c5492d52db9f6c0ff547f1107) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184495))
- [Make "Target Branch" MR filter use sentence case](https://gitlab.com/gitlab-org/gitlab/-/commit/3fa9c0472c651b9a13b96e46e995d640f28f826e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186160))
- [Add documentation to service access tokens revocation](https://gitlab.com/gitlab-org/gitlab/-/commit/ae7ee293278f0dbc533efacf8e285716aa4b53ac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184288))
- [Fix flaky tests for Loose Foreign Keys](https://gitlab.com/gitlab-org/gitlab/-/commit/4150b637c32af5e932d067e3d18cea130b5952b2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185770))
- [Add project export event tracking](https://gitlab.com/gitlab-org/gitlab/-/commit/a8b38425a7cdb826c5d579155c64dc45c9e37e20) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186125))
- [Add NOT NULL for sharding key on milestone_releases](https://gitlab.com/gitlab-org/gitlab/-/commit/dce0b3bb845f9572d8eba695fe8d204c2522283e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186452))
- [Migrate Amazon instance audit event destinations](https://gitlab.com/gitlab-org/gitlab/-/commit/ec0e2a07e5d2a383ba76c1672492562350d1ccb9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184039)) **GitLab Enterprise Edition**
- [Remove deprecation for cancel pipelines api](https://gitlab.com/gitlab-org/gitlab/-/commit/92f80a2b42188cff73819da0aea32940ade5c578) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185919))
- [Removes the add_timezone_to_web_operations](https://gitlab.com/gitlab-org/gitlab/-/commit/23ec12fcb4de4f57d37414318440fb75efdbeb60) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186156))
- [Display with Amazon Q on duo chat button when enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/bfd8bbe2e43b66f96cc519638da38bd19ef8b939) by @jlosito ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186012)) **GitLab Enterprise Edition**
- [Remove cancel gracefully from metadata](https://gitlab.com/gitlab-org/gitlab/-/commit/eeb8e8dbaf0dcc7bd18ca95a6be184e563759be2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186123))
- [Backfill organization_id on fork_networks](https://gitlab.com/gitlab-org/gitlab/-/commit/1d79c7141aba4f455d2e634ade1616dadf77be4c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184051))
- [Add duo seat assignment task to learn gitlab](https://gitlab.com/gitlab-org/gitlab/-/commit/899a7912601d7b22d0721d166e284e6568e16fb3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185851)) **GitLab Enterprise Edition**
- [Add reemit event to speedup](https://gitlab.com/gitlab-org/gitlab/-/commit/efc0ea19dbf160c46f6c3cd407d1f316ba54c6fc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186241)) **GitLab Enterprise Edition**
- [Drop admin-token from internal CDot](https://gitlab.com/gitlab-org/gitlab/-/commit/2efd4eb72bb0ff502710ee0faec1fe3f00a7b79e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184780)) **GitLab Enterprise Edition**
- [Rename usage of file to blob in Geo](https://gitlab.com/gitlab-org/gitlab/-/commit/b84b39131e82339a59404ae5187edc56df1da651) by @karras ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186346)) **GitLab Enterprise Edition**
- [Remove runner registration token deprecations](https://gitlab.com/gitlab-org/gitlab/-/commit/0d5a4c568799502738d402a0afc7690a1f7373fc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184746))
- [Add BBM to migrate group legacy HTTP destinations](https://gitlab.com/gitlab-org/gitlab/-/commit/f449a751040c897fd1bb7f2e1f974b3ab90c41cc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183044)) **GitLab Enterprise Edition**
- [Migrate Google Group audit event destinations](https://gitlab.com/gitlab-org/gitlab/-/commit/c5edb778f8753667f9b9a276dad7d613e0e03443) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183043)) **GitLab Enterprise Edition**
- [Add BBM to migrate group legacy Amazon destinations](https://gitlab.com/gitlab-org/gitlab/-/commit/8f371333271b960c02b961c87bfabea124e3d984) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183042)) **GitLab Enterprise Edition**
- [Add NOT NULL on error_tracking_error_events.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/483fa08cec0f7c8c1c7931d328df2299ed738aef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184908))
- [Remove beta from Amazon Q auto complete descriptions](https://gitlab.com/gitlab-org/gitlab/-/commit/4c4ae3d5aed1505d5ea3b7951c067c439e6b4671) by @jlosito ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185976)) **GitLab Enterprise Edition**
- [Move the FF to ops to enable by default](https://gitlab.com/gitlab-org/gitlab/-/commit/73fe131fdde462efa11f3b39cba4a908e080eefa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185994)) **GitLab Enterprise Edition**
- [Remove the `merge_request_dashboard_merge_checks` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/9645bb26657da635edfcdffefb623bb6b7729785) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185943))
- [Make work item quick actions text consistent](https://gitlab.com/gitlab-org/gitlab/-/commit/ceb79039f8611097f114005f6d7f10355acb99fc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185087))
- [Backfill redirect_routes.namespace_id](https://gitlab.com/gitlab-org/gitlab/-/commit/1e33da44b5da277319eb653e5db004ee31b6efc5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183967))
- [Add NOT NULL on vulnerability_occurrence_identifiers.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/0794341940e412b1a505c8d7c34dfc4725289380) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184914))
- [Add NOT NULL on projected_environment_deploy_access_level sharding keys](https://gitlab.com/gitlab-org/gitlab/-/commit/75137f87db9a17e22ac39e065b8f04abed907b9e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184913))
- [Finalize migration BackfillDependencyProxyBlobStatesGroupId](https://gitlab.com/gitlab-org/gitlab/-/commit/daf547adfe7d3b995eb8232b96ac5242c21d49ed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185870))
- [Finalize migration SetTotalNumberOfVulnerabilitiesForExistingProjects](https://gitlab.com/gitlab-org/gitlab/-/commit/df45c6189205abd62569e5cc7eb0a019fc778a27) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185868))
- [Deprecate the merge_when_pipeline_suceeds push option for auto_merge](https://gitlab.com/gitlab-org/gitlab/-/commit/1c915d0c94497794fc12b8f38e928279db833a01) ([merge request](gitlab.com/gitlab-org/gitlab/-/merge_requests/185368))
- [Finish user onboarding when the user is an enterprise user](https://gitlab.com/gitlab-org/gitlab/-/commit/ac0cbee13c7bf9b0f8ad78496510bff97cb60771) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183597))
- [Finalize migration BackfillPackagesRubygemsMetadataProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/15a3e84b510257d98dec982f3f792cda6cb3c0dd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184715))
- [Initialize conversion of MergeRequestDiff Id columns to bigint](https://gitlab.com/gitlab-org/gitlab/-/commit/71e0d153588fd08112c9a0ae7bb7dbf82a1184b6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185829))
- [Add information about the known issue](https://gitlab.com/gitlab-org/gitlab/-/commit/d8bcaa2c14d936d4240ba520af5321397232f5f6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185787)) **GitLab Enterprise Edition**
- [Add a description for the /using_docker_images doc to improve SEO](https://gitlab.com/gitlab-org/gitlab/-/commit/dee061d10d949d7b99c32573c55db44f025db645) by @nikitasakau ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185830))
- [Create new ClickHouse events table](https://gitlab.com/gitlab-org/gitlab/-/commit/64a3543aca26be2e214d54da0a0e7f34b34326f4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185318))
- [Complete the virtual registry cleanup worker rename](https://gitlab.com/gitlab-org/gitlab/-/commit/a338bc736c82b53e3b55221097cc03cd060d394a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185394))
- [Sync translations from crowdin (2025-03-25)](https://gitlab.com/gitlab-org/gitlab/-/commit/7e26a7e2736f436063927065fd0a4aed45a002e9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185766))
- [Add models for mapping ldap group to admin custom role](https://gitlab.com/gitlab-org/gitlab/-/commit/e589958fceefed248c5bbc53005900e18168d74b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184606))
- [Re-queue migration to delete orphaned groups](https://gitlab.com/gitlab-org/gitlab/-/commit/dfacf7c245612677611ed6a2813f5a5510b852d9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183639))
- [Remove ai_features_enabled and improve ai_features_banned policy](https://gitlab.com/gitlab-org/gitlab/-/commit/a3209ecd33628f3983179f964a523bd7737b7acb) by @karras ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185526)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/e21af91d984ef28ba6459ca517a70d6a7ee0f5ce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185560))
- [Add organization support to merge request diff commit users](https://gitlab.com/gitlab-org/gitlab/-/commit/7ce6b0fc39df4192bf8074e48ecf505c7b83613e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185110))
- [Remove the `todos_bulk_actions` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/577e106ee27a3eecf940ff8358c940f74818c7ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185346))
- [Backfill approval_policy_rule_id in scan_result_policies](https://gitlab.com/gitlab-org/gitlab/-/commit/6ccf311aeccb8fdaf7f44b1357e4a793af506aae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182584)) **GitLab Enterprise Edition**
- [Drop RequeueDeleteOrphanedPartitionedCiRunnerMachineRecords](https://gitlab.com/gitlab-org/gitlab/-/commit/ed977ff792a53e994c52ee3934543972f51882b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185296))
- [Drop DeleteOrphanedPartitionedCiRunnerMachineRecords migration](https://gitlab.com/gitlab-org/gitlab/-/commit/79d60a9bb8dbbb138a4389c0b7f75b5bc364ca5f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185296))
- [No-op ci_runner_machines_687967fa8a table backfill migration](https://gitlab.com/gitlab-org/gitlab/-/commit/310f927b571674eb0c3960e267cdec3b074da8ac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185296))
- [Fix Graphql/ResourceNotAvailableError offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/2ed1cbe93de40c86345d295ec909ffc1a29e9f97) by @prileygraham ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180834))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/e107e3da94327918efaf640241a594454dd6cd1d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185614))
- [Add and backfill project_id for packages_helm_file_metadata](https://gitlab.com/gitlab-org/gitlab/-/commit/f16f444609ac7965540542cfbb9ab319a9fab272) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185225))
- [Sync translations from crowdin (2025-03-24)](https://gitlab.com/gitlab-org/gitlab/-/commit/c342c7eaf74ae19cab3fae1789bf8af2e98c75ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185612))
- [Change "My-Reaction" filter to "My reaction"](https://gitlab.com/gitlab-org/gitlab/-/commit/e15615edffe8179f3e20142a85280a450097a09a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185235))
- [Removing old CI partition tables from LFK config file](https://gitlab.com/gitlab-org/gitlab/-/commit/7d44361993406fe7c5f375f957a2bfe0a790c0b4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185121))
- [Add NOT NULL on merge_request_user_mentions.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/cf81582254b6fc4e6555ef200fa558617ccc5ffc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182696))
- [Remove custom debug message in organization_controller_spec](https://gitlab.com/gitlab-org/gitlab/-/commit/1c3f1e497d978584e75251af4b4432cf34f58c33) by @karras ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185116))
- [Finalize migration FixProjectSettingsHasVulnerabilities](https://gitlab.com/gitlab-org/gitlab/-/commit/908f2157b1ddbe4070b89bdf5e10a845cb9094ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185360))
- [Add service pings for runner token expiration by runner type](https://gitlab.com/gitlab-org/gitlab/-/commit/94f2d2bde346fcf8aaf783d5b875b398de1ec4c7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185544))
- [Drop partitioned copy of merge_request_diff_commits](https://gitlab.com/gitlab-org/gitlab/-/commit/b12f17e6a154982cf14fb25e225eae1e1ed0db75) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182794))
- [Add and backfill project_id for packages_package_file_build_infos](https://gitlab.com/gitlab-org/gitlab/-/commit/de7d888a47d5e4341533b4d3502410469610cbd8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185226))
- [Add and backfill project_id for packages_debian_file_metadata](https://gitlab.com/gitlab-org/gitlab/-/commit/f1faf75aacce3a84f932961ab44c75b625ec70e2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185223))
- [Add and backfill project_id for packages_conan_file_metadata](https://gitlab.com/gitlab-org/gitlab/-/commit/0b9cd3abebf7ed1e8cdf5b0bbd833b2cb1272d80) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185222))
- [Reduce increased query count for decomposition](https://gitlab.com/gitlab-org/gitlab/-/commit/8e35239767074e9621ed6e5d21c75b128aecb8ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169462)) **GitLab Enterprise Edition**
- [Sync translations from crowdin (2025-03-21)](https://gitlab.com/gitlab-org/gitlab/-/commit/52ca52e86774590083d0952b0f3bdf7a583f0144) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184937))
- [Create new code suggestion_daily_events table in ClickHouse](https://gitlab.com/gitlab-org/gitlab/-/commit/c9527257888fb70347e474010b050bce2806a296) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184384))
- [Add NOT NULL on ci_trigger_requests.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/7b75b21d1df9cc28be24e44a13be87865fef8990) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183978))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/2b6836ff9f0397430475ed4756ca80f78ac80ba5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185022))
- [Add NOT VALID NOT NULL constraint to ci_build_needs.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/a40e2473127323771d0917e4db70d22e17e8b5ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184429))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/0007b4407a08c274f6d3b5e8386d135562a3cd4f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184409))
- [Finalize migration BackfillPagesDomainAcmeOrdersProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/c0a538e21a1465f7269501b6a2395e5b0f5bd815) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185358))
- [Finalize migration BackfillPagesDeploymentStatesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/1b90033fbb162c58f28fd889c0ba07f729b35cfe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184716))
- [Re-queue BackfillOnboardingStatusRole migration](https://gitlab.com/gitlab-org/gitlab/-/commit/68c02ea30a8ab9d86c53458d0306281cfcd25939) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185314))
- [Cleanup use_ssot_for_ultimate_trial_eligibility feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/7c1126cf5be78af89bb4412e07fbb02b143d502b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184228)) **GitLab Enterprise Edition**
- [Partition vulnerability archival related tables](https://gitlab.com/gitlab-org/gitlab/-/commit/5d1181f3db11af23945fc359d8100a04f2f9a36a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184636))
- [Finalize migration BackfillPackagesNpmMetadataProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/fdeb4e944512dd64f7a878170c8c65e949623946) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184244))
- [Make "Search Within" filter use sentence case](https://gitlab.com/gitlab-org/gitlab/-/commit/3e9ec2c241619f3916dd8f4eacf1f7e7e7e2c0e8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185242))
- [Finalize migration BackfillPackagesNugetMetadataProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/9626d2ee0f38acfe721db3e2d085a459cfa3af85) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184245))
- [Finalize migration BackfillPackagesPypiMetadataProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/0b9e8608a1a36ba152e29b7ee3f0a38a1dcce003) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184398))
- [Changing "acknowledgement" to American spelling](https://gitlab.com/gitlab-org/gitlab/-/commit/19482e03405abb5a30629742b6aeaa5d7796a3b2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184185))
- [Add ComplianceFrameworks count metric](https://gitlab.com/gitlab-org/gitlab/-/commit/65a0d1a5b02b0dd3a17fcbccf19f4987da90f850) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184686)) **GitLab Enterprise Edition**
- [Validate NOT NULL on packages_package_files](https://gitlab.com/gitlab-org/gitlab/-/commit/206a29e962dc22471b2048030b292b0d4680b79b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185064))
- [Remove ElasticIndexingControlWorker class and related files](https://gitlab.com/gitlab-org/gitlab/-/commit/da995f512ce7802652502d807f8f535537dd7ad2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185117)) **GitLab Enterprise Edition**
- [Reindex Elasticsearch note index to update integer with long type](https://gitlab.com/gitlab-org/gitlab/-/commit/931811688773ad39a383085ad311fc699af9f1c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184202)) **GitLab Enterprise Edition**
- [Add a migration to remove the routes that are pending deletion](https://gitlab.com/gitlab-org/gitlab/-/commit/2511830eba3c91e74220ac10c0eb88cbe57f519e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184755))
- [Finalize Jira Cloud App connection migration](https://gitlab.com/gitlab-org/gitlab/-/commit/fb1848e5f751d9aea913f7f37d72b6a9cd103789) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182655))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/44768066556396b8383a53b29b07b41a7f8f97eb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184699))
- [Add NOT NULL on protected_environment_approval_rules sharding keys](https://gitlab.com/gitlab-org/gitlab/-/commit/8786c32355d62950e10d01a5df220b42f3ac9ac6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184433))
- [Validate NOT NULL on approvals.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/c661813293801d1b29508b7b614755e4594eefbc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181753))
- [Remove feature flag "Cleanup codeowners_file_exclusions"](https://gitlab.com/gitlab-org/gitlab/-/commit/e401dccecda97e19b0e8446c9e9fd75621783c8f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184860))
- [Add NOT NULL on epic_issues.namespace_id](https://gitlab.com/gitlab-org/gitlab/-/commit/3aedaf0d2504b12e55eb33a6f821ea4fdc69468e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184430))
- [Initial commit: Remove log_response_length feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/67f898e963cfe4e69d1010c1fc5fc225aaff7b80) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184261))
- [Add and backfill project_id for incident_management_oncall_shifts](https://gitlab.com/gitlab-org/gitlab/-/commit/daf87c99cfa202afa3c3e630424132a927eaa55a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184772))
- [Migrate Google Instance audit event destinations](https://gitlab.com/gitlab-org/gitlab/-/commit/612f69d5384fb5eb70ce5c9988d044bc963699ed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184058)) **GitLab Enterprise Edition**
- [Add and backfill project_id for incident_management_oncall_participants](https://gitlab.com/gitlab-org/gitlab/-/commit/a4022477085b70781f2274f40371a9379513743b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184771))
- [Add NOT NULL on ci_build_pending_states.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/c7687705e69682b2de71a4bdd276259b7a521db3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183975))
- [Remove feature flag label_keep_around_ref_metrics](https://gitlab.com/gitlab-org/gitlab/-/commit/055e3a95ed3944a246d3f4e36cb564faf3866ad1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184847))
- [Log Runner info for Release builds](https://gitlab.com/gitlab-org/gitlab/-/commit/7c68a6e351a79f7a42a31964424b0973f10f23ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184817))
- [Protected containers: Fix metadata for FF minium access level for delete](https://gitlab.com/gitlab-org/gitlab/-/commit/c58346a842c888740a58582d90e53ad72e710053) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184812))
- [Sync translations from crowdin (2025-03-15)](https://gitlab.com/gitlab-org/gitlab/-/commit/0fe7bd747fd69148424c5903522c0e36421e39bd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184696))
- [Cleanupp the no_onboarding_enterprise_users feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/7d9d548746a1b6dd2f2f074f64c7758745fb0494) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184478)) **GitLab Enterprise Edition**
- [Remove feature flag allow_merge_request_pipelines_from_fork](https://gitlab.com/gitlab-org/gitlab/-/commit/b62f9187a57cc5ba66ce26889516cc55a425181a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182862))
- [Finalize migration BackfillNewAuditEventTables](https://gitlab.com/gitlab-org/gitlab/-/commit/1bc0f07ffd3af5b9fab8a0ea0b1af5f2759d25db) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181881))

## 17.10.6 (2025-05-07)

### Fixed (2 changes)

- [Bump devfile gem to v0.4.3](https://gitlab.com/gitlab-org/security/gitlab/-/commit/c4840d962f0d7c7b0358e9f88727a6bfabb1bf90)
- [Only check records with encrypted data in gitlab:doctor:encryption_keys](https://gitlab.com/gitlab-org/security/gitlab/-/commit/2552b470ad275177d3b2cd8673fecb6b46edde50)

### Changed (1 change)

- [Change to async_delete for ci_running_builds.runner_id](https://gitlab.com/gitlab-org/security/gitlab/-/commit/541c04acdcb4662d1da9752bc57e4f35b3132394)

### Security (3 changes)

- [Improve Octokit::ResponseValidation middleware and add rate limits](https://gitlab.com/gitlab-org/security/gitlab/-/commit/3643c75ca34b0d50ddd0ada526d73c33f49b8222) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4936))
- [Remove id attribute from OAuth form](https://gitlab.com/gitlab-org/security/gitlab/-/commit/09f38647c06a2e1ac3d84510a4f04729b3d6fe86) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4949))
- [Use IssuePolicy for #issues_readable_by_user](https://gitlab.com/gitlab-org/security/gitlab/-/commit/777d7a4b6f5b4101d8d1d174365006f2f112ccff) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4956))

## 17.10.5 (2025-04-22)

### Fixed (3 changes)

- [Fix 500 in Todo API when wiki page todo exists](https://gitlab.com/gitlab-org/security/gitlab/-/commit/71215f0615fad3167fb96b521b9628e11ea30a5d)
- [Clear session cookie when browser is closed](https://gitlab.com/gitlab-org/security/gitlab/-/commit/7c77ca404d9be7166d8ef991013394483b3f0371)
- [Fix workspaces reconciliation to send inventory config map correctly](https://gitlab.com/gitlab-org/security/gitlab/-/commit/aba508e925aea81c4d47555254e6a657edc94863) **GitLab Enterprise Edition**

### Security (4 changes)

- [Add SecureHeaders middleware with the Nel header](https://gitlab.com/gitlab-org/security/gitlab/-/commit/0e180be62768513438f86ea99f0a4a305cca46b6) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4919))
- [Restrict forwarded headers in Maven dependency proxy](https://gitlab.com/gitlab-org/security/gitlab/-/commit/faa100503f89d08e51549e4f35f362c9945dbb6f) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4930))
- [Security unauthorized access to reading branch names](https://gitlab.com/gitlab-org/security/gitlab/-/commit/dc2f917499f58ed9ccff23158b39528b62b71c2f) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4895))
- [Simplify detecting paragraphs for quick actions](https://gitlab.com/gitlab-org/security/gitlab/-/commit/507e465f21b5be5297eda7a67f0ba75994df88d8) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4926))

### Other (1 change)

- [No-op FinalizeBackfillCiRunnerMachinesPartitionedTable migration](https://gitlab.com/gitlab-org/security/gitlab/-/commit/119891459658f48120bcef02b1b66e3e78c78865)

## 17.10.4 (2025-04-09)

### Fixed (2 changes)

- [Fix invalid pipelines for scan execution policies](https://gitlab.com/gitlab-org/security/gitlab/-/commit/b27b9794e62f4e8ba33e2f56c1c7c64872b4e771) **GitLab Enterprise Edition**
- [Move group.cluster_agents field to CE](https://gitlab.com/gitlab-org/security/gitlab/-/commit/d649d85eab978e106135cc03db4baf261d5d8cb3) **GitLab Enterprise Edition**

### Security (7 changes)

- [Bump workhorse golang-jwt/jwt to 5.2.2](https://gitlab.com/gitlab-org/security/gitlab/-/commit/0ccf3be7475234aca2c54bd1b0283cd9efed6d87) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4912))
- [Global search count leak for confidential issues](https://gitlab.com/gitlab-org/security/gitlab/-/commit/2a6b55c797818a232b0b6ca271f42f594f5a2eae) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4907))
- [Set the IP address state for Action Cable requests](https://gitlab.com/gitlab-org/security/gitlab/-/commit/eef77387081aaf590f13dcdbd7faa6cbadd26bb7) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4904))
- [Bump Golang Oauth2 >=0.27.0](https://gitlab.com/gitlab-org/security/gitlab/-/commit/ee730000f88d319bbd70ce828a0b21118e30231b) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4893))
- [Adding validation for Ci::Pipeline](https://gitlab.com/gitlab-org/security/gitlab/-/commit/5d8162f4dfd64d817adef4b2bfd6ce174b66fa44) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4884))
- [Add delay to when pointer events are enabled for 0Auth authorize page](https://gitlab.com/gitlab-org/security/gitlab/-/commit/d54f30acea881202ae0b225c20d306633d7708bf) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4888))
- [Do not enable pprof by default in Workhorse](https://gitlab.com/gitlab-org/security/gitlab/-/commit/4e61600d751d0aba541d8019c9c6419762acc1b7) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4891))

## 17.10.3 (2025-04-02)

No changes.

## 17.10.2 (2025-04-02)

### Fixed (2 changes)

- [Fix free push limit on non-saas](https://gitlab.com/gitlab-org/gitlab/-/commit/41d60e463f147b2cc76889e0f97a3192a9654ec9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186166))
- [Ensure runner taggings are copied from taggings](https://gitlab.com/gitlab-org/gitlab/-/commit/225b22847600e53bcf83d26b85e0a5e80b38c470) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186279))

### Other (1 change)

- [No-op ci_runner_machines_687967fa8a table backfill migration](https://gitlab.com/gitlab-org/gitlab/-/commit/5e9c7c787a1fb500707fbbceea2dccd1fd86ab92) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185304))

## 17.10.1 (2025-03-26)

### Security (7 changes)

- [Sync organization user access when admin status changes](https://gitlab.com/gitlab-org/security/gitlab/-/commit/49c7f443c828187785f8714509933a1228e00c89) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4882))
- [Prevent XSS via merge error on the merge request page](https://gitlab.com/gitlab-org/security/gitlab/-/commit/8410e21aa289a55ce8e65258af5bcc2c3073e1f1) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4881))
- [Inherit current_user external status while rotating project/group token](https://gitlab.com/gitlab-org/security/gitlab/-/commit/c9a33f8331d54a8925006c5dce8738203328e759) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4865))
- [Add validations for the project_name of Harbor integration](https://gitlab.com/gitlab-org/security/gitlab/-/commit/8fdb151d20d24d9f51dac9efa0aba92d6a31ce97) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4864))
- [Sanitize returned input on asciidoc Timeout](https://gitlab.com/gitlab-org/security/gitlab/-/commit/e32acea8a77d03b3403a097e2284e173885884b0) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4863))
- [Add CI/CD project setting `allow_composite_identities_to_run_pipelines`](https://gitlab.com/gitlab-org/security/gitlab/-/commit/5cfde6ed6799bb16350aab55218b0904ccb7b053) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4876))
- [Add limit to resource counts in tfplan merge request report](https://gitlab.com/gitlab-org/security/gitlab/-/commit/0ec13496f360b7d600cf604995d8f90276bef0c9) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4870))

## 17.10.0 (2025-03-19)

### Added (150 changes)

- [Add CI runner manager custom executor count to service ping](https://gitlab.com/gitlab-org/gitlab/-/commit/0ff760ca3f36016b6558c9d27e3b0cefeb1fe827) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184308))
- [Add compliance control: auth_sso_enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/e386ea2d8ebab9512a2552011da1e10520595ee8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183762)) **GitLab Enterprise Edition**
- [Protected containers: Integrate delete protection in REST API](https://gitlab.com/gitlab-org/gitlab/-/commit/074e863f366b85096f8e59dd93ba046b30692de8) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183729))
- [Destroy compliance statuses when project is deleted](https://gitlab.com/gitlab-org/gitlab/-/commit/48105bbba27648d01879e9c72ab2f0538abec2b1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183997)) **GitLab Enterprise Edition**
- [Add GraphQL query for organization cluster agents](https://gitlab.com/gitlab-org/gitlab/-/commit/0a58bad5b22f26825368ffbc1560b74c05637c5f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183728))
- [Export squash options](https://gitlab.com/gitlab-org/gitlab/-/commit/2219cde7bf1098f3f07d51a22d30d3d8c5ccb622) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175472)) **GitLab Enterprise Edition**
- [Add query to pipeline inputs form](https://gitlab.com/gitlab-org/gitlab/-/commit/10237c60e0680d7a219d504320a1b87205f4f7a8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183587))
- [Update table_size database dictionary entries](https://gitlab.com/gitlab-org/gitlab/-/commit/f90fc44e30f41f8a33d0ff8b8b79765d94189d76) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184718))
- [Added graphql query for listing project compliance statuses](https://gitlab.com/gitlab-org/gitlab/-/commit/c1e2223ba7c2321445d6de70bacdf4df737ad830) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183640)) **GitLab Enterprise Edition**
- [Emit input data to pipeline new form](https://gitlab.com/gitlab-org/gitlab/-/commit/1e8c63a524d7c3a9c9fb1ff92a4bdaa2d11bcbeb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184375))
- [Add missing sorting options to access token APIs](https://gitlab.com/gitlab-org/gitlab/-/commit/fecf59b69b870f037442b5fea70d32b7d0c135a8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184298))
- [Add work item view controls](https://gitlab.com/gitlab-org/gitlab/-/commit/663aecae54ae491c642bb5986bdb38983df8a880) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181184))
- [Backfill software_license_policies without spdx and custom_license](https://gitlab.com/gitlab-org/gitlab/-/commit/e8187711095b23e1dbefd31480512859d3daa9e2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181736)) **GitLab Enterprise Edition**
- [Updating pipeline inputs form](https://gitlab.com/gitlab-org/gitlab/-/commit/9f133639227253535e7fbb30110d162abffa010b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184112))
- [Track credentials inventory page visits on SAAS, SM & Dedicated](https://gitlab.com/gitlab-org/gitlab/-/commit/c8ce6b9ae02e3f693c8986032b6c3a5cddc18c81) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184346)) **GitLab Enterprise Edition**
- [Add inputs to pipeline schedule endpoints](https://gitlab.com/gitlab-org/gitlab/-/commit/f08790547e5fa28746ae880788d96400fd0374ae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184019))
- [Support filtering work items by timeframe](https://gitlab.com/gitlab-org/gitlab/-/commit/65916874d04584fa91188da709910dfd50d8f129) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181904))
- [Release GitLab Query Language (GLQL) Beta](https://gitlab.com/gitlab-org/gitlab/-/commit/bd5d4c6eaa885e0fd514e543d9d5bf1a38e00450) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184168))
- [Add createdAt field to source_user_type](https://gitlab.com/gitlab-org/gitlab/-/commit/b39d88016f4fb445487c2bac5cd944214cb6e50b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182177))
- [Automatically scan pubspec.lock files when new analyzer enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/706c6a20a3221223cb5c4877344914e0d39d23ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184379))
- [Add admin page for targeted messages basic upload](https://gitlab.com/gitlab-org/gitlab/-/commit/f08d3ffa800c991c7b22a8bd118fff0fe003e84b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183052)) **GitLab Enterprise Edition**
- [Implement vulnerability archive export API](https://gitlab.com/gitlab-org/gitlab/-/commit/ff0904799c49d21d5e82cee60ba034fd1f69d487) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183521)) **GitLab Enterprise Edition**
- [Create merge_request_approval_settings table](https://gitlab.com/gitlab-org/gitlab/-/commit/0b44f525835df85f0261eb0bc64daa3b84a26743) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183679)) **GitLab Enterprise Edition**
- [ActiveContext preprocessor for embeddings](https://gitlab.com/gitlab-org/gitlab/-/commit/5017fd3d05b4a2be28d424a2be78561b2a089809) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183693))
- [Respect tag protection rules when deleting tags](https://gitlab.com/gitlab-org/gitlab/-/commit/c99b88552ecf214475b5d6f13adebf710af57ba6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180661))
- [Show subgroup projects in the DORA projects comparison visualization](https://gitlab.com/gitlab-org/gitlab/-/commit/910ecaf74f432346fa7d420ee8a67521ad0d66f7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184211)) **GitLab Enterprise Edition**
- [Enable importer_user_mapping_reassignment_csv flag by default](https://gitlab.com/gitlab-org/gitlab/-/commit/278aee25d619a71912eb645cb479020b39df64ac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184169))
- [Add count of createdservice_accounts,28d](https://gitlab.com/gitlab-org/gitlab/-/commit/03dcd1495e212b94d580c6bf81bd18fd1f85a053) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183222)) **GitLab Enterprise Edition**
- [Add by_project_id scope to ProjectSettings](https://gitlab.com/gitlab-org/gitlab/-/commit/e5ad00c21571e79f1acd187b4c937588b2498858) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180296)) **GitLab Enterprise Edition**
- [Enable the `todos_bulk_actions` FF by default](https://gitlab.com/gitlab-org/gitlab/-/commit/40563c25b3cd9d3d1baf39fb38a87e1fbedd9497) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184151))
- [Add shortcut tooltips](https://gitlab.com/gitlab-org/gitlab/-/commit/f669b3a6963bbb161d35f36947da7ed698801171) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183757))
- [ActiveContext preprocessors for preload and bulk embeddings](https://gitlab.com/gitlab-org/gitlab/-/commit/dcdec6b4eea2f043aa32481a410ddaf2137d7f10) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183374))
- [Add the ability to search versions](https://gitlab.com/gitlab-org/gitlab/-/commit/c00d278bfa68375ebd0b7dcd287f2f2311e007c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183105)) **GitLab Enterprise Edition**
- [Add service account update endpoint for groups](https://gitlab.com/gitlab-org/gitlab/-/commit/5404b436347d7441bb5b0870ce1d3e3d56cb6113) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182607)) **GitLab Enterprise Edition**
- [Added code to auto approve pending promotions via ldap](https://gitlab.com/gitlab-org/gitlab/-/commit/f7d60b5b3f319ff31e884a7d796c294570ef86d3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182423)) **GitLab Enterprise Edition**
- [Admin Token API: Revoke pipeline trigger tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/765c467ac4315c33ecf61e5ba0fe7f82b4572351) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181598))
- [Expose path_lock permissions in graphql endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/894e13e9c6753b396706170fc7ebadbf6b367862) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184242)) **GitLab Enterprise Edition**
- [Protected packages: Add minimum_access_level_for_delete to GRAPHQL API](https://gitlab.com/gitlab-org/gitlab/-/commit/dd2c7c3ab12793bc8023de5bac784fb191fec601) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180260))
- [Add `usage_count` data source and visualizations](https://gitlab.com/gitlab-org/gitlab/-/commit/7b371873cfb3041ab919221d1c12529f36cd90a5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183891)) **GitLab Enterprise Edition**
- [Add Duo with Amazon Q to Duo interface](https://gitlab.com/gitlab-org/gitlab/-/commit/11a972aa5d8cf7937e8810f5e2c1c0efc75c3873) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182120)) **GitLab Enterprise Edition**
- [Model experiments: Add artifacts list](https://gitlab.com/gitlab-org/gitlab/-/commit/c7cb2c8c359e8c3fb2c39782ef81c2e59360b479) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183678))
- [Add excluded_merge_requests table](https://gitlab.com/gitlab-org/gitlab/-/commit/09179454c488f3eb5601f5f9b362347fa7da61f3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182488))
- [Add vulnerability_severity_overrides table](https://gitlab.com/gitlab-org/gitlab/-/commit/a985600fdcc410d872dea0f9a40bd9e347612a86) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176952)) **GitLab Enterprise Edition**
- [Introduce Ci::ProjectWithPipelineVariable model and migration](https://gitlab.com/gitlab-org/gitlab/-/commit/6197a60603908283344b91e0350fe0ca03e477f2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176022))
- [Protected packages: Integrate delete protection](https://gitlab.com/gitlab-org/gitlab/-/commit/98b2aaeabd1eed7a2867f342bd9d2ba63ab595e2) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179931))
- [Add ci_pipeline_schedule_inputs table](https://gitlab.com/gitlab-org/gitlab/-/commit/378b5df8157a955108e45bbc8423b2dd647f5a48) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182763))
- [Add duo_chat_troubleshoot_job to FLAGGED_FEATURES](https://gitlab.com/gitlab-org/gitlab/-/commit/317691ac2664f6ceb4a1ef9eec23abc0a530cf64) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184134)) **GitLab Enterprise Edition**
- [Remove users_search_scoped_to_authorized_namespaces_advanced_search flag](https://gitlab.com/gitlab-org/gitlab/-/commit/e951adcae07423cd2168fdfc53f5677d63e16fc5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184125)) **GitLab Enterprise Edition**
- [Add Authz::UserGroupMemberRole model](https://gitlab.com/gitlab-org/gitlab/-/commit/7c8eb82dc54b884203206bdffb598b03a9391260) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182980)) **GitLab Enterprise Edition**
- [Add `parent_path` argument to Groups GQL resolver](https://gitlab.com/gitlab-org/gitlab/-/commit/4a8aab2d65bcf3a3d0f9ee846f3bbacc25900d49) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183012))
- [Added a new vulnerability_namespace_statistics table](https://gitlab.com/gitlab-org/gitlab/-/commit/6c5539a6df41b93423a715036ec17681821bdaf1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183138))
- [Support admin custom roles on SaaS](https://gitlab.com/gitlab-org/gitlab/-/commit/4117831792cc903acf9a9c62209dcf27fb441d83) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181559)) **GitLab Enterprise Edition**
- [Implement `GET /Groups/:id` SCIM endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/052e8d5b635a77ce8994ff05d395ecbdcd14ef38) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181577)) **GitLab Enterprise Edition**
- [Add WorkItemWidgetVulnerabilities with related vulnerabilities](https://gitlab.com/gitlab-org/gitlab/-/commit/7c6acbd08fbb273e5250f175ae7f747b6055b072) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183548)) **GitLab Enterprise Edition**
- [Prevent decremeting stars of project with zero star count](https://gitlab.com/gitlab-org/gitlab/-/commit/c9b3c9629ad2b537ae32104af0efc1766d09c0b5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183481))
- [Added table and model for project requirement status](https://gitlab.com/gitlab-org/gitlab/-/commit/ae8b8a4fd10691298e4bd7470683bc7860c25f5f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183484)) **GitLab Enterprise Edition**
- [Enable Duo Code Review and change it to beta](https://gitlab.com/gitlab-org/gitlab/-/commit/60dc901bf62c1bce545668d6334d362a865a891d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183478)) **GitLab Enterprise Edition**
- [Add inputs adoption banner](https://gitlab.com/gitlab-org/gitlab/-/commit/e636f6533b62a10abe1729f01e97f3183f35eb0a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183407))
- [Add dependency paths data to vulnerabilities](https://gitlab.com/gitlab-org/gitlab/-/commit/98401d1dd27cfd7cd4d383448c6fa2ecb5950475) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183487)) **GitLab Enterprise Edition**
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/b2c8391c0fdab273c7a2e1d15a1a2272948f7f37) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183856))
- [Show blame preferences when .git-blame-ignore-revs file exists](https://gitlab.com/gitlab-org/gitlab/-/commit/cee1cfacd22437ca8556977c93cd897011541327) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182827))
- [Bulk add controls while requirement creation](https://gitlab.com/gitlab-org/gitlab/-/commit/d883fe61541afa002f63e21202c18b53d66e5597) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181898)) **GitLab Enterprise Edition**
- [Add groups GQL query argument to only return groups with user membership](https://gitlab.com/gitlab-org/gitlab/-/commit/7fffc8b4136d61a113caa2831d697c882ed13408) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183161))
- [Add ability to force cancel jobs stuck in canceling status](https://gitlab.com/gitlab-org/gitlab/-/commit/1a70128e344b4ad63adc84134ba0207b031cba15) by @ajuckel ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179137))
- [Add put API endpoint to support uploading recipe package files](https://gitlab.com/gitlab-org/gitlab/-/commit/6eea3d1010efdcdc023e0f0d0a4c26d8867fd6d2) by @oceane_scania ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181393))
- [Add the `RecentlyViewedMergeRequestsResolver` class](https://gitlab.com/gitlab-org/gitlab/-/commit/8e4c6010d12f75cf730a2658a037b154a0698a2b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183706))
- [Introduce GroupDora type with projects](https://gitlab.com/gitlab-org/gitlab/-/commit/d039f1486c4f93cc6d736d2a1e7858446039930d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181975)) **GitLab Enterprise Edition**
- [Introduce separate rate limiter for /autocomplete/users](https://gitlab.com/gitlab-org/gitlab/-/commit/c56892fd850d37dba6aaadd58bcd232d7b0bd1ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183244))
- [Track Cloud Connector token signing metrics](https://gitlab.com/gitlab-org/gitlab/-/commit/91861f52d73a451a5d1d312878c3828aa9202e2f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183676)) **GitLab Enterprise Edition**
- [Add vulnerability_severity_overrides table](https://gitlab.com/gitlab-org/gitlab/-/commit/bce60bb6a9bd6a2de27beff230ce3cebef9e420f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176952)) **GitLab Enterprise Edition**
- [Process security report observability events](https://gitlab.com/gitlab-org/gitlab/-/commit/c4be99cf6fd9777f8308aa2f093f3a70e05b229d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175612))
- [Capture job token policies for API endpoints](https://gitlab.com/gitlab-org/gitlab/-/commit/bc7f41bba693e4fb6afcec218ba2e6f7f781f371) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182582))
- [Update vulnerabilities ExternalIssueLink create service](https://gitlab.com/gitlab-org/gitlab/-/commit/a81fd7f5dfa68a8dd2d322952dec905178a5a35e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181950)) **GitLab Enterprise Edition**
- [Migrate table cell dropdown to a bubble menu](https://gitlab.com/gitlab-org/gitlab/-/commit/a3e34dfe4c15c3d865c8685b83190bce4d00b675) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182909))
- [Add Duo with Amazon Q support to SM/Dedicated provisioning](https://gitlab.com/gitlab-org/gitlab/-/commit/445de297eb3a4b2d226f60d6ed3354d8515c3d0c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183529)) **GitLab Enterprise Edition**
- [Add value renderer](https://gitlab.com/gitlab-org/gitlab/-/commit/4c119afc75d69056bab78c2b26e1ead1121fcc17) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182799))
- [Remove block_seat_overages feeature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/42db137830172086da6e0014f9fd30a1af196068) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181653)) **GitLab Enterprise Edition**
- [Add import history table and import source table components](https://gitlab.com/gitlab-org/gitlab/-/commit/d5e4d47d16a22c4034489c7e2f849dbf40d6b78f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180098))
- [Add namespace_metadata visualization and data source](https://gitlab.com/gitlab-org/gitlab/-/commit/1e0753a2b28826057b41e8b9419820df2e76c877) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183096)) **GitLab Enterprise Edition**
- [Add CSV format to group dependency export](https://gitlab.com/gitlab-org/gitlab/-/commit/78781796626b4dedb2597aaa8e4228a3b9015cff) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183097)) **GitLab Enterprise Edition**
- [Restrict manual job variables](https://gitlab.com/gitlab-org/gitlab/-/commit/709a35fd11d4becb26763c2575e38d1610b28838) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183068))
- [Cloud Connector: add key rotation rake tasks](https://gitlab.com/gitlab-org/gitlab/-/commit/54a43ecebdea34e1667589302f9074212bace19a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182711)) **GitLab Enterprise Edition**
- [Create GraphQL endpoint to return pipeline inputs](https://gitlab.com/gitlab-org/gitlab/-/commit/be04d0ea0fff216ac93b64b8cddd2579574fc3ce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182609))
- [Add Project.forkedFrom to graphql api](https://gitlab.com/gitlab-org/gitlab/-/commit/9ba1c9b57d20d61ff05e23204998c5b86d19aa05) by @Taucher2003 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183115))
- [Add error tracking widget to work items](https://gitlab.com/gitlab-org/gitlab/-/commit/440bb7783d17ddb814e684d9ea04c0b554492817) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181983))
- [Enable cluster agents for groups](https://gitlab.com/gitlab-org/gitlab/-/commit/b8d6ec5cd500c71846ddf5891e725d3d0b470cb6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182628))
- [Apply GitHub markdown reformatting to more objects](https://gitlab.com/gitlab-org/gitlab/-/commit/16570e16526ead2673d16eda5e46dadbe102f92e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181297))
- [Improve pipeline execution policy documentation](https://gitlab.com/gitlab-org/gitlab/-/commit/4e6657b52057a2a53f8c20687e163c165a88e3b8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182269))
- [Add GraphQL API for querying dedicated usage filters](https://gitlab.com/gitlab-org/gitlab/-/commit/747d7f9796b33e5af5b364a70ce9f4b7089774f3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181383)) **GitLab Enterprise Edition**
- [Add namespace package setting for audit events](https://gitlab.com/gitlab-org/gitlab/-/commit/6e1017c7db9da4e696bb6fbd3203355deed9f1c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182310))
- [Adding the CI_PROJECT_NAMESPACE_SLUG variable](https://gitlab.com/gitlab-org/gitlab/-/commit/481185f5bfcb475d6ad8df8d7b66bd82a5f18168) by @tonton1728 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181988))
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/d8222b92a2c63fb1fd44bd3511a01d173a26c1fe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183193))
- [ActiveContext OpenSearch processor for queries](https://gitlab.com/gitlab-org/gitlab/-/commit/61448378d87d011d0ee462548111e50ce0cf47a1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183192))
- [Add support for /epic on work_items](https://gitlab.com/gitlab-org/gitlab/-/commit/3e19a48db9e3043b8f7aef2a1567d973db1048b5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181750)) **GitLab Enterprise Edition**
- [Add `organization_id` field to `fork_networks`](https://gitlab.com/gitlab-org/gitlab/-/commit/34c02117ed94dbb83d583852ec0ec30f67f55f88) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182898))
- [Add vulnerability id for create work item](https://gitlab.com/gitlab-org/gitlab/-/commit/80a8757f432c2d2e464c5717d35cd3a49b6b9c3a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181895))
- [Pre-select permissions when creating a custom role](https://gitlab.com/gitlab-org/gitlab/-/commit/080b2dac7f9dd28879dfb62d0114a609c9da903c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178060)) **GitLab Enterprise Edition**
- [Append any value defined in pages.publish to artifact paths](https://gitlab.com/gitlab-org/gitlab/-/commit/f4fe9adc6581fbebbdcb7a2b3bc4b405dbe714ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180239))
- [Add a limited count field to registries](https://gitlab.com/gitlab-org/gitlab/-/commit/2da96a9139f78087ec65db80dd997d863028202a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183189)) **GitLab Enterprise Edition**
- [Implement `POST /Groups` SCIM endpoint for self-managed](https://gitlab.com/gitlab-org/gitlab/-/commit/bda74db95a055eaa7720b22a00867f1b162235b7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180831)) **GitLab Enterprise Edition**
- [GraphQL query for component dependency path](https://gitlab.com/gitlab-org/gitlab/-/commit/01b9e3dbb1e0a59c6f709e2cb79ffe21826cd101) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182289)) **GitLab Enterprise Edition**
- [Add pipeline inputs table](https://gitlab.com/gitlab-org/gitlab/-/commit/39762c32ec5147924304e1e4320686cf16bf36f1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182676))
- [Add worker to assign security bot for namespaces](https://gitlab.com/gitlab-org/gitlab/-/commit/97a31e6586895bf2e461f577b15f86c597f8e483) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181182)) **GitLab Enterprise Edition**
- [Remove feature flag change_data_consistency_for_permissions_workers](https://gitlab.com/gitlab-org/gitlab/-/commit/fa64b4ffc6fee61e2591cd334bbe63e2c5952cde) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182975))
- [Allow users to /q test in mr note](https://gitlab.com/gitlab-org/gitlab/-/commit/952392123f3c5764ec1b2d00c87e4732c76f3af7) by @jlosito ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182010)) **GitLab Enterprise Edition**
- [Add models for system defined status](https://gitlab.com/gitlab-org/gitlab/-/commit/91e8062dcf2ea2fba8f0e0b1ace91b6582542327) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181962))
- [Add default role to variables settings](https://gitlab.com/gitlab-org/gitlab/-/commit/a240e2b741a3f02975974ac408b4552a9226c8ec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181272))
- [Add index on merge_request_diffs for id and project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/2b5e662ed26b2ff40cd6d677ea48371fa084bcd5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173929))
- [Support duo_chat_2 conversation type](https://gitlab.com/gitlab-org/gitlab/-/commit/dbaf33ea2547f3658fdb70bab1422bfa535ffd6f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181771)) **GitLab Enterprise Edition**
- [Expose CI_JOB_GROUP_NAME variable for builds](https://gitlab.com/gitlab-org/gitlab/-/commit/cd0ce46c878ad8c521e02d1d7ab3a56107700544) by @azinke ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179447))
- [Add find_or_initialize_project_control_status](https://gitlab.com/gitlab-org/gitlab/-/commit/6bb465ef64ab325605d62196a866207717ff444e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180107)) **GitLab Enterprise Edition**
- [Expose `blocked_work_items` feature availability in WI permissions](https://gitlab.com/gitlab-org/gitlab/-/commit/ac8edbb59ecc74d007303de508e3f3a72b71e7c5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182158)) **GitLab Enterprise Edition**
- [Add GraphQL for WorkItems::UserPreference](https://gitlab.com/gitlab-org/gitlab/-/commit/e2d5263ee9f18ef213f41bd386fe42afb9a389f7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176975))
- [Release PAT expiry notifications to inherited group and project members](https://gitlab.com/gitlab-org/gitlab/-/commit/1acddc4e2a70d9b52eeb0d83063b721ffa219377) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182055))
- [Promote model version through api](https://gitlab.com/gitlab-org/gitlab/-/commit/600cfc3169aef35e2ebce46dfe6bff9ead9f916e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182777))
- [Introduce a GraphQL mutation to archive vulnerabilities](https://gitlab.com/gitlab-org/gitlab/-/commit/f1872a8335f6b88b1eea2da5fd39d4c6babf2539) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181986)) **GitLab Enterprise Edition**
- [Add user_discussions_count to WorkItem API](https://gitlab.com/gitlab-org/gitlab/-/commit/5d0a04b4dd55874cae26b4b393bd2048e9422446) by @vedant-jain03 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179164))
- [Add migration to create missing nuget symbols](https://gitlab.com/gitlab-org/gitlab/-/commit/2148e0dc8fc667635cbbb5fc8699250121e1fd2f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173869))
- [Enable users to fetch all WorkItems they have access through GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/83be9dc0b25f78c83d8af5194ddd99e3ff14bdc2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177484))
- [Preload policies in contributed and starred projects resolvers](https://gitlab.com/gitlab-org/gitlab/-/commit/1bfafed705e6f6366429823d93c81ae9fbb0887e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182494))
- [Markdown: Select text and paste URL to create link](https://gitlab.com/gitlab-org/gitlab/-/commit/bcd2a3bcc3f4b91c4e5afc6828df8e1bbe03d083) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182471))
- [Add export dropdown to dependency list](https://gitlab.com/gitlab-org/gitlab/-/commit/f112339a2cf3853179fc89aeff5383a9b1260a97) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180617)) **GitLab Enterprise Edition**
- [GraphQL: search by commit in the repository](https://gitlab.com/gitlab-org/gitlab/-/commit/013cd757b4e6441bf77b0948e22d8e7d7f3c967e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179542))
- [Add external control fields to GraphQL API](https://gitlab.com/gitlab-org/gitlab/-/commit/7017d5d7f382e0f179282e9dfbcb7ee22aebaf31) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181318)) **GitLab Enterprise Edition**
- [Make Ci::Runner#token routable](https://gitlab.com/gitlab-org/gitlab/-/commit/82024706866a6ba3ce64ce25bfc9d22464bec059) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170634))
- [Removes limited_capacity_member_destruction FF](https://gitlab.com/gitlab-org/gitlab/-/commit/f636f1de5af54404ac76c4c6d3ebd7d8892c8198) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180185))
- [Add comment summarization to work items](https://gitlab.com/gitlab-org/gitlab/-/commit/f75414f0787901a7ca9565f8bf36d6ee34c7aaaa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181712)) **GitLab Enterprise Edition**
- [Removes billable_member_async_deletion FF](https://gitlab.com/gitlab-org/gitlab/-/commit/543a9f346f427743a7513e779b28d81f9e7f910a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180184)) **GitLab Enterprise Edition**
- [Show auto-resolve info banner on vulnerability report](https://gitlab.com/gitlab-org/gitlab/-/commit/741da3d24853da9e3084d8d9af116cdeaa9c879f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181967)) **GitLab Enterprise Edition**
- [Make Users API rate limits configurable](https://gitlab.com/gitlab-org/gitlab/-/commit/4ed1d53f75058b391a135323788383d22122feef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181054))
- [Add switch for CI/CD Job Token format](https://gitlab.com/gitlab-org/gitlab/-/commit/953335cecad9625afa08aa0f44a7ee99c119c5d0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181293))
- [Show Start/Due date sort options in Work Item list](https://gitlab.com/gitlab-org/gitlab/-/commit/eb0f231b4b440d525960e7924aefc6cfca52ee7b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182173))
- [Remove feature flag pipeline_execution_policy_analyze_configs](https://gitlab.com/gitlab-org/gitlab/-/commit/d834b44e1ddc9133be84e4f4009f18d6b14bc50b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181963)) **GitLab Enterprise Edition**
- [Add import history stats and error components](https://gitlab.com/gitlab-org/gitlab/-/commit/81f0cc980422fdc96084ab00f1aae21f267a8c23) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181146))
- [Add runner ID filter for dedicated usage query](https://gitlab.com/gitlab-org/gitlab/-/commit/4d2b776c4b7d22ee1bc4fa09bf915851067326d3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181916)) **GitLab Enterprise Edition**
- [ActiveContext OpenSearch executor for migrations](https://gitlab.com/gitlab-org/gitlab/-/commit/ef037daaf65a75748fba84d529c888f825af81c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181971))
- [ActiveContext Find partition by serializing collection](https://gitlab.com/gitlab-org/gitlab/-/commit/010dc11145cd18c3a4e9dc27503a57cfabefe72a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181525))
- [Mutation for destroying compliance control](https://gitlab.com/gitlab-org/gitlab/-/commit/f2c8c7c90b9b389026fa225f8952cbb64e850040) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177878)) **GitLab Enterprise Edition**
- [Add Support PIN UI functionality](https://gitlab.com/gitlab-org/gitlab/-/commit/3bf456b1fe8e3c31ed8793289fd58df46c81e8cf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176922))
- [Add system note when submitted review is "comments only"](https://gitlab.com/gitlab-org/gitlab/-/commit/45c24bde9d692e042b86a9910829dd9e841eb767) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179149))
- [Enable work item description templates](https://gitlab.com/gitlab-org/gitlab/-/commit/a38540c58ed75d15cf8b9215286b6b4eeae41450) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181688))
- [Protected packages: Add basics for package delete protection](https://gitlab.com/gitlab-org/gitlab/-/commit/241a1dc3e3f74996f62aee1208a5db0db34d3046) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179739))
- [Display warning banner when LFS is misconfigured](https://gitlab.com/gitlab-org/gitlab/-/commit/05d5a2034f2b2e4ef97f3641d7d31be1cc30ca51) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181953))
- [Expose error tracking stack trace though GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/5d848cf139d116004f57e599925adcb9f264b46a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181520))
- [Adds project_id and namespace_id to JWT payload](https://gitlab.com/gitlab-org/gitlab/-/commit/df5a3ac35174b81aa16e90cdbe8d6b6879f0d7e9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180975))
- [Add peek functionality for ResourceUsageLimiter](https://gitlab.com/gitlab-org/gitlab/-/commit/64a1d528b65f0afec148df972b4a92f935ccb4fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174808))
- [Add move button to work item Issue type actions menu](https://gitlab.com/gitlab-org/gitlab/-/commit/10e007178488cb7473d56da2417ed041c96859b6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178799))
- [Add support for api site profiles in DAST Scan Execution Policies](https://gitlab.com/gitlab-org/gitlab/-/commit/5849f39b6cf27cdecaaeae4e45218b0b844e8b50) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181411)) **GitLab Enterprise Edition**
- [Clean up display_password_requirements feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/55e94756c3d8337cc38b1a7914820584dfe3d4d6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181446)) **GitLab Enterprise Edition**
- [Handle Silent Mode for Audit Events streaming](https://gitlab.com/gitlab-org/gitlab/-/commit/ff7b8d7fde8a37b37503636f65aa5c85d020b5db) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181421)) **GitLab Enterprise Edition**

### Fixed (183 changes)

- [Detect JSON tables even with other lang params](https://gitlab.com/gitlab-org/gitlab/-/commit/292c8ffa2f3d7d8d0f47a9198538a2a0a31294c8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184635))
- [Make sure a.anchor::after has position absolute all the time](https://gitlab.com/gitlab-org/gitlab/-/commit/c1dcb71b1bbc80e840ebbf08e779683c62998919) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184220))
- [Do not enforce job token permissions for public endpoints](https://gitlab.com/gitlab-org/gitlab/-/commit/e7c4bc1d5bdbd23fbef1a2e50a3fb78f0e4f95f1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184087))
- [Fix URL escaping in badges API](https://gitlab.com/gitlab-org/gitlab/-/commit/a7329a7c08b2f1120e59266e7581f682beca441f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183543))
- [Add migration to delete zoekt_replicas with evicted zoekt_indices](https://gitlab.com/gitlab-org/gitlab/-/commit/52c2600fe5210921814c06eb32c884de09f89ff8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183685))
- [Fix group level auth for epics advanced search](https://gitlab.com/gitlab-org/gitlab/-/commit/4970eff19fff21b05b379820e8721044fe4678c5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183748)) **GitLab Enterprise Edition**
- [Handle duplication error](https://gitlab.com/gitlab-org/gitlab/-/commit/331dad5654cc4f1a51f225fc05be8c717096a401) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184116))
- [Fix comment templates](https://gitlab.com/gitlab-org/gitlab/-/commit/4f47d3a1b79133d7e34ef10fa60fb7adb83a00ea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181913))
- [Add conditional Flux reconciliation update](https://gitlab.com/gitlab-org/gitlab/-/commit/20c4a32f9d0f64f5c856a8be135f66b6aa6fb218) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184505))
- [Fix integrations table alignment](https://gitlab.com/gitlab-org/gitlab/-/commit/162506aa1f6c74ad4b3cbdf9cb1ecc803e524aae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184538))
- [Fix VSA filtered search bar overflow issue when many filters are applied](https://gitlab.com/gitlab-org/gitlab/-/commit/fc3e4fb731dfc097cb590f3902f49bed41887352) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184520))
- [Prevent new user registration when block seat overages is enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/4c35d12bb2ee647da185ba77d599e7a8a72c7f72) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183913)) **GitLab Enterprise Edition**
- [GLQL table: Fix inclusion of table in description field](https://gitlab.com/gitlab-org/gitlab/-/commit/f04c4eadd5785b631e5d8a53db025cd3a6db7b75) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184435))
- [Rolled up dates only when rollUp is true](https://gitlab.com/gitlab-org/gitlab/-/commit/f70825f10d5b6f30a5dfd84c18a6173099665729) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183455))
- [Fix: Skip agent authorization check for environment creation in REST API](https://gitlab.com/gitlab-org/gitlab/-/commit/2ea4c98270a76bcee6076e62e34cb848373397c7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184403))
- [Stop scroll misbehavior when linking to comments](https://gitlab.com/gitlab-org/gitlab/-/commit/ee0d8c9c7bc426f9a0f3c8e5168e4e063440c32e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184009))
- [Prevent WI sticky header edit button from shrinking when title is long](https://gitlab.com/gitlab-org/gitlab/-/commit/4dc4486acc993895573c8f680b7795a3ae3a5aaf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184370))
- [Add additional checks for group projects](https://gitlab.com/gitlab-org/gitlab/-/commit/5ddc49644b4a823ee21c5beb75eda09f24d1ff4e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184350)) **GitLab Enterprise Edition**
- [Only load vulnerability related records when actually exporting](https://gitlab.com/gitlab-org/gitlab/-/commit/8129bf948471ba32e66c439c73311a77217b8f38) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184195)) **GitLab Enterprise Edition**
- [Reorder runners backfill migrations](https://gitlab.com/gitlab-org/gitlab/-/commit/73f53b6c5b762686a30c74a95b9d70ebbb033cb1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184341))
- [Ignore math on spaced_link_filter](https://gitlab.com/gitlab-org/gitlab/-/commit/cd90ac39b4eda4d2c7407135923ce81370a850ab) by @Bubbis ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182626))
- [Fix read more button styling](https://gitlab.com/gitlab-org/gitlab/-/commit/d73c72a76e02169002b34ac4e230f76199513556) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184262))
- [Zoekt: Fix undefined feature flag handling in gitlab:zoekt:info](https://gitlab.com/gitlab-org/gitlab/-/commit/e256adfb3719ced95f2d3d65ecca40f2eafca1a4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184315)) **GitLab Enterprise Edition**
- [Refactor rule_index while updating security policy](https://gitlab.com/gitlab-org/gitlab/-/commit/ab2cdaddfdc50e2c768223b26e374260f08d5567) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183117)) **GitLab Enterprise Edition**
- [Return an error if the parent DNE / Lacks permissions](https://gitlab.com/gitlab-org/gitlab/-/commit/c02e35aba467208a49f8a410ce7e30c0df87021c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183938))
- [Removes ordering requirement for funnel sync test](https://gitlab.com/gitlab-org/gitlab/-/commit/8c7211bcf6c6a626c70ef95c6221f528896ba204) by @max.woolf ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184167))
- [Add check for nullability for compliance framework](https://gitlab.com/gitlab-org/gitlab/-/commit/80dacf519c6c6cb8c7c2f9798104f9e83514a10f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183665)) **GitLab Enterprise Edition**
- [Fix sorting issue credential inventory](https://gitlab.com/gitlab-org/gitlab/-/commit/836b8d90e45b9e42deaf227336abd6e2271e93a5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183076))
- [Add `description` param to the service access tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/5bda9dffa3bc75f3e365fbc27dcd2e1e00dd70f5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184099))
- [Reduce redundant Redis parameter initialization](https://gitlab.com/gitlab-org/gitlab/-/commit/ba04c2c1baf5e337c26944628d5d685d1adc8be3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184218))
- [Fix gitlab:elastic:info rake task](https://gitlab.com/gitlab-org/gitlab/-/commit/4c602bd80431c20b978061327f516f55bdcd87b6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184278)) **GitLab Enterprise Edition**
- [Fix work item draft and description with "\n\n"](https://gitlab.com/gitlab-org/gitlab/-/commit/87c3e20492c3bff884fb43115db95cf921052f8c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184273))
- [Add fallback for yaml editor](https://gitlab.com/gitlab-org/gitlab/-/commit/12d75bbde14dfba0a7888d6b7c0837e49c42ba39) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183917))
- [Improve a11y of Integrations table](https://gitlab.com/gitlab-org/gitlab/-/commit/19760748a3040424f67095ca78c5584dcd001b06) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183756))
- [Fix inconsistent state for project-level approval settings](https://gitlab.com/gitlab-org/gitlab/-/commit/14e9785890325f4793b24f5a387d3a49d0382210) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183677)) **GitLab Enterprise Edition**
- [Ensure "Edit release" links have accessible labels](https://gitlab.com/gitlab-org/gitlab/-/commit/8dc2fef337a0247cec4a2a361931901e11183ba5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183749))
- [Fix error when fetching custom roles when used in policies](https://gitlab.com/gitlab-org/gitlab/-/commit/e4c5855c011b493275b6d45b333436d18cde76c3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183506)) **GitLab Enterprise Edition**
- [Add 99 to valid onboarding_status_role value](https://gitlab.com/gitlab-org/gitlab/-/commit/98e2a7d659dd64d0374990d0ad9412fa561bdee8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184159)) **GitLab Enterprise Edition**
- [Don't use DestroyExportWorker on successful export](https://gitlab.com/gitlab-org/gitlab/-/commit/4c895fd1c74ff725cc9efe68bad87f1f1d0635ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184175)) **GitLab Enterprise Edition**
- [Fix CI/CD variable settings with custom role](https://gitlab.com/gitlab-org/gitlab/-/commit/63e034a43296ac1fbd632ebd458e9167da693a41) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183448))
- [Fix merge request pipelines on ambiguous refs](https://gitlab.com/gitlab-org/gitlab/-/commit/9e126a06392558f8f4787cfd55c1bc0f34992c62) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158976))
- [Remove tsquery_deduplicate_search_terms feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/076fd9d3aa223ded31fb11a6c66c92950f01c9fc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183538))
- [Handle undefined body and html for rte](https://gitlab.com/gitlab-org/gitlab/-/commit/0792e0e9f73c4e20c941543b707bc8eaae4195cf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184140))
- [Use normalized package_name during](https://gitlab.com/gitlab-org/gitlab/-/commit/47a734bb9cfdbeb1728dddfe34e7d88fe5772f29) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183995)) **GitLab Enterprise Edition**
- [Update pipeline variables polling](https://gitlab.com/gitlab-org/gitlab/-/commit/2ea276fb72ed30bb2ff890ab82d1fcd0c80eefcf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183881))
- [Fix rebase failure alert variant](https://gitlab.com/gitlab-org/gitlab/-/commit/d6a647ce6583c6e35b3b2f47f8d8c796c36c56c3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184085))
- [Ensure "Edit release" links have accessible labels](https://gitlab.com/gitlab-org/gitlab/-/commit/58234022a177f8bba09ce7e7b459f3fb5d029f1d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183747))
- [Adapt Duo Chat Slash commands for multi-threaded](https://gitlab.com/gitlab-org/gitlab/-/commit/435a8408c1dc0b4f0ec9be6d0222596f3ede3292) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183822)) **GitLab Enterprise Edition**
- [Passing color contrast for job log line numbers](https://gitlab.com/gitlab-org/gitlab/-/commit/f42daf67b72a3d3af7fc3db27fb7d1c3190e5f14) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179551))
- [Show full job sidebar when troubleshoot bar exists](https://gitlab.com/gitlab-org/gitlab/-/commit/c64143a64c44f534ddb72bb6aaf0e0c926c212e2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184053))
- [fix: Use short ref name as fallback in pipeline UI](https://gitlab.com/gitlab-org/gitlab/-/commit/5ac5fc25933c71fda32a3e8ecc760b44e19210be) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184052))
- [Add unverified_author_email to grahql endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/763dae9e6b0848fb2066f458c64905c6e374dfe7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181805))
- [Allow anonymous users to load pipeline analytics](https://gitlab.com/gitlab-org/gitlab/-/commit/60839c49f24800433380a6cf1724b3801a441e8c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184032))
- [Fix WorkItemType for reference work items](https://gitlab.com/gitlab-org/gitlab/-/commit/8cf4e1496ac11e4df12491dbd75e0bfaaee5f7e6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183647))
- [Stop redirection loop with welcome during onboarding](https://gitlab.com/gitlab-org/gitlab/-/commit/4cfcc6d997a75c36ffb1407ac7c057081c6f64d9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183899)) **GitLab Enterprise Edition**
- [Capture model experiment creation RecordNotUnique error](https://gitlab.com/gitlab-org/gitlab/-/commit/8262f11a4e82b11183453beadc5fd33720845fdc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183515))
- [Fix frozen array error with custom analyzers](https://gitlab.com/gitlab-org/gitlab/-/commit/0337089fedacf862073554e7efb6002a222a36fb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183879)) **GitLab Enterprise Edition**
- [Fix Rack Attack incorrectly rate limiting runner API](https://gitlab.com/gitlab-org/gitlab/-/commit/f3547556874377474cfe1f64ccbb22f83088a8e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183764))
- [Fix SHM health check not enabling properly](https://gitlab.com/gitlab-org/gitlab/-/commit/f15f2bb428b3b968f4e6f4c1bc8138bb5e2e0123) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183692)) **GitLab Enterprise Edition**
- [Use Redis pipeline creation for MR commit pushes](https://gitlab.com/gitlab-org/gitlab/-/commit/cd290ed3a3a5a6d95eb7682f819033d51a9fb5c3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182449))
- [Use design tokens for diff file row and linked diff file](https://gitlab.com/gitlab-org/gitlab/-/commit/31c22efb66f6aa22e5873aa5e41da7e3abf2efdc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183456))
- [Convert DuoEnterprise trials lead form to view component](https://gitlab.com/gitlab-org/gitlab/-/commit/b798acf110292b70f58bfe4e7e74659db0e07716) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181874)) **GitLab Enterprise Edition**
- [Fix confidential filters for epics advanced search](https://gitlab.com/gitlab-org/gitlab/-/commit/f877c05292ba8dce79a21dca6c4b035b133218f7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183437)) **GitLab Enterprise Edition**
- [Add all actions to sticky header](https://gitlab.com/gitlab-org/gitlab/-/commit/c0bcc11ee7c87b0929de3a4360543ba12a20228f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183547))
- [A11y improvements for user profile and admin user groups/projects page](https://gitlab.com/gitlab-org/gitlab/-/commit/d3c36d30eaabbcbb2269737dd784fefe8771d656) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183438))
- [Ensure revoke token buttons have unique link text](https://gitlab.com/gitlab-org/gitlab/-/commit/17eba2966bce266c1c53ee148a25ef2c48237876) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183265))
- [Fix path rejection for Dependency path](https://gitlab.com/gitlab-org/gitlab/-/commit/c619aed99d762435b976d2b952cb1bf5ed2260ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183682)) **GitLab Enterprise Edition**
- [Make sure aside has its implicit complementary role](https://gitlab.com/gitlab-org/gitlab/-/commit/8d26b5a8977a99875ad57990439c71ef8deb219c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163483))
- [Fix admin_display_duo_addon_settings? check](https://gitlab.com/gitlab-org/gitlab/-/commit/e430aa150ff69f89553f28d4c0eae7be55fd9266) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183507)) **GitLab Enterprise Edition**
- [Prevent invalidating remember tokens on logout](https://gitlab.com/gitlab-org/gitlab/-/commit/ce87820a7879854e1b4d891ec5e6cecdcdedad57) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183471))
- [Fix checkbox toggling in work item notes](https://gitlab.com/gitlab-org/gitlab/-/commit/59fb1b71fde5b2baf98da1f049ee78d4dfe6fb36) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182771))
- [Fixes CE profile Usage Quotas rendering](https://gitlab.com/gitlab-org/gitlab/-/commit/26dda60685d6d6e6bc856e8e499337175f58f60f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183577))
- [Don't auto-resolve dismissed vulnerabilities](https://gitlab.com/gitlab-org/gitlab/-/commit/0c393436c2bdca79b59eb9bed59204b0efadd139) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183430)) **GitLab Enterprise Edition**
- [Include before_sha in PEP pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/7ab7e8b5779495b84e9736a41cd56932e533af09) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182876)) **GitLab Enterprise Edition**
- [Added long line truncation for frontend highlighting](https://gitlab.com/gitlab-org/gitlab/-/commit/5331b6595deda1f9335dc159da3295a8b98782a0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180761))
- [Requeue migration to resync policy project links](https://gitlab.com/gitlab-org/gitlab/-/commit/16e6f0d7d385b9a592954b5295fd9986f9d5c497) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183065)) **GitLab Enterprise Edition**
- [Capture model registry version creation PG errors](https://gitlab.com/gitlab-org/gitlab/-/commit/4983076ce1b477e1917477127dc664ce9bdef9a9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183475))
- [Do not disable OAuth by "Disable personal access tokens" group setting](https://gitlab.com/gitlab-org/gitlab/-/commit/cc8aa847dc94ac1137e44b9756dbeede53b4e4aa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183488)) **GitLab Enterprise Edition**
- [Stop user onboarding for group saml](https://gitlab.com/gitlab-org/gitlab/-/commit/7ac701f3ebf87cec739b6c73bbb1f60e2b68da52) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183252)) **GitLab Enterprise Edition**
- [Update PruneProjectExportJobsWorker cronjob schedule](https://gitlab.com/gitlab-org/gitlab/-/commit/6c12d7f4e62e3e3cd022149a1fd8b352e6ccbf85) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182971))
- [Add optional chaining to ref response](https://gitlab.com/gitlab-org/gitlab/-/commit/6be2fb04c6d44f908c6bb353d9f73134bab43631) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183463))
- [Improve a11y of Help menu](https://gitlab.com/gitlab-org/gitlab/-/commit/9ee75f409cd732fac04028728e4f9adf6c4e66ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183443))
- [Ensure feature flag edit buttons have unique link text](https://gitlab.com/gitlab-org/gitlab/-/commit/ff5b26da8223f551d23727614b7f17548156acde) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183262))
- [Remove filter_saml_enforced_resources_from_graphql feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/3dfd246265acffb47d687e6ff570c7cd61effa88) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183417))
- [Improve a11y of links in Whats New drawer](https://gitlab.com/gitlab-org/gitlab/-/commit/6c972a1025f12977e675b8ab27effd38db834c7f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183411))
- [Show copy to clipboard button on mermaid code block](https://gitlab.com/gitlab-org/gitlab/-/commit/51c99b275e8f029d45fc821544d3170c14681739) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183247))
- [Fix RTE loading indicator position](https://gitlab.com/gitlab-org/gitlab/-/commit/4ab6ae83369e6dc425b32069fe4feb841c5e03ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183358))
- [Ensure user edit links in admin have unique text](https://gitlab.com/gitlab-org/gitlab/-/commit/d3776f58bfee2dbd6317f0eacec18194a4d203f4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183268))
- [Ensure docs and config links on admin dashboard are accessible](https://gitlab.com/gitlab-org/gitlab/-/commit/92bbbbe6d7716fb430a0b5613089348600818502) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183379))
- [Fix source and target branch in dev widget](https://gitlab.com/gitlab-org/gitlab/-/commit/f869a5f30ad71946f26f2fd38a4b044aa4cbc522) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182504))
- [Fix group filter on work items list](https://gitlab.com/gitlab-org/gitlab/-/commit/71ea84e06fa0f37ab7caa2ff259f87b81cb6934c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182163))
- [Fix custom_ability_ feature flag usage](https://gitlab.com/gitlab-org/gitlab/-/commit/e2a0044a21eb2f34421407c6330ddf7326eccca3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181738)) **GitLab Enterprise Edition**
- [Fix pipeline marked invalid when var is empty string](https://gitlab.com/gitlab-org/gitlab/-/commit/6f7428aa9d35043e547d8cd49af29f22a7e22441) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182993))
- [Add aria-desrcribedby for status links in admin jobs table](https://gitlab.com/gitlab-org/gitlab/-/commit/7f428f94f13e0d9bffb626206a17aacc457adcde) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183271))
- [Fix open vsx resource url template](https://gitlab.com/gitlab-org/gitlab/-/commit/934cd0b99786c79f88cd85aee3eb0713c26f23d8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183071))
- [Stream audit events only once using feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/d25fe8a7bab78fe6a08add1d404c6ecc314ed9ce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182587)) **GitLab Enterprise Edition**
- [Fix missing graphql field](https://gitlab.com/gitlab-org/gitlab/-/commit/04d9869db9c7a8ab420824a9097ca17c1b4fd279) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182755))
- [Skip entry owners check for exclusion pattern](https://gitlab.com/gitlab-org/gitlab/-/commit/d372d595a373019a8911fc4ebfc342dc5a305aa7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182403))
- [Fix invalid sort in placeholder users app](https://gitlab.com/gitlab-org/gitlab/-/commit/3e701946fbd9edf1701cd1af653cafab4aa8f8ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183210))
- [Fix emoji key in suggestions dropdown](https://gitlab.com/gitlab-org/gitlab/-/commit/e3c0846074f55ff1b8663a21e2e0a77ef7192a37) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183206))
- [Abuse report: Fix a11y issues](https://gitlab.com/gitlab-org/gitlab/-/commit/8c0885c040e944e05f922d9c7a8170d86d09da59) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182237))
- [Process auto megre on page load if required](https://gitlab.com/gitlab-org/gitlab/-/commit/b4afe537d2771232a0925f1ea4fdf19d69d1aafb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182992))
- [Fix downloads failing due to duplicate SSRF filters](https://gitlab.com/gitlab-org/gitlab/-/commit/b42c01c7b2ae04d03f6404bba02c102d1a3621e0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182493))
- [Implement repository archive cache cleaning inside Workhorse](https://gitlab.com/gitlab-org/gitlab/-/commit/6ba452632a17b32d4b33dab2bac117d0bf4388ad) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182796))
- [Split cyclonedx artifact into multiple reports](https://gitlab.com/gitlab-org/gitlab/-/commit/fca94833bb4694bc11989cf4694d7ce3184f950e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182324)) **GitLab Enterprise Edition**
- [Fix the pipe search for zoekt exact search mode](https://gitlab.com/gitlab-org/gitlab/-/commit/2efdc94d5f275b73561f5bc995ecbac8f227b48a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181424))
- [Fix workItem parent dropdown item click](https://gitlab.com/gitlab-org/gitlab/-/commit/55d5bbf5098b0addbe4d314b2029f47f59f27360) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183030))
- [Preserve selected items in dropdown text](https://gitlab.com/gitlab-org/gitlab/-/commit/f8380923b9cfa09edbbd71e966bcc8a3b2d9d7c9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182644)) **GitLab Enterprise Edition**
- [Model runs: Handle not destroyed error](https://gitlab.com/gitlab-org/gitlab/-/commit/d6f6576effe05e5674fa201d9383520ba50fc4fa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183004))
- [Return a bad request status if an environment fails to stop via API](https://gitlab.com/gitlab-org/gitlab/-/commit/c56d035749724865d7af64522cb9da6ca64e12b4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181339))
- [Update typo](https://gitlab.com/gitlab-org/gitlab/-/commit/7150c42a347e74248764f5740c226ecb1ba26714) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182964))
- [Reset selected exceptions projects](https://gitlab.com/gitlab-org/gitlab/-/commit/90e389ee13fe424ac6ce75b9be5f6b54998c6693) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182951)) **GitLab Enterprise Edition**
- [Adjust help text for instance wide restricted access setting](https://gitlab.com/gitlab-org/gitlab/-/commit/35a26ea5a74820766963e95b25ece5faf19a160c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182942)) **GitLab Enterprise Edition**
- [Fixed missing regex and syntax options buttons in topbar](https://gitlab.com/gitlab-org/gitlab/-/commit/56e67fb1140ef5e8187a3c23be5459f56ec556c1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182879))
- [Delete security_policies when policy.yml becomes invalid](https://gitlab.com/gitlab-org/gitlab/-/commit/97faf8265c2515d8be730d59347036c074d512d8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181837)) **GitLab Enterprise Edition**
- [Show rebase button if user can push to source branch](https://gitlab.com/gitlab-org/gitlab/-/commit/b1ee4cb4ec7f2c3004fec739dc41b9a19779d055) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182793))
- [Fix emoji award button styling for selected state](https://gitlab.com/gitlab-org/gitlab/-/commit/55b0ea60941defa2f88173aef312090303122df4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182787))
- [Prevent CiIcon text color from being overridden](https://gitlab.com/gitlab-org/gitlab/-/commit/5b56510e4ed97325f49eb9446c1ac57de973061f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182780))
- [Ensure badge popover opens on click](https://gitlab.com/gitlab-org/gitlab/-/commit/564879f68bd353271e1f5127ff7f2623a0aa0a5d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182399))
- [Zoekt: Fix missing repo logic](https://gitlab.com/gitlab-org/gitlab/-/commit/4d58b55f51fd4bc248d4e107286654d0170815af) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182585)) **GitLab Enterprise Edition**
- [Fix issuable filter focus shortcut](https://gitlab.com/gitlab-org/gitlab/-/commit/27ae7b1fefbe1f9d50f19d46cdcfb4300ef66af8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/152427))
- [Release status badge: Fix border not appearing render issue](https://gitlab.com/gitlab-org/gitlab/-/commit/f43308b6ee0cb1d6094231b475c25d13523f6d68) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182743))
- [Catch Key errors in Google Cloud audit event steaming](https://gitlab.com/gitlab-org/gitlab/-/commit/8e8deebfec32552d114fefabf6f4f8a805471ebb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182712))
- [Add background migration to resync policy project links](https://gitlab.com/gitlab-org/gitlab/-/commit/c95a6596ba20a6c3c93199c9aca0737443ed611a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181164)) **GitLab Enterprise Edition**
- [Use semantic H2 for "Related jobs" header](https://gitlab.com/gitlab-org/gitlab/-/commit/bcdd2db8fbfd8e52f17989c38ad1a9c4d0c5cbf9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182320))
- [Set default for pipeline dependency export](https://gitlab.com/gitlab-org/gitlab/-/commit/ad56573215a5f6efb5a71eeb025a9b1a548eace8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182634)) **GitLab Enterprise Edition**
- [Prevent deletion of project_bot users with non-expiring access tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/6937915aed1d3d2a8eb215b39d3f335cf41f9257) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182621))
- [Fix accessibility of Whats New drawer headers](https://gitlab.com/gitlab-org/gitlab/-/commit/07ab934351c9bc663873da6da25eda1a3e4cc6f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182625))
- [Fix skip to main content button UI](https://gitlab.com/gitlab-org/gitlab/-/commit/18ada5a052e02bd2286e21accd94b05203a4a36d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182614))
- [Fix indentation for default yaml file](https://gitlab.com/gitlab-org/gitlab/-/commit/31b54f898cff97841117b07a80d352766c47e881) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182572)) **GitLab Enterprise Edition**
- [Add validation styling for approver widget](https://gitlab.com/gitlab-org/gitlab/-/commit/1fafa422669bf6c9fe31a575047110c16d59ecc5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182482)) **GitLab Enterprise Edition**
- [Prevent double escaping forward slashes](https://gitlab.com/gitlab-org/gitlab/-/commit/ed79877215e03aac58ca4e741c2cf0f2c46940df) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182548))
- [Fix badly formatted help link on some integrations](https://gitlab.com/gitlab-org/gitlab/-/commit/c6e860551a4f0d88169c4ec7d60af3235b681426) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181348))
- [Update truncato](https://gitlab.com/gitlab-org/gitlab/-/commit/8fa7d5929775e178722695e7a7f4809949219d7f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182200))
- [Load missing from dropdown groups](https://gitlab.com/gitlab-org/gitlab/-/commit/18070d862a34930548be629b2fad9a4353b17a53) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182333)) **GitLab Enterprise Edition**
- [Fix "code_owner_approval_required" override when the param is not set](https://gitlab.com/gitlab-org/gitlab/-/commit/a575c3c0fe86d5d5a5b91de4567d789f0e285f26) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181419)) **GitLab Enterprise Edition**
- [Fix pagination issue on empty To-Do dashboard pages](https://gitlab.com/gitlab-org/gitlab/-/commit/fe80749758601efb8e719213877b7d0ebba92396) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182434))
- [Fix policies for GitLab Duo code suggestions and glab ask](https://gitlab.com/gitlab-org/gitlab/-/commit/d088304f4783cb875f87b8e8112a73afd4dd302c) by @stepech ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182315)) **GitLab Enterprise Edition**
- [Issue boards: Add new item projects select a11y label fix](https://gitlab.com/gitlab-org/gitlab/-/commit/fc4e8458003d36bdbb833902bfd31323e9f94b97) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182270))
- [Use semantic H3 for "Can't scan the code" section of 2FA setup](https://gitlab.com/gitlab-org/gitlab/-/commit/f03e5814e2c8017341b312bd226b4fde91636864) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182336))
- [Use semantic headers in SingleStatComponent in admin elasticsearch form](https://gitlab.com/gitlab-org/gitlab/-/commit/4cafbb359a0d98d0e7f1569a8247ff27f53f6355) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182335))
- [Use semantic headers for user stat cards in admin and unique links](https://gitlab.com/gitlab-org/gitlab/-/commit/9cb7f6973875f8c3c5461bc5c28ec850ac3353a5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182332))
- [Correct acessibility header issues in admin dashboard](https://gitlab.com/gitlab-org/gitlab/-/commit/8bf74f71d69482dbd868642338c5d5088d69ddde) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182329))
- [Use H2 for job empty state](https://gitlab.com/gitlab-org/gitlab/-/commit/789f9d20e05516ef6296b426c16478a840aee741) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182322))
- [Prevent Child item expand toggle from overlapping child item](https://gitlab.com/gitlab-org/gitlab/-/commit/40ab430c4e8b465551104a8a9aaffce4271d460c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182169))
- [Fix detection of empty merge request approval policy](https://gitlab.com/gitlab-org/gitlab/-/commit/8e0adb60fac29ec4b05a9662b708315915a46e8b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179623)) **GitLab Enterprise Edition**
- [Fix MR approval policy evaluation for chained MRs](https://gitlab.com/gitlab-org/gitlab/-/commit/5295fe63551a4343e09864472de3bcf267511d22) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176630)) **GitLab Enterprise Edition**
- [Ensure Md header anchor shows even when description is collapsed](https://gitlab.com/gitlab-org/gitlab/-/commit/52774c106c5c541abc358589d3f543007fc880a9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182182))
- [Fix previous/next commit buttons on merge requests](https://gitlab.com/gitlab-org/gitlab/-/commit/3a138546fef5a1091cc3a9cd0f42091d4fb64098) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182168))
- [Fix work item epic listing button](https://gitlab.com/gitlab-org/gitlab/-/commit/d4ad029021d68a70b49ad94181da77b59f2487fc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182061))
- [Fixes deactive active deployment with same path](https://gitlab.com/gitlab-org/gitlab/-/commit/39c329746f7572ca18f9658182706d8778ea25bb) by @Rumple_17 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179100))
- [Load missing from dropdown frameworks](https://gitlab.com/gitlab-org/gitlab/-/commit/88eb6009e897872b69afcc1e79aed8bf7f480313) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182184)) **GitLab Enterprise Edition**
- [Load missing from dropdown projects](https://gitlab.com/gitlab-org/gitlab/-/commit/cee88f87f5fb2a76e0bf9b1e77a15b967273bd04) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182137)) **GitLab Enterprise Edition**
- [Add max length calculations and user indications to status form](https://gitlab.com/gitlab-org/gitlab/-/commit/feabf8d1b869709939c6842e98b7546b9f8ad1a1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179618))
- [Resync security_policies with incorrect index](https://gitlab.com/gitlab-org/gitlab/-/commit/d4374e2a95a7c0d9cefb3cffad1f3ddd04fd8bd3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181303)) **GitLab Enterprise Edition**
- [Adjusts BSO logic for free groups](https://gitlab.com/gitlab-org/gitlab/-/commit/cf4d27e5b61cc2279c2269765a759dc2b4f76986) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181765)) **GitLab Enterprise Edition**
- [Dompurify: Allow background-color style attribute on GlLabel](https://gitlab.com/gitlab-org/gitlab/-/commit/68405c44650f7c8c07037d3d918bcdccb009e7e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180194))
- [Allow read access for admin job token permissions](https://gitlab.com/gitlab-org/gitlab/-/commit/cd925b93d1ac6fe05091e91794e5d7767b2c852b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181970))
- [Fix setting ci_id_token_sub_claim_components](https://gitlab.com/gitlab-org/gitlab/-/commit/82f296045e3c76fd8a23c9471cbd152769a5016a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181981)) **GitLab Enterprise Edition**
- [Fixes admin page CI minutes css class usage](https://gitlab.com/gitlab-org/gitlab/-/commit/27b10b521c2df4f4a053b98f0973f4569f4f58ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180797)) **GitLab Enterprise Edition**
- [Correct milestone in featue flag definition](https://gitlab.com/gitlab-org/gitlab/-/commit/043d54854c4503589331a2387f7a134ba97d052f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181991)) **GitLab Enterprise Edition**
- [Ignore policy schema validation for custom roles](https://gitlab.com/gitlab-org/gitlab/-/commit/ad4151cb5b83f3956cb66936fc3c4eb0af513cc8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182026)) **GitLab Enterprise Edition**
- [Keep value stream analytics active in sidebar](https://gitlab.com/gitlab-org/gitlab/-/commit/1f3d18edc4350f445e9b99fba1de6010dfa95fd8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181844))
- [Add queuing worker for broken adherences](https://gitlab.com/gitlab-org/gitlab/-/commit/c616ddd831d78a973f8dfe77de149ce9e809046c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179944)) **GitLab Enterprise Edition**
- [Fix severity filtering for severity overridden security findings](https://gitlab.com/gitlab-org/gitlab/-/commit/5044210769ef8ba1955b860bf6c11f3ae538a44b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181998)) **GitLab Enterprise Edition**
- [Skip processed members](https://gitlab.com/gitlab-org/gitlab/-/commit/0c7861ca1e89f61c7a9254cc6a744674f28d6d3a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180935))
- [Fix DOMPurify validation for SVGs](https://gitlab.com/gitlab-org/gitlab/-/commit/9464f220997d8d4f5d7eea34cd00f0e18d4d0834) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181941))
- [Import GitHub collaborators consistently](https://gitlab.com/gitlab-org/gitlab/-/commit/4eefdb14c629edbad6a29a5c3eb8b0e55f08041a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180685))
- [Fix edit framework refresh bug](https://gitlab.com/gitlab-org/gitlab/-/commit/d3eb0a43790295bb3ac4dedd73f759089ce3bc29) by @nradina ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181290))
- [Add min size to confidential icon](https://gitlab.com/gitlab-org/gitlab/-/commit/42c1fb65dc6a85e5fe03a96fa3c1bdd36994d5a0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181779))
- [Generate correct agent URL in managed resource annotations](https://gitlab.com/gitlab-org/gitlab/-/commit/75e8af59be806dfe396c3bcec421008d29351de1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181839))
- [Small alignment fixes in merge widget](https://gitlab.com/gitlab-org/gitlab/-/commit/ae895daf7a003acb4f0acdd8ce327cb318eaa180) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181834))
- [Change date toggle when updated via subscriptions](https://gitlab.com/gitlab-org/gitlab/-/commit/28e939251dc80c52283ef7d32b43c48f9b7c59ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181654)) **GitLab Enterprise Edition**
- [Hide markdown editor fullscreen button when work item is in drawer](https://gitlab.com/gitlab-org/gitlab/-/commit/4c7a183471138021d80cae1ee691ac1f5ea7a77f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180626))
- [Fix release evidence tag name generation](https://gitlab.com/gitlab-org/gitlab/-/commit/d80669df6168f308e010f3f35baad2555045cb25) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180772))
- [Fix ambiguous created_at column for pipeline_configuration_full_path](https://gitlab.com/gitlab-org/gitlab/-/commit/0e7ef108f246a1bef4a3765c3340875dbdd0a30f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181334)) **GitLab Enterprise Edition**
- [Fix audit event http streaming under feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/5fb51e7e0a621a1b8a2ffecb207996919bd91141) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181009)) **GitLab Enterprise Edition**
- [Update query for banned user project deletion](https://gitlab.com/gitlab-org/gitlab/-/commit/637bbb91b0ee3b802d220cab2a5130d7042cdbc4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181592))
- [Safely handle when sanitized Elastic result is blank](https://gitlab.com/gitlab-org/gitlab/-/commit/ead89bd40ebcad3b7f88216d45fef06fad735781) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181760)) **GitLab Enterprise Edition**
- [Use correct project when fetching managed resources templates](https://gitlab.com/gitlab-org/gitlab/-/commit/da815aee5ea74e58c86b5020268e93277dde3972) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181749))
- [Fix 'Apply' button for WI dates widget](https://gitlab.com/gitlab-org/gitlab/-/commit/c94cca690189e346d7107c2e90067fe930777d01) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181578))
- [Allow access to publicly accessible features from job tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/9d03265f820d7b92cb3b3a8fb1370fc92f503029) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179717))
- [Make multi-word label matching case-insensitive](https://gitlab.com/gitlab-org/gitlab/-/commit/3ceafd23802ab2a38b5ad60a85a7956270fe2281) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180823))

### Changed (189 changes)

- [Use epic creation adapter in more places](https://gitlab.com/gitlab-org/gitlab/-/commit/852f75d079c36a2ba3d0fcd5a4d3ce41c0da442c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181767)) **GitLab Enterprise Edition**
- [Add email delivery for vulnerabilities exports](https://gitlab.com/gitlab-org/gitlab/-/commit/360ecb7d206e7fce820c6b30c96e700d37e984ce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183169)) **GitLab Enterprise Edition**
- [Update CI steps syntax specification](https://gitlab.com/gitlab-org/gitlab/-/commit/8fddc95cde27be66643f4bd1bc8a6a5b0384291b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184005))
- [Document how to use a custom PEP pre stage as non-blocking](https://gitlab.com/gitlab-org/gitlab/-/commit/e65edda1f9f55b42e59b31ce76a95a3b95707581) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184603))
- [Finalize delete_orphaned_stage_records](https://gitlab.com/gitlab-org/gitlab/-/commit/67ce59edcfe157444b31c6eafa012f0d70f02209) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178120))
- [Finalize backfill subscription_add_on_purchases](https://gitlab.com/gitlab-org/gitlab/-/commit/97916629289e446348c9d91768b908655c82f7ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184336))
- [Improve performance of CI/CD analytics page](https://gitlab.com/gitlab-org/gitlab/-/commit/98b0b808163da3e7f0e62140fa9c57f80b51bbf4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184328))
- [Update description for q test mr norm and diff](https://gitlab.com/gitlab-org/gitlab/-/commit/f34979a5d3829b18b4ab20b8e9e54be7dd49465a) by @jlosito ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183853)) **GitLab Enterprise Edition**
- [Changed text on the breadcrumbs for creating new entities in projects:](https://gitlab.com/gitlab-org/gitlab/-/commit/5aba39fe7e5fb5367df098e5dbc3e752c48f2ae5) by @illia_bakunovskyi ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174315))
- [Crud, MR widget, settings block: Add preference for reduced motion](https://gitlab.com/gitlab-org/gitlab/-/commit/37ea97fceee67309f370a3ea9d36c4055c6dbe1e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184434))
- [Remove feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/03b521aa7c270d000618343c536b315f06e20b76) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184330)) **GitLab Enterprise Edition**
- [Refresh member authorized projects in background job](https://gitlab.com/gitlab-org/gitlab/-/commit/19b9a244692d21a6b6a4f3226f04df8074be4702) by @Taucher2003 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183920))
- [Enable migrated prompts for summarize comments](https://gitlab.com/gitlab-org/gitlab/-/commit/256d33b1cc2c21f6243055db31847fde5a90c685) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184447))
- [Refactored util to fix sm billable logic](https://gitlab.com/gitlab-org/gitlab/-/commit/fc3ac3521061f789c0493e50eed38c52299e6163) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184305)) **GitLab Enterprise Edition**
- [Add header to project snippets page](https://gitlab.com/gitlab-org/gitlab/-/commit/8e3eed6da4d3e93746014d0638992a84b5c89222) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184201))
- [Enable configuration of Duo Chat sub-features](https://gitlab.com/gitlab-org/gitlab/-/commit/03a24fdcb780fa5d04b621b3b0a79f31d9f152de) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175349)) **GitLab Enterprise Edition**
- [Show skipped rows in CSV reassignment email](https://gitlab.com/gitlab-org/gitlab/-/commit/98b291c2ac1fd9a921dee908078dc16ea74ffc9d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183449))
- [Expose correlation ID in overloaded message](https://gitlab.com/gitlab-org/gitlab/-/commit/d9fe2edb9e63f3b0c5131d6b541512c322ba6b15) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182908))
- [Update dependency auto-deploy-image to v2.125.0](https://gitlab.com/gitlab-org/gitlab/-/commit/c091dd0c9f2725ec9c488d66bbe6f5fd130493c3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184388))
- [Add group and project scope for basic users autocomplete](https://gitlab.com/gitlab-org/gitlab/-/commit/8217c1ac948c9022805f61d3fdd43ff2d527dd21) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182557))
- [RCA/Troubleshoot uses new Claude 3.7 model](https://gitlab.com/gitlab-org/gitlab/-/commit/50bac36c3516db7e8c7fa6a6b4d8e825040456a8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184364)) **GitLab Enterprise Edition**
- [Release the Docker Hub credentials support in the Dependency Proxy](https://gitlab.com/gitlab-org/gitlab/-/commit/58d339780ba2cbe87e6a57ecfd3a89f1c71e901b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183020))
- [Update code creation slash commands to Claude 3.7 Sonnet](https://gitlab.com/gitlab-org/gitlab/-/commit/0f6788435f293cacf8eab113fbbf1da654293e3a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184333)) **GitLab Enterprise Edition**
- [Remove deprecated remote_development_agent_config references](https://gitlab.com/gitlab-org/gitlab/-/commit/8ce5e46c151eb5a14c036b60b25f897a478cdcbf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183427)) **GitLab Enterprise Edition**
- [Release squash commits options for branch rules](https://gitlab.com/gitlab-org/gitlab/-/commit/236f5a3a9ddc7eaf9a3a1c29a4d3ba85985382c1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184177))
- [GLQL: Add Crud to views](https://gitlab.com/gitlab-org/gitlab/-/commit/94e52b56a4fe7b079c802e90560bcc6ab29d8f11) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183709))
- [Vulnerability finding: Update design of form](https://gitlab.com/gitlab-org/gitlab/-/commit/1566dddbcf26cb42ec43535df3e894b36c996815) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183668))
- [Move Seat Control > Restricted Access to paid plans only](https://gitlab.com/gitlab-org/gitlab/-/commit/5e9eff2ed6eb41e8aafd7ac78c018b12e2516800) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183983)) **GitLab Enterprise Edition**
- [Release ignore specific revisions in git blame](https://gitlab.com/gitlab-org/gitlab/-/commit/ba43eb5cce1014310146c73086781447bdba375b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184260))
- [Tables: Add scroll indicator](https://gitlab.com/gitlab-org/gitlab/-/commit/8c90370c3fdade51379b0406e52781fa98e2cf49) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181650))
- [Update class for to-do item on hover](https://gitlab.com/gitlab-org/gitlab/-/commit/251652370cf6d24bba2fd4afe254ab706df4587e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184064))
- [Update page headings in the CI/CD analytics pages](https://gitlab.com/gitlab-org/gitlab/-/commit/aadca97beb43dc8b4499df58f41f6a2a487d0920) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184282))
- [Remove feature flag `dependency_scanning_using_sbom_reports`](https://gitlab.com/gitlab-org/gitlab/-/commit/11ffa7c2fcd06e030f29ffad39b7719f8339d55f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184295)) **GitLab Enterprise Edition**
- [Clean up labels UI](https://gitlab.com/gitlab-org/gitlab/-/commit/23eb196ed6bf89e45438ff66e3ad9acd5a502156) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183767))
- [Improve error message for webhook name description](https://gitlab.com/gitlab-org/gitlab/-/commit/1bfe6b2c061108c4f17b4d50b9b3ceb0ac35022d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184256))
- [Default enable duo_code_review_claude_3_7_sonnet](https://gitlab.com/gitlab-org/gitlab/-/commit/2f99149eb71a65eb7f60987c252d50928810beaa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184253)) **GitLab Enterprise Edition**
- [Default enable generate_commit_message_claude_3_7](https://gitlab.com/gitlab-org/gitlab/-/commit/d096074c61b313db95350670e709270db9668e6b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184255)) **GitLab Enterprise Edition**
- [SPP docs diff scan web requests feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/b27eeb5198d9c9eb2b345012bef5a01b3b1d8e8c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183741))
- [Make snippet list info focusable](https://gitlab.com/gitlab-org/gitlab/-/commit/f546698d83357dec5e75abb5fbc7122ee32ed96b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184209))
- [Add archived only project filter to project graphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/f286badda17c876009be947c1c100996dba4972f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182667))
- [Optimize file size check using quarantine dir and add EE-specific check](https://gitlab.com/gitlab-org/gitlab/-/commit/b13520eba56ce581ad58a54fdd422c082d4afd76) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183600)) **GitLab Enterprise Edition**
- [Remove group_dependency_list_csv_export feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/e44cee8234d6469a28d4ada3e3d5d551bafb36dd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184206)) **GitLab Enterprise Edition**
- [Updating /troubleshoot or RCA AI Feature to pull prompt from AI Gateway](https://gitlab.com/gitlab-org/gitlab/-/commit/e0363d9d5d2c2a9a8b20bd47f027e1ceb2b7f6ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184198))
- [Rollout manual severity overrides feature](https://gitlab.com/gitlab-org/gitlab/-/commit/2bfe5a82b28c6912a0687dcfb614568cede38231) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183528)) **GitLab Enterprise Edition**
- [Move GLQL SLIs to its new controller](https://gitlab.com/gitlab-org/gitlab/-/commit/84e91e1952036022ae5a581852bc6b467a467022) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183842))
- [Bump PG default version for CI](https://gitlab.com/gitlab-org/gitlab/-/commit/18d719abee7707e3ba84a918475f840785823b65) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183537))
- [Update Sidekiq memory killer docs](https://gitlab.com/gitlab-org/gitlab/-/commit/d3b2009da3a40bcdd5f6bf273a4d02149196f602) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184130))
- [Remove `your_work_projects_vue` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/dfd2721c1deee154dafc60257ac142613c8fbda6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183429))
- [Move CI_PAGES_HOSTNAME from build.rb to project.rb](https://gitlab.com/gitlab-org/gitlab/-/commit/05346c2fe6c110cd90e642f9ecb336d0fb6818e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183671))
- [Rename Rack Attack log field: request_method -> method](https://gitlab.com/gitlab-org/gitlab/-/commit/c41459d2c6805f332fa1e2ea853890c0ec33ffcd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183888))
- [Add v2 approval rule associations to user and user group](https://gitlab.com/gitlab-org/gitlab/-/commit/6726d1dba0c7a6669a4c78577342161cb648cbeb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179877)) **GitLab Enterprise Edition**
- [Ingest and display direct dependencies](https://gitlab.com/gitlab-org/gitlab/-/commit/5ae47e2187a0e021a3c8932a9ff6d2526ca378be) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183246)) **GitLab Enterprise Edition**
- [Add ReplicatorEvents module to seperate event logic from other files](https://gitlab.com/gitlab-org/gitlab/-/commit/93516f6be6ed412b9cd1b47f666cbb79db3fc090) by @bymayanksingh ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/126397)) **GitLab Enterprise Edition**
- [Add tooltip directive to remove snooze](https://gitlab.com/gitlab-org/gitlab/-/commit/8d83822cf76894f87fdff54a63dd97c2246a16a4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184071))
- [Add policy type property to editors](https://gitlab.com/gitlab-org/gitlab/-/commit/ec785719c49eb7a49921972a54034f94c24d0bd9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183557)) **GitLab Enterprise Edition**
- [Mlflow get run to return less metrics data](https://gitlab.com/gitlab-org/gitlab/-/commit/9f0cea5f74bf821de69ee44a8ed1ca07df46f7f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183838))
- [Block local URLs for external controls on SaaS](https://gitlab.com/gitlab-org/gitlab/-/commit/012e0578b04d796232a52469232c9569eaff4ae0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182877)) **GitLab Enterprise Edition**
- [Simplify admin_display_duo_addon_settings? method](https://gitlab.com/gitlab-org/gitlab/-/commit/3b724ee7f410aab4a32731510e9dee2bb2d422b5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183970)) **GitLab Enterprise Edition**
- [For autocomplete scoped search options, check greater than or equal](https://gitlab.com/gitlab-org/gitlab/-/commit/9c308bf7badb9d240fea90433f930e12248d39f5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183972))
- [Enable unblock_rules_using_pipeline_execution_policies by default](https://gitlab.com/gitlab-org/gitlab/-/commit/7db3d37252923a5d16d94e74c8aa18a59f709acb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184023)) **GitLab Enterprise Edition**
- [Update policy_tuning wording to account for pipeline execution policies](https://gitlab.com/gitlab-org/gitlab/-/commit/1c2f01ab5263ce4e0e349b204f78d7741535e569) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183840)) **GitLab Enterprise Edition**
- [Use secure defaults for token storage in TokenAuthenticatable](https://gitlab.com/gitlab-org/gitlab/-/commit/4e111ec3a500290d450b27e501f373512a5338aa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183341))
- [Update documentation of policy_tuning with pipeline execution policies](https://gitlab.com/gitlab-org/gitlab/-/commit/0a14ae58cf4fd2cef7614b3cde2278b47fa0190e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183839))
- [Update User Cap settings related error message](https://gitlab.com/gitlab-org/gitlab/-/commit/08b33b9bb09f471cf219ad41b88cfeb49b44c1c0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183652)) **GitLab Enterprise Edition**
- [Sync FK `fk_rails_507416c33a_p`](https://gitlab.com/gitlab-org/gitlab/-/commit/01926187255bd87b75c823552f93eafa39cc76b0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178117))
- [Add validation for approvals required](https://gitlab.com/gitlab-org/gitlab/-/commit/58c3a67bf114fab167e19a9aad984f7a5ae00071) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183835)) **GitLab Enterprise Edition**
- [Changed regex button colors to design tokem colors](https://gitlab.com/gitlab-org/gitlab/-/commit/3fe6e6583c8903b6638991eb4c4a17b37464b35d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183406))
- [Change text limit for duo workflow event message](https://gitlab.com/gitlab-org/gitlab/-/commit/7c73cc21d95567bbba3ca1226a6ff40d8095b7b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183885))
- [Use progress track when importing single relations](https://gitlab.com/gitlab-org/gitlab/-/commit/13db8ffb657c7b004278be14583f44b7d0c91404) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183862))
- [Use sentence case for package registry](https://gitlab.com/gitlab-org/gitlab/-/commit/a02a09e91f8e8048222ad82b182ba11240791ab7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183533))
- [Rename custom status widget to status widget](https://gitlab.com/gitlab-org/gitlab/-/commit/ef78e820ad7994c643871e83a7b22288fadfd61b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183026))
- [Use text.color.link for hover color in issuable sidebar controls](https://gitlab.com/gitlab-org/gitlab/-/commit/4aa2d94087a7cae2e018ffc0ecec152a8d3812a5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183307))
- [Rename the status widget to the verification status widget](https://gitlab.com/gitlab-org/gitlab/-/commit/5c40e02e1b4ce0853c586d873b700a4a2ad86f5a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182520))
- [Making existing pipeline colours more vibrant and supporting additional pipeline statuses](https://gitlab.com/gitlab-org/gitlab/-/commit/951a8521a3c27b6a2021944a7c14255eea033b81) by @barton.tomas ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181091))
- [Display test duration time in 24hr format](https://gitlab.com/gitlab-org/gitlab/-/commit/1a5376274170ea5b8ae58a99515acef701f60be0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183705))
- [Add check to prevent banning paid users](https://gitlab.com/gitlab-org/gitlab/-/commit/a208f3fa4240018ed34c3a008c813c4f57bbf738) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183733)) **GitLab Enterprise Edition**
- [Exclude bot users from dormant removal](https://gitlab.com/gitlab-org/gitlab/-/commit/09382f5c28a1d59a3e995bd3db3a660b371ba05f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183489)) **GitLab Enterprise Edition**
- [System notes: Update icon design tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/f01f4bddd2a672e45ef721a9a7a32f76892849bd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183228))
- [Fix auto-applying labels when creating a child issue](https://gitlab.com/gitlab-org/gitlab/-/commit/af0c49b0e31215cfae3f5e02f9627cd6242093df) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181605))
- [Restrict new pipeline variables](https://gitlab.com/gitlab-org/gitlab/-/commit/19287da677c161a6e7704ef2cca4d3c2a36eefcb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183420))
- [Runner registration page should not be accessible if registered](https://gitlab.com/gitlab-org/gitlab/-/commit/5168e6cb936042bcbc95d4df8129b4f40a94933b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183178))
- [Add awareness banner for new adhernece report](https://gitlab.com/gitlab-org/gitlab/-/commit/4f005d444b3b24fb23ce3a0cf5308b1193bf8964) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182870)) **GitLab Enterprise Edition**
- [Raise runner token_encrypted length from 128 to 512 bytes](https://gitlab.com/gitlab-org/gitlab/-/commit/ae363528ed36452c7a666dafedf6f8cb5be2d5d2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183454))
- [Update feature name to GitLab Duo Self-Hosted in the UI](https://gitlab.com/gitlab-org/gitlab/-/commit/f252a8e7e6504d8c5b47026dedcd6474ac24b24d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182672)) **GitLab Enterprise Edition**
- [Design item: Improve a11y label, contrast and alignment](https://gitlab.com/gitlab-org/gitlab/-/commit/81fceee656b91ecaf5d7c0ec8da2b3f856c0a2bf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182722))
- [Remove `reject_security_policy_project_deletion_groups` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/b561e72ddbe970548d29876625d3e06142d82f80) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183334)) **GitLab Enterprise Edition**
- [Update Compliance Center Breadcrumbs](https://gitlab.com/gitlab-org/gitlab/-/commit/fad978ee4b44c2c246daaafdace629832e0f2d05) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182571)) **GitLab Enterprise Edition**
- [Allow requesting multiple embeddings from vertex](https://gitlab.com/gitlab-org/gitlab/-/commit/389f3afe454440fbe0d161936fc350fea871a0cc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182989)) **GitLab Enterprise Edition**
- [Delete the `index_todos_on_author_id` index](https://gitlab.com/gitlab-org/gitlab/-/commit/abfdd0837dcd8e61bbe438c5b91760656448512a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183434))
- [Clean up validate_codeowner_users feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/ab9568cf9bde17ad4dabed53c80cca143c29b508) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182817))
- [Restrict pipeline schedule variables](https://gitlab.com/gitlab-org/gitlab/-/commit/03af63e9d24d362f6668c9f7d070348bdf1b1f8d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183370))
- [Prevent double policy update](https://gitlab.com/gitlab-org/gitlab/-/commit/18f34792108f9f55be10432dc94a071da5d4b309) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183387)) **GitLab Enterprise Edition**
- [Write multiple PEP schedules](https://gitlab.com/gitlab-org/gitlab/-/commit/fa43c2e4209548f1a1856759eb03d7870a02c64c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180714)) **GitLab Enterprise Edition**
- [Add PG 17 to nightly rspec builds](https://gitlab.com/gitlab-org/gitlab/-/commit/5667867f40e4e635d3e286a4db7bb64c47f43db3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182730))
- [Remove FF projectComponentFilter](https://gitlab.com/gitlab-org/gitlab/-/commit/200b808ee862447e97bf33ca2f2f5c6b7452320c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180350)) **GitLab Enterprise Edition**
- [Update seats related notifications](https://gitlab.com/gitlab-org/gitlab/-/commit/048f5998001dcda45b2629a5a800f63d8481ebd2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181811)) **GitLab Enterprise Edition**
- [Backfill pipeline execution policy config links](https://gitlab.com/gitlab-org/gitlab/-/commit/d680bee9f4f8ac181b3a0a2f87a8d5cd8d4dd2b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181151)) **GitLab Enterprise Edition**
- [Update dependency auto-deploy-image to v2.124.0](https://gitlab.com/gitlab-org/gitlab/-/commit/c232855b436be8a2463481971f439df7456ca99b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179863))
- [Skip updated failed zoekt tasks to processing](https://gitlab.com/gitlab-org/gitlab/-/commit/f720c56ff067f6515520e5e3cbe51f1b6f865a6c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183272)) **GitLab Enterprise Edition**
- [Add enterprise_user key to allowlist](https://gitlab.com/gitlab-org/gitlab/-/commit/90d8c668c96e0278c2aac8c77b8f439a52b51f90) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183267))
- [Re-enable PG16 nightly integration jobs](https://gitlab.com/gitlab-org/gitlab/-/commit/6650424340878d2dc84370530ac1ff3e2c7c5558) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182619))
- [Show type label for all pipeline types](https://gitlab.com/gitlab-org/gitlab/-/commit/ba2e11c9c4ef1aaf56c54d7cb8a1a16e2d0e49be) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179760))
- [Update UX for dependency proxy for packages settings](https://gitlab.com/gitlab-org/gitlab/-/commit/c46a4336cb16690c4ce3eba3f38515118f0e52b4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182818)) **GitLab Enterprise Edition**
- [Update Application Secrets developer docs](https://gitlab.com/gitlab-org/gitlab/-/commit/49221d20ce09b10ce64b59ea8adc5750d1a71ed8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181271))
- [Wiki notes: Update design tokens used, bugfixes](https://gitlab.com/gitlab-org/gitlab/-/commit/2d9703161a74b67714182a9e04d60abb8e6c9c75) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183175))
- [Add learn more link to Disable PAT for enterprise users docs](https://gitlab.com/gitlab-org/gitlab/-/commit/99019772b511a6e7c381c600c5337455abb58771) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182965)) **GitLab Enterprise Edition**
- [Sync FK `fk_rails_494e57ee78_p`](https://gitlab.com/gitlab-org/gitlab/-/commit/0efb97716db5f501eecfd63ec807a3ea4231ae98) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177980))
- [Align submit buttons for policy cards](https://gitlab.com/gitlab-org/gitlab/-/commit/f4de386d04494a3b7e51a5a40b79af4e7686b469) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183180)) **GitLab Enterprise Edition**
- [Remove feature flag separate_group_scim_table](https://gitlab.com/gitlab-org/gitlab/-/commit/15645449430e62f421a2d37ca7068d3fb5296f8e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181148))
- [Improve development widget error message](https://gitlab.com/gitlab-org/gitlab/-/commit/47bf43d79cd6cd4d82863d3f4f5a59f59e350cce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182445))
- [Migrate web_ide_extensions_marketplace ff to data](https://gitlab.com/gitlab-org/gitlab/-/commit/838c777f1cb49ec2d8dcb48ccf8f479d6568c859) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181152))
- [Extends work item shortcut support](https://gitlab.com/gitlab-org/gitlab/-/commit/0f4e1426a03a2d5900dabb415af1490f288e9af9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182327))
- [Remove `reject_security_policy_project_deletion` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/6a75854eacda80e35f8e646d6a919d7f0a65aae3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182413))
- [Update icon in nav to use import](https://gitlab.com/gitlab-org/gitlab/-/commit/df1435f4c1a67aa8e7ebf9b7b0ab604285d58370) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182428))
- [Advanced Search user autocomplete scoped to auth namespaces](https://gitlab.com/gitlab-org/gitlab/-/commit/837a8bed6e3832eb3a0c5ebee069d24eaeb9899f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182277)) **GitLab Enterprise Edition**
- [Execute GitLabDocumentation tool via Agents](https://gitlab.com/gitlab-org/gitlab/-/commit/22446d49a5ccc1a83dda2f3c81f53e9e35020887) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180273)) **GitLab Enterprise Edition**
- [Remove id mapping from skip ci](https://gitlab.com/gitlab-org/gitlab/-/commit/d1987eab6331b866189362dc131309f67c80917c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183027)) **GitLab Enterprise Edition**
- [Remove two related Cloud Connector FFs](https://gitlab.com/gitlab-org/gitlab/-/commit/586288de96c39c5066639f3f4587cf6d82f716c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183010)) **GitLab Enterprise Edition**
- [Introduce new policy for deleting image tags](https://gitlab.com/gitlab-org/gitlab/-/commit/d8413839057daf0fb9b54cb6828c45717137354d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181857))
- [Replace feature flags for email restrictions with setting](https://gitlab.com/gitlab-org/gitlab/-/commit/a522fce6849ad6050e25019076bd5447eff587f3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182601))
- [Persist analytics dashboards filter bar selections in the URL](https://gitlab.com/gitlab-org/gitlab/-/commit/a6e5427eb7185be432d8fc32f3ac929fceba488d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182465))
- [Stop logging Direct Transfer pipeline steps](https://gitlab.com/gitlab-org/gitlab/-/commit/52a86894e07455790c3486b5bbcf1547c64d4215) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182966))
- [Migrate restrict_user_defined_variables to `true`](https://gitlab.com/gitlab-org/gitlab/-/commit/998d84eeb4f49a9be9396f21ac8b2263f38ebee6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181856))
- [Fix Style/FormatString offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/7b948e371a1fd5fe9d0596c774c67ed0814064fd) by @JonstonChan ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180293))
- [Copying over the rest of the pipeline variables form code](https://gitlab.com/gitlab-org/gitlab/-/commit/d210d4b52efec681e99a34f717ee0b6e9d4916c9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182455))
- [Add scheduling columns to PEP schedules](https://gitlab.com/gitlab-org/gitlab/-/commit/1fd72554464971cf1e05cf8f4d0b0be8cab24264) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180708)) **GitLab Enterprise Edition**
- [Shorten text when leaving comment as review](https://gitlab.com/gitlab-org/gitlab/-/commit/c85dffde22659b99c05637016af530dbb464ab15) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182885))
- [Adjust texts for exclude license packages](https://gitlab.com/gitlab-org/gitlab/-/commit/92c1ac78928ed40614bc4c60c2a58960c9858d47) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182740)) **GitLab Enterprise Edition**
- [Create new Geo verification state table for SnippetRepository](https://gitlab.com/gitlab-org/gitlab/-/commit/a7e7a8303af57ed28ca095719bfff1190693d30e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181255)) **GitLab Enterprise Edition**
- [Add ids argument for descendant groups](https://gitlab.com/gitlab-org/gitlab/-/commit/f846d2b6a971fca31ed76918aef7e6591eeb46ac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182411))
- [Fetch details of banned and blocked users](https://gitlab.com/gitlab-org/gitlab/-/commit/59540294796a74d28a8e1ec9c8ae46d0ffa1c567) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182218))
- [Abstract pipeline_variables_form to its own component](https://gitlab.com/gitlab-org/gitlab/-/commit/c240c18d7349fbf8622d1a7efe071f7a913f86fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182376))
- [Document Workhorse repository archive cache](https://gitlab.com/gitlab-org/gitlab/-/commit/ce38353bf2ba67f4381632db12df95a0b006fab8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182810))
- [Improve dependency export API usability](https://gitlab.com/gitlab-org/gitlab/-/commit/c1c21fe6bf4c1f811db1b0e3453a69c316032136) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182814)) **GitLab Enterprise Edition**
- [Clean up auto_assign_duo_seat feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/3a71ad12a8c1e888ed710ec55d08106078fd2707) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182638)) **GitLab Enterprise Edition**
- [Change strings to use consistant ellipses](https://gitlab.com/gitlab-org/gitlab/-/commit/aeb6a8a1dc3f4f7dae354b4d0402e7290f305531) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182709))
- [Add zoekt setting to control rollout batch size](https://gitlab.com/gitlab-org/gitlab/-/commit/2fdb68a4bcbdc18879e77f83384dc4ebec3d938b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182581)) **GitLab Enterprise Edition**
- [Added delete oauth connection on Amazon Q disconnect](https://gitlab.com/gitlab-org/gitlab/-/commit/a5c5d0ee36dbbd37e91fd1a8c66353d5eaaf3551) by @protsivd ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182043)) **GitLab Enterprise Edition**
- [Deprecate the `force_to_redownload` field in Types::Geo::RegistryType](https://gitlab.com/gitlab-org/gitlab/-/commit/651735dbe5dcbdbdbef42b0692584e7377c6b898) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182342)) **GitLab Enterprise Edition**
- [Add bulk dismissed event and subscriber](https://gitlab.com/gitlab-org/gitlab/-/commit/64799942060e65f084e8ef420bd046a5394b8abe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181239)) **GitLab Enterprise Edition**
- [Save licenses outside of the spdx catalog as custom licenses](https://gitlab.com/gitlab-org/gitlab/-/commit/fd33f8ca15745c0bb7e144ca5eef502274913e74) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181454)) **GitLab Enterprise Edition**
- [Allow use to select a date range of Runner Usage](https://gitlab.com/gitlab-org/gitlab/-/commit/e6e9b74b758bf8c306c9d54dba7185e23fa77c86) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182095))
- [Allow dashboard panel to reload data with query overrides](https://gitlab.com/gitlab-org/gitlab/-/commit/7e05ab0554047785fae5929c90f0046d28487c00) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181955))
- [Add ai context migration model](https://gitlab.com/gitlab-org/gitlab/-/commit/a4e9b17d25adcadb76b07afff4deb11042f741dc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181238)) **GitLab Enterprise Edition**
- [Delete dropdown item in label list use danger variant](https://gitlab.com/gitlab-org/gitlab/-/commit/104f17a715665f916426eadc0bebb3c24d140673) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182301))
- [Use tertiary explore projects button](https://gitlab.com/gitlab-org/gitlab/-/commit/cc55c1746705eca56bd8e8f111d320a4688aa8f1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182447))
- [Update active context Collections table](https://gitlab.com/gitlab-org/gitlab/-/commit/b02468dab2f8df0e8a08351bd184752b289d6d5b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181923))
- [Update bundler to v2.6.5](https://gitlab.com/gitlab-org/gitlab/-/commit/3e387d7f9a7d8802b371e17dbbf1d8741b698bd8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182381))
- [Extract fromYaml method shared method](https://gitlab.com/gitlab-org/gitlab/-/commit/8dc39af3ac2ca661a978c18823a92a55ddd783ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182288)) **GitLab Enterprise Edition**
- [Change markdown multiline quoting behaviour on already quoted lines](https://gitlab.com/gitlab-org/gitlab/-/commit/d31b9144e6eb513d9ff7dd9038ee4d0f6d1fabb8) by @Bubbis ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178744))
- [Update Pod counters to reflect search filter results on environment page](https://gitlab.com/gitlab-org/gitlab/-/commit/6879ae9e2912f0978fce5e0cfa0c675a07095024) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182283))
- [Remove action approvers from helper](https://gitlab.com/gitlab-org/gitlab/-/commit/c6121a53ee5e95730049ca81831127f70b31e328) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179138)) **GitLab Enterprise Edition**
- [Add UI for pipeline variables minimum role project setting](https://gitlab.com/gitlab-org/gitlab/-/commit/0fc948bdf08c32be1d91ad44229017355105bee4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172304))
- [Clarify tooltip message](https://gitlab.com/gitlab-org/gitlab/-/commit/52e8fec529460437601269b4800c3f34b7388ec6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181635)) **GitLab Enterprise Edition**
- [Avoid writing over the severity override](https://gitlab.com/gitlab-org/gitlab/-/commit/7c488d2191af61f37271003f047c69f8368bc4a4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178804)) **GitLab Enterprise Edition**
- [Improve API error for invalid sub claim component](https://gitlab.com/gitlab-org/gitlab/-/commit/94a7572382c6fa633dad1906d0330acfa404bb70) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182257)) **GitLab Enterprise Edition**
- [Cleanup duo_chat_drop_redis_storage feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/a03300e094fd10129aba3a8cf89c629617084b1b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181908)) **GitLab Enterprise Edition**
- [Log Duo Chat M2000 Error Code](https://gitlab.com/gitlab-org/gitlab/-/commit/f180046f9efe4fd1927cbb91addfd32d69bca031) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181374)) **GitLab Enterprise Edition**
- [Support custom pipcompile lockfile in DS latest template](https://gitlab.com/gitlab-org/gitlab/-/commit/681405f7aee3b098a571904577567445b403bd01) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182159)) **GitLab Enterprise Edition**
- [Change keyFields for ScanExecution type](https://gitlab.com/gitlab-org/gitlab/-/commit/4c3ee50cdbb218ca5c528c06d6f36ebec4b687fc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181964)) **GitLab Enterprise Edition**
- [Remove work_items_alpha flag from Move button](https://gitlab.com/gitlab-org/gitlab/-/commit/0f978d4f7e339e41cb1a5879deecfb17febdb8ac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182203))
- [Add minor UI changes for Severity Override](https://gitlab.com/gitlab-org/gitlab/-/commit/bfc92587714e9657eb40e056a4d3c6a7d6abbbfc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181504)) **GitLab Enterprise Edition**
- [Move Troubleshoot button inside the sticky footer](https://gitlab.com/gitlab-org/gitlab/-/commit/24712bb718b5662492fccf6055dcdeae545246c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182161))
- [Update allow/deny list payload](https://gitlab.com/gitlab-org/gitlab/-/commit/864f1a10c388122cf9216c1e4c665f2a41cfb3b0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181803)) **GitLab Enterprise Edition**
- [Remove the `snoozed_todos_sort_order` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/ac94d0496961302f66f4ac54c68b2cc3b215d627) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181569))
- [Static reachability job process only DS artifacts](https://gitlab.com/gitlab-org/gitlab/-/commit/2e31ea086cfccd5821e4d2cf20b091e999c1e8c3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182146))
- [Add minimum override role to CI/CD settings mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/6b5df91c72490ebf6e3ce8c0d81ed2b273a6b814) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174598))
- [Disable group ascendency validation on Direct Transfer](https://gitlab.com/gitlab-org/gitlab/-/commit/62406aa03a2a89cfbe737a02498172965919d65d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181804))
- [Redesign the action buttons for manual jobs to improve usability](https://gitlab.com/gitlab-org/gitlab/-/commit/8788ba4dd38f3b037f085ba665dca68da3f9e933) by @shakahwath.hussain ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176368))
- [Model registry: Clarify buttons and titles](https://gitlab.com/gitlab-org/gitlab/-/commit/abf269dfe1f4934159d30287d4c68ab2f08c6cdf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181667))
- [Update repository limit notifications](https://gitlab.com/gitlab-org/gitlab/-/commit/d616887c8433614bf46589297bd434844967a201) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180779)) **GitLab Enterprise Edition**
- [Enable `ensure_pipeline_policy_pre_stage_complete` by default](https://gitlab.com/gitlab-org/gitlab/-/commit/96a26299aedbeee75aa91a46d2a31714e4ad4dde) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182081)) **GitLab Enterprise Edition**
- [Disable remove user button for last owners](https://gitlab.com/gitlab-org/gitlab/-/commit/bcc2a5de1434dc14af0666c8d16e277544c4ab7d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181706))
- [Allow Duo Chat to be resizable on self-managed](https://gitlab.com/gitlab-org/gitlab/-/commit/4bc8783dfa525925fb4d02bfa59d4eb5aef8c03b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182008)) **GitLab Enterprise Edition**
- [DB migration to add Milestone widget to Epic work item type](https://gitlab.com/gitlab-org/gitlab/-/commit/6dc651b7964b668bab5bf802bfd2865eac6d0a60) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180857))
- [Add zoekt index watermark level update callback](https://gitlab.com/gitlab-org/gitlab/-/commit/99e74190a8de611665e2bc53305717e09d31dc63) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181056)) **GitLab Enterprise Edition**
- [Remove the `pat_ip` derisk feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/e5e5dc5a1a1df71e08f03eb15a874880f2a063a5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178297))
- [Fix vulnerability autoresolve flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/8f104fb74fe0395c8f0bccdc9fd4fe73418e51c3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181850)) **GitLab Enterprise Edition**
- [Fix: Enhance error handling for expired relation export keys](https://gitlab.com/gitlab-org/gitlab/-/commit/1f33e7ad1000bf370345ef452dcf89a4eb8e9e96) by @guptapratibha26 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180802))
- [Improve error handling when creating new directory](https://gitlab.com/gitlab-org/gitlab/-/commit/3a2dc8755ae5724af24ac3d5c08b137dd9077625) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181766))
- [Add ai active context connection model](https://gitlab.com/gitlab-org/gitlab/-/commit/20ffcf455d6416152dabc185a711c06bb1eb7985) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181400)) **GitLab Enterprise Edition**
- [Change project export download rate limit](https://gitlab.com/gitlab-org/gitlab/-/commit/111898b836da5fb2b11e5ad6d236f61e43d63983) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181822))
- [Update Duo Pro usage button to Purchase seats](https://gitlab.com/gitlab-org/gitlab/-/commit/96223f384f943cec325236044c52c31285530160) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181198))
- [Show badge for multiple licenses and tooltip for unknown licenses](https://gitlab.com/gitlab-org/gitlab/-/commit/bedc31cdda02002aa6b759a0b2f99be0603bcd3f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181109)) **GitLab Enterprise Edition**
- [Add animation to a menu section chevron](https://gitlab.com/gitlab-org/gitlab/-/commit/559870d1035469987698b183812ee2f24b1b5c0c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174872))
- [Make the Troubleshoot button in the Job Log app sticky](https://gitlab.com/gitlab-org/gitlab/-/commit/8ab43ed407e9802f0b8782e48cf81819b9fb2225) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181565))
- [Set new host URL params when initializing Web IDE](https://gitlab.com/gitlab-org/gitlab/-/commit/4b0d2f3d5da8c26e5c0938cbab983e53a029b1bd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180050))
- [Fix Style/FormatString offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/7794ffa690251e1693a8c274dd9e83c56fe160ba) by @JonstonChan ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178810))
- [Readd 422 error context to omniauth error page](https://gitlab.com/gitlab-org/gitlab/-/commit/4e5756c7c67cda1ddfbb9e671584a94a6d4754ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180272))

### Removed (28 changes)

- [Remove all *_tab ff and mark migration as noop](https://gitlab.com/gitlab-org/gitlab/-/commit/6d39c9ed199d759ee0bfeb47edff26ce7a6731f4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184734)) **GitLab Enterprise Edition**
- [Removal of non Claude 3 Model](https://gitlab.com/gitlab-org/gitlab/-/commit/b54d187639389b1d5769f70f6275e0bd4ded1373) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184545)) **GitLab Enterprise Edition**
- [BBM for removing orphaned notes](https://gitlab.com/gitlab-org/gitlab/-/commit/765cbfc79aa7d02c6fc3119cf72fde4d7b713cec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180624))
- [Removed feature flag extended_expiry_webhook_execution_setting](https://gitlab.com/gitlab-org/gitlab/-/commit/969c5b6c9aad0481e0bc08ba98d43c572c90bbc6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184300))
- [Remove note on commit real-time update on MR](https://gitlab.com/gitlab-org/gitlab/-/commit/505145665f4d839c36ef697299217fc67816c6af) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184138))
- [Clean up `blob_repository_vue_header_app` flag](https://gitlab.com/gitlab-org/gitlab/-/commit/ea324a8af683f6f7492beccfa5135a7e0b0b455a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183259))
- [Cleanup Claude 3.5 Haiku feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/8a0c9c47d30b2068b0939a2e6def188a19f934b9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184065)) **GitLab Enterprise Edition**
- [Delete the `zoekt_cache_search_responses` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/daf7dbe21fd620026e52d1a2dcb7f3fa9db58e5d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183217))
- [Remove broken foreign key fk_a2141b1522_p](https://gitlab.com/gitlab-org/gitlab/-/commit/8f2a98491b3f40aaeb4a8dcc48c4a9cdcdc82064) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183638))
- [Remove unused feature flag and partially completed code](https://gitlab.com/gitlab-org/gitlab/-/commit/037bde32ecb4d09c468418843dcfd4bd983b2e20) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182334))
- [Delete increased concurrency indexing ff](https://gitlab.com/gitlab-org/gitlab/-/commit/8b8835c716e3c8f2de08bdb58f218a9f55b3553a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183211))
- [Remove redundant code from new pipeline page](https://gitlab.com/gitlab-org/gitlab/-/commit/cc4d772df7ac3f066367698e2858ecf5c5f25983) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182475))
- [Remove unused feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/c2b836e7496cd44e46ee3fc6a0b681c8e1b89634) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183168))
- [Remove confidence columns from vulnerabilities](https://gitlab.com/gitlab-org/gitlab/-/commit/1b5ca4b70ec67878056c4b6a20d6b9595b1d182e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182637))
- [Delete the `zoekt_reallocation_task` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/06a4e04e0766cc886bb2851880c5caf39850bdbc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182901))
- [Delete the `zoekt_scheduling_worker` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/3e83080edc1d00ce4941bb5e7d99b0fba3f64801) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182854))
- [Delete the `zoekt_replica_state_updates` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/86666f9a3e92547cad804f9fd94b4d87343ca318) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182853))
- [Removing use_typhoeus_elasticsearch_adapter flag](https://gitlab.com/gitlab-org/gitlab/-/commit/de12601a214b480862d82a6551356dfaeae5df40) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182284)) **GitLab Enterprise Edition**
- [Delete the `zoekt_random_force_reindexing` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/4bc693c8b00a5d1b2d2127dd644d12a81e9dd5f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182555))
- [Delete the `zoekt_internal_api_register_nodes` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/5acf245b53f22d6fbf7a2a3a48ffd9ab24621f37) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182552))
- [Drop geo_event_log.repositories_changed_event_id column](https://gitlab.com/gitlab-org/gitlab/-/commit/076e72c9c49b1918944025dc56afdc0628e7e929) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182462))
- [Remove DB table system hooks and NoStiSystemHooks model](https://gitlab.com/gitlab-org/gitlab/-/commit/263172a41bb0e49daeea14c21e6dd0eae92e90c5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182115))
- [Delete the `pipeline_stage_set_last_modified` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/3a76d872b3704e8123980ee574148f7b7f7ff6ea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182100))
- [Remove yaml format feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/f093b1c6795693dd09713f75472b87cfd1ebc8bb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181705)) **GitLab Enterprise Edition**
- [Remove ignored AI application settings columns](https://gitlab.com/gitlab-org/gitlab/-/commit/c223ba9a8a34fa163703c0fa00434f3dc6bf35cc) by @crenz ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179175))
- [Remove fetch-arkose-data-exchange-payload feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/2907cbaac718c92ecc5c4571b7c3766826c39868) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181670))
- [Remove custom_ability_read_admin_users feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/201a335f9b22c643bff7314c8effa2acefa874ad) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181571)) **GitLab Enterprise Edition**
- [Remove pass_add_on_name_for_trial_requests feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/1e2bccd193d6dcf06f863b74c3872f7ea3f08b07) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179725))

### Security (18 changes)

- [Fix ruby-saml gemspec](https://gitlab.com/gitlab-org/gitlab/-/commit/c2c5be905c6c6989373e6c5d098293ee2c5f2811)
- [Mask unencoded userinfo in project mirror errors](https://gitlab.com/gitlab-org/gitlab/-/commit/08ae64432f8ea3a57d4f1f731fed435a34087f76)
- [approval_rules name is unbounded](https://gitlab.com/gitlab-org/gitlab/-/commit/57a03b551b4c1442a17368b0a99a6173fcec387e)
- [Vendor GraphQL gem](https://gitlab.com/gitlab-org/gitlab/-/commit/163192bd96554bfc1e57a87b722a13c936753357)
- [Ruby-SAML updates](https://gitlab.com/gitlab-org/gitlab/-/commit/4d45b6fa090a6d4a879eb04d9e156eaecddd26c0)
- [Limit preview size](https://gitlab.com/gitlab-org/gitlab/-/commit/10b827df7c47db18d805f361d82d78f570eb0898)
- [Prevent custom role to activate group members](https://gitlab.com/gitlab-org/gitlab/-/commit/6ee484f51bf9ca4b554fd996e808d9c0a1082e61)
- [Filter out internal notes if the recipient do not have access](https://gitlab.com/gitlab-org/gitlab/-/commit/1ccf3302c55f26b50772709588d1e37ddfb10438)
- [Maintainer can inject shell code in Google integration configurations that...](https://gitlab.com/gitlab-org/gitlab/-/commit/649d3dea98eb12d185791d022f04c39eb4ff4fd4)
- [Revert "Merge branch 'security-private-artifacts-jobs-api' into 'master'"](https://gitlab.com/gitlab-org/gitlab/-/commit/82064a60dccb41503704b7b103662fa47d9604b0)
- [Bump KAS version](https://gitlab.com/gitlab-org/gitlab/-/commit/f0c1092e0b6b76ac7305e872a706bff2b83bc27a)
- [Use stricter CSP values in the packages dependency proxy](https://gitlab.com/gitlab-org/gitlab/-/commit/1801feb9cee23ee0e40b4118f92b85c0a16ade78)
- [Escape work item dropdown items and restrict HTML tags](https://gitlab.com/gitlab-org/gitlab/-/commit/c8b9fff5b661fc66476d45a96372e7fd5477a000)
- [Fix access to read code review analytics in private projects](https://gitlab.com/gitlab-org/gitlab/-/commit/3e82c62c208678269aee11038662e8b4cbf70c54)
- [Increase minimum role in SPP to read policy yaml](https://gitlab.com/gitlab-org/gitlab/-/commit/8006df30b1661af00c010c7507962c72fcfcc3fa)
- [Check user access for artifacts in Jobs API endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/ae8cd6c91e3e5c4fd2645182e902f4d7d9a059d8)
- [Resolve "Enterprise User with disabled PATs can still use PATs"](https://gitlab.com/gitlab-org/gitlab/-/commit/5567f530d5145142dcbd9eeafaa21ce8356ea5a9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181669)) **GitLab Enterprise Edition**
- [Resolve "Enterprise User with disabled PATs can still create PATs"](https://gitlab.com/gitlab-org/gitlab/-/commit/a5484070e64511211bce9f6076635361938e2b03) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181661)) **GitLab Enterprise Edition**

### Performance (12 changes)

- [Improve User#verified_emails when emails are preloaded](https://gitlab.com/gitlab-org/gitlab/-/commit/21c9c55cba38e58d825ddb75277fe5efffcc191c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184663))
- [Set the patch_id outside of the DB TXN](https://gitlab.com/gitlab-org/gitlab/-/commit/2f4a3e2f5eebe23d6f277de789ffa0cdb5c41a1d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179734))
- [Fix backend filtering in RTE autocomplete](https://gitlab.com/gitlab-org/gitlab/-/commit/c7b0872098ba9a3e3974ba913ed5f86e4df4c7d9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183637))
- [Model: Improve performance of with_version_count scope](https://gitlab.com/gitlab-org/gitlab/-/commit/6a82a69352bc9f2079cc15ebadb200a6145307aa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183031))
- [Update the authentication codeowners yml & script](https://gitlab.com/gitlab-org/gitlab/-/commit/ec85af3ebb68c73de6838e5e6881a67ce53f207e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178264))
- [Improve query performance for all_projects_pages_domains query](https://gitlab.com/gitlab-org/gitlab/-/commit/787589188a8a493cd15631cc21af9333c7663aef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182897)) **GitLab Enterprise Edition**
- [Enable ci_merge_request_variables_preload and remove the FF](https://gitlab.com/gitlab-org/gitlab/-/commit/803f8812bd94e381bc9703a4eaa7da628da6ee8e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182252))
- [Prevent N+1 queries when fetching issue references](https://gitlab.com/gitlab-org/gitlab/-/commit/b8e8954f33d6e2bca470161a17a6574d80034ecb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182233))
- [Optimize build.execute_hooks when creating pipeline](https://gitlab.com/gitlab-org/gitlab/-/commit/3213e2e4bc384cbee052ecadfbeef5faaaed7e17) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182074))
- [Validate p_ci_pipeline_variables#project_id constraint](https://gitlab.com/gitlab-org/gitlab/-/commit/0337ecbd1e3ebaffa46d2a0c8755f0f479e29153) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180066))
- [Deliver reassignment mails later](https://gitlab.com/gitlab-org/gitlab/-/commit/84ed112184b3aa05897472f67f50e26ff9738fc9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181826))
- [Enable bitbucket_import_resumable_worker flag](https://gitlab.com/gitlab-org/gitlab/-/commit/e91cf215414b44559710a9f473526650eda91679) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181647))

### Other (194 changes)

- [Add NOT NULL on ml_candidate_metrics.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/31aefa505b8e64330eb8db7119a7de5e5b90272e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184431))
- [Add NOT NULL on ml_candidate_params.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/3d32c3f1fbae958cdb56c3410fbb61d474f312b7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184432))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/34e391840a30714cc639abac909d9ad79d58f09b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184766))
- [Add and backfill project_id for merge_request_context_commit_diff_files](https://gitlab.com/gitlab-org/gitlab/-/commit/49a59903299a998d3e3aa6fcc8f917516dcfa384) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183935))
- [Add compliance control status transition events and metrics](https://gitlab.com/gitlab-org/gitlab/-/commit/1c3565339b78cff53f7cc40603dedec6f66b078e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183256)) **GitLab Enterprise Edition**
- [Add NOT NULL on ci_build_trace_chunks.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/719454739f9bd4be3b0a5f829cd848aab0c16f9a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183976))
- [Documenting Cells configuration for OmniBus and Helm Charts](https://gitlab.com/gitlab-org/gitlab/-/commit/98830eb3b96587647db39a0a48774e35c302767a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180957))
- [Improve documentation access token API](https://gitlab.com/gitlab-org/gitlab/-/commit/ab0baf261c3861b95ad53e8008ffa57cd08bdfde) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184291))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/1513d44c30d0adefd16f414040b3aeb22df00f90) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183188))
- [Model registry: Simplify table mechanism](https://gitlab.com/gitlab-org/gitlab/-/commit/83de5babd1f2280f6f9cacf7c36ffffb9e26a186) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184031))
- [Add and backfill project_id for packages_nuget_dependency_link_metadata](https://gitlab.com/gitlab-org/gitlab/-/commit/7ae94045c8f36be77c7199028df8a1b1ea53e5ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184610))
- [Add NOT NULL for sharding key on packages_package_files](https://gitlab.com/gitlab-org/gitlab/-/commit/12f461033ac48f9a51c124a2162aeb5327625b6e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184630))
- [Add NOT NULL for sharding key on incident_management_oncall_rotations](https://gitlab.com/gitlab-org/gitlab/-/commit/793d6b8f03b7b8be59f8619a18debdcd78b4cb88) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184622))
- [Sync translations from crowdin (2025-03-14)](https://gitlab.com/gitlab-org/gitlab/-/commit/7e8edbc6510143d8a01eca2c05453283833f4315) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184615))
- [Add sequence to partitioned runner tables](https://gitlab.com/gitlab-org/gitlab/-/commit/3889fe2e32946d647fe721f2dd82aa67fdc5644f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183817))
- [Remove Gitlab::Redis::ClusterSessions post migration](https://gitlab.com/gitlab-org/gitlab/-/commit/dad64361c6b56ec1f4dd3ec2033f74b47ff5d3c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184562))
- [Add NOT NULL on ci_builds_runner_session.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/8ca1bd48a443e69bdb0f7d8e78d5c04df0f22ead) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183977))
- [Add NOT NULL constraint on ci_unit_test_failures.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/24cc5df25fb46d675a38c142efa631dae68453c3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182507))
- [Add NOT NULL constraint on packages_dependency_links.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/41c3220cc4261eac7a1df63cd48ec6f562b5cbe1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182510))
- [Migrate HTTP instance audit event destinations](https://gitlab.com/gitlab-org/gitlab/-/commit/7d19d209c72089be675034093286dd4e6f394163) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184035)) **GitLab Enterprise Edition**
- [Skip saving pipeline config when using inputs](https://gitlab.com/gitlab-org/gitlab/-/commit/e8af953ebc6ddedf3df806694625f5dcf31b447c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184318))
- [Add & backfill sharding keys for snippet_user_mentions](https://gitlab.com/gitlab-org/gitlab/-/commit/114308c19e8ebf0e6d6f97bfcb969701c6172707) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180836))
- [Add & backfill sharding keys for snippet_statistics](https://gitlab.com/gitlab-org/gitlab/-/commit/4f30c94fba6bc2068ce33ad64dd6b90e17ad7bfa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183124))
- [Add & backfill sharding keys for snippet_repositories](https://gitlab.com/gitlab-org/gitlab/-/commit/bbcb0efba3bc4c7b6fa577fa14c6c89721255aef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175410))
- [No-op 20250307080100 migration and retry in 20250307080101](https://gitlab.com/gitlab-org/gitlab/-/commit/f60155196640decafdf40d185c2d4bb7a758cf52) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184439))
- [Add ProjectsWithComplianceFrameworks metric](https://gitlab.com/gitlab-org/gitlab/-/commit/a056fce989d95e9c324c6fdd3a06b172a93bd01a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183422)) **GitLab Enterprise Edition**
- [Add compliance requirement metrics for controls and policies](https://gitlab.com/gitlab-org/gitlab/-/commit/f5dd408a36e4391b554c17382658f4d49131e014) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183382)) **GitLab Enterprise Edition**
- [Sync translations from crowdin (2025-03-13)](https://gitlab.com/gitlab-org/gitlab/-/commit/59d23b74f074baf95a4d64249a788c0674e41919) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184470))
- [Remove Gitlab::Sessions::RedisStore as session store](https://gitlab.com/gitlab-org/gitlab/-/commit/b9c288656b9e40f699462ced6a5225888ec2f087) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181637))
- [Remove update_merge_request_worker_sticky feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/d48f58a5d02537aa44e2fa752c471ae15e10a98a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184411))
- [test: Add missing feature categories for tests related to system access](https://gitlab.com/gitlab-org/gitlab/-/commit/ec53d463bf176db2350a85713bd11e41ea87e4ce) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176700)) **GitLab Enterprise Edition**
- [Sync translations from crowdin (2025-03-12)](https://gitlab.com/gitlab-org/gitlab/-/commit/3fe80a44d1b019acea6600a575d2815522a65548) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184036))
- [Finalize migration BackfillMembersRequestAcceptedAt](https://gitlab.com/gitlab-org/gitlab/-/commit/0187d67271e58fd710180e5faaab1f9fb7531e37) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184105))
- [Add internal event tracking to placeholder reassignment](https://gitlab.com/gitlab-org/gitlab/-/commit/0244f146f8fb5794a545685d391afc86ce68d59a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182679))
- [Enable reassignment throttling feature](https://gitlab.com/gitlab-org/gitlab/-/commit/cf25daf2d4444f1f0a621a48a53a95b99e004991) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184131))
- [Replace ci_runner_machines with partitioned table](https://gitlab.com/gitlab-org/gitlab/-/commit/5680b0559d160a214e72ad23dfb2c38e7a7a4706) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182859))
- [Finalize migration BackfillMilestoneReleasesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/9b0a98b5985cb66cab0ce731115b17a1ab6c3967) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184106))
- [Remove redundant validate in BulkImport::Entity](https://gitlab.com/gitlab-org/gitlab/-/commit/f9e4a8ae23165520a44882e17bdcbe1231ad2441) by @n.h.long.9697 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182760))
- [Improving Cells validation message](https://gitlab.com/gitlab-org/gitlab/-/commit/a7127cc046b94832eb4d835debf800c92e264d91) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184040))
- [Finalize migration BackfillIncidentManagementEscalationRulesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/cff739e1dfd123693cf7d18bb74484ad013b7dfb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183765))
- [Add and backfill project_id for deployment_merge_requests](https://gitlab.com/gitlab-org/gitlab/-/commit/577d1817d5424403700b709fb27d086153ba714f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183738))
- [Add and backfill wiki_page_slugs for namespace_id](https://gitlab.com/gitlab-org/gitlab/-/commit/60acb9075de7b0101bfc4a89f0e0d7accbec26b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183332))
- [Remove Gitlab::Redis::ClusterSessions post migration](https://gitlab.com/gitlab-org/gitlab/-/commit/9d143551abc59e6a0b30d4af42af96c3e876dac5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181631))
- [Finalize BackfillIncMgmtTimelineEventTagLinksProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/61bed0e11899a199c01095e59046834b32260d92) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183908))
- [Finalize migration RerunEpicDatesToWorkItemDatesSourcesSync](https://gitlab.com/gitlab-org/gitlab/-/commit/d55563e12754a5aa85eb18aa8cc6cc871fdb6342) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183282))
- [Remove bulk_create_scan_result_policies Feature Flag](https://gitlab.com/gitlab-org/gitlab/-/commit/6558e1637d19ab0bdee0b5c494e9acb56c37fb6a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183509)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/60445f0f5ef1c52460e85dec9257113edd26badd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183923))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/f9e0c3fe1aa6e74eebbb473ab2cad86509065583) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/184119))
- [Populate redirect_routes.namespace_id on save](https://gitlab.com/gitlab-org/gitlab/-/commit/b258d82c870660dbd251af5a5e7fc6e29eef722a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183974))
- [Add FK constraint and index on merge_request_user_mentions.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/21634826da4ff0ee4d3400ae6a519d5480257694) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183971))
- [Fix merged MRs that reverted to "closed" state](https://gitlab.com/gitlab-org/gitlab/-/commit/ea4ef3c3809ae45a71be0b8fd97f46b3ae0b789a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181021))
- [Remove existing users from onboarding if they have group saml](https://gitlab.com/gitlab-org/gitlab/-/commit/81605ddb9c114dba8a6030fa728cf06b6b0f8575) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183559))
- [Fix Style/SendWithLiteralMethodName offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/7a47fc425ded8d3f51274b0ff069710655b2e0ca) by @albertoroldanq ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179585)) **GitLab Enterprise Edition**
- [Remove the `mr_approvers_filter_hidden_users` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/275476b7757ed7665b6b5f8293773eb1d3142327) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183058))
- [Add and backfill project_id for approval_merge_request_rules_approved_ap](https://gitlab.com/gitlab-org/gitlab/-/commit/880a4f383dafaf9bf80088aa005e133f17657a5c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183352))
- [Replace ci_runners with partitioned table](https://gitlab.com/gitlab-org/gitlab/-/commit/21cbc3beac1b4c58eb47a0b2c2a791100f3ec124) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183508))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/8abda5c1de7f6556f0dd4c23a856a339fcea8f3c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183628))
- [Add and backfill project_id for approval_merge_request_rules_users](https://gitlab.com/gitlab-org/gitlab/-/commit/f683b5501f484b294bc22fc8acb4d397312bbc48) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183354))
- [refactor: Add oauth_login_counter before request phase middleware](https://gitlab.com/gitlab-org/gitlab/-/commit/9788d7d1f3502027cf474f697859ce1a38f774a9) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177720))
- [Finalize migration BackfillCiSecureFileStatesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/0f0499f55fb0dd86819daf179cc65ca5586f137e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181727))
- [Finalize migration BackfillIncidentManagementOncallRotationsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/9d8a6e53c97108433caf92fcdd93ad2427f2e8a9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183766))
- [Finalize migration BackfillDastSiteProfilesBuildsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/49960c402969bd5aa2d56778e7d4ef11711631fe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183452))
- [Finalize migration to backfill namespace_id in policy rule schedules](https://gitlab.com/gitlab-org/gitlab/-/commit/ccaffa6a8e7908f3ee13541b513acaf247a99961) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183280))
- [Finalize BackfillApprovalProjectRulesProtectedBranchesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/23b71c4faf18a88099a60620d1285c0b61876e91) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183451))
- [Add CountFrameworksWithRequirementsMetric](https://gitlab.com/gitlab-org/gitlab/-/commit/bbb8bb5eaac6575034ba865fbca77f0be0c5347c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183414)) **GitLab Enterprise Edition**
- [Add and backfill project_id for packages_debian_project_component_files](https://gitlab.com/gitlab-org/gitlab/-/commit/773bf078489ae099410dbe3e929bf2793a007746) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183806))
- [Rename remote development namespace cluster agent mapping table](https://gitlab.com/gitlab-org/gitlab/-/commit/b6c3b59f2a95317f93df1db680fbf065abeadb30) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181926)) **GitLab Enterprise Edition**
- [Add NOT NULL constraint on packages_debian_project_components.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/67e6453223fb1a1b6fbe9650c0ec05e54babb696) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182509))
- [Cleans up authentication_logs_migration_for_allowlist feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/5664ef2019c354fb2eaf15d9c3ff211258de39a4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183773))
- [Create ClickHouse table to store group traversal namespaces paths](https://gitlab.com/gitlab-org/gitlab/-/commit/93eeeb09c78e953d3587f4577d2c6ada4d4caaf2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182164))
- [Add namespace_id column to redirect_routes](https://gitlab.com/gitlab-org/gitlab/-/commit/133f4815bcfd064c3d4ed34164d18b66744c2d15) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183002))
- [Add performance bar to GraphQL explorer](https://gitlab.com/gitlab-org/gitlab/-/commit/57190ec595dcf60febe30b83deb8685c430adcae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171948))
- [Validate not null constraint on projects.project_namespace_id column](https://gitlab.com/gitlab-org/gitlab/-/commit/595684382c459d18bccd0f3444fd53a2065f4412) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183649))
- [Refactor Cells configuration](https://gitlab.com/gitlab-org/gitlab/-/commit/1dd42ed25234e1be37273ad4399d5db4501bfda3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181708))
- [Add and backfill namespace_id for incident_management_pending_issue_esca](https://gitlab.com/gitlab-org/gitlab/-/commit/d7b8feaf1b544a8a342c9937189f74fbd7ddd4ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183047))
- [Remove shared_namespace_locks feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/79b86d8e467ac2a7292a7e0b484d1c76003f5abd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183624))
- [Use occurrence id to fetch dependency graph](https://gitlab.com/gitlab-org/gitlab/-/commit/4b42d50e7ad8b20fd974042949aabbca0797477b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183625)) **GitLab Enterprise Edition**
- [Finalize migration BackfillCiBuildTraceMetadataProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/2673238b6d419b4eba095409874c325011b4b23e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182192))
- [Backfill onboarding_status_setup_for_company from user_preferences](https://gitlab.com/gitlab-org/gitlab/-/commit/b071a20a528b307bc84905604c3de6e46029a99d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180602))
- [Add approval_policy_rule_id to scan_result_policies](https://gitlab.com/gitlab-org/gitlab/-/commit/a79788d08fdc1f319da981a4dbf8a016044c2476) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182418)) **GitLab Enterprise Edition**
- [Remove broken FK between builds and pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/214d2295825675a79262f5c7e6aa42daa31d54ae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174115))
- [Move Import file removal to a cron job](https://gitlab.com/gitlab-org/gitlab/-/commit/1d6c03f0b2047a6bb9f69035f68028911c549063) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182101))
- [Remove ci_runner_manager_runtime_features feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/2b5b8d8b5aa36ce8ae32381d5bca5afc5bb3db8e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183500))
- [Finalize BackfillSecurityOrchestrationPolicyRuleSchedulesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/77d6f49595b87fcaf6534c741e1b04f735d80f84) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183281))
- [Finalize Batched Background Migration](https://gitlab.com/gitlab-org/gitlab/-/commit/63460747ade74fac657a198f1ba118644daa6649) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182653))
- [Remove groups/discovers_helper.rb](https://gitlab.com/gitlab-org/gitlab/-/commit/0a893e67ca9a85f2dac582e86e16732ab2467e99) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182779)) **GitLab Enterprise Edition**
- [Reindex work items to index notes data](https://gitlab.com/gitlab-org/gitlab/-/commit/c2cb179046c0fc700b9bd4e2d27fcd8824bb7ca2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182950)) **GitLab Enterprise Edition**
- [Replace ci_runners with partitioned table](https://gitlab.com/gitlab-org/gitlab/-/commit/93cf156a339a7e14815600a92d1329430842eb55) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182549))
- [Add and ensure presence of resource_mileston_events.namespace_id](https://gitlab.com/gitlab-org/gitlab/-/commit/f7a9511c8e3455e0b9c7219718d440f24ca5b82a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181868))
- [Add ability to manage experimental features for security policies](https://gitlab.com/gitlab-org/gitlab/-/commit/5b2f637b31e942f79731e5d5042265fa5d17bd0b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182484))
- [Add index on approvals.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/b1edb2fc3ba2a3d7a1ac4f1b4b572a941fb1876e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182066))
- [Add NOT NULL on ci_pipeline_schedule_variables.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/63c118d28f7d0c4653365219ed1ca1f175253121) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182681))
- [Add and backfill project_id for push_event_payloads](https://gitlab.com/gitlab-org/gitlab/-/commit/f03f3991fa283cdc1216032c028a2e9651503d46) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183123))
- [Finalize protected_environment_deploy_access_levels backfill](https://gitlab.com/gitlab-org/gitlab/-/commit/2d5e8328b7b7071b1781091af90d5e4bf6db9bda) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183279))
- [Validate NOT NULL on approval_merge_request_rules sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/6e98f72a64120a0700df81b63bd8c3e569e19133) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180907))
- [Add and backfill project_id for scan_result_policies](https://gitlab.com/gitlab-org/gitlab/-/commit/ecc5b7abfd71962f8e6d2ee4ea04d6714dda4f48) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183125))
- [Minor improvements to the performance bar](https://gitlab.com/gitlab-org/gitlab/-/commit/a45c755ba147f735a076ec0e780ce5406bfefeb2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181397))
- [Finalize migration BackfillProtectedTagCreateAccessLevelsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/e7824f9ab214f3c7e6f840bceffc4bd83bb5eccd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181208))
- [Remove dead code around recaptcha_on_top_level_group_creation feature](https://gitlab.com/gitlab-org/gitlab/-/commit/64a32f0674c13f333c5cea96b1bb796efca850b1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183174))
- [Finalize migration BackfillMlCandidateParamsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/f52900d7b38399494433fc148be672d576d1de1e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183109))
- [Finalize migration MakeSecurityPolicyBotsPrivate](https://gitlab.com/gitlab-org/gitlab/-/commit/1d8014071f93ee3b942952b72dd7085d31f44f08) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182962))
- [Finalize protected_environment_deploy_access_levels backfill](https://gitlab.com/gitlab-org/gitlab/-/commit/0242462664281a7470b6bd66e24aff5fbce9a6ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183110))
- [Move Import file removal to a cron job](https://gitlab.com/gitlab-org/gitlab/-/commit/e4a7ff58142e84458a3f18e838de333c2ab9891c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181784))
- [Finalize migration BackfillReservedStorageBytes](https://gitlab.com/gitlab-org/gitlab/-/commit/446f6068b41b0bc819f2a392931bec463912622c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182189))
- [Store project namespace traversal paths on ClickHouse](https://gitlab.com/gitlab-org/gitlab/-/commit/cfd2482073576de3332749d8effac5085491b59e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183053))
- [Introduce `Vulnerabilities::ArchiveExport` model](https://gitlab.com/gitlab-org/gitlab/-/commit/fa145e30591667582b14f1d1b32776aeaa89a3ac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182290))
- [Reindex Elasticsearch merge request to update integer with long type](https://gitlab.com/gitlab-org/gitlab/-/commit/28c969e902362b492225b6f4dde9519febfbc10e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182255)) **GitLab Enterprise Edition**
- [Reindex Elasticsearch user index to update integer with long type](https://gitlab.com/gitlab-org/gitlab/-/commit/94eee10017dd8e418eb5c55eb393c481c570ead7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182733)) **GitLab Enterprise Edition**
- [Reindex Elasticsearch note index to update integer with long type](https://gitlab.com/gitlab-org/gitlab/-/commit/f1d971c86bbf29b1570f9053912495739cd01e53) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182727)) **GitLab Enterprise Edition**
- [Finalize "generate commit message" migration to AI Gateway](https://gitlab.com/gitlab-org/gitlab/-/commit/a70658e227b2cca454cb26a1814d96bef4261414) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182969))
- [Finalize migration BackfillCiBuildsRunnerSessionProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/0b08c2dec0ebf6b469870b8991c0c50e73942d7a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181723))
- [Finalize migration BackfillMlCandidateMetricsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/f4c506f3a2dfb67fc8c07662cb3bcd3fc4a69e2d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182963))
- [Finalize migration BackfillVulnerabilityOccurrenceIdentifiersProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/43ace000ca708a9a960ae988e141efe4e1fd7efd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182654))
- [fix(rubocop): Fix Performance/MapCompact offenses in app/models/ci](https://gitlab.com/gitlab-org/gitlab/-/commit/6d9cae74b9ed8e5624a7337140790548c246196f) by @thelooter ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182956))
- [Remove kubernetes_agent_protected_branches feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/2280141eebab910158a344951cda78586086c6e2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182895))
- [Remove feature flag pat_organization_filter](https://gitlab.com/gitlab-org/gitlab/-/commit/f42e8601404015866abc046fa007213c0c65965d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182700))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/ae18647f643704cf2f6499f419657cd04c8e96e9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182673))
- [Finalize migration BackfillEpicIssuesNamespaceId](https://gitlab.com/gitlab-org/gitlab/-/commit/2a1fbf479b636c5120a0dd5da996be85f3c6553d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181719))
- [Finalize migration FixNamespaceIdForWorkItemParentLinks](https://gitlab.com/gitlab-org/gitlab/-/commit/709b7692ef46039fcb7b070452e379b306fea145) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182656))
- [Fix any bad sharding_key_id values on project runners](https://gitlab.com/gitlab-org/gitlab/-/commit/b612a0ad4c82d5cea8c3150ff0e905b766dba52f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182527))
- [Update work_item_type_custom_fields FK](https://gitlab.com/gitlab-org/gitlab/-/commit/c0e5b9b6a88fe42dd340bf52f58f0aecff705618) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182051))
- [Fix Style/SymbolProc offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/9b31b6baeaaf314685c4db110d1fab87137d102d) by @barton.tomas ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181311))
- [Introduce data retention guidelines](https://gitlab.com/gitlab-org/gitlab/-/commit/23b9659db568b77e904904c2867678adbc485c97) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178455))
- [Add NOT NULL on vulnerability_state_transitions.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/1342a12bf73ab1563caf9a50032445531dffcc46) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182698))
- [Finalize migration BackfillErrorTrackingErrorEventsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/5f59c6f57262511849ebe59ddf2c59d18ac8f383) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181720))
- [Save runner runtime features to runner manager](https://gitlab.com/gitlab-org/gitlab/-/commit/e6e0813759ff8742c2588d177b88234227643506) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181817))
- [Validate NOT NULL constraint on packages_build_infos.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/bef629ebe02c776886e60bc68c86e0c4945df568) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182526))
- [Validate NOT NULL constraint on merge_request_reviewers.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/37ccc8b5902a7eb24ab73f3f2566b93d1c1d4c16) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182524))
- [Add NOT NULL constraint on evidences.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/00b2cc0f4e3c24ba40dc42fb72ebd63424445982) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182508))
- [Add NOT NULL constraint on packages_maven_metadata.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/34ba8b3e62d8edbcd68e2feebef08835f2ba47b8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182511))
- [Add and backfill namespace_id for issue_assignees](https://gitlab.com/gitlab-org/gitlab/-/commit/ef77f05e872bed20da94544321182e10886f0f0c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174106))
- [Finalize migration BackfillCiPipelineScheduleVariablesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/a42d96684acb006b4a063db76787b079ba3baab6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181725))
- [Remove correct_work_item_type_id from work item index](https://gitlab.com/gitlab-org/gitlab/-/commit/0a4d85e57d8a517352dc310766612f65d93e98d9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182551)) **GitLab Enterprise Edition**
- [Replace client lib with pure HTTP implementation](https://gitlab.com/gitlab-org/gitlab/-/commit/e5bbaf93c43c83fafcda8c33f5ef36de46ff1759) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182567))
- [Add new Elastic commit indexer worker](https://gitlab.com/gitlab-org/gitlab/-/commit/7e93d41685abe15dee084588f2a0116e845a0c98) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182114)) **GitLab Enterprise Edition**
- [Enable virtual_registry_maven_cleanup_new_worker_class by default](https://gitlab.com/gitlab-org/gitlab/-/commit/2bd137bcf385496fcecbda4eb5ca13192eab70ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182560))
- [Remove security widget findings FF](https://gitlab.com/gitlab-org/gitlab/-/commit/951b74877df8075bfb226d25fa6c59ddf331c9ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182541)) **GitLab Enterprise Edition**
- [Remove show_diff_if_head_sha_commit_is_missing flag](https://gitlab.com/gitlab-org/gitlab/-/commit/18512914ed74fce2ba2e2ec80a6117a2a4f0577b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182473))
- [Creates event trigger to alter range of new sequences](https://gitlab.com/gitlab-org/gitlab/-/commit/e51a48ba87ecbc70d2c65976e320773f78445045) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181115))
- [Add the new state deleted in Zoekt::Repository model](https://gitlab.com/gitlab-org/gitlab/-/commit/130f7b5e27c367a177c3e396e2c2bee1cc05557e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182402)) **GitLab Enterprise Edition**
- [Remove `global_file_size_check` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/fa8667b80dda3cb3ed44e755350f4ab041124783) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173546))
- [Remove reference to taggings table in deduplicate_tags rake task](https://gitlab.com/gitlab-org/gitlab/-/commit/9f0c508f50e4a1aef2f138bb54598f54e4d6b72f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182412))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/11ae1fa569bcd1fb28067bf7783c65395fe4e789) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182408))
- [Cleanup security_policy_custom_roles feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/4a482bbc33a50ab16f01cb97fadc4fce861b533d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181530)) **GitLab Enterprise Edition**
- [Finalize migration BackfillMergeRequestUserMentionsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/7d9d3d2c63248e538d7b61887018f1d4a5964882) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181880))
- [Validate NOT NULL on merge_request_blocks sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/917a705a30218442626274a9a6357a5dadf3ca52) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180913))
- [Remove feature flag `policies_always_override_project_ci`](https://gitlab.com/gitlab-org/gitlab/-/commit/e257a9ab9abbfb4c2d8063cb157a83f57083ae9e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182001)) **GitLab Enterprise Edition**
- [Finalize Batched Background Migration](https://gitlab.com/gitlab-org/gitlab/-/commit/44b224d018493b6edb7709829996f7fff6c34f97) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182188))
- [Finalize migration BackfillEvidencesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/f7e005bbb6dae8a5a54952afa898255b5e1f8902) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181721))
- [Finalize migration BackfillCiBuildTraceChunksProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/4ebba95792c93a88c2e4a8272b3ed8e3595dd0e5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182191))
- [Finalize migration BackfillCiBuildPendingStatesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/a078e50c90c13218f744954c02347f9efa9477cb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182190))
- [Add tables/model for targeted messages](https://gitlab.com/gitlab-org/gitlab/-/commit/65a84e0299508cb21ae7b6e3005fbfadd92809d8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179303))
- [Remove ai_commit_reader_for_chat flag](https://gitlab.com/gitlab-org/gitlab/-/commit/cb549de5bdda28c27cf091ee46e5671cf6c7c053) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181555)) **GitLab Enterprise Edition**
- [Add and backfill group_id for packages_debian_group_component_files](https://gitlab.com/gitlab-org/gitlab/-/commit/8831e8e773a144d62789c57b2214119aec2fed2c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182117))
- [Add and backfill project_id for project_relation_export_uploads](https://gitlab.com/gitlab-org/gitlab/-/commit/c5d70a305c577138d6d56302d60efc475a1c9ebe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182116))
- [Add NOT NULL constraint on packages_debian_group_components.group_id](https://gitlab.com/gitlab-org/gitlab/-/commit/41410bb73a81cd0eeac8015352e418174cd47247) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181064))
- [Release vulnerability report identifier filter for group level](https://gitlab.com/gitlab-org/gitlab/-/commit/022bbec4123ec5d75d52e6887c16c0e7b92078d4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182084)) **GitLab Enterprise Edition**
- [Finalize migration FixSyncedEpicWorkItemParentLinks](https://gitlab.com/gitlab-org/gitlab/-/commit/ee62a87c75df8be99e1d0c39faccf55b3c7aae4c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181330))
- [Validate NOT NULL on project_relation_exports sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/83472208a7c3e9cead4fe9ad3bd3c7dcfe83130e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180914))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/65082c9a54186e0a4e93a9385c27bd14d5493221) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182057))
- [Validate NOT NULL on draft_notes sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/96c9c3d3b0804a90b8ac55aad7e6275f03d8491f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180909))
- [Finalize migration AlterWebhookDeletedAuditEvent](https://gitlab.com/gitlab-org/gitlab/-/commit/6adbc44d84adb7c1674107904bac2ce700fc524c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181480))
- [Finalize migration BackfillCiResourcesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/8dbde447f2810fc89d81bee928b15cead1e0d179) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181726))
- [Refactor approvals widget](https://gitlab.com/gitlab-org/gitlab/-/commit/f684e7be723f58344ff96249e5895083f5fb9d87) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178957)) **GitLab Enterprise Edition**
- [Remove Elasticsearch settings from application settings](https://gitlab.com/gitlab-org/gitlab/-/commit/95418b5ea732f2a6231ea2247ba91cbd00b0d24e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181660))
- [Remove unused ClickHouse table ci_failed_pipelines_counts_by_namespace](https://gitlab.com/gitlab-org/gitlab/-/commit/1d308570d9f40b634931244284b5ed2afa6b0b9f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/182019))
- [Validate NOT NULL on status_check_responses sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/9ea39e80542b6b24e37beab0d116d2353013eb31) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180701))
- [Validate NOT NULL on vulnerability_finding_links sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/80472e5665b50192db1c2dd89142c959d3a35e40) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180689))
- [Finalize migration NullifyBuildsAutoCanceledById](https://gitlab.com/gitlab-org/gitlab/-/commit/e9e3a23bd6de3670ec2f89147a28d72c618301f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181732))
- [Finalize migration BackfillCiTriggerRequestsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/775a69f8fb60e26f6c223c2c29eaad35cafd25b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181729))
- [Finalize migration DeleteOrphanedPipelineVariableRecords](https://gitlab.com/gitlab-org/gitlab/-/commit/eb8c59eb0aca189f4c9ba30dca3804b2e2ea8769) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181730))
- [Finalize migration BackfillCiBuildNeedsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/ff678d0f38fe270d298d3e45ccf5250a947d68cf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181722))
- [Reindex work items for type id alignment](https://gitlab.com/gitlab-org/gitlab/-/commit/5df7fbe7e36914f295983efabc7e42afd5ce7c63) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181790)) **GitLab Enterprise Edition**
- [Finalize migration BackfillCiUnitTestFailuresProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/928f7d0dfeeb581c6488838fedb5c34986ca10c5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181728))
- [Finalize migration BackfillPackagesPackageFilesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/11ed1d8ac4ebe9ed6550e1277bebc25f57365a2a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181882))
- [Finalize migration BackfillVulnerabilityStateTransitionsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/e578dec947e6092be8e3b8bfd2a2c8ddc885ac51) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181203))
- [Remove ElasticIndexingControlWorker job instances](https://gitlab.com/gitlab-org/gitlab/-/commit/e48ffffd972ca76c738cb7beb938c2ea8e34ab60) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181668))
- [Change routes.namespace_id from LFK to regular foreign key](https://gitlab.com/gitlab-org/gitlab/-/commit/9a75bbf1cdd6eea1532e8deda641db683b59e531) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181772))
- [Finalize migration BackfillVulnerabilityExternalIssueLinksProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/84e34ecdf8fb4b7e174b59390dfdb5deae5ad338) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181209))
- [Remove concurrency_limit_process_commit_worker feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/0d19797675118823b66844c18a8939fbb8b3b39e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181758))
- [Add NOT NULL constraint on merge_request_reviewers.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/b8045ea96420397aeccc721315a9b74d7a0dea9f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181081))
- [Use the pipeline creation meta data rather than project.ci?](https://gitlab.com/gitlab-org/gitlab/-/commit/a5cb7724df7dfb75862c248b314d269626c1b2e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181745))
- [Validate NOT NULL on merge_request_assignees sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/a517000bab7e91b063f7edd37609af4e17500d6a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180912))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/0244921f55a133eb8dd57e17c212edb6e62cc2e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181491))
- [Update maven virtual registry cache entries table](https://gitlab.com/gitlab-org/gitlab/-/commit/fae2f9df5189040d8790d7c98c37c1dd21828d04) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181707))
- [Re-enqueue LimitNamespaceVisibilityByOrganizationVisibility migration](https://gitlab.com/gitlab-org/gitlab/-/commit/4f536c2bd45495263e6f5706117245307f58e148) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181640))
- [Add NOT NULL constraint on merge_requests_closing_issues.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/b61c2e1c39dec7a91d43f7ef2a12fdc769fee767) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181082))
- [Finalize migration BackfillPackagesMavenMetadataProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/d27b6ead984e72424569109176e998a5c7bdce5f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181207))
- [Add NOT NULL constraint on vulnerability_merge_request_links.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/ef7913273b9a45cce654fbadb46e06524c59550a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181080))
- [Add NOT NULL constraint on vulnerability_issue_links.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/c34add13294a3d6f1e22c9747685cb712da9b1c8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181079))
- [Validate NOT NULL on epic_user_mentions sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/661448171c0c5f2ac9dd8984f406db19d7169ba1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180910))
- [Validate NOT NULL on issue_links sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/88d10656deca31b2af41b3fcb20f5c56aa88af7e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180911))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/998d8028213da6bf0c3c1c08301797c8b3395c28) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180234))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/8ae69a3765cfb7561db95e43faa30cc60fac6444) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177662))

## 17.9.8 (2025-05-07)

### Fixed (2 changes)

- [Bump devfile gem to v0.4.3](https://gitlab.com/gitlab-org/security/gitlab/-/commit/4586145dda8558f5af93e24aaeeb7810dd8d4986)
- [Only check records with encrypted data in gitlab:doctor:encryption_keys](https://gitlab.com/gitlab-org/security/gitlab/-/commit/8ea60ee95fa9603bbfab42374ce4be932f80c571)

### Security (3 changes)

- [Improve Octokit::ResponseValidation middleware and add rate limits](https://gitlab.com/gitlab-org/security/gitlab/-/commit/dbf91625730119709829caf0de36a1a0a85e1cca) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4937))
- [Remove id attribute from OAuth form](https://gitlab.com/gitlab-org/security/gitlab/-/commit/c62d3390b16495e22db7aca5ea2464d5b3c2df24) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4950))
- [Use IssuePolicy for #issues_readable_by_user](https://gitlab.com/gitlab-org/security/gitlab/-/commit/03bdcca386dda566770614d21b099e2819b86b53) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4957))

## 17.9.7 (2025-04-22)

### Security (4 changes)

- [Add SecureHeaders middleware with the Nel header](https://gitlab.com/gitlab-org/security/gitlab/-/commit/5e9112ba2d6fac340e1dbfc4b0330bdcff2f82bc) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4920))
- [Restrict forwarded headers in Maven dependency proxy](https://gitlab.com/gitlab-org/security/gitlab/-/commit/24d73f3e778471c4e0153af174f2d8b44e106108) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4931))
- [Security unauthorized access to reading branch names](https://gitlab.com/gitlab-org/security/gitlab/-/commit/cb09987371857b97ec3cc5774b9f214c9db7c8a6) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4923))
- [Simplify detecting paragraphs for quick actions](https://gitlab.com/gitlab-org/security/gitlab/-/commit/29d3f746b02137aaff4364473ce62f701d208e27) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4927))

### Other (2 changes)

- [Clean up BackfillCiRunnerMachinesPartitionedTable migration](https://gitlab.com/gitlab-org/security/gitlab/-/commit/76d351431e07b3a695356c7b78ac16d23b180302)
- [No-op FinalizeBackfillCiRunnerMachinesPartitionedTable migration](https://gitlab.com/gitlab-org/security/gitlab/-/commit/fb16e2ebcc6188b3f9bb0bc30e7e2b709484f3b1)

## 17.9.6 (2025-04-09)

### Security (6 changes)

- [Bump workhorse golang-jwt/jwt to 5.2.2](https://gitlab.com/gitlab-org/security/gitlab/-/commit/ac61772efb740af0684755d1db7d057f412b218e) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4913))
- [Global search count leak for confidential issues](https://gitlab.com/gitlab-org/security/gitlab/-/commit/46932e9f78e0b138b8fd7320b2e4e4c09f2fcfc0) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4908))
- [Set the IP address state for Action Cable requests](https://gitlab.com/gitlab-org/security/gitlab/-/commit/7019ae8aa04f49f66d7db86ec4023f816f8e90f1) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4905))
- [Adding validation for Ci::Pipeline](https://gitlab.com/gitlab-org/security/gitlab/-/commit/33961db6cab6ac4d3cc99d4ad521f160b43aafe2) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4885))
- [Add delay to when pointer events are enabled for 0Auth authorize page](https://gitlab.com/gitlab-org/security/gitlab/-/commit/b154f7884178a622da6d60fdcbd1097ce50cc6cb) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4852))
- [Do not enable pprof by default in Workhorse](https://gitlab.com/gitlab-org/security/gitlab/-/commit/94aba826029e01791e394456aa9dd6a5db497415) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4890))

## 17.9.5 (2025-04-02)

No changes.

## 17.9.4 (2025-04-01)

### Fixed (1 change)

- [Ensure runner taggings are copied from taggings](https://gitlab.com/gitlab-org/gitlab/-/commit/40aa3c8333f19f65f7a74526d61c228e2525f3c0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186278))

### Other (1 change)

- [No-op ci_runner_machines_687967fa8a table backfill migration](https://gitlab.com/gitlab-org/gitlab/-/commit/9339d0b92dae455ad74d27cde67bc897b153eaf8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185303))

## 17.9.3 (2025-03-26)

### Fixed (2 changes)

- [Reorder runners backfill migrations](https://gitlab.com/gitlab-org/security/gitlab/-/commit/75f2ae1a6f0716fe70a8ab48fa300e7448fc02aa)
- [Update dependency gitlab-mail_room to v0.0.27](https://gitlab.com/gitlab-org/security/gitlab/-/commit/153fab2966eb8b9266bfe6625fbebee936b1ce50)

### Security (7 changes)

- [Sync organization user access when admin status changes](https://gitlab.com/gitlab-org/security/gitlab/-/commit/21b924368fccad62c8329c243e086f5fcfa824aa) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4847))
- [Prevent XSS via merge error on the merge request page](https://gitlab.com/gitlab-org/security/gitlab/-/commit/2574af89065d099ec8148f8ac22a02739fa27f2a) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4880))
- [Inherit current_user external status while rotating project/group token](https://gitlab.com/gitlab-org/security/gitlab/-/commit/254f27669b281314fef74c3830b4a812f64708d4) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4866))
- [Add validations for the project_name of Harbor integration](https://gitlab.com/gitlab-org/security/gitlab/-/commit/eefe5150b0b9681a564757197c8ce2668088e32b) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4857))
- [Sanitize returned input on asciidoc Timeout](https://gitlab.com/gitlab-org/security/gitlab/-/commit/6041ddbe1808506e5194ef89190f3e44c47badd1) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4842))
- [Add CI/CD project setting `allow_composite_identities_to_run_pipelines`](https://gitlab.com/gitlab-org/security/gitlab/-/commit/4922213de1af01d53c68ecca81524c472fa7fa06) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4875))
- [Add limit to resource counts in tfplan merge request report](https://gitlab.com/gitlab-org/security/gitlab/-/commit/bfec8bb2981359dca26092f8ee79abe569465f4a) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4871))

## 17.9.2 (2025-03-11)

### Fixed (3 changes)

- [Fix the pipe search for zoekt exact search mode](https://gitlab.com/gitlab-org/security/gitlab/-/commit/22030051963d488575df6a2cca19e1d4e0d82a2d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/183373))
- [Prevent deletion of project_bot users with non-expiring access tokens](https://gitlab.com/gitlab-org/security/gitlab/-/commit/0249d460f0f6b7f867e7a4171e0effae2e4e5135)
- [Use correct project when fetching managed resources templates](https://gitlab.com/gitlab-org/security/gitlab/-/commit/9bac9ffcd01abff2bf0d4d38829655e394dea3b3)

### Security (8 changes)

- [Vendor GraphQL gem](https://gitlab.com/gitlab-org/security/gitlab/-/commit/e78a52dcafa4c7316e01d4dcd35a33ab9623f532) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4841))
- [Ruby-SAML updates](https://gitlab.com/gitlab-org/security/gitlab/-/commit/780f136abbf4b27c18485e5c173aaa18acfcb644) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4828))
- [Prevent custom role to activate group members](https://gitlab.com/gitlab-org/security/gitlab/-/commit/efbd1afae3cce6bb4e03e91ed82b7af27671977f) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4833))
- [approval_rules name is unbounded](https://gitlab.com/gitlab-org/security/gitlab/-/commit/9a4e857ea3223fe56536a81f3d1fdadb833eca8d) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4838))
- [Limit preview size](https://gitlab.com/gitlab-org/security/gitlab/-/commit/b2ce61725c9946766a2a964377fc756d87e8234e) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4821))
- [Maintainer can inject shell code in Google integration configurations that...](https://gitlab.com/gitlab-org/security/gitlab/-/commit/7fd30226d79520b742abd9edc01055766f56c39b) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4824))
- [Filter out internal notes if the recipient do not have access](https://gitlab.com/gitlab-org/security/gitlab/-/commit/a55e5b359912daa90ef07c73ebd66b4bb9b0e2c3) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4815))
- [Mask unencoded userinfo in project mirror errors](https://gitlab.com/gitlab-org/security/gitlab/-/commit/af6f445b66c3353652c47ad36b1c700c2c0572a1) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4789))

## 17.9.1 (2025-02-26)

### Fixed (1 change)

- [Fix instance level dashboard by default severity override](https://gitlab.com/gitlab-org/security/gitlab/-/commit/56d2f940bb6e87b34e4f26ba9a298f28360dd23a) **GitLab Enterprise Edition**

### Security (4 changes)

- [Increase minimum role in SPP to read policy yaml](https://gitlab.com/gitlab-org/security/gitlab/-/commit/593c0a6f70564e9570fb16b25a37298eacf6c644) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4718))
- [Fix access to read code review analytics in private projects](https://gitlab.com/gitlab-org/security/gitlab/-/commit/0faa526c76e3c523ff6486057c5b5b07e8e4e5d9) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4794))
- [Escape work item dropdown items and restrict HTML tags](https://gitlab.com/gitlab-org/security/gitlab/-/commit/fc777a98ebd45b30ab95bc0d94a418479d15f09c) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4788))
- [Use stricter CSP values in the packages dependency proxy](https://gitlab.com/gitlab-org/security/gitlab/-/commit/922d3ad17cf7493a10f8dbf90c0cae8d9d4b063d) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4787))

## 17.9.0 (2025-02-19)

### Added (202 changes)

- [Add GraphQL API for visualizing dedicated hosted runner compute usage](https://gitlab.com/gitlab-org/gitlab/-/commit/e10ed189e9751c952f151582bc252c6fe3facbaf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179854)) **GitLab Enterprise Edition**
- [Adds the `experiment` status for analytics dashboards](https://gitlab.com/gitlab-org/gitlab/-/commit/df3439845aa82540c67eec2d787da1727e246f7e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180879)) **GitLab Enterprise Edition**
- [Allow adding comments on Wiki pages](https://gitlab.com/gitlab-org/gitlab/-/commit/962ae956d85337b4bd2b39f68ee090310018e6b6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181518))
- [Add integrity verification for remote CI includes](https://gitlab.com/gitlab-org/gitlab/-/commit/5ba3eaea9ead230ac8b5e05db2aa52feed47afee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178593))
- [Set default_enabled to true for feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/4527baca1d925264574ca6cbdee15c17c2567392) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181535)) **GitLab Enterprise Edition**
- [Set `default_enabled` to `true` for the feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/4d09aa620d997d5c078a673b8491c363f1b97238) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181539)) **GitLab Enterprise Edition**
- [Remove maven_extract_package_model feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/73081481fc5d991f6f2b3a662d47a852156b214f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181366))
- [ActiveContext add preprocessors for references](https://gitlab.com/gitlab-org/gitlab/-/commit/d5d91112ad701855c64f1b9cfc63862fb05022dc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181671))
- [Add worker to unassign security bot](https://gitlab.com/gitlab-org/gitlab/-/commit/d0c82d558321c289164d7ab25adb9a905064410c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180760)) **GitLab Enterprise Edition**
- [Introduce project.vulnerabilityArchives GraphQL field](https://gitlab.com/gitlab-org/gitlab/-/commit/28459e82005e6faa13074a0aa823852c53894bb5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181102)) **GitLab Enterprise Edition**
- [ActiveContext postgres indexer](https://gitlab.com/gitlab-org/gitlab/-/commit/8ae3016c1d25ee2be105f8fdb02c1890b3597387) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180719))
- [Add support for created_at on work_items create API](https://gitlab.com/gitlab-org/gitlab/-/commit/39079ed89c4d34f80c77436bd8a60aa55b045f18) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180903))
- [Add `Shared groups` tab to group overview](https://gitlab.com/gitlab-org/gitlab/-/commit/144b070b5c5975d6a8ce83700fdf7eeb748056f4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181039))
- [Model registry: Support loading runs](https://gitlab.com/gitlab-org/gitlab/-/commit/57ffba14b4bf304308fc57f0eb1e2aeaef042333) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177136))
- [Add API endpoints for group level integrations](https://gitlab.com/gitlab-org/gitlab/-/commit/a884ebabbe7b41e2b50552673123c943a1a37654) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179694))
- [Admin Token API: Revoke Feature Flags Client token](https://gitlab.com/gitlab-org/gitlab/-/commit/23e99f5bdd2985517afb82dcad7560bec8d63a16) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181096))
- [Update flag for duo chat include file context](https://gitlab.com/gitlab-org/gitlab/-/commit/cd269a964d09827c44aa50d80f01d9e8870d943c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181305)) **GitLab Enterprise Edition**
- [Add pipeline analytics for groups on GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/226a0be9c4c8ec595b577aa4171c260d72af7a75) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180579))
- [Add organization and job title to user synced attributes](https://gitlab.com/gitlab-org/gitlab/-/commit/5780048d27619f8fc59c74e4665a5f81d818ee6d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175662))
- [Query evaluator for expression control](https://gitlab.com/gitlab-org/gitlab/-/commit/a56f18e9eee736b60e61d32825c52f8f3689f4aa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177981)) **GitLab Enterprise Edition**
- [Add vulnerability_severity_overrides table](https://gitlab.com/gitlab-org/gitlab/-/commit/6e35bd6cc5dbaafe63083a659ab1f830dd31763e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176952)) **GitLab Enterprise Edition**
- [Display dropdown text explainer on component token](https://gitlab.com/gitlab-org/gitlab/-/commit/0db6b774e3c3a1d1472db258e761c03e80b163d6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181132)) **GitLab Enterprise Edition**
- [feat: Protected packages: Maven package push protection](https://gitlab.com/gitlab-org/gitlab/-/commit/863e774de5e5cbb14abf0ee1b713e08532dd25f5) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/147055))
- [Show message when approaching Pages deployments limit](https://gitlab.com/gitlab-org/gitlab/-/commit/3ec667b154e067411adeab55d53024ae1d08c772) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181119)) **GitLab Enterprise Edition**
- [Add error tracking widget to work items](https://gitlab.com/gitlab-org/gitlab/-/commit/40be2a269d54672ad62d755dc727677ae76a04ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179719))
- [Added resources widget](https://gitlab.com/gitlab-org/gitlab/-/commit/508b5d8572aae2e046f422fddb90bacc287ed8eb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174793))
- [Expose sign_in_restrictions from ApplicationSettings API](https://gitlab.com/gitlab-org/gitlab/-/commit/cfc21639522a54eadc08456e908596288942be43) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181247))
- [Add thread ID to AI completion response](https://gitlab.com/gitlab-org/gitlab/-/commit/f2d23a004c00bd0cdd596433ab46bb395aae2d07) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181129)) **GitLab Enterprise Edition**
- [Add enforce_email_subaddress_restrictions application setting](https://gitlab.com/gitlab-org/gitlab/-/commit/f73c3599f23cfcd86d917cd3dff9e01af2c0b656) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180446))
- [Add support for severity overrides in pipeline security finding type](https://gitlab.com/gitlab-org/gitlab/-/commit/16d52222936a6b710336a5f169955a7b2d82c9f4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180965)) **GitLab Enterprise Edition**
- [Add inject_policy_ci as default pipeline execution config strategy](https://gitlab.com/gitlab-org/gitlab/-/commit/b8dbacfaca8fa99b8c16820ca79f945028ba035f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178715)) **GitLab Enterprise Edition**
- [Add service class to trigger external control](https://gitlab.com/gitlab-org/gitlab/-/commit/916189504f2a02067a06124c512421d8f3a2fde8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180016)) **GitLab Enterprise Edition**
- [Implement revisions/:recipe_revision/:file_name endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/e8507d2207825d45595e17f9a19f02622bbf843d) by @oceane_scania ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176600))
- [Add `MALFORMED_ENTRY_OWNER` error for CODEOWNERS](https://gitlab.com/gitlab-org/gitlab/-/commit/8b3d59d5a60a99c87198e4483266bf1d5345ff79) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180978)) **GitLab Enterprise Edition**
- [Reschedule backfill of vulnerabilities.detected_at](https://gitlab.com/gitlab-org/gitlab/-/commit/5853bb891dd91aa91a700d59d819b8c377f86266) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181192))
- [Add UI for subscribed filter](https://gitlab.com/gitlab-org/gitlab/-/commit/2fdefbe87845ff4ea239e57c96e149433422228b) by @Taucher2003 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/136007))
- [Promote runs in standalone experiments to a model version](https://gitlab.com/gitlab-org/gitlab/-/commit/1a03c7d720859001ad67c39d91bbd649e2fc3f9f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179228))
- [Add an option to specify language for file icon](https://gitlab.com/gitlab-org/gitlab/-/commit/27cedf7a09ed3f72ca178199de6a865cb34cb977) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178147))
- [Added ability to manage compliance frameworks at project level](https://gitlab.com/gitlab-org/gitlab/-/commit/289c328d971955585001bd98cd2995817fb63d5e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180103)) **GitLab Enterprise Edition**
- [Add swift to package_metadata_purl_types](https://gitlab.com/gitlab-org/gitlab/-/commit/b93db4245313e9124fa95feffcaab58d7c15643b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179539))
- [Pipeline mini graph downstream jobs](https://gitlab.com/gitlab-org/gitlab/-/commit/8308e8c57f7f5c5a10ef475e7f457d5f52b94c6e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180464))
- [Expose lastDuoActivityOn user field in GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/b21ed8bec3f2759373364b71f0f4d1b6aba661f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179704)) **GitLab Enterprise Edition**
- [Load SoftwareLicenses names from catalogue](https://gitlab.com/gitlab-org/gitlab/-/commit/fc8c388dc89f6c2eccd1f4720d8dd3f1a6b44631) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179744)) **GitLab Enterprise Edition**
- [Add rebase button to MR widget if available](https://gitlab.com/gitlab-org/gitlab/-/commit/5c173ad53be80ad970925c3ca939f31d6e2ccac7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179906))
- [Adds root redirect feature](https://gitlab.com/gitlab-org/gitlab/-/commit/13e68cb8b4e5d3454d0ba8907adcac62d80ef920) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180352))
- [Add updatedAt ExperimentType graphql type](https://gitlab.com/gitlab-org/gitlab/-/commit/749226c85913910f03d9854f2a02481c28351fd2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180789))
- [Document how to use Azure workload and managed identities](https://gitlab.com/gitlab-org/gitlab/-/commit/9e98e06cefcf376edc47f536db9c45d6d1ed6f9f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180471))
- [Add missing json fields to WorkspacesAgentConfigType](https://gitlab.com/gitlab-org/gitlab/-/commit/1fdd573893efef6783ea5d7b2362c8315cb528a9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180084)) **GitLab Enterprise Edition**
- [Add scim_group_uid to saml_group_links](https://gitlab.com/gitlab-org/gitlab/-/commit/96193ac9e8a1497bc0b0f226a93c6ed140c71b08) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180288))
- [Add vulnerability_severity_overrides table](https://gitlab.com/gitlab-org/gitlab/-/commit/3e7c02d5ef712f639890c48653e8a641e127ae66) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176952)) **GitLab Enterprise Edition**
- [Add model-level default for Vulnerability#detected_at](https://gitlab.com/gitlab-org/gitlab/-/commit/2bfab9155b623d325dfb03ac3cb8fda7f1562274) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180582)) **GitLab Enterprise Edition**
- [Browser history added](https://gitlab.com/gitlab-org/gitlab/-/commit/5317e50b07b3745e3d31720e19b94b7280b2226c) by @nraj0408 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178564))
- [Extend GraphQL dependency type](https://gitlab.com/gitlab-org/gitlab/-/commit/b37c46db2f05402dd5941c445a0241b8b69a0aa2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179062)) **GitLab Enterprise Edition**
- [Add the model record id to a replicable item in the Geo replicables list](https://gitlab.com/gitlab-org/gitlab/-/commit/7197613a81b99ffdeb89bb5fec63dd265129b971) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180713)) **GitLab Enterprise Edition**
- [Update Create Page with Default Devfile](https://gitlab.com/gitlab-org/gitlab/-/commit/3b67cd76913ddf43c0b48410a58ff581a425a255) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178554)) **GitLab Enterprise Edition**
- [Remove oauth2_device_grant_flow FF](https://gitlab.com/gitlab-org/gitlab/-/commit/090d9c7355a1bf61862de3694d4c2f37763464c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179941))
- [Add group-level pages access control setting](https://gitlab.com/gitlab-org/gitlab/-/commit/ac2862886d7a678a1f21da2e627934423b221edd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176757))
- [Add service class to trigger external control](https://gitlab.com/gitlab-org/gitlab/-/commit/abb0fe967bf6c3d289e890954c6f1fa6800e572b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180010)) **GitLab Enterprise Edition**
- [Remove async dependency export feature flags](https://gitlab.com/gitlab-org/gitlab/-/commit/d2031ca30cdba6259ff3d16d7f56f08f21510b0f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180586)) **GitLab Enterprise Edition**
- [This commit adds support to delete Duo Chat threads through GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/2aa3b75f31561821bde25266c92a36d12a1e9d74) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180286)) **GitLab Enterprise Edition**
- [Admin Token API: Identify Incoming Email Tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/b4191575ba438c80f7f3f0a764432a716ea0c100) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177077))
- [Add new sort option placeholders](https://gitlab.com/gitlab-org/gitlab/-/commit/eb347c4edb48578ceb3b69f1c795213a7bdc57a1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180491))
- [Add clusters_managed_resources table](https://gitlab.com/gitlab-org/gitlab/-/commit/626d3c542ddc4a9c9917d427b424a9129d4b371a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177525))
- [Add support for unassigning user from an admin custom role in GraohQL](https://gitlab.com/gitlab-org/gitlab/-/commit/c54d6294d6b1358a456437a2e1c490c426ed12b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179975))
- [Remove the check_ip_address_for_email_verification FF](https://gitlab.com/gitlab-org/gitlab/-/commit/5da69994aaa49f17208fd4701ad6952ebc98da4a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180408))
- [Introduce CloudConnector::Keys model](https://gitlab.com/gitlab-org/gitlab/-/commit/ffe4c884044d57f4926a5debe4994507e1064498) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179559)) **GitLab Enterprise Edition**
- [Add parameter to toggle if email is sent on export completion](https://gitlab.com/gitlab-org/gitlab/-/commit/1142ccbb14db33ab82e1c1d4dff6291d004c46e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180065))
- [Add streaming to new audit event models](https://gitlab.com/gitlab-org/gitlab/-/commit/8adefcd95e0d123cbd80e84dee93b886f83493b8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179746)) **GitLab Enterprise Edition**
- [Exempt specific files from Codeowners rules](https://gitlab.com/gitlab-org/gitlab/-/commit/80bf09e34d5098f3d7c2d3cbf21bb5203550952f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180162)) **GitLab Enterprise Edition**
- [Add popover support on milestone in WI Sidebar](https://gitlab.com/gitlab-org/gitlab/-/commit/a5f0988e8ee13108ecb743a4238dcdde39733d46) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179902))
- [Audit authorizing an OAuth application](https://gitlab.com/gitlab-org/gitlab/-/commit/d167cc1196a2e326da447f05ae0ff61d22071d8d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179187))
- [Allow read_admin_monitoring access to audit_logs](https://gitlab.com/gitlab-org/gitlab/-/commit/5643f57cdaf612d399a8d2ad15d417217ad268fe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179894)) **GitLab Enterprise Edition**
- [Markdown: Select text and paste URL to create link](https://gitlab.com/gitlab-org/gitlab/-/commit/b4b4a68bbaf272c02861b80c9442b279868e49c8) by @ajuckel ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178942))
- [Prompt user to enter missing access token](https://gitlab.com/gitlab-org/gitlab/-/commit/aadc94754b88cfe47290093d948c296e90379fab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178471))
- [Adding correlation_id attribute to duo workflow message event api](https://gitlab.com/gitlab-org/gitlab/-/commit/8ab95fdce39a7cfb3d72a295c3e2a2413be56848) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179642)) **GitLab Enterprise Edition**
- [Feat(Blob): Add PlantUML render support for Blob Viewer](https://gitlab.com/gitlab-org/gitlab/-/commit/e7faf55c710462e5e8edfee38e59b591323f5a20) by @schurzi ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179301))
- [Add ability to snooze to-dos until a custom time](https://gitlab.com/gitlab-org/gitlab/-/commit/547196b5992810f0dcfbcbdad83e28c7d45015fc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178490))
- [Add queue_namespace as an attribute for Sidekiq routing rules](https://gitlab.com/gitlab-org/gitlab/-/commit/df657a65d9b0f6a69d851fb5074c2d4d44d2a858) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180136))
- [Enforce NOT NULL constraint on vulnerabilities.detected_at](https://gitlab.com/gitlab-org/gitlab/-/commit/6e83857ad3f0b32d6edf7b67baf7f157bd85284e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179644))
- [Admin Token API: Revoke Runner authentication token](https://gitlab.com/gitlab-org/gitlab/-/commit/af6882352654e8a3fb74680cc5e20ef830cb98e1) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179066))
- [Add indexes to web_hook_logs_daily](https://gitlab.com/gitlab-org/gitlab/-/commit/bc8f49c1002f35659dcccab9316af8a81e4eea5c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180155))
- [Add `read_admin_users` permission](https://gitlab.com/gitlab-org/gitlab/-/commit/f32d0556c5256aace13be5cf7c1bfd0bfaba9f76) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177514)) **GitLab Enterprise Edition**
- [Introduce archival related entities](https://gitlab.com/gitlab-org/gitlab/-/commit/6112c120c21c17ad875a232aca7fe1314d2aec1f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179569))
- [Add a new 'Index version' to the elastic info rake task](https://gitlab.com/gitlab-org/gitlab/-/commit/4be6369d9033d165bff2648abd095e922b60a26f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179446/)) **GitLab Enterprise Edition**
- [Add license check to the fields allowedParentTypes and allowedChildTypes](https://gitlab.com/gitlab-org/gitlab/-/commit/7dfb4bdd52ea82069281a1b8f1ec6d99dd8fd0e0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178863)) **GitLab Enterprise Edition**
- [Resolve MR issue with new work item](https://gitlab.com/gitlab-org/gitlab/-/commit/be4f7cb7df5fcd78b6fa636f2950ad118d39c3e2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176703))
- [ActiveContext OpenSearch indexer](https://gitlab.com/gitlab-org/gitlab/-/commit/1f2fb3f07effb2a08ff178ed5b01238c9ef56eba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179662)) **GitLab Enterprise Edition**
- [Extend dashboard date range filter configuration](https://gitlab.com/gitlab-org/gitlab/-/commit/f9bdf7f45ce982644a4e3bb822f8045bdba3937c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178999)) **GitLab Enterprise Edition**
- [Remove microsoft_azure_group_sync FF](https://gitlab.com/gitlab-org/gitlab/-/commit/48921fc8f38a8d3da5aeff0442bb950beeac4c2d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179942))
- [Add `project_design_management_routes_view` database view](https://gitlab.com/gitlab-org/gitlab/-/commit/6c52398635b7ae345bc7ffdd6a16ba388597db9a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179449))
- [Add `project_routes_view` database view](https://gitlab.com/gitlab-org/gitlab/-/commit/dbb6013c0a22018fbda0adbd08f161bee01f25fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179443))
- [Add “Added from log” icon in job token allowlist UI](https://gitlab.com/gitlab-org/gitlab/-/commit/024a9f1f3e9b7558f011cdafbc55677a395d3400) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177785))
- [Add ActiveContext reference class](https://gitlab.com/gitlab-org/gitlab/-/commit/b18c45d566f9f9dc47299da9b6df071eef3394e9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179362)) **GitLab Enterprise Edition**
- [Introduce a NamespaceSettingsUpdate mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/39eb31f777242fd317a60cb1a476a17930b16c33) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178328))
- [Enable ability to view IP addresses in access tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/c702d20887db4e8050af35dfeb59d07897cf8079) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179747))
- [Create work_item_user_preferences table](https://gitlab.com/gitlab-org/gitlab/-/commit/5eeed2127c1ed09460bb1ec344bf671bdd396017) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176869))
- [GraphQL: Populate `timeSeries.count` field in AnalyticsType](https://gitlab.com/gitlab-org/gitlab/-/commit/c76b632d494f9bd5cf8a07493705428be1129e1d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179378))
- [Prevent unnecessary processing of AutoDevops with overriding PEP](https://gitlab.com/gitlab-org/gitlab/-/commit/3484e63a7a201a1e19dba5b3755bc303a3562dab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178581))
- [Allow SSH keys to be filtered by created at and expires at](https://gitlab.com/gitlab-org/gitlab/-/commit/8f13ba6e5e73e282ee7a04e34a4587c048d18ce0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177010))
- [Added severity override support in MR security widget](https://gitlab.com/gitlab-org/gitlab/-/commit/fc9784b8d0757ecc7727f886cd7bcf85ac6c92ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178862)) **GitLab Enterprise Edition**
- [Admin Token API: Identify GitLab sessions](https://gitlab.com/gitlab-org/gitlab/-/commit/e48740b4c37ff005f4d4838ea093517521ed6987) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178022))
- [Add Security Risk Management feature categories](https://gitlab.com/gitlab-org/gitlab/-/commit/4375b0f45d403676e4ad9687338e099fd8c12546) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179556))
- [Add external_url to compliance_requirements_control](https://gitlab.com/gitlab-org/gitlab/-/commit/ce08f6d06ef52b16bc94317f4996bdfd9ae9c4e8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179256)) **GitLab Enterprise Edition**
- [Admin Token API: Add support for revocation of Cluster Agent Tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/5d772a541ab4ab2d8122e7d6174a17b3e7b692f4) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178211))
- [GraphQL: Add `timeSeries.durationStatistics` field to AnalyticsType](https://gitlab.com/gitlab-org/gitlab/-/commit/30a55af07876d9673e104d3710174f348da07972) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179006))
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/c6ade453311f2cdf21092351d029fdc8f0831d38) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179675))
- [Add Amazon Q role arn validation](https://gitlab.com/gitlab-org/gitlab/-/commit/e1289305102f93fe8e5567feed0a11755e70b448) by @protsivd ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176883))
- [Add read_admin_monitoring permission](https://gitlab.com/gitlab-org/gitlab/-/commit/9389c1b393661845a9aca3a0e5cc445ff83114a3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179439)) **GitLab Enterprise Edition**
- [Add security findings severity override mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/6692d998f1ea68ead25ba0b3322ce7141bae3393) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178167)) **GitLab Enterprise Edition**
- [Add anti_abuse_settings column to application_settings table](https://gitlab.com/gitlab-org/gitlab/-/commit/e517c5475d7cd069757a09a22a25e8c8d0f1d905) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179596))
- [Prioritize vulnerability severity when resolving security findings](https://gitlab.com/gitlab-org/gitlab/-/commit/d4ea75f6b0576e591e54b73920515b46cf03b9c1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179566)) **GitLab Enterprise Edition**
- [Backfill web_hook_logs_daily](https://gitlab.com/gitlab-org/gitlab/-/commit/26afa6c7fd59c118cfdb40fb1fa448203e8dda9c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176714))
- [Enable Vulnerability Change Status modal by default](https://gitlab.com/gitlab-org/gitlab/-/commit/147651617959d746884a92d0938deb7a719626b8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179346)) **GitLab Enterprise Edition**
- [Add more details for zoekt performance bar in multimatch](https://gitlab.com/gitlab-org/gitlab/-/commit/5fff92091005feabadff9f70fcd2826775de88ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178585)) **GitLab Enterprise Edition**
- [Release SAML Groups Duo Add On Assignment](https://gitlab.com/gitlab-org/gitlab/-/commit/b607682fe6cedf2b13f274c00fc83be8118ad7fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179575)) **GitLab Enterprise Edition**
- [ActiveContext indexer for elasticsearch](https://gitlab.com/gitlab-org/gitlab/-/commit/687828665b8b9ca9dd41f061f12467b499c00504) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178705)) **GitLab Enterprise Edition**
- [Add AI impact visualizations to the analytics dashboard designer](https://gitlab.com/gitlab-org/gitlab/-/commit/e20557c5803c7430e68d6f20684c1edfca964269) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179406)) **GitLab Enterprise Edition**
- [Add GraphQL fields for pipeline creation status](https://gitlab.com/gitlab-org/gitlab/-/commit/a0a443daa6f7aecd0c328fcaa2d9a8232a5b8557) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178558))
- [Allow to configure LFS link batch size via environment variable](https://gitlab.com/gitlab-org/gitlab/-/commit/1f94146a5dc045bd26abd8dd6e8384c8f61b4be7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179401))
- [Crud HAML component: Adds collapsible feature](https://gitlab.com/gitlab-org/gitlab/-/commit/cdc2fe0808f2690a8f52a44cd51bdaf37d5997fa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178917))
- [Adding GraphQL mutations to trigger Allowlist Autopopulation processes](https://gitlab.com/gitlab-org/gitlab/-/commit/d85923693b43f15f3808e6bc72d2c44a5bfb1c84) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177465))
- [Added update mutation for compliance requirement controls](https://gitlab.com/gitlab-org/gitlab/-/commit/0671b32c256d2a9c67b988e0f500a5ef8f307725) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178290)) **GitLab Enterprise Edition**
- [Block Seat Overage for SM](https://gitlab.com/gitlab-org/gitlab/-/commit/a3b64dcfa0002f10bffb5413a6ac43c6112cb2ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176655)) **GitLab Enterprise Edition**
- [Introduce endpoint to discover cert-based clusters](https://gitlab.com/gitlab-org/gitlab/-/commit/47309f441d5076ace208273fa1b5404afebc13fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178883))
- [Add clusters_managed_resources table](https://gitlab.com/gitlab-org/gitlab/-/commit/f2a0aa14f2d4388fb0a531ce45f03b6760324424) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178118))
- [Remove composite identity FF](https://gitlab.com/gitlab-org/gitlab/-/commit/3939f6cfbe12ea64c10f297cdab3b563e3da3a00) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176977))
- [Admin Token API: Identify Feature Flags client token](https://gitlab.com/gitlab-org/gitlab/-/commit/8c52f104a381be850c7ecda66f540a8f98402854) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177431))
- [Add `raw_diff` endpoint to merge request API](https://gitlab.com/gitlab-org/gitlab/-/commit/0b917ddeab3856f35724b86110e50f99df1ce349) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178813))
- [Adds not-null migration for ComplianceViolation on target_project](https://gitlab.com/gitlab-org/gitlab/-/commit/b2d8389e9872fa4ed24a8464ff3a5e3272abef4e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173748)) **GitLab Enterprise Edition**
- [Add diff_lines endpoint to blobs controller](https://gitlab.com/gitlab-org/gitlab/-/commit/5c3299904e75137a37b48e00c8d2012b57137bb3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176274))
- [Throw error when incorrect scope is used in auditor](https://gitlab.com/gitlab-org/gitlab/-/commit/102678b9703be032c11bf8470b9eb57ec5639b2e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178412)) **GitLab Enterprise Edition**
- [Add self_rotate scope for access token self rotate endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/e81424a4075c4f577bf6a18636abacb9c7be6c86) by @ajuckel ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178111))
- [Backfill archived and traversal_ids for vulnerability_statistics](https://gitlab.com/gitlab-org/gitlab/-/commit/35210641f9eb708eb3b20828c927ae6ff9dd58ce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177993))
- [Add manage protected tags custom permission](https://gitlab.com/gitlab-org/gitlab/-/commit/1bf44697e2df4796f6d6a9fe6b6e082002f2d4ce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178059)) **GitLab Enterprise Edition**
- [ActiveContext processes refs from queues via cron worker](https://gitlab.com/gitlab-org/gitlab/-/commit/54a834f35fc46e2ece7688c0d5dacfdd7444cb4f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177732)) **GitLab Enterprise Edition**
- [Add cloud_connector_keys ApplicationSetting](https://gitlab.com/gitlab-org/gitlab/-/commit/ccd0fee30852d2495d8e5cf2ad6aac986811e842) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178857)) **GitLab Enterprise Edition**
- [Create AiUserMetrics table and model](https://gitlab.com/gitlab-org/gitlab/-/commit/d3085c206f130f3582eaa6b0520e1202a78a2a41) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178559)) **GitLab Enterprise Edition**
- [Expose linkType in field linkedWorkItems](https://gitlab.com/gitlab-org/gitlab/-/commit/663126084427a6eca2f869b295804c71ba95d1f5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178569))
- [Use security_findings for security mr widget](https://gitlab.com/gitlab-org/gitlab/-/commit/861dcf7cda90c12b9e4c0a7fd53104b58247e8b8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173949)) **GitLab Enterprise Edition**
- [Add protection rules to TagType](https://gitlab.com/gitlab-org/gitlab/-/commit/9b3842c5720bc748a767f64aeb9c651d2834cad4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177039))
- [Schedule web_hook_logs_daily indexes](https://gitlab.com/gitlab-org/gitlab/-/commit/ea98672ae62e65d55eaba035408ea17c726b69d6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178413))
- [Add skip ci configuration](https://gitlab.com/gitlab-org/gitlab/-/commit/1289cda2687208d5df9b56a6e28206986525b312) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178496)) **GitLab Enterprise Edition**
- [Changes to support group level report for severities count api](https://gitlab.com/gitlab-org/gitlab/-/commit/ea010ca8e2a39717ae846b1fc793194ecd6de314) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175913)) **GitLab Enterprise Edition**
- [Support expires_at param for group service account PAT rotation API](https://gitlab.com/gitlab-org/gitlab/-/commit/da24662ab3d9c45cadea88e9662652030bcbc2a4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178608))
- [Add skip ci configuration to a policy drawer](https://gitlab.com/gitlab-org/gitlab/-/commit/e992c73c7cb6d191d708b84f8edfb006dcfff4c7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178497)) **GitLab Enterprise Edition**
- [Add instance setting to restrict private user profiles](https://gitlab.com/gitlab-org/gitlab/-/commit/1e554fccecaab8043e7917f4e3d655cda3979c11) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178683)) **GitLab Enterprise Edition**
- [Add migration to enable read_compliance_dashboard in member roles](https://gitlab.com/gitlab-org/gitlab/-/commit/5b786f31332cc5eb9d78d578b3467a5596576ae0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176834))
- [Improve throttling during user record reassignment](https://gitlab.com/gitlab-org/gitlab/-/commit/e19d519b4aac0d2ed8b9b3a93a4fb6e75784d605) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175961))
- [List threads GraphQL API](https://gitlab.com/gitlab-org/gitlab/-/commit/d6554b7ff2fdaac663b5170ca31ea1dcbf7c2d6d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178268)) **GitLab Enterprise Edition**
- [Add Duo Chat usage rate to AI analytics dashboard metric table](https://gitlab.com/gitlab-org/gitlab/-/commit/b1f04b75f2e22a86b0dec9e06941767378490ad5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178622)) **GitLab Enterprise Edition**
- [Add worker architecture for scheduled PEP](https://gitlab.com/gitlab-org/gitlab/-/commit/90273ea98412565ec0976272596db620d996084e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175246))
- [Fix documentation for confidential incidents visibility](https://gitlab.com/gitlab-org/gitlab/-/commit/8cb53be2a5e4b439ed9ecd1ad0bb889d6c96c84e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178600))
- [Introduce codeSuggestionsContexts for CurrentUser](https://gitlab.com/gitlab-org/gitlab/-/commit/ea41fdb1c536f1c7cce1c4963b9f06370912732e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178402)) **GitLab Enterprise Edition**
- [GraphQL: add TagDelete mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/2595da6b07f1c560572bb51b9d9d76dee4f641ea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176000))
- [Remove the `todos_snoozing` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/61007f1f42a7d22b987f8c6e771166023c5aba20) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178205))
- [Use helper to update stream destinations from legacy API](https://gitlab.com/gitlab-org/gitlab/-/commit/846db30be279ba234c677fa6686ff8e5b07476f7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177927)) **GitLab Enterprise Edition**
- [Expose cvss v3 in vulnerability details page](https://gitlab.com/gitlab-org/gitlab/-/commit/905b8c7ccc7e9c56fe4e06dad963a88864302171) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177071)) **GitLab Enterprise Edition**
- [Add "PATCH /groups/:id/enterprise_users/:user_id/disable_two_factor" API endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/0eae379570a111e73967345bb7439c090ae7257c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177943)) **GitLab Enterprise Edition**
- [Support thread id in AiAction GraphQL mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/faafe1390e5f6dcea51394e4be8964e463a9293e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177053)) **GitLab Enterprise Edition**
- [Define sharding key for events](https://gitlab.com/gitlab-org/gitlab/-/commit/9ebccbfd61f9effd683eba842c981ad3c9611a80) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177810))
- [Delete paired audit event destinations](https://gitlab.com/gitlab-org/gitlab/-/commit/24bcc1c111e1abb2d89eb39098899f83a7933068) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175018)) **GitLab Enterprise Edition**
- [Add project topics to CI/CD Catalog](https://gitlab.com/gitlab-org/gitlab/-/commit/31a74b76e32e349600866ff681b3d90941383d1d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177522))
- [Add Ci/CD job token policies static analysis](https://gitlab.com/gitlab-org/gitlab/-/commit/1b79cc3e031b305423b91344894da94e4ce2ad92) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174474))
- [Adding mutation for creating compliance controls](https://gitlab.com/gitlab-org/gitlab/-/commit/039b1a25458fbff2c8047807291c8d8135946d4e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177557)) **GitLab Enterprise Edition**
- [Add AiDuoChatEvent model](https://gitlab.com/gitlab-org/gitlab/-/commit/f258d566bc8bfb576219cb8000c4edff7ca726c8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177239)) **GitLab Enterprise Edition**
- [Defined event and metrics](https://gitlab.com/gitlab-org/gitlab/-/commit/238fa7990ad7ff0d8f2f4bd694b0b1ed384c3abe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177663)) **GitLab Enterprise Edition**
- [Add last_approved_at event to VSA](https://gitlab.com/gitlab-org/gitlab/-/commit/5becf3114cfe34f9b83180ce9ded32cc62070d96) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175989))
- [Surface user.type to frontend](https://gitlab.com/gitlab-org/gitlab/-/commit/9e6ffe21b5e28a48bb9c99bf310a9104b38df744) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173343))
- [Improve UX of registering a GitLab agent](https://gitlab.com/gitlab-org/gitlab/-/commit/1944090910bdeb979966da792baccf6701de593e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177777))
- [Release DAST UI additional varibles feature](https://gitlab.com/gitlab-org/gitlab/-/commit/b88727b6f9fef1d7a883ba3cfadb3dc85bd13ddf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177703)) **GitLab Enterprise Edition**
- [Introduce write_virtual_registry scope](https://gitlab.com/gitlab-org/gitlab/-/commit/a9c6ad66a75f71de1541e0c4beabb4c03aeff770) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174496))
- [Add metrics for sep scheduled scans using time_window](https://gitlab.com/gitlab-org/gitlab/-/commit/ad6cb54f4ace2d66ccc7cf948e860e212d21a348) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176472)) **GitLab Enterprise Edition**
- [Add ability to add related item for work items](https://gitlab.com/gitlab-org/gitlab/-/commit/9393fb5dd0acc0c39a21417d1de6b6711e6edc79) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178025))
- [Let ActiveContext add references to a queue](https://gitlab.com/gitlab-org/gitlab/-/commit/96a2f68a81d96b8957b9c8186a30f31d7ed086c3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177232)) **GitLab Enterprise Edition**
- [Update vulnerability_statistic.archived when project is archived](https://gitlab.com/gitlab-org/gitlab/-/commit/ca3a10992082fe478f88e05450bf1625fbf5f4ec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177990)) **GitLab Enterprise Edition**
- [Prepare not-null for ci_pipeline_messages.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/316cb408d16671ba65a06827fcb0156475471693) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173952))
- [Implement filtered search UI for credentials](https://gitlab.com/gitlab-org/gitlab/-/commit/6174fc9c2a5d7f6a5122bfd36f9ca14c6ba493ae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176677))
- [Add Code Suggestions acceptance rate to AI usage metrics table](https://gitlab.com/gitlab-org/gitlab/-/commit/9e100fad76e1225ec1bc39c044d6824b8907131e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178063)) **GitLab Enterprise Edition**
- [Persist licenses column to support component filtering](https://gitlab.com/gitlab-org/gitlab/-/commit/cfff99a93f516acf8b31273689135e0a7ad6ff2d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177297)) **GitLab Enterprise Edition**
- [Add feature flag for anthropic prompt caching](https://gitlab.com/gitlab-org/gitlab/-/commit/0b8a752d16de2d3c6e2fcd4367a734fe89f568d4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177642)) **GitLab Enterprise Edition**
- [Update Report class to return new dependencies for licenses](https://gitlab.com/gitlab-org/gitlab/-/commit/c09fcb8a4b4a422ad9338472385110168b4dcfd0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177499)) **GitLab Enterprise Edition**
- [Admin Token API: Identify CI/CD Job Tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/a08cb8061ca3c0090e8c0a897203418f36c74e44) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175234))
- [Extend selective sync scope to the primary checksumming](https://gitlab.com/gitlab-org/gitlab/-/commit/f4077e068bf62a2a3056788c461dcfdf56285836) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174453)) **GitLab Enterprise Edition**
- [Add uri validation for licenses purl](https://gitlab.com/gitlab-org/gitlab/-/commit/51af1ab294bfb1e62072544a39d63afc70db0fd3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178048)) **GitLab Enterprise Edition**
- [Add `expires_at` column to `vulnerability_exports`](https://gitlab.com/gitlab-org/gitlab/-/commit/22470dafc1a3f1a648df9af09de3aa35f929b1cc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178043))
- [Add `expires_at` column to `dependency_list_exports`](https://gitlab.com/gitlab-org/gitlab/-/commit/315d101e1d08e8b5fe2b36c79acfef308c7be636) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178042))
- [Add elastic client to active context gem](https://gitlab.com/gitlab-org/gitlab/-/commit/3eb2ecf09c2ada617a05ce7579188419da1eec67) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177093)) **GitLab Enterprise Edition**
- [GitLab storybook add missing features](https://gitlab.com/gitlab-org/gitlab/-/commit/8a53c4c86895574fa692f5e57b8840d26a640896) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178028))
- [Allow gem to register queues](https://gitlab.com/gitlab-org/gitlab/-/commit/45f08dd9d0231325d4b50c3cfe61c18208197669) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177086)) **GitLab Enterprise Edition**
- [Allow users to configure skip_ci behavior for scan execution policy](https://gitlab.com/gitlab-org/gitlab/-/commit/e55cd2e211a21c660485b2aa38fed932a5dcf4cd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174975)) **GitLab Enterprise Edition**
- [Add "GET /groups/:id/enterprise_users/:user_id" API endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/1bbd02c210c485836f06fac618308a71acc2ac50) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176328)) **GitLab Enterprise Edition**
- [Remove Epics scope and replace it with work_item type epic](https://gitlab.com/gitlab-org/gitlab/-/commit/5923033037a48aec0e943a0e294e100eee0dea99) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173915)) **GitLab Enterprise Edition**
- [Add vulnerability_severity_overrides table](https://gitlab.com/gitlab-org/gitlab/-/commit/6052e201a22a5a7703646627858bb407fc743bec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176952)) **GitLab Enterprise Edition**
- [Defined event and metrics](https://gitlab.com/gitlab-org/gitlab/-/commit/03ddd6f4ad8778ed213eacbc018f9a3381fff6d6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177315)) **GitLab Enterprise Edition**
- [Add traversal_ids to vulnerability_statistics](https://gitlab.com/gitlab-org/gitlab/-/commit/5cf9d0e45242f7a015265f8542ab635c6484ca3b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177591))
- [Add helper method to update legacy destination from stream destination](https://gitlab.com/gitlab-org/gitlab/-/commit/59a1c4f98b633c9a7f426e430082245ba27e1d6b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175892)) **GitLab Enterprise Edition**
- [Model Registry: Add ability to get Model Version by alias](https://gitlab.com/gitlab-org/gitlab/-/commit/89fc8baebe17ce2fb325be73e9646b9e81149d92) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177715))
- [Fetch latest pipeline if no arguments are passed](https://gitlab.com/gitlab-org/gitlab/-/commit/f21c98cced9cd1d77ed613c8a83d300dfe0fc683) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172934))
- [Add /create_merge_request quickaction to work items](https://gitlab.com/gitlab-org/gitlab/-/commit/b6689979b26b6efb6ac0fa0eb6f3ea797307618e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177815))
- [Add reports identification](https://gitlab.com/gitlab-org/gitlab/-/commit/34ecaf8c1589b9555e03944c6e62ff2400d9db0e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177764))
- [Run dependency scanning on uv.lock detection](https://gitlab.com/gitlab-org/gitlab/-/commit/56c2f10a0260df218c634e89a6f17370a5593529) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177637))
- [Release group credentials inventory feature](https://gitlab.com/gitlab-org/gitlab/-/commit/02765aaa84fce62deebbc78d95a43264fd596de1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177286))

### Fixed (242 changes)

- [Hide Edit button for work item metadata for Guest users](https://gitlab.com/gitlab-org/gitlab/-/commit/60a70a940b66ec9319b54b9e75ab81284008958e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180418))
- [Update net-imap gem](https://gitlab.com/gitlab-org/gitlab/-/commit/83853b3ce0f5a00859fd778ea8341b20e87c026b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181666))
- [Fix runner owner if necessary when runner assigned to a project](https://gitlab.com/gitlab-org/gitlab/-/commit/30df5eb287573c54549791d3194aebabf1759ba7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180417))
- [Fix vulnerability severify badge rendering](https://gitlab.com/gitlab-org/gitlab/-/commit/82f9dc41e51dbae899fb273fc85c7a8383ecdd3f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181422)) **GitLab Enterprise Edition**
- [Fix incident layout when new issue look is turned on](https://gitlab.com/gitlab-org/gitlab/-/commit/6915eb6aa3713f3836b7121e2f2b74bddba90b47) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181432))
- [Fix returning cached severity value after severity override](https://gitlab.com/gitlab-org/gitlab/-/commit/b009659d565b632cf6ab2bf297c5811ee7d6f368) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181078)) **GitLab Enterprise Edition**
- [Backfill default pages deployment limit](https://gitlab.com/gitlab-org/gitlab/-/commit/85c514c45b3f4e32349b3bdbb8579fc1a8f523ce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180735))
- [Upgrade net-http-persistent gem to 4.0.2 to fix connection pool issues](https://gitlab.com/gitlab-org/gitlab/-/commit/bcd1e19c7a06956786723ddaac1a9dab7b0ab289) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181361))
- [Fix: Removing all domains does not reset primary domain](https://gitlab.com/gitlab-org/gitlab/-/commit/3ef229df51784a61d573255af21f9512bb4c99cc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181150))
- [Add default value to plan deployment limits](https://gitlab.com/gitlab-org/gitlab/-/commit/249053e17e69b7fec91243a1e0c9476260a9beca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180538))
- [Render files based on the correct file sizes](https://gitlab.com/gitlab-org/gitlab/-/commit/17ed419dbb845db15b3f79034f8b625487220b01) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180718))
- [Fix incorrect branch access check](https://gitlab.com/gitlab-org/gitlab/-/commit/82cf739d24cc489de8cc7d6d4b2e5a9ba468ea3a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180225))
- [Fixed UX flow when when author filter dropdown opens](https://gitlab.com/gitlab-org/gitlab/-/commit/201f0d52e0237da2fb91b5b36ce745d662ce74e5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180389))
- [Update getBlobSearchCountQuery variables](https://gitlab.com/gitlab-org/gitlab/-/commit/a685e3d0f90331c7490a6adc3ee2780a4206de0f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181256)) **GitLab Enterprise Edition**
- [It is not necessary to set FK when moving issue under new parent](https://gitlab.com/gitlab-org/gitlab/-/commit/37dc9bb9b44ac780ac8b116ca2a75eec1c090748) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181244)) **GitLab Enterprise Edition**
- [Enforce SEP jobs when `pipeline_source` is a string](https://gitlab.com/gitlab-org/gitlab/-/commit/f1ff087c8ab29687a3bd454f1c5c417c2993901e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180977)) **GitLab Enterprise Edition**
- [Fix Ci::RunnerTagging sharding_key_id validation](https://gitlab.com/gitlab-org/gitlab/-/commit/7a1d48ed2ce01859821402ba06bb2c2927b6ea63) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181228))
- [Fix overflow issues on snippets page](https://gitlab.com/gitlab-org/gitlab/-/commit/3114caf280b0293acd3523926bb2dd3118571075) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181212))
- [Fix work item issues webhook event type and object kind](https://gitlab.com/gitlab-org/gitlab/-/commit/abebbb2372b6f2bdcea8cb339a1fb395ec65df8d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180959))
- [Add custom role preloader to projects resolver](https://gitlab.com/gitlab-org/gitlab/-/commit/c23b7647331216fd96fe93821627635f18f55cfe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179471)) **GitLab Enterprise Edition**
- [Fix CRM issue filters when contacts not sourced from root group](https://gitlab.com/gitlab-org/gitlab/-/commit/38e9186565f1ab07060fcf888256ac33b836679a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180290))
- [Add content_disposition to export downloads](https://gitlab.com/gitlab-org/gitlab/-/commit/efa9e8afe4b455acb16d5a57d86f451fe58f95e2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181187)) **GitLab Enterprise Edition**
- [Strip trailing newline from rendered Kroki and PlantUML diagram source](https://gitlab.com/gitlab-org/gitlab/-/commit/23358b316db540b78c984112035fd34b163b68c8) by @puxlit ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180830))
- [Width correction](https://gitlab.com/gitlab-org/gitlab/-/commit/aa243cffc71fc0ab75087efa92cdce54d10a5152) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181140))
- [Remove `repo` if agent project is null](https://gitlab.com/gitlab-org/gitlab/-/commit/c666f122017f0f59b6862235ea3b2ff8f5307537) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181138))
- [Change Security Finding to reference project from scan](https://gitlab.com/gitlab-org/gitlab/-/commit/f5a5c721dd9472dc1ecc30bcbd6f41f7ff69e674) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180246)) **GitLab Enterprise Edition**
- [Fix overlap with description](https://gitlab.com/gitlab-org/gitlab/-/commit/164d7bdc2b259948e92eab397e4e28c7348d48fc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181127))
- [Ensure issues has fixed dates](https://gitlab.com/gitlab-org/gitlab/-/commit/4d846bb333c5a45dc2d66545da4f95403af3248d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179882))
- [Make `any_merge_request` rules respect `branch_exceptions`](https://gitlab.com/gitlab-org/gitlab/-/commit/c78165cd5eccfb06346e869b811a18c8331907a6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181121)) **GitLab Enterprise Edition**
- [Fix member guidelines resulting in overflow in group member view](https://gitlab.com/gitlab-org/gitlab/-/commit/e78c5e5dd1dd12ded84b1b46c0c85a27f8e28ff0) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181077))
- [Increase query limiting threshold](https://gitlab.com/gitlab-org/gitlab/-/commit/5ec65d649d8228bd363a3b1ef437ee5aff24d304) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181050))
- [Update stop environment API to use different policy](https://gitlab.com/gitlab-org/gitlab/-/commit/e06dfd496bb2fc113bf47ab2d31dadc50b134e4a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181042))
- [Clean up remote_mirror_retry_with_delay feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/f95ad0f4fcbcb5997dd30135db1cb4a5c58ef0bd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181016))
- [Fix linking of policy to the project](https://gitlab.com/gitlab-org/gitlab/-/commit/9f1b4be90a16318abd5afeff65494071c919baec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180615)) **GitLab Enterprise Edition**
- [Zoekt cache should invalidate if multi match chunk size changes](https://gitlab.com/gitlab-org/gitlab/-/commit/1ab722b63d5ccf3e969cdf1ff71a06d66fd35682) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180603)) **GitLab Enterprise Edition**
- [Fix broken vulnerability management save functionality](https://gitlab.com/gitlab-org/gitlab/-/commit/44c8f86c99914ad2fdc3a6f0b62bb05aceec95b2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180979)) **GitLab Enterprise Edition**
- [Determine file id from hash](https://gitlab.com/gitlab-org/gitlab/-/commit/5869bcc04ab2e34fe4c62b6154998822933a749d) by @crenz ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179483))
- [Nav eval > Enable filters button](https://gitlab.com/gitlab-org/gitlab/-/commit/81fba6b66963d120752d3b7ee4a6725e4573ed54) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180808))
- [Handle invalid repository names gracefully](https://gitlab.com/gitlab-org/gitlab/-/commit/1a05d7d47f51c6a4484ca461bad8ffb3b5109f07) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180140))
- [Add group-level validation for audit events feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/cb09b1c52c96e1f9d84c24a69adbe739ded2a299) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180245)) **GitLab Enterprise Edition**
- [Dismiss alert upon toggling labels in Tasks by type chart in VSA](https://gitlab.com/gitlab-org/gitlab/-/commit/9bc1b0be53bbf1da81a0f0e709edccf0984d4b85) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180790)) **GitLab Enterprise Edition**
- [Support merge request variables in pipeline execution policies](https://gitlab.com/gitlab-org/gitlab/-/commit/7f717a84ab5162a36284ddfdc3ed1c61c565df16) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180945)) **GitLab Enterprise Edition**
- [Fix link rendering in GitHub integration](https://gitlab.com/gitlab-org/gitlab/-/commit/ec86a5937e20304eeb8efef5e0ba71f416970df2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180833)) **GitLab Enterprise Edition**
- [Fix AddOnPurchase API override trial attribute bug when deprovision](https://gitlab.com/gitlab-org/gitlab/-/commit/036af5fd756acba8a5c6ff3680f2ba5a88572210) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179989)) **GitLab Enterprise Edition**
- [Prevent Direct Transfer from re-enqueueing timed-out pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/d8d2eb0d6b9c4de34aa0501c7b115f3f16cdccde) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179097))
- [Fix getExperiments Graphql Query](https://gitlab.com/gitlab-org/gitlab/-/commit/354973fc34402c2e40a61143c7cb78b9b7beb4d6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180786))
- [Use common insertText in dropzone_input to preserve browser undo](https://gitlab.com/gitlab-org/gitlab/-/commit/232c934fff752dcfccc6af13d537da1512d65d08) by @Bubbis ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180255))
- [Fix: add name prop to instances of devops_adoption_table_cell_flag.vue](https://gitlab.com/gitlab-org/gitlab/-/commit/4c76cbaad6fbb013e5b21267d3cf5f05169a6ce7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180781))
- [Do not list pending migrations if search service unreachable](https://gitlab.com/gitlab-org/gitlab/-/commit/e2db31e58bcd175d11b9770a64b95cf2be908054) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179782)) **GitLab Enterprise Edition**
- [Do not allow assigning non-admin custom roles directly to users](https://gitlab.com/gitlab-org/gitlab/-/commit/1e2a91d337438c87e0634a49f18db284cb620a70) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180036))
- [Display download message conditionally](https://gitlab.com/gitlab-org/gitlab/-/commit/70073f093ae8b3a9b0c229c79500c4820075fb1a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179872))
- [Fix issue work item spacing issue related to gutter classes](https://gitlab.com/gitlab-org/gitlab/-/commit/84315fa4292c4d2d0dc9b7e09e926d1976c447e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180444))
- [Update policy for stop environment REST API](https://gitlab.com/gitlab-org/gitlab/-/commit/4d360debd97526343e9b73231f51475a1735878b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179955))
- [Fix console error during filter search](https://gitlab.com/gitlab-org/gitlab/-/commit/3e3871cf0c3939b40f30af010fc865c8f382edcc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180715)) **GitLab Enterprise Edition**
- [Fix remote response broadcast messages with target path](https://gitlab.com/gitlab-org/gitlab/-/commit/2a68bbbd72ca5a9b2e8d921da7d005116d43985c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180730))
- [Ensure correct header is present for work item detail](https://gitlab.com/gitlab-org/gitlab/-/commit/f43ddf9fe14017676c9561bd9f2d642844de4328) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179595))
- [Fix bug of missing groups in JobTokenAllowlist](https://gitlab.com/gitlab-org/gitlab/-/commit/77083af5168dbf0b9ccbee1cb2c3fe74270b7b3c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180174))
- [Display the correct Direct Connections value in Duo admin page](https://gitlab.com/gitlab-org/gitlab/-/commit/c961b96c366156112dd94bfae75d5cd935a256ae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180653)) **GitLab Enterprise Edition**
- [Add conditional operation for system note](https://gitlab.com/gitlab-org/gitlab/-/commit/bdbd6cd3ddb56e3891e928dbca5c459beb548533) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180652))
- [Exclude file upload trigger from closing drawer](https://gitlab.com/gitlab-org/gitlab/-/commit/8df532e9399c7dfe16077bcd2da9f1bb02c8f343) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180614))
- [Send additional params to getBlobSearchCountQuery](https://gitlab.com/gitlab-org/gitlab/-/commit/77848b97386313e38c729856a98b44ec0396a2dd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180584)) **GitLab Enterprise Edition**
- [Ignore database policies check for enforcing SEP](https://gitlab.com/gitlab-org/gitlab/-/commit/376afd4a9d416daf1e943ef3425f4fc0aeb61d3e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180572)) **GitLab Enterprise Edition**
- [Fix scrolling to clipped file browser items](https://gitlab.com/gitlab-org/gitlab/-/commit/b14e81b24cc5e08d75c017154f26afd475926f66) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180501))
- [Fix dependency proxy with some object storage providers](https://gitlab.com/gitlab-org/gitlab/-/commit/722885885103561fc3f9ed21669cc3a8e1e4234c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180493))
- [Fix button name](https://gitlab.com/gitlab-org/gitlab/-/commit/f2f65baa33d80d2600e9810f20f53fa030c8e4d2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180505))
- [Return false for pending_migrations? if indexing disabled](https://gitlab.com/gitlab-org/gitlab/-/commit/9f835ae08d0fe1b129ded874cb01d36468eb3676) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179873)) **GitLab Enterprise Edition**
- [Add aria-label to delete project modal](https://gitlab.com/gitlab-org/gitlab/-/commit/67a23dae4796fd0c0ef979becd946f05c43f221b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179904))
- [Capture enter & tab in related MR field](https://gitlab.com/gitlab-org/gitlab/-/commit/52462f83600ba15ad97682e9acf81421fc6ffef2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180069)) **GitLab Enterprise Edition**
- [Update topics path for badges](https://gitlab.com/gitlab-org/gitlab/-/commit/79df35daa739ed798bb28f65ebf0be5a25d6b5d0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180439))
- [Add gitRef support for workspaces](https://gitlab.com/gitlab-org/gitlab/-/commit/b5aef619477f050e05e8a31bf7b64ee61a457f25) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177680)) **GitLab Enterprise Edition**
- [Fix compare branches from the fork](https://gitlab.com/gitlab-org/gitlab/-/commit/725438556bfc2b93a119cdcc0ff31ecd391aeeb9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180377))
- [Add ids to a policy actions and rules](https://gitlab.com/gitlab-org/gitlab/-/commit/531d3772c95ebeb44fc1eab91e7cf3bd5559182b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180045)) **GitLab Enterprise Edition**
- [Persist payload attributes of code suggestion events](https://gitlab.com/gitlab-org/gitlab/-/commit/25ee8f327d081add325bd6ebe7a5022f956aa5ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179285)) **GitLab Enterprise Edition**
- [Fixes Restricted access  gitlab.com bugs](https://gitlab.com/gitlab-org/gitlab/-/commit/86a1ef6d14c2135c6ac5dcc39f6087eb9f5bacb7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180167)) **GitLab Enterprise Edition**
- [Improve error-handling when editing blobs](https://gitlab.com/gitlab-org/gitlab/-/commit/999e6f87acf97d6567285d765f3a100ed767883b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178994))
- [Fix epic creation when instance templates are set](https://gitlab.com/gitlab-org/gitlab/-/commit/51a9d63250077c5f189d8b4e904c5a6134aa1b9b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179354)) **GitLab Enterprise Edition**
- [Fix Duo Chat getting slower by message increase](https://gitlab.com/gitlab-org/gitlab/-/commit/bce50800a52720cc322d08e896854813864d5e1a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180157)) **GitLab Enterprise Edition**
- [Fix QueryCanceled error in PersistSecurityPoliciesWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/5848e6683ea05beb02d8da791722d7859132432b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179600)) **GitLab Enterprise Edition**
- [Fix SecurityPolicyDefault to work with mr pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/14b774ef3fc2606ed600362c128d7936a77f8c45) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179614)) **GitLab Enterprise Edition**
- [Add aria-label to single file editor search input for accessible name](https://gitlab.com/gitlab-org/gitlab/-/commit/d502021f90d1cfedcd349c26aec527c1df240754) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179953))
- [Add comment to cache when submitting a comment on a work item](https://gitlab.com/gitlab-org/gitlab/-/commit/4700e414f53439e63021e20f6982609d3c02c01a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180268))
- [Improve Value Stream Analytics path navigation accessibility](https://gitlab.com/gitlab-org/gitlab/-/commit/c3f657d4fe802113161cb7ecaa166d02ed2c1f6d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179110)) **GitLab Enterprise Edition**
- [Fix calculation of owner project when project runner is assigned](https://gitlab.com/gitlab-org/gitlab/-/commit/323f41d1f62523e294709183c300182de54d8613) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180264))
- [MLOps run with no metrics with step results in failed display](https://gitlab.com/gitlab-org/gitlab/-/commit/f8db332da32c570e417e1e1c836960a8dfd873f3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180182))
- [Fix find file on blame page](https://gitlab.com/gitlab-org/gitlab/-/commit/895521414fdcdfa43685ffc4ce7ade171832e6fe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180127))
- [Update pipeline graph](https://gitlab.com/gitlab-org/gitlab/-/commit/8a3be768ec8fa1efa32b1bc70e0fbf87ceb732cf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178645))
- [Dismiss value stream created/updated success alert upon its deletion](https://gitlab.com/gitlab-org/gitlab/-/commit/e218bee31df078c89f9bad81bc217deebb5310a8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179770)) **GitLab Enterprise Edition**
- [Fix GQL Error on accessing Job Token Authentication log](https://gitlab.com/gitlab-org/gitlab/-/commit/f5fc5e8308972d365760722aa9d893269b6f4553) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178401))
- [Remove jobs_api_use_primary_to_authenticate feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/bc8add8c936aacb800a44f305d908923790da7d4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179772))
- [Fix Ctrl+k command palette keyboard shortcut](https://gitlab.com/gitlab-org/gitlab/-/commit/34ebf56313da82656d958385dd3b60bcacac5714) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178451))
- [Add a way to present Epics using WorkItem new logic](https://gitlab.com/gitlab-org/gitlab/-/commit/3459be7cc8881451b1bca765954db0feede409ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178363)) **GitLab Enterprise Edition**
- [Use comma-separated IDs for skipping groups](https://gitlab.com/gitlab-org/gitlab/-/commit/3e46fe6938391839e9a173e87994b6f5515f0d3c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179186))
- [Remove graphql_minimal_auth_methods FpF](https://gitlab.com/gitlab-org/gitlab/-/commit/3fcb284f6f9849bb57a9388f46295ef0a1929906) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179940))
- [Display custom permission title](https://gitlab.com/gitlab-org/gitlab/-/commit/feb64da636e12b96de7a4c67443b5790b9c8e9c1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179597)) **GitLab Enterprise Edition**
- [Only check pending migrations if indexing enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/3a673a93e6ab45303b4378c93700cdf6d88fc95b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179300)) **GitLab Enterprise Edition**
- [Remove duplicated controls for narrow viewport](https://gitlab.com/gitlab-org/gitlab/-/commit/21efc44a289d4d5f82d0c587d21331f0bef27711) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179057))
- [Fix the exact code search](https://gitlab.com/gitlab-org/gitlab/-/commit/760f54ac4888e1cda8762392eb5e36914b072860) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179268)) **GitLab Enterprise Edition**
- [Fix "Edit single file" option for empty files](https://gitlab.com/gitlab-org/gitlab/-/commit/bc8e6917681da411b7cc28ac6af159b17008633a) by @sahilsarawagi ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179370))
- [Redirect group searches when SSO enabled and expired](https://gitlab.com/gitlab-org/gitlab/-/commit/0f720784a9c55efaf42afebbb785a1d6fa0c738a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179104)) **GitLab Enterprise Edition**
- [Fix storing incorrect policy index in scan_result_policies](https://gitlab.com/gitlab-org/gitlab/-/commit/77fc1e014a36df6e9507a4774ab5f7dc1d804513) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179860)) **GitLab Enterprise Edition**
- [MR actions: Fix alignment and responsive behavior](https://gitlab.com/gitlab-org/gitlab/-/commit/d572003c76781491dbdbcc683b4caa52cff7d3a7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179828))
- [Include SEP jobs with overriding PEPs](https://gitlab.com/gitlab-org/gitlab/-/commit/f03326873cb7146be5ef43fe740ff5761d7ca04a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179366)) **GitLab Enterprise Edition**
- [Fix todos for user mentions in wiki page comments](https://gitlab.com/gitlab-org/gitlab/-/commit/6abf9064e91a59ad5ee0c029b469f70da648f4f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178583))
- [Add missing `hasParent` to Hierarchy widget definition](https://gitlab.com/gitlab-org/gitlab/-/commit/2949213c79e1ae6e1688823d02a1e0ff2eac0204) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178969)) **GitLab Enterprise Edition**
- [Ensure dropdown toggle has accessible text on work item create MR button](https://gitlab.com/gitlab-org/gitlab/-/commit/0f524345df92960b4e8d1ae34248a1b69907d3c1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179756))
- [Decrease inline button min-height in merge conflict page](https://gitlab.com/gitlab-org/gitlab/-/commit/34ab1be28de3fef3c15d524bd60680fa3b740e8c) by @mschoenlaub ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178959))
- [Enable submit buttons](https://gitlab.com/gitlab-org/gitlab/-/commit/fca494462ff5d9a5fb1fee1d265215792aedfc88) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179315)) **GitLab Enterprise Edition**
- [Fix MergeRequestsComplianceViolations not null migrations](https://gitlab.com/gitlab-org/gitlab/-/commit/8eed879311a068fb0cae5f9f3cc107c5aad454ed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179567))
- [Allow user to have only 1 admin member role](https://gitlab.com/gitlab-org/gitlab/-/commit/d6de3ddd969b5162cd65bfc7a415c006f4b0664a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179528))
- [Removed coverage check learn more link](https://gitlab.com/gitlab-org/gitlab/-/commit/75404e5b7fee97a3488cd91c9d67d995bbfe1042) by @peterhdangg ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179162)) **GitLab Enterprise Edition**
- [Add a post deploment migration fixing the scim data](https://gitlab.com/gitlab-org/gitlab/-/commit/97afa60e8bc7854500ef48ded08131de13d9b244) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178326))
- [Update error message for validation errors of slugs](https://gitlab.com/gitlab-org/gitlab/-/commit/63911c2b00720f491628d3814083de3aac5f11e1) by @schurzi ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179178))
- [Fix a11y issue for new todos dashboard](https://gitlab.com/gitlab-org/gitlab/-/commit/84b796a15b9c3f607c9b1cd8cd750e80e7cceca3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178737))
- [Model Registry: Fix default_experiment path](https://gitlab.com/gitlab-org/gitlab/-/commit/6d007a5a36b776d99a8809d4d38e468b1825b9e7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179387))
- [Fix CI_RUNNER_TAGS regression](https://gitlab.com/gitlab-org/gitlab/-/commit/f39af4c70d1237010ccdee30b3612b938a27c002) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179671))
- [Fix API logging of JSON float/boolean param values](https://gitlab.com/gitlab-org/gitlab/-/commit/1c822c03a031bb907fed8fa5e8c924618c676ff5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179659))
- [Filter out SAML projects when SAML session has expired](https://gitlab.com/gitlab-org/gitlab/-/commit/f932a3506b2d2f37e1b71971a93f44f662c9d8fc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179650)) **GitLab Enterprise Edition**
- [Filter out SAML projects when SAML session has expired](https://gitlab.com/gitlab-org/gitlab/-/commit/f8b50e46e824731a9c6b0357686026b49e31a9db) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179651)) **GitLab Enterprise Edition**
- [Add alert when global search and logged out groups exist](https://gitlab.com/gitlab-org/gitlab/-/commit/87fd2d66256a6af49000577741ac3a08c19dabe8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179114)) **GitLab Enterprise Edition**
- [Filter out SAML projects when SAML session has expired](https://gitlab.com/gitlab-org/gitlab/-/commit/32f8e5f02f0cf7a22bbdd4ad551069e20d2a8f81) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179111)) **GitLab Enterprise Edition**
- [Ensure file tree table has row headers](https://gitlab.com/gitlab-org/gitlab/-/commit/d3503c72e32f2c1e756fe0a6d0e240aae3f8c770) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179123))
- [Fix commit length](https://gitlab.com/gitlab-org/gitlab/-/commit/b81d096e62410217aa467cae9414e75bfda05e12) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179584))
- [Tags list: Fix alignment of actions](https://gitlab.com/gitlab-org/gitlab/-/commit/f0e0a46547ba87164966bf7bf23f881e1fe6cbdb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179357))
- [Add role to informative icons for monitor settings](https://gitlab.com/gitlab-org/gitlab/-/commit/588e89f28dd793a2a0242afd2aabd0b6caee2029) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179065))
- [Two-factor quth: Add title to QR Code SVG](https://gitlab.com/gitlab-org/gitlab/-/commit/e324552600a5da75cd35db6628f29c090288d1c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179030))
- [Add work item title and description in draft](https://gitlab.com/gitlab-org/gitlab/-/commit/f76b559e13432cb3910b1885e9208c05eb418d9b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179475))
- [Fixed invalid states for custom stage fields in VSA settings form](https://gitlab.com/gitlab-org/gitlab/-/commit/2e9a48e1c74fec7056ae2bdf073c454613df3721) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178962)) **GitLab Enterprise Edition**
- [Use proper HTML semantics in shortcuts modal window](https://gitlab.com/gitlab-org/gitlab/-/commit/e68ba40da7823344d8b5d55a5c541f766aa64d6c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179456))
- [Avoid hard-coding test integer](https://gitlab.com/gitlab-org/gitlab/-/commit/e35e7f95e3fedd188a07f9c4f8bdce3da7370636) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178820))
- [Only show re-request review button to users who have permission](https://gitlab.com/gitlab-org/gitlab/-/commit/86d8caf0c6d0404759f9e4b4fa251c7637562548) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179442)) **GitLab Enterprise Edition**
- [Wrap devops table help icon with `gl-button`](https://gitlab.com/gitlab-org/gitlab/-/commit/49fb985503a1cfc5fd314ecadf69f45fde479aac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178955)) **GitLab Enterprise Edition**
- [Fix loading pipeline execution policies with missing project](https://gitlab.com/gitlab-org/gitlab/-/commit/942db7605235f49ea5e83da7fd59051b19ee633b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177876)) **GitLab Enterprise Edition**
- [Fix bug with contacts autocomplete checking root group not CRM group](https://gitlab.com/gitlab-org/gitlab/-/commit/483e9b6ad3d82cd350f223ada99e980222b2e8b7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179415))
- [Uses billable or nonbillable trait for  member roles](https://gitlab.com/gitlab-org/gitlab/-/commit/1cdc43bdbaa41c76abe9708c5cef2761d1fe2ce7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179400)) **GitLab Enterprise Edition**
- [Hide comment template button in work item description](https://gitlab.com/gitlab-org/gitlab/-/commit/089fc806c4d0d3e9ee889919bce411f7ccb0fd09) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178607))
- [Update to use `gl-button` instead of `gl-icon` in `visibility-icon`](https://gitlab.com/gitlab-org/gitlab/-/commit/5c8e79d601c8a3a7b1a3c8590ad17a1ca6602180) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179102)) **GitLab Enterprise Edition**
- [Remove exclude_child_pipelines_from_tag_branch_query feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/94cc6562bd9390fbb2eaaff72a4abf024580f6f5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162308))
- [Fix category of collapsed issue sidebar notification button](https://gitlab.com/gitlab-org/gitlab/-/commit/a583d5b86c1c02f520a8a488d8928af162d9e331) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178907))
- [Rescue timeout errors in GeoNodeStatus metrics queries](https://gitlab.com/gitlab-org/gitlab/-/commit/76201b66b96956e90bbb4f09f477fb1c777a2776) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177100)) **GitLab Enterprise Edition**
- [Use primary DB when authenticating via job token in jobs API](https://gitlab.com/gitlab-org/gitlab/-/commit/61e5ce682e5d979d36d005663db20e81462771bb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179189))
- [Skip scheduling service cache if no period is provided](https://gitlab.com/gitlab-org/gitlab/-/commit/99dea4b34308aab407a8216f84257d731fff0ddb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179259)) **GitLab Enterprise Edition**
- [Fix resource_tokens page in credentials](https://gitlab.com/gitlab-org/gitlab/-/commit/f3941e3293040803a426f4cb12d0db8c76551a57) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177268)) **GitLab Enterprise Edition**
- [Fix pages multiple deployments limit for forgotten plans](https://gitlab.com/gitlab-org/gitlab/-/commit/e6313a1dac35c9c5d75c5139cdb96cd4e33cf87a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179280))
- [Take scrollbar width into account when calculating collapsed sidebar](https://gitlab.com/gitlab-org/gitlab/-/commit/c7870c67547251714c4d00ae32912554498bba8b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178913))
- [Use `canUpdate` policy to control close button visibility](https://gitlab.com/gitlab-org/gitlab/-/commit/1283da06cc020728ba8f07a057a22abbf90bcb25) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179113))
- [Work items design management: Fix alignment](https://gitlab.com/gitlab-org/gitlab/-/commit/10b01e7877c62bb3f787c9a1c9aeb0aca4148a81) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179245))
- [Update validations for pipeline removal](https://gitlab.com/gitlab-org/gitlab/-/commit/d52ae45616ba4c2a69039ac838deb805e9cf2061) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179241))
- [Localize type names in work item create form](https://gitlab.com/gitlab-org/gitlab/-/commit/c04746ccb148e134b9bb37c98173bdabd4d7f47e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178891))
- [Fix NoMethodError when quick action users are not set](https://gitlab.com/gitlab-org/gitlab/-/commit/9461e6e9c50336cb1b12d03b1174b6c841129985) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179208))
- [Fix routing for projects with dots in catalog](https://gitlab.com/gitlab-org/gitlab/-/commit/31c5b6f06a02c5570962a4bab92a3d6e6766232d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178420))
- [Update project settings approval widget](https://gitlab.com/gitlab-org/gitlab/-/commit/cfd0b0de1fbbf3c8ee0fefadb0ba005ed88e3014) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179161)) **GitLab Enterprise Edition**
- [Skip cyclonedx report when its type is set to](https://gitlab.com/gitlab-org/gitlab/-/commit/e487d0c107698b6ff89c8c4893d57a2448a5da00) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179070)) **GitLab Enterprise Edition**
- [Ensure DevOps Reports tables have row headers](https://gitlab.com/gitlab-org/gitlab/-/commit/7efd4af79515d00adeebc47a5d578bbeb8aea5fb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179126)) **GitLab Enterprise Edition**
- [Ensure admin subscripton page tables have row headers](https://gitlab.com/gitlab-org/gitlab/-/commit/9749ae55259c8bc771ecd76ee62b4443c9027884) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179116))
- [Ensure Admin users table has appropriate row headers](https://gitlab.com/gitlab-org/gitlab/-/commit/1db7b541f1761cd1baaa7efd32131abd37eafe30) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179118))
- [Ensure PAT table rows have a row header](https://gitlab.com/gitlab-org/gitlab/-/commit/17b50450c318748cf77f6b7c384c541924e9edf1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179121))
- [Add labels to color picker inputs in user preferences](https://gitlab.com/gitlab-org/gitlab/-/commit/1aa51c9d4ab40e0f7d6500dea050582378455e71) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179134))
- [Ensure Kubernetes cluster table rows have row headers](https://gitlab.com/gitlab-org/gitlab/-/commit/b8bc8242dce645a4a49ed85224f58ae77656d4ac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179127))
- [Ensure Job cell is the row header for Jobs table](https://gitlab.com/gitlab-org/gitlab/-/commit/a79966ace7f6aaf11a428f793d0487529d826064) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179120))
- [Ensure board move to top/bottom buttons have role](https://gitlab.com/gitlab-org/gitlab/-/commit/97f0dc0ff75b324d0238239630c9198a22a251d9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179109))
- [Update to use `gl-button` for feature flag description info](https://gitlab.com/gitlab-org/gitlab/-/commit/f0ad03c6d1c15e56672f008f1a13680394ca80ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179108))
- [Fix review/draft notes using only quick actions](https://gitlab.com/gitlab-org/gitlab/-/commit/50d3453096d7b9ff3798a853ddd1f67964e94dcc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174028))
- [Fix alignment of user profile info](https://gitlab.com/gitlab-org/gitlab/-/commit/ce642707942e63e34e9500cc7cc76cddf4931fa1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178768))
- [Editor toolbar: Add role and aria-label](https://gitlab.com/gitlab-org/gitlab/-/commit/97ed86f942b66d26d42ccbc7d16b82f03b4b377d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179086))
- [Pass schedule param to execution policy pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/e24bc594a778e41c9e19897a3c97acfa4759eac2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179078)) **GitLab Enterprise Edition**
- [Verification: Add missing id for form label to work](https://gitlab.com/gitlab-org/gitlab/-/commit/2bfdbb9d563f819957a51cb272400ff5ddd4327e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179079))
- [Monitor settings: Fix a11y issue with labels](https://gitlab.com/gitlab-org/gitlab/-/commit/fcd92b637b7c6b69f79fef3772837e82727ed147) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179074))
- [Pages: Adds label to input fields on step 2](https://gitlab.com/gitlab-org/gitlab/-/commit/2b2b610c890da85c7570259f060c346bfd055389) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179064))
- [Design management (legacy): Add aria-label to checkbox](https://gitlab.com/gitlab-org/gitlab/-/commit/5a6e61aceccf862ecbf090d0d7fce70dbba1fb0e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179061))
- [Project acess tokens: Fix select label for attribute value](https://gitlab.com/gitlab-org/gitlab/-/commit/fc43934a1f243811c8d15d5b60bb9637b12ae115) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179056))
- [Remove "project_templates_reporter_access" feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/8e3087647e35c1b6fcee99cba66bbeabb9e1e10c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178440))
- [Make sure badges visible for non-admins](https://gitlab.com/gitlab-org/gitlab/-/commit/3d11ac0b813b2011e8307522c26edf03c6cb13f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178615))
- [Content editor: Add missing aria-label](https://gitlab.com/gitlab-org/gitlab/-/commit/c827b0e6c425efb6b638ada70ecd4667de1984c6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179013))
- [Add missing name for disclosure button on group list page](https://gitlab.com/gitlab-org/gitlab/-/commit/679183cb828b65f29464877b4f626b1c6e4a917c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179012))
- [Add missing name for disclosure button](https://gitlab.com/gitlab-org/gitlab/-/commit/980dbd41c9c46b303d07f1caeb9510dcf2e1ae3d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179009))
- [Instance overview: Fix link focus](https://gitlab.com/gitlab-org/gitlab/-/commit/85bf45195f110f7b86db35193982fb3659ad15e2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179003))
- [Fix ActionView::MissingTemplate for CompareController](https://gitlab.com/gitlab-org/gitlab/-/commit/0c7a2daf5b5e17b46ab892876a2cd8e73bb11c1f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179000))
- [Commment user link: Add focus ring](https://gitlab.com/gitlab-org/gitlab/-/commit/e97970a3f48083defdfdafb8ed4f9cba2dc89ec5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178998))
- [Fix intermittent logouts even with remember me](https://gitlab.com/gitlab-org/gitlab/-/commit/7e603e1f1c361707030efbc983f26123c264b7e1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178035))
- [Add missing names for buttons on policies, labels and clusters table](https://gitlab.com/gitlab-org/gitlab/-/commit/5e473df1776113475fbf7d717df7c3255f19f520) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178947))
- [Fix error for anonymous users on Projects::Ml::CandidatesController#show](https://gitlab.com/gitlab-org/gitlab/-/commit/c8386d5d25008c864cc77c87d4c320fd81a12f29) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178127))
- [Finalize deduplication of issuable_resource_links](https://gitlab.com/gitlab-org/gitlab/-/commit/875082b5b5f157a748e1a34e755ffd85270f62cd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173180))
- [Fix memory leak in DiffFile.vue](https://gitlab.com/gitlab-org/gitlab/-/commit/c69eee775a67f6bfdd3fb9d2aaa3a73b36fb673c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178719))
- [Upload large export files outside DB transaction](https://gitlab.com/gitlab-org/gitlab/-/commit/c5ae4fb2d8512a25076c75e204d73166f75be929) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178738)) **GitLab Enterprise Edition**
- [Fixes merge reports section in the widget not being fully hidden](https://gitlab.com/gitlab-org/gitlab/-/commit/2e0d65caf46e85c135bf9707678099fb1c6bbfd6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178704))
- [Add error handling to dependency export creation](https://gitlab.com/gitlab-org/gitlab/-/commit/cbbfccaae5bb063bcc5a696f3b4d01855a335edc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178784)) **GitLab Enterprise Edition**
- [Fixed layout issue on the invite member modal component](https://gitlab.com/gitlab-org/gitlab/-/commit/04c433bcab5a7e4e983434ff2dc01527ae7b3fed) by @zillemarco ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177866))
- [Wrap project card content on small screens](https://gitlab.com/gitlab-org/gitlab/-/commit/cece05e6a4b1a6882269b3f255c936d4f808cd4a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178772))
- [Fix projectAnalytics.aggregate.durationStatistics nil values](https://gitlab.com/gitlab-org/gitlab/-/commit/98796b1a1e88d04734fdadcac4041da31f63e8fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178623))
- [Fix 500 error when tag delete process fails](https://gitlab.com/gitlab-org/gitlab/-/commit/101a88eb94fa3abf19a42f97f8700cebedbb6e08) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178305))
- [Remove useless validations for subgroup settings](https://gitlab.com/gitlab-org/gitlab/-/commit/b091d9c397ee39bff08ff264f6312115c664a5e6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178724))
- [Add static analysis checks for job token policies](https://gitlab.com/gitlab-org/gitlab/-/commit/7671020a737ec7ea2f47315c151c4cd851ac886e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178731))
- [Fix DumpWriteBufferCronWorker with multiple attribute groups](https://gitlab.com/gitlab-org/gitlab/-/commit/948bf45a2f20de092899f94070acccb26d7df3a7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178701)) **GitLab Enterprise Edition**
- [Fix permission issue for On-demand scans](https://gitlab.com/gitlab-org/gitlab/-/commit/407581b35997a9895c726c5c3e90e4ff792e91f6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178546)) **GitLab Enterprise Edition**
- [Fix 500 error when `ciPipelineStage` query has an invalid id](https://gitlab.com/gitlab-org/gitlab/-/commit/3255d75107f3bbc69fabc6c47d3e41f70f6b5bb5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178708))
- [Add db trigger to fill wiki user mention sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/471bdaabf3fa7e61d44d10f53ab27eb1cd0c9c1d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176220))
- [Fix 500 error on unauthenticated audit event](https://gitlab.com/gitlab-org/gitlab/-/commit/d560015f51a2051c97acbcca367c6afcb1dccf79) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177631)) **GitLab Enterprise Edition**
- [Fix vulnerability details header alignment](https://gitlab.com/gitlab-org/gitlab/-/commit/5ecf5a8c43074ecdd2c489a82f678a6cde295a24) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178409)) **GitLab Enterprise Edition**
- [Fix Workhorse failing on 64-bit unaligned access on Raspberry Pi 32-bit](https://gitlab.com/gitlab-org/gitlab/-/commit/a01304965ae462ad33600aac4105d9858a5addd3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178476))
- [Support capitalized response for smart server reply](https://gitlab.com/gitlab-org/gitlab/-/commit/115f07789b4824688d8e8b21a8735f0a409dc75b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178443))
- [Fix nil input in causing SetGroupSecretPushProtectionService to fail](https://gitlab.com/gitlab-org/gitlab/-/commit/1027ae4430f17868ed1d278fc462bb225bcd9126) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178423)) **GitLab Enterprise Edition**
- [Ensure user external attribute is preserved and not null](https://gitlab.com/gitlab-org/gitlab/-/commit/9ed71364e017727777ed85dd6b73b5e5d8d32e1d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177671))
- [Delete scan_result_policy_reads when deleting security policies](https://gitlab.com/gitlab-org/gitlab/-/commit/5cde89d6508d102898d72cd49118cb1e121ac2f3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176183)) **GitLab Enterprise Edition**
- [Use `moveDesign` permission to control design reordering](https://gitlab.com/gitlab-org/gitlab/-/commit/4ce172136250cbaa767c0419750be32600756104) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176695))
- [Fix rescue statement by returning expected value](https://gitlab.com/gitlab-org/gitlab/-/commit/8e1d81a96d51cd13f4e8253ea137129b4f3b0203) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177736))
- [Fix descendant filter for security policies](https://gitlab.com/gitlab-org/gitlab/-/commit/49f21df654dc503b18f60632232688ad36d49cab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176840)) **GitLab Enterprise Edition**
- [Use naive component-based state approach for infinite list](https://gitlab.com/gitlab-org/gitlab/-/commit/0465cbbe0dd01bd394d11246032d9f10937d9587) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178309)) **GitLab Enterprise Edition**
- [Include support_bot comments in MRs to Duo Chat context](https://gitlab.com/gitlab-org/gitlab/-/commit/df7041245d088b35da2dc5d1674e1716567dc516) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178300)) **GitLab Enterprise Edition**
- [Fix weight attribute truncation on related items](https://gitlab.com/gitlab-org/gitlab/-/commit/bce0eb7f967ad2484a3831fe464867ec902dc285) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178289))
- [Fix shared agents list](https://gitlab.com/gitlab-org/gitlab/-/commit/d5c15f048fa79417ca7b3587cdbed141e9140f45) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178220))
- [Fix member role preloaders when IDs are passed instead of objects](https://gitlab.com/gitlab-org/gitlab/-/commit/d809a0e6acff7065b1c48cb4dde4485b67074d6e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178260)) **GitLab Enterprise Edition**
- [Don't show incorrect median value for Overview tab of VSA](https://gitlab.com/gitlab-org/gitlab/-/commit/ccf0986782e1f34507575d8760efa29dc0846677) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177894))
- [Check for admin in remote_mirror_setting_enabled?](https://gitlab.com/gitlab-org/gitlab/-/commit/42070bf85628a37e9f18fe88c6af036662efd208) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177351)) **GitLab Enterprise Edition**
- [Fix commit tags badge link text color in dark mode](https://gitlab.com/gitlab-org/gitlab/-/commit/49aebe3a1ff1588476f70fc0b5559ed5c7f01d67) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178241))
- [Prevent guest users from locking issue discussion](https://gitlab.com/gitlab-org/gitlab/-/commit/19549b3273e56559b02afa98b7f63f0d45ec1344) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177498))
- [Fix work item parent reset error on create work item](https://gitlab.com/gitlab-org/gitlab/-/commit/a4911031f8418e9b04893d8c2bfbe929bde757fc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178210))
- [Cloud Connector: Fix health check for dev use case](https://gitlab.com/gitlab-org/gitlab/-/commit/84cb865b890a703d49fe4bb921625078cbdf68e7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178189)) **GitLab Enterprise Edition**
- [Redirect users not in onboarding to root_path](https://gitlab.com/gitlab-org/gitlab/-/commit/71e5567405f0d9fb9a27e4d1329f6351bf7d9943) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177926)) **GitLab Enterprise Edition**
- [Fix text color of rich text suggestion added line text](https://gitlab.com/gitlab-org/gitlab/-/commit/4f8f03971105ad3d05e07d1bbfc6b4d56c29322a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178077))
- [Remove limit of max 5 defined policies from json schema](https://gitlab.com/gitlab-org/gitlab/-/commit/2e98670af2bc0f7285e42770404252b5a434a9b1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177849)) **GitLab Enterprise Edition**
- [Show diff when diff_refs.head_sha has been pruned](https://gitlab.com/gitlab-org/gitlab/-/commit/f5e992a71a1cc1e30f59444bd5923945476cd1ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178082))
- [Fix SCIM revoked identities](https://gitlab.com/gitlab-org/gitlab/-/commit/114a2889409845abf15d2b19d07468d176644d03) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177882)) **GitLab Enterprise Edition**
- [Fix console warning on work items new page](https://gitlab.com/gitlab-org/gitlab/-/commit/222b840246e11f721255aa1d3b5a5646940b853d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177985))
- [Move to-dos actions out of the main link](https://gitlab.com/gitlab-org/gitlab/-/commit/a030702d5e6d8ae2966f9564328b78add2b31706) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177906))
- [GitHub import handle requested_reviewer nil](https://gitlab.com/gitlab-org/gitlab/-/commit/2d9dc9bde00750b843c28fc814e1541460d2b7d8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176929))
- [Fix console error on work item detail page](https://gitlab.com/gitlab-org/gitlab/-/commit/e4272d358a3ca4c000b42c28fcaa7316ce67ecf1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177989))
- [Use UTF-8 encoding for email notifications](https://gitlab.com/gitlab-org/gitlab/-/commit/8f3492a026c9e6bbbdba542ac4e0ab077a9ef7b7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177979))
- [Show diff when diff_refs.head_sha has been pruned](https://gitlab.com/gitlab-org/gitlab/-/commit/556f98c6a0ecf6363f8e868c7971af674bc644b6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177932))
- [Handle case when deployable is nil](https://gitlab.com/gitlab-org/gitlab/-/commit/a68a751a6f9076c5304a105660c3eaa7d130afa5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177862))
- [Apply all filters to flowMetricsQuery](https://gitlab.com/gitlab-org/gitlab/-/commit/0d23535ef9b32a21f012701fe1bddecd6d871b24) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173710))
- [Handle nil `#mapped_user_id` in `SourceUserMapper`](https://gitlab.com/gitlab-org/gitlab/-/commit/f60feb618c7cd230b6209c936ba377e689df2607) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167713))
- [Reset variable visibility on form reset](https://gitlab.com/gitlab-org/gitlab/-/commit/6f6dfcf13fed717c33e637a20c790276dfee3d91) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177925))
- [Fix issue template loading for templates with spaces in names](https://gitlab.com/gitlab-org/gitlab/-/commit/0a422abb7f8da911c0e3d9510c259c806ee3ee8f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177819))
- [Fix merge_after moving on each edit if server timezone is not UTC](https://gitlab.com/gitlab-org/gitlab/-/commit/875e6080e7089e3ecee69a8ff562b9a842cf8f18) by @Taucher2003 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177792))
- [Fix merge request list empty state](https://gitlab.com/gitlab-org/gitlab/-/commit/4717688f581d4e4ea96c06064c69e8be2b9801bd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177790))
- [Resolve vulnerability modal error race condition](https://gitlab.com/gitlab-org/gitlab/-/commit/e5cd80a386b41168804e15c4f1a2d45e60901d4b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177463)) **GitLab Enterprise Edition**
- [Fix error when deleting all optional variables](https://gitlab.com/gitlab-org/gitlab/-/commit/167e3fbf4f12f2751319ce1b1e77fc2ad92604cb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177610)) **GitLab Enterprise Edition**
- [Render code line breaks in vulnerability](https://gitlab.com/gitlab-org/gitlab/-/commit/a1b941e99cda85f119c2d0160dac83d48b6c040b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177592)) **GitLab Enterprise Edition**
- [Fix scroll position while loading comments](https://gitlab.com/gitlab-org/gitlab/-/commit/51abef50387e258e03b17d03f1f0f9010862314b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177432))
- [Prevent guests from locking MR or assigning reviewers](https://gitlab.com/gitlab-org/gitlab/-/commit/837fc32ee2926203b9c95d026aabf1b392cb2b17) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177500))
- [Add H1 to legacy issue edit page for screen reader users](https://gitlab.com/gitlab-org/gitlab/-/commit/6e7c215d9bdb27243433c502c7d57dfa606af442) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177311))
- [Fix HAML rendering](https://gitlab.com/gitlab-org/gitlab/-/commit/d2edd404053b6242441cade901894c3be28d4bdc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174222))

### Changed (273 changes)

- [Adjust import history table row toggle](https://gitlab.com/gitlab-org/gitlab/-/commit/cdb0c96f4742e0a40c35c26590cc374b54a60503) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181324))
- [Add dropdown to load projects for multiple groups](https://gitlab.com/gitlab-org/gitlab/-/commit/4341efde8d8f3f485d0a8d003b577b8db9000b61) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179908)) **GitLab Enterprise Edition**
- [Add db migration for vscode_extension_marketplace](https://gitlab.com/gitlab-org/gitlab/-/commit/6261c4308ecadf59fa4f91b36b1def7318c9011f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181038))
- [Update the latest DS template to use the new DS analyzer](https://gitlab.com/gitlab-org/gitlab/-/commit/bb549cdcba3ad71177654dcb107c87132244ed73) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181546)) **GitLab Enterprise Edition**
- [Remove mark_resolved_vulnerabilities_with_sbom_scans feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/3bae81c1d43c4d7d5163589c2052c751e3662ac6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181556))
- [Apply gl-card styling to code suggestion blocks](https://gitlab.com/gitlab-org/gitlab/-/commit/336cf8f7e193b3924fe73d1b2f7fd5ce7ef08bcb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180032))
- [Move Add to tree control](https://gitlab.com/gitlab-org/gitlab/-/commit/d3cf7b34544d74e8bf25d99dd7a7fa3d5db4e548) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180951))
- [Improve accessibility for project and commit views](https://gitlab.com/gitlab-org/gitlab/-/commit/5e8351225e39788128f75adee48b4d9dd81a1eba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181287))
- [Pass interface and client information to AI Gateway](https://gitlab.com/gitlab-org/gitlab/-/commit/8b6277e4376b9565607a791371f38570eb8abade) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181351)) **GitLab Enterprise Edition**
- [Fix 500 error on IP restrictions when checking snippets](https://gitlab.com/gitlab-org/gitlab/-/commit/5ad5acc6cc64eead987a113d20265ca1f033caaf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180331)) **GitLab Enterprise Edition**
- [Update the CI templates for DS to use the new DS analyzer](https://gitlab.com/gitlab-org/gitlab/-/commit/b929fca32a1664abd50982bed666f9e816950081) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178065)) **GitLab Enterprise Edition**
- [Change new github project error message](https://gitlab.com/gitlab-org/gitlab/-/commit/4505a22a99cbc982e72d0d5e0a3e36ee1ba3dca7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180398)) **GitLab Enterprise Edition**
- [Migrate model experiments listing page to graphql](https://gitlab.com/gitlab-org/gitlab/-/commit/57fb55a1c6ec83c52fb854b173fd5d60a5baeff7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179227))
- [Improve invalid owners detection in CODEOWNERS](https://gitlab.com/gitlab-org/gitlab/-/commit/3232479ca81628d0b47c4a269516056d7207e329) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180936)) **GitLab Enterprise Edition**
- [Link custom software license to software license policies](https://gitlab.com/gitlab-org/gitlab/-/commit/2d76c9f19f4d98a388f1439d0413ae79f0026d14) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180958)) **GitLab Enterprise Edition**
- [Admin Token API: Revoke Incoming Email Tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/20b24a6b20c1efe70ef4d422facdc00916f313f6) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180763))
- [Call MarkAsResolvedService after an SBOM security scan](https://gitlab.com/gitlab-org/gitlab/-/commit/84f7e9b86d27ac44559a3dc88d8e79175c103ef7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179119)) **GitLab Enterprise Edition**
- [Show a visual when the environment is in the stopping state](https://gitlab.com/gitlab-org/gitlab/-/commit/2bea53abb3e7d23e8498dd48d377d96cd67d27b8) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179981))
- [Consider user permissions when validating Code Owners](https://gitlab.com/gitlab-org/gitlab/-/commit/cb8de9cab36618b63717d354d2e37379ace939a3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179310)) **GitLab Enterprise Edition**
- [Add v2 approval rule table and model](https://gitlab.com/gitlab-org/gitlab/-/commit/ff11799500d08e8973f30cc1631747db6c85d11b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179839)) **GitLab Enterprise Edition**
- [Document inject_policy strategy for pipeline execution policies](https://gitlab.com/gitlab-org/gitlab/-/commit/b6df56a570ce5b9eb4bcb8f12721883dc84c6d37) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180753))
- [Fix Pages CI Variables](https://gitlab.com/gitlab-org/gitlab/-/commit/7a921eed857f485162cd6963524c18c09a6541ed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180697)) **GitLab Enterprise Edition**
- [Cloud Connector: Expose keys from database](https://gitlab.com/gitlab-org/gitlab/-/commit/ae993b45782688be5a1c7936caa3013ff33fb91d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180385)) **GitLab Enterprise Edition**
- [Prevent user from downloading empty CSV](https://gitlab.com/gitlab-org/gitlab/-/commit/f13ab0d87ebf9e40bcb7453547c6d97ed6122d9f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178750))
- [Zoekt: Rollout the zoekt_reemit_events FF](https://gitlab.com/gitlab-org/gitlab/-/commit/83ba2346fa9bbf78443172a9f73363ad7802e5d8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181236)) **GitLab Enterprise Edition**
- [Remove unnecessary codes](https://gitlab.com/gitlab-org/gitlab/-/commit/517c561f0d96265fe70aad4857329c0cadb863ea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181235)) **GitLab Enterprise Edition**
- [Remove loose_foreign_keys_for_polymorphic_associations FF](https://gitlab.com/gitlab-org/gitlab/-/commit/2fcaa2f0ef87b9e4f037abc42012a5891b8b39f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181230)) **GitLab Enterprise Edition**
- [Removed feature flag search_mr_filter_source_branch](https://gitlab.com/gitlab-org/gitlab/-/commit/63085168dc34ddd2f7cb8e724882a5fce98ce37a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180254)) **GitLab Enterprise Edition**
- [Change label ID field type to Types::GlobalIDType[::Label]](https://gitlab.com/gitlab-org/gitlab/-/commit/58f9bf93f8a05212089952ec746c97125d4650e5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180861))
- [Update squash options update mutation to support all branches rules](https://gitlab.com/gitlab-org/gitlab/-/commit/d032aa51232ea99473a39e618b67abe631f78cab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181197))
- [Remove claude_3_5_sonnet_20241022_for_code_gen feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/bb1c6002aa72b324611cd4c9fd8f4fb082a1c42e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181171))
- [Update links to full docs URLs to skip index](https://gitlab.com/gitlab-org/gitlab/-/commit/52ddf2df64cc7581fa8a512ca2c96e64135b079b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180890))
- [Update comment to be mandatory in bulk severity override mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/7940c4755222436ac92e381a7575d251a0f192f2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180856)) **GitLab Enterprise Edition**
- [Update links to full docs URLs to skip index](https://gitlab.com/gitlab-org/gitlab/-/commit/8b443ae2b89990b015616a5715ede5ff2fc73ef6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180877))
- [Add import history table destination formatter](https://gitlab.com/gitlab-org/gitlab/-/commit/9fa2503be6091a70b6758b18c323a6f2deac6c11) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181139))
- [Documentation changes for rename prsd to spp](https://gitlab.com/gitlab-org/gitlab/-/commit/900367780a0937cc867bd0495e4b00623114997c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179768))
- [Add import history table row and header container components](https://gitlab.com/gitlab-org/gitlab/-/commit/10c21c32bfb29140ba566300e4f7c4a2f3ea61d3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181133))
- [Rename index files in application security docs](https://gitlab.com/gitlab-org/gitlab/-/commit/38ad6c3c83f6fe0ae5effda4705a80cea0a9be4f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180670))
- [Allow shortcuts to remove markdown](https://gitlab.com/gitlab-org/gitlab/-/commit/56a5da78b1e8a9d5d289bf8dbcba33190decbfd4) by @Bubbis ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178466))
- [Import group: Migrate components used](https://gitlab.com/gitlab-org/gitlab/-/commit/860d84886f5d409dcc451eaa43f8455f2a16ebf4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180376))
- [Import groups by direct transfer: Cleanup interface](https://gitlab.com/gitlab-org/gitlab/-/commit/5fa416018ba93d7fc1b322c3a46287c396046a63) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180534))
- [Use work item epic-issue adapter by default](https://gitlab.com/gitlab-org/gitlab/-/commit/18b013c0e78f38919145837ea1cac6748d44253c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179457)) **GitLab Enterprise Edition**
- [Automatically update subsequent ordered lines in plain markdown editor](https://gitlab.com/gitlab-org/gitlab/-/commit/840b52b736faf3d2057ce735d43a0a75ac5ebca7) by @Bubbis ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179924))
- [Disallow project runners from being unassigned from owner](https://gitlab.com/gitlab-org/gitlab/-/commit/7e12e9e35cc733f19219766b1f74593fbcced459) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180368))
- [Update links to full docs URLs to skip index](https://gitlab.com/gitlab-org/gitlab/-/commit/794d4d9acb46c5fc0e6bc822339f3fea9bb4da21) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180891))
- [Improve error messages for custom stage fields in VSA settings form](https://gitlab.com/gitlab-org/gitlab/-/commit/e06abb354bb3fe08b3e3af186e4ff79e4baf242c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180628)) **GitLab Enterprise Edition**
- [Change user ID field type to Types::GlobalIDType[::User]](https://gitlab.com/gitlab-org/gitlab/-/commit/09ef044849ab1b23292f9342f21c665df1e37b0b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180901))
- [Add an explanation why the CI variable value cannot be masked](https://gitlab.com/gitlab-org/gitlab/-/commit/1e5f1c32c0df6886828bdaab70fe6192f7862fb1) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180778))
- [Change repository controls into a dropdown](https://gitlab.com/gitlab-org/gitlab/-/commit/1fef76663f6fbeb3b7dbfb29c9434d6b50894bc4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179713))
- [Update error message for `needs` CI keyword](https://gitlab.com/gitlab-org/gitlab/-/commit/efafa546b5c3d30d67207dbc523e7bb696bb1088) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180411))
- [Move the troubleshoot button to a sticky footer](https://gitlab.com/gitlab-org/gitlab/-/commit/274323e5558ddbb6e1883c53785113ba1226e93e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179599))
- [Handle ghost users consistently](https://gitlab.com/gitlab-org/gitlab/-/commit/b4a2a3e4cd473e041a87d0de04cc20f32ef42b59) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179829))
- [Update sort labels to be consistent across groups and projects](https://gitlab.com/gitlab-org/gitlab/-/commit/96a6229dfe0fe860cfb0dc69b69a0288d057e855) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180971))
- [Store recently delete billable members to ease the sync up](https://gitlab.com/gitlab-org/gitlab/-/commit/6aedb357a5c9c5d7f4503023d6819ee1fe8d998e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179497)) **GitLab Enterprise Edition**
- [Cleanup left over cross-db suppressions](https://gitlab.com/gitlab-org/gitlab/-/commit/9400bef33e7a70fda7912415da62dd234a705336) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180156)) **GitLab Enterprise Edition**
- [Default-enable security policy project deletion prevention](https://gitlab.com/gitlab-org/gitlab/-/commit/acf2eda151ecc2440a89949068aff2e05cdaaa7d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180919)) **GitLab Enterprise Edition**
- [Update links to full docs URLs to skip index](https://gitlab.com/gitlab-org/gitlab/-/commit/fbbd7ddb1ba1121ffbe6ebd9a20e9a492c5c19de) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180872))
- [Rename index files for user/group clusters and contribution_analytics](https://gitlab.com/gitlab-org/gitlab/-/commit/c233d986b6ad614addd286880964c2d5592266df) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180862))
- [Update CI_JOB_TOKEN JWT payload](https://gitlab.com/gitlab-org/gitlab/-/commit/7ff6775c4a8e75a2e82d1c71fb698e65c4cb99cd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179710))
- [Add the ability to download compliance frameworks](https://gitlab.com/gitlab-org/gitlab/-/commit/5f1d1eeb548779a4c30e0512b8591c52e52c5762) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179588)) **GitLab Enterprise Edition**
- [Add GET /projects/:id/remote_mirrors/:mirror_id/public_key API endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/b2e4e6ed8aba5cfd4daca37f66fc0630222cf43e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180291))
- [Enhance resilience of single relation import Sidekiq worker](https://gitlab.com/gitlab-org/gitlab/-/commit/c60a86b76da83ff94ea925dcb19299dd7189867a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180780))
- [Do not drill props to BlobButtonGroup](https://gitlab.com/gitlab-org/gitlab/-/commit/c5af509ef855a555c498795de49d4ddafd30503f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180228)) **GitLab Enterprise Edition**
- [Rename index files for Hugo migration](https://gitlab.com/gitlab-org/gitlab/-/commit/eb4ebf62e45b7032f2ca3cc781f0e94a24dc1bc7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180702))
- [Remove codeowner_role_approvers ff](https://gitlab.com/gitlab-org/gitlab/-/commit/5a184e9cab71b9718bd6ccde720bc793fc70baeb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180213)) **GitLab Enterprise Edition**
- [Advanced search: Cleanup sections](https://gitlab.com/gitlab-org/gitlab/-/commit/be83f3f4bb5eeb958ab81371b4bfda2bc9012312) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180528))
- [Zoekt: Update dot_com_rollout task](https://gitlab.com/gitlab-org/gitlab/-/commit/60badd1dabce96f76f3a8c6c888f29bb56b3c966) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180250)) **GitLab Enterprise Edition**
- [Rename index.md to _index.md for compatibility with docs-gitlab-com](https://gitlab.com/gitlab-org/gitlab/-/commit/2fbc794ac4b80280259083d17bff7a2ab44626af) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180660))
- [Rename index.md to _index.md for compatibility with docs-gitlab-com](https://gitlab.com/gitlab-org/gitlab/-/commit/97ee7b1468c4efc6e3179bc1ed674cb1030195df) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180656))
- [Rename index.md to _index.md for compatibility with docs-gitlab-com](https://gitlab.com/gitlab-org/gitlab/-/commit/67be33ed902a1b2bfcbff95ee900cd465b45967c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180636))
- [Restructures code coverage doc and incorporates test coverage viz doc](https://gitlab.com/gitlab-org/gitlab/-/commit/011ef1ecb20dab2361aed524fb79e97a1403636d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179914))
- [Rename index.md to _index.md for compatibility with docs-gitlab-com](https://gitlab.com/gitlab-org/gitlab/-/commit/54e5990d20fcd2f1794213957825bc6f0ae31887) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180633))
- [Rename from index.md to _index.md](https://gitlab.com/gitlab-org/gitlab/-/commit/3dac072e0ca276cc1140cffb4a14a0f64a4d9fbc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180591))
- [Update pages service](https://gitlab.com/gitlab-org/gitlab/-/commit/3d308fff32ac822da8a44ad2a54dc582d9e74052) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172950))
- [Update create pipeline mutation to use GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/dbee4e48eda3f5746bdcf2ed4aa9cdcb879ea332) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176728))
- [Add ComplianceFrameworksController for JSON export](https://gitlab.com/gitlab-org/gitlab/-/commit/61d2316255c27bb528552964cadb9a924a6693c1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178817)) **GitLab Enterprise Edition**
- [Change UX flow of license exclude packages](https://gitlab.com/gitlab-org/gitlab/-/commit/29ada8d32f4f89eb4de812e792218dd60caa69f3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180466)) **GitLab Enterprise Edition**
- [Include AllBranchesRules in non-EE branch rules responses](https://gitlab.com/gitlab-org/gitlab/-/commit/b5a86ce83fa7db401eaf7bd4dbdb46739b90ff51) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176815))
- [Remove $registryClass from replicableTypeUpdate mutation in Geo](https://gitlab.com/gitlab-org/gitlab/-/commit/e3c4ef64dfce174dabf7f3fd5368e4b654d95eed) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180635)) **GitLab Enterprise Edition**
- [Create downstream_pipeline_dropdown.vue](https://gitlab.com/gitlab-org/gitlab/-/commit/1a0ffa67bf38c1e924aa814a36b20f15d7bc64e5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180277))
- [Add `cronjob_child` tag to Sidekiq cronjob workers](https://gitlab.com/gitlab-org/gitlab/-/commit/3639ca35760294f2bcbad0fa6e7a9ef6be88ec35) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180595))
- [Add v2 approval rule table and model](https://gitlab.com/gitlab-org/gitlab/-/commit/96b1539ac6107076ee52980ac2f8d4d7a2330abb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179839)) **GitLab Enterprise Edition**
- [Remove fully rolled-out feature flag for Duo Chat conciseness](https://gitlab.com/gitlab-org/gitlab/-/commit/ba07a9681036dee959b796b6af4d98e54d743cc8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179910)) **GitLab Enterprise Edition**
- [Check root namespace for ci_jwt_groups_direct feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/1e0c8792b388dc9d8a7e97459e3cfe0e5bf056a6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180588))
- [Set traversal_ids on vulnerability stat insert](https://gitlab.com/gitlab-org/gitlab/-/commit/3f8da50cd8f7fe0664a8a0947abb06d548ee2a83) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180343)) **GitLab Enterprise Edition**
- [Add more spacing to super-sidebar toggle button](https://gitlab.com/gitlab-org/gitlab/-/commit/c4621410ec633e8c60885164376125443c424f5a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180214))
- [Rename index.md to _index.md for compatibility with docs-gitlab-com](https://gitlab.com/gitlab-org/gitlab/-/commit/619b57d6eb323e9ead10b899a6c2ee837c858235) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180507))
- [Include users from custom roles as MR approvers](https://gitlab.com/gitlab-org/gitlab/-/commit/079feaf0edfce2c08aca2dd4238e5c6472ed736c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176698)) **GitLab Enterprise Edition**
- [Import status: Update component](https://gitlab.com/gitlab-org/gitlab/-/commit/d2b3e933a7b65158b335dcf5a53c2687c4f0e09d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180544))
- [Rename variable and environments index files](https://gitlab.com/gitlab-org/gitlab/-/commit/9ed0a4aa06ab2c5893414cd57055b0fcb1b5f44a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180510))
- [Remove without_archived_projects](https://gitlab.com/gitlab-org/gitlab/-/commit/738d71de0bbb789527037a37f063da00bdcbcb09) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179215)) **GitLab Enterprise Edition**
- [Rename CI YAML index file](https://gitlab.com/gitlab-org/gitlab/-/commit/49252fd68acee80049f32501f1bb79d30789fd92) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180508))
- [Reflow work item buttons](https://gitlab.com/gitlab-org/gitlab/-/commit/8e47f923233534225fd4145d507d1e74b05620f8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180486))
- [Cleanup pages_multiple_versions_setting feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/9a49142e6efc04704c09dc2109c87f985c0e880c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179678))
- [Remove cross-DB modification](https://gitlab.com/gitlab-org/gitlab/-/commit/b9c7c3cdc6496a0e7c08fad67b7b3bb50a134c54) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179578)) **GitLab Enterprise Edition**
- [Expose squash options for all branches rules in free plan](https://gitlab.com/gitlab-org/gitlab/-/commit/9504920e53c7017b10e052b585d23e1583cbaa50) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179248))
- [Topic badge tooltip enhancement](https://gitlab.com/gitlab-org/gitlab/-/commit/fd0523b2732c3b8d4a52e04d807b1e5f997dce91) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180442))
- [Ingest all licenses for components with at least one known license](https://gitlab.com/gitlab-org/gitlab/-/commit/7c8bade68600978bc78278081f0764aeef837776) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179373)) **GitLab Enterprise Edition**
- [Make project visibility icon keyboard focusable](https://gitlab.com/gitlab-org/gitlab/-/commit/6681acbbe2b88df6dd5e73735be4bdbeacf37f8c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179099))
- [Model Experiments: Sort data descending](https://gitlab.com/gitlab-org/gitlab/-/commit/f669f1a1697a9c6638b68f0df9a9c4004b4fa103) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180219))
- [Visibility settings: Migrate to GlCard](https://gitlab.com/gitlab-org/gitlab/-/commit/de457211bac9841f963b860465a005f637f27126) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180168))
- [Remove callback for adding user to default organization](https://gitlab.com/gitlab-org/gitlab/-/commit/f0c081dec9b4cf9a36a95508ed36a26c081f4565) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175288))
- [Permanently enables duplicate exceptions for packages](https://gitlab.com/gitlab-org/gitlab/-/commit/8a2aca920d5d63c9fdc3f8aa67e5245d00ea2a09) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178828))
- [Admin Token API: Reset OAuth Application Secrets](https://gitlab.com/gitlab-org/gitlab/-/commit/6e4b9bb9bec1bf6d9f495f435b268c1bc1fa351a) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179035))
- [Remove feature-flag drop_lease_usage_project_recalculate_workers](https://gitlab.com/gitlab-org/gitlab/-/commit/15dd6082e96c318dfc33696bc401ce3fea137397) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179956))
- [Cleanup bigint conversion for geo_event_log.geo_event_id](https://gitlab.com/gitlab-org/gitlab/-/commit/1436e59b4e28de3251fb9420e32c05cd21c8fa9b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180270))
- [Update text for license rule](https://gitlab.com/gitlab-org/gitlab/-/commit/25f841529e9e0a2db1acfe566ca20601d598743c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180298)) **GitLab Enterprise Edition**
- [Commit: Update page header to use PageHeading component](https://gitlab.com/gitlab-org/gitlab/-/commit/431f5c04379bbd74aac081c59f94b09760bd3321) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179843))
- [Add import history to your work nav bar](https://gitlab.com/gitlab-org/gitlab/-/commit/6a2b9bee919e0aa56968f5ccc771294a0cc2c604) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179752))
- [Fix duplicate emails sent for PrAT and GrAT expiring tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/7b5cfb0a0d985bf0911890ece03daf776158a11f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179774))
- [Enable FF by default for project dependency page](https://gitlab.com/gitlab-org/gitlab/-/commit/97fe90f0d76ad7cff66c2ea409e70c1e09676d4b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180208))
- [Improve UI text for syntax theme selection](https://gitlab.com/gitlab-org/gitlab/-/commit/5c812d26c0299bae424df83656934b504db3bf8a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179316))
- [Move publish to pages.publish](https://gitlab.com/gitlab-org/gitlab/-/commit/e238b973efcd4c821e9e53869e4b68fc356fee55) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178425))
- [Add discernible text to project notifications button](https://gitlab.com/gitlab-org/gitlab/-/commit/73104ef9dda7d199e4f1e6e3af9c5853609e0093) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179088))
- [Use background status warning on matched text](https://gitlab.com/gitlab-org/gitlab/-/commit/a422a79dd8112fd559ae22233c16a3fceac4fdfb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178551))
- [Improve seat controls copy](https://gitlab.com/gitlab-org/gitlab/-/commit/f8456f59de921d453bf27b2f0a3adca70094bf48) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179341)) **GitLab Enterprise Edition**
- [Split microsoft_applications tables](https://gitlab.com/gitlab-org/gitlab/-/commit/c14c6677d9c79728fefcf4b8852070c97a8a5df5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177531)) **GitLab Enterprise Edition**
- [Improve to-do items' styling](https://gitlab.com/gitlab-org/gitlab/-/commit/2213208a98e1fc5e7e2c941dd8a0dd8b94f884d3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179865))
- [Always allow pipeline variables in ondemand_dast_validation pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/4c44be2a1d3457d57f4d8a6f42c6451d1cc15c60) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179903))
- [Increase fileSize threshold for Highlight.js](https://gitlab.com/gitlab-org/gitlab/-/commit/dd783497e650d3c1eee08f2665492e52fd89edc4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179687))
- [Add in-product announcement for legacy IDE removal](https://gitlab.com/gitlab-org/gitlab/-/commit/ae4259a13dc78ae4f591f288841621de4fa062d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179239))
- [Update gitlab-glfm-markdown and prometheus-client-mmap gems](https://gitlab.com/gitlab-org/gitlab/-/commit/8323a4ab49421030e921b2f65281eb03349609df) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179987))
- [Update import page header](https://gitlab.com/gitlab-org/gitlab/-/commit/5f4f7c8f1abdb51cdcc595184c73c8cb67fc155f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178329))
- [Change group SPP feature category to security_testing_configuration](https://gitlab.com/gitlab-org/gitlab/-/commit/51808306d0cf2786b0d8ca3a026421eb77c8cbd8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179800)) **GitLab Enterprise Edition**
- [Add table creator to plain markdown editor](https://gitlab.com/gitlab-org/gitlab/-/commit/411ed41ba97387b51d49dd996344b01b5023c2d6) by @Bubbis ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179150))
- [Load linked to SPP groups](https://gitlab.com/gitlab-org/gitlab/-/commit/9a96403384c04b7b6dcda5a5fa02fa7d12cd4ff4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176899)) **GitLab Enterprise Edition**
- [Remove feature-flag drop_lease_usage_authorized_projects_worker](https://gitlab.com/gitlab-org/gitlab/-/commit/ee9ded971cadb9269be7e07a1a91f080276bc8a0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179957))
- [Add partially disabled mode](https://gitlab.com/gitlab-org/gitlab/-/commit/d6daad196893a5331743d34752b4cec77178c1f2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179576)) **GitLab Enterprise Edition**
- [Refactor limit check](https://gitlab.com/gitlab-org/gitlab/-/commit/2ea8714a2b9157b6db96719090b5e42804a63aa8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179943))
- [Update breadcrumbs to match tabs and view in the Geo replication](https://gitlab.com/gitlab-org/gitlab/-/commit/094febba8a130c5956edc18954d3b755e6a3cd57) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179535)) **GitLab Enterprise Edition**
- [Truncate the project description when it is long in the CI/CD Catalog](https://gitlab.com/gitlab-org/gitlab/-/commit/2a960511fa6c68bdaf9801fe49d3f176f280017d) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179919))
- [Add ordering when updating used storage bytes for zoekt indices](https://gitlab.com/gitlab-org/gitlab/-/commit/24e39810f158f3fbe70aa06bf56ae26c083b563d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179589)) **GitLab Enterprise Edition**
- [Add number formatting to ci minutes limit banner](https://gitlab.com/gitlab-org/gitlab/-/commit/5cc5994a4be39a9562b32c875e92fb4629e99547) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178736)) **GitLab Enterprise Edition**
- [Add sast tooltip and download link](https://gitlab.com/gitlab-org/gitlab/-/commit/133da063848431b465e6aa26533d3c4d4d5219c3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179587))
- [Allow MarkAsResolvedService to scope by report type](https://gitlab.com/gitlab-org/gitlab/-/commit/43f5960c0ffbcad3281ebac1e7374983664b7134) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179117)) **GitLab Enterprise Edition**
- [Update re2 to v2.15.0](https://gitlab.com/gitlab-org/gitlab/-/commit/f2ecf1dc9babfaa44d27846a3fe334bded2c70f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177830))
- [Make file tree and modified icon focusable](https://gitlab.com/gitlab-org/gitlab/-/commit/83147e205945f3a91d96c66ab1a4226c429196dc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179125))
- [Rename seat controls section to singular](https://gitlab.com/gitlab-org/gitlab/-/commit/011daf9a0ec4ff662eae311e209f2ecee96d895e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179821)) **GitLab Enterprise Edition**
- [Rename Sign-up restrictions settings section](https://gitlab.com/gitlab-org/gitlab/-/commit/d6b27dbcbe55e8cbced28bcb619cedf3970518b9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179806)) **GitLab Enterprise Edition**
- [Restrict tag rule ops  when Gitlab API is not supported](https://gitlab.com/gitlab-org/gitlab/-/commit/cca1e6f0a357f281772fb4bcd5c4865cd2d2c566) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178403))
- [Add project_id to DescriptionTemplates & split singular/bulk fields](https://gitlab.com/gitlab-org/gitlab/-/commit/88e566b2302b524f8c270614a67c040a743f81f5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178968)) **GitLab Enterprise Edition**
- [Runner Authentication Tokens: Explain how a token can be resetted](https://gitlab.com/gitlab-org/gitlab/-/commit/68f9f89eda000b71f168f082b5329b3714dd409e) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179568))
- [Sync security policies when protected branch is modified](https://gitlab.com/gitlab-org/gitlab/-/commit/baa80b19ada0713f53ac8e309bb16176364d4c5c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172447)) **GitLab Enterprise Edition**
- [Add linked groups resolver](https://gitlab.com/gitlab-org/gitlab/-/commit/9e86e857c5c885615a54a62745fa8df0df1c1db9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176670)) **GitLab Enterprise Edition**
- [Resolve cross-join in security project statistics](https://gitlab.com/gitlab-org/gitlab/-/commit/e216cf5b19d187d079682687ba7cdd2979615a00) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178886)) **GitLab Enterprise Edition**
- [Update notification to Admin](https://gitlab.com/gitlab-org/gitlab/-/commit/2787651b9d8ec653d851c8cd8fdaa483db674c29) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178135)) **GitLab Enterprise Edition**
- [Pipeline wizard placeholder use design tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/3159309971d08a5813282f315b5eb993363c9e9b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179683))
- [Migrate authored todos to GhostUser](https://gitlab.com/gitlab-org/gitlab/-/commit/aa50e780315cccd9f161950b27f93b37de23f195) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179359))
- [Add discernible text to merge request overview activity sorting button](https://gitlab.com/gitlab-org/gitlab/-/commit/75bae30f1dc949835e03ca8bcda5c9a674929819) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179080))
- [Set vuln stat traversal_ids when setting pipeline](https://gitlab.com/gitlab-org/gitlab/-/commit/5c18882dc6f5796905975c403847eb35fcdc7d6d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179663)) **GitLab Enterprise Edition**
- [Restrict creation of new rules if over maximum](https://gitlab.com/gitlab-org/gitlab/-/commit/66022d3d0e04b12548e3fc449eccd637402730c7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178996))
- [Allow option to do multi node search on zoekt proxy](https://gitlab.com/gitlab-org/gitlab/-/commit/e283f8dc44801de6313792a9e3e1a181bd893937) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171867)) **GitLab Enterprise Edition**
- [Add partially disabled mode](https://gitlab.com/gitlab-org/gitlab/-/commit/a548e1d70447d29a8ede2bc35a68d3b85c0e95e9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179312)) **GitLab Enterprise Edition**
- [Remove feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/e250af6a857eddc16c04353ab4cd03d8203dc54f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178643)) **GitLab Enterprise Edition**
- [Papercuts 17.9](https://gitlab.com/gitlab-org/gitlab/-/commit/6b615d3a0d937b66f7b564cd687ad28c894de58b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178934))
- [Enhance CI/CD variable drawer UI with popovers for help content](https://gitlab.com/gitlab-org/gitlab/-/commit/7d02e593eb57110c7e0943daf1f207dcfb000096) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179531))
- [Enable specifying a semantic element for the CRUD component container](https://gitlab.com/gitlab-org/gitlab/-/commit/2fa74ffb9619bced6a949cd4ca3f5df40cc8731b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179072))
- [Return ids of created vulnerabilities with SBOM scanning](https://gitlab.com/gitlab-org/gitlab/-/commit/e279a1f8b0c53d6042ee2b8da45e35e661d2323f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179115)) **GitLab Enterprise Edition**
- [Add protected tag to the container registry](https://gitlab.com/gitlab-org/gitlab/-/commit/bbe6002d9fe79922bc36c3e526f2018d2aa8ebe4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179130))
- [Do not update target entities if todos change](https://gitlab.com/gitlab-org/gitlab/-/commit/10f68bba4f12ccc129d0e41af77fd2d50a923216) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179421))
- [Refactored non-billable check for Gitlab.com BSO](https://gitlab.com/gitlab-org/gitlab/-/commit/fcdf66930362ee1f3f7b71996dce5cd2c3447e87) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179392)) **GitLab Enterprise Edition**
- [Reduce layout shifts in usage quotas > pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/8f93c9c6ed0319eda268ad04068b0afe968010eb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178274)) **GitLab Enterprise Edition**
- [Integration: Item changes](https://gitlab.com/gitlab-org/gitlab/-/commit/cef357c32e2cdd6dcea082622e4ae0a052a1c8c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178155))
- [Single/Multiple choice component: Update selected and disabled](https://gitlab.com/gitlab-org/gitlab/-/commit/c0c5f54bdaca627985f77d880b4102ba39deb68d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179356))
- [Remove cross-join from namespace historical statistics](https://gitlab.com/gitlab-org/gitlab/-/commit/7f71f082a03f41fd1b87646e63a8bd80f2a6a69d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178899)) **GitLab Enterprise Edition**
- [Fix some RSpec/BeEmpty offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/db5d60c9fa58ef3032ada69f5b6a100c46b08d31) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179355))
- [Use small text for description.](https://gitlab.com/gitlab-org/gitlab/-/commit/f0576eaadeb832d3bc21079023c0775b63adcea1) by @nomad_blaze ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179166))
- [Remove feature flag after globally enbaling](https://gitlab.com/gitlab-org/gitlab/-/commit/d8ac2e35ace131bdf620400bc5ca4547bb1db0ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178748)) **GitLab Enterprise Edition**
- [Update software license policies with custom licenses](https://gitlab.com/gitlab-org/gitlab/-/commit/16f859c9217d3742efdca2b12eccc8f9b16b734d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172406)) **GitLab Enterprise Edition**
- [Show commit SHA in target column of AuditEvents table](https://gitlab.com/gitlab-org/gitlab/-/commit/925d525e518e6f5491098441431b6b095ce3ccaa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175229)) **GitLab Enterprise Edition**
- [Admin Token API: Clarify historic prefixes are only excluded for PATs](https://gitlab.com/gitlab-org/gitlab/-/commit/8ab3749fece8c6341d474494c6c317f056b6d608) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179075))
- [Elaticsearch issue query boost iid by 50](https://gitlab.com/gitlab-org/gitlab/-/commit/9f956a664831cb50ffa79ae8a4c6fa9c5561c9a2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179205)) **GitLab Enterprise Edition**
- [Validate not-null and update sharding key for ci_pipeline_messages](https://gitlab.com/gitlab-org/gitlab/-/commit/871d49f698be95c50a7ae646947ab362c92ad4cb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178397))
- [Compliance framework dropdown order change & style update](https://gitlab.com/gitlab-org/gitlab/-/commit/82684c85088158fa9a3028ad979802749e9fc24f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179192)) **GitLab Enterprise Edition**
- [Finalize backfilling epic work item data](https://gitlab.com/gitlab-org/gitlab/-/commit/77186da82599ee2f9cdbc144682a8e8c1bf159f2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177734))
- [Allow null access levels on rule creation](https://gitlab.com/gitlab-org/gitlab/-/commit/f83db7383cd91442c17b00b8ff05ea1764812744) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179176))
- [Execute pipelines for PEP project schedules](https://gitlab.com/gitlab-org/gitlab/-/commit/6b45bc4310e20b2cbaa3e6a85deb9b840af0d134) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176427)) **GitLab Enterprise Edition**
- [Work item note activity buttons enabled while loading](https://gitlab.com/gitlab-org/gitlab/-/commit/986fe3dccd4fa672d0baecbdba5e7d1a3c4b35e7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178006))
- [Show timeago tooltip on tab](https://gitlab.com/gitlab-org/gitlab/-/commit/ac6f39d9f25b3ef51f56cda52fd9d32ab5e53920) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179105))
- [Add discernible text to network/repository graph search button](https://gitlab.com/gitlab-org/gitlab/-/commit/9efbb580a4c0d4b23fd3aebeb4e14cd4d734d55d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179055))
- [Add label to feature flag instance ID regeneration input](https://gitlab.com/gitlab-org/gitlab/-/commit/45495de42b6f08530d706fc655b4e368f0bab095) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179087))
- [Create and trigger the an event to update the](https://gitlab.com/gitlab-org/gitlab/-/commit/d3ecdaab0c07c47ebb7c057c578937fcc9002f41) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178456)) **GitLab Enterprise Edition**
- [Remove branch_names_sorting feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/a0568da1a4ac74540d4bf91694c6a5bc1d507f87) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178930))
- [Specify username and password required](https://gitlab.com/gitlab-org/gitlab/-/commit/1ca91064941859b678653e7aba6e80be7470de8e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179071))
- [Update dependency @gitlab/web-ide to ^0.0.1-dev-20250110172049](https://gitlab.com/gitlab-org/gitlab/-/commit/e4737b60741600ff4e19b5f71665906b2198b607) by @gitlab-dependency-update-bot ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177778))
- [Update traversal_ids for vulnerability statistic](https://gitlab.com/gitlab-org/gitlab/-/commit/001425af112c9c7d57f251e13b32bce5b6539fb3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178989)) **GitLab Enterprise Edition**
- [Only log elasticsearch metrics if the cluster is red](https://gitlab.com/gitlab-org/gitlab/-/commit/3db51e9ee9c516dfc6c470442ba8796a44937164) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178830)) **GitLab Enterprise Edition**
- [Release create NuGet packages on the fly feature](https://gitlab.com/gitlab-org/gitlab/-/commit/89800fbff272f77bd87bb37312b45671c2751c1d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177868))
- [Allow `max_artifact_size` to be changed via the REST API](https://gitlab.com/gitlab-org/gitlab/-/commit/ba543cede3416ec32aadf81c5c0ba7ea742e8ada) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178343))
- [Integrations detail page: Migrations and small visual fixes](https://gitlab.com/gitlab-org/gitlab/-/commit/7caa2a849c1847177e1cd2b0bbd981c67a65a7c1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178141))
- [Clean up duo_chat_storage_postgresql feature flags](https://gitlab.com/gitlab-org/gitlab/-/commit/4bc93ba4d086fe23287f0cfb18a7b1d0d42964ec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178985)) **GitLab Enterprise Edition**
- [fix: Move call to `AiRelatedSettingsChangedEvent`](https://gitlab.com/gitlab-org/gitlab/-/commit/be7dd579a02145148a45177fe00a37d96c3c8a71) by @yashikajotwani12 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178015)) **GitLab Enterprise Edition**
- [Make new header app default](https://gitlab.com/gitlab-org/gitlab/-/commit/f6524fdd92ad5f6780c47619ff83451ef7532b93) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176182))
- [Clean up PATs::ExpiringWorker extended logging](https://gitlab.com/gitlab-org/gitlab/-/commit/00f537820d5b6bce9a247dc6c9728e2739f9b048) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178918))
- [Clean up `rewrite_history_ui` flag](https://gitlab.com/gitlab-org/gitlab/-/commit/8fa34d7df6f796a5bca25abbef7de69082c26a69) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178746))
- [Add class level config for simple zoekt scheduling service tasks](https://gitlab.com/gitlab-org/gitlab/-/commit/6f70909303f32dbda6531c3921cc2772d2a5819b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178606)) **GitLab Enterprise Edition**
- [Allow access fields on Protection::TagRule to be null](https://gitlab.com/gitlab-org/gitlab/-/commit/9b50aa04af2a406da4dd84161a9a3712fc5a1d05) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178294))
- [Remove move_ai_tracking_to_instrumentation_layer feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/024aa1591ca793a598cdc445212601b5bef252f2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176060))
- [Only claim human users as enterprise](https://gitlab.com/gitlab-org/gitlab/-/commit/1f70379bc5353f9f463ecdea9208d1e22e3c614d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178707)) **GitLab Enterprise Edition**
- [Update skip ci payload](https://gitlab.com/gitlab-org/gitlab/-/commit/f8936bf2a6f4f84adf05df98e3fb693074134ad5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178758)) **GitLab Enterprise Edition**
- [Improve heading hierarchy and accessibility on group import](https://gitlab.com/gitlab-org/gitlab/-/commit/77900b8c87a9e3683074d9de21f0d6112af51171) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178850))
- [Replace '.' character on organization path](https://gitlab.com/gitlab-org/gitlab/-/commit/7cc5261a6e01628c9792a30df292f013506d396f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176942))
- [Update SPDX to 3.26.0](https://gitlab.com/gitlab-org/gitlab/-/commit/1cb95e2b8f439ff2cea29a61d85a01b0a21420f0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178747))
- [Show only folder name and a link to the folder in the environments list](https://gitlab.com/gitlab-org/gitlab/-/commit/6cee7a8a61f69c2afaab23421b0f5f6c24ada905) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178383))
- [Fix counter and remove first/last pages from applications](https://gitlab.com/gitlab-org/gitlab/-/commit/e48fc7cdbf3d2d0b5453e8b780b313217183ac3b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178001))
- [Process repo_to_delete worker in a single batch](https://gitlab.com/gitlab-org/gitlab/-/commit/eed152dcdf7ebeb005a3fcb6be162bc0c60f3493) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177336)) **GitLab Enterprise Edition**
- [Resolve cross-joins from InstanceSecurityDashboard](https://gitlab.com/gitlab-org/gitlab/-/commit/7435dd779418dfd1dcb896cbe25562e822079ca0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178422)) **GitLab Enterprise Edition**
- [Expand publish variables for pages deployment](https://gitlab.com/gitlab-org/gitlab/-/commit/31dde2b6f36abbd2ddbf4f8fd65f58e013459006) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176228))
- [Prevent creation of placeholder users for deleted users](https://gitlab.com/gitlab-org/gitlab/-/commit/64418acf386713ee42dcd80909f3ac4ae2bdab94) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177804))
- [Remove delete_inactive_project_bot_users FF](https://gitlab.com/gitlab-org/gitlab/-/commit/6dd16aa0bdb65169c4dc48059e140712e0a514d1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178541))
- [Align deletion action between groups and projects in the settings page](https://gitlab.com/gitlab-org/gitlab/-/commit/a31c670604af833ccbae4110d6d6101f5cb326a6) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175873)) **GitLab Enterprise Edition**
- [Clean up duo_chat_storage_postgresql feature flags](https://gitlab.com/gitlab-org/gitlab/-/commit/e787c9b6a8e07ab27ee99390cfd205cabba70092) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178671)) **GitLab Enterprise Edition**
- [Update streaming filters docs links](https://gitlab.com/gitlab-org/gitlab/-/commit/c849b6b0240757405bb28719ce1258a61d0bd203) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178660)) **GitLab Enterprise Edition**
- [Add setup_for_company to onboarding status json](https://gitlab.com/gitlab-org/gitlab/-/commit/0fc8ade000f67e57aa7ab7210d7921cd225db94b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178655))
- [Show "delete model" and "version" links only with permission](https://gitlab.com/gitlab-org/gitlab/-/commit/85e3aa2e19c28f47bc28b9161f4f1576eec72677) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178161))
- [Add sast/dast identification on job](https://gitlab.com/gitlab-org/gitlab/-/commit/1eb05b445cfb495f034c7641a11f3b64ee33f9f1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177924))
- [Remove retain_resource_access_token_user_after_revoke FF](https://gitlab.com/gitlab-org/gitlab/-/commit/80585cd90bf408e03754e4baef8a0ee049ccb66a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178587))
- [Remove policies check from pipeline tooling](https://gitlab.com/gitlab-org/gitlab/-/commit/bf8bb81136b2b203097e11de0066abffdc8f3465) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178612))
- [Add secret_token for compliance requirement controls](https://gitlab.com/gitlab-org/gitlab/-/commit/39260bb79457f5f001445e2119dc88849814cdda) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178204)) **GitLab Enterprise Edition**
- [Hide "promote run" button when no permission exists](https://gitlab.com/gitlab-org/gitlab/-/commit/102e83ff3e9152ba30099f0ba70aa7b14d6dd64a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178400))
- [Extend DescriptionTemplate type to include category](https://gitlab.com/gitlab-org/gitlab/-/commit/5f94b1c8ff61b322ef701948601fa2a77e282533) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178340))
- [Add notes to mention permissions related to a DAST scan](https://gitlab.com/gitlab-org/gitlab/-/commit/ea911b3ab97698299402b5fe40b5e242e7e570d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178272)) **GitLab Enterprise Edition**
- [Add pending status for req. controls](https://gitlab.com/gitlab-org/gitlab/-/commit/ec958af6cdc47735f03bd3070215e0d033c85434) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178601)) **GitLab Enterprise Edition**
- [Remove search_mr_filter_author feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/a46a4e06faf26b03b43db37e0ea0210b525a86ce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178418)) **GitLab Enterprise Edition**
- [Update license exceptions format](https://gitlab.com/gitlab-org/gitlab/-/commit/c1c32f2c964a8b47afe085b9804325c39666ecc8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178586)) **GitLab Enterprise Edition**
- [Remove enable_inactive_tokens_deletion_cron_worker FF](https://gitlab.com/gitlab-org/gitlab/-/commit/873b4572d3ab9df5db6deef806a8ac6e2414c9c7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178548))
- [Fix jira api required field](https://gitlab.com/gitlab-org/gitlab/-/commit/a4d153e908a97d5ca7ac4023af2c9dbcff5d8cf1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178501))
- [Refactor where actions appear in the accessibility MR widget](https://gitlab.com/gitlab-org/gitlab/-/commit/ad3dd2e09eb185eb15f203d463fb471a4f499c4c) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178009))
- [Increase spacing between to-do link and actions](https://gitlab.com/gitlab-org/gitlab/-/commit/e3fa439c8486fb0a8d0e8c3248819063f370fc1e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178469))
- [Hide "Delete experiment" for model experiment without permission](https://gitlab.com/gitlab-org/gitlab/-/commit/05cdd0ad6bd7ebc88bda38d23701f89c9a147f78) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178160))
- [Added ability to close the board modal with esc or background click](https://gitlab.com/gitlab-org/gitlab/-/commit/8ed48a58d373c44eaef3329f8b7053d28462648c) by @zillemarco ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177917))
- [Remove deprecated and disabled SAST jobs](https://gitlab.com/gitlab-org/gitlab/-/commit/ac9163e7495bf9e97ee4fff3e47c7eef0d4668a2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178093))
- [Bump nokogiri to v1.18](https://gitlab.com/gitlab-org/gitlab/-/commit/21767d759eee1bdd6b41cc0cd98283e302edd332) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177832))
- [Refactor scheduling service to use dispatch helper](https://gitlab.com/gitlab-org/gitlab/-/commit/20e9d30fe5a0e993a43d202fbe9ca3c82edcac2e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178068)) **GitLab Enterprise Edition**
- [Update error message when password validation fails](https://gitlab.com/gitlab-org/gitlab/-/commit/9e218cb5eadce64dbe027819ee78326519b7d43c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178212)) **GitLab Enterprise Edition**
- [Remove cross-join from .grades_for with instance](https://gitlab.com/gitlab-org/gitlab/-/commit/eac5c394df278311f181d7ca4c191919c5790cb2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175602)) **GitLab Enterprise Edition**
- [Add new workspace_variables query API](https://gitlab.com/gitlab-org/gitlab/-/commit/68e5df4ce0ac7560b43df6fffe5ca15a70806ed9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176617)) **GitLab Enterprise Edition**
- [Return all validation errors when manual vulnerability creation fails](https://gitlab.com/gitlab-org/gitlab/-/commit/17e1fe4512a1493be6d433363467a946f4b8f7a7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178321)) **GitLab Enterprise Edition**
- [Remove unused prop](https://gitlab.com/gitlab-org/gitlab/-/commit/4a7e36f410cc0a9466167b94dc76e7c92deddebe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175016))
- [Get group grades using vulnerability statistics](https://gitlab.com/gitlab-org/gitlab/-/commit/a645327bd838f9ae5bb2c63ee396af69d875d071) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178024)) **GitLab Enterprise Edition**
- [Remove alert_message_faq from storage banners](https://gitlab.com/gitlab-org/gitlab/-/commit/a47d2a61ca95aa5119f4c07cdce7c0ae930c7936) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177548)) **GitLab Enterprise Edition**
- [Save the LDAP tab pressed in cookie](https://gitlab.com/gitlab-org/gitlab/-/commit/449e4329fe2f660aaec1d35cd421c3b6ea99a36b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178285))
- [Change registry protection rule admin text to Adminstrator](https://gitlab.com/gitlab-org/gitlab/-/commit/59039cb4f4b9f7281a703f2ac29bcb709fee7059) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177822))
- [Update spacing](https://gitlab.com/gitlab-org/gitlab/-/commit/7da90ebc36611dcde05db21466d3ee781f569e82) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177598))
- [Enable the highlighting and memoization of admin tabs](https://gitlab.com/gitlab-org/gitlab/-/commit/1afe3eb9faaf0f7d068492a54e2c20c8f81d8b19) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178227))
- [Update dependency auto-deploy-image to v2.118.0](https://gitlab.com/gitlab-org/gitlab/-/commit/6084fb4b6b4bf994dc0eecb305d7010e1230d278) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176171))
- [LicenseScanning Report refactoring](https://gitlab.com/gitlab-org/gitlab/-/commit/bc064752a7938f8ea54054007c83a24eb97274df) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178236)) **GitLab Enterprise Edition**
- [Update pre-populated branch name when user can push to branch](https://gitlab.com/gitlab-org/gitlab/-/commit/f36ba81ab3ab83f80e0827a6751cffe52568b9ec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177626))
- [Warn user if iteration has confidential issues they can't access](https://gitlab.com/gitlab-org/gitlab/-/commit/e02799bc74a642c5e11882cb9a8664b552b832fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177324)) **GitLab Enterprise Edition**
- [Replace paginator for keyset paginator admin applications](https://gitlab.com/gitlab-org/gitlab/-/commit/4480b38758533ee86872f536a2d4d812bcf6fe0c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178216))
- [Use page heading component in feature flags list view](https://gitlab.com/gitlab-org/gitlab/-/commit/1741fa717525979723f45e7c060c4f292c7aa15f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177606))
- [Model Registry: Rename candidate to run](https://gitlab.com/gitlab-org/gitlab/-/commit/c6ec750f706472d4e9e5d58414f67a4b7f7c9b2a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178158))
- [Show agent version warnings from KAS](https://gitlab.com/gitlab-org/gitlab/-/commit/538d4f63763e401c19b3372c89b34de588a5d327) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175419))
- [Add separate tabs for project and shared agents](https://gitlab.com/gitlab-org/gitlab/-/commit/d367829d1a98b40bb1b6855941d2f13f9d05e9d1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177776)) **GitLab Enterprise Edition**
- [Topics subpage: Cleanup and layout refinements](https://gitlab.com/gitlab-org/gitlab/-/commit/efc40d523b19e28b93af7ae7d997f4e037f7e622) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177735))
- [Add index to import_source_user_placeholder_references](https://gitlab.com/gitlab-org/gitlab/-/commit/a19d12399ebd716d8b30f8abd5369bd5da301437) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177908))
- [Set traversal_ids upon vuln statistics ingestion](https://gitlab.com/gitlab-org/gitlab/-/commit/58e79bd253cfe2617963562bee117b80a2e7b06d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178125)) **GitLab Enterprise Edition**
- [Move conan v1 search endpoint to conan shared endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/7491d190e84e98a474dd341866b634df85530b5e) by @oceane_scania ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177226))
- [Get group grades using vulnerability statistics](https://gitlab.com/gitlab-org/gitlab/-/commit/06a459c696b129930da7bf0843a14ade7eb0b6c9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177892)) **GitLab Enterprise Edition**
- [Support multiple oidc providers](https://gitlab.com/gitlab-org/gitlab/-/commit/96592394aac78974b53072c42dcc81d3f0806fdc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/138734)) **GitLab Enterprise Edition**
- [Process repo_to_index event with one batch at a time](https://gitlab.com/gitlab-org/gitlab/-/commit/67c1050899ebe1af8a49101dc35eff3dab890e3e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177337)) **GitLab Enterprise Edition**
- [Use page heading component in compliance center dashboard](https://gitlab.com/gitlab-org/gitlab/-/commit/0bd4f92a03a5a23e43183c101b9e2b745bfa1245) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177611)) **GitLab Enterprise Edition**
- [Replace VulnerabilitiesFinder with VulnerabilityReadsFinder](https://gitlab.com/gitlab-org/gitlab/-/commit/be1f80f0cb6062443d8c79453b3ebaf64d1fd3f4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175947)) **GitLab Enterprise Edition**
- [Generalize relationship quick action copy](https://gitlab.com/gitlab-org/gitlab/-/commit/04ddcc20b3e2d130f089709e1c2d2ecd3a45d166) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177506))
- [Move full page tooltip to right](https://gitlab.com/gitlab-org/gitlab/-/commit/5278fc367f4c151ca1417c0d532a45f3026ba868) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177893))
- [Drop ipaddr as a dependency](https://gitlab.com/gitlab-org/gitlab/-/commit/c686572c634887d56b4fbe184ed5ca7fbb5f931c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177833))
- [Expose linked work item state on LinkedItemType](https://gitlab.com/gitlab-org/gitlab/-/commit/044545504eb79a71eb9e24a2c9cd44a731f3d106) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176449))
- [Move Seat Control to licensed feature](https://gitlab.com/gitlab-org/gitlab/-/commit/2d40d3354c03d374497912251012bc1cf63ae5da) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177379)) **GitLab Enterprise Edition**
- [Add an icon to the bypassed reviews event in the MR timeline](https://gitlab.com/gitlab-org/gitlab/-/commit/005c78dc41ec6b497cd18d46a96958ea2b2c3f8e) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177675))
- [Change checkbox placement in Artifacts stacked view](https://gitlab.com/gitlab-org/gitlab/-/commit/0390aa87e42568e468c5ba9ac69780634176b2e8) by @Deepak18-06 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164674))
- [Remove job token auth feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/4ef775a78dc64305987ec24f657df50f2d34db45) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177796))
- [Unhide container repository protection rules API](https://gitlab.com/gitlab-org/gitlab/-/commit/9410666adc4dea3843e6f1c5a9adb8fab6246866) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177673))
- [Switch from delete_all to destroy_all for user add-on assignments](https://gitlab.com/gitlab-org/gitlab/-/commit/8454058ef90a9fd9e7250d79e15a119e70d2319f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177421)) **GitLab Enterprise Edition**

### Deprecated (5 changes)

- [Add deprecation announcements for DS build support and Gemnasium](https://gitlab.com/gitlab-org/gitlab/-/commit/6f47693b764200bb1e859cb965bee9427b11bead) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178084))
- [Geo GraphQL API: Deprecate keyword arg](https://gitlab.com/gitlab-org/gitlab/-/commit/08353244cd5218dbb453eb521bd945158e531ab6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180479)) **GitLab Enterprise Edition**
- [Fix deprecated field name](https://gitlab.com/gitlab-org/gitlab/-/commit/5bbb9b65c9ad7a73d73a88dd85cc2a0aa1150b6b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180181))
- [Redirect page visit on group projects page to the group overview](https://gitlab.com/gitlab-org/gitlab/-/commit/18f61d737d8e5f74efd5309403210cb58c6c2202) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179339))
- [Ignore confidence columns on Vulnerability model](https://gitlab.com/gitlab-org/gitlab/-/commit/517e0b69180edd7e2db985b6b38ee11798e6900b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169303)) **GitLab Enterprise Edition**

### Removed (24 changes)

- [Remove rake task to enable or disable work item epics](https://gitlab.com/gitlab-org/gitlab/-/commit/cddde54fef5a5b792b22f942730d1288565e3a5b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181641)) **GitLab Enterprise Edition**
- [Ignoring expression and type column from requirement](https://gitlab.com/gitlab-org/gitlab/-/commit/9da46e715aa37934639a417c4face156a573bf4b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180549)) **GitLab Enterprise Edition**
- [Remove availableFromAccessLevel field](https://gitlab.com/gitlab-org/gitlab/-/commit/f85416708c4b520c109dc26d7eaaccaaedc7134f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181014)) **GitLab Enterprise Edition**
- [Remove buildForecast graphQL endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/e9686da31ae79747287f6a7c1a8762d8281b9850) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180932)) **GitLab Enterprise Edition**
- [Remove All tab from To-Do dashboard](https://gitlab.com/gitlab-org/gitlab/-/commit/0315ffeeb10a57b63ab83d1e4bce15716916bbb9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180589))
- [Removed feature flag by_pass_two_factor_for_current_session](https://gitlab.com/gitlab-org/gitlab/-/commit/669684f3bfbe765a99c80a5bec4cc8a3853e5323) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180968))
- [Remove richText from bloblSearch graphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/136ca3261f8adb8bb4125fc778c6e9f5ebc6f0a0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180631)) **GitLab Enterprise Edition**
- [Remove epic_metrics table, models and associated references](https://gitlab.com/gitlab-org/gitlab/-/commit/35969dd2061ba03f983bfca23ae4bb538eebf2dd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179477))
- [Remove web_ide_settings_context_hash feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/db6e46b374dcbcf1bdb8da4f294de3d20d368701) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180261))
- [Remove scan_execution_pipeline_concurrency_control ff](https://gitlab.com/gitlab-org/gitlab/-/commit/a789f0667984cb673f0a316a48dbaac80107ec71) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180271))
- [Remove temporary indicies from packages_dependencies table](https://gitlab.com/gitlab-org/gitlab/-/commit/a2ab3d2934dbc512d4858df0b3507c0cca626221) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180068))
- [Revert "Merge branch 'autoflow/basic-workitems-events' into 'master'"](https://gitlab.com/gitlab-org/gitlab/-/commit/86932b640d5b66016fdd15a48bfabd84cf0de0f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179738))
- [Add post-deploy migration to drop unused column](https://gitlab.com/gitlab-org/gitlab/-/commit/a953059e6d1b315711ac315ba32acce3dfb9499d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179672))
- [Remove function-based namespace lookups](https://gitlab.com/gitlab-org/gitlab/-/commit/e2b24e2e22b9ca305c5394d0ed3b5b81ffefb03d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179582))
- [Ignore sep max_concurrency application setting](https://gitlab.com/gitlab-org/gitlab/-/commit/b6b93d1b7a6dfef41ade5087989c3c6a7398a0a8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178926)) **GitLab Enterprise Edition**
- [Removed the ignore rule for dropped column](https://gitlab.com/gitlab-org/gitlab/-/commit/b6c24134e6027be0ff8a76bb1625c8577e7d1cda) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178634)) **GitLab Enterprise Edition**
- [Remove todos_vue_application feature flag and all inactive code](https://gitlab.com/gitlab-org/gitlab/-/commit/693fdd971c102dbea090265330fc48b79c8463b1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175863))
- [Remove `index_vulnerabilities_on_detected_at_and_id` synchronously](https://gitlab.com/gitlab-org/gitlab/-/commit/eafdd7f3a291b56b9d4d339d3db9e27262878d06) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178444))
- [Remove license_scanning_with_sbom_licenses feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/e86dfe29cafdabdc07ef379ea82ab2c5281a0dcb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172437))
- [Remove sep scheduled scans application settings unused view](https://gitlab.com/gitlab-org/gitlab/-/commit/41059c39126eb43c8178f44b7c99d8179b1ad6c9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177502)) **GitLab Enterprise Edition**
- [Remove hybrid search](https://gitlab.com/gitlab-org/gitlab/-/commit/4427c4367181f3c87da434006cf08ddbfd1ad045) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178151)) **GitLab Enterprise Edition**
- [Drop advanced_scopes from personal_access_tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/9ccd253eb52146d0961e2fe71a71eb6ad31b139b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178110))
- [Remove failing merge request approval rules metric](https://gitlab.com/gitlab-org/gitlab/-/commit/03c4913f0fb7e4cc99c6e3fc17ed0531b897b614) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177494)) **GitLab Enterprise Edition**
- [Remove broken compliance_total_unique_counts weekly, monthly metrics](https://gitlab.com/gitlab-org/gitlab/-/commit/fb1a1b8c60a7b6c7ff707eefab324b8ecb60ff79) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175901)) **GitLab Enterprise Edition**

### Security (15 changes)

- [Revert "Update Kas version to the lastest sha"](https://gitlab.com/gitlab-org/gitlab/-/commit/c89db5ed4a62eb58c81030f453d25741a138dc03)
- [Do not allow Planner role to update or delete incidents](https://gitlab.com/gitlab-org/gitlab/-/commit/96c29d4cea022495546617429116226c65b6c779)
- [Reduce number of object allocations on PAT endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/6f4aea90bd0b6bfe61109173aaeb422d05e6f870)
- [Prevent SSRF attacks for Workspaces](https://gitlab.com/gitlab-org/gitlab/-/commit/277faf3747bcc4b6d4beb9d04548c1037ac28840)
- [Security Duo Chat Escape Unknown Domain Hyperlinks](https://gitlab.com/gitlab-org/gitlab/-/commit/babc054870124dc9faad58f9580ca5cd1d48d9c4)
- [Fixes XSS on the target branch in the merge request widget](https://gitlab.com/gitlab-org/gitlab/-/commit/e5f4d1cdbaf813741491013e4c2ab2a5ec758ba0)
- [Prevent read code access when repository is disabled](https://gitlab.com/gitlab-org/gitlab/-/commit/047963e52d1905b2c053c02e014f09c4150a7682)
- [Unsubscribe from actioncable channel when PAT is revoked](https://gitlab.com/gitlab-org/gitlab/-/commit/74adac8edd65cd3cb830e1674f540ee2566d749c)
- [Update Kas version to the lastest sha](https://gitlab.com/gitlab-org/gitlab/-/commit/55609a21ea82501fb0ec4ce8b33e318c764a9e6c)
- [Add offset optimization to audits event API](https://gitlab.com/gitlab-org/gitlab/-/commit/d6fa8fa871e821f805e55f65405ba23bb977d6eb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178619)) **GitLab Enterprise Edition**
- [Fix protected variable exfiltration](https://gitlab.com/gitlab-org/gitlab/-/commit/cea3d30eca2ebb9aedd749a4f43f98e328eef350) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179611))
- [Avoid recursive sidekiq calls on cyclic work item hierarchies](https://gitlab.com/gitlab-org/gitlab/-/commit/9d135851bac232665aeadceba56c12104c9ea625) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179611))
- [Enhance rich viewer sanitization](https://gitlab.com/gitlab-org/gitlab/-/commit/2841af0777cef60413aae3ce6844871defa41a4d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179611))
- [Respect the private profile constraints](https://gitlab.com/gitlab-org/gitlab/-/commit/d589410f5a99fc6a5c0b6e524e7255f6f0b6a49b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179611))
- [Reduce REGEXP_TIMEOUT_SECONDS to 40 seconds](https://gitlab.com/gitlab-org/gitlab/-/commit/d2fc6336b69f407a85791ec3b7c5196e3102a31d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177104))

### Performance (11 changes)

- [Optimize build.execute_hooks when creating pipeline](https://gitlab.com/gitlab-org/gitlab/-/commit/45035a5245db22e4ed74e7fa7b8090e8e5881943) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180687))
- [Set idempotency_arguments to SyncProjectPolicyWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/85d166340df03146803e63c579121d34f69076c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180807)) **GitLab Enterprise Edition**
- [Fix cache of branch_requires_code_owner_approval?](https://gitlab.com/gitlab-org/gitlab/-/commit/7e5c090b672f377b3ce9dfdbdbd32f00b4a853c9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179697)) **GitLab Enterprise Edition**
- [Reduce N+1 in project GraphQL project queries](https://gitlab.com/gitlab-org/gitlab/-/commit/e069f4f163556c196ebf480096a841a80b122a02) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179330))
- [Update import_failures sharding](https://gitlab.com/gitlab-org/gitlab/-/commit/e50235c033fb5f544fcdf765f0445c487b3bcf92) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168393))
- [Share preloads across multiple GraphQL project resolvers](https://gitlab.com/gitlab-org/gitlab/-/commit/bf32e7ecdd878abc22d97ef8e30fa4ba51b9fe4b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178978))
- [Remove auto_merge_process_worker_pipeline feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/12b04a6a1940e82c426de20582719ebfb5f052b1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178960))
- [Replace check_rate_limit! with check_rate_limit_by_user_or_ip!](https://gitlab.com/gitlab-org/gitlab/-/commit/c0966deb97a024268264261b0c9e2c8b3c340688) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178698))
- [Remove check_oversized_blobs_without_blob_stitcher ff](https://gitlab.com/gitlab-org/gitlab/-/commit/d52e793e4dfc12ec4c3f6168e0e00e15171e7930) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178538))
- [Improve resolved vulnerabilities performance with SM-specific index](https://gitlab.com/gitlab-org/gitlab/-/commit/18fdf4440e5fb1bfaea76227f8846cd81ecde826) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176561))
- [Create system_hooks table](https://gitlab.com/gitlab-org/gitlab/-/commit/a458033864081335284f266a5e049eddb79df57a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175729))

### Other (283 changes)

- [Add Telegram instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/394bb24682fa2dfd0875e163d0e69d00fb51f65d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179361)) **GitLab Enterprise Edition**
- [Add sharding_key to board_labels table](https://gitlab.com/gitlab-org/gitlab/-/commit/d4a3c5c55e2ff2cc65aca58cf074d3f1534dc915) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180642))
- [Validate not null on vulnerability_finding_evidences sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/92a224568bf154feddd978c563e9131fbcaaf520) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179802))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/e9c7395aad1295c8273e514e0750a6c671e73890) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181656))
- [Finalize migration BackfillIssuesDatesWithWorkItemDatesSources](https://gitlab.com/gitlab-org/gitlab/-/commit/229253de212912cf19b21496656abbbca3bf5f8f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177108))
- [Remove deprecation notice for runner fields in REST entity](https://gitlab.com/gitlab-org/gitlab/-/commit/ccf62b7e357cfb0fb49dd00b68d38d79a8ffb2cf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181507))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/07a2e9f9868318eb77e68dffdb6d6ae43a18466a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181345))
- [Finalize migration BackfillWikiPageSlugsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/30e55f7585b0c1105a1bf5feb57ff991d6dd0975) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177106))
- [Set pipl user soft deletion](https://gitlab.com/gitlab-org/gitlab/-/commit/5f42e8b268021dc7af1d6b5acb4e4911a7efab11) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181112)) **GitLab Enterprise Edition**
- [Add MicrosoftTeams instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/a401d57449e004f0cee509d2af57086d105236e6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179510))
- [Address non-blocking comments](https://gitlab.com/gitlab-org/gitlab/-/commit/dafba28a6d912b7ecc37a39af14bb43924cb1f6e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181409)) **GitLab Enterprise Edition**
- [Add new CDot internal endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/0a9a74fad8114a606d8cb44788124604881b33e1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180980)) **GitLab Enterprise Edition**
- [Sync setup_for_company in user_preferences and onboarding_status](https://gitlab.com/gitlab-org/gitlab/-/commit/a1d6499bd848592ea04ff15e4680853b34c40a5c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179314)) **GitLab Enterprise Edition**
- [Fix rubocop offenses for conan package tests](https://gitlab.com/gitlab-org/gitlab/-/commit/e79b188473dd83e0a726099e92f6564fe7b83c8f) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181117))
- [Expose project/root_namespace ids for Workhorse requests](https://gitlab.com/gitlab-org/gitlab/-/commit/530bd18faf94c7f585559148f5ecd53b87274b19) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/150337))
- [Remove numbers from alerts integration settings](https://gitlab.com/gitlab-org/gitlab/-/commit/4f06441cf93e2e38da882e554ea930f2cbc4a179) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181291))
- [Remove current_page_context_prompt_in_aigw feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/dc3a89a7d919493b03a447ab7e251a265ca9af56) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181273)) **GitLab Enterprise Edition**
- [Remove Search::Zoekt::IndexOverWatermarkEventWorker job instances](https://gitlab.com/gitlab-org/gitlab/-/commit/107a89f2c3e325c454c403eb5eae620d3fe4a0d3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181258))
- [Reject API calls from orphaned project runners with HTTP 403](https://gitlab.com/gitlab-org/gitlab/-/commit/63cdafa71506f3010c1be6d99fc2203f5b4570c1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180918))
- [Add and backfill namespace_id for design_management_repository_states](https://gitlab.com/gitlab-org/gitlab/-/commit/f6a78a4b95a83d584139f002fd5fc4bfc909d502) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180426))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/84c56408940e120d1a36f694c4e444d14e66b8a0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181051))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/bcb0f3b6cfb3c1c0157cb4f6fcf96bddbefd0ad9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180233))
- [Finalize migration BackfillZoektReplicas](https://gitlab.com/gitlab-org/gitlab/-/commit/30f834fda8794352de8512f2648f98b31b99700f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181210))
- [Finalize migration BackfillPackagesDependencyLinksProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/53b57c46287fc7b5b03d01cc6a56e061d69167e2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181206))
- [Finalize migration BackfillPackagesDebianProjectComponentsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/7c6407a123064ebac47b60f8422c60d624d5a15a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181205))
- [Add & backfill sharding keys for bulk_import_failures](https://gitlab.com/gitlab-org/gitlab/-/commit/789f0f980e19aeb99c88a5187d91d86e0114c0b6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180435))
- [Model registry: Remove unused components](https://gitlab.com/gitlab-org/gitlab/-/commit/9593840707a61ddb268b8f1c95d67273a77753b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181131))
- [Add Teamcity instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/aa871b2d7f83f8d169778d27d9733a2a7f4e2f40) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178920))
- [Add a migration to limit group visibility by organization visibility](https://gitlab.com/gitlab-org/gitlab/-/commit/497bbcc6412f73b3e6b608bbae088a0aa4a559ed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179827))
- [Set packages_debian_project_architectures.project_id as NOT NULL](https://gitlab.com/gitlab-org/gitlab/-/commit/ecc1c3d91e975b21ae64b47ba3c71d1581ee4dd1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181065))
- [Add NOT NULL constraint on packages_debian_group_architectures.group_id](https://gitlab.com/gitlab-org/gitlab/-/commit/0e06b4b843c79e0b43b1a5785666d4cee8dc4103) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181062))
- [Add NOT NULL constraint on packages_conan_metadata.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/8d43a17278c06e3cc7ba5460c3a89b20994e3ac6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181061))
- [Set external_status_checks_protected_branches.project_id as NOT NULL](https://gitlab.com/gitlab-org/gitlab/-/commit/d83381aeddbd4469836cf661140b4a0c151346a6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181060))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/07f6c6500aeeeeb4eca90b5991f2772c3c329bd5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180874))
- [Validate NOT NULL on vulnerability_findings_remediations sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/0188d5ba1b557073f6fe5238c9648d8fa38cc401) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180698))
- [Validate NOT NULL on terraform_state_versions sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/f73aab982ab39bbf8dcb71c7f08ab232f550512d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180699))
- [Add unique constraints on ci_runners_e59bb2812d partitions](https://gitlab.com/gitlab-org/gitlab/-/commit/6f943a68c4741d1cc740c16dcee009deac683f21) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180721))
- [Add ExternalWiki instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/b27aed0b35963486f037325e8b5535508511cdd3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178723))
- [Remove search_group_sso_redirect feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/58430e78b8944270332bdd6056888b412f679a12) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180750)) **GitLab Enterprise Edition**
- [Remove search_global_sso_redirect feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/fa4b9a22532a728d7754577b7f20f37c23616cb4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180748))
- [Add Harbor instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/e37a19936a5657f9d61b9ba8dee12c97b3cf8b5e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178895))
- [Use ResetAuthenticationTokenService in Runner API](https://gitlab.com/gitlab-org/gitlab/-/commit/4b5b546b2baa3856ccc8d860bc45e18d29370022) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180365))
- [Validate NOT NULL on wiki_repository_states sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/ce1f4c9abd2ce52a504394c3b63644461f2e4fd2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180700))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/f7c59ccd03152e00a5f9a1e6754b318b7bb4ad32) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180943))
- [Cleanup feature flag ff_pages_use_open_file](https://gitlab.com/gitlab-org/gitlab/-/commit/dc2dfcd69c62d2399e579006e7bce37951bb4be5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180926))
- [Validate NOT NULL on work_item_parent_links sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/20ca5bb3701f21a33bb27ae7cfe8c3e98af89427) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180915))
- [Validate NOT NULL on approval_project_rules_users sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/2dd29ce8a65960b4877de8eb788823fd6a2ce2e8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180908))
- [Validate NOT NULL on approval_merge_request_rule_sources sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/80f92b08ae80023a4c78fc144163949133b685c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180906))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/643b4f09e052b89fab01e3f60734ebe9a014882e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180820))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/6dd1c1fe592cce48d1871406775ec91829cc7ff3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180819))
- [Add EmailsOnPush instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/f4a911f73c5d7808a3b7f9e87d30a5f677ff4b8b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178460))
- [Add and backfill project_id for merge_request_cleanup_schedules](https://gitlab.com/gitlab-org/gitlab/-/commit/d97485474fe4af3423543a3c3d399f2d3360534a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180840))
- [Add & backfill sharding keys for bulk_import_trackers](https://gitlab.com/gitlab-org/gitlab/-/commit/eb3e6e26d792e2b39b72e9e1af5f648b8d571f31) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180437))
- [Add and backfill project_id for merge_request_predictions](https://gitlab.com/gitlab-org/gitlab/-/commit/5bde5a0fd8b82d288e0fe50d8bc9f340f9766ef7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180839))
- [Add and backfill project_id for requirements_management_test_reports](https://gitlab.com/gitlab-org/gitlab/-/commit/f1f90901e1dcd89ca06891f0e1cb51c84a63e9b9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180838))
- [Add and backfill namespace_id for design_user_mentions](https://gitlab.com/gitlab-org/gitlab/-/commit/f161cf269bdf41d631b7179505dfbc0269d3c6aa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180837))
- [Admin Token API: Revoke Impersonation tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/fa3555c11e65fffddf58cf85373ac2c714c0c1ee) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180745))
- [Add NOT NULL constraint on approvals sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/68aec3940a1095753619849f9fa543b2c702c677) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177402))
- [Validate NOT NULL on vulnerability_finding_signatures sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/20e396173dff1fa1b7a404781832980d0b7ad4e2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180692))
- [Add NOT NULL constraint on ml_model_metadata.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/6ef1b13948de9c0e6211d7e28bf84998e9da70d3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179816))
- [Requeue backfill for target_project_id on ComplianceViolations table](https://gitlab.com/gitlab-org/gitlab/-/commit/30c2d30f5f525aad5deccd11d7297ac80dd7a9b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180053))
- [Refactor NuGet package enqueuing](https://gitlab.com/gitlab-org/gitlab/-/commit/60c426dc2182e4d3027362f1834d62c30c8ba772) by @holtvogt ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170649))
- [Add Discord instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/a35e764f30106abd9a7dfbbea6b1cfd33f7653f2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178313))
- [Add and backfill project_id for operations_scopes](https://gitlab.com/gitlab-org/gitlab/-/commit/2be897fcaa970746cf359680b854e96f1963726a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180223))
- [Add and backfill project_id for merge_request_diff_details](https://gitlab.com/gitlab-org/gitlab/-/commit/d22e78e61eb5a1cb193a82a794c32379b07aa464) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180428))
- [Add & backfill sharding keys for bulk_import_export_batches](https://gitlab.com/gitlab-org/gitlab/-/commit/9aea28f1fb2110b01a83245ce53a398f280620fa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180432))
- [Add & backfill sharding keys for required_code_owners_sections](https://gitlab.com/gitlab-org/gitlab/-/commit/680051f9862194503da017d2217933308fefaba3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180440))
- [Mark 20241025160103 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/eb9e5c0e091fd29a8a4297f55f7050fb88ca74c9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180209)) **GitLab Enterprise Edition**
- [Mark 20241106201829 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/ce8b72a008b8cf757134f8218a2e25cab35d1c6c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180211)) **GitLab Enterprise Edition**
- [Add and backfill namespace_id for design_management_designs_versions](https://gitlab.com/gitlab-org/gitlab/-/commit/63c5d772706cae84776db17804c4dc51febe6872) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180220))
- [Validate not null on sbom_occurrences_vulnerabilities sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/68265ff0d5d16c5db5b218d4dd1711780b9c8c58) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179798))
- [Add & backfill sharding keys for snippet_repository_storage_moves](https://gitlab.com/gitlab-org/gitlab/-/commit/d2195c80d81f5e0cb3ca8f300734874bdff1558d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180441))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/1c533c6f6163dc4e56e4d8eb9388b69839557ce5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180489))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/f9d94114531036aa118c1c25ed369de95b05a545) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180232))
- [Remove vulnerability_report_security_scores feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/1e1624fc4c949e5a3ce3a12482787a1fcace1c68) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180447)) **GitLab Enterprise Edition**
- [Reindex Elasticsearch projects index to update integer with long type](https://gitlab.com/gitlab-org/gitlab/-/commit/22f8a5431d535c677c13461ec4c5715316e252e3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180165)) **GitLab Enterprise Edition**
- [Reindex Elasticsearch users index to update integer with long type](https://gitlab.com/gitlab-org/gitlab/-/commit/5da816f4ab67fb65a537330b488348782db62db0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180178)) **GitLab Enterprise Edition**
- [Remove `sourcegraph` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/8c9cdd9df086c6191643b3c1d2933aa63ca90432) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173712))
- [refactor: Use BaseProjectService for container protection services](https://gitlab.com/gitlab-org/gitlab/-/commit/e9694d06c385b843d892c214f7f70f553783a4d1) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180386))
- [Protected packages: Remove deprecation warnings in GRAPHQL](https://gitlab.com/gitlab-org/gitlab/-/commit/0e59997cd265ff15b22114345812ffc6675a34b2) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180372))
- [Change FF ownership](https://gitlab.com/gitlab-org/gitlab/-/commit/e5a43acd604fcb754e683cd3f56ccc80297c6eea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180355)) **GitLab Enterprise Edition**
- [Delete track_user_access_from_pipl_countries FF](https://gitlab.com/gitlab-org/gitlab/-/commit/28f1bb7b79df3d64d1065f213e7b8129a7b147c0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180358)) **GitLab Enterprise Edition**
- [Mark 20241105111645 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/ca4b2f9c98b12817819c4449430e2408b4c8a560) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180210)) **GitLab Enterprise Edition**
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/5d14d1300261e6678e521a3c345acd4608c5ea64) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175841))
- [Add milestones not null sharding key constraint](https://gitlab.com/gitlab-org/gitlab/-/commit/e5cbda153f88c9ef8ba14d57cbf306f15e866fac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179791))
- [Instrument the creation of CI runners](https://gitlab.com/gitlab-org/gitlab/-/commit/e5215d8d81f110be7061f7ddc40a3729a00cf3a0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179876))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/683257901596c5866198a209b94208ce2019b273) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180248))
- [Add and backfill group_id for boards_epic_list_user_preferences](https://gitlab.com/gitlab-org/gitlab/-/commit/98722aad8dc8e147fcdb3a22d217379e5044514f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180037))
- [Extend SyncNamespaceService for add-on purchases](https://gitlab.com/gitlab-org/gitlab/-/commit/513b625b2a90d06053c13e417878404bfb26787e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179667)) **GitLab Enterprise Edition**
- [Add and backfill project_id for dast_pre_scan_verification_steps](https://gitlab.com/gitlab-org/gitlab/-/commit/01061bad39fb4cefa39d91730b6865cd7e73a2de) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180046))
- [Reindex Elasticsearch wiki index to update integer with long type](https://gitlab.com/gitlab-org/gitlab/-/commit/689152bcf724fd6d938f2a319bfbf85f28f1e4de) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180023)) **GitLab Enterprise Edition**
- [Add Confluence instance integraiton model](https://gitlab.com/gitlab-org/gitlab/-/commit/efe3bc858502348b5ccbe17abd43b874d01def71) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179500))
- [Add sharding key to board_assignees](https://gitlab.com/gitlab-org/gitlab/-/commit/c9773b4e168cd0cba3c6eefb7463b857776f9a11) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178949))
- [Set sharding key for merge_requests_compliance_violations](https://gitlab.com/gitlab-org/gitlab/-/commit/0a6a1d20a7973dbcdffba4b2a66564685e256cf2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178769))
- [Fix Layout/LineLength offenses](https://gitlab.com/gitlab-org/gitlab/-/commit/b83474fe688ca025b63538bdb7eaa721ab61eef3) by @ikelax ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169988))
- [Add new provision service](https://gitlab.com/gitlab-org/gitlab/-/commit/10484bec1461437e282be0cfd0f4864b65d07537) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178532)) **GitLab Enterprise Edition**
- [test: Improve readability of test by applying table syntax](https://gitlab.com/gitlab-org/gitlab/-/commit/9d150b29950176b9a19c61e462a610f8a3fb1bd1) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179518))
- [Remove start and due date widget from incident WIT](https://gitlab.com/gitlab-org/gitlab/-/commit/d40b31788b76d44efcd72cd1acd4e362760d7192) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180002))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/121897473d6152994d061ff201cd4d3eb66d5929) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180003))
- [Add NOT NULL constraint to release_links.project_id column](https://gitlab.com/gitlab-org/gitlab/-/commit/b67da92b8fbdef3b44485fb94c8bd248f99f4fe2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177235))
- [Add NOT NULL constraint on draft_notes.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/0b4bb46dd01704ec5753f334ffd72711f1673664) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177403))
- [Fix 20 rubocop violations for Layout/ArrayAlignment](https://gitlab.com/gitlab-org/gitlab/-/commit/297c8179c1eea1683a0990c07c53d777d7a6981e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179945))
- [Add project_namespace_id_from and project_namespace_id_to](https://gitlab.com/gitlab-org/gitlab/-/commit/34844d1c7dfe1d9512fac9b6eae9f74ab5eafaa8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179558)) **GitLab Enterprise Edition**
- [Extend documentation for includes in code blocks](https://gitlab.com/gitlab-org/gitlab/-/commit/e3bfef24e98b0b29236f5facfe5a0eeeac23d478) by @schurzi ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179571))
- [Mark 20240814223217 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/24930e28bff39fbd2aba3f228efc3257a9f8be6b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178353)) **GitLab Enterprise Edition**
- [Add NOT NULL constraint on ml_candidate_metadata.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/e9a445a37ec0f40913c1ea37f9ec1daa0353b869) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179814))
- [Add FK back to issues.work_item_type_id](https://gitlab.com/gitlab-org/gitlab/-/commit/ff2878f48c843cd7fc38a89505a9b8c15734b856) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178495))
- [Add NOT NULL constraint on merge_request_blocks.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/275fadb87a1d3a5d05a30d5c9068aeb9d48b45bb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177399))
- [Create siphon tables for namespace details and bulk imports](https://gitlab.com/gitlab-org/gitlab/-/commit/d255645902f3cf5ace52846b086005f4de3cb06a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179726))
- [Add NOT NULL constraint to boards sharding key](https://gitlab.com/gitlab-org/gitlab/-/commit/ec3e6f8822bcdbdc7c86cb28601fee40dcb6499d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179112))
- [Remove vulnerability_filtering_by_identifier feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/1761599e30a460a805893129ed9de76985ec5393) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179525)) **GitLab Enterprise Edition**
- [Add custom fields widget to all work item types](https://gitlab.com/gitlab-org/gitlab/-/commit/d7f5cfcaffdb7f542010866cb1da4f8c7b832899) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176206))
- [Partition Manager to automatically attack LFK trigger to new partitions](https://gitlab.com/gitlab-org/gitlab/-/commit/b5f7e144a29f359100daff4bf7d5a7f66dcce912) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175310))
- [Remove duplicate shared spec](https://gitlab.com/gitlab-org/gitlab/-/commit/237d7898012050db19cde69a880fef54489bdd8b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179705))
- [Finalize migration BackfillPackagesDebianProjectArchitecturesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/f3aea4ac41401beff21677a7c0179a48983ffa79) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178652))
- [Add trigger token expiration](https://gitlab.com/gitlab-org/gitlab/-/commit/e6e7076f775930c802ffcbbede986aef28e102c9) by @william.allen1 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/146912))
- [Add not null constraint on vulnerability_finding_signatures.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/2df4fea30d70ffc96ffa8eeac059b603867820f7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177376))
- [Add NOT NULL constraint on approval_merge_request_rules.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/827d3f28a4db1be0c2c5c95ff70b4614bc609524) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177401))
- [Add NOT NULL constraint on work_item_parent_links.namespace_id](https://gitlab.com/gitlab-org/gitlab/-/commit/14cc21b8f98649f73107a253fb12af499eee69f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177413))
- [Add NOT NULL constraint on merge_request_context_commits.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/6eb1beca38bbc762fbc754b73930dba146f2bd66) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177405))
- [Add not null constraint on dast_scanner_profiles_builds.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/4be2a19dae1488eea1bbe04efa3a9cf27ec4e85e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177358))
- [Add NOT NULL constraint on epic_user_mentions.group_id](https://gitlab.com/gitlab-org/gitlab/-/commit/bef15865d7805fcaf247c7f23c3b922df99983c1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177411))
- [Add NOT NULL constraint on status_check_responses.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/775015ad54377942c8a706663292252c7496058d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177392))
- [Cleanup throttle_with_process_commit_worker_pool feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/b3cfec256f9a7cc89c748c7d3e361177bf4f8db6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179619))
- [Create cluster_agent_migrations table](https://gitlab.com/gitlab-org/gitlab/-/commit/523f4fe602825c8f366b8aa9fc44e01c48f924ed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179324))
- [test: Fix typo in test](https://gitlab.com/gitlab-org/gitlab/-/commit/4d18974c58a6c66e1c441499917d85ffd82b4979) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179533))
- [Create ClickHouse siphon tables for milestones and events](https://gitlab.com/gitlab-org/gitlab/-/commit/b3a838ed16e81b83c004a188e02efa9d42449063) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179573))
- [Rename feature flag for enhanced vulnerability bulk actions](https://gitlab.com/gitlab-org/gitlab/-/commit/cdb6a2d0505da67f6c8878cb4380cb5ee723add0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179488)) **GitLab Enterprise Edition**
- [Add MattermostSlashCommands instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/fde3040722cb2adae6cda19cd14e8b6df69467a5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179534))
- [Add MockCi instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/413881770e1b1e90e53ba62d05e5a4ab57ac4ed0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179505))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/fca2ade31a2c0214b55defe6f5e328f400fdc01e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178459))
- [Remove the index_curation feature](https://gitlab.com/gitlab-org/gitlab/-/commit/fd013ff12c41c351fef7b5c216e157ea02e2f2e0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179017))
- [Fix pngquant script by requiring logger](https://gitlab.com/gitlab-org/gitlab/-/commit/9646145ce34962ece56921e02d76ac35893f4ca6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179424))
- [Add MockMonitoring instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/f4ee73047604c86392b2a2bf09d589f93cdae026) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179423))
- [Add Phorge instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/38a55b6af6476d2d199c3293c19ebccbf9b7b37d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179422))
- [Add PipelinesEmail instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/f24fbc7f28c4d09fd987de4d1dc3f2e0ebea7206) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179419))
- [Add Pivotaltracker instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/e986da76167b91bbca8654c4886d30c3a29a097d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179413))
- [Fix Usernamespace Audit events](https://gitlab.com/gitlab-org/gitlab/-/commit/e49d9dedfee119b3adbe2791155efc6b633cfe4c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177095))
- [Add Pumble instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/a29d262ad54d8eaa17315cd5048fa90a8e312af0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179393))
- [Add Pushover instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/dba353e2d84e7167ed4ac2114a126f0820610a3f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179388))
- [Remove Ci::Tagging model](https://gitlab.com/gitlab-org/gitlab/-/commit/c8b209b006180066151afc5d52a69a1c67352313) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179384))
- [Add Redmine instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/4622b0480e80a9f76569b210d866259b1b139189) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179377))
- [Remove enforce_global_file_size_limit feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/2b7fea4f1c1e0b35475731944ba6dfa1efa91ade) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179347))
- [Handle case where pipeline can be nil in FindingsFinder](https://gitlab.com/gitlab-org/gitlab/-/commit/f67428c81caaadacecad9efec81db70338453877) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178545)) **GitLab Enterprise Edition**
- [Add NOT NULL constraint on project_relation_exports.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/94410f407af125bacf3762f5a892031d135a4c56) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177407))
- [Add NOT NULL constraint on merge_request_assignees.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/6f1c17c72025e21e0d55749196df912155cb9ce0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177404))
- [Add NOT NULL constraint on vulnerability_finding_links.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/7fe709c43216f6e52d7d0b1da322cd1b8cdde387) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177375))
- [Mark 20241003142503 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/f23b78db89f7e6435adf24047f3288d911153f62) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178357)) **GitLab Enterprise Edition**
- [Add UnifyCircuit instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/0cfe9941b377efd1c9cc250f47bd7685c991908f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179265))
- [Remove Ci::Tagging association](https://gitlab.com/gitlab-org/gitlab/-/commit/5d65b36c743da8bc7716a27dcc080c8450b0d4e8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178462))
- [Finalize migration BackfillMergeRequestReviewersProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/3fdb4a69858d56908582e7fffe7205d938020eef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177331))
- [Add WebexTeams instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/2e090ba15e11d278c273819ee727033608e8bb39) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179264))
- [Finalize migration for backfilling security policies](https://gitlab.com/gitlab-org/gitlab/-/commit/cef94778b25b23517145dcc44a9b01b7b5996471) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175231))
- [Backfill p_ci_pipeline_variables from ci_trigger_requests](https://gitlab.com/gitlab-org/gitlab/-/commit/a89820fc031f68e3022749be9c32039800e8bc06) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175399))
- [Add Youtrack instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/b45096f739d95719a7c40c5eb2536da4faf99991) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179251))
- [Add warning to DT docs](https://gitlab.com/gitlab-org/gitlab/-/commit/3bd54863ac7934bffef246c53fe2d296a2c558f7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179223))
- [Move registration_objective to onboarding_status column](https://gitlab.com/gitlab-org/gitlab/-/commit/3aa1fb5916b699b26fbdb14937728a52b613b2ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176428)) **GitLab Enterprise Edition**
- [Validate not null constraint on projects.project_namespace_id column](https://gitlab.com/gitlab-org/gitlab/-/commit/1f98c0759263f01d803fa2d3bc9ed3e05bea1be8) by @c0rydoras ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178729))
- [Refactor Cell Configuration](https://gitlab.com/gitlab-org/gitlab/-/commit/9aed1004d100d4afcb9357b8c8e2fac2fecca9c3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177988))
- [Mark 20241017094601 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/ce85551f2ff50e33975c5c31b8290e6cddd47bd2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178359)) **GitLab Enterprise Edition**
- [Remove multiple_todos feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/a5d66c1fe59147287de1a64d2f14b92f35b9c47a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178897))
- [Add CustomIssueTracker instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/7f8c2e5fc6dabef6650edfd56355de67c9009969) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178019))
- [Add DiffblueCover instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/a7d4bc9db454f1e357e62e45129948ee5b3d4d7d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178027))
- [Add Ewm instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/bc747914b77a5fe0630fae8acc343002746b14b8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178721))
- [Finalize 20250109133913 batched migration](https://gitlab.com/gitlab-org/gitlab/-/commit/06f17ea420b60a57f7ff94a23468d4d46e8b74fb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179042))
- [Finalize 20250108170045 batched migration](https://gitlab.com/gitlab-org/gitlab/-/commit/f1d718bd046922ccf1f20e30a602a9e6ae76c382) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179039))
- [Finalize RecalculateShardingKeyIdForOrphanedProjectRunners](https://gitlab.com/gitlab-org/gitlab/-/commit/9f1efb3c43b7405817c0bc1b85597f59e9be1c29) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179036))
- [Remove `merge_request_dashboard_new_lists` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/4b64fdf95f5811fb4a41b67e513d5030bb86d6af) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179020))
- [Set vulnerability_findings_remediations.project_id as NOT NULL](https://gitlab.com/gitlab-org/gitlab/-/commit/8fbd1ab0bc5c0ef21962e0359caf85efba5408b1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177377))
- [Add NOT NULL constraint on issue_links.namespace_id](https://gitlab.com/gitlab-org/gitlab/-/commit/ea831ddb2c5fb9ac74967c13093e029b0ed7e901) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177412))
- [Consolidate secure tokens feature flags](https://gitlab.com/gitlab-org/gitlab/-/commit/3759f68a47d2d136f8643312ff21d2a399531e51) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178404))
- [Add not null constraint on packages_build_infos.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/ad2fa4c965ea6c090d271f65eb45ff4c0f4f5d01) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177362))
- [Remove feature flag for pipeline cleanup](https://gitlab.com/gitlab-org/gitlab/-/commit/7477598a4ac0e5e3eb1c01505f43cbe6d9b1fc70) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178754))
- [Add Irker instance intergration](https://gitlab.com/gitlab-org/gitlab/-/commit/4627b5f5f4f339b94746be4a0a61b6da843d34fa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178903))
- [Finalize migration BackfillResourceLinkEvents](https://gitlab.com/gitlab-org/gitlab/-/commit/0a89eccff629ad5f2c4ff43867905e3460f68dd1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178649))
- [Create ClickHouse siphon table for notes](https://gitlab.com/gitlab-org/gitlab/-/commit/6f316a39360b0e002b08cc583446f5aa81ba7514) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178914))
- [Remove toggle_redis_6_0_compatibility FF](https://gitlab.com/gitlab-org/gitlab/-/commit/7b5ceece82f6dbaafb85c9922fcaafe21e66712b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178908))
- [Finalize migration BackfillPackagesConanMetadataProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/506d8e4b73f25ac9b912ad6f4b623fc099b052d4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178097))
- [Store failed pipeline counts on ClickHouse](https://gitlab.com/gitlab-org/gitlab/-/commit/44e1c4298a4ce3f7c7729d6a59143a3606bf0c28) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178621))
- [Finalize migration BackfillDetectedAtFromCreatedAtColumn](https://gitlab.com/gitlab-org/gitlab/-/commit/b39e2b7a1e9b1ced2f35eaa2f9bb1bed6a56903e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178847))
- [Creating table for scheduling user deletion](https://gitlab.com/gitlab-org/gitlab/-/commit/9e7fb70e48bd79bd5487da1f78bfdd2596516b73) by @Anzala09 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167520))
- [Remove Gitlab::Redis::ClusterDbLoadBalancing store post migration](https://gitlab.com/gitlab-org/gitlab/-/commit/04a4ee4a34370aeaebf8d32af3b952591a7ffc56) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178566))
- [Add not null constraint on dast_profiles_pipelines.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/0e9503bbd0cfcf490be1423fbee222e826003abc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177355))
- [Add not null constraint on vulnerability_finding_evidences.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/ed54de0b63934d399fd35aea64f5dacb15ba0970) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177374))
- [Finalize SkipCompanyOnboardingStep batched migration](https://gitlab.com/gitlab-org/gitlab/-/commit/2c6a8df111776ef4eabb2882a948f475f61e2af2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178780))
- [Finalize migration ResyncHasVulnerabilities](https://gitlab.com/gitlab-org/gitlab/-/commit/bfaeda1c54fdc6c67c27fa96d1ee2ec970a53caa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177797))
- [Mark 20240716141532 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/99c4346ef6dd695dd0dc27f067df221298cadec3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178351)) **GitLab Enterprise Edition**
- [Clean up dora_charts_forecast feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/f44868e274be3d757399e5f9beac44e3833096bd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178325)) **GitLab Enterprise Edition**
- [Add HangoutsChat instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/5377683a83230ac7eaed011c2f51b253bfa1de20) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178755))
- [Mark 20240807160655 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/4c7a55e2e3cf6cd793d495489e9e4322f1d31e80) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178352)) **GitLab Enterprise Edition**
- [Mark 20241003151804 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/d53bcbfd72a0f93c5104aa133bf16308fed1d0fe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178358)) **GitLab Enterprise Edition**
- [Add Clickup instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/332ae9e0bdce77ab46d7aef04f2a3839cbbd0360) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178007))
- [Optimize the update_index_used_bytes](https://gitlab.com/gitlab-org/gitlab/-/commit/5afc226f5f528ff1c3f1f53f866f1664e8c87289) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177575)) **GitLab Enterprise Edition**
- [Mark 20240704125425 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/1a05b4fda57d46ff60cdebd460de530d1340bd03) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178350)) **GitLab Enterprise Edition**
- [Validate `namespaces.organization_id` foreign key](https://gitlab.com/gitlab-org/gitlab/-/commit/b7fbfad1ef11b307c37d77da03bf14e21f9d12ea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178298))
- [feat: Abstracting SLIs' initialization step](https://gitlab.com/gitlab-org/gitlab/-/commit/b92bfebff3b12857cb1bdf83fd3eed8a29e0ca7a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177479)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/45a64269430845d5a6c27f92a0761a385120227e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178510))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/63d80b63c5d2014223583d86386d4f700a646331) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178667))
- [Finalize migration BackfillPackagesDebianGroupComponentsGroupId](https://gitlab.com/gitlab-org/gitlab/-/commit/6c7071415fba1263db6e69e772bb73ccde4d7a17) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178651))
- [Use project_id as sharding key for packages_nuget_symbols](https://gitlab.com/gitlab-org/gitlab/-/commit/79c8b82aff8db388a53d9951d05c2acfad25680b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178008))
- [Add placeholder instance integration models](https://gitlab.com/gitlab-org/gitlab/-/commit/b00d879b2f4dc49cac464dba2ba93578621fc2b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178597))
- [Guard against status changes](https://gitlab.com/gitlab-org/gitlab/-/commit/17f4c3a8cb8b1f1d59a8fc4cf80b65d32fe9604e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176574)) **GitLab Enterprise Edition**
- [Mark 20240826172514 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/07547820125a3bb78b248ea7d1f9542a4d3e54eb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178355)) **GitLab Enterprise Edition**
- [Remove the FF zoekt_index_marked_as_ready_event](https://gitlab.com/gitlab-org/gitlab/-/commit/340e3e57c64dcb360ef1ee88f7aae9918569f743) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178530))
- [Set approval_merge_request_rule_sources.project_id as NOT NULL](https://gitlab.com/gitlab-org/gitlab/-/commit/3d67ad91e0d07b33eb5da41f3669ba482620c4c6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177400))
- [Add NOT NULL constraint on approval_project_rules_users.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/e48a273237e6cda508751a2e730ac1d6d8a0d3ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177398))
- [Add NOT NULL constraint on terraform_state_versions.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/c228b5eee9c04c97ae1e0b59f44c470d69fc556e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177390))
- [Add NOT NULL constraint on terraform_state_versions.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/b8462258d998704242dba202ade83b838874a38c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177384))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/ac61e8330405e99ee23de2a6c0e306113e40dc87) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178509))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/7b244ddab79133161057c438b343031dffcf422c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177659))
- [Finalize migration RestoreOptInToGitlabCom](https://gitlab.com/gitlab-org/gitlab/-/commit/458f932198ca25205b3754c52678e1bc7560b2b0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177594))
- [Drop the virtual_registries_packages_maven_cached_responses table](https://gitlab.com/gitlab-org/gitlab/-/commit/e606f1e5d8e74f97982f31ae952a372a76e21b15) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178004))
- [Mark 20241002103536 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/8471665bc4b95d575d1ba743a285b889b630fa90) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178356)) **GitLab Enterprise Edition**
- [Mark 20240814231502 as obsolete](https://gitlab.com/gitlab-org/gitlab/-/commit/96b5af9e557110847b215998d7f014852354bbe0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178354)) **GitLab Enterprise Edition**
- [Remove feature flag new_pages_ui](https://gitlab.com/gitlab-org/gitlab/-/commit/c815f2aa35a1df6b8054510d1b910cd5f2f52f0e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178299))
- [Add alert_management_alert_user_mentions.project_id NOT NULL constraint](https://gitlab.com/gitlab-org/gitlab/-/commit/604fe630cc72a36deca1cea2eb905172cc23977f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177258))
- [feat: Record error rate on security scan reports](https://gitlab.com/gitlab-org/gitlab/-/commit/1eb4a3a7ddf52c49ab854b2cdc64d181852ab011) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170983)) **GitLab Enterprise Edition**
- [Remove project and group vulnerability management feature flags](https://gitlab.com/gitlab-org/gitlab/-/commit/9549996c4ebb9a2d139ede72019e377a062fd573) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178031)) **GitLab Enterprise Edition**
- [Create ClickHouse table siphon_merge_requests](https://gitlab.com/gitlab-org/gitlab/-/commit/cbb9f99a477ea2bb5170d9fb8f0738b960c9093a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178318))
- [Removing cascading-duo-features-for-instance FF](https://gitlab.com/gitlab-org/gitlab/-/commit/2a7611fe6975ca2362ba349ee52dd54f1f4849fc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178176)) **GitLab Enterprise Edition**
- [Validate the not null constraint on `projects.organization_id`](https://gitlab.com/gitlab-org/gitlab/-/commit/717f5c047622ebbd4d1813963683959dbabef039) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177722))
- [Add NOT NULL constraint on design_management_designs.namespace_id](https://gitlab.com/gitlab-org/gitlab/-/commit/dd3345a946ba3b08878fb4e4f85ede1b19404629) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177367))
- [Finalize copy runner taggings migrations](https://gitlab.com/gitlab-org/gitlab/-/commit/85a44bfdcc9c0faa52d9a5dd880aba62ac6c48da) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177881))
- [Add not null constraint on sbom_occurrences_vulnerabilities.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/1feb0a75c38ea67cb8240d45f3fd3cdbedab1325) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177361))
- [Add NOT NULL constraint on operations_strategies_user_lists.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/9c3671a630fb42b2a1328e545231732c5f1a4fde) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177372))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/e92a644cb1ca25bd91a2a190e73fdeae7bbacacd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178259))
- [Create ClickHouse siphon for issues](https://gitlab.com/gitlab-org/gitlab/-/commit/79ad43d04c904d7706c11da61efa240b26bc2435) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178218))
- [docs: Extend docs that delete protection is not yet implemented](https://gitlab.com/gitlab-org/gitlab/-/commit/987155062f2ba16b31ab410d2bdd2aa5c9ee0be8) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168822))
- [Add Bugzilla instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/6fe0086518345305014cacb8afd0ae7c1f42c756) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177441))
- [Drop table subscription_provision_syncs](https://gitlab.com/gitlab-org/gitlab/-/commit/55a78b4bbfd1d1114815d4113f76f03ab1e57101) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178183)) **GitLab Enterprise Edition**
- [Finalize BackfillCiRunnerMachinesPartitionedTable](https://gitlab.com/gitlab-org/gitlab/-/commit/742a13ca537d4bf69017ce3d8bb5bcbb1f7679c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177745))
- [Finalize migration BackfillPackagesDebianGroupArchitecturesGroupId](https://gitlab.com/gitlab-org/gitlab/-/commit/8af649161419c15e0e24e4e25f6409606e84a38b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178098))
- [[Feature flag] Cleanup mr_vulnerability_code_flow](https://gitlab.com/gitlab-org/gitlab/-/commit/abf9ea9e764390321623cc532403d79f0b809404) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177843))
- [Remove advanced_search_multi_project_select feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/e92628aa11393aa7f8058f25096b0eeae4428572) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178134)) **GitLab Enterprise Edition**
- [Add NOT NULL constraint on design_management_repositories.namespace_id](https://gitlab.com/gitlab-org/gitlab/-/commit/647f133eebaa73137b4bd3874af7ca9d0b84afdf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177368))
- [Update sharding_key_id for project runners if project is deleted](https://gitlab.com/gitlab-org/gitlab/-/commit/ede152ec014e694fc39c66a78507073870d3ed3a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178130))
- [Add NOT NULL constraint to cluster_agent_tokens.project_id column](https://gitlab.com/gitlab-org/gitlab/-/commit/17f2361b075b6a1a027cba02e57e6668995ab7d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177246))
- [Add not null constraint on related_epic_links.group_id](https://gitlab.com/gitlab-org/gitlab/-/commit/09ed995cc33788a4c4f2e950d480b444b2a68c76) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177352))
- [Add NOT NULL constraint on packages_debian_publications.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/6fc7c1c847852f68a11b62692cb6deaffacccb63) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177366))
- [Add schema for work item custom field values](https://gitlab.com/gitlab-org/gitlab/-/commit/4a6c7745042caa5c8a123052fc9766887ac0df9b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175312))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/806c24e496d81d21dba8f92de88c1a367e013720) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178112))
- [Direct code generation requests to v4 when client supports sse](https://gitlab.com/gitlab-org/gitlab/-/commit/68e34bab9e8dc51d3e1fccd8f850c5bce4ab4d7e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178094))
- [Add NOT NULL constraint on operations_strategies.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/767c776b85c16b02d4b1a4d5dfe2ecc24eea50d3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177371))
- [Finalize backfill_onboarding_status_role migration](https://gitlab.com/gitlab-org/gitlab/-/commit/f8ba8ce5ffa2105ca4e63fffae9ebec68616752a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177782))
- [Finalize migration for backfilling status checks project ID](https://gitlab.com/gitlab-org/gitlab/-/commit/93a0ec788f30f0d0c71aca6f6c50dd0d4ba79935) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177107))
- [Remove ApplicationSetting legacy AI columns](https://gitlab.com/gitlab-org/gitlab/-/commit/41b6bbe518711e6186f5de309012797336686785) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177600))
- [Finalize QueueBackfillComplianceViolationNullTargetProjectIds migration](https://gitlab.com/gitlab-org/gitlab/-/commit/1e6206fbba7f8f8b4740af4f0f546f284d347d0e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175905))
- [Remove orphaned managers from .com ci_runner_machines_687967fa8a](https://gitlab.com/gitlab-org/gitlab/-/commit/3b24c40f3c356c604ad2d3b4e34dc6aed856bee8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177774))
- [Fix backfill_p_ci_pipelines_trigger_id](https://gitlab.com/gitlab-org/gitlab/-/commit/83abdb491ce63e387756feaac3f3803d2ac0c99a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176645))
- [Add not null constraint on dast_pre_scan_verifications.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/3b9295e13abc9c136a6cfa028bd1861809247f0b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177354))
- [Validate fk_0e743433ff foreign key](https://gitlab.com/gitlab-org/gitlab/-/commit/b95d99a9a2e3b44c297935fecc217a2dc9c04075) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177757))
- [Finalize the DeleteOrphanedCiRunnerProjects migration](https://gitlab.com/gitlab-org/gitlab/-/commit/ce11d1a372d28dc8ff1a932f4e0a89f11f142445) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177757))
- [Finalize BackfillCiRunnersPartitionedTable](https://gitlab.com/gitlab-org/gitlab/-/commit/afb5cf865f93f20c29d0ddbf306df4f92d5d3a49) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177750))
- [Model Registry: Add metrics for users](https://gitlab.com/gitlab-org/gitlab/-/commit/373f4d641c51384be2bc7b748045180aafb253db) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177854))
- [Schedule the `namespaces.organization_id` foreign key to be validated](https://gitlab.com/gitlab-org/gitlab/-/commit/523cb12a667524e0e733f1be6cc5ca5d2c46b987) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177991))
- [Add not null constraint on dast_profiles_tags.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/205049d7b7120f6ec971e8189da90437f2ce1947) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177357))
- [Set compliance_framework_security_policies sharding keys as NOT NULL](https://gitlab.com/gitlab-org/gitlab/-/commit/5064d9c8143ee1df937d587387214fa62be7f508) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177388))
- [Add not null constraint on boards_epic_user_preferences.group_id](https://gitlab.com/gitlab-org/gitlab/-/commit/93900dfae9fb7f3670ce7fbc8b92b42f66dca0f3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177349))
- [Finalize migration BackfillMlModelMetadataProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/fbddc9f0f7ba64e94d677416b8a66e07e97869fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177939))
- [Finalize migration for Software Licenses without spdx](https://gitlab.com/gitlab-org/gitlab/-/commit/3702648dbd5a27e30c5f7c04661bc6960e77840b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175164))
- [Remove DeleteProjectWorker and feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/5892e0521f1f18508774c7dd66dbffa4de5e0b56) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177863)) **GitLab Enterprise Edition**
- [Finalize migration BackfillMergeRequestsClosingIssuesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/d58a2983e62e81593e0447fb5221f9cfbb298c20) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177644))
- [Add Bamboo instance integration](https://gitlab.com/gitlab-org/gitlab/-/commit/e1b01fe45e380380dc009c1d48c495bf766e9b93) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177145))
- [Set approval_group_rules_protected_branches.group_id as NOT NULL](https://gitlab.com/gitlab-org/gitlab/-/commit/d82b4950188c760030aa89963ee77187fd97a2dc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177396))
- [Add NOT NULL constraint on user_achievements.namespace_id](https://gitlab.com/gitlab-org/gitlab/-/commit/974870a1b5f07010443404e227bba25aecadd19c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177391))
- [Add NOT NULL constraint on audit_events_streaming_headers.group_id](https://gitlab.com/gitlab-org/gitlab/-/commit/916a274b615b9cca5826ed05d794bcbf4e306241) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177386))
- [Set audit_events_streaming_event_type_filters.group_id as NOT NULL](https://gitlab.com/gitlab-org/gitlab/-/commit/8e9aa5a91dccb90b5299a44e8903d3151ccf78c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177385))
- [Add NOT NULL constraint on workspace_variables.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/96a8c8685ceaa19dea59e1efd3a0a5ea7665401a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177383))
- [Add NOT NULL constraint on vulnerability_user_mentions.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/f2cbbc6568eba48be6f184875810100dd014a6b9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177381))
- [Add NOT NULL constraint on vulnerability_flags.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/722b67ecda2c30258e4ccf26309879388013b1cf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177380))
- [Add NOT NULL constraint on operations_feature_flags_issues.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/01ff8297ced0afbf06fcd4632e6fd32205504147) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177370))
- [Set packages_debian_project_distribution_keys.project_id as NOT NULL](https://gitlab.com/gitlab-org/gitlab/-/commit/b465a351cf71a53ec884ad9d9c3a086703639199) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177365))
- [Set packages_debian_group_distribution_keys.group_id as NOT NULL](https://gitlab.com/gitlab-org/gitlab/-/commit/d219be05e558234ff9ff47ee4ffeab298f468f65) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177363))
- [Add not null constraint on dast_site_validations.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/85eb588c6fe40cd7c53d935697e03779c5f395ac) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177360))
- [Add not null constraint on dast_site_profile_secret_variables.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/389c9d41dbe6c1dfd0180869c24f9b6f7af4aeaa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177359))
- [Add not null constraint on dora_daily_metrics.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/58b5ad11bcceb415fecb9c753154387eea0ff32c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177353))
- [Add not null constraint on boards_epic_board_positions.group_id](https://gitlab.com/gitlab-org/gitlab/-/commit/6a6d2ca461d278f31d8ca6056b3721be9dce1de2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177347))
- [Add not null constraint on boards_epic_board_labels.group_id](https://gitlab.com/gitlab-org/gitlab/-/commit/8a6f2a76f10ed888a62e548a5b0316b0bf1ababf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177343))
- [Add alert_management_alert_metric_images.project_id NOT NULL constraint](https://gitlab.com/gitlab-org/gitlab/-/commit/8c724247b9f6ada6c9280746f93b680bcbb70de3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177257))
- [Add NOT NULL constraint to alert_management_alert_assignees.project_id](https://gitlab.com/gitlab-org/gitlab/-/commit/717adc3ec7397658d12beb18421159e352e0ec54) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177252))
- [Add NOT NULL constraint to ml_experiment_metadata.project_id column](https://gitlab.com/gitlab-org/gitlab/-/commit/d0200b5b317b842f7bc2308a20760f8682bff3ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177249))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/c932e35efdc0e3c6f316a3c2d37045e115ce8cd5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176452))
- [Finalize migration BackfillRemoteDevelopmentAgentConfigsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/da4c63d7aab3685c3fbe9d1e48f68ba2162a0b5e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172769))

## 17.8.7 (2025-04-09)

### Security (5 changes)

- [Bump workhorse golang-jwt/jwt to 5.2.2](https://gitlab.com/gitlab-org/security/gitlab/-/commit/00f779daaff694529b5ae4d15011c6ed66ce8130) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4914))
- [Global search count leak for confidential issues](https://gitlab.com/gitlab-org/security/gitlab/-/commit/84a94c7a024ff295241bbf659812cd4a71bd2639) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4909))
- [Set the IP address state for Action Cable requests](https://gitlab.com/gitlab-org/security/gitlab/-/commit/41e74002f076ce8af8d6ed1b7452f5b03c94f291) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4906))
- [Adding validation for Ci::Pipeline](https://gitlab.com/gitlab-org/security/gitlab/-/commit/e1b887d7c7a826a696a2d459cbd7263b4d78d25c) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4886))
- [Add delay to when pointer events are enabled for 0Auth authorize page](https://gitlab.com/gitlab-org/security/gitlab/-/commit/c0202d64a770617d01884b47cac582867769c84b) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4853))

### Other (1 change)

- [No-op ci_runner_machines_687967fa8a table backfill migration](https://gitlab.com/gitlab-org/security/gitlab/-/commit/547295b6cfb9da651208fbe64da67d236ff813de)

## 17.8.6 (2025-03-26)

### Fixed (1 change)

- [Reorder runners backfill migrations](https://gitlab.com/gitlab-org/security/gitlab/-/commit/e822c803d82ba9ebb681f8885836dd2c1a0f25a3)

### Security (8 changes)

- [Sync organization user access when admin status changes](https://gitlab.com/gitlab-org/security/gitlab/-/commit/96c20dece9a6a1aa096d09207a6585caf32d5f1a) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4848))
- [Prevent XSS via merge error on the merge request page](https://gitlab.com/gitlab-org/security/gitlab/-/commit/b01080ce203d3c28b37c88937819e126d6e688bc) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4879))
- [Inherit current_user external status while rotating project/group token](https://gitlab.com/gitlab-org/security/gitlab/-/commit/5c5642c3379d72fc8906026113da4af1f76728ed) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4868))
- [Add validations for the project_name of Harbor integration](https://gitlab.com/gitlab-org/security/gitlab/-/commit/af608cad419e11ceeb0ec49997367c456f4178e4) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4859))
- [Sanitize returned input on asciidoc Timeout](https://gitlab.com/gitlab-org/security/gitlab/-/commit/cc7d8607c3b448b6ba98f0c205679ca051f9f903) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4843))
- [Add CI/CD project setting `allow_composite_identities_to_run_pipelines`](https://gitlab.com/gitlab-org/security/gitlab/-/commit/80d1a17d232460b6b5b80af89df631857c399eba) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4877))
- [Add limit to resource counts in tfplan merge request report](https://gitlab.com/gitlab-org/security/gitlab/-/commit/2dbaabebbcc1c6106ec695f2c1e1c793aab4e4a2) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4872))
- [Fix a typo in sitemap_controller_spec](https://gitlab.com/gitlab-org/security/gitlab/-/commit/eebde7538b3c48f030172d72e9ebf8c4a361fca4) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4861))

## 17.8.5 (2025-03-11)

### Security (8 changes)

- [Vendor GraphQL gem](https://gitlab.com/gitlab-org/security/gitlab/-/commit/1d1019ef7f1f447b9438221ff734f07cb8cfc6f7) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4840))
- [Ruby-SAML updates](https://gitlab.com/gitlab-org/security/gitlab/-/commit/f68b16e4319f01144c90b725e6ec62b3c2ca42bd) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4829))
- [Prevent custom role to activate group members](https://gitlab.com/gitlab-org/security/gitlab/-/commit/a1d818293e11796c71553e2c5eaba4e2f358db79) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4834))
- [approval_rules name is unbounded](https://gitlab.com/gitlab-org/security/gitlab/-/commit/89018f0df2df5c9b3c656a0981384ee3872a54e1) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4837))
- [Limit preview size](https://gitlab.com/gitlab-org/security/gitlab/-/commit/9824f5746a38e95dbfa5d991b69c18ec3e5c1194) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4822))
- [Maintainer can inject shell code in Google integration configurations that...](https://gitlab.com/gitlab-org/security/gitlab/-/commit/688e445b811a4ffa2e2a175effe4f211af57afe8) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4825))
- [Filter out internal notes if the recipient do not have access](https://gitlab.com/gitlab-org/security/gitlab/-/commit/117de613cd4025a41c93a25809dd4c5bd47df7b4) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4814))
- [Mask unencoded userinfo in project mirror errors](https://gitlab.com/gitlab-org/security/gitlab/-/commit/73a0c85541ef22125c52be1b4980ced1bfbc1dba) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4777))

## 17.8.4 (2025-02-26)

### Security (4 changes)

- [Increase minimum role in SPP to read policy yaml](https://gitlab.com/gitlab-org/security/gitlab/-/commit/9bfcf4a596b965ce73426d68861cec83ee70f19e) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4716))
- [Fix access to read code review analytics in private projects](https://gitlab.com/gitlab-org/security/gitlab/-/commit/537159f505cad7d23cded01140fbdfd84e9cdfa2) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4758))
- [Escape work item dropdown items and restrict HTML tags](https://gitlab.com/gitlab-org/security/gitlab/-/commit/5548168c3d4e0ba660ed934f23c332045a640799) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4784))
- [Use stricter CSP values in the packages dependency proxy](https://gitlab.com/gitlab-org/security/gitlab/-/commit/d491abd511c9c1cb00c928e28dc84cb7ef8e4cd3) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4764))

## 17.8.3 (2025-02-21)

### Fixed (2 changes)

- [Use primary DB when authenticating via job token in jobs API](https://gitlab.com/gitlab-org/gitlab/-/commit/6eee5c6811cac82981252280f1b08316ae8c1fd5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181872))
- [Revert stricter workhorse route regexes](https://gitlab.com/gitlab-org/gitlab/-/commit/aba07e94e0587dd378dccbdf18dfe839f09078bf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181358))

## 17.8.2 (2025-02-11)

### Fixed (3 changes)

- [Fix storing incorrect policy index in scan_result_policies](https://gitlab.com/gitlab-org/security/gitlab/-/commit/49e2809628b91b4200b62faf512ae73ba4bfaa27) **GitLab Enterprise Edition**
- [Enable ai tracking even with feature flag disabled](https://gitlab.com/gitlab-org/security/gitlab/-/commit/27526bdc24302c80940356e93928956ea6cb21d3) **GitLab Enterprise Edition**
- [Fix Workhorse failing on 64-bit unaligned access on Raspberry Pi 32-bit](https://gitlab.com/gitlab-org/security/gitlab/-/commit/a026bcb6a7a0a69329ab6cc63cfe2ef51a7d2d83)

### Security (8 changes)

- [Security Duo Chat Escape Unknown Domain Hyperlinks](https://gitlab.com/gitlab-org/security/gitlab/-/commit/44436a9c648b077a89efb5d2b394f36702f0e315) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4706))
- [Hide sensitive workhorse headers and fix route confusion between web and workhorse routes](https://gitlab.com/gitlab-org/security/gitlab/-/commit/80e0601861d797ed6126b999c5830409ee5e8abf) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4760))
- [Do not allow Planner role to update or delete incidents](https://gitlab.com/gitlab-org/security/gitlab/-/commit/3c76c42d1451fea9f74aec4ff31d17483f8c2d14) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4746))
- [Reduce memory allocations on create PAT endpoint](https://gitlab.com/gitlab-org/security/gitlab/-/commit/3183ac5d359b349b248dfb6d094e6791b2cf716a) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4750))
- [Prevent SSRF attacks for Workspaces](https://gitlab.com/gitlab-org/security/gitlab/-/commit/ad1ddf3353d1817d3b7eb583ea333dab0dd3f6a2) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4729))
- [Prevent read code access when repository is disabled](https://gitlab.com/gitlab-org/security/gitlab/-/commit/be2a9c24d18e2735f4d8e640bfd61633851da60e) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4705))
- [Fixes XSS on the target branch in the merge request widget](https://gitlab.com/gitlab-org/security/gitlab/-/commit/3de176b1ee5c0df452d265a9ca39ae950c9553aa) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4735))
- [Unsubscribe from actioncable channel when PAT is revoked](https://gitlab.com/gitlab-org/security/gitlab/-/commit/85760efaf82d85241732360045a1763095740049) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4725))

## 17.8.1 (2025-01-22)

### Security (4 changes)

- [Fix protected variable exfiltration](https://gitlab.com/gitlab-org/security/gitlab/-/commit/998874eb0ed029872a47991788565213aa6707b8) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4713))
- [Enhance rich viewer sanitization](https://gitlab.com/gitlab-org/security/gitlab/-/commit/895088208f7a39aad0bd9cd8dbec8cf6b8f8f1f3) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4708))
- [Avoid recursive sidekiq calls on cyclic work item hierarchies](https://gitlab.com/gitlab-org/security/gitlab/-/commit/1872a670e73e294db21773d8289bc51c6b9ec9aa) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4711))
- [Respect the private profile constraints](https://gitlab.com/gitlab-org/security/gitlab/-/commit/f434b2e5d6542b3d762852a725a19780d6966db1) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4704))

## 17.8.0 (2025-01-15)

### Added (127 changes)

- [Add more specs for most_recent_commit_sha method](https://gitlab.com/gitlab-org/gitlab/-/commit/12172c6fcc8ca1b7b77acaab3d0d3ce508a8a1f2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176467)) **GitLab Enterprise Edition**
- [Update runners owned by non-existent projects](https://gitlab.com/gitlab-org/gitlab/-/commit/804d81dc1ab1d576b6c27168a1e0d7c82fddfcd0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177271))
- [Delete orphaned project runners when project is deleted](https://gitlab.com/gitlab-org/gitlab/-/commit/a78c44336335a6f7e3f156bbda44bbee6f06739e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176879))
- [Allow configuring "auto_stop_setting" through graphql](https://gitlab.com/gitlab-org/gitlab/-/commit/369ad4b24d91cb8a4eaf613a53e44f01fe7c42c7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176083))
- [Create GraphQL query for the pages settings](https://gitlab.com/gitlab-org/gitlab/-/commit/2d64cec39dccdd31ceb3d78409b6d76bcaccba36) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169835))
- [Add elastic client to active context gem](https://gitlab.com/gitlab-org/gitlab/-/commit/8cb64dfa3f2a6dd172b6cbd92a1d22f6a70c038d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176973)) **GitLab Enterprise Edition**
- [Save branch name of code suggestion events](https://gitlab.com/gitlab-org/gitlab/-/commit/a24f245be6492d3fb3ca153b571d4a193035983f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176389)) **GitLab Enterprise Edition**
- [Release protected pypi packages feature](https://gitlab.com/gitlab-org/gitlab/-/commit/ce95ef89875fbd7b4ee54a7b0ad7ad14e64a5e98) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177096))
- [Model experiments: Add href to CI Job](https://gitlab.com/gitlab-org/gitlab/-/commit/59fc8c9973c5ede619bf2c3a7b5788585d10e388) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177710))
- [Add graphql field ai_xray_reports to ProjectType](https://gitlab.com/gitlab-org/gitlab/-/commit/1a563af4a1ca22fa4cef9f54e0e7590bc33167f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176901))
- [Add LinkedResources work item widget placeholder](https://gitlab.com/gitlab-org/gitlab/-/commit/03da3ff54eec1262503bfd43c2f8504ec9b714c0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177508))
- [Add ability to add related item for work items](https://gitlab.com/gitlab-org/gitlab/-/commit/68147984bf315d22883e61fdec6b0c7dde9876ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176169))
- [Create siphon ClickHouse table for projects](https://gitlab.com/gitlab-org/gitlab/-/commit/cb4845306917c82ca1d2dcca50863a149dbe2cae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177486))
- [Add Rest and GraphQL API to configure scheduled merge](https://gitlab.com/gitlab-org/gitlab/-/commit/7cfd279b88758ae09abd783e473feb229ec01693) by @Taucher2003 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177300))
- [Promote runs in a model's experiments to a model version](https://gitlab.com/gitlab-org/gitlab/-/commit/ba293bdcd29f6be9b4cd70e934adc30db76269f2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177110))
- [Allow users to configure skip_ci for pipeline execution policies](https://gitlab.com/gitlab-org/gitlab/-/commit/e1da67076029b7bce6e06099da80bdd9c9f0085d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177394)) **GitLab Enterprise Edition**
- [Add indices for sharding_key_id for runners and runner managers](https://gitlab.com/gitlab-org/gitlab/-/commit/4ae5548552345ef788ad95bce89037f89816c39f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176865))
- [Release protected container repositories feature](https://gitlab.com/gitlab-org/gitlab/-/commit/794937eea2cc3e9bea794d7edde61e1c0c8fdcaa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173811))
- [Add resolve MR discussion arguments to create work item mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/20d3bf017c1af78bdb40b98dfbcb2786502d189a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177211))
- [Add directory or file name with icon](https://gitlab.com/gitlab-org/gitlab/-/commit/916cf3e2856bc818e15482bb1fb351c014cac568) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177261))
- [Adds workflows_definition to Duo Workflow](https://gitlab.com/gitlab-org/gitlab/-/commit/651b3faceb9296c49c0787b38ae03561b7dba05a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176266)) **GitLab Enterprise Edition**
- [Allow filtering tokens by before and after expires at](https://gitlab.com/gitlab-org/gitlab/-/commit/284d6005e973048ce2b1577ad1c6eb9b192dc1b9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176996))
- [Adds bso instrumentation metric](https://gitlab.com/gitlab-org/gitlab/-/commit/1ab0ff584629d2c39c169e607fb769c3248cf62a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177262)) **GitLab Enterprise Edition**
- [Update runner taggings owned by non-existing projects](https://gitlab.com/gitlab-org/gitlab/-/commit/f9e9740a37ec25fdd28f6aaa2a0a0424b579f903) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177453))
- [Update runner managers owned by non-existing projects](https://gitlab.com/gitlab-org/gitlab/-/commit/5240af72f0d253320dad4de85f8b1820786d0562) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177423))
- [Mock Api for custom statuses](https://gitlab.com/gitlab-org/gitlab/-/commit/1ec52b6baacd07710423764949e8c240f6be547a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176843)) **GitLab Enterprise Edition**
- [Surface user.type to frontend](https://gitlab.com/gitlab-org/gitlab/-/commit/054cb968685487f728481e995e00871ef9672432) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175972))
- [Remove use_list_commits_rpc_network_graph feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/4a638bc7cfab46736cad21ccf8b6494f55bda109) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177373))
- [Add support in UI to select Pages primary domain](https://gitlab.com/gitlab-org/gitlab/-/commit/b8eba5f91ab2cfa56f0aa39a00e0484485fa126d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176699))
- [Model experiments: Improve candidate table](https://gitlab.com/gitlab-org/gitlab/-/commit/dd5da6033c717c8f8fa1abc874eca7ac73bddac4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176099))
- [Add Restricted Access option to Seat Controls](https://gitlab.com/gitlab-org/gitlab/-/commit/c784016c9f1d2924ccc8536b5868882e05c81d89) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175705)) **GitLab Enterprise Edition**
- [Add linkedWorkItems field to EpicType](https://gitlab.com/gitlab-org/gitlab/-/commit/36b8d5bf970e0c4805b25b12e3f95cdc1b1e1a20) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177097)) **GitLab Enterprise Edition**
- [Use legacy destination helper in legacy destination create APIs](https://gitlab.com/gitlab-org/gitlab/-/commit/e41835e675afad567a6c7cff57d12c93e33bff15) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175753)) **GitLab Enterprise Edition**
- [Add xray context to /refactor](https://gitlab.com/gitlab-org/gitlab/-/commit/f1d5eda1204b3402757964fd9cb50e50934b5bd1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173750)) **GitLab Enterprise Edition**
- [Add optional variables for passing on to CI](https://gitlab.com/gitlab-org/gitlab/-/commit/43302ca2aea99ba03e1f501ee78f121c05b609cf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177026)) **GitLab Enterprise Edition**
- [Group level support for dropdown API](https://gitlab.com/gitlab-org/gitlab/-/commit/b9e8335618948f9e471650f4857380b1c7ff9e64) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175902)) **GitLab Enterprise Edition**
- [Enable group-level vulnerability management policies by default](https://gitlab.com/gitlab-org/gitlab/-/commit/5857afaaf061217e83648bb2f220cdc6a46f0049) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177228)) **GitLab Enterprise Edition**
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/3278b6c4e7ee89f1ab64c1a76e0c8411aacdd249) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177213))
- [Full support for Vulnerability Webhook events](https://gitlab.com/gitlab-org/gitlab/-/commit/1a36642693f7abedf61e1a1b082a708e6faaa6be) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176064)) **GitLab Enterprise Edition**
- [Remove amazon_q_integration feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/effde0dc90e9accf7fbcee6d25fa75773bfa0791) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177196))
- [Search in accessible deploy keys](https://gitlab.com/gitlab-org/gitlab/-/commit/2a24e17deec63d2d9f9f2fd149241e99f262a0c1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176538))
- [Model experiments: Add copy button to MLflow usage](https://gitlab.com/gitlab-org/gitlab/-/commit/9cc8565d80140f4ba12d716b3d5950be320b9be1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176037))
- [Model experiments: Add experiment id](https://gitlab.com/gitlab-org/gitlab/-/commit/998afb6a4e142ec30c394237103fe61029c8fed2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177119))
- [Add linkedWorkItems field to EpicType](https://gitlab.com/gitlab-org/gitlab/-/commit/ebec8b8de0790492679ae32695e694ecaefa1bcd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177116)) **GitLab Enterprise Edition**
- [Model experiments: Add creator to candidates table](https://gitlab.com/gitlab-org/gitlab/-/commit/2631c30f7244a381b39356c2f7b39280ef06090f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176121))
- [Adding project control status table](https://gitlab.com/gitlab-org/gitlab/-/commit/ef78b3c2d2c6a19d95828ad83ba64ba7c32c0264) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176581)) **GitLab Enterprise Edition**
- [Model experiments: Add creator field to candidates type](https://gitlab.com/gitlab-org/gitlab/-/commit/f347666c05b01d650172c031e55459060b0ab192) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177073))
- [Add retry_duo_workflow_execution event](https://gitlab.com/gitlab-org/gitlab/-/commit/37e847fa45ba298059a97a46df58a588741cb895) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177070)) **GitLab Enterprise Edition**
- [Model experiments: Add Experiments to GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/bb25ee1fcc2a5ada1e018f4746576128b92521d4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175815))
- [Added destroy requested changes GraphQL mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/f8b808fc0a86354d7f059ac7aa5a76741f95145f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176363)) **GitLab Enterprise Edition**
- [Sync index for p_ci_pipelines.trigger_id](https://gitlab.com/gitlab-org/gitlab/-/commit/a3ab66164f942f5b75b7488a9970ab74d0260d6b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175213))
- [Add CUD endpoints for tag protection rule](https://gitlab.com/gitlab-org/gitlab/-/commit/492be0979e6ebdea14e83391e6a6b00aefba9f4e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175736))
- [Introduce lazy loading of projects list in framework drawer](https://gitlab.com/gitlab-org/gitlab/-/commit/277ec524094270497316264c03f7c1ca1bfe547d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175197)) **GitLab Enterprise Edition**
- [Add skip ci configuration](https://gitlab.com/gitlab-org/gitlab/-/commit/a3872d7eae9bea5728f798676d810e5688852f16) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176523)) **GitLab Enterprise Edition**
- [Add optional variables to dast_site_profiles table](https://gitlab.com/gitlab-org/gitlab/-/commit/2d60326719cf0cfe87242b41ee384f066ad9a846) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175476)) **GitLab Enterprise Edition**
- [Helper method for legacy audit event destinations graphql create](https://gitlab.com/gitlab-org/gitlab/-/commit/30c134a30592562a655dfa0d2851e20033125c49) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175628)) **GitLab Enterprise Edition**
- [Helper method for audit event destinations graphql create](https://gitlab.com/gitlab-org/gitlab/-/commit/91bade77a232e4a7e25ceec894054995b7a95c6a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173752)) **GitLab Enterprise Edition**
- [Create v2 enpoints and add feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/dabbf89307bc51bfc77cd851e263ade3f88e4e2b) by @ScanianJP ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165034))
- [Link user_destroyed event for user provisioned by group to the group](https://gitlab.com/gitlab-org/gitlab/-/commit/7ca8e4bfed2efc57a262c8ad19e8926c174b55ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176405)) **GitLab Enterprise Edition**
- [Remove log_advanced_search_cluster_health_elastic flag](https://gitlab.com/gitlab-org/gitlab/-/commit/79590ee3215f2def69bf1d6e52999aaae2873f3a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177076)) **GitLab Enterprise Edition**
- [Add skip ci configuration to a policy drawer](https://gitlab.com/gitlab-org/gitlab/-/commit/a09baa682f840942f6753c3c950f15697739f00e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176616)) **GitLab Enterprise Edition**
- [Add licenses to scan_result_policies](https://gitlab.com/gitlab-org/gitlab/-/commit/3d533069346897fd4d4c6488f4e1ab02e6fda3a3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176715)) **GitLab Enterprise Edition**
- [GraphQL: add TagCreate mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/9f592e98a4c9c47105273c43009ac469391446a3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175833))
- [Update policy schema to support package exclusion](https://gitlab.com/gitlab-org/gitlab/-/commit/7038d8b9d88afa2e61cf7178a52f27012337f00c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176433)) **GitLab Enterprise Edition**
- [Delete orphaned ci_runner_projects records](https://gitlab.com/gitlab-org/gitlab/-/commit/d319bae2246e991c0c7abcca80c46120c90f5b09) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176676))
- [Add an audit event for user provisioning by group SCIM](https://gitlab.com/gitlab-org/gitlab/-/commit/b224928751954887e24552dea819c3a62b7ca169) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174040)) **GitLab Enterprise Edition**
- [Reorganise project-level packages and registries settings](https://gitlab.com/gitlab-org/gitlab/-/commit/cb82e5ebef1d1e4f2bb1605a703accb32fe30841) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176343))
- [Added merge request requested changes to the merge request GraphQL type](https://gitlab.com/gitlab-org/gitlab/-/commit/f79b3606d62680ab7d7ef9608e4c30591d764ed3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176300))
- [Enable third-party UCM flags by default](https://gitlab.com/gitlab-org/gitlab/-/commit/b381a70264f81842fa48112e540c5289e490fad4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176675))
- [Set gh user mapping ff to true](https://gitlab.com/gitlab-org/gitlab/-/commit/c52246f6f097060bf2fdc5c52378958a2a5cfdb1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176633))
- [Update loading state of create merge request button](https://gitlab.com/gitlab-org/gitlab/-/commit/e89f8643e23c4bfcf0bd1be7e28f000d77d66501) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176481))
- [Show title suggestions to project work items](https://gitlab.com/gitlab-org/gitlab/-/commit/5cc74f8a8e52f8281e430621451aaefff290398a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176455))
- [Add new table subcsrption_provision_syncs](https://gitlab.com/gitlab-org/gitlab/-/commit/dcb7051432bfa43cae676a76f8c04dda739bc586) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176606)) **GitLab Enterprise Edition**
- [Automatically enable group hierarchy optimization](https://gitlab.com/gitlab-org/gitlab/-/commit/25d6eb5f54ef2cbf2b83c900ea42a7e0de852221) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176648))
- [Fix policies update MR blocked](https://gitlab.com/gitlab-org/gitlab/-/commit/dc144264209fbc0422a9a2d41613145ef1a4a319) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176608)) **GitLab Enterprise Edition**
- [Expose `move_design` policy in GraphQL permission type](https://gitlab.com/gitlab-org/gitlab/-/commit/fc4abdf1ccadc41a9286422966126a3aaef2780f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176542))
- [Adding tables and models for requirement controls](https://gitlab.com/gitlab-org/gitlab/-/commit/5ede88ea8d4a6299ab0a6debd2521a5e9e2290e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175812)) **GitLab Enterprise Edition**
- [Log all AI Gateway responses related to Amazon Q](https://gitlab.com/gitlab-org/gitlab/-/commit/90c36b09f7f143abf7b0d840136c7e14d93d879a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176548))
- [Expose EPSS and KEV in finding entity](https://gitlab.com/gitlab-org/gitlab/-/commit/585fa176ec99ccaccd94de6e8975dd99a539a59e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175792)) **GitLab Enterprise Edition**
- [Remove track_member_activity feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/314c13081b1c421eed21b4f168503d04b364d1bd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176480))
- [Remove epic_and_work_item_associations_unification ff](https://gitlab.com/gitlab-org/gitlab/-/commit/6d915390b0b9e1842d7ceba97af2db1ac7f76f65) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170264)) **GitLab Enterprise Edition**
- [Show modal when updating with pipeline](https://gitlab.com/gitlab-org/gitlab/-/commit/18651dfefffe31a7855deb28dc5774361c2ab13c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173584)) **GitLab Enterprise Edition**
- [Add API endpoints and services for Account Ownership Verification PIN](https://gitlab.com/gitlab-org/gitlab/-/commit/1f436f665766f88e87ebf24893cc5000cf16ac4a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175040))
- [Add read compliance dashboard as a custom ability](https://gitlab.com/gitlab-org/gitlab/-/commit/5c754f867624f9629735a9af190de40a287e7d49) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175066)) **GitLab Enterprise Edition**
- [Add Amazon Q system note support](https://gitlab.com/gitlab-org/gitlab/-/commit/72e510361ea5f54702be76e4bdf087bb3c0555ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176413))
- [Add `async` arg to `PipelineCreate` mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/e608229d005ddc6bc8011fe2a6c780c89c50bf7c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174577))
- [Add quick actions messages to work items](https://gitlab.com/gitlab-org/gitlab/-/commit/f5e9f208c99488c49613021cd141f7a1a143696b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175449))
- [Add topic to catalog resources](https://gitlab.com/gitlab-org/gitlab/-/commit/f85f2927590e6f8ffc5580bb090313c731e9ce1e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176257))
- [Add a confirmation alert when an environment is protected/unprotected](https://gitlab.com/gitlab-org/gitlab/-/commit/4740c742ece1da0cd5c7c9414861b3ea6dc8640d) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176103)) **GitLab Enterprise Edition**
- [Implement project secrets graphql query](https://gitlab.com/gitlab-org/gitlab/-/commit/21e07e933143d1a1db5eef0a0f38e4688ba95866) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175603))
- [Show Closed MRs deprecated in the list](https://gitlab.com/gitlab-org/gitlab/-/commit/caae8a052e8ab01c57213fb25c3dcceb7cbdb2c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176087))
- [Defined event and metrics](https://gitlab.com/gitlab-org/gitlab/-/commit/35b2c20ddcbe1f307b138ac577e26506b5e66e80) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175762)) **GitLab Enterprise Edition**
- [Remove create branch and merge request from behind FF](https://gitlab.com/gitlab-org/gitlab/-/commit/5556cb570226109a78a012fbfdbc5d21d1b06de9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176218))
- [Show warning when approval settings are overridden for MR](https://gitlab.com/gitlab-org/gitlab/-/commit/f901f9cbc8717ef2e00e6378ccde48bf4e1ae7be) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175674)) **GitLab Enterprise Edition**
- [Make composite_identity FF default enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/e8cec24fb2ff7ab6dbb77ae1e69a469e217851ff) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176301))
- [Model registry: Add empty state to candidate list](https://gitlab.com/gitlab-org/gitlab/-/commit/65c7d3da7f372c08617dd02e68ab19f95920d601) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176122))
- [Implement delete pipl users](https://gitlab.com/gitlab-org/gitlab/-/commit/cb5dfce0419853bd2be312d2cb2177832db76d39) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175861)) **GitLab Enterprise Edition**
- [Add arkose_labs_data_exchange_enabled setting](https://gitlab.com/gitlab-org/gitlab/-/commit/1b5f4168d0c7bcfa45354b647a9e7840fd62bedb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176034)) **GitLab Enterprise Edition**
- [Model experiments: Split Experiment card into tabs](https://gitlab.com/gitlab-org/gitlab/-/commit/fc03c89d7d8e3bd6d40f1bd6d1f2e06bd95f6600) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174686))
- [Allow configuring "auto_stop_setting" through Environments API](https://gitlab.com/gitlab-org/gitlab/-/commit/88f28e81ec895d8c5c96a0ae469e8a405d4696ed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175940))
- [Connect Amazon Q trigger service to issuable create/update](https://gitlab.com/gitlab-org/gitlab/-/commit/ad22de2e58d32d25b4e7fd2edef88778a7eee6d3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176221)) **GitLab Enterprise Edition**
- [Connect Amazon Q trigger service to quick actions](https://gitlab.com/gitlab-org/gitlab/-/commit/9f4f0eced50aa434eee04aa73415f1c91a606e1a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176217)) **GitLab Enterprise Edition**
- [Add `inputs` key to trigger include objects CI schema](https://gitlab.com/gitlab-org/gitlab/-/commit/c5727f72a70cb9f8d91967c69b097957f9ad8bf7) by @Ben.Leith ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173216))
- [Add 'Start review' button to MR Overview](https://gitlab.com/gitlab-org/gitlab/-/commit/9138d1311b749b3c0cc4c9c80782537b15923598) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169815))
- [Add `group_analytics_dashboard_editor` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/016034f278e3727cf548499607c5c1fd4d475bda) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175604)) **GitLab Enterprise Edition**
- [Add base support for Amazon Q quick actions service](https://gitlab.com/gitlab-org/gitlab/-/commit/7f0d00e0c7eba45f88869e46621240d9860d1b8e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175919))
- [Add duo_add_on_groups config for LDAP](https://gitlab.com/gitlab-org/gitlab/-/commit/58cab9d68b3cbaddda171bbe6cd7f4fbcd727d32) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175101)) **GitLab Enterprise Edition**
- [Model registry: Add link to candidate](https://gitlab.com/gitlab-org/gitlab/-/commit/f0b433de5bd79fe2347a34bc5393b2ef5403c81b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176149))
- [Add audit event to CreateRunnerService](https://gitlab.com/gitlab-org/gitlab/-/commit/dfaa9d256941e78e614e5d276a1dfa9a82f627b0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175447)) **GitLab Enterprise Edition**
- [Model experiments: Enhance experiment card title](https://gitlab.com/gitlab-org/gitlab/-/commit/66eb033cb2d8b0da8423f648de5e8352d1ceea98) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175700))
- [Show Related MR's in dev widget with deduplication](https://gitlab.com/gitlab-org/gitlab/-/commit/6f65f199034936fbf8385593dfd27a06fcca42bd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174812))
- [Add iteration support to content editor](https://gitlab.com/gitlab-org/gitlab/-/commit/c842a08facaeb9ba6945d7a9e67f4c8710a36bc8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175981))
- [Adds scheduled workers for dormant member removal](https://gitlab.com/gitlab-org/gitlab/-/commit/1921d01eb14fd691ed3f9a8a7138bcb9ab3cb35f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157930))
- [Add web_hook_logs_daily table](https://gitlab.com/gitlab-org/gitlab/-/commit/8bb2d8c31fdddd7a8c5f2369bfc52503cdf4c516) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175379))
- [Update semver_dialects to 3.4.5](https://gitlab.com/gitlab-org/gitlab/-/commit/ac417ebfca206d21d557bda4a21cc8d3f54d0837) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175297))
- [Add status deprecated to the packages statuses](https://gitlab.com/gitlab-org/gitlab/-/commit/a66644a0a15aad39b43384e447ce3184de92f900) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174312))
- [Add ability to assign GitLab Duo seats based on SAML groups](https://gitlab.com/gitlab-org/gitlab/-/commit/2e5ea3cb9cb2db172f80479e5ffcbd3d16af6e6a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170502)) **GitLab Enterprise Edition**
- [Extend GraphQL with  policies overriding project approval settings in MR](https://gitlab.com/gitlab-org/gitlab/-/commit/4cd2fe2da596e9c3a560ca4d149bcff100ad0683) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175614)) **GitLab Enterprise Edition**
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/bbafba73fd3eeb17747eb5ae6526b1a022134f2c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176014))
- [Add container tag protection rules to project](https://gitlab.com/gitlab-org/gitlab/-/commit/b18810e676c3ea3f84dd60bd8c0ff6a79196ed7d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174954))
- [Model registry: Add Experiment to model card](https://gitlab.com/gitlab-org/gitlab/-/commit/cf4046fa83d03710c65263f0b482ec4c565a0c9d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174378))
- [Add unique domain regenerate button](https://gitlab.com/gitlab-org/gitlab/-/commit/3268fba94e3c77b896008db3cc6d5da5b1dc7a8a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172479))
- [Add warning modal when creating work item](https://gitlab.com/gitlab-org/gitlab/-/commit/da38beec44ec6f3cd4505b0264409b0dfac72b79) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170657))
- [Add arkose_labs_enabled application setting](https://gitlab.com/gitlab-org/gitlab/-/commit/4c5867249aabba2a2403888b11e3ddc5a5171a81) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175748)) **GitLab Enterprise Edition**
- [Remove feature flag custom_ability_admin_push_rules & keep new code](https://gitlab.com/gitlab-org/gitlab/-/commit/a720e9f423f13723160a3659b97928433b30e998) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175807))
- [Adding Service Ping metric for dependency api](https://gitlab.com/gitlab-org/gitlab/-/commit/73a7f22b0ad0f3b4238f2bd7e0e95b1331f4bb51) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175725)) **GitLab Enterprise Edition**
- [Add support for using ActiveRecord::Encryption](https://gitlab.com/gitlab-org/gitlab/-/commit/df74fa198c25095508b54e765d4629959b1e44ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175154))

### Fixed (88 changes)

- [Prevent Direct Transfer from incorrectly marking entities as stale](https://gitlab.com/gitlab-org/gitlab/-/commit/9815b2ccb4b9a4fffec75884b8aa34cb2604e73c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177587))
- [Reassign runner's owner when owning project is deleted](https://gitlab.com/gitlab-org/gitlab/-/commit/0a8f791205092ca19ea34d7623eb463237627e3a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176879))
- [Fix visitor location country localization](https://gitlab.com/gitlab-org/gitlab/-/commit/ce7e367a04bfbc5f8fd863b83030c6ad0beacb38) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177761))
- [Reset `resolved_at` attribute vulnerabilities](https://gitlab.com/gitlab-org/gitlab/-/commit/ec370e873dd44e6fc76d4fb6ad394a94176e663e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177713)) **GitLab Enterprise Edition**
- [Fix `/unlink` quick command to work with epic work items](https://gitlab.com/gitlab-org/gitlab/-/commit/538cbb0d79866ef533aa458bca7fc530076c4028) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177763)) **GitLab Enterprise Edition**
- [Use NamespaceProjectIdsEachBatch instead of for_group_and_its_subgroups](https://gitlab.com/gitlab-org/gitlab/-/commit/144b66e5dce6ece67e746aa2bec0a5dd8af858fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177091))
- [Add resource context to Duo Chat history](https://gitlab.com/gitlab-org/gitlab/-/commit/68c5d5b33f87810c8071a4c6c79632bc368232c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174881)) **GitLab Enterprise Edition**
- [Protected Container Repositories: Fix link in documentation](https://gitlab.com/gitlab-org/gitlab/-/commit/ad0cab62b9755d3eabb0af2faa8f17d6521cf44d) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177672))
- [Fix UI text in lock and unlock file modal](https://gitlab.com/gitlab-org/gitlab/-/commit/5e8244ddb76abf11b548ba24a4623bdd9e37823e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177601)) **GitLab Enterprise Edition**
- [BBS handle missing users when user mapping](https://gitlab.com/gitlab-org/gitlab/-/commit/28ac706e06c66f8ea9f8b2d68d34211e12a6dea1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177321))
- [Documentation and refactor for Duo group/subgroups bug fix](https://gitlab.com/gitlab-org/gitlab/-/commit/2d69d67ca8be67bd0d8a4e661756107ecbd3d6c0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177340)) **GitLab Enterprise Edition**
- [Make ClickHouse write buffer workers compatible with Redis 6.0](https://gitlab.com/gitlab-org/gitlab/-/commit/cab74b70535f6d1b7bc5e9596875e20469d15b7c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176184))
- [Update FinishBatchedRelationExportWorker to fail export on timeout](https://gitlab.com/gitlab-org/gitlab/-/commit/55b1e3c03a894aca2ae15a63c726899a9fb7dd67) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177559))
- [Last commit: Fix alignemnt of right content](https://gitlab.com/gitlab-org/gitlab/-/commit/270547c59af84924adfde92cf61fa39d18f97895) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177543))
- [Fix circular reference with pipeline execution policy variables](https://gitlab.com/gitlab-org/gitlab/-/commit/be4dfeff61d610be9801a27cf64269b05c9cec37) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176152)) **GitLab Enterprise Edition**
- [Update Secure sub-section of the sidebar to show only permitted items](https://gitlab.com/gitlab-org/gitlab/-/commit/28e52591b2c2d87e1288e43f7792f060093ec547) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175865)) **GitLab Enterprise Edition**
- [Fix Pages primary domain not getting saved](https://gitlab.com/gitlab-org/gitlab/-/commit/0e9055eb18a8187cb201c9500b0a33d76bd33f1b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177424))
- [Set the used_storage_bytes to default when it is 0](https://gitlab.com/gitlab-org/gitlab/-/commit/a06f86d21e04f401843f8aa667efe134363e8ed4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177419)) **GitLab Enterprise Edition**
- [Lazily initiate a Redis publish/subscribe channel](https://gitlab.com/gitlab-org/gitlab/-/commit/e8deefcce4bba742843c6958eb58ff1f8a80630a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177057))
- [Fix handling of short gzip metadata files](https://gitlab.com/gitlab-org/gitlab/-/commit/978fa9a5fee79895a493d63b32c9ea08e73c8c49) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177221))
- [Apply all filters to flowMetricsQuery](https://gitlab.com/gitlab-org/gitlab/-/commit/dfd1585cbe3c4074a43841bdfad1ef6882bd4175) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176346))
- [Update the default API value for environment auto stop setting](https://gitlab.com/gitlab-org/gitlab/-/commit/8bd0140346bd7061b8ac642470f434569fb15895) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177328))
- [Make sure MR sticky header is accessible when browser font size=large](https://gitlab.com/gitlab-org/gitlab/-/commit/2a2206fde85af31147c759e564d3658c0281a2a9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177310))
- [Fix mobile layout for requirements list page](https://gitlab.com/gitlab-org/gitlab/-/commit/654b0054eff607c3e0101cf6807dd24f27f458d6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177170)) **GitLab Enterprise Edition**
- [Show Iteration field on items within the work items Child widget](https://gitlab.com/gitlab-org/gitlab/-/commit/ca3c94c06e0ef1787ce6174c02f67f5bf37d9047) by @vedant-jain03 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176306))
- [Fix pipeline execution policies skipping when allowed](https://gitlab.com/gitlab-org/gitlab/-/commit/3263e938b0cc96bd57927d9706d87f04aa86bbe5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177266)) **GitLab Enterprise Edition**
- [Reverse toggle to enable skip ci behavior for policy](https://gitlab.com/gitlab-org/gitlab/-/commit/9faa0041eac38656236cf156897cac01af42419b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177169)) **GitLab Enterprise Edition**
- [Fix sizing of done/redo button on mobile todo page](https://gitlab.com/gitlab-org/gitlab/-/commit/ec3cc5e09ae15e7cac653206ae367b843458e3d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177168))
- [Show milestone popover for GFM references to group milestones](https://gitlab.com/gitlab-org/gitlab/-/commit/3ca6538bfe7d17eb638cafea58a94f38e4df3e9c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177186))
- [Use data from current tab of Vue MR list page for export to CSV](https://gitlab.com/gitlab-org/gitlab/-/commit/40665a30700c21752cfa516905f800bf4be51752) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176196))
- [Geo Replication - Fix incorrect breadcrumbs](https://gitlab.com/gitlab-org/gitlab/-/commit/452a5985a13d7d2e905ce8e4276e12ccdc1f13bb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177148)) **GitLab Enterprise Edition**
- [Ensure REST API handles SSH key expiry todos](https://gitlab.com/gitlab-org/gitlab/-/commit/99cfae558b38464fe3e52931d6e4a790bf3180f8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177144))
- [Ensure users can receive notifications before verifying email](https://gitlab.com/gitlab-org/gitlab/-/commit/28eafda13a1d73f3476fe279df950e1cd9a44fbe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176818))
- [Fix typo in policy UI editor for skip ci allowlist](https://gitlab.com/gitlab-org/gitlab/-/commit/afa464ecc77b153b66b3782194a69af2b811b481) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177081)) **GitLab Enterprise Edition**
- [Fix undefined method error for `remaining_pipl_access_days`](https://gitlab.com/gitlab-org/gitlab/-/commit/fe9f38d8e08b73995298501aa0bde8b42c720ea5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176851)) **GitLab Enterprise Edition**
- [Fix missing variables for DAST scans](https://gitlab.com/gitlab-org/gitlab/-/commit/b88d72b08b43ba9d6651d93e1dd6e3f7ac49b63d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176882)) **GitLab Enterprise Edition**
- [Fix resource access token bot namespace bug for admin users](https://gitlab.com/gitlab-org/gitlab/-/commit/23276cf43c0e7948925d52829edfa825a1d67151) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177018))
- [Remove unnecessary padding for policy warning icon](https://gitlab.com/gitlab-org/gitlab/-/commit/58da79a17c9df4c8b132a7c93673c5f0ac5e7782) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176974))
- [Remove "go_get_handle_relative_url" feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/911c3b164305c9eeebf6d4418a66d29c7897272e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176972))
- [Use add on trial dates for combined trial on premium](https://gitlab.com/gitlab-org/gitlab/-/commit/26abffe3593b3156f0d8e36ec8c022fbf29d5d24) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176780)) **GitLab Enterprise Edition**
- [Fix policy name in MR with trailing numbers](https://gitlab.com/gitlab-org/gitlab/-/commit/fcc13de079cf1575607f649cac36f82bdb85e2be) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176629)) **GitLab Enterprise Edition**
- [Move User namespace audit events to instance scope](https://gitlab.com/gitlab-org/gitlab/-/commit/0ef9e46a77413ac93de17611bf108a7ce696e0ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176943)) **GitLab Enterprise Edition**
- [Don't post policy bot comments in MRs of archived projects](https://gitlab.com/gitlab-org/gitlab/-/commit/0cff41469d3e0b62481ee9aea0c8cd11786cf66d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176870)) **GitLab Enterprise Edition**
- [Fixing audit event group path failure](https://gitlab.com/gitlab-org/gitlab/-/commit/649066800d572f51305408994c83f0e5d686d8bb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176855))
- [Add BoardEpicConnection type policy for pagination](https://gitlab.com/gitlab-org/gitlab/-/commit/a70ec596c2f07f9a05289994bd2af8baedcb3bd1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176803)) **GitLab Enterprise Edition**
- [Fix 500 error when banzai commit filter incorrectly captures a group](https://gitlab.com/gitlab-org/gitlab/-/commit/40588193b6092caefd20babecfe3ba8aadb457d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176770))
- [Add reference permission check for group level items](https://gitlab.com/gitlab-org/gitlab/-/commit/38a0a03077346fa5824a519430e4c38efde57a6c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176500))
- [Merge branch...](https://gitlab.com/gitlab-org/gitlab/-/commit/af768407f2bbb1b2fbdf707dde684ae87f2aed5a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176552))
- [Update acme-client to v2.0.19](https://gitlab.com/gitlab-org/gitlab/-/commit/6371ad0e9f88a691291dbc19b5afbeffb179e154) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176465))
- [Fix failed jobs widget polling issue](https://gitlab.com/gitlab-org/gitlab/-/commit/6f61aaa0b4127f4dd9a456ea672575a428655f3f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176402))
- [Restore diff file draft note editing state](https://gitlab.com/gitlab-org/gitlab/-/commit/c65ad27d08fb29605d1c3af8fcb7693174c9e695) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176559))
- [Add a migration to regenerate CI job token signing key](https://gitlab.com/gitlab-org/gitlab/-/commit/192b99d50c6349f64f2a2bc727c6d532903c8311) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176483))
- [Fix CI job token signing key not always generated](https://gitlab.com/gitlab-org/gitlab/-/commit/72a4f3c0bc3f4af6e7eb7fa7fb1d83f1303f0c52) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176483))
- [Fix issues boards unable to fetch issues for anonymous users](https://gitlab.com/gitlab-org/gitlab/-/commit/0b97b746eb70d1d3010af5ea8282f80d9465da74) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176482))
- [bug: Fix appearance of protected badge in group package overview](https://gitlab.com/gitlab-org/gitlab/-/commit/1de4111988e5ab69f2c805615e4d1fb6dc81060d) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174243))
- [Fix NoMethodError on most_recent_commit_sha method](https://gitlab.com/gitlab-org/gitlab/-/commit/d11b82291734d08ad790d00284f592cdd1ac466e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176308)) **GitLab Enterprise Edition**
- [Only create Geo verification records if primary checksumming enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/7dce11060c4fe1a67f5989f6c902f3e3629f6209) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173901)) **GitLab Enterprise Edition**
- [Update subscription check for hide duo section](https://gitlab.com/gitlab-org/gitlab/-/commit/f2c6c3e66d570d99e4cd0bffc8c81ee47f610f7d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175625)) **GitLab Enterprise Edition**
- [Provide a workaround for users that do not have a registration_type](https://gitlab.com/gitlab-org/gitlab/-/commit/7ba2277afb48ac878c4a189bc068e442b127f93c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176195)) **GitLab Enterprise Edition**
- [Only show repo file tooltip when truncated](https://gitlab.com/gitlab-org/gitlab/-/commit/b494fcb7864aa887e517e2b4103f66d90481ab28) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158252))
- [Make ClickHouse exclusive lock compatilble with Redis 6](https://gitlab.com/gitlab-org/gitlab/-/commit/12339e03f48dc5044ce6c1a875b74bc647513543) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176041))
- [Fix Analytics dashboards description `Show more` toggle button](https://gitlab.com/gitlab-org/gitlab/-/commit/6ce5d5ec2d8dc14537998d622a39d05fc48bebbf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176395)) **GitLab Enterprise Edition**
- [Use the project_id_from and project_id_to in InitialIndexingEventWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/af38e768f23d31c881036b90fdef206698508bc8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176224)) **GitLab Enterprise Edition**
- [Fix resetting timer on ChunkWriter](https://gitlab.com/gitlab-org/gitlab/-/commit/04f347b3306fc6fa508e1dc18c675b869d656df9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176348))
- [Fix last commit styling when description is expanded](https://gitlab.com/gitlab-org/gitlab/-/commit/0175a0467051995a13b723a749650bbd817ec4a2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175764))
- [Preserve saved access levels when re-enabling project features](https://gitlab.com/gitlab-org/gitlab/-/commit/d234c0c342f5718aa13cb9eda02d60ea7757edcb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174114))
- [Handle SSO redirect during authorization](https://gitlab.com/gitlab-org/gitlab/-/commit/cf9fcdbb7c07b09cbaf83f4eb6828972a41c165c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175618)) **GitLab Enterprise Edition**
- [Fix Gitlab::Audit::NullAuthor string keyword splat](https://gitlab.com/gitlab-org/gitlab/-/commit/e218991b2b346967dcbc6ab95e9af8a4057ab9fa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176327))
- [Protected containers: Show protected badge in group container overview](https://gitlab.com/gitlab-org/gitlab/-/commit/a58934bb2b29f4cb408f47f7cda589fd0dda5ea9) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174033))
- [Fix index to evict event worker](https://gitlab.com/gitlab-org/gitlab/-/commit/76d9174c509963a41205f89e61866a87d50ae847) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176246)) **GitLab Enterprise Edition**
- [Fix foreign key error while backfilling](https://gitlab.com/gitlab-org/gitlab/-/commit/499fd72f4ebd426777426db19a036330cea2731b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174545)) **GitLab Enterprise Edition**
- [Fix appearance of merge split button](https://gitlab.com/gitlab-org/gitlab/-/commit/9197848c24b2c9dfd64ea6543442654bb2582c08) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175315))
- [Fix infinite scroll when inviting a group to a project](https://gitlab.com/gitlab-org/gitlab/-/commit/440b8c1dfe11158e9575920087e66987d8b17862) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176194))
- [Pipeline stage job polling fix](https://gitlab.com/gitlab-org/gitlab/-/commit/580f444d8875b5e7bdefb2fd3b07eb70f264893c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175926))
- [Fix backoff of disabled webhooks ramp up too fast](https://gitlab.com/gitlab-org/gitlab/-/commit/1715a8d64a9a4ae5325d9f1673467f14b7c68beb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172449))
- [Fix audit events destination_url to be public](https://gitlab.com/gitlab-org/gitlab/-/commit/601539bb03afb4ebf23b801da9c9658151cf3910) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175903)) **GitLab Enterprise Edition**
- [MR widget alert warning: border bottom and fix border-radius](https://gitlab.com/gitlab-org/gitlab/-/commit/959c1c16afb1a85186a56a7d3311f21459d46fc2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176094))
- [Zoekt: Fix negative unclaimed storage bytes](https://gitlab.com/gitlab-org/gitlab/-/commit/0826899d3b854628dc11af54174d4d4e5ace93b7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175561)) **GitLab Enterprise Edition**
- [Replace DB unique index with model validator](https://gitlab.com/gitlab-org/gitlab/-/commit/692b65dcc9aedbedb07c5cb13d39314b3186da94) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175167))
- [Fix edge case when trying to access policy approval_settings](https://gitlab.com/gitlab-org/gitlab/-/commit/cf065a5eb1938189fcebbc50020ac887e48dbf38) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176098)) **GitLab Enterprise Edition**
- [Fix issue in RTE with image resize](https://gitlab.com/gitlab-org/gitlab/-/commit/2e79df1681b805fbb72c490b56c94615a5f508b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176017))
- [Fix issue with preserving checkboxes whitespace](https://gitlab.com/gitlab-org/gitlab/-/commit/39128a438791f7f7634ce3224691ee69470b9bce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175991))
- [Use correct height value for emoji picker rows](https://gitlab.com/gitlab-org/gitlab/-/commit/5cd2cf85460841d5a336c088584944345911e106) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176045))
- [Fix a case-sensitivity issue in the application rate limiter](https://gitlab.com/gitlab-org/gitlab/-/commit/ac404842d0b44168cb3275580a0d12b943929b54) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175930))
- [Skip copying over custom award emoji that do not exist](https://gitlab.com/gitlab-org/gitlab/-/commit/1c15f2091557a0cab04ec22b7e45fc6e13ea6b43) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175712))
- [Fix Random.rand for zero values in RuleScheduleService](https://gitlab.com/gitlab-org/gitlab/-/commit/d138c824fffd8344123d8cbf06f0548c16028d7d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175838)) **GitLab Enterprise Edition**
- [Ignore system notes when indexing notes on work items](https://gitlab.com/gitlab-org/gitlab/-/commit/c102c108431418d9f57f32f46e1364b9a18f7417) by @joe-snyder ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175632)) **GitLab Enterprise Edition**
- [Restrict PAT informaton endpoint to PAT authentication](https://gitlab.com/gitlab-org/gitlab/-/commit/8e93cea85b1834b7187ac67304107223435673ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175820))

### Changed (102 changes)

- [Fix layout of requirements](https://gitlab.com/gitlab-org/gitlab/-/commit/4844cfe12d7f1419f82c065087d6157339531848) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177179))
- [Abstract project topics to reusable component](https://gitlab.com/gitlab-org/gitlab/-/commit/84cd634b90287153e2999ff9316ebb74cb281375) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177496))
- [Change language filter icon to "code"](https://gitlab.com/gitlab-org/gitlab/-/commit/fbec86ddb305a7cff59cbebe6bf0ed7653c61924) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177789))
- [Update environments list page](https://gitlab.com/gitlab-org/gitlab/-/commit/d5ec48b57977d027eb4184a6d2c0fc1a00424196) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176595)) **GitLab Enterprise Edition**
- [Modify gl-icon in email_verification.vue to use info variant and size 16](https://gitlab.com/gitlab-org/gitlab/-/commit/faf36fd1f8d6f27b51283f3fca8173d2e97bceb9) by @alvinowyong ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177295))
- [Update operational vulnerabilities info](https://gitlab.com/gitlab-org/gitlab/-/commit/f563283112e558e415157828accf4dce9bd8e69e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177618))
- [Fix AdjustmentService to use SEC DB connection](https://gitlab.com/gitlab-org/gitlab/-/commit/60a263669aeb2bd2770ad35ae6b256dbf7bb285e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177731)) **GitLab Enterprise Edition**
- [Split SCIM tables](https://gitlab.com/gitlab-org/gitlab/-/commit/fa66c7e206bc167529aea6fbe64865b11dc95df9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170565))
- [Reject soft-deletion of groups containing security policy projects](https://gitlab.com/gitlab-org/gitlab/-/commit/6525f1ba7459c1aae178113c8f5b88a011713f5a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176602)) **GitLab Enterprise Edition**
- [Specify SCIM as reason for DestroyService audit event](https://gitlab.com/gitlab-org/gitlab/-/commit/5db084a9c7494dcb6dad3f54a757fe0d432d8858) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177629)) **GitLab Enterprise Edition**
- [Set Amazon Q service account username](https://gitlab.com/gitlab-org/gitlab/-/commit/e9936ea7e50c56b48996dfcef31652b37c1f254e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177521)) **GitLab Enterprise Edition**
- [Adjust hidden variables error messages](https://gitlab.com/gitlab-org/gitlab/-/commit/fe15ba4ead868f0e04b11ec1ec3d5d40d60dcf77) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166286))
- [Set codeowner_role_approvers to default enabled](https://gitlab.com/gitlab-org/gitlab/-/commit/a37075c4582c33a5907909918fa99f471c22363d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177410))
- [Added project id to the internal workflow API get method](https://gitlab.com/gitlab-org/gitlab/-/commit/5ae03db3dac22cb6279a6f7466c6efd252799674) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177565)) **GitLab Enterprise Edition**
- [Remove flag gitaly_pack_objects_hook_with_sidechannel](https://gitlab.com/gitlab-org/gitlab/-/commit/39f51b573d9370f9a8f2fb8020c0e1cc513f5c77) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176393))
- [Update edit blob to use commit change modal](https://gitlab.com/gitlab-org/gitlab/-/commit/94cb69d12af14f89e59726e17ea2ba68765cb542) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174936))
- [Amazon Q service account has private profile](https://gitlab.com/gitlab-org/gitlab/-/commit/7732f2cb6d0f9602153b5c5c004d432612315f99) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177513)) **GitLab Enterprise Edition**
- [Easily copy link to current issue template from URL](https://gitlab.com/gitlab-org/gitlab/-/commit/07d9b1f36c766c374716efec5bcf0a2ef4389bb1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177215))
- [Remove `auto_resolve_vulnerabilities` feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/c20e9d5ab184c1329cbf1262513f76755329f4b0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177487)) **GitLab Enterprise Edition**
- [Support enablement of Fireworks/Qwen model by top-level group](https://gitlab.com/gitlab-org/gitlab/-/commit/a73aec8262d259e47e9d51d63484bc371cd5d786) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176841)) **GitLab Enterprise Edition**
- [Remove tooltip from activity item](https://gitlab.com/gitlab-org/gitlab/-/commit/249e22a64ec988d86930b0bc7760d48693fb7710) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177313))
- [Model experiments: Rename candidate to run](https://gitlab.com/gitlab-org/gitlab/-/commit/ed296a14e6f6896c59fbcd4a89f8beed13c797c2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177444))
- [Remove duo_seat_assignment_email_for_sm feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/aca41518cf9a5211949ea56766289bd64d6cb8ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177462)) **GitLab Enterprise Edition**
- [Model registry: rename candidate to "run"](https://gitlab.com/gitlab-org/gitlab/-/commit/e73083a1c41a06024c87a1a7becabcf8673c952c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177294))
- [Enable FF policies_always_override_project_ci by default](https://gitlab.com/gitlab-org/gitlab/-/commit/1f91a1f665e7871453ebaef7146d6c1af6d383f4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177469)) **GitLab Enterprise Edition**
- [Dont show amazon q with duo add ons](https://gitlab.com/gitlab-org/gitlab/-/commit/4d99370cb9418c0aef56ef1db3163ff058dfa35d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177317))
- [Make in-app trials display fixed](https://gitlab.com/gitlab-org/gitlab/-/commit/1b19d6b0be2582258c0dd1062e49d4f762ff4e39) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177264)) **GitLab Enterprise Edition**
- [Show file type in security scan artifact download dropdown](https://gitlab.com/gitlab-org/gitlab/-/commit/b42bf9d862d1eddee8a2e6ccc915e6cfc083604f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177272))
- [Promote project.dependencies to generally available](https://gitlab.com/gitlab-org/gitlab/-/commit/90fb84cecada748b6989a85b4cff740f6ae12fd4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177450)) **GitLab Enterprise Edition**
- [Update adherence report drawer heading](https://gitlab.com/gitlab-org/gitlab/-/commit/f98dda4fd55059470755e43f64cd9f56d51499a6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177332)) **GitLab Enterprise Edition**
- [Add X-Gitlab-Feature-Enablement-Type AI Gateway header](https://gitlab.com/gitlab-org/gitlab/-/commit/cb9ba07ad89f090ab3cc666e9d375f0ababe03c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176329)) **GitLab Enterprise Edition**
- [Enhance model experiments listing page](https://gitlab.com/gitlab-org/gitlab/-/commit/bdf6779047dd79920cb5712df768a3bc90e5b6a5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176603))
- [Ref container darkmode color changes](https://gitlab.com/gitlab-org/gitlab/-/commit/4b4b00d3d8acb7b412d3f28cc2b16aa4dc9947b8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171561))
- [Remove automatic feature access level adjustments when updating project visibility](https://gitlab.com/gitlab-org/gitlab/-/commit/05dc8f47f7bdd6d5ce6d9f06096103a00593442d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175070))
- [Remove WalReceiverSaturation indicator](https://gitlab.com/gitlab-org/gitlab/-/commit/cfdd6bf4b05b23b42bf45ff1dfdf9c5356c2b49a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177021))
- [Rename pages_default_domain_redirect to pages_primary_domain](https://gitlab.com/gitlab-org/gitlab/-/commit/f45bed58832d47b9f9bea6ac052a9a20959b9775) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176651))
- [Drop use of AWS SDK v1 in Workhorse uploads](https://gitlab.com/gitlab-org/gitlab/-/commit/bd66f8ff561b80fd1a20a8e82af4391748130349) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177161))
- [Change tooltip text and icon for Summarize button on issues](https://gitlab.com/gitlab-org/gitlab/-/commit/f12ef10445ea74668c120d125cfc87cac6f4241f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175087))
- [Allow nil values for project_id_to in zoekt index metadata](https://gitlab.com/gitlab-org/gitlab/-/commit/0850cac2723dc6c9949b9e4ba228bf970c99e0f4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175945)) **GitLab Enterprise Edition**
- [Update CreateIssueService rollback](https://gitlab.com/gitlab-org/gitlab/-/commit/45bfc379c9396c80a34ce635dde4378266b1c1a3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176154)) **GitLab Enterprise Edition**
- [Remove default value for organization_id](https://gitlab.com/gitlab-org/gitlab/-/commit/75f3d3ef47eff70a64e0797a542881217d0a2187) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177080))
- [Change tooltips to HelpPopover in projects import](https://gitlab.com/gitlab-org/gitlab/-/commit/d6264503e29cf3078ca403a72c2a088d11162414) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176750))
- [Use diff_blobs for streaming compare rapid diffs](https://gitlab.com/gitlab-org/gitlab/-/commit/cb786bbb976bcbd369de8811ae7c880cf0d5b529) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174982))
- [Reject deletion of security policy projects](https://gitlab.com/gitlab-org/gitlab/-/commit/2b4b439c654a77ac07949877b81182dfc5f76adc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176601)) **GitLab Enterprise Edition**
- [Change pipeline identifier priority](https://gitlab.com/gitlab-org/gitlab/-/commit/38a814a3f67e3f72faad971d8002bf8053934ae1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177011))
- [Repaced and removed css gl-last-of-type-border-b-0](https://gitlab.com/gitlab-org/gitlab/-/commit/5921d0fc52a7f67dc7d5f59e952bad6478f764ab) by @illia_bakunovskyi ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172870))
- [Group usage quotas: Update page hierarchy](https://gitlab.com/gitlab-org/gitlab/-/commit/763b438bea7b7154974e0d7f772ec5da922f823e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176265)) **GitLab Enterprise Edition**
- [Refactor topics admin page to use PageHeadingComponent](https://gitlab.com/gitlab-org/gitlab/-/commit/68f0dce2d59495b34f155359516f87840328335e) by @bufferoverflow ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170241))
- [Add validation for license rule](https://gitlab.com/gitlab-org/gitlab/-/commit/3917deddddcc245d3d10c12f2e68975b40977aa4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176445)) **GitLab Enterprise Edition**
- [Update widget in pipeline editor to use pipeline summary component](https://gitlab.com/gitlab-org/gitlab/-/commit/77c7d396c2857a0a730332a3b1d7b8679d297b75) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175179))
- [Update licenses validation](https://gitlab.com/gitlab-org/gitlab/-/commit/1c4267febf66844af1560dc29f32413067358d8f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176889)) **GitLab Enterprise Edition**
- [Unify error messages styling when onboarding](https://gitlab.com/gitlab-org/gitlab/-/commit/ca2788e54c7d1664f2a5246b602fc577bcd5d9b6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176846))
- [Updates BBM docs](https://gitlab.com/gitlab-org/gitlab/-/commit/53b9386e18c1c412253724e0cbcb829a1c6f98bc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175994))
- [New split view for a policy editor](https://gitlab.com/gitlab-org/gitlab/-/commit/92e1315b6cace0d2d57ef4118247baecd5ecc140) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176062)) **GitLab Enterprise Edition**
- [Remove validation for branches on group level](https://gitlab.com/gitlab-org/gitlab/-/commit/5c45399c5b3805a3057068cc5c1db63939d9a4e6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175866)) **GitLab Enterprise Edition**
- [Enhance experiment candidate(run) detail page](https://gitlab.com/gitlab-org/gitlab/-/commit/e96e0f085bb7c282368560939ecf308f3d113ada) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175957))
- [Fix icon text alignment](https://gitlab.com/gitlab-org/gitlab/-/commit/3865a55ffdd733258354d41b74c2c58eaed3143f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176680)) **GitLab Enterprise Edition**
- [Sync index creation for p_ci_builds.trigger_request_id](https://gitlab.com/gitlab-org/gitlab/-/commit/2076737fd69773c0006ea090058b5ed7f39b660a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176641))
- [Moved seat_control from helper to controller](https://gitlab.com/gitlab-org/gitlab/-/commit/0deea04db8477c31d49a911014f6620a175da432) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176649)) **GitLab Enterprise Edition**
- [Remove old completions class and update service_class](https://gitlab.com/gitlab-org/gitlab/-/commit/0ebb0daf3776d466788571beefa837843098b7d1) ([merge request](https://gitlab.com/foo/bar/-/merge_requests/176468))
- [Enable scan_execution_pipeline_concurrency_control ff](https://gitlab.com/gitlab-org/gitlab/-/commit/229bae74c99e2faa81a3f7e3417c8c54aad9dd1e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176469)) **GitLab Enterprise Edition**
- [Remove database default for organization_id from oauth tables](https://gitlab.com/gitlab-org/gitlab/-/commit/6106b31a16dae67ed50f4cd9bbb63d21fb2ab29b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175690))
- [Removed sync code for seat_control and new_user_signups_cap](https://gitlab.com/gitlab-org/gitlab/-/commit/26d3684a816e1ceff2338f4c152c4e722196753e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174712)) **GitLab Enterprise Edition**
- [Changes index on namespace_settings](https://gitlab.com/gitlab-org/gitlab/-/commit/eb97d8f5cd6dacb1350f7931d6617f56217e6583) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176454))
- [Add instructions in the pipeline editor for configuring jobs for MRs](https://gitlab.com/gitlab-org/gitlab/-/commit/7f39e9b7620ce55a51fdb8a9277571550c2c1ef9) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175715))
- [New machine learning runs use ml_model package type](https://gitlab.com/gitlab-org/gitlab/-/commit/8934468f93e76b22495557646320a850cbcf7ad3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173680))
- [Make details disclosures easier to spot in rendered markdown](https://gitlab.com/gitlab-org/gitlab/-/commit/8cee1c3660cf2745bcc9b1799d559ba12c5c245b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176396))
- [Added link to project and group](https://gitlab.com/gitlab-org/gitlab/-/commit/05d7b3ac0644e98b478d9323d3f7af0e25d6917a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176379))
- [Update label text for protected branch in commit change modal](https://gitlab.com/gitlab-org/gitlab/-/commit/dc046d7abeda5b5f9b6ff632af61408417f880f7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176190))
- [Help Icon: Removes small size and replaces it with default](https://gitlab.com/gitlab-org/gitlab/-/commit/f01ef9c192026c79ee21db19d999406b3c985298) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176252))
- [Consolidate pipeline queries](https://gitlab.com/gitlab-org/gitlab/-/commit/4fe561fc1b84f467f566c5a8dc45d6416e3a503e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175914))
- [Update Kubernetes agent registration](https://gitlab.com/gitlab-org/gitlab/-/commit/8b0d1ea6e6c7e2087f26be6187a1858e469ce4a5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175766)) **GitLab Enterprise Edition**
- [Improve readability of status icon](https://gitlab.com/gitlab-org/gitlab/-/commit/c6e09b5b3e9ce9ecb9fdd61174c9c848a66fba78) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176337)) **GitLab Enterprise Edition**
- [feat: Toggle Duo Chat drawer state instead of only showing](https://gitlab.com/gitlab-org/gitlab/-/commit/2d5efd1590b66e9dc9f2b5a3aa855f33bc47f710) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176288)) **GitLab Enterprise Edition**
- [Remove `download_code` dependency from access to read merge requests](https://gitlab.com/gitlab-org/gitlab/-/commit/1c2beb5e05a289be664cce8440952f41f3cd51e7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175444))
- [Markdown: Use fixed type scale](https://gitlab.com/gitlab-org/gitlab/-/commit/e977306445647036bfb1d98dca299e58ea0256bf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175258))
- [Add auto-approval param in CE](https://gitlab.com/gitlab-org/gitlab/-/commit/a8cd7c3f6676ed894d624f8f735338f265ae32f1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176026))
- [Use diff_blobs for streaming commit rapid diffs](https://gitlab.com/gitlab-org/gitlab/-/commit/4832a7b37ee28057cd44d3e15f78cb187e34770c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174863))
- [Updated SeatControl UX](https://gitlab.com/gitlab-org/gitlab/-/commit/de31b5bd361011d1b636bceed83125bb4e627fb9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174514)) **GitLab Enterprise Edition**
- [Allow dots in path_prefix in Pages](https://gitlab.com/gitlab-org/gitlab/-/commit/e116421722541fddd85621118d3e34730a4e7bfd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175563))
- [Fix Direct Transfer scopes copy to be precise](https://gitlab.com/gitlab-org/gitlab/-/commit/e0e707b530a6c8f079999dfebcffd7d77ed7c221) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176211))
- [Use YMD date for value stream metrics queries](https://gitlab.com/gitlab-org/gitlab/-/commit/d31dacd8fd204d20b3e987ecbe8c006442be6ab3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175081))
- [Update edit blob to use commit change modal](https://gitlab.com/gitlab-org/gitlab/-/commit/1abc4f15c479e9dd118318095ef08252abb67655) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174287))
- [Update styling in pipeline mini graph dropdown](https://gitlab.com/gitlab-org/gitlab/-/commit/e07fa88c9442ffa68a1032e5dc231647b0df39a6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175888))
- [Show an Actions column name on the pipelines list on the desktop view](https://gitlab.com/gitlab-org/gitlab/-/commit/fbcfc70f16ad1e9dff770e3aa6f4a358096d07ff) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176019))
- [Release feature flag ml_experiment_tracking](https://gitlab.com/gitlab-org/gitlab/-/commit/d3813a073988bd66698a66ca7f9daa88f1a83f5e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175814))
- [Model Experiments: Add menu item to MLflow usage example](https://gitlab.com/gitlab-org/gitlab/-/commit/3479919e0ced5f6c7ea7b2b2de4076eaa05ed130) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175813))
- [Remove default value from namespaces.organization_id column](https://gitlab.com/gitlab-org/gitlab/-/commit/3940199f1fd7b5644698a89460f6fd75d4110f67) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174559))
- [Replace NamespaceSettings index with composite](https://gitlab.com/gitlab-org/gitlab/-/commit/19c14b16220a0b0059f189fa8698eebbd3dde84e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175678))
- [Add Auditor badge to Admin area Users page](https://gitlab.com/gitlab-org/gitlab/-/commit/ea9d892642d681d1c5a6782b7eb3af1329243714) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175654)) **GitLab Enterprise Edition**
- [Uses organization id on Topics GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/1e8f770c7944da17fd1f3e0386d83ceb57b8a1bc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175114))
- [Update sign up path on Admin Settings](https://gitlab.com/gitlab-org/gitlab/-/commit/5c8388d6c13b2efd07ab111d9620443fae15b401) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176011))
- [Remove BackfillPCiPipelinesTriggerId](https://gitlab.com/gitlab-org/gitlab/-/commit/9e2cba271682a3665893719274733ec2a6c5b0fb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175517))
- [Change CreateMergeRequestService rollback for sec](https://gitlab.com/gitlab-org/gitlab/-/commit/2e9dd22fb7e93fc6ef749264e05572f13958e11c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172673)) **GitLab Enterprise Edition**
- [Fix first and last pagination icon sizes](https://gitlab.com/gitlab-org/gitlab/-/commit/e19abef1284a1a5015debd6cb7e772f0644f5a37) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175320))
- [Use projects icon and add tooltips in admin > groups](https://gitlab.com/gitlab-org/gitlab/-/commit/aef53ef54fccc85a285a705bd82440e838b21639) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175965))
- [Update text in dependency table](https://gitlab.com/gitlab-org/gitlab/-/commit/55af56d5b736dd5729e169f3d1c8a34bf4973f3c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175722)) **GitLab Enterprise Edition**
- [Remove increase_lsif_artifacts_limit feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/bdeda8e613c87cb2d4227e9911862164ab955830) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175685))
- [Increase ci_max_artifact_size_lsif default limit](https://gitlab.com/gitlab-org/gitlab/-/commit/dc7de5ed4cc655b168555aca75bbd028f03074d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175684))
- [Remove correct_work_item_type feature flags](https://gitlab.com/gitlab-org/gitlab/-/commit/ad39360932acce95be609d8bc2d906a22c88c529) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175934))
- [Update dependency auto-deploy-image to v2.115.0](https://gitlab.com/gitlab-org/gitlab/-/commit/9513699bb86fecab8cd60fc83efe4991ca420966) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175416))
- [Set cache: [] in SAST latest CI templates](https://gitlab.com/gitlab-org/gitlab/-/commit/613bab02b3ce3ff4fd94b83a889980872620db3c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174987))

### Removed (17 changes)

- [Removed the ignore rule](https://gitlab.com/gitlab-org/gitlab/-/commit/16e980b27a1eccb7f19bacf5320a4cd1cd9bdd3a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176730)) **GitLab Enterprise Edition**
- [Remove top-level group concurrency docs](https://gitlab.com/gitlab-org/gitlab/-/commit/ee2b19ee7f77dfe47d45b5939181b0c3d39837e0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177632)) **GitLab Enterprise Edition**
- [Remove feature flag 'vulnerability_code_flow'](https://gitlab.com/gitlab-org/gitlab/-/commit/f52b0757bcb79b2bc3eaedfd965a7b371b5fc17b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177248))
- [Remove ci_graphql_pipeline_mini_graph](https://gitlab.com/gitlab-org/gitlab/-/commit/67b3cb5a12ab1d9211a9847cd8e2841434a7fb3b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176822))
- [Remove pipeline editor dead code](https://gitlab.com/gitlab-org/gitlab/-/commit/5c5f29d24c91926659479554e3ae7522810faf30) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175334))
- [Removing ci_secure_files_read_only feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/e5c0a143be5d6248939bbcc551958db2956d70aa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177033))
- [Remove epic cached count checking](https://gitlab.com/gitlab-org/gitlab/-/commit/0c3ea92d9cd91e7d5729504148b4c02b8bcadb20) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176976)) **GitLab Enterprise Edition**
- [Remove sync_audit_events_to_clickhouse feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/eb6be9bb3fd10d96120caae122530a9ec259b246) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175370))
- [Create migration for synchronous index removal](https://gitlab.com/gitlab-org/gitlab/-/commit/41c7dfc9a7e8de5fce5085f623bffd9b5b4b6b8a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176673))
- [Remove namespace_descendants_cache_expiration FF](https://gitlab.com/gitlab-org/gitlab/-/commit/6c2d1737f15b4f588dfe69abaa66ff3f64e5992d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176643))
- [Dropping confidence column from security_findings](https://gitlab.com/gitlab-org/gitlab/-/commit/832e071a3789e475532be32821b7147b6ba255de) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176415))
- [Remove `use_holt_winters_forecast_for_deployment_frequency`](https://gitlab.com/gitlab-org/gitlab/-/commit/57073e040576fc72e3f333ba8938c621b601cf83) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175893)) **GitLab Enterprise Edition**
- [Remove require_resource_id feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/6b715a248f4026707a4c060187dfa835f88f65a7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176155))
- [Remove self_hosted_models_beta_ended FF](https://gitlab.com/gitlab-org/gitlab/-/commit/15709f32291a6402e79ffbea9a986b7cd97a6ba1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176278))
- [Remove code_suggestions_usage_events_in_pg feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/326e9b308f206b2062f68b06d625ed49ab83b1db) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175836)) **GitLab Enterprise Edition**
- [Remove groups_with_event_streaming_destinations metric](https://gitlab.com/gitlab-org/gitlab/-/commit/6f61a3d13eaf22c77e41e157474e8dfa48568115) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173590)) **GitLab Enterprise Edition**
- [Remove the 'auth_finder_no_token_length_detection' FF](https://gitlab.com/gitlab-org/gitlab/-/commit/31ce2ac7133143e567350dc2c7fc53c0d745d6c5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175276))

### Security (12 changes)

- [Update KaTeX to fix several CVEs](https://gitlab.com/gitlab-org/gitlab/-/commit/6c0e0890a99748f9e73c9ebb6e010934f795c9d1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176404))
- [Update rails to 7.0.8.7](https://gitlab.com/gitlab-org/gitlab/-/commit/ed8267b6d57c9bb995eb714d790fbff81f65277e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176769))
- [Revert "Merge branch 'sh-fix-http-io-empty-gz-handling' into 'master'"](https://gitlab.com/gitlab-org/gitlab/-/commit/7d5162c849e182435b05da0def80642972700502)
- [Add strong parameters to the passwords_controller](https://gitlab.com/gitlab-org/gitlab/-/commit/1bb92907f6c0e02cbf3152f8759b5f31e4fb26f6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177050))
- [Fix handling of short gzip metadata files](https://gitlab.com/gitlab-org/gitlab/-/commit/0bd210b633756857a3ed1884eef58d248fc7ad0c)
- [Filter out sensitive parameters on Auth logs](https://gitlab.com/gitlab-org/gitlab/-/commit/4f778ed32ee45feb6ad66087108e2972ae2b9dee)
- [Prevent cyclic reference in work item hierarchy widget from frontend](https://gitlab.com/gitlab-org/gitlab/-/commit/2fdbe509828bc42960f70c576b1d94073610634c)
- [Allow external_provider config take precedence over external_groups](https://gitlab.com/gitlab-org/gitlab/-/commit/c2de306ba30f5afda1e7a24afb94c8e7dc04cedb)
- [Don't allow unauthorized users to close issues automatically](https://gitlab.com/gitlab-org/gitlab/-/commit/92c10374afb3a86ee76c149202204a642f8702ae)
- [Update golang.org/x/net package](https://gitlab.com/gitlab-org/gitlab/-/commit/776e269a1eab799fdeb891ac0e9e37d2c7d09037) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176775))
- [Update net-ssh to fix CVE-2023-48795](https://gitlab.com/gitlab-org/gitlab/-/commit/3d1006d7fdfd87028028d33d6cb3220832ef580d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176092))
- [Update yard to fix CVE-2024-27285](https://gitlab.com/gitlab-org/gitlab/-/commit/9ec01eecb1d1c229f723920622798e26ebfcdebd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176096))

### Performance (4 changes)

- [Implement included remote checksum in the Maven package registry](https://gitlab.com/gitlab-org/gitlab/-/commit/54d9368daf0d2d187e54a8108578291819d265b0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177142))
- [Remove auto_merge_process_worker_sticky feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/b0b910de2eda218f1220385f1ac55f6d42f67851) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177639))
- [Load entire discussion first when linking to a note](https://gitlab.com/gitlab-org/gitlab/-/commit/a85cea378a33605e7f0f1c907874a01588e281de) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177058))
- [Lazy load create epic modal in group sidebar](https://gitlab.com/gitlab-org/gitlab/-/commit/a5cf2160ae974d9e3158002e81a00904b7452cb1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176945))

### Other (83 changes)

- [Finalize migration BackfillMlCandidateMetadataProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/bf4313ce6236ccecac61b9dfe26b6764ad322e9f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177814))
- [Add not null constraint on boards_epic_lists.group_id](https://gitlab.com/gitlab-org/gitlab/-/commit/95af350244cf1d4370543b0856b102e8cc5a8e5e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177348))
- [Introduce partitioned table for maven virtual registry cache entries](https://gitlab.com/gitlab-org/gitlab/-/commit/04a2f8cd79bceba6ceca3d38d33cfc633ff8714c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174985))
- [Remove ci_catalog_ranking_from_new_usage_table feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/342fd847c9583e6292970693dbfafc8b096f48e9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177553))
- [Add Asana instance integraiton model](https://gitlab.com/gitlab-org/gitlab/-/commit/b250029c95115685ef2269e96bf37a36bc25e7af) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177009))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/845076c6395d038a8045e830922ac229b1ce6c0f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177727))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/065b821dde75a03d953c28f9f5ef5942b8d73c6a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177530))
- [Cleanup lfs_sync_before_branch_updates FF](https://gitlab.com/gitlab-org/gitlab/-/commit/db5b8e427a4a5b704e707f400817781b90738e7b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175629))
- [Remove actor override flag for GH and BBS importer](https://gitlab.com/gitlab-org/gitlab/-/commit/c31986a0ddf2adf22769fddd0bb7e8e227ea3a1d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177225))
- [Finalize migration BackfillVulnerabilityIssueLinksProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/f44eddf3233085cfe20e35a155606edb8735c4ab) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173199))
- [Remove unnecessary wrapper method](https://gitlab.com/gitlab-org/gitlab/-/commit/1f8bf9d684128ca7abe5f86dd685c837828e5585) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176589))
- [Re-queue migration to delete orphaned groups](https://gitlab.com/gitlab-org/gitlab/-/commit/c987504d9fc3ab700ee2aab263bbb4065024d32f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176705))
- [Add closed reason urls to work item GraphQL types](https://gitlab.com/gitlab-org/gitlab/-/commit/6a0355bd1506bd802199a89a799d7fc6bcc02874) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176410))
- [Reorder migrations for ci_deleted_objects](https://gitlab.com/gitlab-org/gitlab/-/commit/811a15e015b86be3ad9460c3c8f58bf7c53f9ff6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177541))
- [Add ClickHouse table siphon for namespaces](https://gitlab.com/gitlab-org/gitlab/-/commit/439790c4a8d8245a0aced68b3affee354653628a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176809))
- [Remove actor override when Direct Transfer disabled](https://gitlab.com/gitlab-org/gitlab/-/commit/1fe4d0c48e09b07acdd85fa21047d7e37c127946) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177121))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/a4de4da3eb89ab6f2bcfc7737593e716c1cacb2c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168911))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/59114bd0f80fe80d958e5bf548a5707f71c79e25) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175660))
- [Cell ID to default to null instead of 1](https://gitlab.com/gitlab-org/gitlab/-/commit/83bd31861bbb6f8f876dcc87a663e950df28ea74) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176605))
- [Add Assembla instance integraiton model](https://gitlab.com/gitlab-org/gitlab/-/commit/61122c53f24dc875aed30c02685e9df3c8f56d01) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177125))
- [Revert ElasticsearchSettingsFromApplicationSettings pd migration](https://gitlab.com/gitlab-org/gitlab/-/commit/c3297053affbbccd9daf032573ebb66f68afaa49) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176987))
- [Remove Search::Zoekt::DeleteProjectWorker job instances](https://gitlab.com/gitlab-org/gitlab/-/commit/62d09ab48c065c57b49bb386c25fb903c582b020) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176796))
- [Drop sequence for work_item_types.id column](https://gitlab.com/gitlab-org/gitlab/-/commit/d7bd2d3a510a3b388bab70a2fd611cc1f4aeec35) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177316))
- [Simplify Rouge/HLJS mapping](https://gitlab.com/gitlab-org/gitlab/-/commit/7288241f313b537e8d0147b599b62da48d35c8d2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177237))
- [Fix issues.work_item_type_id values](https://gitlab.com/gitlab-org/gitlab/-/commit/b6187cdf82dac351a58d0caf7344fd239ae7f3a1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177008))
- [Regenerate RuboCop TODO files](https://gitlab.com/gitlab-org/gitlab/-/commit/0c6ee9f4a1ffbb157a1d12229db86d3838bcad0b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176965))
- [refactor: Extract shared examples in create_package_service_spec.rb](https://gitlab.com/gitlab-org/gitlab/-/commit/a530d278547df27923777283767355289a8e0958) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/135552))
- [Only show active trial widget for ultimate trial plans](https://gitlab.com/gitlab-org/gitlab/-/commit/5989ba369767945fdce7f0d55cdb1d4c0fddef71) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175126)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/8b772b9c2bf37c48facaa5a6e850584efd13ab19) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177206))
- [Finalize migration BackfillVulnerabilityMergeRequestLinksProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/17d866ec5b1b9eef51a2aeb57eb69f7673be8bdf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177102))
- [Finalize migration MigrateOsSbomOccurrencesToComponentsWithoutPrefix](https://gitlab.com/gitlab-org/gitlab/-/commit/a964506ec361525a586e3d2a8e18c6f862776e21) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176555))
- [Update downtime migration docs](https://gitlab.com/gitlab-org/gitlab/-/commit/454a7c8b049538bf067b5b26f216b24c0dd5f6cb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177006))
- [Remove feature flag definition](https://gitlab.com/gitlab-org/gitlab/-/commit/3baa76347186820170868cd57bd586d137a4551f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177063))
- [Cleanup multiple_approval_actions feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/7c3464b10f99f0e9436b0a0cb6a68e5a938a2846) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176958)) **GitLab Enterprise Edition**
- [Finalize migration BackfillVulnerabilityUserMentionsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/35d58d1d41fbb4fa582c96f20e46a9d383da8dbe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177105))
- [Fix work_item_types.id values with sequential values 1-9](https://gitlab.com/gitlab-org/gitlab/-/commit/a7d408d949089bc57e8841515462ed2e65302a1e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176199))
- [Enable pause control for zoekt workers](https://gitlab.com/gitlab-org/gitlab/-/commit/bd5fcddc39a1e9731bf685e6a8e7523e7b983c50) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176397)) **GitLab Enterprise Edition**
- [Cleanup premium_can_trial_again feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/7014d9705e4cc911681699f96635d0dc99c118fc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177012)) **GitLab Enterprise Edition**
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/bb539f05999f23195e720c414e08ea0a0bf03642) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176531))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/69387fa4904ced09c9e11a8008a0df850bb3cd2d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176734))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/5a3e9a5ac09bd65b0374e8ef9fa671a51f3e7ba7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175935))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/ce1d3d5ccbc19db047edf5cb208f9e40cca49d66) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176904))
- [Remove orphaned managers from .com ci_runner_machines_687967fa8a](https://gitlab.com/gitlab-org/gitlab/-/commit/462aaa7069a91bd8728ed5d03e7e66304965ca1a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176702))
- [Requeue backfill of ci_runners_e59bb2812d table](https://gitlab.com/gitlab-org/gitlab/-/commit/352640b68f23df48a4c55ade1a5b86edac0eee1c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176848))
- [Fix a misspelling in BBM docs](https://gitlab.com/gitlab-org/gitlab/-/commit/d0ddaaa93a750f4d94f1e17932782587e51b4c2f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176816))
- [Add tracking metrics for multiple approver actions](https://gitlab.com/gitlab-org/gitlab/-/commit/69698ce2a8fb498aa4fe23ae28b03f9f90732323) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176669)) **GitLab Enterprise Edition**
- [Delete redundant docs link from "Linked items"](https://gitlab.com/gitlab-org/gitlab/-/commit/02f55377e3ad2a835565f4649c537d1c8eae7db1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176373))
- [Remove UpdateIndexUsedBytesWorker job instances](https://gitlab.com/gitlab-org/gitlab/-/commit/e6ff37c5d5baf2c726a0e040adefe2cdf7ef0d4d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176370))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/a1e0166ed5be34e20a383ef708532601ea78e9e7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176436))
- [Add feature category to github import specs](https://gitlab.com/gitlab-org/gitlab/-/commit/1eeee0715368cc84e14984a7ca129e85b4d26ef9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176639))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/77584f240200517e72f1bc2ee337f1b04adb98ed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176622))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/6c7305dc7df6a81c2715092a1d7c3662b2f2fbef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176623))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/5794d86d54baa394202f1f884cf5a00b10ab0f2e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176529))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/6c3878db73f8b22319370bf04157708fd93b1f4f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176528))
- [Remove feature_flag admin_agnostic_token_finder](https://gitlab.com/gitlab-org/gitlab/-/commit/98f46d84b317d58b390d132db614bf01ff7166cd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175948))
- [Finalize migration BackfillVulnerabilityFindingLinksProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/f6a25bd597ee9ea6d40af40d264c197b903b16f2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173669))
- [Finalize migration BackfillVulnerabilityFlagsProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/1535feaa3f0cf60aa2d7d687db1d2a0095adbcf9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173666))
- [Finalize migration BackfillVulnerabilityFindingEvidencesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/18aa5ef132089182d9161d2a43bde86a8191bf82) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173670))
- [Finalize migration BackfillVulnerabilityFindingSignaturesProjectId](https://gitlab.com/gitlab-org/gitlab/-/commit/e1fd372507b4c2a4ed7df951e1b3ae35fe345cff) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173668))
- [Protected packages: Add regex validation for pypi protection rules](https://gitlab.com/gitlab-org/gitlab/-/commit/8f36ed9ab9ebbd936d3656196ac1f93174482377) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163504))
- [Merge branch '458891-metadata-api-get-kas-version-by-serverinfo-rpc' into 'master' ](https://gitlab.com/gitlab-org/gitlab/-/commit/df2696997a349f2eee23249ee03d544421620caf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164579))
- [Create helper method for tree header app](https://gitlab.com/gitlab-org/gitlab/-/commit/80c65af2ce8e4ded806234fae0bc52fd32380c8b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175882)) **GitLab Enterprise Edition**
- [Removed git_guardian_integration FF](https://gitlab.com/gitlab-org/gitlab/-/commit/6010a33d68859beb94e2752e1d1fa1f1dc5cc070) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176391))
- [Detail view renders legcy issue view for unsupported work item types](https://gitlab.com/gitlab-org/gitlab/-/commit/1dc9935158f50957e8e085d4bb02484c22dc8abb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175109))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/8df9984fee8f89a492bf588ee579a12c20806b6f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175780))
- [Updates step_url for users that do not have registration_type](https://gitlab.com/gitlab-org/gitlab/-/commit/016db0bc2dc46dad61420cca3e44bbfea99ebf47) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176324))
- [Update vulnerability_management_policy to clarify group availability](https://gitlab.com/gitlab-org/gitlab/-/commit/ab4a7bf97d0d641172a9beb4f3210bbd01843a73) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176297)) **GitLab Enterprise Edition**
- [Consolidate elasticsearch application settings into one JSON field](https://gitlab.com/gitlab-org/gitlab/-/commit/32cdd44b376797f334d7caee3c1ae6ff479aff3f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174172)) **GitLab Enterprise Edition**
- [Run EnsureFactoryForTable in CE to avoid RedundantCopDisableDirective](https://gitlab.com/gitlab-org/gitlab/-/commit/bb76605d0478523248efd3dfcf66db71c1f8c377) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176077))
- [Add missing widgets to incidents for parity with issues](https://gitlab.com/gitlab-org/gitlab/-/commit/088689c5ac4cd35385fde8f2a9dcddc5685102b4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175386))
- [Add & backfill sharding keys for protected_branch_unprotect_access_level](https://gitlab.com/gitlab-org/gitlab/-/commit/dbfa3214907589f2b72b6a6209b133879687ba4d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175718))
- [Remove feature flag write_to_ci_runner_taggings](https://gitlab.com/gitlab-org/gitlab/-/commit/49f214f6bab911e8759e7d2b505955c2fd27c954) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176163))
- [test: Move test from feature test to model test](https://gitlab.com/gitlab-org/gitlab/-/commit/c6758b7dabde0357b81c001037d48da16cca0d21) by @gerardo-navarro ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176136))
- [Reclaim disk space used by old job tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/2fda52e5b7c0f7ee4311b80cf7b3d2bcfab8336f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176025))
- [Quarantine a flaky test](https://gitlab.com/gitlab-org/gitlab/-/commit/6d1ff2c64b8bd29805d313ce6c279eba470b8fc2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175782))
- [Fix variable literal](https://gitlab.com/gitlab-org/gitlab/-/commit/9aaead6bf01a3d7e14ecfc7ffe23b4f85bcd53a9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175983)) **GitLab Enterprise Edition**
- [Add and backfill namespace_id for issuable_slas](https://gitlab.com/gitlab-org/gitlab/-/commit/2ac50a8ce7a485bac517029185f48cde9558ce80) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175719))
- [Add & backfill sharding keys for bulk_import_export_uploads](https://gitlab.com/gitlab-org/gitlab/-/commit/f38e81eda4b4c71cb1bae5372ddf6e6dc2045a19) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175723))
- [Use the project_id_from and project_id_to in InitialIndexingEventWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/9f084888bf20d6e4c0e4ddb0523f01f8e150ed64) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175844)) **GitLab Enterprise Edition**
- [Remove cache_autocomplete_sources_* feature flags](https://gitlab.com/gitlab-org/gitlab/-/commit/20bb52a61f038d6e09f69fd852f8b0191846cbc6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175874))
- [Remove feature flag `ai_custom_model`](https://gitlab.com/gitlab-org/gitlab/-/commit/790adc35614aa08ea66a4a3b66233e9320cf9dce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175687))
- [Remove default on `group_saved_replies_flag feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/75d49fe13646e1e0d3b68233ac4a965c86853917) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175647))
- [Remove use_actual_plan_in_license_check flag](https://gitlab.com/gitlab-org/gitlab/-/commit/b8c3fe16aedb69c82ff52d1c695d72e933c4b946) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175649))

## 17.7.7 (2025-03-11)

### Security (8 changes)

- [Vendor GraphQL gem](https://gitlab.com/gitlab-org/security/gitlab/-/commit/1c7e70de86d4bdd9395c9bcda9f816a608d78a3d) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4839))
- [Ruby-SAML updates](https://gitlab.com/gitlab-org/security/gitlab/-/commit/8ac8f914d289f182de00be49d10f15e7db7bd7a3) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4830))
- [Prevent custom role to activate group members](https://gitlab.com/gitlab-org/security/gitlab/-/commit/1c01e25b256b30a8edca3024909c9b1df56adb59) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4835))
- [approval_rules name is unbounded](https://gitlab.com/gitlab-org/security/gitlab/-/commit/1db850c51fcd8ceab50bced39165464c0943a45b) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4836))
- [Limit preview size](https://gitlab.com/gitlab-org/security/gitlab/-/commit/0ca0f0bad8d2d470b10491fa672e3134cb0d5acf) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4823))
- [Maintainer can inject shell code in Google integration configurations that...](https://gitlab.com/gitlab-org/security/gitlab/-/commit/f22e6beb143b983e2bd76c08beff215816a52079) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4826))
- [Filter out internal notes if the recipient do not have access](https://gitlab.com/gitlab-org/security/gitlab/-/commit/17181360562c5f5b9c4907eb8f8d3aad12b7748b) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4813))
- [Mask unencoded userinfo in project mirror errors](https://gitlab.com/gitlab-org/security/gitlab/-/commit/a7a51b42149a2db1c39a948604c2296c61b1ddb9) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4778))

## 17.7.6 (2025-02-26)

### Fixed (1 change)

- [Fix failed jobs widget polling issue](https://gitlab.com/gitlab-org/security/gitlab/-/commit/e2154d3d886d82e1f5fe62fb9d234d00e257e784)

### Security (4 changes)

- [Increase minimum role in SPP to read policy yaml](https://gitlab.com/gitlab-org/security/gitlab/-/commit/6d5c2ea1feb6097cb5720650f39b3808554b6a29) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4717))
- [Fix access to read code review analytics in private projects](https://gitlab.com/gitlab-org/security/gitlab/-/commit/4454c18d19d2d8df92520f4c0fafa24ddbf9fbe4) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4757))
- [Escape work item dropdown items and restrict HTML tags](https://gitlab.com/gitlab-org/security/gitlab/-/commit/a834b94cf4e967065590f6b78b15c8733d67df30) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4785))
- [Use stricter CSP values in the packages dependency proxy](https://gitlab.com/gitlab-org/security/gitlab/-/commit/d975b402434b9e17ff2963d9c4c6f438f52545ed) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4765))

## 17.7.5 (2025-02-21)

### Fixed (1 change)

- [Revert stricter workhorse route regexes](https://gitlab.com/gitlab-org/gitlab/-/commit/9f1a05217022094de570ca4e4afd5b96b9b68c56) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181359))

## 17.7.4 (2025-02-11)

### Security (8 changes)

- [Security Duo Chat Escape Unknown Domain Hyperlinks](https://gitlab.com/gitlab-org/security/gitlab/-/commit/d3eafa571712e6891f16ecccaaefd82b147b75f6) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4691))
- [Hide sensitive workhorse headers and fix route confusion between web and workhorse routes](https://gitlab.com/gitlab-org/security/gitlab/-/commit/af871eb34f21f862bce699839af69c88826a3420) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4762))
- [Do not allow Planner role to update or delete incidents](https://gitlab.com/gitlab-org/security/gitlab/-/commit/f5ae9423dbd353f571ffbea5a8ffe2ac77b587d6) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4747))
- [Reduce memory allocations on create PAT endpoint](https://gitlab.com/gitlab-org/security/gitlab/-/commit/d443ded9eaed1300b888594125684db884c88e4d) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4751))
- [Prevent SSRF attacks for Workspaces](https://gitlab.com/gitlab-org/security/gitlab/-/commit/03fbdbe7b80e1028098df6bb10abc749b4f4b968) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4730))
- [Prevent read code access when repository is disabled](https://gitlab.com/gitlab-org/security/gitlab/-/commit/fb3eb2135770abcea4951ffe432cebb2065e7d3c) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4700))
- [Fixes XSS on the target branch in the merge request widget](https://gitlab.com/gitlab-org/security/gitlab/-/commit/f4fd06e3450f686817104895eb6aca42af4fab11) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4736))
- [Unsubscribe from actioncable channel when PAT is revoked](https://gitlab.com/gitlab-org/security/gitlab/-/commit/972f392e7daa6b60ed8ff03e6651944e1d045b40) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4726))

## 17.7.3 (2025-01-22)

### Fixed (1 change)

- [Add BoardEpicConnection type policy for pagination](https://gitlab.com/gitlab-org/security/gitlab/-/commit/f49b4349cecbbca2629e4abf9e2746d48537f350) **GitLab Enterprise Edition**

### Security (4 changes)

- [Fix protected variable exfiltration](https://gitlab.com/gitlab-org/security/gitlab/-/commit/ed6f52bb29b7dc1d6fad13c8d62725aa3a3c7283) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4714))
- [Enhance rich viewer sanitization](https://gitlab.com/gitlab-org/security/gitlab/-/commit/68187f7e86b936d1d361c78160b3855db7ffa495) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4709))
- [Avoid recursive sidekiq calls on cyclic work item hierarchies](https://gitlab.com/gitlab-org/security/gitlab/-/commit/77692306d5122b9a3006667a4bbd695f4e983a33) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4673))
- [Respect the private profile constraints](https://gitlab.com/gitlab-org/security/gitlab/-/commit/325eea0ef21773481a0aa753cffacf05a835acbc) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4698))

## 17.7.2 (2025-01-14)

### Fixed (1 change)

- [Fix handling of short gzip metadata files](https://gitlab.com/gitlab-org/gitlab/-/commit/aaa32a37cf34a2e171f5ae1b7ce1259796605f92) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177633))

### Changed (1 change)

- [Remove `download_code` dependency from access to read merge requests](https://gitlab.com/gitlab-org/gitlab/-/commit/01a950b82192d6b93de58bf3678767f58c08c5f2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/176667))

## 17.7.1 (2025-01-08)

### Fixed (3 changes)

- [Update acme-client to v2.0.19](https://gitlab.com/gitlab-org/security/gitlab/-/commit/17fb399704080e909a7ffd188dad4a0367a41cf6)
- [Add a migration to regenerate CI job token signing key](https://gitlab.com/gitlab-org/security/gitlab/-/commit/1a69b334e54530b37ca623b8e0d5da6ed2961fb1)
- [Fix CI job token signing key not always generated](https://gitlab.com/gitlab-org/security/gitlab/-/commit/6fd10c2117db61d7c894944462c29425038301c0)

### Security (4 changes)

- [Prevent cyclic reference in work item hierarchy widget from frontend](https://gitlab.com/gitlab-org/security/gitlab/-/commit/a545d1f48720d3d9908880d2a77ff0e76bcaa9a5) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4684))
- [Allow external_provider config take precedence over external_groups](https://gitlab.com/gitlab-org/security/gitlab/-/commit/c74b00da4e644dc5628f805587b2ec492e8bd044) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4680))
- [Filter out sensitive parameters on Auth logs](https://gitlab.com/gitlab-org/security/gitlab/-/commit/e6f661b6f3ec52e0e9d37b89d171e5b949346804) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4686))
- [Don't allow unauthorized users to close issues automatically](https://gitlab.com/gitlab-org/security/gitlab/-/commit/b1ef837d0b61f997dacd3b299da17c96616ba275) ([merge request](https://gitlab.com/gitlab-org/security/gitlab/-/merge_requests/4674))

## 17.7.0 (2024-12-18)

### Added (178 changes)

- [Add iteration autocomplete to RTE](https://gitlab.com/gitlab-org/gitlab/-/commit/9e1c7e1dfb027154540aabd9dade248feeea4608) by @salihudickson ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175785)) **GitLab Enterprise Edition**
- [Add pages domain verify API](https://gitlab.com/gitlab-org/gitlab/-/commit/450f7f330e7588c61d95db871c3d630ae6a4bb9a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174330))
- [Add foreign key constraints to ci_runner_machines_687967fa8a](https://gitlab.com/gitlab-org/gitlab/-/commit/373fea60d3660aabe7048ba84b39b9b93f614b04) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171848))
- [Register new audit event](https://gitlab.com/gitlab-org/gitlab/-/commit/9ac3ceb4eabe7d14ff1c5f10e92869a3d48e245c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174412)) **GitLab Enterprise Edition**
- [Add credit_card_verification_enabled setting](https://gitlab.com/gitlab-org/gitlab/-/commit/d9364a34ddcec3c7a415adf6cdde7bff8e813365) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175148)) **GitLab Enterprise Edition**
- [Add internal events tracking to the individual release page](https://gitlab.com/gitlab-org/gitlab/-/commit/f3ced32bc0289a857e503102fd7f5db54b578aee) by @antonkalmykov ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175594))
- [GraphQL: add BranchDelete mutation](https://gitlab.com/gitlab-org/gitlab/-/commit/4cde11ea43c33dcc8ee522473d79d2731d7217a6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175270))
- [Update qa github spec](https://gitlab.com/gitlab-org/gitlab/-/commit/4bd5769773e2f40cf02b5739414447c91146cc67) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175385))
- [Add deny allow list to a policy drawer](https://gitlab.com/gitlab-org/gitlab/-/commit/2132107b32bf6ddf953af4f45410cf709a9e11a8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175439)) **GitLab Enterprise Edition**
- [Add search for Kubernetes pods](https://gitlab.com/gitlab-org/gitlab/-/commit/2f13cf47d690b93b3f12f68f0a0bded08d780a0f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175585))
- [Add `/relate` quick action to WorkItems](https://gitlab.com/gitlab-org/gitlab/-/commit/14340fd8db5cc6acf78588873217c47f17890d56) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172901)) **GitLab Enterprise Edition**
- [Model experiments: Add empty state to performance graph](https://gitlab.com/gitlab-org/gitlab/-/commit/dcecf41948385ee059b11e8eb6427a7eee0f9e99) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175688))
- [In project update service add support for pages default domain redirect](https://gitlab.com/gitlab-org/gitlab/-/commit/6a7a9f8c2b8e2fa5b04f490d76ea9e8ca9b93d82) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174813))
- [Log scope when auditor initialized](https://gitlab.com/gitlab-org/gitlab/-/commit/d1465ee7377d11eed4d598286e1b8531114c23fc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175107))
- [Add validation key for license exceptions](https://gitlab.com/gitlab-org/gitlab/-/commit/1c396b582610eba69e690a3038ad7abe243a8157) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175132)) **GitLab Enterprise Edition**
- [Enable markdown description lists](https://gitlab.com/gitlab-org/gitlab/-/commit/bace25950945c55cb273d7212574fd065370f925) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175169))
- [Add backticks and remove FF](https://gitlab.com/gitlab-org/gitlab/-/commit/888268b0458492de713aade5fafd72126316d4ed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174880))
- [Add note regarding user namespaces](https://gitlab.com/gitlab-org/gitlab/-/commit/4fdaf5c2b23fbab3e92d8ba806561e4b4c3e9371) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175545))
- [Model experiments: Add user, created_at, model_id](https://gitlab.com/gitlab-org/gitlab/-/commit/cd594594bc933a856d29071b1194e3a8ddaf8031) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175529))
- [Remove npm_extract_npm_package_model feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/3b6c508c14412d76ccc819263a8e5273e5db5e71) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173999))
- [Add ability to assign GitLab Duo seats based on SAML groups](https://gitlab.com/gitlab-org/gitlab/-/commit/44dc47007c61982d9fa82df13668fef00111c9c7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174021)) **GitLab Enterprise Edition**
- [Add ci_requires_identity_verification_on_free_plan setting](https://gitlab.com/gitlab-org/gitlab/-/commit/f220095c6e267a3086ba90168e1cfe2fa5ab2609) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175305)) **GitLab Enterprise Edition**
- [GraphQL API: add endpoint to return a list open merge requests](https://gitlab.com/gitlab-org/gitlab/-/commit/d4523528d87731748cef2c9047f0e50a6ce2dc87) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172997))
- [Admin Token API: Revoke token](https://gitlab.com/gitlab-org/gitlab/-/commit/4d27a6a59ca4715dc832a808f1a076a760d9be0f) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170421))
- [Default enable FF vulnerability_filtering_by_identifier](https://gitlab.com/gitlab-org/gitlab/-/commit/9540b807e10270ec5bae50bdd08134a9ed333d30) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175512)) **GitLab Enterprise Edition**
- [Allow default editor setting to be optional](https://gitlab.com/gitlab-org/gitlab/-/commit/3066c9c0d61057ffbec865da927120625c9a9b88) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175187))
- [Support for Vulnerability webhook events](https://gitlab.com/gitlab-org/gitlab/-/commit/8304e298f5a009f33ff69c16bf16f52de3def85f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169701)) **GitLab Enterprise Edition**
- [Introduce Rotate Token in UI - Impersonation Tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/3d5eb88f078fce8852b060bb0fce5346183bd3f0) by @shangsuru ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173708))
- [Add and track events for Vulnerability auto-resolution](https://gitlab.com/gitlab-org/gitlab/-/commit/a547977c90c0249ea6d3881b5e2d99e14c286ba6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175012)) **GitLab Enterprise Edition**
- [Add pipeline summary for reusable pipeline widgets](https://gitlab.com/gitlab-org/gitlab/-/commit/13d0a286e3f766536064e4b7d1c05cceedc6bd2a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173798))
- [Add UI for managing integrations allowlist](https://gitlab.com/gitlab-org/gitlab/-/commit/1947c028d8ed4189058cb0afb1af83e8e5704222) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174617)) **GitLab Enterprise Edition**
- [Add warning to group approval settings when policies may override it](https://gitlab.com/gitlab-org/gitlab/-/commit/21b49e946618a2f18588f0f19061e2f439d9a2ae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175319)) **GitLab Enterprise Edition**
- [Add a warning when approval settings may be affected by policies](https://gitlab.com/gitlab-org/gitlab/-/commit/a52032aede263054c88a34b56418234ba07b5e72) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175303)) **GitLab Enterprise Edition**
- [Add new API to update secret push protection for group](https://gitlab.com/gitlab-org/gitlab/-/commit/aeabdc0aad3b5514a868e1e05060a770797fa4a4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175225)) **GitLab Enterprise Edition**
- [Add build source filter to GraphQL Project Job query](https://gitlab.com/gitlab-org/gitlab/-/commit/7c5dde7c145f2c17907c343a432e6125f3ea599b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170899))
- [Added the ability to query EPSS data in GraphQL through vulnerabilities](https://gitlab.com/gitlab-org/gitlab/-/commit/0f3309e4bc772b8efa183a0eca29404ad6e6539b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172285)) **GitLab Enterprise Edition**
- [Model experiments: Add candidates table](https://gitlab.com/gitlab-org/gitlab/-/commit/a725fbb73206c9dee593692547b22566510fd3bb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174684))
- [Document skip_ci option for pipeline execution policies](https://gitlab.com/gitlab-org/gitlab/-/commit/fccfa6dcad20e83a7d3a3539c24e6c5495dc8c37) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175239))
- [Adding metric for when a vulnerability is resolved](https://gitlab.com/gitlab-org/gitlab/-/commit/f63412bed60e525a780f4485929c029e83d1f390) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175174)) **GitLab Enterprise Edition**
- [Support composite identity in Runner activity](https://gitlab.com/gitlab-org/gitlab/-/commit/16683f568934fce717413f40fd7377f85169d3ea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175406))
- [Allow users to configure skip ci behavior for pipeline execution policy](https://gitlab.com/gitlab-org/gitlab/-/commit/c1e9eba787436fa6f093f33a1b336b38b5e035a3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173480)) **GitLab Enterprise Edition**
- [Enable VR in MR by default](https://gitlab.com/gitlab-org/gitlab/-/commit/9c816a94ffc91d96e89d521b51faa07bdfe3b8b0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175150)) **GitLab Enterprise Edition**
- [Include snippet import requirements](https://gitlab.com/gitlab-org/gitlab/-/commit/f705d7335e7305e11be381318ea2ac63c44044cc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175273))
- [Add vulnerabilities in Import and Export and Direct Transfer](https://gitlab.com/gitlab-org/gitlab/-/commit/a28d750a976ee29f379369a6d209eacd5ec7f0b7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171684))
- [Add include_forked for blobs search graphql api](https://gitlab.com/gitlab-org/gitlab/-/commit/1ec2e0ab9cde8f6943dfd46a85339c6edcfbd784) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175008)) **GitLab Enterprise Edition**
- [Add new KAS fields to GraphQl](https://gitlab.com/gitlab-org/gitlab/-/commit/3b66c9f9372041cea417d2031ba5fce4fb535ed3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174384))
- [Fix the response order](https://gitlab.com/gitlab-org/gitlab/-/commit/b4401cd8a4ddadaedffbdc8d59b06c276708241f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173835)) **GitLab Enterprise Edition**
- [Add yaml update for allow list](https://gitlab.com/gitlab-org/gitlab/-/commit/6766162666f400cba193e727ed3ad27fa70a7218) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174296)) **GitLab Enterprise Edition**
- [Create approval rules for multiple policy approvers](https://gitlab.com/gitlab-org/gitlab/-/commit/d3be4a2f001d31c197a5ce5db893082fdcd9b7dd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175162)) **GitLab Enterprise Edition**
- [Document that Planner role can import issues from CSV](https://gitlab.com/gitlab-org/gitlab/-/commit/fb1ac5aedeedf62ee44af567ef3b7a60b6161074) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174964))
- [Add migration to reindex all work items](https://gitlab.com/gitlab-org/gitlab/-/commit/560657f88b28dded6cddb177bcb601158f409961) by @joe-snyder ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174463)) **GitLab Enterprise Edition**
- [Add phone_verification_enabled application setting](https://gitlab.com/gitlab-org/gitlab/-/commit/e7b9c6b72a524c866be2733c6341e4cac27d0851) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175013)) **GitLab Enterprise Edition**
- [Added total policy violations count to the GrpahQL API](https://gitlab.com/gitlab-org/gitlab/-/commit/b45f1690e400bc657f126a497aaa65b82fbd2fe1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175100)) **GitLab Enterprise Edition**
- [Add new API to update secret push protection for group](https://gitlab.com/gitlab-org/gitlab/-/commit/815b4e9e82dadf01cbd6f7c871e149852c414e76) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174342)) **GitLab Enterprise Edition**
- [Add composite identity enforce setting to users](https://gitlab.com/gitlab-org/gitlab/-/commit/f57311382b7806c6113e289623d2400b1d6ff088) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174026))
- [Model experiments: Performance graph](https://gitlab.com/gitlab-org/gitlab/-/commit/44726791aa2f8497739baf0934caf6f84c8e77ad) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174413))
- [Backfill namespace shared_runner_minutes_limits](https://gitlab.com/gitlab-org/gitlab/-/commit/f1d1f9982bb10ed52759b007e677f53ba5f5a2e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161485)) **GitLab Enterprise Edition**
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/7568ee97793553d03f4b81040245208937bf1cf6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175078))
- [Add custom_role_approvers to MR approval policies](https://gitlab.com/gitlab-org/gitlab/-/commit/c90918772c19a163e5b2fef792df91c733822e6c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174338)) **GitLab Enterprise Edition**
- [Remove merge_when_checks_pass_merge_train feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/a9723888bab8f764bef7424e3ccf202b0d83fbcf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174357))
- [Add indent and outdent functionality to RTE](https://gitlab.com/gitlab-org/gitlab/-/commit/1a8c7655abcbff13c392a963109908975f4529cd) by @salihudickson ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174311))
- [Add include_archived for blobs search graphql api](https://gitlab.com/gitlab-org/gitlab/-/commit/1739a9d16a46b332c2bc4aeb7e1cefbaa56dfe04) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174911)) **GitLab Enterprise Edition**
- [Adds autopopulated to group and project scope links tables](https://gitlab.com/gitlab-org/gitlab/-/commit/92d77f50cc25d40829523ef7735294996d38d5b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174901))
- [Support composite identity in CI pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/28e04061e7512239c37857773d23c27f415814f5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174051))
- [Create entry in package reference when adding new package file](https://gitlab.com/gitlab-org/gitlab/-/commit/126e07bbce5598e67cfa96c14823439c1ec4a233) by @oceane_scania ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168381))
- [Add documentation and roll out ensure PEP pre stage complete](https://gitlab.com/gitlab-org/gitlab/-/commit/ca7f13e5795fbc3027c4617d7aae78e492ee6b13) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174663)) **GitLab Enterprise Edition**
- [Allow unverified users to opt-in to identity verification for access](https://gitlab.com/gitlab-org/gitlab/-/commit/360f470a4e803f6e6afd3f5f878a7c1bc6fc07ee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174732)) **GitLab Enterprise Edition**
- [Add a type field to UserCore](https://gitlab.com/gitlab-org/gitlab/-/commit/00dff5f519dfb16c00fa8acd0cf387e76bfc9c31) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173568))
- [Add ai_conversation_threads and ai_conversation_messages tables](https://gitlab.com/gitlab-org/gitlab/-/commit/78d263911f80478f8f862cce52fdbb913b5a4e12) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171934)) **GitLab Enterprise Edition**
- [Add auto stop setting to environments](https://gitlab.com/gitlab-org/gitlab/-/commit/d5792a14823eaf5da88bc84d9ba380a7d5d1db83) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173804))
- [Update issue tracking integrations to work  with instance integrations](https://gitlab.com/gitlab-org/gitlab/-/commit/f206ca18a208e1dc21fafe5b3ac9a1aef34f12c4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173746))
- [Added new author filter for merge request scope](https://gitlab.com/gitlab-org/gitlab/-/commit/6929fb50e14bb135f7314124d895bd7c9a20fd7a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173247)) **GitLab Enterprise Edition**
- [Add GQL type on project for component usages](https://gitlab.com/gitlab-org/gitlab/-/commit/14cce165d7d51898b67cc50b9017fb068cd186e7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173816)) **GitLab Enterprise Edition**
- [Settings block: Add id to url to make them shareable](https://gitlab.com/gitlab-org/gitlab/-/commit/dbaf3fc096131e8321ef232050b6f53d0136910a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173988))
- [Add pages_default_domain_redirect in project_settings](https://gitlab.com/gitlab-org/gitlab/-/commit/689a3a2c460d89a6de12fd025132a7d42328b280) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173510))
- [Write trigger_id to Ci::Pipeline](https://gitlab.com/gitlab-org/gitlab/-/commit/129af5381f27b1c897c9495298e2a0e248cff182) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174132))
- [Allow promoting a work item issue to an epic using quick actions](https://gitlab.com/gitlab-org/gitlab/-/commit/16c16f9c97668fd01141110ebaa34cf1c8ff80bb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173718)) **GitLab Enterprise Edition**
- [Add backticks around username mentions](https://gitlab.com/gitlab-org/gitlab/-/commit/5595b18174e0e4d804ffcb6560e3fc912c8e98cf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174536))
- [Implement WorkItemWidgetDevelopment.relatedMergeRequests field](https://gitlab.com/gitlab-org/gitlab/-/commit/86971adccc793f76e9cb77f6527b179e9215f3f1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174044))
- [Add policy action_idx to approval rules validation](https://gitlab.com/gitlab-org/gitlab/-/commit/c9c7332c5c3d9f3d4eff07a27dc7278e4dfacd1d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174308)) **GitLab Enterprise Edition**
- [Enable filtering by subscriptions in GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/e7d7fcb0d8c4586f7abdc99e657e7c4f6e1a5dfc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174578))
- [Add concurrency limit to CreateBotWorker](https://gitlab.com/gitlab-org/gitlab/-/commit/3379a8ba1ac721d61189587f963d41d52dbb8d59) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174739)) **GitLab Enterprise Edition**
- [Vue Projects - Inactive project descriptions](https://gitlab.com/gitlab-org/gitlab/-/commit/0b81708152cb9b301d785d07b456521f0a52c45c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173788))
- [Add error_messages to GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/73c44ba81052972a24fdfaf30f19bd7cc647c56b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174434))
- [Introduce failed jobs in MR](https://gitlab.com/gitlab-org/gitlab/-/commit/7b12f3e6486766124a124a60f8b1766d5b022c7e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174586))
- [Add option without auto-approvals to User Signup settings](https://gitlab.com/gitlab-org/gitlab/-/commit/93d6bed753f1582b632dd78b24e2f0db7b5d23de) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172726)) **GitLab Enterprise Edition**
- [Handle variables_attributes for policy pipelines](https://gitlab.com/gitlab-org/gitlab/-/commit/3b45e590392ef5809334073a34ced282f6dc1d14) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174112)) **GitLab Enterprise Edition**
- [Enable work item epics](https://gitlab.com/gitlab-org/gitlab/-/commit/1d835ebbc3855a20ae0c9f4ffa713a6be1826516) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174341)) **GitLab Enterprise Edition**
- [Remove api_audit_requests_with_scope flag](https://gitlab.com/gitlab-org/gitlab/-/commit/cefe5f9a0816ccaaf1abf21c53b43258750b908b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174516))
- [Promote planner role on invite members page](https://gitlab.com/gitlab-org/gitlab/-/commit/e26dceb80d587b7b1c0f0f7f1541150554599227) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173733))
- [Add with_highest_role_planner field to users_statistics table](https://gitlab.com/gitlab-org/gitlab/-/commit/772a8f6aa0237e34d10fd9286461229ea3d02375) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170949)) **GitLab Enterprise Edition**
- [Specify namespace and flux_resource_path in CI job](https://gitlab.com/gitlab-org/gitlab/-/commit/7b6a1a8a8350de94ee476bdaefda635134edfe03) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173366))
- [Fix: Completions worker accessing deleting feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/abbc3cce57eba053d2490114abdc424d560e92a1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173296)) **GitLab Enterprise Edition**
- [Update Initial Duo Config Box Settings](https://gitlab.com/gitlab-org/gitlab/-/commit/111fb1daf860a74e59d796bd2d565ffaa1a427f5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168903)) **GitLab Enterprise Edition**
- [Add markdown include directive](https://gitlab.com/gitlab-org/gitlab/-/commit/f287ab276b6208332f3059b590c8ec1e10237a23) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174584))
- [Add rotate via UI to project and group access tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/3ef91c750102bf3bcd5c4a20c6d527739a163289) by @shangsuru ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173074))
- [Update dormant member docs to reference max value](https://gitlab.com/gitlab-org/gitlab/-/commit/5582dc3df9441f8acd1693afb57e9c6dca9792bf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174168))
- [Remove specialized_worker_for_group_lock_update_auth_recalculation FF](https://gitlab.com/gitlab-org/gitlab/-/commit/e52726b7148104120b96178af38d6ddfe0ffdc46) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174519))
- [Add Owners to `Allowed to create projects` options on Group](https://gitlab.com/gitlab-org/gitlab/-/commit/7be0ea355e97730fcecd322d8ca203e3de60b852) by @yasuk ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173406))
- [Add pages_default_domain_redirect in project_settings](https://gitlab.com/gitlab-org/gitlab/-/commit/06dfce173aab739f504426ff4c08cc61b330e495) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173373))
- [Backfill issue_links_id on related_epic_links](https://gitlab.com/gitlab-org/gitlab/-/commit/d67572e8f44732d8a8a873a10e95f32fec612bfc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174444)) **GitLab Enterprise Edition**
- [Fix AiSetting race condition](https://gitlab.com/gitlab-org/gitlab/-/commit/0174485b9629506a394cb99fb5bfd2bb84755e7f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173226)) **GitLab Enterprise Edition**
- [Added completion notification for project imports](https://gitlab.com/gitlab-org/gitlab/-/commit/75e5d99b8550801e770daf286f0c00afd834b39b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173596))
- [Add sharding key columns to uploads](https://gitlab.com/gitlab-org/gitlab/-/commit/e4a250a50637406ac515a41273791360794e9410) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168003))
- [Clean up expiring_pats_30d_60d_notifications FF](https://gitlab.com/gitlab-org/gitlab/-/commit/d9068fd1893f1909921269db36ee88f5239066d5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173792))
- [Add stream destination mapping to legacy models](https://gitlab.com/gitlab-org/gitlab/-/commit/ff0a9f8cf8a755c0f823a47565f4f0126e964904) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173322)) **GitLab Enterprise Edition**
- [Add remaining licenses without spdx to custom software license table](https://gitlab.com/gitlab-org/gitlab/-/commit/8a064cabb152531ab165faad940e574a72c612c3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173790))
- [Model registry: Add default experiment to model card](https://gitlab.com/gitlab-org/gitlab/-/commit/b1c35b84395c630ffd77e6b10aa4fe825ebf65bf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174376))
- [Add persisted related item to new work item flow](https://gitlab.com/gitlab-org/gitlab/-/commit/a53198d43cbc68d022676b24aabbaf9c0f149c07) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173840))
- [Add processing for additional error codes](https://gitlab.com/gitlab-org/gitlab/-/commit/5d454dc4372b829c79a3c1c9fe3bdac0891b21e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172117)) **GitLab Enterprise Edition**
- [Add the model for registry tag protection rules](https://gitlab.com/gitlab-org/gitlab/-/commit/57ffd8a98f26cf9357aa074db24ed84d9b04b9e3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172580))
- [Added Work item frontend ground work](https://gitlab.com/gitlab-org/gitlab/-/commit/724a647c86633d343d77f9803b34c2f466d7be9a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171956)) **GitLab Enterprise Edition**
- [Integrations observe settings allow list](https://gitlab.com/gitlab-org/gitlab/-/commit/49e4313a57a89741985db74d32cda9740405ab58) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172951)) **GitLab Enterprise Edition**
- [Add dormant scope to seat assignments](https://gitlab.com/gitlab-org/gitlab/-/commit/03fa2e8035af8aad4409d210f8e689b9b75e8ceb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173518))
- [Add `suspended` status for Flux sync badge](https://gitlab.com/gitlab-org/gitlab/-/commit/9b46a4379bed74218d759f3ce9fcdcbfb40efdf1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174161))
- [Rename to follow convention](https://gitlab.com/gitlab-org/gitlab/-/commit/399474beca149c78ffc6aa2e886e610f032ec38a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173269)) **GitLab Enterprise Edition**
- [Add pages_default_domain_redirect in project_settings](https://gitlab.com/gitlab-org/gitlab/-/commit/a6be40915b17e2f0bee15e4060e7e758d474ceee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173120))
- [Add Duo seats usage panel to AI Impact dashboard](https://gitlab.com/gitlab-org/gitlab/-/commit/45562b25c5dc445f90beef3366d6c95b82372ac3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173735)) **GitLab Enterprise Edition**
- [Allow transfer of project with tags](https://gitlab.com/gitlab-org/gitlab/-/commit/e1f1f2a55c72477bedf3810293bd8edadc88be34) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173768))
- [Add trial date attribute validations](https://gitlab.com/gitlab-org/gitlab/-/commit/9d1bcda516085bdbc8c8daab0eb92f23487c83d5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168521)) **GitLab Enterprise Edition**
- [Model registry: Add candidates tab to Model card](https://gitlab.com/gitlab-org/gitlab/-/commit/cec17ff9bf08f4df013ed7e7a272339297ade672) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173711))
- [Enforce allowlisted policies for CI/CD Jobs](https://gitlab.com/gitlab-org/gitlab/-/commit/8a62251ec12aa5bb079e7f10189258725aaeabe0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169264))
- [Add additional fields and optional slot to commit changes modal](https://gitlab.com/gitlab-org/gitlab/-/commit/7747226a9d9d111ba23f51295bbbf6593e36265c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173620))
- [Adding update mutation for compliance requirements](https://gitlab.com/gitlab-org/gitlab/-/commit/e9857175b69f175f8f0fc60b2abe306b65316afe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170195)) **GitLab Enterprise Edition**
- [Add new index to alert management alerts](https://gitlab.com/gitlab-org/gitlab/-/commit/286822402922238185831b8bd1418f7f976f8644) by @max.woolf ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174015))
- [Exposed pre_receive_secret_detection_enabled in ProjectTypes](https://gitlab.com/gitlab-org/gitlab/-/commit/fd5498a92c9eac3f4ead0525e186fbfb44a776e5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173221)) **GitLab Enterprise Edition**
- [Enable auto_stop_in for non-deployment environment actions](https://gitlab.com/gitlab-org/gitlab/-/commit/a87f6660f9f39add380276dae514c51fc6b5f643) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173351))
- [Add notes fields to work item query](https://gitlab.com/gitlab-org/gitlab/-/commit/d9e7a1f3589d790734fed7c71a9d88a99e031085) by @joe-snyder ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173719))
- [Add entry for GLQL to code block languages](https://gitlab.com/gitlab-org/gitlab/-/commit/64ee6208422f520dfddc7b5f4cc2dc8141db669b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174024))
- [Remove feature flag "beyond_identity_exclusions"](https://gitlab.com/gitlab-org/gitlab/-/commit/e81fb19e8f709b4c053ad2f40a3b670de2645884) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173281))
- [Set assign_custom_roles_to_group_links_sm to true by default](https://gitlab.com/gitlab-org/gitlab/-/commit/29cb8e88d0c885716eae14376ba75b38068d9a52) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173941)) **GitLab Enterprise Edition**
- [Dynamically populate Duo Chat slash command suggestions based on URL](https://gitlab.com/gitlab-org/gitlab/-/commit/18aff951238eba8f77bf6d4dd847653889c477d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173052)) **GitLab Enterprise Edition**
- [GraphQL: Expose user timezone](https://gitlab.com/gitlab-org/gitlab/-/commit/55aec6880d7637e869dd428b823dbceb89d00350) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173913))
- [Add "GET /groups/:id/enterprise_users" API endpoint](https://gitlab.com/gitlab-org/gitlab/-/commit/249d272cb8e182f9110bc805d1ee4971d69e8795) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172408)) **GitLab Enterprise Edition**
- [Remove work_items_rolledup_dates feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/cd713ebb3acb770c4bf613eef162d49d1acfd345) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167917)) **GitLab Enterprise Edition**
- [Include identifierName argument to vulnerabilitySeveritiesCount GraphQL](https://gitlab.com/gitlab-org/gitlab/-/commit/92756c3569e3c042642c145278f942861067d57b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173545)) **GitLab Enterprise Edition**
- [Add duo workflow status check](https://gitlab.com/gitlab-org/gitlab/-/commit/0ccc5fd1c5b215cae14d26c64fbc964a0abe47c6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173388)) **GitLab Enterprise Edition**
- [View branches in development widget](https://gitlab.com/gitlab-org/gitlab/-/commit/9c9f04acf04b2e309436c6c7d002a003f526759a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173384))
- [Setup associations for inviting a group to a project with a custom role](https://gitlab.com/gitlab-org/gitlab/-/commit/8fe027c539890788b6e4bfe81acd2a3f31e10c6c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173658)) **GitLab Enterprise Edition**
- [Support job token auth for read-only changelog generation API](https://gitlab.com/gitlab-org/gitlab/-/commit/72fc936d08b8b37786911c993f9c0ee4bbdf0ee5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172842))
- [Admin Token API: Cluster Agent Tokens](https://gitlab.com/gitlab-org/gitlab/-/commit/401f5a1f70ca1d021c953eccb2f1e33c49b9ae71) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172932))
- [Admin Token API: Add support for reading OAuth Application Secrets](https://gitlab.com/gitlab-org/gitlab/-/commit/ff403182b64c0260bfe550e26f411da967bd021e) by @nwittstruck ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172985))
- [Update project statistics when create/delete NuGet symbols](https://gitlab.com/gitlab-org/gitlab/-/commit/63f36aec2e3dc1495a67b70d208d69f6bfa61d5d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173411))
- [Make PersonalAccessToken#token routable](https://gitlab.com/gitlab-org/gitlab/-/commit/3bd08ef6f1c743ca0c048f27256e05dd9667d7f3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169322))
- [Update UI text referencing confidentiality visibility](https://gitlab.com/gitlab-org/gitlab/-/commit/bc354fa3e04f34356da591342e2e315689247489) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171950))
- [Show anchors in cleanup image tags regex input fields](https://gitlab.com/gitlab-org/gitlab/-/commit/da699f136b30089454d216c4e3cabdc288d06ede) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172537))
- [Add PostgresTableSize](https://gitlab.com/gitlab-org/gitlab/-/commit/751bb26364670539d59a2dc063a1ab6b66d5b21f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173113))
- [Add Planner role to access level GraphQL enums](https://gitlab.com/gitlab-org/gitlab/-/commit/d4ff282b9fc64f8eb841fc4a05afc07c44aef340) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170940)) **GitLab Enterprise Edition**
- [Add permissions for Planner role](https://gitlab.com/gitlab-org/gitlab/-/commit/5b833ab353dcb6703fa6983df23ae3287c996460) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171283))
- [Add Planner role to Roles and permissions admin page](https://gitlab.com/gitlab-org/gitlab/-/commit/f52054a5eb5cdb34f6ff56dbfaeb9c30b51b7f5e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173280)) **GitLab Enterprise Edition**
- [Add Planner role](https://gitlab.com/gitlab-org/gitlab/-/commit/382fea3baa01e3a53176140033a93129cc9c1581) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256))
- [Implement new routable token specification](https://gitlab.com/gitlab-org/gitlab/-/commit/5e0e3d943fa686a2ee3a271bd47ee39c186096cd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172708))
- [New GraphQL API for filter by identifier dropdown](https://gitlab.com/gitlab-org/gitlab/-/commit/e1da1669afbe66d60c97775fe49e70cd219915b9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171464)) **GitLab Enterprise Edition**
- [Initial checkin for Admin Duo Configuration page](https://gitlab.com/gitlab-org/gitlab/-/commit/adfd5a0556a2bf0d68ee5a00da7b796345836dca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168702)) **GitLab Enterprise Edition**
- [Destroy mutation for compliance requirements](https://gitlab.com/gitlab-org/gitlab/-/commit/b896d5301c0a183a9338476b3a7606d42484472f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170380)) **GitLab Enterprise Edition**
- [Add migration to create missing terraform module metadata](https://gitlab.com/gitlab-org/gitlab/-/commit/def8125c3c3370c9fcc007ebbe577feb910d4288) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171729))
- [Create is_known_exploit column in pm_cve_enrichment and add tests](https://gitlab.com/gitlab-org/gitlab/-/commit/b6400000bef4d917ee47f97fb19690584d273bdd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172190))
- [Expose can_create_organization through application settings API](https://gitlab.com/gitlab-org/gitlab/-/commit/4f5951936862414b0cd91dfab866ef206bdac6ed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173380))
- [Remove merge_when_checks_pass feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/17d4261428a490ebdb74d33fc75425f9a0e717dd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170886))
- [Remove feature flag lfs_misconfiguration_banner](https://gitlab.com/gitlab-org/gitlab/-/commit/3f88a3b929edff076309684edefeb7ea283eb258) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173318))
- [Link compliance frameworks with vulnerability management policies](https://gitlab.com/gitlab-org/gitlab/-/commit/a1ae237770add362366d2231a92b7b4597a28ecf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171766)) **GitLab Enterprise Edition**
- [Fetch linked context lines](https://gitlab.com/gitlab-org/gitlab/-/commit/65c38f43458b2224ed25d89628b150584cd8de9c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172990))
- [Update GitLab Pages version](https://gitlab.com/gitlab-org/gitlab/-/commit/561277f08c6ca3ceacb4175c6c6f9321b1927671) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172810))
- [Add additional JWT audiences for Jira Connect](https://gitlab.com/gitlab-org/gitlab/-/commit/004c681cd170cb857ad912f190e2c85a7915bcc1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171197))
- [Clean up sm_duo_pro_bulk_user_assignment](https://gitlab.com/gitlab-org/gitlab/-/commit/92a7cf6c4fd5970dcdd5c4a3dd74f6a3570b6ccd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172975)) **GitLab Enterprise Edition**
- [Add legacy_destination mapping for audit event streaming destinations](https://gitlab.com/gitlab-org/gitlab/-/commit/142f916425191a5bff07499aee19370f2d72a161) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172308)) **GitLab Enterprise Edition**
- [Add transclusion markdown syntax](https://gitlab.com/gitlab-org/gitlab/-/commit/09e452c92a5d2584f08aa0e7efa64e44845c89ef) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169374))
- [Add ciJobTokenScopeAllowlist graphql type](https://gitlab.com/gitlab-org/gitlab/-/commit/ac9434f1aab54f6918ca9bab029059eb80067d8e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171887))
- [Support claude 3.5 Sonnet new model version](https://gitlab.com/gitlab-org/gitlab/-/commit/b054b171a4b0efed9ed73bf5294e6249c7db204b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173134)) **GitLab Enterprise Edition**
- [Use feature flag to new streamers](https://gitlab.com/gitlab-org/gitlab/-/commit/52db19c6cde0333d29ecd969ca71d419e1f320db) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171431)) **GitLab Enterprise Edition**
- [Project template becomes an official part of the product](https://gitlab.com/gitlab-org/gitlab/-/commit/c55cde183c38d6ca7716da731c8ec48180922362) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172802)) **GitLab Enterprise Edition**
- [Add support for using ActiveRecord::Encryption](https://gitlab.com/gitlab-org/gitlab/-/commit/d3a67954521dad93641184fb7e640b1411d5235a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168773))
- [Initial checkin for duo configuration page](https://gitlab.com/gitlab-org/gitlab/-/commit/7ad19b5b575dfc2038bfa7e7e62d5a248102f3bd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168581)) **GitLab Enterprise Edition**
- [Mark note as internal permission on frontend](https://gitlab.com/gitlab-org/gitlab/-/commit/ca581bd32666f4d3008a43c7895867eee692dc28) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173083))
- [Added Work item frontend ground work](https://gitlab.com/gitlab-org/gitlab/-/commit/376c1db623cc48d8e5fa3eb9ccace2f0ef48245c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171126))
- [Added keyboard shortcuts for command platte](https://gitlab.com/gitlab-org/gitlab/-/commit/8da80d24cca92030d72e3380c23a59182e07cfb6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172732))
- [Enable ingestion of EPSS data to GitLab database](https://gitlab.com/gitlab-org/gitlab/-/commit/79231461a37eecb62fd54a8f85cee0e781bfe175) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172510)) **GitLab Enterprise Edition**
- [Default Duo Chat output tokens to 8k](https://gitlab.com/gitlab-org/gitlab/-/commit/3f9d9d358cef7f877c65ed765c379d1ac3efad6e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167841)) **GitLab Enterprise Edition**

### Fixed (181 changes)

- [Fix duplicate reply bug on wiki comments](https://gitlab.com/gitlab-org/gitlab/-/commit/1666d68421a36da4522f66d4ac15844eedfa0e8d) by @salihudickson ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175794))
- [Set CVSS vectors during vulnerability scanning](https://gitlab.com/gitlab-org/gitlab/-/commit/a91afd97174798423ac4081cfd1303708b3fb2cc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175756)) **GitLab Enterprise Edition**
- [Fix CreateService for buffered_token_expiration_limit](https://gitlab.com/gitlab-org/gitlab/-/commit/51dfa96b004a77fd007fa9563a8fd20b36e48ba8) by @joe-snyder ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175124)) **GitLab Enterprise Edition**
- [Render a warning for pull mirroring when the project is read-only](https://gitlab.com/gitlab-org/gitlab/-/commit/cf7adc171c308208fbcbaf293a63178b4acec790) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174976))
- [Fix classification label default behaviour](https://gitlab.com/gitlab-org/gitlab/-/commit/b95bd172405c7d08adc17fdb280ecb243881722c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175201))
- [Return `title` field from YAML for `name` custom role graphql field](https://gitlab.com/gitlab-org/gitlab/-/commit/f03c16c2dd0f73152dc948f22467d406e75f02d0) by @Florian_Lang ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167405)) **GitLab Enterprise Edition**
- [Fix alignment of MR approvals widget revoke button](https://gitlab.com/gitlab-org/gitlab/-/commit/5cdf0f910fc9fe06466741bb9e20bdf66006f0e5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175277))
- [Additional updates to PAT buffered expiration flow](https://gitlab.com/gitlab-org/gitlab/-/commit/82b4bc81ec76474f21ab41758c568aa736b103da) by @joe-snyder ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175172))
- [Improve confusing UX when deleting free project on gitlab.com](https://gitlab.com/gitlab-org/gitlab/-/commit/ee7733ad4de0852a42b031b9d5ee776b8e3027aa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173338)) **GitLab Enterprise Edition**
- [Fix styling in Analytics data explorer](https://gitlab.com/gitlab-org/gitlab/-/commit/356b906299231e84cd3c1a709dec297520b74e8e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174994)) **GitLab Enterprise Edition**
- [Fix work item create new draft data](https://gitlab.com/gitlab-org/gitlab/-/commit/f8a94926a292f33422a7f647587de3a38bad0a44) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175682))
- [Don't rewrite `applies_to_all_protected_branches` value on update](https://gitlab.com/gitlab-org/gitlab/-/commit/b27e692c03a6802aef0abb58e1b473a290d18e65) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175708)) **GitLab Enterprise Edition**
- [BranchRuleDelete mutation: fix 500 error when rule is missing](https://gitlab.com/gitlab-org/gitlab/-/commit/1238183c8618eb71a317a5a544f840ee65970d32) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175275))
- [Fix incorrect query parameters for commits request](https://gitlab.com/gitlab-org/gitlab/-/commit/139c8184c4a393987e8f1d9a683c9ca1ebd1d991) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175665))
- [Backport bugfix for diff_files highlighting](https://gitlab.com/gitlab-org/gitlab/-/commit/a01b3538f10067f52f7d005496320d76a4284d15) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175661))
- [fix: Add missing gitlab_sec schema to PrometheusAlertIndicator](https://gitlab.com/gitlab-org/gitlab/-/commit/85f73bd285525b1e91d89c444bea5a0f31bbd687) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170857))
- [Fix message for the restart merge train popup](https://gitlab.com/gitlab-org/gitlab/-/commit/c462d86f529e3d01d36f635fcb28607849e3332a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175631))
- [Sync any_merge_request rules based on scan_result_policy_reads](https://gitlab.com/gitlab-org/gitlab/-/commit/032c9d530e7b40db72352393eab5518ec27c8c74) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175539)) **GitLab Enterprise Edition**
- [Show group dropdown for minimal access users](https://gitlab.com/gitlab-org/gitlab/-/commit/f174719c6ba7306adacc9f2abe53538412b66be0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173937))
- [Set minimum override role to developer](https://gitlab.com/gitlab-org/gitlab/-/commit/dd21e69c38967dfb287a1e686da204951e9f7e26) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175592))
- [Fix vulnerability_states filter for pre-existing approval rules](https://gitlab.com/gitlab-org/gitlab/-/commit/a21ee903a96862ca26a34492910e57ec123bfccf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175282)) **GitLab Enterprise Edition**
- [Fix composite identities with Gitaly calls](https://gitlab.com/gitlab-org/gitlab/-/commit/32a1bafaaabc0c359b1d5f3d88bb33e4655cd225) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175361))
- [Fix a strange bug with preserving paragraphs and list items](https://gitlab.com/gitlab-org/gitlab/-/commit/cad030f57fb9e184a9d5867d2c35416d19196bc3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175455))
- [Strip frontmatter when including wiki content](https://gitlab.com/gitlab-org/gitlab/-/commit/0809fc62f1e93685110a55ce923ad7e705b67d2e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173573))
- [Allow issuable expansion when previewing wiki](https://gitlab.com/gitlab-org/gitlab/-/commit/7f938b29b5b566a0f9e628cfdb119f41c5703453) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175451))
- [Fix: last commit box action styling](https://gitlab.com/gitlab-org/gitlab/-/commit/190bc73b383d923c1768adaf54d03d2b1a7cdd92) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175024))
- [Allow deactivated users with password reset to reactivate their accounts](https://gitlab.com/gitlab-org/gitlab/-/commit/8d281824b6fe9e3c64aabc8387806904eaeb1756) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172879))
- [Make finalzie background migration no-op](https://gitlab.com/gitlab-org/gitlab/-/commit/16ab92d94e14462f372a96af975f9d42a644f5fe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175250))
- [Clean up `upgrade_pdf` flag](https://gitlab.com/gitlab-org/gitlab/-/commit/20ab97875677e8c5ce7b73079cddd248ecba4522) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174904))
- [Capture composite identity in Git workflows](https://gitlab.com/gitlab-org/gitlab/-/commit/d441612eebac359d72b95abe6d2335bf8614a759) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175144))
- [Namespace api find un-replicated newly created trial group by id](https://gitlab.com/gitlab-org/gitlab/-/commit/e1e18d127af80cca3c2b524b98e6c98180504570) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174396)) **GitLab Enterprise Edition**
- [Remove Owner from base_access_level roles when creating custom role](https://gitlab.com/gitlab-org/gitlab/-/commit/17294c6b19cc223c2754205fc52863514b726bc9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174735)) **GitLab Enterprise Edition**
- [Fix free shared runners minutes backfill](https://gitlab.com/gitlab-org/gitlab/-/commit/b761668a1230b01f81b8a9691823e93b52fc193c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175354)) **GitLab Enterprise Edition**
- [Fix ability to use password for Git when password for Web is disabled](https://gitlab.com/gitlab-org/gitlab/-/commit/798dabc5892dfc3d4a649a2c890b0728f5f638e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175160))
- [Fix color of emoji picker sticky header category header](https://gitlab.com/gitlab-org/gitlab/-/commit/6bd31f686892c4e1a575b0d30dd535eaae344cb3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175027))
- [Ensure p element inside details summary behaves properly](https://gitlab.com/gitlab-org/gitlab/-/commit/db42f1734a95455917dfd12535bfa22965353c6f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175336))
- [Only truncate/scroll to anchor on mount of work item description](https://gitlab.com/gitlab-org/gitlab/-/commit/a5ee9f98b1a146f215bef30abbf5d253791c4152) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175322))
- [Add pagination to group applications](https://gitlab.com/gitlab-org/gitlab/-/commit/063b450e2315f817c6773f98a51aa84281a3e162) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174464))
- [Fix empty branch name exception for branch delete](https://gitlab.com/gitlab-org/gitlab/-/commit/418b08f07135af4b0e121308ee563c4eae504a8f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175294))
- [Set engine for OpenSearch indices](https://gitlab.com/gitlab-org/gitlab/-/commit/f0dfb650059c6c76498376bd9ee5567ce8e3ff50) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175261)) **GitLab Enterprise Edition**
- [Deprecate :labels negatable filter value](https://gitlab.com/gitlab-org/gitlab/-/commit/a2cedccbc13b8523293267e93b81c0725dbb1009) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175166))
- [Fix note creation error for SHA256 repositories](https://gitlab.com/gitlab-org/gitlab/-/commit/869627307ea51b7ef09c930881c7a48528bd9124) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174154))
- [Improve checking on status of SAST jobs](https://gitlab.com/gitlab-org/gitlab/-/commit/e6c52452dab4f197600827cbc9ff1cf4e142dbe7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173027))
- [Set request_path when rendering repository blobs](https://gitlab.com/gitlab-org/gitlab/-/commit/d59d3e234ec4532e0d58d54fb3c279b2ec2cd9fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175185))
- [Remove redacting inaccessible wiki link slugs](https://gitlab.com/gitlab-org/gitlab/-/commit/90c973dc010a7202db03d24eee0ce66732a0997e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175180))
- [Make discussions API work with quick actions-only notes](https://gitlab.com/gitlab-org/gitlab/-/commit/69e3ac9592d5c655806a292266504f6fec484973) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174935))
- [Update doorkeeper to v5.8.1](https://gitlab.com/gitlab-org/gitlab/-/commit/1eea01929a9f382485e363892ac24d59fb359861) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175127))
- [Fix date re-calculation when moving children](https://gitlab.com/gitlab-org/gitlab/-/commit/b48ed43ee786f3d77c9514c2906178492c5853f5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174698))
- [Changed A tag to pajamas button](https://gitlab.com/gitlab-org/gitlab/-/commit/1879d3d2d69df0fd894cba1fb7f2072fb4ca2d83) by @mehulsharma ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174427))
- [Fix Flux status popover with long message](https://gitlab.com/gitlab-org/gitlab/-/commit/b47a576bed610d1715905a4b6f68a600bf1b95ed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174309))
- [Add additional checks for diff tabs](https://gitlab.com/gitlab-org/gitlab/-/commit/6f6d39ca707a39df474c50469df5d80e6267f973) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174972))
- [Fix font weight when selecting status](https://gitlab.com/gitlab-org/gitlab/-/commit/9f76d58c4af13caa7d942995306b8f8faa586b48) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175058)) **GitLab Enterprise Edition**
- [Style fixes for on call schedules page](https://gitlab.com/gitlab-org/gitlab/-/commit/a94bdca0f4d1a0892a1c07788c41f85fc719f1b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175022)) **GitLab Enterprise Edition**
- [Remove FF update_approval_rules_for_related_mrs](https://gitlab.com/gitlab-org/gitlab/-/commit/c3faca64fa75d4a0697754781e4008876eefa373) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175009))
- [Fix scrolling in markdown/RTE](https://gitlab.com/gitlab-org/gitlab/-/commit/925226171d2c24bba4bad818f97c37e600926a7b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175002))
- [Adjust styles of Value stream filters row](https://gitlab.com/gitlab-org/gitlab/-/commit/cf7f7bc34f334a71956681db2a936a12b54a8451) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174991))
- [Adjust styling of Merge request analytics filters bar](https://gitlab.com/gitlab-org/gitlab/-/commit/df95760a73d0d7bd78d87fdd55eabb76268098b6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174986))
- [Fix reference to inline code bug](https://gitlab.com/gitlab-org/gitlab/-/commit/2fe980ef0cf8c201f8ce62f0c1209ac278939e15) by @mehulsharma ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174837))
- [Emails on Push: fix wrong number of changed files](https://gitlab.com/gitlab-org/gitlab/-/commit/fee9b9be6d4fed0458b0e7a7b8179fbd4930fea6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172089))
- [Only add matching roles for codeowner role approvers](https://gitlab.com/gitlab-org/gitlab/-/commit/4c922d50a705bbd3fbef3a167a8ed5c2f430ead3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174681)) **GitLab Enterprise Edition**
- [Disable read_dependency and read_licenses policies for Planner role](https://gitlab.com/gitlab-org/gitlab/-/commit/414d277f5e7d918d8d6f68c03c34d825d9681d45) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174838)) **GitLab Enterprise Edition**
- [Fix GlCard rendering in dark mode for empty repository message](https://gitlab.com/gitlab-org/gitlab/-/commit/6595c01bb1a8eb60aca0e61d8a8c8132a2fa6bd7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174927))
- [Re-order concurrency limit and deduplication middleware](https://gitlab.com/gitlab-org/gitlab/-/commit/3cb454fd744a04502011be8e3a0ff83e76ce45d7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174929))
- [Make control expression nullable](https://gitlab.com/gitlab-org/gitlab/-/commit/fa968028f4a96193234ece0b7c3e368940990af6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174859)) **GitLab Enterprise Edition**
- [Update styles of Error tracking list page](https://gitlab.com/gitlab-org/gitlab/-/commit/a30b6fab9f714e6b2816bd5505af5e2f2933f1c9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174916))
- [Mention ClickHouse requirement in GraphQL queries](https://gitlab.com/gitlab-org/gitlab/-/commit/7b455c62ec0c5704b254e7439f830f2158fd5b4d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174375)) **GitLab Enterprise Edition**
- [Set defaults format to csv](https://gitlab.com/gitlab-org/gitlab/-/commit/3952f89b17c2c8e8970e28e32e0967262e644d22) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174893))
- [Handle other errors from TomlRB library](https://gitlab.com/gitlab-org/gitlab/-/commit/63b2f80ec60fc1c5722af85ceea96c2a5793861d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174653))
- [Allow approvals widget content to wrap](https://gitlab.com/gitlab-org/gitlab/-/commit/f66ce9d7e2ca34eb9f2c13aeb09c5b66f12659d1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174876))
- [Fix wording on vulnerability state transitions](https://gitlab.com/gitlab-org/gitlab/-/commit/ff91651f8153d48e9f603f8a5f7c08b0e0ba7687) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174736)) **GitLab Enterprise Edition**
- [Backfill ci_cd_settings when updating project](https://gitlab.com/gitlab-org/gitlab/-/commit/83628d9241f18ecc26ca3835ef5aa36020fbfa2d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174841))
- [Move nuget symbol files creation outside uploading package transaction](https://gitlab.com/gitlab-org/gitlab/-/commit/01658378a654cbc59a0a6b5ffa73deff6ef2450d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174829))
- [Ensure project deletion with external pipeline works](https://gitlab.com/gitlab-org/gitlab/-/commit/b440048b56e815c0b3220eee29c045954e03b950) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174023))
- [Use `:not(.gl-button)` selector to avoid overriding GlButton usage](https://gitlab.com/gitlab-org/gitlab/-/commit/6476aba4b04331a2c54c088a16722fa3ba3f402d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174785))
- [Remove box-shadow from old dropdowns on hover](https://gitlab.com/gitlab-org/gitlab/-/commit/9c24418973a1819f13c4e862c88923a5eded31d6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174733))
- [Pre-load the TanukiEmoji index](https://gitlab.com/gitlab-org/gitlab/-/commit/e511424b16ae0e80cd5e1fe1e18f5e5f21950e9f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174729))
- [Add a namespace to the csv_download_path](https://gitlab.com/gitlab-org/gitlab/-/commit/7d0a3bffdf4bfc635e71acc36f220aed2b47eb22) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174656))
- [Fix dropdown variant for AI actions](https://gitlab.com/gitlab-org/gitlab/-/commit/f81dfdfc2b9978f2a41c3e0f8feafee868bd91d0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174696)) **GitLab Enterprise Edition**
- [Re-add Tier/Offering details to bulk edit issues documentation](https://gitlab.com/gitlab-org/gitlab/-/commit/c9c3ee093d8381d046ea683a9f4a4b48c8731e12) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174710))
- [Add budget into Auto Resolve process](https://gitlab.com/gitlab-org/gitlab/-/commit/d814866f564b0b996dcaaf5f3655b5c4090a7818) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174679)) **GitLab Enterprise Edition**
- [Backfill nil started_at values](https://gitlab.com/gitlab-org/gitlab/-/commit/6fc8954c60a9709e5502af19d257a9fafee3835e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174626))
- [Fix vertical alignment of MR approvals summary](https://gitlab.com/gitlab-org/gitlab/-/commit/ae0e87009353f274b3604d1ec210bcae383984c5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174704))
- [Reset unconfirmed_email if it exists on /users/identity_verification/verify_email_code](https://gitlab.com/gitlab-org/gitlab/-/commit/b39f0b7f10a578708e00f8236fec097bd6cab667) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173468)) **GitLab Enterprise Edition**
- [Avoid creating approval rules from policies for unprotected branches](https://gitlab.com/gitlab-org/gitlab/-/commit/265ff008c7e016d693df24d6dbe03708aac4be66) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173345)) **GitLab Enterprise Edition**
- [Fix alignment of wiki pages buttons](https://gitlab.com/gitlab-org/gitlab/-/commit/3bbaf9fcb5e4c5bb6457cf9280605d8c0407ff54) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174601))
- [Fix page header button alignment](https://gitlab.com/gitlab-org/gitlab/-/commit/ea44033c54bd714fa0855ea35d486ecc1c53487a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174423))
- [Fix incorrect conflict warnings on issuable update](https://gitlab.com/gitlab-org/gitlab/-/commit/857ffd23fdf2a9d64d7138f0933eff994bf750fa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174190))
- [Fix Psych::DisallowedClass in WebHookLog](https://gitlab.com/gitlab-org/gitlab/-/commit/c23ab1192b67cc2dd1d7c9d6dab03dc5d9982c9d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173064))
- [Fix integration test settings](https://gitlab.com/gitlab-org/gitlab/-/commit/2614b6b5c6b1ee25125fb9bc015df0f73b776e48) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169861))
- [Fix gap between avatar and text for board assignee in config modal](https://gitlab.com/gitlab-org/gitlab/-/commit/ad2c12996f598f028fc0de06d399cf8732da8850) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174449)) **GitLab Enterprise Edition**
- [Fix spacing of boad configuration modal buttons at small size](https://gitlab.com/gitlab-org/gitlab/-/commit/9902d3eff80ada25ce23cbfce7bbd19eadcdbc06) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174451))
- [Continue to show roadmap filters bar when no results to access settings](https://gitlab.com/gitlab-org/gitlab/-/commit/5951e7ea91b8757c43339ea601ac4816a81b5c83) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173597)) **GitLab Enterprise Edition**
- [Revert removing default value from oauth tables](https://gitlab.com/gitlab-org/gitlab/-/commit/17f12fa724658b14207327446b92a361d66af6b1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174366))
- [Allow plus icons in project nav to inherit color](https://gitlab.com/gitlab-org/gitlab/-/commit/853e57f9a21201b24ad3a037e66be2590e9d8abd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174407))
- [Do not warn changelog required when removing feature flag patches](https://gitlab.com/gitlab-org/gitlab/-/commit/acda77c4f8583f6c8122c8c295e4dd825031e12e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173992))
- [Ensure access_level is present before comparison](https://gitlab.com/gitlab-org/gitlab/-/commit/0d29e52a16167c64895575ae60ac01ba80fcbcf0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174354))
- [Fix undefined method error 'assigned_to_duo_enterprise?'](https://gitlab.com/gitlab-org/gitlab/-/commit/a6b0defdd6783c1241b5d10e94a7f0531ae7f054) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174345)) **GitLab Enterprise Edition**
- [Fix accessibility violation for vue_shared/settings-block](https://gitlab.com/gitlab-org/gitlab/-/commit/bda71e932fc588b686ef66c68c73f97262a47c66) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174321))
- [Support quick actions in commits and discussions API](https://gitlab.com/gitlab-org/gitlab/-/commit/05729f5de1d04de3c3fb9673b27a6f46e0705b3c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173055))
- [Avoid reporting error in Sentry for known failures](https://gitlab.com/gitlab-org/gitlab/-/commit/d16df90a9c50fb7e36ffb4957ea3cf45252c4c89) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174290))
- [Add optional chaining to avoid `null` error](https://gitlab.com/gitlab-org/gitlab/-/commit/511891bb1dd552391f724cc031d721b25b18a02b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173207))
- [Fix is_blocked_by for epic work item](https://gitlab.com/gitlab-org/gitlab/-/commit/b7402acc368b21b2d4ffbcba35a892eb70d516b1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174277)) **GitLab Enterprise Edition**
- [Fix protected tags with Deploy keys](https://gitlab.com/gitlab-org/gitlab/-/commit/2f29d1c8efdb5e96cf992d80e6289dae2f3727af) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174269))
- [Fix Dangerfile parsing non-Ruby files](https://gitlab.com/gitlab-org/gitlab/-/commit/22e9a73e1811ce5e6d34b13d8e9d0b58cb9ee6e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174179))
- [Fix epic work item rake task progressbar](https://gitlab.com/gitlab-org/gitlab/-/commit/0c9b1096d6413caa225fc2cae3145e3d9090913b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174265)) **GitLab Enterprise Edition**
- [Fix search on the environments page](https://gitlab.com/gitlab-org/gitlab/-/commit/704e3364b972bcf4ff20c0dfe4f6d9c3661883a9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174128))
- [Only show LFS misconfiguration banner when objects exist in project repo](https://gitlab.com/gitlab-org/gitlab/-/commit/12969096d3852938cabff297206b467ba3400aed) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173880))
- [Skip validations when transforming references](https://gitlab.com/gitlab-org/gitlab/-/commit/66c2e24db13ecb8edbbd32873d3ed7e3ad03322b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174201))
- [Mark repository at URL not found as missing on primary](https://gitlab.com/gitlab-org/gitlab/-/commit/3ffb9dc81250756c37f3e7f19152f098660c37dc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173059)) **GitLab Enterprise Edition**
- [Fixed z-index issue in content editor box](https://gitlab.com/gitlab-org/gitlab/-/commit/be3e679d51c65c30a60b6be9ac9d6d5969cec946) by @mehulsharma ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173971))
- [Add guard clause to Wiki#find_page when title is nil](https://gitlab.com/gitlab-org/gitlab/-/commit/36c79908d95d8fb3f09ea5ee91cfa99352e96115) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174011))
- [Rewrite the InitialIndexingEventWorker to fix the SQL timeout](https://gitlab.com/gitlab-org/gitlab/-/commit/9ecb454feb61feda927298fcaaff383dbb2fa41f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174170))
- [Fix the logic of mark_indices_as_ready](https://gitlab.com/gitlab-org/gitlab/-/commit/f7c0b9e5f92a4352ba3765759c3c5c53d51a281c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174034)) **GitLab Enterprise Edition**
- [Cache Cloud Connector keys in process memory](https://gitlab.com/gitlab-org/gitlab/-/commit/2cf843753b825c79d0f5ad6eb155c8299314eda0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174153)) **GitLab Enterprise Edition**
- [Refactor to check if user has access to experimental features](https://gitlab.com/gitlab-org/gitlab/-/commit/ecae72d30bda91e4161c97d8f0ad3b435f45e450) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173015)) **GitLab Enterprise Edition**
- [Do not create system not when linked on same EPIC](https://gitlab.com/gitlab-org/gitlab/-/commit/cb695a0f0a4d7ba0c495342214fa66ae33521af5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173397)) **GitLab Enterprise Edition**
- [Fetch projects in subgroups for DORA projects comparison chart](https://gitlab.com/gitlab-org/gitlab/-/commit/708ba43689cc615b6832e22b4e0cec064c3aa053) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174088)) **GitLab Enterprise Edition**
- [Ensure cron manager receives updated geo node](https://gitlab.com/gitlab-org/gitlab/-/commit/b168df49e354ff5d68ff91fa72f891461b790f16) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173724)) **GitLab Enterprise Edition**
- [Raise internal/suggested_reviewers query limit to 110](https://gitlab.com/gitlab-org/gitlab/-/commit/03e0371a69ad0d50c6a7af2d0c29b53f4e125237) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174032))
- [Fix code block style in RTE](https://gitlab.com/gitlab-org/gitlab/-/commit/210e2fd3708e1df9f4e4d07e3968709f589093a4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174016))
- [Release use_exclusive_lease_in_mvn_find_or_create_package FF](https://gitlab.com/gitlab-org/gitlab/-/commit/73fefd55fb9f6b5a4fb5296aa541f0c10d475224) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174007))
- [Allow pushing locked LFS files merged from upstream](https://gitlab.com/gitlab-org/gitlab/-/commit/58341e94a6b067f2225bfa76aeede7c84bbfee40) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174012))
- [Ensure .pipeline-policy-pre jobs finish before starting others](https://gitlab.com/gitlab-org/gitlab/-/commit/749f96fd3879365cdfc1b09dd46fb7ad8dd4352e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165096)) **GitLab Enterprise Edition**
- [Zoekt: Do not process failed repos](https://gitlab.com/gitlab-org/gitlab/-/commit/aa3f247637b072cb2ef56480e1bca01093b8ab7f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173895)) **GitLab Enterprise Edition**
- [Fix stages_compatible? not being restrictive enough](https://gitlab.com/gitlab-org/gitlab/-/commit/f7d5120cf71d2a2e005b59e952f118aec2653fde) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173273)) **GitLab Enterprise Edition**
- [Make sure ref_type for History control is appended only once](https://gitlab.com/gitlab-org/gitlab/-/commit/ad0d33b8368c1f74c974cb96e61a9900e96da566) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173980))
- [Fix wrong changes counter on merge request commit diffs](https://gitlab.com/gitlab-org/gitlab/-/commit/dc9d3e041fd83457f52939e23899c2d5c03df507) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173382))
- [Temporary fix for activity feed tooltip contrast](https://gitlab.com/gitlab-org/gitlab/-/commit/0b18716ac5872b9196fce14aad3bc4126c6512a1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173610))
- [Fix 403 errors when setting CI/CD variables via REST API](https://gitlab.com/gitlab-org/gitlab/-/commit/13039fa4d195efc2ac07441b55581261f5711c2c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173202))
- [Improve error message for runner creation with invalid scope](https://gitlab.com/gitlab-org/gitlab/-/commit/2e62c42ffe3b09727581800bf54ca15f485e1c2c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173862))
- [Fix model registry version table error with null author](https://gitlab.com/gitlab-org/gitlab/-/commit/c7f4b24ed82077ccc1818305b6b22a1d8adf177d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173504))
- [Fix dependency on ApplicationSetting stubs for `let_it_be`](https://gitlab.com/gitlab-org/gitlab/-/commit/18e0f0d04db50f9d055d191826165e1f4b7b771c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173636))
- [Improve MR resource prompt to avoid misunderstandings of LLM](https://gitlab.com/gitlab-org/gitlab/-/commit/baf66a2dc5b1cc8439558c7aee7a0ace1378680a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173679)) **GitLab Enterprise Edition**
- [Allow invited Owners to top-level group to manage its enterprise users](https://gitlab.com/gitlab-org/gitlab/-/commit/d0f4f00e5b57ec7221fd8f1093e8a146e8804a2b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173179)) **GitLab Enterprise Edition**
- [Ensure placeholder references are creating in Direct Transfer](https://gitlab.com/gitlab-org/gitlab/-/commit/cdcab4aff69e678708e2229d8deb86cf57eba44d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173791))
- [Revert "Merge branch 'remove-ff-lfs_misconfiguration_banner' into 'master'"](https://gitlab.com/gitlab-org/gitlab/-/commit/877040fb364b1a510e770327eaaecb75cd3fa0c8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173781))
- [Fix translated string used in comparison](https://gitlab.com/gitlab-org/gitlab/-/commit/ab6c63dda7da723ae49c15ae1cea2cba6a1fc2ba) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173749)) **GitLab Enterprise Edition**
- [Fix 500 error for /api/v4/groups?all_available=false&statistics=true API](https://gitlab.com/gitlab-org/gitlab/-/commit/7fe72d7b0af5303902827cf3ab1c3ad718ae7102) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173717))
- [Mini Pipeline Graph dropdown: Change job action button size to sm](https://gitlab.com/gitlab-org/gitlab/-/commit/42a31a470e60f008da4f9df766cb77aeac682c5c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173526))
- [Notes: Confidential or locked message see-through fix](https://gitlab.com/gitlab-org/gitlab/-/commit/5fe2592e218cfdfcad6c50cc9abd221a3e741bf5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172994))
- [Fix edit snippet button alignment](https://gitlab.com/gitlab-org/gitlab/-/commit/1ea88266c9013e7dc014756f5a1baadaec0b4f6e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173624))
- [Add a loading state for branch rule query](https://gitlab.com/gitlab-org/gitlab/-/commit/9939f9c06df9452f1a76196c2b1bcd703c77e9f6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173441))
- [Ensures margin in confidential badge](https://gitlab.com/gitlab-org/gitlab/-/commit/66405cb450aeeca292520aa16d5bf9aba1e7283c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173589))
- [Fix creating current iterations](https://gitlab.com/gitlab-org/gitlab/-/commit/f6ab2be078b7d4da34f2104e96984b0dbe860a06) by @umahasu ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173544)) **GitLab Enterprise Edition**
- [Fix code reloading problems with custom database types](https://gitlab.com/gitlab-org/gitlab/-/commit/88ca73af56e44d91097177da64d7c4f722e426fa) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173566))
- [fix: Ordering of metadata on work items Child & Linked widgets](https://gitlab.com/gitlab-org/gitlab/-/commit/3f89e641172f70d692fd3617ce8898162cdaa320) by @vedant-jain03 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173033))
- [Sync security policies when compliance framework is changed](https://gitlab.com/gitlab-org/gitlab/-/commit/43285b93300a7c082cfb2aa864c684ba5e0e562a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173259)) **GitLab Enterprise Edition**
- [Return unique project set on any framework filter](https://gitlab.com/gitlab-org/gitlab/-/commit/080f52acd3c9e5a001707d124c12c8e25dd681ad) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173019)) **GitLab Enterprise Edition**
- [Fix issue dashboard ANY/NONE assignee filters](https://gitlab.com/gitlab-org/gitlab/-/commit/1883cb4f21d1cc6e1aef8d38190c93eb709b6f02) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173549))
- [Enable nested expansion in rules:changes/exists](https://gitlab.com/gitlab-org/gitlab/-/commit/6932feff4602d92f468f985b4ee90d2e99161dce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166779))
- [Enforce both scan and pipeline execution policies with missing CI](https://gitlab.com/gitlab-org/gitlab/-/commit/01bd8637fa7106f6c14b976c0386f030da436858) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171911)) **GitLab Enterprise Edition**
- [Sort by member role when a user has the same access_level](https://gitlab.com/gitlab-org/gitlab/-/commit/e01f2163c4787252c828dd0950d419c6c19f57b3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171365))
- [Improvements for markdown editor resize behavior](https://gitlab.com/gitlab-org/gitlab/-/commit/4cec15e9014eff6aefc2b19e57242c7fef8b3066) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173465))
- [Hotix: filtering out licenses with a nil spdx_identifier](https://gitlab.com/gitlab-org/gitlab/-/commit/8727f65e95c13e757f5ceb50ce2bb134d0689c73) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173279)) **GitLab Enterprise Edition**
- [Update glql docs link](https://gitlab.com/gitlab-org/gitlab/-/commit/602b4988d5903dad271cfbc15481fd4814433425) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173336))
- [Fix behavior of copy buttons on Wiki clone modal](https://gitlab.com/gitlab-org/gitlab/-/commit/eea9ea071b74ed56896b920b98eec26ce21a5937) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173319))
- [Ensure collapsed sidebar todo button is correct color](https://gitlab.com/gitlab-org/gitlab/-/commit/5fe2230a17a63371170da0942031f0d26a8f2eb3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172105))
- [Only show "can only add issues" warning when issuableType is issue](https://gitlab.com/gitlab-org/gitlab/-/commit/ae92e1d7d0a98e8730c40a39d688952d639ef927) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173297))
- [Remove description text limit on security_policies](https://gitlab.com/gitlab-org/gitlab/-/commit/76456765571b2447c83fbcfcb7351eb92cc50d6e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172933))
- [Fix wrong MR reference in draft notes](https://gitlab.com/gitlab-org/gitlab/-/commit/b9a0ac495998c817f8292f3962e01b71791fa81d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173266))
- [Fix ElasticIndexingControlWorker exception](https://gitlab.com/gitlab-org/gitlab/-/commit/f14d9c9ef77bff