# frozen_string_literal: true

module Types
  module Packages
    module Protection
      class RulePackageTypeEnum < BaseEnum
        graphql_name 'PackagesProtectionRulePackageType'
        description 'Package type of a package protection rule resource'

        value 'CONAN',
          value: 'conan',
          description: 'Packages of the Conan format.'

        value 'MAVEN',
          value: 'maven',
          description: 'Packages of the Maven format.'

        value 'NPM',
          value: 'npm',
          description: 'Packages of the npm format.'

        value 'NUGET',
          value: 'nuget',
          experiment: { milestone: '18.0' },
          description: 'Packages of the NuGet format. ' \
            'Available only when feature flag `packages_protected_packages_nuget` is enabled.'

        value 'PYPI',
          value: 'pypi',
          description: 'Packages of the PyPI format.'
      end
    end
  end
end
