---
stage: Systems
group: Distribution
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: Configuration settings.
title: Configure GitLab
---

{{< details >}}

- Tier: Free, Premium, Ultimate
- Offering: GitLab Self-Managed

{{< /details >}}

Customize and configure GitLab Self-Managed.

- [Authentication](auth/_index.md)
- [CI/CD](cicd/_index.md)
- [Configuration](admin_area.md)
- [Consul](consul.md)
- [Environment variables](environment_variables.md)
- [File hooks](file_hooks.md)
- [Git protocol v2](git_protocol.md)
- [Incoming email](incoming_email.md)
- [Instance limits](instance_limits.md)
- [Instance Review](instance_review.md)
- [PostgreSQL](postgresql/_index.md)
- [Load balancer](load_balancer.md)
- [NFS](nfs.md)
- [Postfix](reply_by_email_postfix_setup.md)
- [Redis](redis/_index.md)
- [Sidekiq](sidekiq/_index.md)
- [S/MIME signing](smime_signing_email.md)
- [Repository storage](repository_storage_paths.md)
- [Object storage](object_storage.md)
- [Merge request diffs storage](merge_request_diffs.md)
- [Static objects external storage](static_objects_external_storage.md)
- [Geo](geo/_index.md)
- [Disaster recovery (Geo)](geo/disaster_recovery/_index.md)
- [Agent server for Kubernetes](clusters/kas.md)
- [Server hooks](server_hooks.md)
- [Terraform state](terraform_state.md)
- [Terraform limits](settings/terraform_limits.md)
- [Packages](packages/_index.md)
- [Web terminals](integration/terminal.md)
- [Wikis](wikis/_index.md)
- [Invalidate Markdown cache](invalidate_markdown_cache.md)
- [Issue closing pattern](issue_closing_pattern.md)
- [Snippets](snippets/_index.md)
- [Host the product documentation](docs_self_host.md)
- [Custom HTML header tags](custom_html_header_tags.md)
- [GitLab Duo Self-Hosted](gitlab_duo_self_hosted/_index.md)
