---
stage: none
group: unassigned
info: For assistance with this What's new page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments-to-other-projects-and-subjects.
title: What's new
---

{{< details >}}

- Tier: Free, Premium, Ultimate
- Offering: GitLab.com, GitLab Self-Managed, GitLab Dedicated

{{< /details >}}

You can view some of the highlights from the last 10
GitLab versions in the **What's new** feature. It lists new features available in different
[GitLab tiers](https://about.gitlab.com/pricing/).

All users can see the feature list, but the entries might differ depending on the subscription type:

- Features only available on GitLab.com are not shown on GitLab Self-Managed instances.
- Features only available to GitLab Self-Managed instances are not shown on GitLab.com.

{{< alert type="note" >}}

For GitLab Self-Managed, the updated **What's new** is included
in the first patch release after a new version, such as `13.10.1`.

{{< /alert >}}

## Access What's new

To access the **What's new** feature:

1. On the left sidebar, at the bottom, select **Help** ({{< icon name="question" >}}).
1. Select **What's new** from the menu.

## Configure What's new

You can configure **What's new** to display features based on the tier,
or you can hide it. To configure it:

1. On the left sidebar, at the bottom, select **Admin**.
1. Select **Settings > Preferences**.
1. Expand **What's new**, and choose one of the following options:

   | Option | Description |
   | ------ | ----------- |
   | Enable What's new: All tiers | Presents new features from all tiers. |
   | Enable What's new: Current tier only | Presents new features for your current subscription tier, and hides new features outside of your tier. |
   | Disable What's new | Disables this feature, so it no longer displays under the {{< icon name="question" >}} icon. |

1. Select **Save changes**.
