---
stage: Foundations
group: Import and Integrate
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: Extend with GitLab
---

Connect GitLab to your tools and workflows to build a customized development environment.
Integrate directly with your existing systems, set up automated responses to events,
and build custom applications on top of GitLab.
Whether you want to automate processes or build integrations, these extensibility
features give you control over your development processes.

| | | |
|--|--|--|
| [**Integrate with GitLab**](../integration/_index.md)<br>Projects, issues, authentication, security providers. | [**Webhooks**](../user/project/integrations/webhooks.md)<br>Custom HTTP callbacks, used to send events. | [**REST API**](rest/_index.md)<br>Programmatic interaction with GitLab. |
| [**GraphQL API**](graphql/_index.md)<br>Programmatic interaction with GitLab. | [**OAuth 2.0 identity provider API**](oauth2.md)<br>Third-party authorization to GitLab. | [**Editor and IDE extensions**](../editor_extensions/_index.md)<br>Visual Studio Code, JetBrains, Neovim, GitLab CLI. |
