---
stage: none
group: unassigned
info: Any user with at least the Maintainer role can merge updates to this content. For details, see https://docs.gitlab.com/ee/development/development_processes.html#development-guidelines-review.
title: How GitLab Merge Request Coaches can help you
---

Welcome, GitLab contributor! As you work on your contributions, Merge Request (MR) Coaches are here to help you succeed. This guide explains how we can support you throughout your contribution journey.

## What is a Merge Request Coach?

MR Coaches are GitLab team members with a special interest in helping community contributors like you get their changes merged into GitLab. Think of us as your guides and advocates in the contribution process.

## How we can help you

### Getting started

- We can help you understand GitLab contribution requirements
- We can provide hints and guidance if you're new to Ruby, JavaScript, Go, or programming

### During development

- We can review your merge requests and provide constructive feedback
- We can help you understand and resolve CI pipeline issues

### Code review process

- We can help find the right reviewers for your contribution
- We can help you understand and address code review feedback
- We can provide technical guidance on implementing requested changes

## If you're stuck

Don't hesitate to ask for help if:

- You're unsure how to implement something
- The CI pipeline is failing
- You don't understand review feedback
- You need help with Git or the development process

## Where to find us

You can reach MR Coaches by commenting `@gitlab-bot help` on your merge request or issue.

## What we look for in contributions

To help your MR succeed, we check for:

- Adherence to GitLab [contribution acceptance criteria](merge_request_workflow.md#contribution-acceptance-criteria)
- Test coverage
- Documentation updates when needed

## Tips for working with MR Coaches

1. **Be Responsive**: Even a quick update helps us help you
1. **Ask Questions Early**: We'd rather help prevent issues than fix them later
1. **Share Your Constraints**: Let us know if you have limited time or specific challenges
1. **Be Open to Feedback**: We aim to help your code meet GitLab quality standards

Remember: No question is "stupid". We're here to help you succeed. Your contributions make GitLab better, and we appreciate your efforts to improve the product and grow your skills.
