---
stage: Solutions Architecture
group: Solutions Architecture
info: This page is owned by the Solutions Architecture team.
title: Solution Components
---

This documentation section covers a variety of Solution components developed and provided by GitLab.
To download and run these solution components, request your account team for invitation code.

The use of any Solution component is subject to the [GitLab Subscription Agreement](https://handbook.gitlab.com/handbook/legal/subscription-agreement/) (the "Agreement") and constitutes Free Software as defined within the Agreement.

## DevSecOps Workflow

GitLab Solution to provide end to end DevSecOps workflow.

[Mobile Apps](workflow_mobileapps.md)

## Integrated DevSecOps

GitLab Solution to provide an integrated end to end DevSecOps workflow.

[Secure Software Development Workflow Workflow: Snyk SAST](integrated_snyk.md)

[Change Control Workflow: ServiceNow](integrated_servicenow.md)

## By Use Cases

GitLab Solution Packages to provide rules and policies to enforce standards and application security tests

[Secret Detection](secret_detection.md)

[OSS License Check](oss_license_check.md)

## Metrics and KPIs

GitLab Metrics and KPI Dashboard and Solution

[Security Metrics and KPIs Dashboard](securitykpi.md)

## GenAI and Data Science

[Agentic Workflow: Apply Coding Style Guide](duo_workflow/duo_workflow_codestyle.md)
