---
stage: none
group: unassigned
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: Users, groups, namespaces, SSH keys.
title: Manage your organization
---

Configure your organization and its users. Determine user roles
and give everyone access to the projects they need.

| | | |
|--|--|--|
| [**Tutorial: Set up your organization**](../tutorials/manage_user/_index.md)<br>Setup, configuration, onboarding, organization structure. | [**Namespaces**](../user/namespace/_index.md)<br>Organization, hierarchy, project grouping. | [**Members**](../user/project/members/_index.md)<br>User management, roles, permissions, access levels. |
| [**Organization** (in development)](../user/organization/_index.md)<br>Namespace hierarchy. | [**Groups**](../user/group/_index.md)<br>Project management, access control, client groups, team groups. | [**Sharing projects and groups**](../user/project/members/sharing_projects_groups.md)<br>Invitations, group inheritance, project visibility. |
| [**Compliance**](../administration/compliance/compliance_features.md)<br>Compliance center, audit events, security policies, compliance frameworks. | [**Enterprise users**](../user/enterprise_user/_index.md)<br>Domain verification, two-factor authentication, enterprise user management, SAML response. | [**Service accounts**](../user/profile/service_accounts.md)<br>Machine user, rate limits, personal access tokens. |
| [**User account options**](../user/profile/_index.md)<br>Profile settings, preferences, authentication, notifications. | [**SSH keys**](../user/ssh.md)<br>Authentication, permissions, key types, ownership. | [**GitLab.com settings**](../user/gitlab_com/_index.md)<br>Instance configurations. |
