---
stage: none
group: Tutorials
info: For assistance with this tutorials page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments-to-other-projects-and-subjects.
description: Introduction to the product.
title: 'Tutorials: Find your way around GitLab'
---

Get to know the features of GitLab and where to find them so you can get up
and running quickly.

| Topic | Description | Good for beginners |
|-------|-------------|--------------------|
| [GitLab with Git Essentials](https://university.gitlab.com/courses/gitlab-with-git-essentials-s2)  |  Learn the basics of Git and GitLab in this self-paced course. | {{< icon name="star" >}} |
| <i class="fa fa-youtube-play youtube" aria-hidden="true"></i> [Use GitLab for DevOps](https://www.youtube.com/watch?v=7q9Y1Cv-ib0) (12m 34s) | Use GitLab through the entire DevOps lifecycle, from planning to monitoring. | {{< icon name="star" >}} |
| [Use the left sidebar to navigate GitLab](left_sidebar/_index.md) |  Start navigating the GitLab UI. | {{< icon name="star" >}} |
| [Use Markdown at GitLab](../user/markdown.md) |  GitLab Flavored Markdown (GLFM) is used in many areas of GitLab, for example, in merge requests. | {{< icon name="star" >}} |
| <i class="fa fa-youtube-play youtube" aria-hidden="true"></i> [GitLab Continuous Delivery overview](https://www.youtube.com/watch?v=M7rBDZYsx8U&list=PLFGfElNsQthYDx0A_FaNNfUm9NHsK6zED&index=193) (17m 2s) | Learn how to use GitLab features to continuously build, test, and deploy iterative code changes. | |
| [Productivity tips](https://about.gitlab.com/blog/2021/02/18/improve-your-gitlab-productivity-with-these-10-tips/) | Get tips to help make you a productive GitLab user. | |
| <i class="fa fa-youtube-play youtube" aria-hidden="true"></i> [Introducing GitLab Service Desk](https://www.youtube.com/watch?v=LDVQXv3I5rI) (6m 50s) | Learn how GitLab [Service Desk](../user/project/service_desk/_index.md) provides an integrated help desk solution to enhance customer support workflows. This video covers key features, such as [custom email addresses](../user/project/service_desk/configure.md#custom-email-address) and [email templates](../user/project/service_desk/configure.md#customize-emails-sent-to-external-participants), ticket management, [comment templates](../user/profile/comment_templates.md), [CRM integration](../user/crm/_index.md), automation using `gitlab-triage` in scheduled CI/CD pipelines, and analytics and [insights](../user/project/insights/_index.md). | |
