---
stage: Security Risk Management
group: Security Insights
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: Vulnerability report
---

{{< details >}}

- Tier: Ultimate
- Offering: GitLab.com, GitLab Self-Managed, GitLab Dedicated

{{< /details >}}

{{< history >}}

- Vulnerability Resolution activity icon [introduced](https://gitlab.com/groups/gitlab-org/-/epics/15036) in GitLab 17.5 with a flag named [`vulnerability_report_vr_badge`](https://gitlab.com/gitlab-org/gitlab/-/issues/486549). Disabled by default.
- [Enabled by default](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171718) in GitLab 17.6.
- [Generally available](https://gitlab.com/gitlab-org/gitlab/-/issues/503568) in GitLab 18.0. Feature flag `vulnerability_report_vr_badge` removed.

{{< /history >}}

{{< alert type="flag" >}}

The availability of Vulnerability Resolution activity icon is controlled by a feature flag.
For more information, see the history.

{{< /alert >}}

The vulnerability report provides a consolidated view of security vulnerabilities found in your
codebase. Sort vulnerabilities by severity, report type, scanner (for projects only), and other
attributes to determine which issues need attention first. Track vulnerabilities through their
lifecycle with status indicators and activity icons that show remediation progress.

Access detailed information for each vulnerability, including Common Vulnerability Scoring System
(CVSS) scores and file locations when available. Filter and group similar vulnerabilities to address
them systematically.

{{< alert type="note" >}}

On GitLab.com, vulnerabilities are archived one year after they were last updated. For more details
see [vulnerability archival](../vulnerability_archival/_index.md).

{{< /alert >}}

<i class="fa fa-youtube-play youtube" aria-hidden="true"></i>
For an overview, see [Vulnerability Management](https://www.youtube.com/watch?v=alMRIq5UPbw).

## Contents of the vulnerability report

The report contains data from the default branch, showing cumulative results from all successful security scan jobs.
Scan results appear after job completion or when a pipeline is blocked by manual jobs.

For projects and groups, the vulnerability report contains:

- Totals of vulnerabilities per severity level.
- Filters for common vulnerability attributes.
- Details of each vulnerability, presented in a table.

For some vulnerabilities, the details include a link to the relevant file and line number in the
default branch. For CVE vulnerabilities, you can also view the KEV status, CVSS and EPSS scores,
and reachability information (Beta) in the vulnerability report. For more details on the security
scores, see [vulnerability risk assessment data](../vulnerabilities/risk_assessment_data.md).

For projects, the vulnerability report also contains:

- A time stamp shows when the default branch was last updated, including a link to the latest pipeline. Pipelines that run against non-default branches do not update the time stamp.
- The number of failures that occurred in the most recent pipeline. Select the failure
  notification to view the **Failed jobs** tab of the pipeline's page.

The **Activity** column contains icons to indicate the activity, if any, taken on the vulnerability
in that row:

- Issues {{< icon name="issues" >}}: Links to issues created for the vulnerability. For more information, see
  [Create a GitLab issue for a vulnerability](../vulnerabilities/_index.md#create-a-gitlab-issue-for-a-vulnerability).
- Merge requests {{< icon name="merge-request" >}}: Links to merge requests created for the vulnerability. For more information, see
  [Resolve a vulnerability with a merge request](../vulnerabilities/_index.md#resolve-a-vulnerability-with-a-merge-request).
- Checked circle {{< icon name="check-circle-dashed" >}}: The vulnerability has been remediated.
- False positive {{< icon name="false-positive" >}}: The scanner determined this vulnerability to be a false
  positive.
- Solution {{< icon name="bulb" >}}: Indicates that the vulnerability has a solution available.
- Vulnerability Resolution {{< icon name="tanuki-ai" >}}: Indicates that the vulnerability has an available AI resolution.

To open an issue created for a vulnerability, hover over the **Activity** entry, then select the link.
The issue icon ({{< icon name="issues" >}}) indicates the issue's status. If [Jira issue support](../../../integration/jira/configure.md) is enabled, the
issue link found in the **Activity** entry links out to the issue in Jira. Unlike GitLab issues, the
status of a Jira issue is not shown in the GitLab UI.

![Example project vulnerability report](img/vulnerability_report_v17_0.png)

When vulnerabilities originate from a multi-project pipeline setup,
this page displays the vulnerabilities that originate from the selected project.

## View the vulnerability report

View the vulnerability report to list all vulnerabilities in the project or group.

Prerequisites:

- You must have at least the Developer role for the project or group.

To view the vulnerability report:

1. On the left sidebar, select **Search or go to** and find your project or group.
1. Select **Secure > Vulnerability report**.

## Filtering vulnerabilities

{{< history >}}

- [Introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/452492) the **Identifier** filter in GitLab 17.7 [with a flag](../../../administration/feature_flags.md) named `vulnerability_filtering_by_identifier`. Enabled by default.
- [Generally available](https://gitlab.com/gitlab-org/gitlab/-/issues/502930) in GitLab 17.9. Feature flag `vulnerability_filtering_by_identifier` removed.

{{< /history >}}

You can filter vulnerabilities in the vulnerability report to more efficiently triage them.

You can filter by:

<!-- vale gitlab_base.SubstitutionWarning = NO -->

- **Status**: Needs triage, confirmed, dismissed, and resolved. For details on what
  each status means, see
  [vulnerability status values](../vulnerabilities/_index.md#vulnerability-status-values).
  Dismissed vulnerabilities can be filtered together or individually by the reason they were
  dismissed.
- **Severity**: Critical, high, medium, low, info, unknown.
- **Report Type**: For more details, see [Report Type filter](#report-type-filter)
- **Scanner**: For more details, see [Scanner filter](#scanner-filter)
- **Activity**: For more details, see [Activity filter](#activity-filter).
- **Identifier**: Filter by the vulnerability's identifier (available only for projects, support for groups is proposed in [issue 508713](https://gitlab.com/gitlab-org/gitlab/-/issues/508713)).
- **Project**: Filter vulnerabilities in specific projects (available only for groups).

<!-- vale gitlab_base.SubstitutionWarning = YES -->

### Filter vulnerabilities

{{< history >}}

- Improved filtering [introduced](https://gitlab.com/groups/gitlab-org/-/epics/13339) in GitLab 16.9 [with a flag](../../../administration/feature_flags.md) named `vulnerability_report_advanced_filtering`. Disabled by default.
- [Enabled on GitLab.com, GitLab Self-Managed, and GitLab Dedicated](https://gitlab.com/gitlab-org/gitlab/-/issues/437128) in GitLab 17.1.
- [Generally available in 17.2](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157172). Feature flag `vulnerability_report_advanced_filtering` removed.

{{< /history >}}

Filter the vulnerability report to focus on a subset of vulnerabilities.

To filter the list of vulnerabilities:

1. On the left sidebar, select **Search or go to** and find your project.
1. Select **Secure > Vulnerability report**.
1. Optional. To remove the default filters, select **Clear** ({{< icon name="clear" >}}).
1. Above the list of vulnerabilities, select the filter bar.
1. In the dropdown list that appears, select an attribute you want to filter by, then select the
   values from the dropdown list.
1. Select outside the filter field. The vulnerability severity totals and list of matching
   vulnerabilities are updated.
1. To filter by multiple attributes, repeat the three previous steps. Multiple attributes are joined
   by a logical AND.

### Report type filter

You can filter vulnerabilities based on the type of report that detected them. By default, the vulnerability report
lists vulnerabilities from all report types.

Use the **Manually added** attribute to filter vulnerabilities that were added manually.

### Scanner filter

For projects, you can filter vulnerabilities based on the scanner that detected them. By default, the vulnerability report
lists vulnerabilities from all scanners. For details of each of the available scanners, see
[Security scanning tools](../detect/_index.md).

### Project filter

The content of the Project filter varies:

- **Security Center**: Only projects you've [added to your personal Security Center](../security_dashboard/_index.md#adding-projects-to-the-security-center).
- **Group**: All projects in the group.
- **Project**: Not applicable.

### Activity filter

{{< history >}}

- Introduced in GitLab 16.7 [with a flag](../../../administration/feature_flags.md) named `activity_filter_has_remediations`. Disabled by default.
- [Generally available](https://gitlab.com/gitlab-org/gitlab/-/issues/429262) in GitLab 16.9. Feature flag `activity_filter_has_remediations` removed.
- Activity filter option **GitLab Duo (AI)** [introduced](https://gitlab.com/groups/gitlab-org/-/epics/15036) in GitLab 17.5 with a flag named [`vulnerability_report_vr_filter`](https://gitlab.com/gitlab-org/gitlab/-/issues/486534). Disabled by default.
- [Enabled by default](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171718) in GitLab 17.6.
- [Generally Available](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172372) in GitLab 18.0. The `vulnerability_report_vr_filter` flag removed.

{{< /history >}}

{{< alert type="flag" >}}

The availability of the activity filter option **GitLab Duo (AI)** is controlled by a feature flag.
For more information, see the history.

{{< /alert >}}

The activity filter behaves differently from the other filters. You can select only one value in
each category. To remove a filter, from the activity filter dropdown list select the filter you want to remove.

Selection behavior when using the activity filter:

- **Activity**
  - **All activity**: Vulnerabilities with any activity status (same as ignoring this filter). Selecting this deselects all other activity filter options.
- **Detection**
  - **Still detected** (default): Vulnerabilities that are still detected in the latest pipeline scan of the `default` branch.
  - **No longer detected**: Vulnerabilities that are no longer detected in the latest pipeline scan of the `default` branch.
- **Issue**
  - **Has issues**: Vulnerabilities with one or more associated issues.
  - **Does not have issue**: Vulnerabilities without an associated issue.
- **Merge request**
  - **Has merge request**: Vulnerabilities with one or more associated merge requests.
  - **Does not have merge request**: Vulnerabilities without an associated merge request.
- **Solution available**
  - **Has a solution**: Vulnerabilities with an available solution.
  - **Does not have a solution**: Vulnerabilities without an available solution.
- **GitLab Duo (AI)**:
  - **Vulnerability Resolution available**: Vulnerabilities with an available AI resolution.
  - **Vulnerability Resolution unavailable**: Vulnerabilities without an available AI resolution.

The **GitLab Duo (AI)** filter is available when:

- Security Center vulnerability report: Any project in the [Security Center](../security_dashboard/_index.md#adding-projects-to-the-security-center) has its **GitLab Duo** toggle turned on.
- Group vulnerability report: For the group, **GitLab Duo features** is set to **On by default**.
- Project vulnerability report: For the project, the **GitLab Duo** toggle is turned on.

## Grouping vulnerabilities

{{< history >}}

- Grouping of vulnerabilities per project [introduced](https://gitlab.com/groups/gitlab-org/-/epics/10164) in GitLab 16.4 [with a flag](../../../administration/feature_flags.md) named `vulnerability_report_grouping`. Disabled by default.
- Grouping of vulnerabilities per project [enabled on GitLab Self-Managed and GitLab Dedicated](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/134073) in GitLab 16.5.
- Grouping of vulnerabilities per project [generally available](https://gitlab.com/gitlab-org/gitlab/-/issues/422509) in GitLab 16.6. Feature flag `vulnerability_report_grouping` removed.
- Grouping of vulnerabilities per group [introduced](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/137778) in GitLab 16.7 with a flag named [`group_level_vulnerability_report_grouping`](https://gitlab.com/gitlab-org/gitlab/-/issues/432778). Disabled by default.
- Grouping of vulnerabilities per group [enabled on GitLab Self-Managed and GitLab Dedicated](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157949) in GitLab 17.2.
- Grouping of vulnerabilities per group [generally available](https://gitlab.com/gitlab-org/gitlab/-/issues/472669) in GitLab 17.3. Feature flag `group_level_vulnerability_report_grouping` removed.
- OWASP top 10 grouping of vulnerabilities per group [introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/432618) in GitLab 16.8 [with a flag](../../../administration/feature_flags.md) named `vulnerability_owasp_top_10_group`. Disabled by default.
- OWASP top 10 grouping of vulnerabilities per group [enabled on GitLab Self-Managed and GitLab Dedicated](https://gitlab.com/gitlab-org/gitlab/-/issues/437253) in GitLab 17.4.
- OWASP top 10 grouping of vulnerabilities per group [generally available](https://gitlab.com/gitlab-org/gitlab/-/issues/437253) in GitLab 17.4. Feature flag `vulnerability_owasp_top_10_group` removed.
- Non-OWASP category in OWASP top 10 grouping [introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/442526) in GitLab 17.1 [with a flag](../../../administration/feature_flags.md) named `owasp_top_10_null_filtering`. Disabled by default.
- Non-OWASP category in OWASP top 10 grouping [enabled on GitLab Self-Managed, and GitLab Dedicated](https://gitlab.com/gitlab-org/gitlab/-/issues/463783) in GitLab 17.5.
- Non-OWASP category in OWASP top 10 grouping [generally available](https://gitlab.com/gitlab-org/gitlab/-/issues/463783) in GitLab 17.6. Feature flag `owasp_top_10_null_filtering` removed.

{{< /history >}}

You can group vulnerabilities on the vulnerability report page to more efficiently triage them.

You can group by:

- Status
- Severity
- Report Type
- Scanner
- OWASP top 10 2017

### Group vulnerabilities

To group vulnerabilities:

1. On the left sidebar, select **Search or go to** and find your project or group.
1. Select **Secure > Vulnerability report**.
1. From the **Group By** dropdown list, select a group.

Vulnerabilities are grouped according to the group you selected. Each group is collapsed, with
the total number of vulnerabilities per group displayed beside their name. To see the
vulnerabilities in each group, select the group's name.

## View details of a vulnerability

To view more details of a vulnerability, select the vulnerability's **Description**. The
[vulnerability's details](../vulnerabilities/_index.md) page is opened.

## Change status of vulnerabilities

{{< history >}}

- Providing a comment and dismissal reason [introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/408366) in GitLab 16.0.

{{< /history >}}

As you triage vulnerabilities you can change their status, including dismissing vulnerabilities.

When a vulnerability is dismissed, the audit log includes a note of who dismissed it, when it was
dismissed, and the reason it was dismissed. You cannot delete vulnerability records, so a permanent
record always remains.

Prerequisites:

- You must have at least the Maintainer role for the project. The `admin_vulnerability` permission was [removed](https://gitlab.com/gitlab-org/gitlab/-/issues/412693) from the Developer role in GitLab 17.0.

To change the status of vulnerabilities:

1. On the left sidebar, select **Search or go to** and find your project.
1. Select **Secure > Vulnerability report**.
1. To select:
   - One or more vulnerabilities, select the checkbox beside each vulnerability.
   - All vulnerabilities on the page, select the checkbox in the table header.
1. In the **Set status** dropdown list, select the desired status.
1. If the **Dismiss** status is chosen, select the desired reason in the **Set dismissal reason** dropdown list.
1. In the **Add a comment** input, you can provide a comment. For the **Dismiss** status, a comment is required.
1. Select **Change status**.

The status of the selected vulnerabilities is updated and the content of the vulnerability report is
refreshed.

![Project vulnerability report](img/project_security_dashboard_status_change_v16_0.png)

## Change or override vulnerability severity

{{< history >}}

- [Introduced](https://gitlab.com/groups/gitlab-org/-/epics/16157) in GitLab 17.9 [with a flag](../../../administration/feature_flags.md) named `vulnerability_severity_override`. Disabled by default.
- [Enabled on GitLab.com, GitLab Self-Managed, and GitLab Dedicated](https://gitlab.com/groups/gitlab-org/-/epics/16157) in GitLab 17.10.

{{< /history >}}

{{< alert type="flag" >}}

The availability of this feature is controlled by a feature flag.
For more information, see the history.

{{< /alert >}}

In certain cases, you may need to adjust the severity of a detected vulnerability to better reflect your organization's priorities. For instance, a scanner might report a lower severity, but you might consider it more critical based on your environment or setup. This feature allows you to override the default severity assigned by the scanner.

Prerequisites:

- You must have at least the Maintainer role for the project or the `admin_vulnerability` permission.

To manually override a vulnerability's severity:

1. On the left sidebar, select **Search or go to** and find your project.
1. Go to **Secure > Vulnerability report**.
1. Select vulnerabilities:
   - To select individual vulnerabilities, select the checkbox beside each vulnerability.
   - To select all vulnerabilities on the page, select the checkbox in the table header.
1. In the **Select action** dropdown list, select **Change severity**.
1. In the **Select severity** dropdown list, select the desired severity level.
1. In the **Add reason** text box, add a brief explanation of why you're changing the severity.
1. Select **Change severity**.

For each selected vulnerability:

- Its severity is updated in both the **Vulnerability details page** and the **Vulnerability report**.
- A badge is added to its severity, indicating that the severity has been overridden.
- Manual severity adjustments are recorded in the vulnerability's **history**.

![Vulnerability Severity Override](img/vulnerability_severity_change_v17_10.png)

## Add vulnerabilities to an existing issue

{{< history >}}

- [Introduced](https://gitlab.com/groups/gitlab-org/-/epics/13216) in GitLab 17.9 [with a flag](../../../administration/feature_flags.md) named `enhanced_vulnerability_bulk_actions`. Disabled by default.
- [Enabled on GitLab.com, GitLab Self-Managed, and GitLab Dedicated](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190213) in GitLab 18.0.

{{< /history >}}

{{< alert type="flag" >}}

The availability of this feature is controlled by a feature flag.
For more information, see the history.

{{< /alert >}}

You can link one or more vulnerabilities to existing issues in the vulnerability report.

Prerequisites:

- You must have at least the Maintainer role for the project or the `admin_vulnerability` permission in a custom role. The `admin_vulnerability` permission was [removed](https://gitlab.com/gitlab-org/gitlab/-/issues/412693) from the Developer role in GitLab 17.0.

To attach vulnerabilities to an existing issue:

1. On the left sidebar, select **Search or go to** and find your project or group.
1. Go to **Secure > Vulnerability report**.
1. Select vulnerabilities:
   - To select individual vulnerabilities, select the checkbox beside each vulnerability.
   - To select all vulnerabilities on the page, select the checkbox in the table header.
1. In the **Select action** dropdown list, select **Attach to existing issue**.
1. In the **Enter issue URL or <#issue ID>** text box, enter the ID of an issue to autocomplete, or add the URL of the issue. You can enter multiple issues to add the vulnerabilities to.
1. Select **Add**.

Each selected vulnerability will be linked to all of the specified issues.

![Attach vulnerabilities to an existing issue](img/vulnerability_attach_existing_issue_v18_0.png)

## Add vulnerabilities to a new issue

{{< history >}}

- [Introduced](https://gitlab.com/groups/gitlab-org/-/epics/13216) in GitLab 17.9 [with a flag](../../../administration/feature_flags.md) named `new_issue_attachment_from_vulnerability_bulk_action`. Disabled by default.
- [Enabled on GitLab.com, GitLab Self-Managed, and GitLab Dedicated](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/190213) in GitLab 18.0.

{{< /history >}}

{{< alert type="flag" >}}

The availability of this feature is controlled by a feature flag.
For more information, see the history.

{{< /alert >}}

You can link one or more vulnerabilities to a new issue.

Prerequisites:

- You must have at least the Maintainer role for the project or the `admin_vulnerability` permission in a custom role. The `admin_vulnerability` permission was [removed](https://gitlab.com/gitlab-org/gitlab/-/issues/412693) from the Developer role in GitLab 17.0.

To attach vulnerabilities to a new issue:

1. On the left sidebar, select **Search or go to** and find your project or group.
1. Go to **Secure > Vulnerability report**.
1. Select vulnerabilities:
   - To select individual vulnerabilities, select the checkbox beside each vulnerability.
   - To select all vulnerabilities on the page, select the checkbox in the table header.
1. In the **Select action** dropdown list, select **Attach to new issue**.
1. Select **Create issue**.

You will be redirected to a new issue. Each selected vulnerability is already linked to it.

![Attach vulnerabilities to a new issue](img/vulnerability_attach_new_issue_v18_0.png)

## Sort vulnerabilities by date detected

By default, vulnerabilities are sorted by severity level, with the highest-severity vulnerabilities listed at the top.

To sort vulnerabilities by the date each vulnerability was detected, select the "Detected" column header.

## Exporting

{{< history >}}

- Added "Dismissal Reason" as a column in the CSV export [introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/434076) in GitLab 16.8.

{{< /history >}}

You can export details of the vulnerabilities listed in the vulnerability report. The export format
is CSV (comma separated values). All vulnerabilities are included because filters do not
apply to the export.

Fields included are:

- Status (See the following table for details of how the status value is exported.)
- Group name
- Project name
- Report type
- Scanner name
- Vulnerability
- Basic details
- Additional information
- Severity
- [CVE](https://cve.mitre.org/) (Common Vulnerabilities and Exposures)
- [CWE](https://cwe.mitre.org/) (Common Weakness Enumeration)
- Other identifiers
- Detected At
- Location
- Activity: Returns `true` if the vulnerability is resolved on the default branch, and `false` if not.
- Comments
- Full Path
- CVSS Vectors
- [Dismissal Reason](../vulnerabilities/_index.md#vulnerability-dismissal-reasons)

{{< alert type="note" >}}

Full details are available through our
[Job Artifacts API](../../../api/job_artifacts.md#download-a-single-artifact-file-from-specific-tag-or-branch).
Use one of the `gl-*-report.json` report filenames in place of `*artifact_path`
to obtain, for example, the path of files in which vulnerabilities were detected.

{{< /alert >}}

The Status field's values shown in the vulnerability report are different to those contained
in the vulnerability export. Use the following reference table to match them.

| Vulnerability report | Vulnerability export |
|:---------------------|:---------------------|
| Needs triage         | detected             |
| Dismissed            | dismissed            |
| Resolved             | resolved             |
| Confirmed            | confirmed            |

### Export details

To export details of all vulnerabilities listed in the vulnerability report, select **Export**.

When the exported details are available, you'll receive an email. To download the exported details, select the link in the email.

{{< alert type="note" >}}

Some CSV readers have limitations on the number of rows or size of columns which
may make them incompatible with larger exports. The vulnerability export does not
account for the limitations of individual programs.

{{< /alert >}}

## Manually add a vulnerability

{{< history >}}

- [Feature flag `new_vulnerability_form`](https://gitlab.com/gitlab-org/gitlab/-/issues/359049) removed in GitLab 15.0.

{{< /history >}}

Add a vulnerability manually when it is not available in the GitLab vulnerabilities database. You
can add a vulnerability only in a project's vulnerability report.

To add a vulnerability manually:

1. On the left sidebar, select **Search or go to** and find your project.
1. Select **Secure > Vulnerability report**.
1. Select **Submit vulnerability**.
1. Complete the fields and submit the form.

The newly-created vulnerability's detail page is opened.

## Operational vulnerabilities

The **Operational vulnerabilities** tab lists vulnerabilities found by [Operational container scanning](../../clusters/agent/vulnerabilities.md).
This tab appears on the project, group, and Security Center vulnerability reports.

![Operational Vulnerability Tab](img/operational_vulnerability_tab_v14_6.png)
