---
stage: Tenant Scale
group: Organizations
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: Project visibility, search, badges, layout.
title: Organize work with projects
---

Create projects to host your codebase in GitLab.
You can also use projects to:

- Track issues
- Plan work
- Collaborate on code
- Use CI/CD tools to continuously build, test, and deploy your app

Projects can be available [publicly, internally, or privately](../public_access.md).
GitLab does not limit the number of private projects you can create.

| | | |
|--|--|--|
| [**Getting started**](../get_started/get_started_projects.md)<br>Overview of how features fit together. | [**Create a project**](_index.md)<br>New project, project templates. | [**Manage projects**](working_with_projects.md)<br>Settings, configuration, project activity, project deletion.  |
| [**Project visibility**](../public_access.md)<br>Public, private, internal. | [**Project settings**](working_with_projects.md)<br>Project features, analytics, project permissions. | [**Description templates**](description_templates.md)<br>Issue templates, merge request templates, instance and group templates. |
| [**Project access tokens**](settings/project_access_tokens.md)<br>Authentication, create, revoke, token expiration. | [**Deploy keys**](deploy_keys/_index.md)<br>Public SSH keys, repository access, bot users, read-only access.  | [**Deploy tokens**](deploy_tokens/_index.md)<br>Repository cloning, token creation, container registry. |
| [**Share projects**](members/sharing_projects_groups.md)<br>Member roles, invitations, group access. | [**Reserved project and group names**](../reserved_names.md)<br>Naming conventions, restrictions, reserved names. | [**Search**](../search/_index.md)<br>Basic, advanced, exact, search scope, commit SHA search. |
| [**Badges**](badges.md)<br>Pipeline status, group, project, custom badges. | [**Project topics**](project_topics.md)<br>Project organization, subscribe, view.  | [**Code intelligence**](code_intelligence.md)<br>Type signatures, symbol documentation, go-to definition. |
| [**Import and migrate**](import/_index.md)<br>Repository migration, third-party repositories, user contribution mapping. | [**System notes**](system_notes.md)<br>Event history, activity log, comments history. | [**Transfer a project to another namespace**](import/_index.md)<br>Namespace transfer, subscription transfer. |
| [**Use a project as a Go package**](use_project_as_go_package.md)<br>Go modules, import calls. | [**Tutorial: Build a protected workflow for your project**](../../tutorials/protected_workflow/_index.md)<br>Security, approval rules, branch protection. | [**Troubleshooting**](troubleshooting.md)<br>Problem solving, common issues, debugging, error resolution. |
