#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 generic-deriving
version:              1.14.5
visibility:           public
id:                   generic-deriving-1.14.5-BzjOO2EqgCN3e6szlgtKOc
key:                  generic-deriving-1.14.5-BzjOO2EqgCN3e6szlgtKOc
license:              BSD-3-Clause
copyright:            2011-2013 Universiteit Utrecht, University of Oxford
maintainer:           generics@haskell.org
author:               José Pedro Magalhães
stability:            experimental
homepage:             https://github.com/dreixel/generic-deriving
synopsis:             Generic programming library for generalised deriving.
description:
    This package provides functionality for generalising the deriving mechanism
    in Haskell to arbitrary classes. It was first described in the paper:

    *  /A generic deriving mechanism for Haskell/.
    Jose Pedro Magalhaes, Atze Dijkstra, Johan Jeuring, and Andres Loeh.
    Haskell'\''10.

    The current implementation integrates with the new GHC Generics. See
    <http://www.haskell.org/haskellwiki/GHC.Generics> for more information.
    Template Haskell code is provided for supporting older GHCs.

    This library is organized as follows:

    * "Generics.Deriving.Base" defines the core functionality for GHC generics,
    including the @Generic(1)@ classes and representation data types.
    On modern versions of GHC, this simply re-exports "GHC.Generics" from
    @base@. On older versions of GHC, this module backports parts of
    "GHC.Generics" that were not included at the time, including @Generic(1)@
    instances.

    * "Generics.Deriving.TH" implements Template Haskell functionality for
    deriving instances of @Generic(1)@.

    * Educational code: in order to provide examples of how to define and use
    "GHC.Generics"-based defaults, this library offers a number of modules
    which define examples of type classes along with default implementations
    for the classes'\'' methods. Currently, the following modules are provided:
    "Generics.Deriving.Copoint", "Generics.Deriving.ConNames",
    "Generics.Deriving.Enum", "Generics.Deriving.Eq",
    "Generics.Deriving.Foldable", "Generics.Deriving.Functor",
    "Generics.Deriving.Monoid", "Generics.Deriving.Semigroup",
    "Generics.Deriving.Show", "Generics.Deriving.Traversable",
    and "Generics.Deriving.Uniplate".

    It is worth emphasizing that these modules are primarly intended for
    educational purposes. Many of the classes in these modules resemble other
    commonly used classes—for example, @GShow@ from "Generics.Deriving.Show"
    resembles @Show@ from @base@—but in general, the classes that
    @generic-deriving@ defines are not drop-in replacements. Moreover, the
    generic defaults that @generic-deriving@ provide often make simplifying
    assumptions that may violate expectations of how these classes might work
    elsewhere. For example, the generic default for @GShow@ does not behave
    exactly like @deriving Show@ would.

    If you are seeking "GHC.Generics"-based defaults for type classes in
    @base@, consider using the
    @<http://hackage.haskell.org/package/generic-data generic-data>@ library.

    * "Generics.Deriving.Default" provides newtypes that allow leveraging the
    generic defaults in this library using the @DerivingVia@ GHC language
    extension.

    * "Generics.Deriving" re-exports "Generics.Deriving.Base",
    "Generics.Deriving.Default", and a selection of educational modules.

category:             Generics
abi:                  73585a1e6938a9b9c0fe943a11d35d3c
exposed:              True
exposed-modules:
    Generics.Deriving Generics.Deriving.Base Generics.Deriving.ConNames
    Generics.Deriving.Copoint Generics.Deriving.Default
    Generics.Deriving.Enum Generics.Deriving.Eq
    Generics.Deriving.Foldable Generics.Deriving.Functor
    Generics.Deriving.Instances Generics.Deriving.Monoid
    Generics.Deriving.Semigroup Generics.Deriving.Show
    Generics.Deriving.TH Generics.Deriving.Traversable
    Generics.Deriving.Uniplate

hidden-modules:
    Generics.Deriving.Base.Internal Generics.Deriving.Monoid.Internal
    Generics.Deriving.Semigroup.Internal Generics.Deriving.TH.Internal
    Paths_generic_deriving Generics.Deriving.TH.Post4_9

import-dirs:          /usr/lib/ghc-9.4.8/site-local/generic-deriving-1.14.5
library-dirs:         /usr/lib/ghc-9.4.8/site-local/generic-deriving-1.14.5
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/generic-deriving-1.14.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-generic-deriving
hs-libraries:         HSgeneric-deriving-1.14.5-BzjOO2EqgCN3e6szlgtKOc
depends:
    base-4.17.2.1 containers-0.6.7 ghc-prim-0.9.1
    template-haskell-2.19.0.0
    th-abstraction-0.5.0.0-BROQwjXmGCt8uLmQUfLqOy

haddock-interfaces:
    /usr/share/doc/haskell-generic-deriving/html/generic-deriving.haddock

haddock-html:         /usr/share/doc/haskell-generic-deriving/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

