#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 nonce
version:              1.0.7
visibility:           public
id:                   nonce-1.0.7-3DqdaYPMcqt8nRLfVZ11hp
key:                  nonce-1.0.7-3DqdaYPMcqt8nRLfVZ11hp
license:              BSD-3-Clause
copyright:            (c) 2014 Prowdsponsor
maintainer:           Prowdsponsor <opensource@prowdsponsor.com>
author:               Felipe Lessa <felipe.lessa@prowdsponsor.com>
homepage:             https://github.com/prowdsponsor/nonce
synopsis:             Generate cryptographic nonces.
description:
    According to the Wikipedia, a nonce is an arbitrary number used
    only once in a cryptographic communication.  This package
    contain helper functions for generating nonces.

    There are many kinds of nonces used in different situations.
    It'\''s not guaranteed that by using the nonces from this package
    you won'\''t have any security issues.  Please make sure that the
    nonces generated via this package are usable on your design.

category:             Cryptography
abi:                  6a9e97dd9e15c9b984f93b59704d8bad
exposed:              True
exposed-modules:      Crypto.Nonce
import-dirs:          /usr/lib/ghc-9.4.8/site-local/nonce-1.0.7
library-dirs:         /usr/lib/ghc-9.4.8/site-local/nonce-1.0.7
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/nonce-1.0.7
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-nonce
hs-libraries:         HSnonce-1.0.7-3DqdaYPMcqt8nRLfVZ11hp
depends:
    base-4.17.2.1 base64-bytestring-1.2.1.0-20QKryWonJ0FfyBIVqw9dX
    bytestring-0.11.5.3 entropy-0.4.1.11-KgGl1Y7Pn5mDV1IyWdAGFR
    text-2.0.2 transformers-0.5.6.2
    unliftio-0.2.25.1-1uYB5ruuxlB51GjsaBkLd
    unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT

haddock-interfaces:   /usr/share/doc/haskell-nonce/html/nonce.haddock
haddock-html:         /usr/share/doc/haskell-nonce/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

