#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 test-framework-th
version:              0.2.4
visibility:           public
id:                   test-framework-th-0.2.4-HbeoDZMOreFBDvAghg2nQo
key:                  test-framework-th-0.2.4-HbeoDZMOreFBDvAghg2nQo
license:              BSD-3-Clause
maintainer:           Oscar Finnsson
author:               Oscar Finnsson & Emil Nordling
homepage:             http://github.com/finnsson/test-generator
synopsis:
    Automagically generate the HUnit- and Quickcheck-bulk-code using Template Haskell.

description:
    @test-framework-th@ contains two interesting functions: @defaultMainGenerator@ and @testGroupGenerator@.

    @defaultMainGenerator@ will extract all functions beginning with case_, prop_ or test_in the module and put them in a testGroup.

    > -- file SomeModule.hs
    > ( -# LANGUAGE TemplateHaskell #- )
    > module SomeModule where
    > import Test.Framework.TH
    > import Test.Framework
    > import Test.HUnit
    > import Test.Framework.Providers.HUnit
    > import Test.Framework.Providers.QuickCheck2
    >
    > -- observe this line!
    > main = $(defaultMainGenerator)
    > case_1 = do 1 @=? 1
    > case_2 = do 2 @=? 2
    > prop_reverse xs = reverse (reverse xs) == xs
    >    where types = xs::[Int]

    is the same as

    > -- file SomeModule.hs
    > ( -# LANGUAGE TemplateHaskell #- )
    > module SomeModule where
    > import Test.Framework.TH
    > import Test.Framework
    > import Test.HUnit
    > import Test.Framework.Providers.HUnit
    > import Test.Framework.Providers.QuickCheck2
    >
    > -- observe this line!
    > main =
    >   defaultMain [
    >     testGroup "SomeModule" [ testCase "1" case_1, testCase "2" case_2, testProperty "reverse" prop_reverse]
    >     ]
    >
    > case_1 = do 1 @=? 1
    > case_2 = do 2 @=? 2
    > prop_reverse xs = reverse (reverse xs) == xs
    >    where types = xs::[Int]

    @testGroupGenerator@ is like @defaultMainGenerator@ but without @defaultMain@. It is useful if you need a function for the testgroup
    (e.g. if you want to be able to call the testgroup from another module).

category:             Testing
abi:                  a6048faa400857bc17e087b36910b1ca
exposed:              True
exposed-modules:      Test.Framework.TH
import-dirs:          /usr/lib/ghc-9.4.8/site-local/test-framework-th-0.2.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/test-framework-th-0.2.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/test-framework-th-0.2.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-test-framework-th
hs-libraries:         HStest-framework-th-0.2.4-HbeoDZMOreFBDvAghg2nQo
depends:
    base-4.17.2.1 haskell-src-exts-1.23.1-sTvcnsgz6K8l5Jfzk2ncg
    language-haskell-extract-0.2.4-4pLiEAYeVxNEmKT0OrqKlp
    regex-posix-0.96.0.2-AHNuIP1Pa8gKU2TxlSaYg9
    template-haskell-2.19.0.0
    test-framework-0.8.2.2-2IGhAKYu62k11ay8hr01RH

haddock-interfaces:
    /usr/share/doc/haskell-test-framework-th/html/test-framework-th.haddock

haddock-html:         /usr/share/doc/haskell-test-framework-th/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

