#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 trifecta
version:              2.1.4
visibility:           public
id:                   trifecta-2.1.4-ERO3RkhMwjU2FIBKFyRcen
key:                  trifecta-2.1.4-ERO3RkhMwjU2FIBKFyRcen
license:              BSD-3-Clause
copyright:            Copyright (C) 2010-2017 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            experimental
homepage:             http://github.com/ekmett/trifecta/
synopsis:
    A modern parser combinator library with convenient diagnostics

description:
    A modern parser combinator library with slicing and Clang-style colored diagnostics

    For example:

    <<https://i.imgur.com/ZyzUSSn.png>>

    <images/example.png (Local Copy)>

category:             Text, Parsing, Diagnostics, Pretty Printer, Logging
abi:                  e4bad91fa3741f989cdca3435a2629f3
exposed:              True
exposed-modules:
    Text.Trifecta Text.Trifecta.Combinators Text.Trifecta.Delta
    Text.Trifecta.Highlight Text.Trifecta.Parser
    Text.Trifecta.Rendering Text.Trifecta.Result Text.Trifecta.Rope
    Text.Trifecta.Tutorial Text.Trifecta.Util.IntervalMap
    Text.Trifecta.Util.It

hidden-modules:
    Text.Trifecta.Util.Combinators Text.Trifecta.Util.Pretty

import-dirs:          /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-trifecta
hs-libraries:         HStrifecta-2.1.4-ERO3RkhMwjU2FIBKFyRcen
depends:
    ansi-terminal-1.0.2-D46JaHr1BfPBLAK7nuv4I array-0.5.4.0
    base-4.17.2.1 blaze-builder-0.4.2.3-1WUo1omsOYUH2PSkelI6MS
    blaze-html-0.9.2.0-7rraM1lSLOl2LrVAS4qxq6
    blaze-markup-0.8.3.0-EXIdF6gaJs7HROOmQDdLmZ bytestring-0.11.5.3
    charset-0.3.12-Lh3Nd7nP3S6EyrvlwNLIrK
    comonad-5.0.9-HvdAojLAJo1IqDxZyKxIba containers-0.6.7
    deepseq-1.4.8.0 fingertree-0.1.5.0-7AymCggW5Ro3HnXV8O07GS
    ghc-prim-0.9.1 hashable-1.4.4.0-HA5jWeGkLE053htWZjUgjX
    indexed-traversable-0.1.4-6KK4zTGU8Qr6m89IZg6q2E
    lens-5.2.3-J1GK3I4tdtMEzlekK9vBY2 mtl-2.2.2
    parsers-0.12.12-DfRfqmZz0sv2HVy3TA2skx
    prettyprinter-1.7.1-2SyS45w2YIjHD6NDr8Zx1B
    prettyprinter-ansi-terminal-1.1.3-1dwjtSDumlJADFnP6ZWFZ
    profunctors-5.6.2-8zaE9IJQG71fFASFxR2Ae
    reducers-3.12.5-9MkVhTJ88u5KdhtO2lnSxR transformers-0.5.6.2
    unordered-containers-0.2.20-Jl6TkouWI2i1D1jczNV0uv
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm

haddock-interfaces:   /usr/share/doc/haskell-trifecta/html/trifecta.haddock
haddock-html:         /usr/share/doc/haskell-trifecta/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

