#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 vector-algorithms
version:              0.9.1.0
visibility:           public
id:                   vector-algorithms-0.9.1.0-EdgnkClX1Ys6U5PfpxYS3O
key:                  vector-algorithms-0.9.1.0-EdgnkClX1Ys6U5PfpxYS3O
license:              BSD-3-Clause
copyright:
    (c) 2008,2009,2010,2011,2012,2013,2014,2015 Dan Doel
    (c) 2015 Tim Baumann

maintainer:
    Dan Doel <dan.doel@gmail.com>
    Erik de Castro Lopo <erikd@mega-nerd.com>

author:               Dan Doel
homepage:             https://github.com/erikd/vector-algorithms/
synopsis:             Efficient algorithms for vector arrays
description:
    Efficient algorithms for sorting vector arrays. At some stage
    other vector algorithms may be added.

category:             Data
abi:                  d28a7a62d1062bc88cf33d7ef6579ea4
exposed:              True
exposed-modules:
    Data.Vector.Algorithms Data.Vector.Algorithms.AmericanFlag
    Data.Vector.Algorithms.Heap Data.Vector.Algorithms.Insertion
    Data.Vector.Algorithms.Intro Data.Vector.Algorithms.Merge
    Data.Vector.Algorithms.Optimal Data.Vector.Algorithms.Radix
    Data.Vector.Algorithms.Search Data.Vector.Algorithms.Tim

hidden-modules:       Data.Vector.Algorithms.Common
import-dirs:          /usr/lib/ghc-9.4.8/site-local/vector-algorithms-0.9.1.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/vector-algorithms-0.9.1.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/vector-algorithms-0.9.1.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-vector-algorithms
hs-libraries:         HSvector-algorithms-0.9.1.0-EdgnkClX1Ys6U5PfpxYS3O
include-dirs:
    /usr/lib/ghc-9.4.8/site-local/vector-algorithms-0.9.1.0/include

depends:
    base-4.17.2.1 bitvec-1.1.3.0-1fjLJjhOs33LNKWiVeHM5v
    bytestring-0.11.5.3 primitive-0.8.0.0-2MtTSGoMYmP3ESqdIhZDu7
    vector-0.13.2.0-F0gUvA5SUIr11j4RVHYOTP

haddock-interfaces:
    /usr/share/doc/haskell-vector-algorithms/html/vector-algorithms.haddock

haddock-html:         /usr/share/doc/haskell-vector-algorithms/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

