#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-iadd
version:              1.3.20
visibility:           public
id:                   hledger-iadd-1.3.20-1vFIErytj9h5O8kV5CnaHa
key:                  hledger-iadd-1.3.20-1vFIErytj9h5O8kV5CnaHa
license:              BSD-3-Clause
copyright:            2018 Hans-Peter Deifel
maintainer:           Hans-Peter Deifel <hpd@hpdeifel.de>
author:               Hans-Peter Deifel <hpd@hpdeifel.de>
homepage:             https://github.com/hpdeifel/hledger-iadd#readme
synopsis:             A terminal UI as drop-in replacement for hledger add
description:
    This is a terminal UI as drop-in replacement for hledger add.

    It improves in the following ways on hledger'\''s add command:

    * Interactive as-you-type completion for
    account names and descriptions with optional
    fuzzy matching.

    * Integrated calculator: Amounts can be written
    as simple sums with real-time feedback on the
    result.

    * All actions while entering a transaction can
    be undone

    * Configurable format for date input. Instead
    of @y\/m\/d@ it is also possible to use other
    formats like the german @d.m.y@.

category:             Finance, Console
abi:                  5bd59383718f8b50031d6f12aa723999
exposed:              True
exposed-modules:
    AmountParser Brick.Widgets.BetterDialog Brick.Widgets.Border.Utils
    Brick.Widgets.CommentDialog Brick.Widgets.Edit.EmacsBindings
    Brick.Widgets.HelpMessage Brick.Widgets.List.Utils
    Brick.Widgets.WrappedText ConfigParser Data.Time.Ext DateParser
    Model View

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-iadd-1.3.20
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-iadd-1.3.20
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-iadd-1.3.20
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-iadd
hs-libraries:         HShledger-iadd-1.3.20-1vFIErytj9h5O8kV5CnaHa
depends:
    base-4.17.2.1 brick-1.9-CNN2sELZNtXI4TehgY6Zdg containers-0.6.7
    directory-1.3.7.1 free-5.2-KarOKhXrR3rIZkP86MOfPz
    hledger-lib-1.32.1-8gyDtvGXhKT8ZrGneTIzYS
    megaparsec-9.6.1-747qApo3GKN165PbKLSk2e
    microlens-0.4.13.1-BCmTOusOWAwKF1xfvNhRYd
    microlens-mtl-0.2.0.3-vQELA1onhlLfPXHvjZtx7
    microlens-th-0.4.3.17-Vfga0HXPTS6SXD3NuXqZ3
    optparse-applicative-0.17.1.0-CKO7Hv5HIMoIThZFruc57S text-2.0.2
    text-zipper-0.13-39YjxT3ii7NKb2YqDu0nQy time-1.12.2
    transformers-0.5.6.2
    unordered-containers-0.2.20-Jl6TkouWI2i1D1jczNV0uv
    vector-0.13.2.0-F0gUvA5SUIr11j4RVHYOTP
    vty-5.39-ErB3NndBoLxBdN12m12j3q
    xdg-basedir-0.2.2-GUgbFy73ZJ02w1NqlBIm8a

haddock-interfaces:   /usr/share/doc/hledger-iadd/html/hledger-iadd.haddock
haddock-html:         /usr/share/doc/hledger-iadd/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

