/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Remove local minima not connected to the boundary of the image.


GrayscaleFillholeImageFilter fills holes in a grayscale image. Holes are local minima in the
grayscale topography that are not connected to boundaries of the
image. Gray level values adjacent to a hole are extrapolated across
the hole.

This filter is used to smooth over local minima without affecting the
values of local maxima. If you take the difference between the output
of this filter and the original image (and perhaps threshold the
difference above a small value), you'll obtain a map of the local
minima.

This filter uses the ReconstructionByErosionImageFilter . It provides its own input as the "mask" input to the geodesic
erosion. The "marker" image for the geodesic erosion is constructed
such that boundary pixels match the boundary pixels of the input image
and the interior pixels are set to the maximum pixel value in the
input image.

Geodesic morphology and the Fillhole algorithm is described in Chapter
6 of Pierre Soille's book "Morphological Image Analysis: Principles
and Applications", Second Edition, Springer, 2003.


See:
 ReconstructionByErosionImageFilter

 MorphologyImageFilter , GrayscaleErodeImageFilter , GrayscaleFunctionErodeImageFilter , BinaryErodeImageFilter

 itk::simple::GrayscaleFillhole for the procedural interface

 itk::GrayscaleFillholeImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkGrayscaleFillholeImageFilter.h
*/
public class GrayscaleFillholeImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected GrayscaleFillholeImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.GrayscaleFillholeImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(GrayscaleFillholeImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(GrayscaleFillholeImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::GrayscaleFillholeImageFilter::~GrayscaleFillholeImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_GrayscaleFillholeImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::GrayscaleFillholeImageFilter::GrayscaleFillholeImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  GrayscaleFillholeImageFilter() {
    this(SimpleITKJNI.new_GrayscaleFillholeImageFilter(), true);
  }

  /**
Self&amp; itk::simple::GrayscaleFillholeImageFilter::SetFullyConnected(bool FullyConnected)

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public  void setFullyConnected(boolean FullyConnected) {
    SimpleITKJNI.GrayscaleFillholeImageFilter_setFullyConnected(swigCPtr, this, FullyConnected);
  }

  /**
Self&amp; itk::simple::GrayscaleFillholeImageFilter::FullyConnectedOn()

Set the value of FullyConnected to true or false respectfully.

*/
public  void fullyConnectedOn() {
    SimpleITKJNI.GrayscaleFillholeImageFilter_fullyConnectedOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::GrayscaleFillholeImageFilter::FullyConnectedOff()
*/
public  void fullyConnectedOff() {
    SimpleITKJNI.GrayscaleFillholeImageFilter_fullyConnectedOff(swigCPtr, this);
  }

  /**
bool itk::simple::GrayscaleFillholeImageFilter::GetFullyConnected() const

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public  boolean getFullyConnected() {
    return SimpleITKJNI.GrayscaleFillholeImageFilter_getFullyConnected(swigCPtr, this);
  }

  /**
std::string itk::simple::GrayscaleFillholeImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.GrayscaleFillholeImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::GrayscaleFillholeImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.GrayscaleFillholeImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::GrayscaleFillholeImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.GrayscaleFillholeImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
