/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

A base class to handle SimpleITK and ITK messages and logging.


In ITK this function is implemented by the itk::OutputWindow, but in SimpleITK it is called a logger.

Provides a base class for SimpleITK to provide the "DisplayText"
methods that match the interface of itk::OutputWindow. Derived instances of LoggerBase are used by an internal adaptor derived from the itk::OutputWindow so that this object instances can be used in ITK.


See:
 itk::OutputWindow


C++ includes: sitkLogger.h
*/
public class LoggerBase extends ObjectOwnedBase {
  private transient long swigCPtr;

  protected LoggerBase(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.LoggerBase_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(LoggerBase obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(LoggerBase obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
itk::simple::LoggerBase::~LoggerBase() override
*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_LoggerBase(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
virtual void itk::simple::LoggerBase::DisplayText(const char *t)=0
*/
public  void displayText(String t) {
    SimpleITKJNI.LoggerBase_displayText(swigCPtr, this, t);
  }

  /**
virtual void itk::simple::LoggerBase::DisplayErrorText(const char *t)
*/
public  void displayErrorText(String t) {
    SimpleITKJNI.LoggerBase_displayErrorText(swigCPtr, this, t);
  }

  /**
virtual void itk::simple::LoggerBase::DisplayWarningText(const char *t)
*/
public  void displayWarningText(String t) {
    SimpleITKJNI.LoggerBase_displayWarningText(swigCPtr, this, t);
  }

  /**
virtual void itk::simple::LoggerBase::DisplayGenericOutputText(const char *t)
*/
public  void displayGenericOutputText(String t) {
    SimpleITKJNI.LoggerBase_displayGenericOutputText(swigCPtr, this, t);
  }

  /**
virtual void itk::simple::LoggerBase::DisplayDebugText(const char *t)
*/
public  void displayDebugText(String t) {
    SimpleITKJNI.LoggerBase_displayDebugText(swigCPtr, this, t);
  }

  /**
std::string itk::simple::LoggerBase::GetName() const override

Set object name.

*/
public  String getName() {
    return SimpleITKJNI.LoggerBase_getName(swigCPtr, this);
  }

  /**
void itk::simple::LoggerBase::SetName(const std::string &amp;n) override

Get object name.

*/
public  void setName(String n) {
    SimpleITKJNI.LoggerBase_setName(swigCPtr, this, n);
  }

  /**
virtual ITKLogger itk::simple::LoggerBase::SetAsGlobalITKLogger()

Set this logger instance to the ITK output window.

After calling this method, all ITK and SimpleITK display, warning and
error texts will be handled by this object's methods.


An ITKLogger object holding the previous itk::OutputWindow instance. The returned object can be used to restore the original
instance.


*/
public  ITKLogger setAsGlobalITKLogger() {
    return new ITKLogger(SimpleITKJNI.LoggerBase_setAsGlobalITKLogger(swigCPtr, this), true);
  }

  public static ITKLogger getGlobalITKLogger() {
    return new ITKLogger(SimpleITKJNI.LoggerBase_getGlobalITKLogger(), true);
  }

}
