/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

This filter finds the closest pixel to the zero-crossings (sign
changes) in a signed itk::Image .


Pixels closest to zero-crossings are labeled with a foreground value.
All other pixels are marked with a background value. The algorithm
works by detecting differences in sign among neighbors using city-
block style connectivity (4-neighbors in 2d, 6-neighbors in 3d, etc.).

Inputs and Outputs
The input to this filter is an itk::Image of arbitrary dimension. The algorithm assumes a signed data type
(zero-crossings are not defined for unsigned int data types), and
requires that operator&gt;, operator&lt;, operator==, and operator!=
are defined.

The output of the filter is a binary, labeled image of user-specified
type. By default, zero-crossing pixels are labeled with a default
"foreground" value of itk::NumericTraits&lt;OutputDataType&gt;::OneValue() , where OutputDataType is the data type of the output image. All
other pixels are labeled with a default "background" value of
OutputDataType{}.
Parameters
There are two parameters for this filter. ForegroundValue is the value
that marks zero-crossing pixels. The BackgroundValue is the value
given to all other pixels.

See:
 Image

 Neighborhood

 NeighborhoodOperator

 NeighborhoodIterator

 itk::simple::ZeroCrossing for the procedural interface

 itk::ZeroCrossingImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkZeroCrossingImageFilter.h
*/
public class ZeroCrossingImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected ZeroCrossingImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.ZeroCrossingImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(ZeroCrossingImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(ZeroCrossingImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::ZeroCrossingImageFilter::~ZeroCrossingImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_ZeroCrossingImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::ZeroCrossingImageFilter::ZeroCrossingImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  ZeroCrossingImageFilter() {
    this(SimpleITKJNI.new_ZeroCrossingImageFilter(), true);
  }

  /**
Self&amp; itk::simple::ZeroCrossingImageFilter::SetForegroundValue(uint8_t ForegroundValue)

Set/Get the label value for zero-crossing pixels.

*/
public  void setForegroundValue(short ForegroundValue) {
    SimpleITKJNI.ZeroCrossingImageFilter_setForegroundValue(swigCPtr, this, ForegroundValue);
  }

  /**
uint8_t itk::simple::ZeroCrossingImageFilter::GetForegroundValue() const

Set/Get the label value for zero-crossing pixels.

*/
public  short getForegroundValue() {
    return SimpleITKJNI.ZeroCrossingImageFilter_getForegroundValue(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ZeroCrossingImageFilter::SetBackgroundValue(uint8_t BackgroundValue)

Set/Get the label value for non-zero-crossing pixels.

*/
public  void setBackgroundValue(short BackgroundValue) {
    SimpleITKJNI.ZeroCrossingImageFilter_setBackgroundValue(swigCPtr, this, BackgroundValue);
  }

  /**
uint8_t itk::simple::ZeroCrossingImageFilter::GetBackgroundValue() const

Set/Get the label value for non-zero-crossing pixels.

*/
public  short getBackgroundValue() {
    return SimpleITKJNI.ZeroCrossingImageFilter_getBackgroundValue(swigCPtr, this);
  }

  /**
std::string itk::simple::ZeroCrossingImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.ZeroCrossingImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::ZeroCrossingImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.ZeroCrossingImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::ZeroCrossingImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.ZeroCrossingImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
