/*
 * Decompiled with CFR 0.152.
 */
package jspecview.source;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import javajs.util.Base64;
import javajs.util.PT;
import jspecview.source.JDXSource;
import jspecview.source.XMLReader;
import org.jmol.util.Elements;

public class NMRMLReader
extends XMLReader {
    private String structure;
    private String assignment;
    private int dim = 1;

    @Override
    protected JDXSource getXML(BufferedReader bufferedReader) {
        block5: {
            this.source = new JDXSource(0, this.filePath);
            this.getSimpleXmlReader(bufferedReader);
            this.parser.nextEvent();
            this.processXML(13, 33);
            if (this.checkPointCount()) break block5;
            return null;
        }
        try {
            this.xFactor = 1.0;
            this.yFactor = 1.0;
            this.populateVariables();
        }
        catch (Exception exception) {
            System.err.println("That file may be empty...");
            this.errorLog.append("That file may be empty... \n");
        }
        this.processErrors("nmrML");
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.source;
    }

    @Override
    protected boolean processTag(int n) throws Exception {
        System.out.println(tagNames[n]);
        switch (n) {
            case 13: {
                this.obNucleus = Elements.getNmrNucleusFromName((String)this.parser.getAttrValueLC("name"));
                return true;
            }
            case 14: {
                this.strObFreq = this.parser.getAttrValueLC("value");
                this.obFreq = Double.parseDouble(this.strObFreq);
                return true;
            }
            case 15: {
                this.dim = 1;
                break;
            }
            case 32: {
                String string = this.parser.getAttrValue("byteFormat");
                if (!"complex128".equals(string)) break;
                this.getXYFromBase64Complex128(this.parser.getCharacters());
                break;
            }
            case 18: {
                this.title = this.parser.getAttrValue("name");
                break;
            }
            case 20: {
                this.structure = NMRMLReader.toCML(this.parser.getInnerXML());
                break;
            }
            case 25: {
                this.assignment = this.parser.getOuterXML();
                break;
            }
        }
        return false;
    }

    private static String toCML(String string) {
        string = PT.rep(string, "x=", "x3=");
        string = PT.rep(string, "y=", "y3=");
        string = PT.rep(string, "z=", "z3=");
        string = PT.rep(string, "atomList", "atomArray");
        string = PT.rep(string, "bondList", "bondArray");
        string = PT.rep(string, "atomRefs", "atomRefs2");
        string = PT.rep(string, ">\"", ">");
        string = "<cml>\n<molecule>\n" + string + "\n</molecule>\n</cml>";
        return string;
    }

    @Override
    protected void processEndTag(int n) throws Exception {
    }

    private void getXYFromBase64Complex128(String string) {
        byte[] byArray = Base64.decodeBase64(string);
        DoubleBuffer doubleBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).asDoubleBuffer();
        if (byArray.length % 16 != 0) {
            throw new RuntimeException("NMRMLReader byte length not multiple of 16 " + byArray.length);
        }
        try {
            int n = byArray.length / 16;
            this.xaxisData = new double[n];
            this.yaxisData = new double[n];
            int n2 = 0;
            while (n2 < n) {
                this.xaxisData[n - n2 - 1] = doubleBuffer.get();
                this.yaxisData[n - n2 - 1] = doubleBuffer.get();
                ++n2;
            }
            this.npoints = n;
            this.firstX = this.xaxisData[0];
            this.deltaX = this.xaxisData[1] - this.firstX;
            this.increasing = false;
            this.continuous = true;
            this.lastX = this.xaxisData[this.npoints - 1];
            this.yUnits = "";
            this.firstY = this.yaxisData[0];
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

