/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin.permissions;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.keycloak.authorization.AdminPermissionsSchema;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.ResourceWrapper;
import org.keycloak.authorization.permission.ResourcePermission;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.idm.authorization.Permission;
import org.keycloak.services.resources.admin.permissions.ClientPermissions;
import org.keycloak.services.resources.admin.permissions.MgmtPermissionsV2;

class ClientPermissionsV2
extends ClientPermissions {
    ClientPermissionsV2(KeycloakSession session, RealmModel realm, AuthorizationProvider authz, MgmtPermissionsV2 root) {
        super(session, realm, authz, root);
    }

    @Override
    public boolean canList() {
        return this.root.hasOneAdminRole(AdminRoles.QUERY_CLIENTS) || this.canView();
    }

    @Override
    public void requireConfigure(ClientModel client) {
        super.requireManage(client);
    }

    @Override
    public boolean canConfigure(ClientModel client) {
        return this.canManage(client);
    }

    @Override
    public boolean canManage(ClientModel client) {
        if (this.root.hasOneAdminRole(AdminRoles.MANAGE_CLIENTS)) {
            return true;
        }
        return this.hasPermission(client, "manage");
    }

    @Override
    public boolean canManage() {
        if (this.root.hasOneAdminRole(AdminRoles.MANAGE_CLIENTS)) {
            return true;
        }
        return this.hasPermission("manage");
    }

    @Override
    public boolean canView(ClientModel client) {
        if (this.root.hasOneAdminRole(AdminRoles.MANAGE_CLIENTS, AdminRoles.VIEW_CLIENTS)) {
            return true;
        }
        return this.hasPermission(client, "view");
    }

    @Override
    public boolean canView() {
        if (this.root.hasOneAdminRole(AdminRoles.MANAGE_CLIENTS, AdminRoles.VIEW_CLIENTS)) {
            return true;
        }
        return this.hasPermission("view");
    }

    @Override
    public boolean canMapRoles(ClientModel client) {
        return this.hasPermission(client, "map-roles");
    }

    @Override
    public boolean canMapCompositeRoles(ClientModel client) {
        return this.hasPermission(client, "map-roles-composite");
    }

    @Override
    public boolean canMapClientScopeRoles(ClientModel client) {
        return this.hasPermission(client, "map-roles-client-scope");
    }

    @Override
    public boolean canManageClientScopes() {
        if (this.root.hasOneAdminRole(AdminRoles.MANAGE_CLIENTS)) {
            return true;
        }
        return this.hasPermission("manage");
    }

    @Override
    public boolean canManage(ClientScopeModel clientScope) {
        return this.canManageClientScopes();
    }

    @Override
    public boolean canView(ClientScopeModel clientScope) {
        if (this.root.hasOneAdminRole(AdminRoles.VIEW_CLIENTS, AdminRoles.MANAGE_CLIENTS)) {
            return true;
        }
        return this.hasPermission("view");
    }

    @Override
    public Set<String> getClientIdsByScope(String scope) {
        if (!this.root.isAdminSameRealm()) {
            return Collections.emptySet();
        }
        ResourceServer server = this.root.realmResourceServer();
        if (server == null) {
            return Collections.emptySet();
        }
        HashSet<String> granted = new HashSet<String>();
        this.policyStore.findByResourceType(server, "Clients").stream().flatMap(policy -> policy.getResources().stream()).forEach(resource -> {
            if (this.hasGrantedPermission((Resource)resource, scope)) {
                granted.add(resource.getName());
            }
        });
        return granted;
    }

    @Override
    public boolean canExchangeTo(ClientModel authorizedClient, ClientModel to, AccessToken token) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Policy exchangeToPermission(ClientModel client) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Policy mapRolesPermission(ClientModel client) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Policy mapRolesClientScopePermission(ClientModel client) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Policy mapRolesCompositePermission(ClientModel client) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Policy managePermission(ClientModel client) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Policy configurePermission(ClientModel client) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Policy viewPermission(ClientModel client) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public boolean isPermissionsEnabled(ClientModel client) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public void setPermissionsEnabled(ClientModel client, boolean enable) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Resource resource(ClientModel client) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Map<String, String> getPermissions(ClientModel client) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    private boolean hasPermission(String scope) {
        return this.hasPermission(null, scope);
    }

    private boolean hasPermission(ClientModel client, String scope) {
        Resource resource;
        if (!this.root.isAdminSameRealm()) {
            return false;
        }
        ResourceServer server = this.root.realmResourceServer();
        if (server == null) {
            return false;
        }
        String resourceType = "Clients";
        Resource resourceTypeResource = AdminPermissionsSchema.SCHEMA.getResourceTypeResource(this.session, server, resourceType);
        Resource resource2 = resource = client == null ? resourceTypeResource : this.resourceStore.findByName(server, client.getId());
        if (client != null && resource == null) {
            resource = new ResourceWrapper(client.getId(), client.getId(), new HashSet(resourceTypeResource.getScopes()), server);
        }
        Collection<Permission> permissions = this.root.evaluatePermission(new ResourcePermission(resourceType, resource, (Collection)resource.getScopes(), server), server);
        for (Permission permission : permissions) {
            if (!permission.getResourceId().equals(resource.getId()) || !permission.getScopes().contains(scope)) continue;
            return true;
        }
        return false;
    }

    private boolean hasGrantedPermission(Resource resource, String scope) {
        ResourceServer server = this.root.realmResourceServer();
        Collection<Permission> permissions = this.root.evaluatePermission(new ResourcePermission(resource, (Collection)resource.getScopes(), server), server);
        for (Permission permission : permissions) {
            if (!permission.getResourceId().equals(resource.getId())) continue;
            for (String s : permission.getScopes()) {
                if (!scope.equals(s)) continue;
                return true;
            }
        }
        return false;
    }
}

