/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.storage.infinispan.jgroups.impl;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.TrustManager;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.jgroups.util.DefaultSocketFactory;
import org.jgroups.util.SocketFactory;
import org.keycloak.common.util.Retry;
import org.keycloak.config.CachingOptions;
import org.keycloak.config.Option;
import org.keycloak.infinispan.module.certificates.CertificateReloadManager;
import org.keycloak.infinispan.module.certificates.JGroupsCertificate;
import org.keycloak.infinispan.module.certificates.JGroupsCertificateHolder;
import org.keycloak.infinispan.module.configuration.global.KeycloakConfigurationBuilder;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.quarkus.runtime.storage.infinispan.CacheManagerFactory;
import org.keycloak.quarkus.runtime.storage.infinispan.jgroups.impl.BaseJGroupsTlsConfigurator;
import org.keycloak.storage.configuration.ServerConfigStorageProvider;

public class JpaJGroupsTlsConfigurator
extends BaseJGroupsTlsConfigurator {
    private static final String TLS_PROTOCOL_VERSION = "TLSv1.3";
    private static final String TLS_PROTOCOL = "TLS";
    private static final int STARTUP_RETRIES = 5;
    private static final int STARTUP_RETRY_SLEEP_MILLIS = 500;
    public static final JpaJGroupsTlsConfigurator INSTANCE = new JpaJGroupsTlsConfigurator();

    @Override
    public boolean requiresKeycloakSession() {
        return true;
    }

    @Override
    SocketFactory createSocketFactory(ConfigurationBuilderHolder holder, KeycloakSession session) {
        KeycloakSessionFactory factory = session.getKeycloakSessionFactory();
        KeycloakConfigurationBuilder kcConfig = (KeycloakConfigurationBuilder)holder.getGlobalConfigurationBuilder().addModule(KeycloakConfigurationBuilder.class);
        JGroupsCertificateHolder crtHolder = JpaJGroupsTlsConfigurator.loadInitialCertificateWithRetry(factory);
        kcConfig.setJGroupsCertificateRotation(CacheManagerFactory.requiredIntegerProperty((Option<Integer>)CachingOptions.CACHE_EMBEDDED_MTLS_ROTATION));
        kcConfig.setKeycloakSessionFactory(factory);
        kcConfig.setJGroupCertificateHolder(crtHolder);
        try {
            SSLContext sslContext = SSLContext.getInstance(TLS_PROTOCOL);
            sslContext.init(new KeyManager[]{crtHolder.keyManager()}, new TrustManager[]{crtHolder.trustManager()}, null);
            return JpaJGroupsTlsConfigurator.createFromContext(sslContext);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static JGroupsCertificateHolder loadInitialCertificateWithRetry(KeycloakSessionFactory factory) {
        return (JGroupsCertificateHolder)Retry.call(iteration -> (JGroupsCertificateHolder)KeycloakModelUtils.runJobInTransactionWithResult((KeycloakSessionFactory)factory, JpaJGroupsTlsConfigurator::createOrLoadCertificate), (int)5, (long)500L);
    }

    private static JGroupsCertificateHolder createOrLoadCertificate(KeycloakSession session) {
        try {
            int rotationDays = CacheManagerFactory.requiredIntegerProperty((Option<Integer>)CachingOptions.CACHE_EMBEDDED_MTLS_ROTATION);
            ServerConfigStorageProvider storage = (ServerConfigStorageProvider)session.getProvider(ServerConfigStorageProvider.class);
            JGroupsCertificate data = JGroupsCertificate.fromJson((String)storage.loadOrCreate("crt_jgroups", () -> CertificateReloadManager.generateSelfSignedCertificate((long)(TimeUnit.DAYS.toSeconds(rotationDays) * 2L))));
            return JGroupsCertificateHolder.create((JGroupsCertificate)data);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private static SocketFactory createFromContext(SSLContext context) {
        DefaultSocketFactory socketFactory = new DefaultSocketFactory(context);
        SSLParameters serverParameters = new SSLParameters();
        serverParameters.setProtocols(new String[]{TLS_PROTOCOL_VERSION});
        serverParameters.setNeedClientAuth(true);
        socketFactory.setServerSocketConfigurator(socket -> ((SSLServerSocket)socket).setSSLParameters(serverParameters));
        return socketFactory;
    }
}

