/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap.mappers;

import org.keycloak.component.ComponentModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.idm.model.LDAPObject;
import org.keycloak.storage.ldap.idm.query.internal.LDAPQuery;
import org.keycloak.storage.ldap.mappers.AbstractLDAPStorageMapper;

public class KerberosPrincipalAttributeMapper
extends AbstractLDAPStorageMapper {
    public KerberosPrincipalAttributeMapper(ComponentModel mapperModel, LDAPStorageProvider ldapProvider) {
        super(mapperModel, ldapProvider);
    }

    @Override
    public void onImportUserFromLDAP(LDAPObject ldapUser, UserModel user, RealmModel realm, boolean isCreate) {
        String kerberosPrincipalAttribute = this.ldapProvider.getKerberosConfig().getKerberosPrincipalAttribute();
        if (kerberosPrincipalAttribute != null) {
            String localKerberosPrincipal = user.getFirstAttribute("KERBEROS_PRINCIPAL");
            String ldapKerberosPrincipal = ldapUser.getAttributeAsString(kerberosPrincipalAttribute);
            if (ldapKerberosPrincipal != null && localKerberosPrincipal != null && !ldapKerberosPrincipal.equals(localKerberosPrincipal)) {
                user.setSingleAttribute("KERBEROS_PRINCIPAL", ldapKerberosPrincipal);
            }
        }
    }

    @Override
    public void onRegisterUserToLDAP(LDAPObject ldapUser, UserModel localUser, RealmModel realm) {
    }

    @Override
    public UserModel proxy(LDAPObject ldapUser, UserModel delegate, RealmModel realm) {
        return delegate;
    }

    @Override
    public void beforeLDAPQuery(LDAPQuery query) {
    }
}

