/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import org.languagetool.JLanguageTool;
import org.languagetool.TestTools;
import org.languagetool.rules.PunctuationMarkAtParagraphEnd;
import org.languagetool.rules.Rule;

public class PunctuationMarkAtParagraphEndTest {
    @Test
    public void testRule() throws IOException {
        JLanguageTool lt = new JLanguageTool(TestTools.getDemoLanguage());
        this.setUpRule(lt);
        Assert.assertEquals((long)0L, (long)lt.check("A paragraph.\n2. Some headline\n\n(a) A new sentence.").size());
        Assert.assertEquals((long)0L, (long)lt.check("A paragraph.\n\n2. Some headline\n\n(a) A new sentence.").size());
        Assert.assertEquals((long)0L, (long)lt.check("A paragraph.\n2.2.1 Some headline\n\n(a) A new sentence.").size());
        Assert.assertEquals((long)0L, (long)lt.check("A paragraph.\n\n2.2.1 Some headline\n\n(a) A new sentence.").size());
        Assert.assertEquals((long)0L, (long)lt.check("2. This is an item in a list").size());
        Assert.assertEquals((long)0L, (long)lt.check("2.2.2. This is an item in a list").size());
        Assert.assertEquals((long)0L, (long)lt.check("a) This is an item in a list").size());
        Assert.assertEquals((long)0L, (long)lt.check("a.) This is an item in a list").size());
        Assert.assertEquals((long)0L, (long)lt.check("\u2713 This is an item in a list").size());
        Assert.assertEquals((long)0L, (long)lt.check("* This is an item in a list").size());
        Assert.assertEquals((long)0L, (long)lt.check("This is a test sentence.").size());
        Assert.assertEquals((long)0L, (long)lt.check("This is a test headline").size());
        Assert.assertEquals((long)0L, (long)lt.check("This is a test sentence. This is a link: http://example.com").size());
        Assert.assertEquals((long)1L, (long)lt.check("This is a test sentence. It can be found at http://example.com/foobar").size());
        Assert.assertEquals((long)1L, (long)lt.check("This is a test sentence. And this is a second test sentence").size());
        Assert.assertEquals((long)1L, (long)lt.check("\"This is a test sentence. And this is a second test sentence").size());
        Assert.assertEquals((long)0L, (long)lt.check("This is a test sentence. And this is a second test sentence.").size());
        Assert.assertEquals((long)0L, (long)lt.check("B. v. \u2013 Beschluss vom").size());
        Assert.assertEquals((long)1L, (long)lt.check("This is a test sentence.\nAnd this is a second test sentence. Here is a dot missing").size());
        Assert.assertEquals((long)0L, (long)lt.check("This is a test sentence.\nAnd this is a second test sentence. Here is a dot missing.").size());
        Assert.assertEquals((long)0L, (long)lt.check("This is a sentence. Another one: https://languagetool.org/foo\n\nAnother sentence\n").size());
    }

    private void setUpRule(JLanguageTool lt) {
        for (Rule rule : lt.getAllRules()) {
            lt.disableRule(rule.getId());
        }
        PunctuationMarkAtParagraphEnd rule = new PunctuationMarkAtParagraphEnd(TestTools.getEnglishMessages(), TestTools.getDemoLanguage());
        rule.setTags(Collections.emptyList());
        lt.addRule((Rule)rule);
    }
}

