/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class EndianConverter {
    public static byte[] writeShort(short s) {
        return ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN).putShort(s).array();
    }

    public static byte[] writeInt(int n) {
        return ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(n).array();
    }

    public static byte[] writeDouble(double d) {
        return ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(Double.doubleToLongBits(d)).array();
    }

    public static short readShort(byte[] byArray) {
        return ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN).put(byArray).getShort(0);
    }

    public static int readInt(byte[] byArray) {
        return ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).put(byArray).getInt(0);
    }

    public static double readDouble(byte[] byArray) {
        return Double.longBitsToDouble(ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).put(byArray).getLong(0));
    }
}

