/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.io;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.impl.rbp.Peer;
import ca.odell.glazedlists.impl.rbp.ResourceStatus;
import ca.odell.glazedlists.io.ByteCoder;
import ca.odell.glazedlists.io.NetworkList;
import java.io.IOException;

public class ListPeer {
    private Peer peer;

    public ListPeer(int listenPort) {
        this.peer = new Peer(listenPort);
    }

    public void start() throws IOException {
        this.peer.start();
    }

    public void stop() {
        this.peer.stop();
    }

    void print() {
        this.peer.print();
    }

    public <E> NetworkList<E> publish(EventList<E> source2, String path, ByteCoder byteCoder) {
        NetworkList<E> published = new NetworkList<E>(source2, byteCoder);
        ResourceStatus resourceStatus = this.peer.publish(published.getResource(), path);
        published.setResourceStatus(resourceStatus);
        published.setWritable(true);
        return published;
    }

    public NetworkList subscribe(String host, int port, String path, ByteCoder byteCoder) {
        NetworkList subscribed = new NetworkList(new BasicEventList(), byteCoder);
        ResourceStatus resourceStatus = this.peer.subscribe(subscribed.getResource(), host, port, path);
        subscribed.setResourceStatus(resourceStatus);
        return subscribed;
    }
}

