
# Device configuration file

## Target version:

v2.1.0

## Terminology

__AM__ - SHARP aggregation manager
__AN__ - SHARP aggregation node

## Overview

Device configuration file feature enables changing AN configuration by the AM.
Device configuration are loaded to the AM from configuration files specified by *device_configuration_file* parameter.

## Configuration file format

Configuration file consists of configuration tables block.
Each tables block starts with START_*[table name]* key word followed by comma table, and ends with START_*[table name]* keyword.

For example:

> START_AN_PORT_RESOURCES  
NodeGUID,           PortNum, ResponderBufferCap, ResponderPackets, NumFlows  
0x001,              2,       10               10             2  
0x002,              2,       10               10             1  
END_AN_PORT_RESOURCES  


## AN port resources table

AN port resources table allows configuring credits and number of streaming aggregation flows for AN port.

### Supported fields
- NodeGUID - Node GUID of the Aggregation Node (not the switch)
- PortNum  - Port number on the switch of the Aggregation node of the specified GUID
- RequesterPackets - Number of packets in to the AN (do not use for Quantum)
- RequesterBufferCap - Buffer size in AN port (do not use for Quantum).
- ResponderPackets - Number of packets from the AN.
- ResponderBufferCap - Buffer size in AN port.
- NumFlows - Number of flows allowed for the port (must be the same for all records of same AN)

### Special values
- NodeGUID set to 0, means that the configuration in this line will be default configuration for all the ANs that are not specified in this table.
- PortNum set to 255, means that the configuration in this line will be the default for all ports of the AN specified in this line.


Notes:
1. Not supported for Switch-IB2 devices.
2. Quantum switches does not support different number of flows for different ports.
3. All values should be configured according device capabilities.


### Example
The following table will result with the following configuration

>START_AN_PORT_RESOURCES  
NodeGUID,	PortNum,	ResponderBufferCap,	ResponderPackets,	NumFlows  
0x0000,		0,		1,			1,			1  
0x0001,		255,		2,			2,			1  
0x0001,		3,		3,			3,			1  
END_AN_PORT_RESOURCES  

Default configuration:
- ResponderBufferCap = 1
- ResponderPackets = 1
- NumFlows = 1

Default for all ports of AN with Node GUID 0x0001
- ResponderBufferCap = 2
- ResponderPackets = 2
- NumFlows = 1

Port 3 of AN with Node GUID 0x0001
- ResponderBufferCap = 3
- ResponderPackets = 3
- NumFlows = 1

