/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.fetch.subphase.highlight;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.search.highlight.DefaultEncoder;
import org.apache.lucene.search.highlight.Encoder;
import org.apache.lucene.search.highlight.SimpleHTMLEncoder;
import org.opensearch.index.fieldvisitor.CustomFieldsVisitor;
import org.opensearch.index.mapper.DerivedFieldValueFetcher;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.ValueFetcher;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.search.fetch.FetchSubPhase;

public final class HighlightUtils {
    public static final char PARAGRAPH_SEPARATOR = '\u2029';
    public static final char NULL_SEPARATOR = '\u0000';

    private HighlightUtils() {
    }

    public static List<Object> loadFieldValues(MappedFieldType fieldType, QueryShardContext context, FetchSubPhase.HitContext hitContext, boolean forceSource) throws IOException {
        if (!forceSource && fieldType.isStored()) {
            CustomFieldsVisitor fieldVisitor = new CustomFieldsVisitor(Collections.singleton(fieldType.name()), false);
            hitContext.reader().storedFields().document(hitContext.docId(), (StoredFieldVisitor)fieldVisitor);
            List<Object> textsToHighlight = fieldVisitor.fields().get(fieldType.name());
            return textsToHighlight != null ? textsToHighlight : Collections.emptyList();
        }
        ValueFetcher fetcher = fieldType.valueFetcher(context, null, null);
        if (fetcher instanceof DerivedFieldValueFetcher) {
            fetcher.setNextReader(hitContext.reader().getContext());
        }
        return fetcher.fetchValues(hitContext.sourceLookup());
    }

    public static class Encoders {
        public static final Encoder DEFAULT = new DefaultEncoder();
        public static final Encoder HTML = new SimpleHTMLEncoder();
    }
}

